/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DashFont {
    private Image m_img;
    private String m_format;
    private int m_charWidth;
    private int m_charHeight;
    private boolean m_isSystemFont = false;
    private Font m_systemFont = null;
    private int m_sysFontColor = 0xFFFFFF;
    public static int FORCE_CASE_NONE = 0;
    public static int FORCE_CASE_UPPER = 1;
    public static int FORCE_CASE_LOWER = 2;
    private int m_forceCase = FORCE_CASE_NONE;

    public void forceCase(int n) {
        this.m_forceCase = n;
    }

    public DashFont(String string, String string2) {
        this.init(string, string2);
    }

    public DashFont(String string) {
        this.init(string, "");
    }

    public DashFont(Font font) {
        this.m_isSystemFont = true;
        this.m_systemFont = font;
    }

    private void init(String string, String string2) {
        this.m_format = string2;
        if (this.m_format == null) {
            System.out.println("format string not found for DashFont " + this.m_img);
            throw new Error("null formatted font, fileid " + string);
        }
        Image image = null;
        try {
            image = Image.createImage((String)string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (image == null) {
            System.out.println("error allocating DashFont " + string);
            return;
        }
        this.m_img = image;
        this.m_charWidth = image.getWidth() / this.m_format.length();
        this.m_charHeight = image.getHeight();
        this.m_forceCase = FORCE_CASE_UPPER;
    }

    public void setColor(int n) {
        this.m_sysFontColor = n;
    }

    public int getIndex(char c) {
        return this.m_format.indexOf(c);
    }

    public boolean isValidChar(char c) {
        return this.getIndex(c) != -1;
    }

    public void drawString(Graphics graphics, String string, int n, int n2, int n3) {
        if (this.m_isSystemFont) {
            graphics.setFont(this.m_systemFont);
            int n4 = graphics.getColor();
            graphics.setColor(this.m_sysFontColor);
            graphics.drawString(string, n, n2, n3);
            graphics.setColor(n4);
        } else {
            int n5 = graphics.getClipX();
            int n6 = graphics.getClipY();
            int n7 = graphics.getClipWidth();
            int n8 = graphics.getClipHeight();
            Image image = this.m_img;
            if (image == null) {
                System.out.println("cannot draw font " + this.m_img + ", img allocation error.  trying to draw string " + string);
                graphics.drawString(string, n, n2, n3);
                return;
            }
            if ((n3 & 1) != 0) {
                n -= string.length() * this.m_charWidth / 2;
            } else if ((n3 & 8) != 0) {
                n -= string.length() * this.m_charWidth;
            }
            if ((n3 & 2) != 0) {
                n2 -= this.m_charHeight / 2;
            } else if ((n3 & 0x20) != 0) {
                n2 -= this.m_charHeight;
            }
            if (this.m_forceCase != FORCE_CASE_NONE) {
                if (this.m_forceCase == FORCE_CASE_UPPER) {
                    string = string.toUpperCase();
                }
                if (this.m_forceCase == FORCE_CASE_LOWER) {
                    string = string.toLowerCase();
                }
            }
            for (int i = 0; i < string.length(); ++i) {
                int n9 = this.m_format.indexOf(string.charAt(i));
                if (n9 == -1) continue;
                graphics.clipRect(n + i * this.m_charWidth, n2, this.m_charWidth, this.m_charHeight);
                graphics.drawImage(image, n + i * this.m_charWidth - n9 * this.m_charWidth, n2, 20);
                graphics.setClip(n5, n6, n7, n8);
            }
        }
    }

    protected void drawString_faster(Graphics graphics, String string, int n, int n2) {
        if (this.m_isSystemFont) {
            graphics.setFont(this.m_systemFont);
            int n3 = graphics.getColor();
            graphics.setColor(this.m_sysFontColor);
            graphics.drawString(string, n, n2, 20);
            graphics.setColor(n3);
        } else {
            Image image = this.m_img;
            for (int i = 0; i < string.length(); ++i) {
                int n4 = this.m_format.indexOf(string.charAt(i));
                if (n4 == -1) continue;
                int n5 = n + i * this.m_charWidth;
                graphics.setClip(n5, n2, this.m_charWidth, this.m_charHeight);
                graphics.drawImage(image, -(n4 * this.m_charWidth) + n5, n2, 20);
            }
        }
    }

    public int stringWidth(String string) {
        if (this.m_isSystemFont) {
            return this.m_systemFont.stringWidth(string);
        }
        return string.length() * this.m_charWidth;
    }

    public int getHeight() {
        if (this.m_isSystemFont) {
            return this.m_systemFont.getHeight();
        }
        return this.m_charHeight;
    }

    public int getWidth() {
        if (this.m_isSystemFont) {
            return this.m_systemFont.charWidth('W');
        }
        return this.m_charWidth;
    }

    public String[] wrap(String string, int n) {
        String[] stringArray = WordWrap.WrapString(n, string, this);
        if (this.m_forceCase != FORCE_CASE_NONE) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.m_forceCase == FORCE_CASE_UPPER) {
                    stringArray[i] = stringArray[i].toUpperCase();
                }
                if (this.m_forceCase != FORCE_CASE_LOWER) continue;
                stringArray[i] = stringArray[i].toLowerCase();
            }
        }
        return stringArray;
    }
}

