/*
 * Decompiled with CFR 0.152.
 */
final class GameObject
implements Objects,
EnemyConfig,
EmitterConfig {
    static final int FLAG_None = 0;
    static final int FLAG_Disabled = 1;
    static final int FLAG_Dead = 2;
    static final int FLAG_NotInteractive = 4;
    static final int FLAG_Obstacle = 8;
    static final int FLAG_EnemyTurned = 16;
    static final int FLAG_EnemyPushed = 32;
    static final int FLAG_EnemyFalling = 64;
    static final int FLAG_EnemySurvival = 128;
    static final int FLAG_BoundByCamera = 256;
    static final int FLAG_IgnoreDamage = 512;
    static final int FLAG_RenderLast = 1024;
    static final int FLAG_UpdateFirst = 2048;
    static final int FLAG_MovingObstacle = 4096;
    static final int FLAG_Immovable = 8192;
    static final int FLAG_CanPush = 16384;
    static final int FLAG_Pushable = 32768;
    static final int FLAG_IsXPushing = 65536;
    static final int FLAG_Passable = 131072;
    static final int FLAG_BulletPassable = 262144;
    static final int FLAG_This = Integer.MIN_VALUE;
    static final int FLAG_All = -1;
    static final int MASK_Inactive = 3;
    static final int MASK_NotInteractive = 7;
    static final int MASK_Passable = -2147352573;
    static final int POS_X = 0;
    static final int POS_Y = 1;
    static final int POS_Dir = 2;
    static final int POS_Max = 3;
    static final int POS_2D_Max = 2;
    static int[] m_coords1 = new int[3];
    static int[] m_coords2 = new int[3];
    static int[] m_coords3 = new int[2];
    static int[] m_coords4 = new int[2];
    static int[] m_coords5 = new int[2];
    static int[] m_coords6 = new int[2];
    static int[] m_coords7 = new int[2];
    static int[] m_coords8 = new int[2];
    static int[] m_coords9 = new int[2];
    int m_ID;
    int m_Class;
    int m_Type;
    int[] m_Config;
    int m_ScreenX;
    int m_ScreenY;
    int m_ShadowScreenY;
    int m_Tag;
    int[] m_Position = new int[3];
    int[] m_PositionLast = new int[3];
    int m_RouteID;
    int[][] m_Route;
    int m_Progress;
    int m_Flags;
    int m_State;
    int m_StateTime;
    int m_StateLast;
    int m_Health;
    int m_Speed;
    int m_AuxInt;
    int m_AuxState;
    static final int PS_Take = -2;
    static final int PS_Throw = -1;
    static final int PS_Idle = 0;
    static final int PS_Move = 1;
    static final int PS_Jump = 2;
    static final int PS_Sit = 3;
    static final int PS_Damage = 4;
    static final int PS_DamageSit = 5;
    static final int PS_Death = 6;
    static final int PS_Shooting = 7;
    static final int PS_ShootingSit = 8;
    static final int PS_ThrowingGrenade = 9;
    static final int PS_ThrowingGrenadeSit = 10;
    static final int PS_Roll = 11;
    static final int PS_Hang = 12;
    static final int PS_Climb = 13;
    static final int PS_ClimbDown = 14;
    static final int PS_TurbojetMove = 15;
    static final int PS_TurbojetShoot = 16;
    static final int PS_Catched = 17;
    static final int PS_Ice_Idle = 18;
    static final int PS_Ice_Damage = 19;
    static final int PS_Push = 20;
    static final int PS_JumpShoot = 21;
    static final int PS_JumpStart = 0;
    static final int PS_JumpUp = 1;
    static final int PS_JumpApogee = 2;
    static final int PS_JumpDown = 3;
    static final int PS_JumpEnd = 4;
    static int m_PlayerWeapon;
    static GameObject m_PlayerMissile;
    static int m_PlayerHealthFlt;
    static int m_PlayerFuelFlt;
    static int m_PlayerFuel;
    static int m_PlayerHealthRegenTimeout;
    static int m_PlayerLastPressKey;
    static long m_PlayerLastPressTime;
    static int m_PlayerJumpSpeedX;
    static final int PLAYER_AMMO_INFINITY = -1;
    static int[] m_PlayerWeaponsAmmo;
    static int[] m_PlayerWeaponsTimeout;
    static byte m_PlayerAntiDoteCount;
    static int m_PlayerCooldownTime;
    static int m_PlayerLimitPosX;
    static boolean m_PlayerLimitLeft;
    int[] m_ForcedSpeed = new int[2];
    boolean m_IsLanded;
    int m_PhysicsY;
    static int ENEMY_DISTANCE_ACTIVE;
    static int ENEMY_DISTANCE_JUMP;
    static int ENEMY_DISTANCE_FIRE;
    static final int ES_Idle = 0;
    static final int ES_Melee = 1;
    static final int ES_Shoot = 2;
    static final int ES_Damage = 3;
    static final int ES_Death = 4;
    static final int ES_Move = 5;
    static final int ES_Jump = 6;
    static final int ES_Fly = 7;
    static final int ES_Last = 7;
    static final int ES_JumpStart = 0;
    static final int ES_JumpUp = 1;
    static final int ES_JumpApogee = 2;
    static final int ES_JumpDown = 3;
    static final int ES_JumpEnd = 4;
    int[] m_Enemy;
    int m_EnemyShootTimeout;
    int m_EnemyBulletsLoaded;
    static final int SS_Idle = 0;
    static final int SS_Throw = 1;
    static final int SS_Damage = 2;
    static final int SS_Death = 3;
    static final int FS_Idle = 0;
    static final int FS_Damage = 1;
    static final int FS_Death = 2;
    int[] m_EnemyFlyerZone;
    static final int MSS_Idle = 0;
    static final int MSS_Melee = 1;
    static final int MSS_Shoot = 2;
    static final int MSS_Damage = 3;
    static final int MSS_Death = 4;
    static final int MSS_Hide = 5;
    static final int MSS_Hide_Hide = 0;
    static final int MSS_Hide_Attack = 1;
    static final int MSS_Hide_Delay = 2;
    static final int MSS_Wait = 3;
    boolean m_EnemyMutantSoldierHideMode;
    int m_EnemyMutantSoldierAuxTime;
    static final int CKS_Idle = 0;
    static final int CKS_Move = 1;
    static final int CKS_Death = 2;
    static final int MS_Idle = 0;
    static final int MS_Move = 1;
    static final int MS_Death = 2;
    static final int MS_Max = 3;
    static final int MS_TakenMin = 5;
    static final int COLLISION_NONE = 0;
    static final int COLLISION_TERRAIN = 1;
    static final int COLLISION_OBJECT = 2;
    static int m_CollisionIntersection;
    static int m_CollisionObject;
    static final int[][] COLLISION_SlidingVectors;
    static boolean m_BossIsActive;
    static int m_BossBlinkTimer;
    static int m_BossTileset;
    static int m_BossPalette;
    static final int OS_Idle = 0;
    static final int OS_Damage = 1;
    static final int OS_Death = 2;
    int m_OctopusTentacleAttackTimeOut;
    GameObject[][] m_OctopusTentacles;
    int[] m_OctopusTentacleTimeOuts;
    boolean[] m_OctopusTentacleIsDirectionUp;
    static GameObject BossOctopus;
    static final int OTS_Idle = 0;
    static final int OTS_RollUp = 1;
    static final int OTS_RollDown = 2;
    static final int OTS_Damage = 3;
    static int DECEIVER_ESCAPE_DISTANCE;
    static final int ES_FlyShoot = 8;
    static final int UW_Inaccessible = 0;
    static final int UW_Accessible = 1;
    static final int UW_NeedFlight = 2;
    static final int UW_PlayerFrozen = 3;
    static final int UW_NeedJump = 4;
    static final int UW_NeedLanding = 5;
    static final int RT_GType = 0;
    static final int RT_Stop = 1;
    static final int RT_SimpleV = 2;
    static final int RT_Landing = 3;
    static int m_BD_HealthFlt;
    static boolean m_BD_NeedRegen;
    static int m_BD_RouteType;
    static final int BMS_Idle = 0;
    static final int BMS_HalfOpening = 1;
    static final int BMS_HalfIdle = 2;
    static final int BMS_HalfThrow = 3;
    static final int BMS_FullOpening = 4;
    static final int BMS_FullIdle = 5;
    static final int BMS_FullThrow = 6;
    static final int BMS_Death = 7;
    static GameObject m_BM_Barrel;
    static GameObject m_BM_BarrelsRoute;
    static GameObject[] m_BM_Grenades;
    static GameObject[] m_BM_GrenadesRoutes;
    static GameObject m_BM_Machine;
    static GameObject m_BM_Membranus;
    static int m_BM_iBarrels;
    static int m_BM_iGrenades;
    static int m_BM_SpawnTimer;
    static final int BMBS_Idle = 0;
    static final int BMBS_Open = 1;
    static final int BMMS_Idle = 0;
    static final int BMMS_Death = 1;
    static final int BMGS_Idle = 0;
    static final int BMGS_Death = 1;
    static final int PPS_Idle = 0;
    static final int PPS_Activate = 1;
    static final int PFSCS_Aim = 0;
    static final int PFSCS_Shoot = 1;
    static final int PFSCS_Defend = 2;
    static final int PFSCS_Death = 3;
    static GameObject m_FSCannonAttacker;
    static final int EFSCS_Climb = 0;
    static final int EFSCS_Crawl = 1;
    static final int EFSCS_Move = 2;
    static final int EFSCS_Attack = 3;
    static final int EFSCS_Falling = 4;
    static final int EFSCS_Death = 5;
    boolean m_PlatformIsActivated;
    static final int BS_Off = 0;
    static final int BS_On = 1;
    static final int CRS_Idle = 0;
    static final int CRS_Rotation = 1;
    public static boolean NO_HOOK;
    GameObject m_CratesHook;
    static final int[] CIVILIAN_DIALOGS;
    static final int CS_Idle = 0;
    static final int CS_Sit = 1;
    static int m_CivilianDialogToShow;
    static final int DS_Close = 0;
    static final int DS_Open = 1;
    boolean m_DoorOpened;
    int m_ScreenLastY;
    static final int TS_Idle = 0;
    static final int TS_Aim = 1;
    static final int TS_Shoot = 2;
    static final int TS_Damage = 3;
    static final int TS_Death = 4;
    static GameObject m_TurretAttacker;
    static final int SST_Idle = 0;
    static final int SST_Throw = 1;
    static final int SST_Damage = 2;
    static final int SST_Death = 3;
    boolean m_ScourgeHitTheTarget_IsShowingUp;
    boolean m_EnemyHitTheTarget_AllowAttack;

    static void ResetStaticData() {
        GameObject.Civilian_ResetStaticData();
    }

    GameObject(int n) {
        this.m_Class = n;
    }

    void Create() {
        this.Init();
        switch (this.m_Class) {
            default: 
        }
    }

    void Init() {
        this.m_IsLanded = true;
        this.SetScreenPosition(this.m_ScreenX, this.m_ScreenY);
        this.StorePosition();
        this.m_Flags = 1;
        this.m_State = 0;
        this.m_StateTime = 0;
        this.m_StateLast = 0;
        this.m_AuxInt = 0;
        this.m_AuxState = 0;
        this.m_Health = this.m_Config[2];
        this.m_Speed = 0;
        this.m_Route = null;
        this.m_Progress = 0;
        switch (this.m_Class) {
            case 0: {
                this.Player_Init();
                break;
            }
            case 2: {
                this.Enemy_Init();
                break;
            }
            case 23: {
                this.EnemyScourge_Init();
                break;
            }
            case 25: {
                this.EnemyScourgeHitTheTarget_Init();
                break;
            }
            case 26: {
                this.EnemyOrangutanHitTheTarget_Init();
                break;
            }
            case 3: {
                this.EnemyFlyer_Init();
                break;
            }
            case 6: {
                this.EnemyMutantSoldier_Init();
                break;
            }
            case 8: {
                this.ContextKiller_Init();
                break;
            }
            case 10: {
                this.Missile_Init();
                break;
            }
            case 11: {
                this.Emitter_Init();
                break;
            }
            case 14: {
                this.Boss_Init();
                break;
            }
            case 17: {
                this.OctopusTentacle_Init();
                break;
            }
            case 18: {
                this.Platform_Init();
                break;
            }
            case 9: {
                this.Hook_Init();
                break;
            }
            case 19: {
                this.Button_Init();
                break;
            }
            case 20: {
                this.Crate_Init();
                break;
            }
            case 21: {
                this.Civilian_Init();
                break;
            }
            case 22: {
                this.Door_Init();
                break;
            }
            case 24: {
                this.PlayerTurret_Init();
                break;
            }
            case 28: {
                this.BossMembranus_Machine_Init();
            }
        }
    }

    void Shutdown() {
        switch (this.m_Class) {
            case 0: {
                this.Player_Shutdown();
                break;
            }
            case 1: {
                this.PlayerFSCannon_Shutdown();
                break;
            }
            case 24: {
                this.PlayerTurret_Shutdown();
                this.Player_Shutdown();
                break;
            }
            case 14: {
                this.Boss_Shutdown();
            }
        }
    }

    void Update(int n) {
        if (0 != (this.m_Flags & 1)) {
            return;
        }
        this.m_StateTime += n;
        switch (this.m_Class) {
            case 0: {
                this.Player_Update(n);
                break;
            }
            case 2: {
                this.Enemy_Update(n);
                break;
            }
            case 23: {
                this.EnemyScourge_Update(n);
                break;
            }
            case 25: {
                this.EnemyScourgeHitTheTarget_Update(n);
                break;
            }
            case 26: {
                this.EnemyOrangutanHitTheTarget_Update(n);
                break;
            }
            case 3: {
                this.EnemyFlyer_Update(n);
                break;
            }
            case 6: {
                this.EnemyMutantSoldier_Update(n);
                break;
            }
            case 1: {
                this.PlayerFSCannon_Update(n);
                break;
            }
            case 24: {
                this.PlayerTurret_Update(n);
                break;
            }
            case 4: {
                this.EnemyFSCannon_Update(n);
                break;
            }
            case 8: {
                this.ContextKiller_Update(n);
                break;
            }
            case 10: {
                this.Missile_Update(n);
                break;
            }
            case 11: {
                this.Emitter_Update(n);
                break;
            }
            case 14: {
                this.Boss_Update(n);
                break;
            }
            case 17: {
                this.OctopusTentacle_Update(n);
                break;
            }
            case 15: {
                this.Pickup_Update(n);
                break;
            }
            case 18: {
                this.Platform_Update(n);
                break;
            }
            case 22: {
                this.Door_Update(n);
                break;
            }
            case 20: {
                this.Crate_Update(n);
                break;
            }
            case 27: {
                this.BossMembranus_Barrel_Update(n);
                break;
            }
            case 28: {
                this.BossMembranus_Machine_Update(n);
                break;
            }
            case 30: {
                this.BossMembranus_Grenade_Update(n);
                break;
            }
            default: {
                if (this.m_Route == null) break;
                this.MoveOnRoute(n);
            }
        }
    }

    void TryKillByNonpassableArea() {
        this.m_Flags |= Integer.MIN_VALUE;
        if (Game.Terrain_IsPositionBlocked(this.m_Position[0], this.m_Position[1], this.m_Config[3], this.m_Config[4]) || null != Game.Geometry_GetObject(this.m_Position[0], this.m_Position[1], this.m_Config[3], this.m_Config[4], 8, -2147352573)) {
            this.OnDamage(this.GetFatalDamage());
        }
        this.m_Flags &= Integer.MAX_VALUE;
    }

    void TryKillByDamageZone() {
        int n = Game.Terrain_GetCell(this.m_Position[0] >> Game.m_PassCellShiftW, this.m_Position[1] >> Game.m_PassCellShiftH);
        if (n == 35) {
            this.OnDamage(this.GetFatalDamage());
        }
    }

    void Render(Renderer renderer) {
        if (0 != (this.m_Flags & 1)) {
            return;
        }
        switch (this.m_Class) {
            case 0: {
                this.Player_Render(renderer);
                break;
            }
            case 2: {
                this.Enemy_Render(renderer);
                break;
            }
            case 26: {
                this.EnemyOrangutanHitTheTarget_Render(renderer);
                break;
            }
            case 13: {
                this.LightSource_Render(renderer);
                break;
            }
            case 14: {
                this.Boss_Render(renderer);
                break;
            }
            case 21: {
                this.Civilian_Render(renderer);
                break;
            }
            case 22: {
                this.Door_Render(renderer);
                break;
            }
            case 25: {
                this.EnemyScourgeHitTheTarget_Render(renderer);
                break;
            }
            case 15: {
                this.Pickup_Render(renderer);
                break;
            }
            case 30: {
                this.BossMembranus_Grenade_Render(renderer);
                break;
            }
            default: {
                this.RenderState(renderer);
            }
        }
    }

    void GetCollisionPoints(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        nArray[0] = this.m_Position[0];
        nArray2[0] = this.m_Position[0];
        nArray3[0] = this.m_Position[0];
        nArray4[0] = this.m_Position[0];
        nArray[1] = this.m_Position[1];
        nArray2[1] = this.m_Position[1];
        nArray3[1] = this.m_Position[1];
        nArray4[1] = this.m_Position[1];
        nArray[0] = nArray[0] + this.m_Config[3];
        nArray2[0] = nArray2[0] - this.m_Config[3];
        nArray3[0] = nArray3[0] + this.m_Config[3];
        nArray4[0] = nArray4[0] - this.m_Config[3];
        nArray[1] = nArray[1] + this.m_Config[4];
        nArray2[1] = nArray2[1] + this.m_Config[4];
        nArray3[1] = nArray3[1] - this.m_Config[4];
        nArray4[1] = nArray4[1] - this.m_Config[4];
    }

    void SetScreenPosition(int n, int n2) {
        this.m_Position[0] = n << 16;
        this.m_Position[1] = (n2 << 16) - this.m_Config[4];
        this.UpdateScreenPosition();
    }

    void UpdateScreenPosition() {
        this.m_ScreenX = this.m_Position[0] >> 16;
        this.m_ScreenY = this.m_Position[1] + this.m_Config[4] >> 16;
        this.UpdateShadow();
    }

    void SetPosition(int n, int n2) {
        this.m_Position[0] = n;
        this.m_Position[1] = n2;
        this.UpdateScreenPosition();
    }

    void SetDirection(int n) {
        this.m_Position[2] = Game.Math_NormalizeAngle_0_2Pi_Flt(n);
    }

    void SetDirection(int n, int n2) {
        this.SetDirection(Game.Math_ArctanFlt(n, n2));
    }

    int GetFastDistanceTo(GameObject gameObject) {
        return Math.max(Math.abs(gameObject.m_Position[0] - this.m_Position[0]), Math.abs(gameObject.m_Position[1] - this.m_Position[1]));
    }

    void StorePosition() {
        this.m_PositionLast[0] = this.m_Position[0];
        this.m_PositionLast[1] = this.m_Position[1];
        this.m_PositionLast[2] = this.m_Position[2];
    }

    int GetFastDistanceTo(int[] nArray) {
        return Math.max(Math.abs(nArray[0] - this.m_Position[0]), Math.abs(nArray[1] - this.m_Position[1]));
    }

    void Move(int n) {
        if (this.m_Speed != 0) {
            int n2 = this.m_Speed * n >> 10;
            this.m_Position[0] = this.m_Position[0] + Game.Math_MulFlt(n2, Game.Math_CosFlt(this.m_Position[2]));
            this.m_Position[1] = this.m_Position[1] + Game.Math_MulFlt(n2, Game.Math_SinFlt(this.m_Position[2]));
        }
    }

    void InitRoute(int[][] nArray) {
        this.m_Route = nArray;
        this.m_Progress = 0;
    }

    boolean InitRoute() {
        if (-1 == this.m_RouteID) {
            return false;
        }
        this.InitRoute(Game.m_Routes[this.m_RouteID]);
        return true;
    }

    void CancelRoute(boolean bl) {
        this.m_Route = null;
        if (bl) {
            this.OnRouteCompleted();
        }
    }

    boolean MoveOnRoute(int n) {
        if (null == this.m_Route) {
            return false;
        }
        this.m_Progress += (this.m_Speed >> 10) * n;
        int n2 = Game.Route_GetDirection(this.m_Route, this.m_Progress, 0);
        if (n2 == Integer.MIN_VALUE) {
            this.CancelRoute(true);
            return false;
        }
        this.m_Position[2] = n2;
        Game.Route_GetPosition(this.m_Position, this.m_Route, this.m_Progress);
        this.UpdateScreenPosition();
        return true;
    }

    void OnRouteCompleted() {
        switch (this.m_Class) {
            case 8: {
                this.ContextKiller_OnRouteCompleted();
                break;
            }
            case 2: 
            case 6: 
            case 26: {
                this.Enemy_OnRouteCompleted();
                break;
            }
            case 18: {
                this.Platform_OnRouteCompleted();
                break;
            }
            case 14: {
                switch (this.m_Type) {
                    case 21: {
                        this.BossDeceiver_OnRouteCompleted();
                        break;
                    }
                    case 34: {
                        this.BossMembranus_OnRouteCompleted();
                    }
                }
                break;
            }
            case 27: {
                this.BossMembranus_Barrel_OnRouteCompleted();
                break;
            }
            case 30: {
                this.BossMembranus_Grenade_OnRouteCompleted();
            }
        }
    }

    boolean HitTestScreen(int n, int n2) {
        return Math.max(Math.abs(n - this.m_ScreenX), Math.abs(n2 - this.m_ScreenY)) < Math.min(this.m_Config[3], this.m_Config[4]) >> 16;
    }

    boolean HitTestWorld(int n, int n2) {
        return Math.abs(n - this.m_Position[0]) < this.m_Config[3] && Math.abs(n2 - this.m_Position[1]) < this.m_Config[4];
    }

    boolean HitTestWorld(int n, int n2, int n3, int n4) {
        return Math.abs(n - this.m_Position[0]) < n3 + this.m_Config[3] && Math.abs(n2 - this.m_Position[1]) < n4 + this.m_Config[4];
    }

    boolean IsIsectsWithSegment(int[] nArray, int[] nArray2, int[] nArray3) {
        if (0 == this.m_Config[3] || 0 == this.m_Config[4]) {
            return false;
        }
        int n = Math.max(this.m_Position[0] - this.m_Config[3], Math.min(nArray[0], nArray2[0]));
        int n2 = Math.max(this.m_Position[1] - this.m_Config[4], Math.min(nArray[1], nArray2[1]));
        int n3 = Math.min(this.m_Position[0] + this.m_Config[3], Math.max(nArray[0], nArray2[0]));
        int n4 = Math.min(this.m_Position[1] + this.m_Config[4], Math.max(nArray[1], nArray2[1]));
        if (n > n3 || n2 > n4) {
            return false;
        }
        n = Integer.MIN_VALUE;
        n2 = Integer.MAX_VALUE;
        Game.Math_SubVector2D(m_coords5, nArray2, nArray);
        n3 = Game.Math_GetMagnitudeFast2D(m_coords5);
        Game.Math_DivVector2D(m_coords4, m_coords5, n3);
        for (n4 = 0; n4 <= 1; ++n4) {
            if (m_coords4[0 + n4] != 0) {
                int n5;
                int n6 = Game.Math_DivFlt(this.m_Position[0 + n4] - this.m_Config[3 + n4] - nArray[0 + n4], m_coords4[0 + n4]);
                if (n6 > (n5 = Game.Math_DivFlt(this.m_Position[0 + n4] + this.m_Config[3 + n4] - nArray[0 + n4], m_coords4[0 + n4]))) {
                    int n7 = n6;
                    n6 = n5;
                    n5 = n7;
                }
                if (n6 > n) {
                    n = n6;
                }
                if (n5 < n2) {
                    n2 = n5;
                }
                if (n <= n2 && n2 >= 0) continue;
                return false;
            }
            if (nArray[0 + n4] <= this.m_Position[0 + n4] + this.m_Config[3 + n4] && nArray[0 + n4] >= this.m_Position[0 + n4] - this.m_Config[3 + n4]) continue;
            return false;
        }
        if (nArray3 == null) {
            return true;
        }
        Game.Math_MulVector2D(m_coords5, m_coords4, n >= 0 ? n : n2);
        Game.Math_AddVector2D(nArray3, nArray, m_coords5);
        return true;
    }

    int GetAnimTime(int n) {
        return Game.m_AnimationTimes[this.m_Config[1] + n];
    }

    int GetTile() {
        if (-1 == this.m_Config[1]) {
            return -1;
        }
        int n = this.m_Config[1] + this.m_State;
        short s = Game.m_AnimationTimes[n];
        short[][] sArray = Game.m_AnimationClips[n];
        if (sArray.length == 0) {
            return -1;
        }
        short[] sArray2 = sArray[Game.Math_AngleToDirectionFlt(this.m_Position[2], sArray.length, false)];
        if (sArray2.length == 0) {
            return -1;
        }
        return sArray2[this.m_StateTime * sArray2.length / s % sArray2.length];
    }

    void RenderState(Renderer renderer) {
        if (-1 == this.m_Config[1]) {
            return;
        }
        int n = this.m_Config[1] + this.m_State;
        short s = Game.m_AnimationTimes[n];
        short[][] sArray = Game.m_AnimationClips[n];
        if (sArray.length == 0) {
            return;
        }
        short[] sArray2 = sArray[Game.Math_AngleToDirectionFlt(this.m_Position[2], sArray.length, false)];
        if (sArray2.length == 0) {
            return;
        }
        short s2 = sArray2[this.m_StateTime * sArray2.length / s % sArray2.length];
        Game.Tile_Render(renderer, s2, this.m_ScreenX, this.m_ScreenY);
    }

    void Enable(boolean bl) {
        this.m_Flags = bl ? (this.m_Flags &= 0xFFFFFFFE) : (this.m_Flags |= 1);
    }

    boolean IsEnabled() {
        return 0 == (this.m_Flags & 1);
    }

    void SetClass(int n) {
        this.m_Class = n;
    }

    void SetType(int n) {
        int n2 = this.m_Config[4];
        this.m_Type = n;
        this.m_Config = Game.m_ObjectConfigs[this.m_Type];
        this.m_Position[1] = this.m_Position[1] + (n2 - this.m_Config[4]);
        this.m_PositionLast[1] = this.m_Position[1];
    }

    void SetState(int n) {
        if (n == this.m_State) {
            return;
        }
        this.m_StateLast = this.m_State;
        this.m_State = n;
        this.m_StateTime = 0;
    }

    int GetTargetPriority() {
        int n = 0;
        switch (this.m_Class) {
            default: 
        }
        if (n > 0 && 0 != (this.m_Flags & 3)) {
            n = 0;
        }
        return n;
    }

    int GetHitEffect() {
        switch (this.m_Class) {
            case 0: {
                return -1;
            }
            case 2: 
            case 3: 
            case 14: {
                return -1;
            }
        }
        return -1;
    }

    void OnDamage(int n, int n2) {
        if (this.m_Health == 0) {
            return;
        }
        if (0 != (this.m_Flags & 0x200)) {
            n = 0;
        }
        if (!Game.m_CutsceneIsCutscene) {
            this.m_Health -= n;
        } else {
            return;
        }
        switch (this.m_Class) {
            case 0: {
                this.Player_OnDamage(n, n2);
                break;
            }
            case 1: {
                this.PlayerFSCannon_OnDamage(n);
                break;
            }
            case 24: {
                this.PlayerTurret_OnDamage(n);
                break;
            }
            case 2: {
                this.Enemy_OnDamage();
                break;
            }
            case 23: {
                this.EnemyScourge_OnDamage();
                break;
            }
            case 25: {
                this.EnemyScourgeHitTheTarget_OnDamage();
                break;
            }
            case 26: {
                this.EnemyOrangutanHitTheTarget_OnDamage();
                break;
            }
            case 3: {
                this.EnemyFlyer_OnDamage();
                break;
            }
            case 6: {
                this.EnemyMutantSoldier_OnDamage();
                break;
            }
            case 14: {
                this.Boss_OnDamage(n);
                break;
            }
            case 17: {
                this.OctopusTentacle_OnDamage(n);
                break;
            }
            case 28: {
                this.BossMembranus_Machine_OnDamage(n);
            }
        }
        if (this.m_Health <= 0) {
            this.m_Health = 0;
            this.OnDeath();
        }
    }

    void OnDamage(int n) {
        this.OnDamage(n, -1);
    }

    void OnDeath() {
        Game.Level_OnObjectDeath(this.m_ID);
        if (Game.Objects_IsEnemy(this.m_ID)) {
            Game.m_ScoreLevel[13] = Game.m_ScoreLevel[13] + 1;
        }
        this.m_Flags |= 2;
        switch (this.m_Class) {
            case 0: {
                this.Player_OnDeath();
                break;
            }
            case 1: {
                this.PlayerFSCannon_OnDeath();
                break;
            }
            case 24: {
                this.PlayerTurret_OnDeath();
                break;
            }
            case 4: {
                this.EnemyFSCannon_OnDeath();
                break;
            }
            case 2: {
                this.Enemy_OnDeath();
                break;
            }
            case 23: {
                this.EnemyScourge_OnDeath();
                break;
            }
            case 25: {
                this.EnemyScourgeHitTheTarget_OnDeath();
                break;
            }
            case 26: {
                this.EnemyOrangutanHitTheTarget_OnDeath();
                break;
            }
            case 3: {
                this.EnemyFlyer_OnDeath();
                break;
            }
            case 6: {
                this.EnemyMutantSoldier_OnDeath();
                break;
            }
            case 10: {
                this.Missile_OnDeath();
                break;
            }
            case 14: {
                this.Boss_OnDeath();
                break;
            }
            case 27: {
                this.BossMembranus_Barrel_OnDeath();
                break;
            }
            case 28: {
                this.BossMembranus_Machine_OnDeath();
                break;
            }
            case 30: {
                this.BossMembranus_Grenade_OnDeath();
            }
        }
    }

    int GetFatalDamage() {
        switch (this.m_Class) {
            case 0: {
                return this.Player_GetFatalDamage();
            }
        }
        return this.m_Health;
    }

    void OnPushed() {
        switch (this.m_Class) {
            case 0: {
                this.Player_OnPushed();
            }
        }
    }

    boolean HasShadow() {
        switch (this.m_Class) {
            case 0: 
            case 2: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    void UpdateShadow() {
        if (!this.HasShadow()) {
            return;
        }
        int n = Game.m_CameraY - Game.m_CameraShiftY + Game.m_realHeightDouble << 16;
        if (this.m_IsLanded || this.m_Position[1] >= n) {
            this.m_ShadowScreenY = this.m_ScreenY;
            return;
        }
        GameObject.m_coords1[0] = this.m_Position[0];
        GameObject.m_coords1[1] = n;
        this.m_ShadowScreenY = m_coords1[1] - this.Collision_GetCorrectedPosition(this.m_Position, m_coords1, null) + this.m_Config[4] >> 16;
    }

    void RenderShadow(Renderer renderer) {
        if (0 != (this.m_Flags & 1)) {
            return;
        }
        if (!this.HasShadow()) {
            return;
        }
        renderer.m_Mode = (byte)2;
        Game.Tile_Render(renderer, 775, this.m_ScreenX, this.m_ShadowScreenY);
        renderer.m_Mode = 0;
    }

    void Player_Init() {
        m_PlayerMissile = null;
        m_PlayerFuel = 1000;
        m_PlayerAntiDoteCount = 0;
        m_PlayerCooldownTime = 0;
        GameObject.Player_InitWeapons();
        m_PlayerLimitPosX = 0;
        m_PlayerLimitLeft = true;
    }

    void Player_Shutdown() {
        m_PlayerMissile = null;
        m_PlayerWeaponsAmmo = null;
        m_PlayerWeaponsTimeout = null;
    }

    void Player_Update(int n) {
        int n2;
        m_PlayerCooldownTime += n;
        for (n2 = 0; n2 < m_PlayerWeaponsTimeout.length; ++n2) {
            GameObject.m_PlayerWeaponsTimeout[n2] = Math.max(0, m_PlayerWeaponsTimeout[n2] - n);
        }
        Game.HUD_ShowPointer(this.m_State == 0 || this.m_State == 3 || this.m_State == 12);
        if (this.m_StateTime >= Game.m_AnimationTimes[this.m_Config[1] + this.m_State]) {
            switch (this.m_State) {
                case 4: 
                case 18: {
                    this.SetState(0);
                    break;
                }
                case -2: {
                    this.SetState(-1);
                    break;
                }
                case 19: {
                    this.SetState(18);
                    break;
                }
                case 11: {
                    if (!this.Player_CanStandUp()) {
                        this.m_StateTime %= Game.m_AnimationTimes[this.m_Config[1] + this.m_State];
                        break;
                    }
                }
                case 5: {
                    this.m_Speed = 0;
                    this.SetState(3);
                    break;
                }
                case 7: {
                    if (this.Player_IsFirePressed()) break;
                    this.SetState(0);
                    break;
                }
                case 21: {
                    if (this.m_IsLanded || !this.Player_IsFirePressed()) {
                        this.SetState(0);
                    }
                    m_PlayerJumpSpeedX = 0;
                    break;
                }
                case 9: {
                    this.SetState(0);
                    break;
                }
                case 10: {
                    this.SetState(3);
                    break;
                }
                case 8: {
                    if (this.Player_IsFirePressed()) break;
                    this.SetState(3);
                    break;
                }
                case -1: {
                    this.Player_ThrowMissile(false);
                    this.SetState(0);
                    break;
                }
                case 13: {
                    Game.ActivityHook_OnClimbEnd();
                    break;
                }
                case 14: {
                    Game.ActivityHookDown_OnClimbDownEnd();
                    break;
                }
                case 16: {
                    if (this.Player_IsFirePressed()) break;
                    this.SetState(15);
                }
            }
        }
        switch (this.m_State) {
            case 20: {
                if ((this.m_Flags & 0x10000) == 0) {
                    this.SetState(0);
                    break;
                }
            }
            case 1: {
                if ((this.m_Flags & 0x10000) != 0) {
                    this.SetState(20);
                }
                this.m_Flags |= 0x4000;
                break;
            }
            default: {
                this.m_Flags &= 0xFFFFBFFF;
            }
        }
        if (this.m_Health < this.m_Config[2]) {
            this.Player_Regenerate(n);
        }
        switch (this.m_State) {
            case 6: {
                this.Player_UpdateDeath(n);
            }
            case 12: 
            case 13: 
            case 14: {
                return;
            }
        }
        if (this.m_Route != null) {
            if (this.MoveOnRoute(n)) {
                return;
            }
            this.m_Speed = 0;
            this.Player_StandUp();
        }
        if (this.Player_IsFirePressed()) {
            switch (this.m_State) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 15: 
                case 16: 
                case 21: {
                    this.Player_Shoot();
                }
            }
        }
        this.StorePosition();
        if (!this.Player_IsLaden()) {
            switch (this.m_State) {
                case 0: 
                case 1: {
                    if (!this.m_IsLanded) break;
                    if (this.Player_IsUpPressed()) {
                        this.Player_Jump();
                        break;
                    }
                    if (!this.Player_IsDownPressed()) break;
                    this.Player_SitDown();
                    this.m_Speed = 0;
                    Game.Keys_Clear();
                    break;
                }
                case 2: {
                    this.Player_UpdateJump();
                    break;
                }
                case 3: {
                    if (!this.Player_IsUpPressed()) break;
                    this.Player_StandUp();
                    Game.Keys_Clear();
                }
            }
        }
        if (!this.m_IsLanded) {
            switch (this.m_State) {
                case 0: 
                case 1: 
                case 3: 
                case 11: {
                    n2 = this.m_Position[0] >> Game.m_PassCellShiftW;
                    int n3 = this.m_Position[1] + this.m_Config[4] + Game.m_PassCellH >> Game.m_PassCellShiftH;
                    if (Game.Terrain_IsPositionBlocked(n2, n3)) break;
                    if (this.Player_IsSitting()) {
                        this.Player_StandUp();
                    }
                    if (this.Player_IsLaden()) {
                        this.Player_ThrowMissile(true);
                    }
                    this.SetState(2);
                    this.m_AuxState = 2;
                    m_PlayerJumpSpeedX = 0;
                }
            }
        }
        n2 = this.Player_GetDirectionPressed();
        switch (this.m_State) {
            case 0: {
                if (this.Player_IsLaden()) {
                    return;
                }
                if (n2 == Integer.MIN_VALUE) break;
                this.m_Position[2] = n2;
                this.m_Speed = 0x640000;
                this.SetState(1);
                break;
            }
            case 1: 
            case 20: {
                if (n2 == Integer.MIN_VALUE) {
                    this.m_Speed = 0;
                    this.SetState(0);
                    break;
                }
                this.m_Position[2] = n2;
                break;
            }
            case 2: {
                if (n2 == Integer.MIN_VALUE) {
                    this.m_Speed = 0;
                    break;
                }
                if (this.m_Position[2] != n2) {
                    m_PlayerJumpSpeedX = -m_PlayerJumpSpeedX;
                }
                this.m_Position[2] = n2;
                this.m_Speed = 0x640000;
                break;
            }
            case 3: {
                if (n2 == this.m_Position[2]) {
                    this.m_Speed = 0x640000;
                    this.SetState(11);
                    break;
                }
                if (n2 == Integer.MIN_VALUE) break;
                this.m_Position[2] = n2;
                Game.Keys_Clear();
                break;
            }
            case 17: {
                this.m_Speed = 0;
            }
        }
        if (this.Player_IsTurbojetActive()) {
            if (n2 != Integer.MIN_VALUE) {
                this.m_Position[2] = n2;
            }
            this.Player_TurbojetUpdate(n);
        } else {
            if ((this.m_Flags & 0x10000) != 0 && this.m_Speed != 0) {
                this.m_Speed = 0x320000;
            }
            this.Move(n);
            this.Physics_Update(n);
        }
        this.m_Position[0] = this.m_Position[0] + (m_PlayerJumpSpeedX * n >> 10);
        this.Player_UpdateLimitPos();
        this.Collision_Update();
        this.TryKillByNonpassableArea();
        this.TryKillByDamageZone();
        if (0 != (this.m_Flags & 0x100)) {
            this.m_Position[0] = Math.max(Game.m_CameraFltMinX + this.m_Config[3], Math.min(Game.m_CameraFltMaxX - this.m_Config[3], this.m_Position[0]));
        }
        if (this.m_IsLanded) {
            m_PlayerJumpSpeedX = 0;
        }
        this.UpdateScreenPosition();
    }

    void Player_Jump() {
        this.m_ForcedSpeed[1] = -17039360;
        m_PlayerJumpSpeedX = 0;
        this.m_IsLanded = false;
        this.SetState(2);
        this.m_AuxState = 0;
    }

    void Player_SwitchWeapon() {
        for (int i = 1; i < Game.m_Weapons.length; ++i) {
            int n = (m_PlayerWeapon + i) % Game.m_Weapons.length;
            if (m_PlayerWeaponsAmmo[n] == 0) continue;
            m_PlayerWeapon = n;
            return;
        }
    }

    boolean Player_CanSwitchWeapon() {
        for (int i = 1; i < Game.m_Weapons.length; ++i) {
            if (m_PlayerWeaponsAmmo[i] <= 0) continue;
            return true;
        }
        return false;
    }

    void Player_SelectFirstWeapon() {
        for (int i = 0; i < Game.m_Weapons.length; ++i) {
            if (m_PlayerWeaponsAmmo[i] == 0) continue;
            if (i == 4) {
                this.Player_StandUp();
            }
            m_PlayerWeapon = i;
            return;
        }
    }

    void Player_Catch() {
        this.SetState(17);
    }

    boolean Player_OnKey(int n) {
        if (n == 7 && !Game.m_PauseIsShown) {
            Game.Pause_Show(true);
            return true;
        }
        if (Game.m_CutsceneIsCutscene) {
            return false;
        }
        switch (n) {
            case 0: 
            case 2: {
                if (n != m_PlayerLastPressKey || Game.g_Time - m_PlayerLastPressTime > 300L || this.Player_IsTurbojetActive() ^ n == 2) {
                    m_PlayerLastPressKey = n;
                    m_PlayerLastPressTime = Game.g_Time;
                    break;
                }
                this.Player_TurbojetToggle();
                return true;
            }
            case 8: {
                this.Player_SwitchWeapon();
            }
        }
        return false;
    }

    void Player_OnPushed() {
        if (this.Player_IsSitting()) {
            this.SetState(3);
        } else if (this.m_State != 7) {
            this.SetState(0);
        }
        this.m_Speed = 0;
        if (Game.m_Activity == -1) {
            return;
        }
        switch (Game.m_Activity) {
            case 2: {
                this.m_Position[2] = this.m_Position[2] == 0 ? 205888 : 0;
            }
            case 3: {
                Game.Activity_SetCurrent(-1);
                break;
            }
            default: {
                Game.Activity_SetCurrent(-1);
            }
        }
    }

    void Player_Render(Renderer renderer) {
        int n;
        if (m_PlayerMissile != null) {
            int n2 = GameObject.m_PlayerMissile.m_Config[1] + 5 + this.m_State;
            n = Game.m_AnimationTimes[n2];
            short[][] sArray = Game.m_AnimationClips[n2];
            short[] sArray2 = sArray[Game.Math_AngleToDirectionFlt(this.m_Position[2], sArray.length, false)];
            short s = sArray2[this.m_StateTime * sArray2.length / n % sArray2.length];
            Game.Tile_Render(renderer, s, this.m_ScreenX, this.m_ScreenY);
        }
        if (this.m_State == 2) {
            short[][] sArray = Game.m_AnimationClips[this.m_Config[1] + this.m_State];
            n = Game.Math_AngleToDirectionFlt(this.m_Position[2], sArray.length, false);
            Game.Tile_Render(renderer, sArray[n][this.m_AuxState], this.m_ScreenX, this.m_ScreenY);
        } else {
            this.RenderState(renderer);
        }
    }

    void Player_GetShootingCoords(int[] nArray, int n) {
        nArray[0] = 0;
        nArray[1] = 0;
        Game.Tile_GetJointOrigin(this.GetTile(), n, nArray, 0);
        nArray[0] = nArray[0] + this.m_ScreenX << 16;
        nArray[1] = nArray[1] + this.m_ScreenY << 16;
        nArray[2] = this.m_Position[2];
    }

    int Player_GetDirectionPressed() {
        if (Game.m_CutsceneIsCutscene || this.m_State == 2) {
            return Integer.MIN_VALUE;
        }
        if (Game.m_IsKeyPressed[1]) {
            return 0;
        }
        if (Game.m_IsKeyPressed[3]) {
            return 205888;
        }
        return Integer.MIN_VALUE;
    }

    int Player_GetDirectionPressedSum() {
        if (Game.m_CutsceneIsCutscene) {
            return Integer.MIN_VALUE;
        }
        if (Game.m_IsKeyPressed[1]) {
            if (Game.m_IsKeyPressed[0]) {
                return 360304;
            }
            if (Game.m_IsKeyPressed[2]) {
                return 51472;
            }
            return 0;
        }
        if (Game.m_IsKeyPressed[3]) {
            if (Game.m_IsKeyPressed[0]) {
                return 257360;
            }
            if (Game.m_IsKeyPressed[2]) {
                return 154416;
            }
            return 205888;
        }
        if (Game.m_IsKeyPressed[0]) {
            return 308832;
        }
        if (Game.m_IsKeyPressed[2]) {
            return 102944;
        }
        return Integer.MIN_VALUE;
    }

    boolean Player_IsFirePressed() {
        if (Game.m_CutsceneIsCutscene || Game.m_Activity != -1 && Game.m_Activity != 3) {
            return false;
        }
        return Game.m_IsKeyPressed[4];
    }

    boolean Player_IsUpPressed() {
        if (Game.m_CutsceneIsCutscene) {
            return false;
        }
        return Game.m_IsKeyPressed[0];
    }

    boolean Player_IsDownPressed() {
        if (Game.m_CutsceneIsCutscene) {
            return false;
        }
        return Game.m_IsKeyPressed[2];
    }

    boolean Player_IsLaden() {
        return this.m_State == -2 || this.m_State == -1;
    }

    boolean Player_IsSitting() {
        return this.m_Type == 1;
    }

    boolean Player_IsHoldingGrenade() {
        return m_PlayerWeapon == 4;
    }

    boolean Player_CanStandUp() {
        int[] nArray = Game.m_ObjectConfigs[0];
        return !Game.Terrain_IsPositionBlocked(this.m_Position[0], this.m_Position[1] + this.m_Config[4] - nArray[4], nArray[3], nArray[4]);
    }

    void Player_SitDown() {
        this.SetType(1);
        this.SetState(3);
    }

    void Player_StandUp() {
        this.SetType(0);
        this.SetState(0);
    }

    void Player_MoveTo(int n, int n2) {
        int[][] nArray = new int[2][5];
        nArray[0][0] = this.m_Position[0];
        nArray[0][1] = this.m_Position[1];
        nArray[1][0] = n << 16;
        nArray[1][1] = (n2 << 16) - this.m_Config[4];
        Game.Route_OnChanged(nArray);
        this.m_Speed = 0x640000;
        this.SetState(1);
        this.InitRoute(nArray);
    }

    void Player_UpdateJump() {
        switch (this.m_AuxState) {
            case 0: {
                if (this.m_StateTime <= 100) break;
                this.m_AuxState = 1;
                if (!this.Player_IsUpPressed()) break;
                m_PlayerJumpSpeedX = 205888 == this.m_Position[2] ? -6553600 : 0x640000;
                break;
            }
            case 1: {
                if (this.m_ForcedSpeed[1] < 0) break;
                this.m_AuxState = 2;
                this.m_StateTime = 0;
                break;
            }
            case 2: {
                if (this.m_StateTime <= 100) break;
                this.m_AuxState = 3;
                break;
            }
            case 3: {
                if (!this.m_IsLanded) break;
                this.m_AuxState = 4;
                this.m_StateTime = 0;
                m_PlayerJumpSpeedX = 0;
                break;
            }
            case 4: {
                if (this.m_StateTime <= 100) break;
                this.SetState(0);
                this.m_Speed = 0;
                m_PlayerJumpSpeedX = 0;
            }
        }
    }

    void Player_UpdateDeath(int n) {
        short s = Game.m_AnimationTimes[this.m_Config[1] + this.m_State];
        if (this.m_StateTime >= s) {
            Game.SceneAction_OnPlayerDeath();
        }
        this.Enemy_UpdateDeath(n);
    }

    boolean Player_IsShooting() {
        return this.m_State == 7 || this.m_State == 8 || this.m_State == 16 || this.m_State == 21 || this.m_State == 9;
    }

    void Player_Shoot() {
        if (!Game.Weapons_IsReady(m_PlayerWeapon, m_PlayerCooldownTime) || m_PlayerWeaponsAmmo[m_PlayerWeapon] == 0 || m_PlayerWeaponsTimeout[m_PlayerWeapon] > 0) {
            return;
        }
        GameObject.m_PlayerWeaponsTimeout[GameObject.m_PlayerWeapon] = Game.m_Weapons[m_PlayerWeapon][2];
        this.m_Speed = 0;
        this.m_StateTime = 0;
        m_PlayerCooldownTime = 0;
        if (this.Player_IsTurbojetActive()) {
            this.SetState(16);
        } else if (this.Player_IsSitting()) {
            if (this.Player_IsHoldingGrenade()) {
                this.SetState(10);
            } else {
                this.SetState(8);
            }
        } else if (this.Player_IsHoldingGrenade()) {
            this.SetState(9);
        } else if (this.m_State == 2 || this.m_State == 21) {
            this.SetState(21);
        } else {
            this.SetState(7);
        }
        Game.m_AnimationTimes[this.m_Config[1] + this.m_State] = (short)Game.m_Weapons[m_PlayerWeapon][1];
        this.Player_GetShootingCoords(Game.m_coords11, 0);
        Game.Weapons_Fire(m_PlayerWeapon, Game.m_coords11, this.m_ID);
        if (m_PlayerWeaponsAmmo[m_PlayerWeapon] != -1) {
            int n = m_PlayerWeapon;
            m_PlayerWeaponsAmmo[n] = m_PlayerWeaponsAmmo[n] - 1;
            if (m_PlayerWeaponsAmmo[n] == 0) {
                this.Player_SelectFirstWeapon();
            }
        }
    }

    void Player_TakeMissile(GameObject gameObject) {
        if (this.Player_IsSitting()) {
            this.Player_StandUp();
        }
        this.m_Speed = 0;
        this.SetState(-2);
        m_PlayerMissile = gameObject;
        m_PlayerMissile.Missile_OnTake();
        m_PlayerMissile.Enable(false);
    }

    void Player_ThrowMissile(boolean bl) {
        boolean bl2 = this.m_Position[2] > 102944 && this.m_Position[2] < 308832;
        GameObject.m_PlayerMissile.m_Position[0] = this.m_Position[0] + (bl2 ? -4915200 : 0x4B0000);
        GameObject.m_PlayerMissile.m_Position[1] = this.m_Position[1] + this.m_Config[4] + -3014656;
        m_PlayerMissile.UpdateScreenPosition();
        GameObject.m_PlayerMissile.m_ForcedSpeed[0] = bl2 ? -17039360 : 0x1040000;
        GameObject.m_PlayerMissile.m_ForcedSpeed[1] = 655360;
        if (bl) {
            GameObject.m_PlayerMissile.m_ForcedSpeed[0] = GameObject.m_PlayerMissile.m_ForcedSpeed[0] / 3;
        }
        m_PlayerMissile.Enable(true);
        m_PlayerMissile.Missile_OnThrow();
        m_PlayerMissile = null;
    }

    void Player_ProcessDamage(int n) {
        m_PlayerHealthRegenTimeout = 4000;
    }

    void Player_Regenerate(int n) {
        if (this.m_State == 6) {
            return;
        }
        this.Player_RegenerateHealth(n);
    }

    void Player_RegenerateHealth(int n) {
        if (m_PlayerHealthRegenTimeout > 0) {
            m_PlayerHealthRegenTimeout -= n;
            if (this.m_Health >= this.m_Config[2]) {
                return;
            }
            if (m_PlayerHealthRegenTimeout > 0) {
                return;
            }
            m_PlayerHealthFlt = this.m_Health << 16;
        }
        this.m_Health = (m_PlayerHealthFlt += 0x190000 * n >> 10) >> 16;
        if (this.m_Health > this.m_Config[2]) {
            this.m_Health = this.m_Config[2];
        }
    }

    void Player_TurbojetToggle() {
        if ((this.m_Flags & 0x200) == 0 && !this.Player_IsTurbojetActive() && (this.Player_IsLaden() || this.Player_IsSitting() || m_PlayerFuel <= 0 || this.m_Class == 1 || !this.Player_IsTurbojetActive() && this.m_State == 18 || this.m_State == 19 || this.m_Health <= 0)) {
            return;
        }
        this.m_IsLanded = false;
        this.m_Speed = 0;
        this.m_ForcedSpeed[0] = 0;
        this.m_ForcedSpeed[1] = 0;
        m_PlayerJumpSpeedX = 0;
        this.SetState(this.Player_IsTurbojetActive() ? 0 : 15);
        if (this.m_State == 15) {
            this.m_PhysicsY = this.m_Position[1];
            Game.Activity_SetCurrent(-1);
        }
        if (this.Player_IsTurbojetActive()) {
            Game.Sound_Play(6);
            Game.Vibra_Play(1000);
        }
    }

    void Player_TurbojetUpdate(int n) {
        int n2 = this.m_Position[2];
        int n3 = this.Player_GetDirectionPressedSum();
        if (m_PlayerFuel > 0) {
            m_PlayerFuelFlt = m_PlayerFuel << 16;
            if (0 == (this.m_Flags & 0x200)) {
                m_PlayerFuelFlt -= 0x320000 * n >> 10;
            }
            if ((m_PlayerFuel = m_PlayerFuelFlt >> 16) <= 0) {
                m_PlayerFuel = 1;
                this.Player_TurbojetToggle();
                m_PlayerFuel = 0;
            }
        }
        this.m_Speed = n3 == Integer.MIN_VALUE ? 0 : 0x640000;
        this.m_Position[2] = n3;
        this.Move(n);
        this.m_Position[2] = n2;
    }

    boolean Player_IsTurbojetActive() {
        return this.m_State == 15 || this.m_State == 16;
    }

    void Player_OnDamage(int n, int n2) {
        Game.m_ScoreLevel[11] = Game.m_ScoreLevel[11] + n;
        if (this.Player_IsLaden()) {
            this.Player_ThrowMissile(true);
        }
        switch (this.m_State) {
            case 12: 
            case 13: {
                Game.ActivityHook_OnPlayerDamage();
            }
        }
        if (!this.Player_IsTurbojetActive()) {
            this.m_Speed = 0;
            if (n2 == 13) {
                this.SetState(19);
            } else {
                this.SetState(this.Player_IsSitting() ? 5 : 4);
            }
        } else {
            this.Player_TurbojetToggle();
        }
        this.Player_ProcessDamage(n);
    }

    int Player_GetFatalDamage() {
        return this.m_Health;
    }

    void Player_OnDeath() {
        if (this.Player_IsSitting()) {
            this.Player_StandUp();
        }
        Game.Sound_Play(24);
        Game.Vibra_Play(1000);
        this.m_AuxInt = 2000;
        this.SetState(6);
        Game.Activity_SetCurrent(-1);
    }

    void Player_IncHealth(int n) {
        this.m_Health = Math.min(this.m_Health + n, this.m_Config[2]);
        m_PlayerHealthFlt = this.m_Health << 16;
    }

    void Player_LoadFuel(int n) {
        if (m_PlayerFuel >= 1000) {
            return;
        }
        m_PlayerFuelFlt = m_PlayerFuel << 16;
        m_PlayerFuel = (m_PlayerFuelFlt += 0xC80000 * n >> 10) >> 16;
    }

    void Player_IncAmmo(int n, int n2) {
        if (n == 0) {
            return;
        }
        int n3 = m_PlayerWeaponsAmmo[n] + n2;
        if (n3 < 0) {
            GameObject.m_PlayerWeaponsAmmo[n] = 0;
        }
        GameObject.m_PlayerWeaponsAmmo[n] = Math.min(n3, Game.m_Weapons[n][3]);
    }

    void Player_AddAntiDote() {
        if (m_PlayerAntiDoteCount < 3) {
            m_PlayerAntiDoteCount = (byte)(m_PlayerAntiDoteCount + 1);
        }
    }

    static void Player_InitWeapons() {
        m_PlayerWeaponsAmmo = new int[Game.m_Weapons.length];
        m_PlayerWeaponsTimeout = new int[Game.m_Weapons.length];
        m_PlayerWeapon = 0;
        GameObject.m_PlayerWeaponsAmmo[0] = -1;
    }

    void Player_OnActivityStart() {
        m_PlayerJumpSpeedX = 0;
    }

    void Player_Land() {
        this.m_ForcedSpeed[0] = 0;
        this.m_ForcedSpeed[1] = 0x1400000;
        while (this.m_Position[1] != this.m_PositionLast[1]) {
            this.StorePosition();
            this.Physics_Update(10);
            this.Collision_Update();
        }
        this.UpdateScreenPosition();
    }

    void Player_UpdateLimitPos() {
        this.m_Position[0] = m_PlayerLimitLeft ? Math.max(this.m_Position[0], m_PlayerLimitPosX) : Math.min(this.m_Position[0], m_PlayerLimitPosX);
    }

    void Player_SetLimitPos(int n, boolean bl) {
        m_PlayerLimitPosX = Game.m_Objects[n].m_Position[0];
        m_PlayerLimitLeft = bl;
    }

    void Physics_Update(int n) {
        if (0 == n) {
            return;
        }
        if (this.m_ForcedSpeed[1] == 0 && this.m_IsLanded) {
            this.m_ForcedSpeed[1] = 0x460000;
        } else if (this.m_ForcedSpeed[1] == 0) {
            this.m_ForcedSpeed[1] = 0x140000;
        } else {
            this.m_ForcedSpeed[1] = (int)((long)this.m_ForcedSpeed[1] + (32768000L * (long)n >> 10));
            if (this.m_ForcedSpeed[1] > 0x1400000) {
                this.m_ForcedSpeed[1] = 0x1400000;
            }
        }
        if (this.m_IsLanded) {
            Game.Math_MulVector2D(m_coords1, this.m_ForcedSpeed, -this.m_Config[6]);
            Game.Math_AddVector2D(this.m_ForcedSpeed, this.m_ForcedSpeed, m_coords1);
            this.m_IsLanded = false;
            this.m_PhysicsY = this.m_Position[1];
        } else {
            this.m_ForcedSpeed[0] = this.m_ForcedSpeed[0] + Game.Math_MulFlt(this.m_ForcedSpeed[0], -this.m_Config[6] >> 3);
            this.m_PhysicsY = Math.min(this.m_Position[1], this.m_PhysicsY);
        }
        this.m_Position[0] = this.m_Position[0] + (this.m_ForcedSpeed[0] * n >> 10);
        this.m_Position[1] = this.m_Position[1] + (this.m_ForcedSpeed[1] * n >> 10);
    }

    void Physics_OnVerticalCollision(boolean bl) {
        this.m_ForcedSpeed[1] = 0;
        this.m_IsLanded = bl;
        if (0 == this.m_Class && this.m_IsLanded) {
            int n = this.m_Position[1] - this.m_PhysicsY;
            this.m_PhysicsY = this.m_Position[1];
            if (n > 0x960000) {
                int n2 = Game.Math_FltToInt(Game.Math_MulFlt(n - 0x960000, 65536));
                Game.Vibra_Play(1000);
                Game.Debug_Println("Height damage: " + n2);
                this.OnDamage(n2);
            }
        }
    }

    void Enemy_Init() {
        this.m_Enemy = Game.m_Enemies[0 + this.m_Type - 2];
        this.m_EnemyShootTimeout = 1000;
        if (this.m_Type == 4) {
            this.m_Flags |= 0x2800;
        }
        this.m_EnemyBulletsLoaded = 3;
    }

    void Enemy_Update(int n) {
        if (this.GetFastDistanceTo(Game.m_Player) > ENEMY_DISTANCE_ACTIVE && this.m_State == 0) {
            return;
        }
        switch (this.m_State) {
            case 1: 
            case 2: 
            case 3: {
                if (this.m_StateTime < Game.m_AnimationTimes[this.m_Config[1] + this.m_State]) break;
                this.SetState(0);
                break;
            }
            case 6: {
                this.Enemy_UpdateJump();
                break;
            }
            case 4: {
                this.Enemy_UpdateDeath(n);
                return;
            }
        }
        if (this.m_Route != null) {
            this.Enemy_UpdateFly(n);
        } else {
            this.StorePosition();
            if (0 != (this.m_Flags & 0x10)) {
                if (this.Enemy_UpdateWatch()) {
                    this.m_Flags &= 0xFFFFFFEF;
                }
            } else if (this.m_AuxInt > 0) {
                this.m_AuxInt -= n;
            } else {
                this.Enemy_UpdateFight(n);
            }
            if (this.m_Type == 4 && Game.m_Player.Player_IsTurbojetActive() && this.GetFastDistanceTo(Game.m_Player) < this.m_Enemy[2]) {
                this.OnDeath();
                this.m_Health = 0;
            }
            if (this.m_Type != 4) {
                this.Physics_Update(n);
                this.Collision_Update();
                this.TryKillByNonpassableArea();
                this.TryKillByDamageZone();
            }
        }
        this.UpdateScreenPosition();
        if (0 != (this.m_Flags & 0x20)) {
            this.Enemy_UpdateFalling();
        }
    }

    void Enemy_Render(Renderer renderer) {
        if (this.m_State == 6) {
            short[][] sArray = Game.m_AnimationClips[this.m_Config[1] + this.m_State];
            int n = Game.Math_AngleToDirectionFlt(this.m_Position[2], sArray.length, false);
            Game.Tile_Render(renderer, sArray[n][this.m_AuxState], this.m_ScreenX, this.m_ScreenY);
        } else {
            this.RenderState(renderer);
        }
    }

    void Enemy_UpdateJump() {
        switch (this.m_AuxState) {
            case 0: {
                if (this.m_StateTime <= 100) break;
                this.m_AuxState = 1;
                break;
            }
            case 1: {
                if (this.m_ForcedSpeed[1] < 0) break;
                this.m_AuxState = 2;
                this.m_StateTime = 0;
                break;
            }
            case 2: {
                if (this.m_StateTime <= 100) break;
                this.m_AuxState = 3;
                break;
            }
            case 3: {
                if (!this.m_IsLanded) break;
                switch (this.m_Type) {
                    case 5: {
                        Game.Sound_Play(16);
                    }
                }
                this.m_AuxState = 4;
                this.m_StateTime = 0;
                break;
            }
            case 4: {
                if (this.m_StateTime <= 100) break;
                this.SetState(0);
                this.m_Speed = 0;
            }
        }
    }

    void Enemy_UpdateFight(int n) {
        GameObject gameObject = Game.m_Player;
        if (this.m_EnemyBulletsLoaded == 0) {
            this.m_EnemyBulletsLoaded = 3;
        }
        if (0 != (gameObject.m_Flags & 2)) {
            return;
        }
        int n2 = this.GetFastDistanceTo(gameObject);
        int n3 = Math.abs(this.m_Position[0] - gameObject.m_Position[0]);
        if (this.m_Enemy[0] > 0) {
            switch (this.m_State) {
                case 0: {
                    this.Enemy_LookAt(gameObject);
                    if (n3 <= this.m_Enemy[2]) break;
                    if (this.m_Type != 5) {
                        this.m_Speed = this.m_Enemy[0];
                        this.SetState(5);
                        break;
                    }
                    if (n2 > ENEMY_DISTANCE_ACTIVE || !this.m_IsLanded || n3 < ENEMY_DISTANCE_JUMP) break;
                    this.m_ForcedSpeed[1] = -17039360;
                    this.m_ForcedSpeed[0] = this.m_Enemy[0];
                    if (this.m_Position[0] - gameObject.m_Position[0] > 0) {
                        this.m_ForcedSpeed[0] = -this.m_ForcedSpeed[0];
                    }
                    this.m_IsLanded = false;
                    this.SetState(6);
                    this.m_AuxState = 0;
                    break;
                }
                case 5: {
                    if (this.m_Enemy[3] != -1) {
                        this.m_EnemyShootTimeout = Math.max(this.m_EnemyShootTimeout - n, 0);
                    }
                    this.Enemy_LookAt(gameObject);
                    if (n3 > this.m_Enemy[2] && this.m_EnemyShootTimeout != 0) break;
                    this.m_Speed = 0;
                    this.SetState(0);
                    this.m_EnemyShootTimeout = 1000;
                }
            }
        }
        this.Move(n);
        switch (this.m_State) {
            case 0: {
                int n4;
                if (n2 < this.m_Enemy[2]) {
                    this.Enemy_AttackMelee(gameObject);
                    break;
                }
                int n5 = n4 = this.m_Type != 5 ? ENEMY_DISTANCE_FIRE + this.m_Config[3] : ENEMY_DISTANCE_JUMP;
                if (n2 >= n4) break;
                this.Enemy_Shoot(gameObject);
                break;
            }
        }
    }

    void Enemy_LookAt(GameObject gameObject) {
        this.m_Position[2] = gameObject.m_Position[0] > this.m_Position[0] ? 0 : 205888;
    }

    void Enemy_AttackMelee(GameObject gameObject) {
        this.Enemy_LookAt(gameObject);
        Game.Bullets_Create(this.m_Enemy[1], this.m_Position[0], this.m_Position[1], Game.Math_ArctanFlt(gameObject.m_Position[0] - this.m_Position[0], gameObject.m_Position[1] - this.m_Position[1]), this.m_ID);
        switch (this.m_Type) {
            case 5: {
                Game.Sound_Play(14);
                break;
            }
            case 4: {
                Game.Effects_Create(30, this.m_Position, null);
            }
        }
        this.m_AuxInt = this.m_Enemy[6];
        this.SetState(1);
    }

    void Enemy_Shoot(GameObject gameObject) {
        if (this.m_Enemy[3] == -1) {
            return;
        }
        this.Enemy_LookAt(gameObject);
        int n = this.m_Position[1] + this.m_Enemy[5] - gameObject.m_Position[1];
        if (Game.m_BulletTypes[this.m_Enemy[3]][7] == 0 ? Math.abs(n) > gameObject.m_Config[4] << 1 : n > gameObject.m_Config[4]) {
            return;
        }
        int n2 = this.m_Position[2] == 0 ? this.m_Enemy[4] : -this.m_Enemy[4];
        int n3 = this.m_Position[0] + n2;
        int n4 = this.m_Position[1] + this.m_Enemy[5];
        Game.Bullets_Create(this.m_Enemy[3], n3, n4, this.m_Position[2], this.m_ID);
        switch (this.m_Type) {
            case 3: {
                --this.m_EnemyBulletsLoaded;
                Game.Sound_Play(19);
                break;
            }
            case 5: {
                Game.Effects_Create(40, n3, n4, 0, this);
                Game.Sound_Play(15);
            }
        }
        this.m_AuxInt = this.m_Enemy[6];
        this.SetState(2);
    }

    void Enemy_UpdateFly(int n) {
        this.MoveOnRoute(n);
        if (this.GetFastDistanceTo(Game.m_Player) < this.m_Enemy[2]) {
            this.m_Speed = 0;
            this.CancelRoute(false);
            this.Enemy_AttackMelee(Game.m_Player);
        }
    }

    boolean Enemy_UpdateWatch() {
        if (this.GetFastDistanceTo(Game.m_Player) < this.m_Enemy[2] >> 1) {
            return true;
        }
        if (this.m_Position[2] == 0 ^ this.m_Position[0] < Game.m_Player.m_Position[0]) {
            return false;
        }
        return !Game.Terrain_IsIsectsWithSegment(this.m_Position, Game.m_Player.m_Position, null);
    }

    void Enemy_UpdateFalling() {
        if (0 != (this.m_Flags & 0x40)) {
            if (this.m_IsLanded) {
                this.OnDamage(this.m_Health);
                Game.Effects_Create(this.GetHitEffect(), this.m_Position, null);
            }
        } else if (!this.m_IsLanded) {
            this.m_Flags |= 0x40;
        }
    }

    void Enemy_UpdateDeath(int n) {
        this.StorePosition();
        this.Physics_Update(n);
        this.Collision_Update();
        this.UpdateScreenPosition();
        short s = Game.m_AnimationTimes[this.m_Config[1] + this.m_State];
        if (this.m_StateTime >= s) {
            this.m_StateTime = s - 1;
            this.m_AuxInt -= n;
            if (this.m_AuxInt < 0) {
                this.Enable(false);
            }
        }
    }

    void Enemy_OnDamage() {
        if (this.m_Route != null) {
            this.CancelRoute(false);
        }
        this.m_Flags &= 0xFFFFFFEF;
        this.m_Speed = 0;
        this.SetState(3);
    }

    void Enemy_OnDeath() {
        this.m_AuxInt = 2000;
        this.SetState(4);
        switch (this.m_Type) {
            case 5: {
                Game.Sound_Play(17);
            }
        }
    }

    void Enemy_OnRouteCompleted() {
        this.m_Speed = 0;
        this.SetState(0);
    }

    void EnemyScourge_Init() {
        this.m_Enemy = Game.m_Enemies[5];
        this.SetState(0);
    }

    void EnemyScourge_Update(int n) {
        switch (this.m_State) {
            case 1: 
            case 2: {
                if (this.m_StateTime < Game.m_AnimationTimes[this.m_Config[1] + this.m_State]) break;
                this.SetState(0);
                break;
            }
            case 3: {
                short s = Game.m_AnimationTimes[this.m_Config[1] + this.m_State];
                if (this.m_StateTime >= s) {
                    this.m_StateTime = s - 1;
                    this.m_AuxInt -= n;
                    if (this.m_AuxInt < 0) {
                        this.Enable(false);
                    }
                }
                return;
            }
        }
        this.m_AuxInt -= n;
        this.EnemyScourge_TryAttack(Game.m_Player);
        this.UpdateScreenPosition();
    }

    void EnemyScourge_OnDamage() {
        this.SetState(2);
    }

    void EnemyScourge_OnDeath() {
        this.m_AuxInt = 2000;
        this.SetState(3);
    }

    void EnemyScourge_TryAttack(GameObject gameObject) {
        if (this.m_AuxInt > 0) {
            return;
        }
        int n = this.GetFastDistanceTo(gameObject);
        if (n < ENEMY_DISTANCE_FIRE) {
            this.SetState(1);
            this.Enemy_LookAt(gameObject);
            Game.Bullets_Create(this.m_Enemy[1], this.m_Position[0], this.m_Position[1], this.m_Position[2] + (this.m_Position[2] > 102944 ? 45875 : -45875), this.m_ID);
        }
        this.m_AuxInt = this.m_Enemy[6];
    }

    void EnemyFlyer_Init() {
        this.m_Enemy = Game.m_Enemies[4];
        this.m_Flags |= 0x2400;
        this.InitRoute();
        this.m_EnemyFlyerZone = new int[4];
        int n = Math.abs(this.m_Route[0][0] - this.m_Route[1][0]);
        int n2 = Math.abs(this.m_Route[0][1] - this.m_Route[1][1]);
        this.m_EnemyFlyerZone[0] = Math.min(this.m_Route[0][0] - n, this.m_Route[1][0]);
        this.m_EnemyFlyerZone[2] = this.m_EnemyFlyerZone[0] + n * 2;
        this.m_EnemyFlyerZone[1] = Math.min(this.m_Route[0][1] - n2, this.m_Route[1][1]);
        this.m_EnemyFlyerZone[3] = this.m_EnemyFlyerZone[1] + n2 * 2;
    }

    boolean EnemyFlyer_IsPlayerInZone() {
        Game.m_frect2[0] = Game.m_Player.m_Position[0] - Game.m_Player.m_Config[3];
        Game.m_frect2[2] = Game.m_frect2[0] + Game.m_Player.m_Config[3] * 2;
        Game.m_frect2[1] = Game.m_Player.m_Position[1] - Game.m_Player.m_Config[4];
        Game.m_frect2[3] = Game.m_frect2[1] + Game.m_Player.m_Config[4] * 2;
        return Game.Math_IsIntersectsRect(this.m_EnemyFlyerZone, Game.m_frect2);
    }

    void EnemyFlyer_Update(int n) {
        if (this.m_StateTime >= Game.m_AnimationTimes[this.m_Config[1] + this.m_State]) {
            switch (this.m_State) {
                case 1: {
                    this.SetState(0);
                    break;
                }
                case 2: {
                    this.Enable(false);
                    return;
                }
            }
        }
        if (this.EnemyFlyer_IsPlayerInZone() && 0 == (Game.m_Player.m_Flags & 2)) {
            this.m_Speed = this.m_Enemy[0];
            this.SetDirection(Game.m_Player.m_Position[0] - this.m_Position[0], Game.m_Player.m_Position[1] - this.m_Position[1]);
        } else {
            this.m_Speed = this.m_Enemy[2] > this.GetFastDistanceTo(this.m_Route[0]) ? 0 : this.m_Enemy[0];
            this.SetDirection(this.m_Route[0][0] - this.m_Position[0], this.m_Route[0][1] - this.m_Position[1]);
        }
        if (this.m_AuxInt > 0) {
            this.m_AuxInt -= n;
        } else if (this.GetFastDistanceTo(Game.m_Player) < this.m_Enemy[2]) {
            this.Enemy_AttackMelee(Game.m_Player);
        }
        this.Move(n);
        this.UpdateScreenPosition();
    }

    void EnemyFlyer_OnDamage() {
        this.m_Speed = 0;
        this.SetState(1);
    }

    void EnemyFlyer_OnDeath() {
        this.m_AuxInt = 2000;
        this.SetState(2);
    }

    void EnemyMutantSoldier_Init() {
        this.m_Enemy = Game.m_Enemies[1];
        this.m_EnemyMutantSoldierHideMode = false;
        this.m_EnemyMutantSoldierAuxTime = 0;
        this.m_EnemyBulletsLoaded = 3;
        this.m_AuxState = 3;
        this.SetState(0);
    }

    void EnemyMutantSoldier_Update(int n) {
        if (this.GetFastDistanceTo(Game.m_Player) > ENEMY_DISTANCE_ACTIVE) {
            return;
        }
        switch (this.m_State) {
            case 2: {
                if (this.m_StateTime >= Game.m_AnimationTimes[this.m_Config[1] + this.m_State] && this.m_EnemyBulletsLoaded > 0) {
                    this.m_AuxInt = 0;
                }
            }
            case 1: 
            case 3: {
                if (this.m_StateTime >= Game.m_AnimationTimes[this.m_Config[1] + this.m_State]) {
                    this.SetState(3 == this.m_State ? this.m_StateLast : 0);
                }
            }
            case 0: {
                this.m_EnemyMutantSoldierAuxTime += n;
                break;
            }
            case 5: {
                this.m_EnemyMutantSoldierAuxTime += n;
                this.EnemyMutantSoldier_UpdateHide(n);
                break;
            }
            case 4: {
                this.Enemy_UpdateDeath(n);
                return;
            }
        }
        this.StorePosition();
        if (0 != (this.m_Flags & 0x10)) {
            if (this.Enemy_UpdateWatch()) {
                this.m_Flags &= 0xFFFFFFEF;
            }
        } else if (this.m_AuxInt > 0) {
            this.m_AuxInt -= n;
        } else {
            this.EnemyMutantSoldier_UpdateFight(n);
        }
        this.Physics_Update(n);
        this.Collision_Update();
        this.TryKillByNonpassableArea();
        this.TryKillByDamageZone();
        this.UpdateScreenPosition();
        if (0 != (this.m_Flags & 0x20)) {
            this.Enemy_UpdateFalling();
        }
    }

    void EnemyMutantSoldier_UpdateFight(int n) {
        GameObject gameObject = Game.m_Player;
        if (0 != (gameObject.m_Flags & 2)) {
            return;
        }
        int n2 = this.GetFastDistanceTo(gameObject);
        int n3 = ENEMY_DISTANCE_FIRE + this.m_Config[3];
        switch (this.m_State) {
            case 0: {
                if (n2 < this.m_Enemy[2]) {
                    this.Enemy_AttackMelee(gameObject);
                    Game.Sound_Play(13);
                    break;
                }
                switch (this.m_AuxState) {
                    case 3: {
                        if (this.m_EnemyMutantSoldierAuxTime > 1500) {
                            this.m_EnemyMutantSoldierAuxTime = 0;
                            this.m_AuxState = 1;
                            break;
                        }
                        this.Enemy_LookAt(gameObject);
                        break;
                    }
                    case 2: {
                        if (this.m_EnemyMutantSoldierAuxTime < 2000) break;
                        this.m_EnemyMutantSoldierAuxTime = 0;
                        if (this.m_EnemyMutantSoldierHideMode) {
                            this.m_AuxState = 0;
                            this.SetState(5);
                            this.SetType(45);
                        } else {
                            this.m_AuxState = 1;
                            this.SetState(0);
                            this.SetType(3);
                        }
                        return;
                    }
                    case 1: {
                        if (this.m_EnemyBulletsLoaded <= 0) {
                            this.m_EnemyBulletsLoaded = 3;
                            this.m_EnemyMutantSoldierAuxTime = 0;
                            this.m_AuxState = 2;
                            this.SetState(0);
                            this.SetType(3);
                            return;
                        }
                        if (n2 >= n3) break;
                        this.Enemy_Shoot(gameObject);
                    }
                }
                break;
            }
            case 5: {
                if (0 == this.m_AuxState || n2 >= this.m_Enemy[2] && n2 >= n3) break;
                this.SetState(0);
                this.m_EnemyMutantSoldierAuxTime = 0;
            }
        }
    }

    void EnemyMutantSoldier_UpdateHide(int n) {
        if (this.m_EnemyMutantSoldierAuxTime >= 3000) {
            this.m_EnemyMutantSoldierAuxTime = 0;
            this.m_AuxState = 1;
            this.SetState(0);
            this.SetType(3);
        }
    }

    void EnemyMutantSoldier_OnDamage() {
        this.SetState(3);
    }

    void EnemyMutantSoldier_OnDeath() {
        Game.Sound_Play(18);
        this.m_AuxInt = 2000;
        this.SetState(4);
    }

    void EnemyMutantSoldier_Hide(boolean bl) {
        this.m_EnemyMutantSoldierHideMode = bl;
        this.m_AuxState = 3;
        this.SetState(this.m_EnemyMutantSoldierHideMode ? 5 : 0);
    }

    void ContextKiller_Init() {
        this.m_Flags |= 8;
        this.InitRoute();
        int n = Game.Route_GetDirection(Game.m_Routes[this.m_RouteID], 0, 0);
        Game.Math_PolarToOrthogonalFlt(n, this.m_Config[3] * 2);
        this.m_AuxInt = this.m_Position[0] - Game.ret_rPolarToOrthogonal_rX;
    }

    void ContextKiller_Update(int n) {
        switch (this.m_State) {
            case 1: {
                this.MoveOnRoute(n);
                for (int i = 1; i < Game.m_Objects.length; ++i) {
                    GameObject gameObject = Game.m_Objects[i];
                    if (gameObject == this || 0 != (gameObject.m_Flags & 3) || this.GetFastDistanceTo(gameObject) > this.m_Config[3] + gameObject.m_Config[3]) continue;
                    gameObject.OnDamage(gameObject.m_Health);
                    this.ContextKiller_CreateHitEffect(gameObject);
                }
                break;
            }
            case 2: {
                if (this.m_StateTime < Game.m_AnimationTimes[this.m_Config[1] + this.m_State]) break;
                this.Enable(false);
            }
        }
    }

    boolean ContextKiller_CanBeActivated() {
        return Game.m_Player.HitTestWorld(this.m_AuxInt, this.m_Position[1]);
    }

    void ContextKiller_CreateHitEffect(GameObject gameObject) {
        int n = gameObject.GetHitEffect();
        if (n == -1) {
            return;
        }
        GameObject.m_coords1[0] = gameObject.m_Position[0] + this.m_Position[0] >> 1;
        GameObject.m_coords1[1] = gameObject.m_Position[1] + this.m_Position[1] >> 1;
        GameObject.m_coords1[2] = 0;
        Game.Effects_Create(n, m_coords1, null);
    }

    void ContextKiller_OnActivate() {
        this.m_Flags |= 4;
        this.m_Flags &= 0xFFFFFFF7;
        this.m_IsLanded = false;
        this.m_Speed = 0x640000;
        this.SetState(1);
    }

    void ContextKiller_OnRouteCompleted() {
        this.m_Speed = 0;
        this.SetState(2);
        this.OnDeath();
    }

    void Missile_Init() {
        this.m_Flags |= 8;
        this.m_State = 0;
    }

    void Missile_Update(int n) {
        switch (this.m_State) {
            case 1: {
                this.Physics_Update(n);
                this.UpdateScreenPosition();
                for (int i = 1; i < Game.m_Objects.length; ++i) {
                    GameObject gameObject = Game.m_Objects[i];
                    if (gameObject.m_ID == this.m_ID || !gameObject.IsEnabled() || this.GetFastDistanceTo(gameObject) > this.m_Config[3] + gameObject.m_Config[3]) continue;
                    if (gameObject.m_Config[5] > 0) {
                        Game.Math_MulVector2D(m_coords1, this.m_ForcedSpeed, this.m_Config[5]);
                        Game.Math_DivVector2D(m_coords1, m_coords1, gameObject.m_Config[5]);
                        gameObject.m_ForcedSpeed[0] = gameObject.m_ForcedSpeed[0] + m_coords1[0];
                        gameObject.m_ForcedSpeed[1] = gameObject.m_ForcedSpeed[1] + m_coords1[1];
                    }
                    gameObject.OnDamage(2000);
                    this.ContextKiller_CreateHitEffect(gameObject);
                    this.OnDeath();
                    return;
                }
                if (!Game.Terrain_IsPositionBlocked(this.m_Position[0], this.m_Position[1], this.m_Config[3], this.m_Config[4])) break;
                this.OnDeath();
                break;
            }
            case 2: {
                if (this.m_StateTime < Game.m_AnimationTimes[this.m_Config[1] + this.m_State]) break;
                this.Enable(false);
            }
        }
    }

    boolean Missile_CanBeTaken() {
        return this.GetFastDistanceTo(Game.m_Player) < Game.m_Player.m_Config[3] + this.m_Config[3] * 3 / 2;
    }

    void Missile_OnTake() {
        this.m_Flags |= 4;
        this.m_Flags &= 0xFFFFFFF7;
    }

    void Missile_OnThrow() {
        this.SetState(1);
    }

    void Missile_OnDeath() {
        this.SetState(2);
        if (this.m_Type != 26) {
            return;
        }
        Game.Effects_Create(22, this.m_Position, null);
        Game.Sound_Play(7);
        for (int i = 0; i < Game.m_Objects.length; ++i) {
            GameObject gameObject = Game.m_Objects[i];
            if (gameObject.m_ID == this.m_ID || !gameObject.IsEnabled() || this.GetFastDistanceTo(gameObject) > 0x1E0000 + gameObject.m_Config[3] + this.m_Config[3]) continue;
            if (gameObject.m_Config[5] > 0) {
                Game.Math_MulVector2D(m_coords1, this.m_ForcedSpeed, this.m_Config[5]);
                Game.Math_DivVector2D(m_coords1, m_coords1, gameObject.m_Config[5]);
                gameObject.m_ForcedSpeed[0] = gameObject.m_ForcedSpeed[0] - m_coords1[0];
                gameObject.m_ForcedSpeed[1] = gameObject.m_ForcedSpeed[1] + m_coords1[1];
            }
            gameObject.OnDamage(2000);
            this.ContextKiller_CreateHitEffect(gameObject);
        }
    }

    void Emitter_Init() {
        for (int i = 0; i < Game.m_Emitters.length; ++i) {
            if (Game.m_Emitters[i][0] != this.m_Type) continue;
            this.m_AuxInt = i;
            return;
        }
    }

    void Emitter_Update(int n) {
        if (Math.abs(this.m_ScreenX - Game.m_CameraX) > Game.m_realWidthDouble || Math.abs(this.m_ScreenY - Game.m_CameraY) > Game.m_realHeightDouble) {
            return;
        }
        int[] nArray = Game.m_Emitters[this.m_AuxInt];
        if (this.m_StateTime > nArray[2]) {
            Game.Effects_Create(nArray[1], this.m_Position, null);
            this.m_StateTime = 0;
        }
    }

    int Collision_Update() {
        int n = this.Collision_GetCorrectedPosition(this.m_PositionLast, this.m_Position, m_coords1);
        GameObject gameObject = Game.m_Objects[m_CollisionObject];
        if (n <= 0) {
            return 0;
        }
        if ((this.m_Flags & 0x1000) != 0) {
            if (m_CollisionIntersection == 2) {
                int n2 = this.m_PositionLast[1] - this.m_Position[1];
                int n3 = this.m_PositionLast[0] - this.m_Position[0];
                while (m_CollisionIntersection == 2) {
                    gameObject.StorePosition();
                    gameObject.m_Position[0] = gameObject.m_Position[0] - n3;
                    gameObject.m_Position[1] = gameObject.m_Position[1] - n2;
                    gameObject.OnPushed();
                    n = this.Collision_GetCorrectedPosition(this.m_PositionLast, this.m_Position, m_coords1);
                    gameObject = Game.m_Objects[m_CollisionObject];
                }
                return 0;
            }
            if (m_CollisionIntersection == 1) {
                return 0;
            }
        } else if ((gameObject.m_Flags & 0x1000) != 0 && m_CollisionIntersection == 2) {
            if (Game.Math_IsAngleInRangeFlt(gameObject.m_Position[2], 0, 205888) || gameObject.m_Position[2] == 0) {
                this.m_Position[0] = this.m_Position[0] - (gameObject.m_PositionLast[0] - gameObject.m_Position[0]);
            }
        } else if ((this.m_Flags & 0x4000) != 0 && m_CollisionIntersection == 2 && (gameObject.m_Flags & 0x8000) != 0) {
            gameObject.StorePosition();
            gameObject.m_Position[0] = gameObject.m_Position[0] - (this.m_PositionLast[0] - this.m_Position[0]);
            gameObject.Collision_GetCorrectedPosition(gameObject.m_PositionLast, gameObject.m_Position, m_coords6);
            if (gameObject.m_Position[0] == m_coords6[0]) {
                this.m_Flags |= 0x10000;
            }
            gameObject.m_Position[0] = m_coords6[0];
        } else {
            this.m_Flags &= 0xFFFEFFFF;
        }
        int n4 = this.m_Position[1];
        Game.Math_SubVector2D(m_coords2, this.m_Position, m_coords1);
        Game.Math_CopyVector2D(this.m_Position, m_coords1);
        boolean bl = true;
        int n5 = Integer.MAX_VALUE;
        for (int i = 0; i < COLLISION_SlidingVectors.length; ++i) {
            int n6 = Game.Math_GetDotProduct2D(COLLISION_SlidingVectors[i], m_coords2);
            if (n6 <= 0) continue;
            Game.Math_MulVector2D(m_coords3, COLLISION_SlidingVectors[i], n6);
            Game.Math_AddVector2D(m_coords4, m_coords1, m_coords3);
            int n7 = this.Collision_GetCorrectedPosition(m_coords1, m_coords4, m_coords3);
            if (n7 >= n6 || n7 >= n5) continue;
            Game.Math_CopyVector2D(this.m_Position, m_coords3);
            n5 = n7;
            if (0 != n7) continue;
            bl = false;
            break;
        }
        if (n4 != this.m_Position[1]) {
            this.Physics_OnVerticalCollision(n4 > this.m_Position[1]);
        }
        return m_CollisionIntersection;
    }

    int Collision_GetCorrectedPosition(int[] nArray, int[] nArray2, int[] nArray3) {
        if (nArray[0] == nArray2[0] && nArray[1] == nArray2[1]) {
            return 0;
        }
        int n = Game.Math_GetMagnitudeFast2DFlt(nArray[0] - nArray2[0], nArray[1] - nArray2[1]);
        int n2 = this.m_Class == 18 ? 1 : 4;
        int n3 = Math.min(Game.m_PassCellW, Game.m_PassCellH);
        int n4 = (n + n3 - 1) / n3 * n2;
        if (null != nArray3) {
            Game.Math_CopyVector2D(nArray3, nArray);
        }
        for (int i = n2; i <= n4; i += n2) {
            Game.Math_InterpolateVector2D(m_coords5, nArray, nArray2, 0, n4, i);
            m_CollisionIntersection = 0;
            if (Game.Terrain_IsPositionBlocked(m_coords5[0], m_coords5[1], this.m_Config[3], this.m_Config[4])) {
                m_CollisionIntersection = 1;
            }
            this.m_Flags |= Integer.MIN_VALUE;
            GameObject gameObject = Game.Geometry_GetObject(m_coords5[0], m_coords5[1], this.m_Config[3], this.m_Config[4], (this.m_Flags & 0x9000) != 0 ? 0 : 8, 0x80020003 | ((this.m_Flags & 0x9000) != 0 ? 8192 : 0));
            this.m_Flags &= Integer.MAX_VALUE;
            if (null != gameObject) {
                m_CollisionObject = gameObject.m_ID;
                m_CollisionIntersection = 2;
            }
            if (0 != m_CollisionIntersection) {
                if (n2 == 1) {
                    return n - (i - 1) * n / n4;
                }
                i -= n2;
                n2 = 1;
                continue;
            }
            if (null == nArray3) continue;
            Game.Math_CopyVector2D(nArray3, m_coords5);
        }
        return 0;
    }

    void LightSource_Render(Renderer renderer) {
    }

    void Boss_Init() {
        m_BossIsActive = false;
        switch (this.m_Type) {
            case 20: {
                m_BossTileset = 7;
                m_BossPalette = 7;
                this.BossOctopus_Init();
                break;
            }
            case 21: {
                m_BossTileset = 2;
                m_BossPalette = 6;
                this.BossDeceiver_Init();
                break;
            }
            case 34: {
                m_BossTileset = 20;
                m_BossPalette = 5;
                this.BossMembranus_Init();
            }
        }
    }

    void Boss_Shutdown() {
    }

    void Boss_Activate() {
        this.Enable(true);
        m_BossIsActive = true;
        switch (this.m_Type) {
            case 20: {
                this.BossOctopus_Activate();
                break;
            }
            case 21: {
                this.BossDeceiver_Activate();
                break;
            }
            case 34: {
                this.BossMembranus_Activate();
            }
        }
    }

    int Boss_GetHealth() {
        switch (this.m_Type) {
            case 34: {
                return this.BossMembranus_GetHealth();
            }
        }
        return this.m_Health;
    }

    int Boss_GetTotalHealth() {
        switch (this.m_Type) {
            case 34: {
                return this.BossMembranus_GetTotalHealth();
            }
        }
        return this.m_Config[2];
    }

    void Boss_Update(int n) {
        m_BossBlinkTimer = Math.max(m_BossBlinkTimer - n, 0);
        if (m_BossIsActive) {
            switch (this.m_Type) {
                case 20: {
                    this.BossOctopus_Update(n);
                    break;
                }
                case 21: {
                    this.BossDeceiver_Update(n);
                    break;
                }
                case 34: {
                    this.BossMembranus_Update(n);
                }
            }
        }
    }

    void Boss_Render(Renderer renderer) {
        switch (this.m_Type) {
            default: 
        }
        if (!Boxal.bInfSimplePalette && m_BossBlinkTimer > 0 && m_BossBlinkTimer / 50 % 2 == 0) {
            Game.Palette_Select(m_BossTileset, m_BossPalette);
        }
        this.RenderState(renderer);
        if (!Boxal.bInfSimplePalette && m_BossBlinkTimer > 0 && m_BossBlinkTimer / 50 % 2 == 0) {
            Game.Palette_Select(m_BossTileset, 0);
        }
    }

    void Boss_OnDamage(int n) {
        m_BossBlinkTimer = 200;
        switch (this.m_Type) {
            case 20: {
                this.BossOctopus_OnDamage(n);
            }
        }
    }

    void Boss_OnDeath() {
        switch (this.m_Type) {
            case 20: {
                this.BossOctopus_OnDeath();
                break;
            }
            case 21: {
                this.BossDeceiver_OnDeath();
                break;
            }
            case 34: {
                this.BossMembranus_OnDeath();
            }
        }
    }

    void BossOctopus_Init() {
        BossOctopus = this;
    }

    void BossOctopus_Activate() {
        int n;
        int n2;
        for (n2 = 0; n2 < Game.m_Objects.length; ++n2) {
            for (n = n2 + 1; n < Game.m_Objects.length; ++n) {
                if (Game.m_Objects[n2].m_Class != 17 || Game.m_Objects[n].m_Class != 17 || Game.m_Objects[n2].m_Tag != Game.m_Objects[n].m_Tag || Game.m_Objects[n2].m_Position[1] <= Game.m_Objects[n].m_Position[1]) continue;
                GameObject gameObject = Game.m_Objects[n2];
                Game.m_Objects[n2] = Game.m_Objects[n];
                Game.m_Objects[n] = gameObject;
            }
        }
        this.m_OctopusTentacleTimeOuts = new int[this.m_Tag];
        this.m_OctopusTentacleIsDirectionUp = new boolean[this.m_Tag];
        for (n2 = 0; n2 < this.m_Tag; ++n2) {
            this.m_OctopusTentacleTimeOuts[n2] = -1;
            this.m_OctopusTentacleIsDirectionUp[n2] = true;
        }
        this.m_OctopusTentacles = new GameObject[this.m_Tag][];
        int[] nArray = new int[this.m_Tag];
        for (n = 0; n < Game.m_Objects.length; ++n) {
            if (Game.m_Objects[n].m_Class != 17) continue;
            int n3 = Game.m_Objects[n].m_Tag;
            nArray[n3] = nArray[n3] + 1;
            Game.m_Objects[n].Enable(false);
        }
        for (n = 0; n < this.m_Tag; ++n) {
            this.m_OctopusTentacles[n] = new GameObject[nArray[n]];
            int n4 = 0;
            for (int i = 0; i < Game.m_Objects.length; ++i) {
                if (Game.m_Objects[i].m_Class != 17 || Game.m_Objects[i].m_Tag != n) continue;
                this.m_OctopusTentacles[n][n4] = Game.m_Objects[i];
                ++n4;
            }
            this.m_OctopusTentacles[n][this.m_OctopusTentacles[n].length - 1].Enable(true);
        }
    }

    void BossOctopus_Update(int n) {
        int n2;
        int n3;
        short s = Game.m_AnimationTimes[this.m_Config[1] + this.m_State];
        if (this.m_StateTime >= s) {
            switch (this.m_State) {
                case 1: {
                    this.SetState(0);
                    break;
                }
                case 2: {
                    if (this.BossOctopus_AreTenteclesDown()) {
                        this.BossOctopus_EnableTentecles(false);
                        this.Enable(false);
                        return;
                    }
                    this.m_StateTime = s - 1;
                }
            }
        }
        if (this.m_OctopusTentacleAttackTimeOut > 0) {
            this.m_OctopusTentacleAttackTimeOut -= n;
        }
        if (this.m_State != 2) {
            block4: for (n3 = 0; n3 < this.m_Tag; ++n3) {
                if (this.m_OctopusTentacles[n3][this.m_OctopusTentacles[n3].length - 1].m_State == 3 || this.m_OctopusTentacleTimeOuts[n3] >= 0) continue;
                for (n2 = 0; n2 < this.m_OctopusTentacles[n3].length; ++n2) {
                    if (this.m_OctopusTentacles[n3][n2].GetFastDistanceTo(Game.m_Player) > 0x230000) continue;
                    this.m_OctopusTentacleTimeOuts[n3] = 250;
                    this.m_OctopusTentacles[n3][this.m_OctopusTentacles[n3].length - 1].SetState(1);
                    continue block4;
                }
            }
        }
        block6: for (n3 = 0; n3 < this.m_Tag; ++n3) {
            if (this.m_OctopusTentacleTimeOuts[n3] < 0) continue;
            int n4 = n3;
            this.m_OctopusTentacleTimeOuts[n4] = this.m_OctopusTentacleTimeOuts[n4] - n;
            if (this.m_OctopusTentacleTimeOuts[n3] >= 0) continue;
            if (this.m_OctopusTentacleIsDirectionUp[n3]) {
                for (n2 = this.m_OctopusTentacles[n3].length - 1; n2 >= 0; --n2) {
                    if (!this.m_OctopusTentacles[n3][n2].IsEnabled()) {
                        this.m_OctopusTentacles[n3][n2].Enable(true);
                        this.m_OctopusTentacleTimeOuts[n3] = 250;
                        continue block6;
                    }
                    if (n2 != 0 || this.m_OctopusTentacles[n3][this.m_OctopusTentacles[n3].length - 1].m_State == 3) continue;
                    this.m_OctopusTentacleIsDirectionUp[n3] = false;
                    this.m_OctopusTentacles[n3][this.m_OctopusTentacles[n3].length - 1].SetState(2);
                    this.m_OctopusTentacleTimeOuts[n3] = 250;
                }
                continue;
            }
            for (n2 = 0; n2 < this.m_OctopusTentacles[n3].length - 1; ++n2) {
                if (this.m_OctopusTentacles[n3][n2].IsEnabled()) {
                    this.m_OctopusTentacles[n3][n2].Enable(false);
                    this.m_OctopusTentacleTimeOuts[n3] = 250;
                    continue block6;
                }
                if (n2 != this.m_OctopusTentacles[n3].length - 2) continue;
                this.m_OctopusTentacleIsDirectionUp[n3] = true;
            }
        }
    }

    boolean BossOctopus_AreTenteclesDown() {
        for (int i = 0; i < this.m_Tag; ++i) {
            if (!this.m_OctopusTentacles[i][this.m_OctopusTentacles[i].length - 2].IsEnabled()) continue;
            return false;
        }
        return true;
    }

    void BossOctopus_EnableTentecles(boolean bl) {
        for (int i = 0; i < this.m_Tag; ++i) {
            for (int j = 0; j < this.m_OctopusTentacles[i].length; ++j) {
                this.m_OctopusTentacles[i][j].Enable(bl);
            }
        }
    }

    void BossOctopus_OnDeath() {
        this.SetState(2);
    }

    void BossOctopus_OnDamage(int n) {
        this.SetState(1);
    }

    void OctopusTentacle_Init() {
        this.m_OctopusTentacleAttackTimeOut = 0;
        this.SetState(0);
    }

    void OctopusTentacle_Update(int n) {
        if (this.m_Config[1] != -1 && this.m_StateTime >= Game.m_AnimationTimes[this.m_Config[1] + this.m_State] && (this.m_State == 2 || this.m_State == 3)) {
            this.SetState(0);
        }
        if (GameObject.BossOctopus.m_OctopusTentacleAttackTimeOut > 0 || GameObject.BossOctopus.m_State == 1) {
            return;
        }
        if (this.GetFastDistanceTo(Game.m_Player) < 0x230000) {
            Game.Bullets_Create(14, this.m_Position[0], this.m_Position[1], Game.Math_ArctanFlt(Game.m_Player.m_Position[0] - this.m_Position[0], Game.m_Player.m_Position[1] - this.m_Position[1]), this.m_ID);
            Game.Sound_Play(13);
            GameObject.BossOctopus.m_OctopusTentacleAttackTimeOut = 2000;
        }
    }

    void OctopusTentacle_OnDamage(int n) {
        this.m_Health += n;
        BossOctopus.OnDamage(n);
        this.SetState(3);
    }

    void BossDeceiver_Init() {
        m_BD_NeedRegen = false;
        this.m_Route = null;
        DECEIVER_ESCAPE_DISTANCE = Math.max(Game.m_realWidthDouble, Game.m_realHeightDouble) / 4;
    }

    void BossDeceiver_Activate() {
    }

    void BossDeceiver_Update(int n) {
        if (0 == (this.m_Flags & 2)) {
            this.BossDeceiver_Regenerate(n);
        }
        if (this.GetFastDistanceTo(Game.m_Player) > ENEMY_DISTANCE_ACTIVE) {
            return;
        }
        switch (this.m_State) {
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                if (this.m_StateTime < Game.m_AnimationTimes[this.m_Config[1] + this.m_State]) break;
                if (this.m_Route == null) {
                    this.m_Speed = 0;
                    this.SetState(0);
                    break;
                }
                this.m_Speed = 0x640000;
                this.SetState(7);
                break;
            }
            case 6: {
                this.Enemy_UpdateJump();
            }
            case 7: {
                Game.m_coords12[0] = this.m_Position[0] + (this.m_Position[2] == 0 ? -655360 : 655360);
                Game.m_coords12[1] = this.m_Position[1] + 655360;
                Game.m_coords12[2] = 0;
                Game.Effects_Create(9, Game.m_coords12, this);
                break;
            }
            case 4: {
                this.Enemy_UpdateDeath(n);
                return;
            }
        }
        if (this.m_Route != null) {
            this.MoveOnRoute(n);
            this.Enemy_LookAt(Game.m_Player);
            if (this.m_AuxInt > 0) {
                this.m_AuxInt -= n;
            } else {
                this.BossDeceiver_Shoot(Game.m_Player);
            }
        } else {
            this.StorePosition();
            if (0 != (this.m_Flags & 0x10)) {
                if (this.BossDeceiver_UpdateWatch() == 1) {
                    this.m_Flags &= 0xFFFFFFEF;
                }
            } else if (this.m_AuxInt > 0) {
                this.m_AuxInt -= n;
                this.BossDeceiver_UpdateFight(n, true);
            } else {
                this.BossDeceiver_UpdateFight(n, false);
            }
            this.Physics_Update(n);
            this.Collision_Update();
            this.UpdateScreenPosition();
        }
    }

    void BossDeceiver_OnDeath() {
        this.Enemy_OnDeath();
    }

    void BossDeceiver_OnRouteCompleted() {
        if (Math.abs(Game.m_Player.m_Position[1] - this.m_Position[1]) < Game.m_Player.m_Config[4] << 1 && !Game.m_Player.m_IsLanded) {
            this.BossDeceiver_InitRoute(m_BD_HealthFlt >= 0x2EE0000 ? 0 : 2, Game.m_Player);
            this.m_Speed = 0x640000;
            this.SetState(7);
        } else if (m_BD_HealthFlt <= 0x2EE0000) {
            this.BossDeceiver_InitRoute(1, Game.m_Player);
        } else if (Math.abs(Game.m_Player.m_Position[1] - this.m_Position[1]) > Game.m_Player.m_Config[4] << 1 && m_BD_RouteType != 3) {
            this.BossDeceiver_InitRoute(3, Game.m_Player);
        } else {
            this.CancelRoute(false);
            this.m_Speed = 0;
            this.SetState(0);
        }
    }

    void BossDeceiver_Regenerate(int n) {
        m_BD_HealthFlt = this.m_Health << 16;
        if (m_BD_HealthFlt > 0x2EE0000 && !m_BD_NeedRegen) {
            return;
        }
        m_BD_NeedRegen = true;
        this.m_Health = (m_BD_HealthFlt += n * 0x320000 >> 10) >> 16;
        if (this.m_Health >= this.m_Config[2]) {
            m_BD_NeedRegen = false;
            this.m_Health = this.m_Config[2];
            m_BD_HealthFlt = this.m_Health << 16;
        }
        if (this.m_Route == null && m_BD_HealthFlt < 0x2EE0000) {
            this.BossDeceiver_InitRoute(2, Game.m_Player);
            this.m_Speed = 0x640000;
            this.SetState(7);
        }
    }

    void BossDeceiver_UpdateFight(int n, boolean bl) {
        GameObject gameObject = Game.m_Player;
        if (0 != (gameObject.m_Flags & 2)) {
            return;
        }
        int n2 = this.GetFastDistanceTo(gameObject);
        int n3 = Math.abs(this.m_Position[0] - gameObject.m_Position[0]);
        int n4 = Math.abs(this.m_Position[1] - gameObject.m_Position[1]);
        int n5 = this.BossDeceiver_UpdateWatch();
        switch (this.m_State) {
            case 0: {
                this.Enemy_LookAt(gameObject);
                if (n5 == 2) {
                    this.m_Speed = 0x640000;
                    this.BossDeceiver_InitRoute(0, gameObject);
                    this.SetState(7);
                }
                if (n3 >= 0x280000) {
                    this.m_Speed = 0x500000;
                    this.SetState(5);
                }
                if (n5 != 4) break;
                this.m_ForcedSpeed[1] = -17039360;
                this.m_ForcedSpeed[0] = this.m_Position[0] - gameObject.m_Position[0] > 0 ? -5242880 : 0x500000;
                this.m_IsLanded = false;
                this.SetState(6);
                this.m_AuxState = 0;
                break;
            }
            case 5: {
                this.Enemy_LookAt(gameObject);
                if (n3 > 0x280000 && n4 < this.m_Config[4]) break;
                this.m_Speed = 0;
                this.SetState(0);
            }
        }
        this.Move(n);
        this.UpdateScreenPosition();
        if (bl) {
            return;
        }
        switch (this.m_State) {
            case 0: {
                if (n2 < 0x280000) {
                    this.BossDeceiver_Melee(Game.m_Player);
                    break;
                }
                if (n2 >= ENEMY_DISTANCE_FIRE + this.m_Config[3] || n5 == 3) break;
                this.BossDeceiver_Shoot(Game.m_Player);
            }
        }
    }

    void BossDeceiver_Melee(GameObject gameObject) {
        this.Enemy_LookAt(gameObject);
        Game.Bullets_Create(15, this.m_Position[0], this.m_Position[1], Game.Math_ArctanFlt(gameObject.m_Position[0] - this.m_Position[0], gameObject.m_Position[1] - this.m_Position[1]), this.m_ID);
        Game.Sound_Play(13);
        this.m_AuxInt = 500;
        this.SetState(1);
    }

    void BossDeceiver_Shoot(GameObject gameObject) {
        this.Enemy_LookAt(gameObject);
        int n = this.m_Position[1] + -1310720 - gameObject.m_Position[1];
        if (Math.abs(n) > gameObject.m_Config[4] << 1) {
            return;
        }
        Game.Bullets_Create(13, this.m_Position[0] + (this.m_Position[2] == 0 ? 655360 : -655360), this.m_Position[1] + -1310720, this.m_Position[2], this.m_ID);
        Game.Sound_Play(29);
        this.m_AuxInt = 1500;
        this.SetState(this.m_Route == null ? 2 : 8);
    }

    int BossDeceiver_UpdateWatch() {
        if (this.m_Position[2] == 0 ^ this.m_Position[0] < Game.m_Player.m_Position[0]) {
            return 0;
        }
        if (Game.m_Player.m_Position[1] - this.m_Position[1] < -Game.m_Player.m_Config[4]) {
            return 2;
        }
        if (Game.m_Player.m_Position[1] - this.m_Position[1] > Game.m_Player.m_Config[4] && Game.m_Player.m_IsLanded && this.m_State == 7) {
            return 5;
        }
        if (Math.abs(Game.m_Player.m_Position[1] - this.m_Position[1]) < Game.m_Player.m_Config[4] && this.m_IsLanded && Game.m_Player.m_IsLanded && (Game.m_Player.m_State == 18 || Game.m_Player.m_State == 19) && Math.abs(Game.m_Player.m_Position[0] - this.m_Position[0]) > ENEMY_DISTANCE_JUMP || this.m_IsLanded && Game.m_Player.m_IsLanded && Math.abs(Game.m_Player.m_Position[1] - this.m_Position[1]) > Game.m_Player.m_Config[4] << 1) {
            return 4;
        }
        if (Game.m_Player.m_State == 18 || Game.m_Player.m_State == 19) {
            return 3;
        }
        return 1;
    }

    void BossDeceiver_InitRoute(int n, GameObject gameObject) {
        int n2;
        m_BD_RouteType = n;
        int n3 = n == 0 ? 3 : 2;
        int[][] nArray = new int[n3][5];
        nArray[0][0] = this.m_Position[0];
        nArray[0][1] = this.m_Position[1];
        int n4 = Math.abs(gameObject.m_Config[4] - this.m_Config[4]) << 1;
        boolean bl = !Game.Terrain_IsPositionBlocked(this.m_Position[0], gameObject.m_Position[1] - n4 - 327680, this.m_Config[3], this.m_Config[4]);
        switch (n) {
            case 0: {
                for (n2 = 1; n2 < nArray.length - 1; ++n2) {
                    if (bl) {
                        nArray[n2][0] = this.m_Position[0];
                        nArray[n2][1] = gameObject.m_Position[1] - n4 - 327680;
                        continue;
                    }
                    nArray[n2][1] = this.m_Position[1];
                    nArray[n2][0] = gameObject.m_Position[0];
                }
                break;
            }
        }
        switch (n) {
            case 0: {
                if (bl) {
                    nArray[nArray.length - 1][0] = gameObject.m_Position[0] + (this.m_Position[0] > gameObject.m_Position[0] ? 0x280000 : -2621440);
                    nArray[nArray.length - 1][1] = gameObject.m_Position[1] - n4 - 327680;
                    break;
                }
                nArray[nArray.length - 1][0] = gameObject.m_Position[0];
                nArray[nArray.length - 1][1] = gameObject.m_Position[1];
                break;
            }
            case 1: {
                nArray[nArray.length - 1][0] = this.m_Position[0];
                nArray[nArray.length - 1][1] = this.m_Position[1];
                break;
            }
            case 2: {
                n2 = this.m_Config[4] << 1;
                int n5 = n2 + this.m_Config[4];
                nArray[nArray.length - 1][0] = this.m_Position[0];
                nArray[nArray.length - 1][1] = this.m_Position[1] - n4;
                if (Math.abs(nArray[nArray.length - 1][1] - gameObject.m_Position[1]) >= gameObject.m_Config[4] << 1) break;
                if (!Game.Terrain_IsPositionBlocked(nArray[nArray.length - 1][0], nArray[nArray.length - 1][1] - n5, this.m_Config[3], this.m_Config[4])) {
                    int[] nArray2 = nArray[nArray.length - 1];
                    nArray2[1] = nArray2[1] - n2;
                    break;
                }
                if (!Game.Terrain_IsPositionBlocked(nArray[nArray.length - 1][0], nArray[nArray.length - 1][1] + n5, this.m_Config[3], this.m_Config[4])) {
                    int[] nArray3 = nArray[nArray.length - 1];
                    nArray3[1] = nArray3[1] + n2;
                    break;
                }
                nArray[nArray.length - 1][1] = this.m_Position[1];
                break;
            }
            case 3: {
                nArray[nArray.length - 1][0] = this.m_Position[0];
                nArray[nArray.length - 1][1] = this.m_Position[1] + 32768000;
                int[] nArray4 = new int[5];
                Game.Terrain_IsIsectsWithSegment(this.m_Position, nArray[nArray.length - 1], nArray4);
                nArray4[1] = nArray4[1] / Game.m_PassCellH * Game.m_PassCellH;
                nArray[nArray.length - 1][1] = nArray4[1] - this.m_Config[4];
            }
        }
        Game.Route_OnChanged(nArray);
        this.InitRoute(nArray);
    }

    void BossMembranus_Init() {
        m_BM_Membranus = this;
        m_BM_iBarrels = 0;
        m_BM_iGrenades = 0;
        m_BM_SpawnTimer = 0;
        this.m_Flags |= 8;
        this.SetState(0);
    }

    void BossMembranus_Activate() {
        GameObject[] gameObjectArray = Game.m_Objects;
        m_BM_Grenades = new GameObject[this.m_Tag];
        m_BM_GrenadesRoutes = new GameObject[Game.Objects_GetCountByType(38) - 1];
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        for (int i = 1; i < gameObjectArray.length; ++i) {
            if (gameObjectArray[i].m_Class == 27) {
                m_BM_Barrel = gameObjectArray[i];
            }
            if (gameObjectArray[i].m_Class == 30) {
                GameObject.m_BM_Grenades[n] = gameObjectArray[i];
                GameObject.m_BM_Grenades[n].m_Flags |= 0x400;
                ++n;
            }
            if (gameObjectArray[i].m_Class != 29) continue;
            if (gameObjectArray[i].m_Tag == this.m_Tag) {
                m_BM_BarrelsRoute = gameObjectArray[i];
                continue;
            }
            GameObject.m_BM_GrenadesRoutes[n2++] = gameObjectArray[i];
        }
    }

    int BossMembranus_GetHealth() {
        if (0 == this.m_State) {
            return GameObject.m_BM_Machine.m_Health;
        }
        return this.m_Health;
    }

    int BossMembranus_GetTotalHealth() {
        if (0 == this.m_State) {
            return GameObject.m_BM_Machine.m_Config[2];
        }
        return this.m_Config[2];
    }

    void BossMembranus_Update(int n) {
        if (this.m_StateTime > this.GetAnimTime(this.m_State)) {
            switch (this.m_State) {
                case 3: {
                    this.SetState(2);
                    break;
                }
                case 4: 
                case 6: {
                    this.SetState(5);
                }
            }
        }
        switch (this.m_State) {
            case 0: {
                this.BossMembranus_UpdateBarrels(n);
                this.m_Health = Integer.MAX_VALUE;
                break;
            }
            case 2: {
                if (this.m_Health < this.m_Config[2] >> 1) {
                    this.SetState(4);
                    return;
                }
            }
            case 5: {
                this.BossMembranus_UpdateGrenades(n);
            }
        }
        if (this.m_State == 1) {
            this.MoveOnRoute(n);
        }
        this.UpdateScreenPosition();
    }

    void BossMembranus_OnRouteCompleted() {
        this.m_Health = this.m_Config[2];
        this.SetState(2);
    }

    void BossMembranus_OnDeath() {
        this.SetState(7);
        this.m_Flags &= 0xFFFFFFF7;
    }

    void BossMembranus_UpdateBarrels(int n) {
        if (!m_BM_Barrel.IsEnabled() && m_BM_SpawnTimer == 0) {
            m_BM_Barrel.BossMembranus_Barrel_Activate();
            GameObject.m_BM_Barrel.m_RouteID = GameObject.m_BM_BarrelsRoute.m_RouteID;
            m_BM_Barrel.InitRoute(Game.m_Routes[GameObject.m_BM_BarrelsRoute.m_RouteID]);
        } else {
            m_BM_SpawnTimer = Math.max(0, m_BM_SpawnTimer - n);
        }
    }

    void BossMembranus_UpdateGrenades(int n) {
        if (m_BM_iGrenades >= this.m_Tag) {
            return;
        }
        if (m_BM_SpawnTimer == 0) {
            int n2 = this.m_State == 2 ? 3 : 6;
            m_BM_SpawnTimer = 1500;
            GameObject gameObject = Game.Objects_GetDisabledInstance(30);
            gameObject.BossMembranus_Grenade_Activate();
            int n3 = this.m_State == 2 ? 0 : m_BM_GrenadesRoutes.length >> 1;
            int n4 = this.m_State == 2 ? m_BM_GrenadesRoutes.length >> 1 : m_BM_GrenadesRoutes.length;
            int n5 = n3 + Game.Math_GetRandomInt(n4 - n3);
            gameObject.m_RouteID = GameObject.m_BM_GrenadesRoutes[n5].m_RouteID;
            gameObject.InitRoute(Game.m_Routes[GameObject.m_BM_GrenadesRoutes[n5].m_RouteID]);
            ++m_BM_iGrenades;
            this.SetState(n2);
        } else {
            m_BM_SpawnTimer = Math.max(0, m_BM_SpawnTimer - n);
        }
    }

    void BossMembranus_Barrel_Activate() {
        this.Enable(true);
        this.m_Flags &= 0xFFFFFFFD;
        this.m_Speed = 0x550000;
        this.m_Health = this.m_Config[2];
        this.SetState(0);
    }

    void BossMembranus_Barrel_Update(int n) {
        GameObject gameObject = Game.m_Player;
        switch (this.m_State) {
            case 0: {
                this.MoveOnRoute(n);
                if (Math.abs(this.m_Position[0] - gameObject.m_Position[0]) >= gameObject.m_Config[3]) break;
                this.OnDeath();
                break;
            }
            case 1: {
                if (this.m_StateTime < this.m_AuxInt) break;
                this.MoveOnRoute(n);
            }
        }
    }

    void BossMembranus_Barrel_OnRouteCompleted() {
        this.Enable(false);
        m_BM_SpawnTimer = 3000;
    }

    void BossMembranus_Barrel_OnDeath() {
        this.SetState(1);
        this.m_AuxInt = this.GetAnimTime(1);
        Game.Bullets_Create(16, this.m_Position[0], this.m_Position[1], Game.Math_ArctanFlt(0, 1), GameObject.m_BM_Machine.m_ID);
    }

    void BossMembranus_Machine_Init() {
        m_BM_Machine = this;
        this.m_Flags |= 8;
    }

    void BossMembranus_Machine_Update(int n) {
        switch (this.m_State) {
            case 1: {
                if (this.m_StateTime < this.m_AuxInt) break;
                this.Enable(false);
            }
        }
    }

    void BossMembranus_Machine_OnDamage(int n) {
        m_BossBlinkTimer = 200;
    }

    void BossMembranus_Machine_OnDeath() {
        this.m_Flags &= 0xFFFFFFF7;
        if (GameObject.m_BM_Barrel.m_State == 0) {
            m_BM_Barrel.OnDeath();
        }
        m_BM_Membranus.SetState(1);
        Game.Route_OnChanged(Game.m_Routes[GameObject.m_BM_Membranus.m_RouteID]);
        m_BM_Membranus.InitRoute(Game.m_Routes[GameObject.m_BM_Membranus.m_RouteID]);
        GameObject.m_BM_Membranus.m_Speed = 0x460000;
        this.m_AuxInt = this.GetAnimTime(1);
        this.SetState(1);
    }

    void BossMembranus_Grenade_Activate() {
        this.Enable(true);
        this.m_Flags &= 0xFFFFFFFD;
        this.m_Speed = 0x640000;
        this.m_Health = this.m_Config[2];
        this.SetState(0);
    }

    void BossMembranus_Grenade_Update(int n) {
        GameObject gameObject = Game.m_Player;
        switch (this.m_State) {
            case 0: {
                this.MoveOnRoute(n);
                if (!this.HitTestWorld(gameObject.m_Position[0], gameObject.m_Position[1], gameObject.m_Config[3], gameObject.m_Config[4])) break;
                this.OnDeath();
                break;
            }
            case 1: {
                if (this.m_StateTime < this.m_AuxInt) break;
                --m_BM_iGrenades;
                this.Enable(false);
            }
        }
    }

    void BossMembranus_Grenade_Render(Renderer renderer) {
        int n = this.m_Config[4] >> 16;
        this.m_ScreenY -= n;
        this.RenderState(renderer);
        this.m_ScreenY += n;
    }

    void BossMembranus_Grenade_OnRouteCompleted() {
        this.OnDeath();
    }

    void BossMembranus_Grenade_OnDeath() {
        this.SetState(1);
        this.m_AuxInt = this.GetAnimTime(1);
        Game.Effects_Create(9, this.m_Position, null);
        Game.Weapons_CreateExplosion(0x1E0000, 1000, this.m_Position);
    }

    void Pickup_Update(int n) {
        if (Game.m_Player.GetFastDistanceTo(this.m_Position) > this.m_Config[3]) {
            if (this.m_Type == 16) {
                this.SetState(0);
            }
            return;
        }
        switch (this.m_Type) {
            case 14: {
                Game.Sound_Play(21);
                Game.m_Player.Player_IncHealth(250);
                break;
            }
            case 17: {
                if (this.m_Tag == 0) break;
                Game.m_ScoreLevel[3] = Game.m_ScoreLevel[3] + 1;
                if (Game.m_Player.Player_IsTurbojetActive()) {
                    Game.m_Player.Player_TurbojetToggle();
                }
                Game.Sound_Play(9);
                Game.m_Player.Player_IncAmmo(4, this.m_Tag);
                break;
            }
            case 16: {
                Game.Sound_Play(22);
                Game.m_Player.Player_LoadFuel(n);
                break;
            }
            case 18: {
                Game.Sound_Play(20);
                Game.m_Player.Player_AddAntiDote();
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                if (this.m_Tag == 0) {
                    this.m_Tag = 5;
                }
                System.out.println("m_Tag = " + this.m_Tag);
                Game.Sound_Play(9);
                int n2 = this.m_Type - 40;
                Game.m_Player.Player_IncAmmo(1 + n2, this.m_Tag);
                int n3 = 4 + n2;
                Game.m_ScoreLevel[n3] = Game.m_ScoreLevel[n3] + 1;
            }
        }
        Game.Messages_ShowMessage(this.Pickup_GetName());
        if (this.m_Type != 16) {
            this.m_Flags |= 2;
            this.Enable(false);
        } else {
            this.SetState(1);
        }
    }

    void Pickup_Render(Renderer renderer) {
        this.RenderState(renderer);
    }

    String Pickup_GetName() {
        int n = 0;
        int n2 = 1;
        switch (this.m_Type) {
            case 14: {
                n = 90;
                break;
            }
            case 17: {
                n = 91;
                n2 = this.m_Tag;
                break;
            }
            case 18: {
                n = 93;
                break;
            }
            case 40: {
                n = 94;
                n2 = this.m_Tag;
                break;
            }
            case 41: {
                n = 95;
                n2 = this.m_Tag;
                break;
            }
            case 42: {
                n = 96;
                n2 = this.m_Tag;
                break;
            }
            default: {
                return null;
            }
        }
        return Game.Font_Sprintf(Game.m_Strings[97], Game.m_Strings[n], Integer.toString(n2));
    }

    void Hook_Init() {
        this.m_Flags |= 0x2000;
    }

    boolean Hook_CanBeUsed() {
        GameObject gameObject = Game.m_Player;
        if (Math.abs(gameObject.m_Position[0] - this.m_Position[0]) > gameObject.m_Config[3] + this.m_Config[3]) {
            return false;
        }
        if (Math.abs(gameObject.m_Position[1] - gameObject.m_Config[4] - this.m_Position[1]) > this.m_Config[4]) {
            return false;
        }
        int n = 0;
        switch (this.m_Type) {
            case 10: {
                n = 0;
                break;
            }
            case 11: {
                n = 205888;
            }
        }
        return Game.Math_GetAngleDifferenceFlt(Game.m_Player.m_Position[2], n) < 102944;
    }

    boolean Hook_CanBeUsedToGoDown() {
        GameObject gameObject = Game.m_Player;
        if (!gameObject.m_IsLanded) {
            return false;
        }
        return this.GetFastDistanceTo(Game.m_Player) < Game.m_Player.m_Config[3] + this.m_Config[3] * 3 / 2;
    }

    boolean Hook_CanBeUsedPlayer() {
        GameObject gameObject = Game.m_Player;
        return gameObject.m_State == 14 || gameObject.m_State == 2;
    }

    void PlayerFSCannon_Shutdown() {
        m_FSCannonAttacker = null;
        this.Player_Shutdown();
    }

    void PlayerFSCannon_Update(int n) {
        switch (this.m_State) {
            case 0: {
                if (!Game.m_IsKeyPressed[4]) break;
                this.PlayerFSCannon_Shoot();
                break;
            }
            case 1: 
            case 2: {
                if (this.m_StateTime <= this.m_AuxInt) break;
                this.SetState(0);
                Game.Debug_Println("PFSCS_Aim");
                break;
            }
            case 3: {
                if (this.m_StateTime <= this.m_AuxInt) break;
                Game.m_Player.OnDeath();
                Game.m_Player.m_Health = 0;
                Game.Activity_SetCurrent(-1);
                Game.SceneAction_OnPlayerDeath();
            }
        }
    }

    void PlayerFSCannon_Shoot() {
        this.SetDirection(Game.m_AimPos[0] - this.m_Position[0], Game.m_AimPos[1] - this.m_Position[1]);
        this.Player_GetShootingCoords(Game.m_coords11, 2);
        Game.Bullets_Create(13, Game.m_coords11[0], Game.m_coords11[1], this.m_Position[2], this.m_ID);
        Game.Sound_Play(29);
        this.SetState(1);
        this.m_AuxInt = this.GetAnimTime(1);
        Game.Debug_Println("PFSCS_Shoot");
    }

    void PlayerFSCannon_OnDamage(int n) {
        this.Player_ProcessDamage(n);
        if (2 == this.m_State) {
            return;
        }
        this.SetState(2);
        this.m_AuxInt = this.GetAnimTime(2);
        Game.Debug_Println("PFSCS_Defend");
        m_FSCannonAttacker.OnDamage(GameObject.m_FSCannonAttacker.m_Health);
    }

    void PlayerFSCannon_OnDeath() {
        this.SetState(3);
        this.m_AuxInt = this.GetAnimTime(3);
        Game.Debug_Println("PFSCS_Dead");
    }

    void EnemyFSCannon_Activate() {
        this.Enable(true);
        this.m_Flags &= 0xFFFFFFFD;
        this.m_Speed = 0x320000;
        this.m_AuxInt = this.GetAnimTime(3);
        this.m_Health = this.m_Config[2];
        this.SetState(0);
    }

    void EnemyFSCannon_Update(int n) {
        Game.m_IsEnemiesAlive = true;
        switch (this.m_State) {
            case 0: {
                this.MoveOnRoute(n);
                if (this.m_Progress < this.m_Route[1][3]) break;
                this.SetState(1);
                break;
            }
            case 1: {
                if (this.m_StateTime <= Game.m_AnimationTimes[this.m_Config[1] + this.m_State]) break;
                this.SetState(2);
                break;
            }
            case 2: {
                this.MoveOnRoute(n);
                if (null != this.m_Route) break;
                this.SetState(3);
                break;
            }
            case 3: {
                if (this.m_StateTime <= this.m_AuxInt) break;
                this.m_AuxInt += this.GetAnimTime(3);
                m_FSCannonAttacker = this;
                Game.m_Player.OnDamage(200);
                break;
            }
            case 5: {
                if (this.m_StateTime < this.m_AuxInt) break;
                this.Enable(false);
                break;
            }
            case 4: {
                int n2;
                this.MoveOnRoute(n);
                GameObject[] gameObjectArray = new GameObject[Game.m_Objects[Game.m_ActivityObject].m_Tag];
                int n3 = 0;
                int n4 = Game.Objects_GetCountByType(8);
                for (n2 = 0; n2 < n4; ++n2) {
                    gameObjectArray[n2] = Game.Objects_FindByType(8, n3);
                    n3 = gameObjectArray[n2].m_ID + 1;
                }
                for (n2 = 0; n2 < gameObjectArray.length; ++n2) {
                    if (gameObjectArray[n2] == null || gameObjectArray[n2] == this || this.m_Progress >= gameObjectArray[n2].m_Progress || gameObjectArray[n2].m_Progress - this.m_Progress >= this.m_Progress / 10 || gameObjectArray[n2].m_RouteID != this.m_RouteID) continue;
                    gameObjectArray[n2].m_Speed = 0xC80000;
                    gameObjectArray[n2].SetState(4);
                }
                if (this.m_Route != null && this.m_Progress < this.m_Route[1][3]) break;
                this.Enable(false);
            }
        }
    }

    void EnemyFSCannon_OnDeath() {
        if (0 == this.m_State) {
            this.m_Speed = 0xC80000;
            this.SetState(4);
        } else {
            this.CancelRoute(false);
            this.SetState(5);
            this.m_AuxInt = this.GetAnimTime(5);
        }
    }

    void Platform_Init() {
        this.InitRoute();
        this.m_Speed = 0x230000;
        this.m_Flags |= 0x1808;
        this.m_PlatformIsActivated = true;
    }

    void Platform_Update(int n) {
        if (!this.m_PlatformIsActivated) {
            return;
        }
        this.StorePosition();
        this.MoveOnRoute(n);
        this.Collision_Update();
        this.UpdateScreenPosition();
    }

    void Platform_OnRouteCompleted() {
        this.InitRoute();
    }

    void Button_Init() {
        this.m_Flags |= 0x22000;
        this.SetState(0);
        this.m_Position[1] = this.m_Position[1] + this.m_Config[4];
    }

    boolean Button_CanBeUsed() {
        return this.GetFastDistanceTo(Game.m_Player) < Game.m_Player.m_Config[3] + this.m_Config[3] * 3 / 2 && this.m_State == 0;
    }

    void Crate_Init() {
        this.m_Flags |= 0x8C08;
        this.SetState(0);
    }

    void Crate_Update(int n) {
        boolean bl = this.m_IsLanded;
        this.Physics_Update(n);
        this.Collision_Update();
        if (this.m_IsLanded) {
            if (!bl) {
                Game.Sound_Play(8);
            }
            if (m_CollisionIntersection != 2 && NO_HOOK) {
                NO_HOOK = false;
            }
            if (m_CollisionIntersection == 2) {
                GameObject gameObject = Game.m_Objects[m_CollisionObject];
                if (gameObject.m_ID != Game.m_Objects[0].m_ID) {
                    gameObject.OnDamage(Integer.MAX_VALUE);
                }
            } else if (this.m_Position[0] != this.m_PositionLast[0]) {
                for (int i = 0; i < Game.m_Objects.length; ++i) {
                    if (!Game.m_Objects[i].IsEnabled() || (Game.m_Objects[i].m_Type != 11 || this.m_Position[0] <= Game.m_Objects[i].m_Position[0]) && (Game.m_Objects[i].m_Type != 10 || this.m_Position[0] >= Game.m_Objects[i].m_Position[0]) || this.GetFastDistanceTo(Game.m_Objects[i]) >= Game.m_Objects[i].m_Config[3] + this.m_Config[3] * 3 / 2) continue;
                    this.SetState(1);
                    this.m_CratesHook = Game.m_Objects[i];
                    this.m_Flags &= 0xFFFF7FFF;
                    this.m_Position[2] = this.m_CratesHook.m_Type == 11 ? 0 : 205888;
                }
            }
        }
        if (this.m_State == 1 && this.m_StateTime >= Game.m_AnimationTimes[this.m_Config[1] + this.m_State]) {
            this.SetState(0);
            NO_HOOK = true;
            this.m_Position[0] = this.m_CratesHook.m_Position[0] + this.m_Config[3] * (this.m_CratesHook.m_Type == 11 ? 1 : -1);
            this.m_Position[1] = this.m_CratesHook.m_Position[1] + this.m_Config[4];
            this.m_Flags |= 0x8000;
        }
        this.StorePosition();
        this.UpdateScreenPosition();
    }

    static void Civilian_ResetStaticData() {
        m_CivilianDialogToShow = 0;
    }

    void Civilian_Init() {
        this.m_State = 0;
        this.m_AuxInt = 0;
    }

    void Civilian_Render(Renderer renderer) {
        Game.Tile_Render(renderer, Game.m_AnimationClips[this.m_Config[1]][0][this.m_State], this.m_ScreenX, this.m_ScreenY);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean Civilian_CanBeUsed() {
        if (this.GetFastDistanceTo(Game.m_Player) >= Game.m_Player.m_Config[3] + this.m_Config[3]) return false;
        if (this.m_State != 0) return false;
        if (this.m_AuxInt != 0) return false;
        if (m_PlayerAntiDoteCount <= 0) return false;
        return true;
    }

    void Civilian_OnSaved() {
        ++this.m_AuxInt;
        this.m_State = 1;
        Game.Sound_Play(23);
        m_PlayerAntiDoteCount = (byte)(m_PlayerAntiDoteCount - 1);
        Game.m_Objects[this.m_Tag].Enable(true);
        Game.Level_ShowDialog(CIVILIAN_DIALOGS[m_CivilianDialogToShow]);
        m_CivilianDialogToShow = (m_CivilianDialogToShow + 1) % CIVILIAN_DIALOGS.length;
        Game.m_ScoreLevel[1] = Game.m_ScoreLevel[1] + 1;
    }

    void Door_Init() {
        this.m_Flags |= 0xC08;
        this.m_DoorOpened = false;
        this.m_State = 0;
        this.m_Speed = 0;
        this.m_AuxInt = 0;
        this.m_Speed = 3;
        this.m_ScreenLastY = this.m_ScreenY;
    }

    void Door_Render(Renderer renderer) {
        int n = renderer.getClipX();
        int n2 = renderer.getClipY();
        int n3 = renderer.getClipWidth();
        int n4 = renderer.getClipHeight();
        short s = Game.Tile_GetWidth(Game.m_AnimationClips[this.m_Config[1]][0][0]);
        short s2 = Game.Tile_GetHeight(Game.m_AnimationClips[this.m_Config[1]][0][0]);
        int n5 = this.m_PositionLast[1] + this.m_Config[4] >> 16;
        renderer.clipRect(this.m_ScreenX - s / 2, this.m_ScreenLastY - s2, s, s2 - this.m_AuxInt);
        Game.Tile_Render(renderer, Game.m_AnimationClips[this.m_Config[1]][0][0], this.m_ScreenX, this.m_ScreenLastY - this.m_AuxInt);
        renderer.setClip(n, n2, n3, n4);
    }

    void Door_Open(boolean bl) {
        if (bl) {
            this.m_State = 1;
            this.m_AuxInt = 0;
            Game.Sound_Play(10);
        } else {
            this.m_State = 0;
        }
        this.m_DoorOpened = true;
    }

    void Door_Update(int n) {
        if (this.m_DoorOpened) {
            int n2 = this.m_Position[1] + this.m_Config[4] >> 16;
            int n3 = this.m_Config[4] >> 16;
            this.m_AuxInt = this.m_ScreenLastY - n2;
            if (this.m_State == 1) {
                if (this.m_ScreenLastY - n2 >= 2 * n3) {
                    this.m_DoorOpened = false;
                }
            } else if (this.m_ScreenLastY - n2 <= 0) {
                this.m_DoorOpened = false;
            }
            this.Door_Move(n);
            this.UpdateScreenPosition();
        }
    }

    void Door_Move(int n) {
        this.m_Position[1] = this.m_State == 1 ? this.m_Position[1] - (this.m_Speed * n << 10) : this.m_Position[1] + (this.m_Speed * n << 10);
    }

    void PlayerTurret_Init() {
        m_TurretAttacker = null;
        this.SetState(0);
        this.m_AuxInt = 0;
    }

    void PlayerTurret_Shutdown() {
        m_TurretAttacker = null;
    }

    void PlayerTurret_Update(int n) {
        this.m_AuxInt -= n;
        switch (this.m_State) {
            case 1: {
                if (!Game.m_IsKeyPressed[4]) break;
                this.PlayerTurret_Shoot();
                break;
            }
            case 2: 
            case 3: {
                if (this.m_StateTime <= this.m_AuxInt) break;
                this.SetState(1);
                break;
            }
            case 4: {
                if (this.m_StateTime <= this.m_AuxInt) break;
                Game.m_Player.OnDeath();
                Game.m_Player.m_Health = 0;
                Game.Activity_SetCurrent(-1);
                Game.SceneAction_OnPlayerDeath();
            }
        }
    }

    void PlayerTurret_Shoot() {
        if (this.m_AuxInt > 0) {
            return;
        }
        this.Player_GetShootingCoords(Game.m_coords11, 1);
        Game.Bullets_Create(12, Game.m_coords11[0], Game.m_coords11[1], this.m_Position[2], this.m_ID);
        this.SetState(2);
        this.m_AuxInt = this.GetAnimTime(2);
    }

    void PlayerTurret_OnDamage(int n) {
        if (Game.m_Player.IsEnabled()) {
            this.m_Health += n;
            return;
        }
        Game.m_Player.Player_ProcessDamage(n);
        if (3 == this.m_State) {
            return;
        }
        this.SetState(3);
        this.m_AuxInt = this.GetAnimTime(3);
    }

    void PlayerTurret_OnDeath() {
        this.SetState(4);
        this.m_AuxInt = this.GetAnimTime(4);
    }

    void EnemyScourgeHitTheTarget_Init() {
        this.m_Enemy = Game.m_Enemies[5];
        this.m_AuxInt = 1500;
        this.SetState(0);
        this.m_ScourgeHitTheTarget_IsShowingUp = true;
    }

    void EnemyScourgeHitTheTarget_Update(int n) {
        this.m_AuxInt -= n;
        if (this.m_ScourgeHitTheTarget_IsShowingUp) {
            if (this.m_AuxInt <= 0) {
                this.m_ScourgeHitTheTarget_IsShowingUp = false;
            }
            return;
        }
        switch (this.m_State) {
            case 1: 
            case 2: {
                if (this.m_StateTime < Game.m_AnimationTimes[this.m_Config[1] + this.m_State]) break;
                this.SetState(0);
                break;
            }
            case 3: {
                short s = Game.m_AnimationTimes[this.m_Config[1] + this.m_State];
                if (this.m_StateTime >= s) {
                    this.m_StateTime = s - 1;
                    this.m_AuxInt -= n;
                    if (this.m_AuxInt < 0) {
                        Game.ActivityHitTheTarget_OnEnemyDeath(this);
                    }
                }
                return;
            }
        }
        this.m_EnemyHitTheTarget_AllowAttack = true;
        this.EnemyScourgeHitTheTarget_TryAttack(Game.m_Player);
        this.UpdateScreenPosition();
    }

    void EnemyScourgeHitTheTarget_OnDamage() {
        this.SetState(2);
    }

    void EnemyScourgeHitTheTarget_OnDeath() {
        Game.ActivityHitTheTarget_ShiftAttackQueue();
        this.m_AuxInt = 2000;
        this.SetState(3);
    }

    void EnemyScourgeHitTheTarget_TryAttack(GameObject gameObject) {
        if (this.m_AuxInt > 0 || !this.m_EnemyHitTheTarget_AllowAttack) {
            return;
        }
        this.SetState(1);
        this.Enemy_LookAt(gameObject);
        Game.Bullets_Create(this.m_Enemy[1], this.m_Position[0], this.m_Position[1], this.m_Position[2] + (this.m_Position[2] > 102944 ? 45875 : -45875), this.m_ID);
        this.m_AuxInt = this.m_Enemy[6];
        Game.ActivityHitTheTarget_ShiftAttackQueue();
    }

    void EnemyScourgeHitTheTarget_Render(Renderer renderer) {
        if (!this.m_ScourgeHitTheTarget_IsShowingUp) {
            this.RenderState(renderer);
            return;
        }
        int n = renderer.getClipX();
        int n2 = renderer.getClipY();
        int n3 = renderer.getClipWidth();
        int n4 = renderer.getClipHeight();
        int n5 = (this.m_Config[4] >> 16) * 2;
        int n6 = n5 * (1500 - this.m_AuxInt) / 1500;
        int n7 = n5 - n6;
        renderer.clipRect(n, (this.m_Position[1] >> 16) - n5 / 2, n3, n6);
        renderer.translate(0, -n7);
        this.RenderState(renderer);
        renderer.translate(0, n7);
        renderer.setClip(n, n2, n3, n4);
    }

    void EnemyOrangutanHitTheTarget_Init() {
        this.m_Enemy = Game.m_Enemies[3];
        this.m_EnemyShootTimeout = 1000;
        this.SetState(6);
        this.m_Speed = this.m_Enemy[0];
    }

    void EnemyOrangutanHitTheTarget_Update(int n) {
        switch (this.m_State) {
            case 1: 
            case 2: 
            case 3: {
                if (this.m_StateTime < Game.m_AnimationTimes[this.m_Config[1] + this.m_State]) break;
                this.SetState(0);
                break;
            }
            case 6: {
                break;
            }
            case 4: {
                this.Enemy_UpdateDeath(n);
                if (this.m_AuxInt < 0) {
                    Game.ActivityHitTheTarget_OnEnemyDeath(this);
                }
                return;
            }
        }
        if (this.m_Route != null) {
            this.MoveOnRoute(n);
        } else {
            this.StorePosition();
            if (this.m_EnemyHitTheTarget_AllowAttack && this.m_State == 0) {
                if (this.m_AuxInt > 0) {
                    this.m_AuxInt -= n;
                } else {
                    this.EnemyOrangutanHitTheTarget_UpdateFight(n);
                }
            }
            this.Physics_Update(n);
            this.Collision_Update();
        }
        this.UpdateScreenPosition();
    }

    void EnemyOrangutanHitTheTarget_UpdateFight(int n) {
        GameObject gameObject = Game.m_Player;
        if (0 != (gameObject.m_Flags & 2)) {
            return;
        }
        switch (this.m_State) {
            case 0: {
                this.Enemy_Shoot(gameObject);
                Game.ActivityHitTheTarget_ShiftAttackQueue();
            }
        }
    }

    void EnemyOrangutanHitTheTarget_Render(Renderer renderer) {
        if (this.m_State == 6) {
            short[][] sArray = Game.m_AnimationClips[this.m_Config[1] + this.m_State];
            int n = Game.Math_AngleToDirectionFlt(this.m_Position[2], sArray.length, false);
            int n2 = this.m_Progress * 4 / Game.Route_GetLength(this.m_Route);
            Game.Tile_Render(renderer, sArray[n][n2], this.m_ScreenX, this.m_ScreenY);
        } else {
            this.RenderState(renderer);
        }
    }

    void EnemyOrangutanHitTheTarget_OnDamage() {
        if (this.m_Route != null) {
            return;
        }
        this.m_Flags &= 0xFFFFFFEF;
        this.m_Speed = 0;
        this.SetState(3);
    }

    void EnemyOrangutanHitTheTarget_OnDeath() {
        Game.ActivityHitTheTarget_ShiftAttackQueue();
        this.m_AuxInt = 2000;
        this.SetState(4);
    }

    void EnemyOrangutanHitTheTarget_OnRouteCompleted() {
        this.m_Speed = 0;
        this.SetState(0);
    }

    static {
        COLLISION_SlidingVectors = new int[][]{{65536, 0}, {-65536, 0}, {0, 65536}, {0, -65536}, {69510, -69510}, {-69510, -69510}};
        NO_HOOK = false;
        CIVILIAN_DIALOGS = new int[]{17, 18};
    }
}

