/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.graphics;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import sk.inlogic.util.Rectangle;

public class GFont {
    private Image font = null;
    private int INT_NULL;
    private int fontColor = this.INT_NULL = -9999;
    private short[] charLenght = null;
    private short[] charXPos = null;
    private short[] charYPos = null;
    private char[] chrs = null;
    private int height = 0;
    private int baseLineHeight = 0;
    private int spaceWidth = 0;
    private int charSpaceWidth = 0;
    int length;
    Rectangle view = new Rectangle(0, 0, 0, 0);
    Rectangle charView = new Rectangle(0, 0, 0, 0);

    public GFont(Image fontImg, char[] chars, short[] lenghts, int charSpaceWidth, int spaceWidth) {
        this.font = fontImg;
        this.fontColor = this.INT_NULL;
        this.charLenght = lenghts;
        this.spaceWidth = spaceWidth;
        this.charSpaceWidth = charSpaceWidth;
        int lines = 1;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '\n') continue;
            ++lines;
        }
        this.height = fontImg.getHeight() / lines;
        this.setBaseLineHeight(this.height);
        this.chrs = new char[chars.length - (lines - 1)];
        this.charXPos = new short[this.chrs.length];
        this.charYPos = new short[this.chrs.length];
        int k = 0;
        int xPos = 0;
        int yPos = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '\n') {
                this.chrs[k] = chars[i];
                this.charXPos[k] = (short)xPos;
                this.charYPos[k] = (short)yPos;
                xPos += lenghts[k];
                ++k;
                continue;
            }
            xPos = 0;
            yPos += this.height;
        }
    }

    public int getSpaceWidth() {
        return this.spaceWidth;
    }

    public void drawChar(Graphics g, int x, int y, char ch) {
        int index = this.getIndex(ch);
        g.setClip(x, y, (int)this.charLenght[index], this.height);
        if (this.fontColor != this.INT_NULL) {
            g.setColor(0xFF0000);
            g.fillRect(x, y, (int)this.charLenght[index], this.height);
        }
        g.drawImage(this.font, x - this.charXPos[index], y - this.charYPos[index], 20);
    }

    public void drawString(Graphics g, char[] str, int x, int y, int anchor) {
        this.length = str.length;
        this.view.x = g.getClipX();
        this.view.y = g.getClipY();
        this.view.width = g.getClipWidth();
        this.view.height = g.getClipHeight();
        if ((anchor & 0x20) == 32) {
            y -= this.height;
        } else if ((anchor & 2) == 2) {
            y -= this.height / 2;
        }
        int index = 0;
        if ((anchor & 4) == 4 || (anchor & 1) == 1) {
            if ((anchor & 1) == 1) {
                x -= this.stringWidth(str) / 2;
            }
            for (int i = 0; i < this.length; ++i) {
                index = this.getIndex(str[i]);
                if (index == -1) {
                    x += this.spaceWidth;
                    continue;
                }
                if (this.isTag(this.chrs[index])) {
                    this.setColor(this.chrs[index]);
                }
                if (this.isTag(this.chrs[index])) continue;
                this.drawChar(g, this.view, x, y, index);
                x += this.charLenght[index] + this.charSpaceWidth;
            }
        } else if ((anchor & 8) == 8) {
            for (int i = this.length - 1; i >= 0; --i) {
                index = this.getIndex(str[i]);
                if (index == -1) {
                    x -= this.spaceWidth;
                    continue;
                }
                x -= this.charLenght[index];
                if (this.isTag(this.chrs[index])) {
                    this.setColor(this.chrs[index]);
                }
                if (!this.isTag(this.chrs[index])) {
                    this.drawChar(g, this.view, x, y, index);
                }
                x -= this.charSpaceWidth;
            }
        }
        g.setClip(this.view.x, this.view.y, this.view.width, this.view.height);
    }

    private boolean isTag(char chr) {
        return chr == '#' || chr == '&' || chr == '*';
    }

    private void drawChar(Graphics g, Rectangle view, int x, int y, int index) {
        if (x + this.charLenght[index] <= view.x || x >= view.x + view.width || y + this.height <= view.y || y >= view.y + view.height) {
            return;
        }
        this.charView.x = x;
        this.charView.y = y;
        this.charView.width = this.charLenght[index];
        this.charView.height = this.height;
        if (x < view.x) {
            this.charView.x = view.x;
            this.charView.width = this.charLenght[index] - (view.x - x);
        }
        if (y < view.y) {
            this.charView.y = view.y;
            this.charView.height = this.height - (view.y - y);
        }
        if (this.charView.x + this.charView.width > view.x + view.width) {
            this.charView.width -= this.charView.x + this.charView.width - (view.x + view.width);
        }
        if (this.charView.y + this.charView.height > view.y + view.height) {
            this.charView.height -= this.charView.y + this.charView.height - (view.y + view.height);
        }
        g.setClip(this.charView.x, this.charView.y, this.charView.width, this.charView.height);
        if (this.fontColor != this.INT_NULL && this.chrs[index] != ' ') {
            g.setColor(this.fontColor);
            g.fillRect(this.charView.x, this.charView.y, this.charView.width, this.charView.height);
        }
        g.drawImage(this.font, x - this.charXPos[index], y - this.charYPos[index], 20);
    }

    private void setColor(int index) {
        switch (index) {
            case 35: {
                this.fontColor = 0xAA0000;
                break;
            }
            case 38: {
                this.fontColor = 43520;
                break;
            }
            case 42: {
                this.fontColor = 16770977;
            }
        }
    }

    private int getIndex(char ch) {
        for (int i = 0; i < this.chrs.length; ++i) {
            if (this.chrs[i] != ch) continue;
            return i;
        }
        return -1;
    }

    public int charsWidth(char[] str, int offset, int length) {
        int result = 0;
        int index = 0;
        for (int i = offset + length - 1; i >= offset; --i) {
            index = this.getIndex(str[i]);
            if (index == -1) {
                result += this.spaceWidth;
                continue;
            }
            result += this.charLenght[index] + this.charSpaceWidth;
        }
        return result;
    }

    public int stringWidth(char[] str) {
        int result = 0;
        int index = 0;
        for (int i = str.length - 1; i >= 0; --i) {
            index = this.getIndex(str[i]);
            if (index == -1) {
                result += this.spaceWidth;
                continue;
            }
            result += this.charLenght[index] + this.charSpaceWidth;
        }
        return result;
    }

    public int getHeight() {
        return this.height;
    }

    public int getBaseLineHeight() {
        return this.baseLineHeight;
    }

    public void setBaseLineHeight(int height) {
        this.baseLineHeight = height;
    }
}

