/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import sk.inlogic.Common;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.X;
import sk.inlogic.screen.IScreen;
import sk.inlogic.text.ResourceBundle;

public class ScreenLanguages
implements IScreen {
    MainCanvas mainCanvas;
    int mode;
    long modeDelay;
    private int[] iconAnimation = new int[]{0, 0, 0, 0, 0, 0};
    private int ICON_ANIMATION;
    public final int LANG_EN;
    public final int LANG_DE;
    public final int LANG_ES;
    public final int LANG_FR;
    public final int LANG_PT;
    private int sprW = 0;
    private int sprH = 0;
    private int yOffset = 0;
    private int xOffset = 0;
    private int SPACING = 0;
    private int selectedLanguage = 0;
    private boolean hideScreen = false;
    private int iHide = 0;

    public ScreenLanguages(MainCanvas mainCanvas) {
        this.LANG_EN = 0;
        this.LANG_DE = 1;
        this.LANG_ES = 2;
        this.LANG_FR = 3;
        this.LANG_PT = 4;
        this.mainCanvas = mainCanvas;
    }

    public void beforeShow() {
        Resources.loadImages(new int[]{1, 22});
        Resources.loadSprites(new int[]{1});
        this.sprW = Resources.resSprs[1].getWidth();
        this.sprH = Resources.resSprs[1].getHeight();
        this.SPACING = this.sprW / 7;
        this.yOffset = MainCanvas.HEIGHT - this.sprH * 3 - this.SPACING * 2 >> 1;
        this.xOffset = (MainCanvas.WIDTH - this.sprW * 2 - this.SPACING) / 2;
        this.ICON_ANIMATION = this.sprH;
        this.iconAnimation = new int[]{this.sprH, this.sprH, this.sprH, this.sprH, this.sprH, this.sprH};
    }

    public void afterHide() {
        Resources.freeImages(new int[]{1, 22});
        Resources.freeSprites(new int[]{1});
    }

    public void trace(String str) {
        System.out.println(str);
    }

    public void update(long lastRunLenght) {
        this.animateIcons();
        this.animateHide();
        this.mainCanvas.repaint();
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
    }

    public void loadLanguage(int language) {
        switch (language) {
            case 0: {
                MainCanvas.texts = new ResourceBundle(X.singleton, "/lang/en/g.csr");
                MainCanvas.EN = true;
                break;
            }
            case 1: {
                MainCanvas.texts = new ResourceBundle(X.singleton, "/lang/de/g.csr");
                MainCanvas.DE = true;
                break;
            }
            case 2: {
                MainCanvas.texts = new ResourceBundle(X.singleton, "/lang/es/g.csr");
                MainCanvas.ES = true;
                break;
            }
            case 3: {
                MainCanvas.texts = new ResourceBundle(X.singleton, "/lang/fr/g.csr");
                MainCanvas.FR = true;
                break;
            }
            case 4: {
                MainCanvas.texts = new ResourceBundle(X.singleton, "/lang/pt/g.csr");
                MainCanvas.PT = true;
            }
        }
    }

    public void animateIcons() {
        for (int i = 0; i < 6; ++i) {
            if (this.iconAnimation[i] == 0) continue;
            if (this.iconAnimation[i] < 2) {
                this.iconAnimation[i] = 0;
            }
            this.iconAnimation[i] = this.iconAnimation[i] - (this.iconAnimation[i] >> 1);
            if (i < 5 && this.iconAnimation[i] < this.ICON_ANIMATION >> 1 && this.iconAnimation[i + 1] == this.ICON_ANIMATION) {
                int n = i + 1;
                this.iconAnimation[n] = this.iconAnimation[n] - 1;
            }
            if (i >= 5 || this.iconAnimation[i + 1] != this.ICON_ANIMATION) continue;
            i = 6;
        }
    }

    public void animateHide() {
        if (this.hideScreen) {
            this.mainCanvas.setActiveScreen(6, null);
        }
    }

    public void paintLangIcons(Graphics g) {
        int x = this.xOffset;
        int y = this.yOffset;
        int frame = 0;
        for (int i = 0; i < 5; ++i) {
            frame = i;
            if (i == 0) {
                x = this.xOffset + (this.sprW + this.SPACING) / 2;
                y = this.yOffset - this.iconAnimation[0];
            }
            if (i == 1) {
                x = this.xOffset;
                y = this.yOffset + (this.sprH + this.SPACING) - this.iconAnimation[1];
            }
            if (i == 2) {
                x = this.xOffset + (this.sprW + this.SPACING);
                y -= this.iconAnimation[2];
            }
            if (i == 3) {
                x = this.xOffset;
                y = this.yOffset + (this.sprH + this.SPACING) + (this.sprH + this.SPACING) - this.iconAnimation[3];
            }
            if (i == 4) {
                x = this.xOffset + (this.sprW + this.SPACING);
                y -= this.iconAnimation[4];
            }
            if (this.selectedLanguage == i) {
                // empty if block
            }
            if (i == 4) {
                frame = 5;
            }
            Resources.resSprs[1].setFrame(frame);
            Resources.resSprs[1].setPosition(x, y);
            Resources.resSprs[1].paint(g);
        }
    }

    public void paint(Graphics g) {
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        Common.paintMenuBackground(g);
        if (this.hideScreen) {
            g.translate(this.iHide, 0);
        }
        this.paintLangIcons(g);
    }

    public void pointerPressed(int x, int y) {
        int x1 = this.xOffset;
        int y1 = this.yOffset;
        for (int i = 0; i < 5; ++i) {
            if (i == 0) {
                x1 = this.xOffset + (this.sprW + this.SPACING) / 2;
                y1 = this.yOffset - this.iconAnimation[0];
            }
            if (i == 1) {
                x1 = this.xOffset;
                y1 = this.yOffset + (this.sprH + this.SPACING) - this.iconAnimation[1];
            }
            if (i == 2) {
                x1 = this.xOffset + (this.sprW + this.SPACING);
                y1 -= this.iconAnimation[2];
            }
            if (i == 3) {
                x1 = this.xOffset;
                y1 = this.yOffset + (this.sprH + this.SPACING) + (this.sprH + this.SPACING) - this.iconAnimation[3];
            }
            if (i == 4) {
                x1 = this.xOffset + (this.sprW + this.SPACING);
                y1 -= this.iconAnimation[4];
            }
            if (x <= x1 || x >= x1 + this.sprW || y <= y1 || y >= y1 + this.sprH) continue;
            this.selectedLanguage = i;
            this.loadLanguage(this.selectedLanguage);
            this.hideScreen = true;
            this.iHide = -1;
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
    }
}

