/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Player;
import sk.inlogic.Resources;
import sk.inlogic.ScreenShop;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.graphics.GFont;
import sk.inlogic.text.StringTokenizer;
import sk.inlogic.util.Rectangle;

public class Common {
    public static final int FN_YES = 0;
    public static final int FN_NO = 1;
    public static final int FN_LEFT = 2;
    public static final int FN_RIGHT = 3;
    public static final int FN_UP = 4;
    public static final int FN_DOWN = 5;
    public static final int FN_QUIT = 6;
    public static final int FN_SEND = 7;
    public static final int FN_PLAY = 8;
    public static final int FN_COINS = 9;
    public static final int INT_NULL = -9999;
    private static int fnPlayCounter = 0;
    private static int fnPlusCounter = 0;
    static int[] SIN_TABLE = new int[]{0, 4, 8, 13, 17, 22, 26, 31, 35, 40, 44, 48, 53, 57, 61, 66, 70, 74, 79, 83, 87, 91, 95, 100, 104, 108, 112, 116, 120, 124, 127, 131, 135, 139, 143, 146, 150, 154, 157, 161, 164, 167, 171, 174, 177, 181, 184, 187, 190, 193, 196, 198, 201, 204, 207, 209, 212, 214, 217, 219, 221, 223, 226, 228, 230, 232, 233, 235, 237, 238, 240, 242, 243, 244, 246, 247, 248, 249, 250, 251, 252, 252, 253, 254, 254, 255, 255, 255, 255, 255, 256, 255, 255, 255, 255, 255, 254, 254, 253, 252, 252, 251, 250, 249, 248, 247, 246, 244, 243, 242, 240, 238, 237, 235, 233, 232, 230, 228, 226, 223, 221, 219, 217, 214, 212, 209, 207, 204, 201, 198, 196, 193, 190, 187, 184, 181, 177, 174, 171, 167, 164, 161, 157, 154, 150, 146, 143, 139, 135, 131, 127, 124, 120, 116, 112, 108, 104, 100, 95, 91, 87, 83, 79, 74, 70, 66, 61, 57, 53, 48, 44, 40, 35, 31, 26, 22, 17, 13, 8, 4, 0, -4, -8, -13, -17, -22, -26, -31, -35, -40, -44, -48, -53, -57, -61, -66, -70, -74, -79, -83, -87, -91, -95, -100, -104, -108, -112, -116, -120, -124, -127, -131, -135, -139, -143, -146, -150, -154, -157, -161, -164, -167, -171, -174, -177, -181, -184, -187, -190, -193, -196, -198, -201, -204, -207, -209, -212, -214, -217, -219, -221, -223, -226, -228, -230, -232, -233, -235, -237, -238, -240, -242, -243, -244, -246, -247, -248, -249, -250, -251, -252, -252, -253, -254, -254, -255, -255, -255, -255, -255, -256, -255, -255, -255, -255, -255, -254, -254, -253, -252, -252, -251, -250, -249, -248, -247, -246, -244, -243, -242, -240, -238, -237, -235, -233, -232, -230, -228, -226, -223, -221, -219, -217, -214, -212, -209, -207, -204, -201, -198, -196, -193, -190, -187, -184, -181, -177, -174, -171, -167, -164, -161, -157, -154, -150, -146, -143, -139, -135, -131, -128, -124, -120, -116, -112, -108, -104, -100, -95, -91, -87, -83, -79, -74, -70, -66, -61, -57, -53, -48, -44, -40, -35, -31, -26, -22, -17, -13, -8, -4};
    public static int SND_GAME = 0;
    public static int SND_MENU = 1;
    public static int ITEM_X;
    public static int ITEM2_X;
    public static int MENU_RADIUS;
    public static int STAFF_RADIUS;
    public static int STAFF_GEM_H;
    public static int SHOT_SPEED;
    public static int GHOST_SPEED;
    public static int GOLEM_SPEED;
    public static int CANNON_SPEED;
    public static int ORC_SPEED;
    public static int BAT_SPEED;
    public static int BOSS_SPEED;
    public static int AVATAR_OFFSET;
    public static int STAT_ITEM_H;
    public static int CLASSIC_ITEM_H;

    public static Rectangle getMenuArea(int width, int height) {
        int marginTop = 0;
        int marginBottom = 0;
        if (height <= 130) {
            marginTop = 30;
            marginBottom = 5;
        } else if (height <= 149) {
            marginTop = 45;
            marginBottom = 10;
        } else if (height <= 160) {
            marginTop = 50;
            marginBottom = 25;
        } else if (height <= 176) {
            marginTop = 65;
            marginBottom = 15;
        } else if (height <= 208) {
            marginTop = 65;
            marginBottom = 20;
        } else if (height <= 220) {
            marginTop = 70;
            marginBottom = 20;
        } else if (height <= 240) {
            marginTop = 80;
            marginBottom = 27;
        } else if (height <= 260) {
            marginTop = 85;
            marginBottom = 20;
        } else if (height <= 287) {
            marginTop = 85;
            marginBottom = 20;
        } else if (height <= 320) {
            if (width == 480) {
                marginTop = 120;
                marginBottom = 5;
            } else {
                marginTop = 100;
                marginBottom = 20;
            }
        } else if (height <= 348) {
            marginTop = 100;
            marginBottom = 25;
        } else if (height <= 360) {
            marginTop = 120;
            marginBottom = 40;
        } else if (height <= 416) {
            marginTop = 125;
            marginBottom = 75;
        } else if (height <= 432) {
            marginTop = 100;
            marginBottom = 132;
        } else if (height <= 480) {
            marginTop = 140;
            marginBottom = 25;
        } else if (height <= 640) {
            if (width == 480) {
                marginTop = 180;
                marginBottom = 40;
            } else {
                marginTop = 200;
                marginBottom = 140;
            }
        } else if (height <= 696) {
            marginTop = 240;
            marginBottom = 70;
        } else if (height <= 854) {
            marginTop = 260;
            marginBottom = 140;
        } else if (height <= 960) {
            marginTop = 260;
            marginBottom = 170;
        }
        return new Rectangle(0, 0 + marginTop, width, height - marginTop - marginBottom);
    }

    public static void paintFNLeft(int icon, Graphics g) {
        if (icon == 8) {
            Resources.resSprs[93].setPosition(0, MainCanvas.HEIGHT - Resources.resSprs[4].getHeight());
            Resources.resSprs[93].paint(g);
            if (ScreenShop.updateCounter % 3L == 0L) {
                ++fnPlayCounter;
            }
            if (fnPlayCounter > 3) {
                fnPlayCounter = 0;
            }
        } else {
            if (Resources.resSprs[4] == null) {
                Resources.loadSprite(4);
            }
            Resources.resSprs[4].setFrame(icon);
            Resources.resSprs[4].setPosition(0, MainCanvas.HEIGHT - Resources.resSprs[4].getHeight());
            Resources.resSprs[4].paint(g);
        }
    }

    public static void paintFNLeftCoins(int shopItemId, Graphics g) {
        g.drawImage(Resources.resImgs[34], 0, MainCanvas.HEIGHT - Resources.resSprs[4].getHeight(), 20);
        Resources.resSprs[99].setFrame(fnPlusCounter);
        Resources.resSprs[99].setPosition(0, MainCanvas.HEIGHT - Resources.resSprs[4].getHeight() + Resources.resSprs[99].getHeight() / 6);
        Resources.resSprs[99].paint(g);
        if (!Player.hasEnoughtGoldToBuyItem(shopItemId)) {
            if (ScreenShop.updateCounter % 3L == 0L) {
                ++fnPlusCounter;
            }
            if (fnPlusCounter > 3) {
                fnPlusCounter = 0;
            }
        }
    }

    public static void paintFNRight(int icon, Graphics g) {
        Resources.resSprs[4].setFrame(icon);
        Resources.resSprs[4].setPosition(MainCanvas.WIDTH - Resources.resSprs[4].getWidth(), MainCanvas.HEIGHT - Resources.resSprs[4].getHeight());
        Resources.resSprs[4].paint(g);
    }

    static int SIN(long angle) {
        if ((angle %= 360L) < 0L) {
            angle = 360L + angle;
        }
        return SIN_TABLE[(int)angle];
    }

    static int COS(long angle) {
        return Common.SIN(angle += 90L);
    }

    public static int getArcX(int angle, int r) {
        return Common.COS(angle) * r >> 6;
    }

    public static int getArcY(int angle, int r) {
        return Common.SIN(angle) * r >> 6;
    }

    public static void paintAnimatedMenuTable(int y, int parts, int animation, Graphics g) {
        Sprite spr = Resources.resSprs[0];
        animation = 0;
        int sprW = spr.getWidth();
        int sprH = spr.getHeight();
        int tableW = sprW;
        int tableH = sprH * (parts + 2);
        int x = MainCanvas.WIDTH - tableW >> 1;
        y = MainCanvas.HEIGHT - tableH >> 1;
        g.setClip(x + animation, y + animation, tableW - animation, tableH - animation);
        g.setColor(5717076);
        g.fillRect(x, y, tableW, tableH);
        spr.setFrame(0);
        spr.setPosition(x + animation, y + animation);
        spr.paint(g);
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        if (MainCanvas.ES) {
            g.drawImage(Resources.resImgs[41], MainCanvas.WIDTH >> 1, y + Resources.resImgs[41].getHeight() / 12, 3);
        } else {
            g.drawImage(Resources.resImgs[28], MainCanvas.WIDTH >> 1, y + Resources.resImgs[28].getHeight() / 12, 3);
        }
        g.setClip(x + animation, y + animation, tableW - animation, tableH - animation);
        for (int i = 0; i < parts; ++i) {
            spr.setFrame(1);
            spr.setPosition(x + animation, y += sprH);
            spr.paint(g);
        }
        spr.setFrame(2);
        spr.setPosition(x + animation, (y += sprH) - animation);
        spr.paint(g);
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    public static void paintTowerUpgradeTable(int y, int parts, int animation, Graphics g) {
        Sprite spr = Resources.resSprs[0];
        animation = 0;
        int sprW = spr.getWidth();
        int sprH = spr.getHeight();
        int tableW = sprW;
        int tableH = sprH * (parts + 2);
        int x = MainCanvas.WIDTH - tableW >> 1;
        y = MainCanvas.HEIGHT - tableH - 3;
        g.setClip(x + animation, y + animation, tableW - animation, tableH - animation);
        g.setColor(5717076);
        g.fillRect(x, y, tableW, tableH);
        spr.setFrame(0);
        spr.setPosition(x + animation, y + animation);
        spr.paint(g);
        for (int i = 0; i < parts; ++i) {
            spr.setFrame(1);
            spr.setPosition(x + animation, y += sprH);
            spr.paint(g);
        }
        spr.setFrame(2);
        spr.setPosition(x + animation, (y += sprH) - animation);
        spr.paint(g);
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        Common.drawCenteredText(g, 0, y - (sprH >> 1) + 13, MainCanvas.WIDTH, Common.separateTextToLines(MainCanvas.texts.getString("UPGRADING"), MainCanvas.WIDTH, Resources.resGFonts[0]), Resources.resGFonts[0]);
    }

    public static void paintAnimatedMenuTableMentor(int y, int parts, int animation, Graphics g) {
        Sprite spr = Resources.resSprs[0];
        animation = 0;
        int sprW = spr.getWidth();
        int sprH = spr.getHeight();
        int tableW = sprW;
        int tableH = sprH * (parts + 2);
        int x = MainCanvas.WIDTH - tableW >> 1;
        y = MainCanvas.HEIGHT - tableH >> 1;
        g.setClip(x + animation, y + animation, tableW - animation, tableH - animation);
        g.setColor(5717076);
        g.fillRect(x, y, tableW, tableH);
        spr.setFrame(0);
        spr.setPosition(x + animation, y + animation);
        spr.paint(g);
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        if (MainCanvas.ES) {
            g.drawImage(Resources.resImgs[41], (MainCanvas.WIDTH >> 1) - Resources.resImgs[41].getWidth() / 5, y + Resources.resImgs[41].getHeight() / 12, 6);
        } else {
            g.drawImage(Resources.resImgs[28], (MainCanvas.WIDTH >> 1) - Resources.resImgs[28].getWidth() / 5, y + Resources.resImgs[28].getHeight() / 12, 6);
        }
        g.setClip(x + animation, y + animation, tableW - animation, tableH - animation);
        for (int i = 0; i < parts; ++i) {
            spr.setFrame(1);
            spr.setPosition(x + animation, y += sprH);
            spr.paint(g);
        }
        spr.setFrame(2);
        spr.setPosition(x + animation, (y += sprH) - animation);
        spr.paint(g);
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    public static int animatedTableLeftBorder() {
        return MainCanvas.WIDTH - Resources.resSprs[0].getWidth() >> 1;
    }

    public static int animatedTableTopBorder(int parts) {
        return MainCanvas.HEIGHT - Common.getInfoTableH(parts) >> 1;
    }

    public static void old_paintAnimatedMenuTable(int y, int parts, int animation, Graphics g) {
        Sprite spr = Resources.resSprs[0];
        int sprW = spr.getWidth();
        int sprH = spr.getHeight();
        int tableW = sprW * 3;
        int tableH = sprH * (parts + 2);
        int x = MainCanvas.WIDTH - sprW * 3 >> 1;
        spr.setFrame(0);
        spr.setPosition(x + animation, y + animation);
        spr.paint(g);
        spr.setFrame(1);
        spr.setPosition(x + sprW, y + animation);
        spr.paint(g);
        spr.setFrame(2);
        spr.setPosition(x + (sprW << 1) - animation, y + animation);
        spr.paint(g);
        for (int i = 0; i < parts; ++i) {
            spr.setFrame(3);
            spr.setPosition(x + animation, y += sprH);
            spr.paint(g);
            spr.setFrame(4);
            spr.setPosition(x + sprW, y);
            spr.paint(g);
            spr.setFrame(5);
            spr.setPosition(x + (sprW << 1) - animation, y);
            spr.paint(g);
        }
        spr.setFrame(6);
        spr.setPosition(x + animation, (y += sprH) - animation);
        spr.paint(g);
        spr.setFrame(7);
        spr.setPosition(x + sprW, y - animation);
        spr.paint(g);
        spr.setFrame(8);
        spr.setPosition(x + (sprW << 1) - animation, y - animation);
        spr.paint(g);
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    public static int getTableH(int parts) {
        if (Resources.resSprs[0] == null) {
            Resources.loadSprite(0);
        }
        return Resources.resSprs[0].getHeight() * (parts + 2);
    }

    public static int getTableW() {
        if (Resources.resSprs[0] == null) {
            Resources.loadSprite(0);
        }
        return Resources.resSprs[0].getWidth();
    }

    public static int getInfoTableH(int parts) {
        if (Resources.resSprs[0] == null) {
            Resources.loadSprite(0);
        }
        return Resources.resSprs[0].getHeight() * (parts + 4) - 5;
    }

    public static void changeMusic(int snd) {
        if (MainCanvas.music) {
            MainCanvas.soundManager.SetSoundOn(false);
            MainCanvas.music = false;
            MainCanvas.soundManager.Stop();
        } else {
            MainCanvas.soundManager.SetSoundOn(true);
            MainCanvas.music = true;
            if (snd == SND_MENU) {
                MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
            } else if (snd == SND_GAME) {
                MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
            }
        }
    }

    public static void paintMenuBackground(Graphics g) {
        if (Resources.resImgs[1] != null) {
            for (int i = 0; i < MainCanvas.WIDTH / Resources.resImgs[1].getWidth() + 1; ++i) {
                for (int j = 0; j < MainCanvas.HEIGHT / Resources.resImgs[1].getHeight() + 1; ++j) {
                    g.drawImage(Resources.resImgs[1], i * Resources.resImgs[1].getWidth(), j * Resources.resImgs[1].getHeight(), 20);
                }
            }
        }
    }

    public static void paintShopButton(Graphics g, String text, int x, int y, int hParts, int state) {
        Sprite sprBut = Resources.resSprs[89];
        int stateAddition = state * 3;
        sprBut.setFrame(0 + stateAddition);
        sprBut.setPosition(x, y);
        sprBut.paint(g);
        for (int i = 0; i < hParts; ++i) {
            sprBut.setFrame(1 + stateAddition);
            sprBut.setPosition(x + (i + 1) * sprBut.getWidth(), y);
            sprBut.paint(g);
        }
        sprBut.setFrame(2 + stateAddition);
        sprBut.setPosition(x + (hParts + 1) * sprBut.getWidth(), y);
        sprBut.paint(g);
        int vectorW = (hParts + 2) * sprBut.getWidth();
        Vector vecText = Common.separateTextToLines(text, vectorW, Resources.resGFonts[2]);
        int vectorH = vecText.size() * Resources.resGFonts[2].getHeight();
        Common.drawCenteredText(g, x, y + (sprBut.getHeight() - vectorH >> 1), (hParts + 2) * sprBut.getWidth(), vecText, Resources.resGFonts[2]);
    }

    public static void paintScrollbar(Graphics g, int heightParts, int percentage) {
        Sprite scrollSpr = Resources.resSprs[85];
        int scrollbarPosX = MainCanvas.WIDTH - (MainCanvas.WIDTH - Common.getTableW() >> 1) - scrollSpr.getWidth();
        int scrollbarFullHeight = heightParts * scrollSpr.getHeight();
        int scrollbarPointerMinY = MainCanvas.HEIGHT - scrollbarFullHeight >> 1;
        int scrollbarPointerMaxY = scrollbarPointerMinY + scrollbarFullHeight - Resources.resImgs[30].getHeight();
        int scrollbarPointerPosY = (scrollbarPointerMaxY - scrollbarPointerMinY) * 1000 / 100 * percentage / 1000;
        int frame = 0;
        for (int i = 0; i < heightParts; ++i) {
            if (i > 0) {
                frame = 1;
            }
            if (i == heightParts - 1) {
                frame = 2;
            }
            scrollSpr.setFrame(frame);
            scrollSpr.setPosition(scrollbarPosX, scrollbarPointerMinY + i * scrollSpr.getHeight());
            scrollSpr.paint(g);
        }
        g.drawImage(Resources.resImgs[30], scrollbarPosX, scrollbarPointerMinY + scrollbarPointerPosY, 20);
    }

    public static Vector separateTextToLines(String text, int maxLineWidth, GFont gFont) {
        Vector<char[]> lines = new Vector<char[]>();
        String acceptableStr = "";
        String tokenStr = "";
        String tmpStr = "";
        int tmpStrWidth = 0;
        StringTokenizer st = new StringTokenizer(text, " ");
        while (st.hasMoreTokens()) {
            tokenStr = st.nextToken();
            tmpStrWidth = gFont.stringWidth((tmpStr = tmpStr + (tmpStr == "" ? "" : " ") + tokenStr).toCharArray());
            if (tmpStrWidth <= maxLineWidth && !tokenStr.equals("^")) {
                acceptableStr = new String(tmpStr);
                continue;
            }
            if (tokenStr.equals("^")) {
                tokenStr = "";
            }
            lines.addElement(new String(acceptableStr).toCharArray());
            tmpStr = tokenStr;
            acceptableStr = tokenStr;
        }
        lines.addElement(new String(acceptableStr).toCharArray());
        return lines;
    }

    public static void drawSeparatedText(Graphics g, int x, int y, Vector textLines, GFont gFont) {
        int fontHeight = gFont.getHeight();
        int linesCount = textLines.size();
        for (int i = 0; i < linesCount; ++i) {
            gFont.drawString(g, (char[])textLines.elementAt(i), x, y + i * fontHeight, 20);
        }
    }

    public static void drawSeparatedText2Vectors(Graphics g, int x, int y, Vector textLines, Vector textLines2, GFont gFont) {
        int i;
        int fontHeight = gFont.getHeight();
        int linesCount = textLines.size();
        int linesCount2 = textLines2.size();
        int yPos = 0;
        for (i = 0; i < linesCount; ++i) {
            gFont.drawString(g, (char[])textLines.elementAt(i), x, y + i * fontHeight, 20);
        }
        yPos = (linesCount + 1) * fontHeight;
        for (i = 0; i < linesCount2; ++i) {
            gFont.drawString(g, (char[])textLines2.elementAt(i), x, yPos + i * fontHeight, 20);
        }
    }

    public static void drawCenteredText(Graphics g, int x, int y, int width, Vector textLines, GFont gFont) {
        int fontHeight = gFont.getHeight();
        int linesCount = textLines.size();
        for (int i = 0; i < linesCount; ++i) {
            gFont.drawString(g, (char[])textLines.elementAt(i), x + (width >> 1), y + i * fontHeight, 17);
        }
    }

    public static void drawScrollingText(Graphics g, int animation, int x, int y, int width, char[] text, GFont gFont) {
        int fontHeight = gFont.getHeight();
        int stringWidth = gFont.stringWidth(text);
        int overflow = stringWidth - width;
        int newX = overflow > 0 ? (animation > overflow ? x - overflow : x - animation) : x;
        g.setClip(x, y, width, fontHeight);
        gFont.drawString(g, text, newX, y, 20);
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    public static void fnTouch(int x, int y) {
        if (y > MainCanvas.HEIGHT - (Resources.resSprs[4].getHeight() << 1)) {
            if (x < Resources.resSprs[4].getWidth() << 1) {
                X.mainCanvas.keyReleased(-21);
            } else if (x > MainCanvas.WIDTH - (Resources.resSprs[4].getWidth() << 1)) {
                X.mainCanvas.keyReleased(-22);
            }
        }
    }

    public static void setPort() {
        if (MainCanvas.WIDTH == 240) {
            if (MainCanvas.HEIGHT == 260) {
                ITEM_X = 58;
                ITEM2_X = 58;
                MENU_RADIUS = 10;
            } else {
                ITEM_X = 35;
                ITEM2_X = 40;
                MENU_RADIUS = 13;
            }
            STAFF_RADIUS = 35;
            STAFF_GEM_H = 5;
            SHOT_SPEED = 6;
            GHOST_SPEED = 10;
            ORC_SPEED = 10;
            BAT_SPEED = 14;
            GOLEM_SPEED = 6;
            CANNON_SPEED = 3;
            BOSS_SPEED = 8;
            AVATAR_OFFSET = -6;
        } else if (MainCanvas.WIDTH == 176) {
            ITEM_X = 25;
            ITEM2_X = 25;
            MENU_RADIUS = 10;
            STAFF_RADIUS = 35;
            STAFF_GEM_H = 5;
            SHOT_SPEED = 4;
            GHOST_SPEED = 7;
            ORC_SPEED = 7;
            BAT_SPEED = 10;
            GOLEM_SPEED = 4;
            CANNON_SPEED = 2;
            BOSS_SPEED = 6;
            AVATAR_OFFSET = -6;
        } else if (MainCanvas.WIDTH == 208) {
            ITEM_X = 35;
            ITEM2_X = 35;
            MENU_RADIUS = 10;
            STAFF_RADIUS = 35;
            STAFF_GEM_H = 5;
            SHOT_SPEED = 4;
            GHOST_SPEED = 7;
            ORC_SPEED = 7;
            BAT_SPEED = 10;
            GOLEM_SPEED = 4;
            CANNON_SPEED = 2;
            BOSS_SPEED = 6;
            AVATAR_OFFSET = -6;
        } else if (MainCanvas.WIDTH == 128) {
            ITEM_X = 15;
            ITEM2_X = 15;
            MENU_RADIUS = 8;
            STAFF_RADIUS = 20;
            STAFF_GEM_H = 5;
            SHOT_SPEED = 3;
            GHOST_SPEED = 5;
            ORC_SPEED = 5;
            BAT_SPEED = 7;
            GOLEM_SPEED = 3;
            CANNON_SPEED = 1;
            BOSS_SPEED = 5;
            AVATAR_OFFSET = 0;
            STAT_ITEM_H = 16;
            CLASSIC_ITEM_H = 16;
        } else if (MainCanvas.WIDTH == 480) {
            if (MainCanvas.HEIGHT == 320) {
                ITEM_X = 155;
                ITEM2_X = 160;
                MENU_RADIUS = 13;
                STAFF_RADIUS = 50;
                STAFF_GEM_H = 7;
                SHOT_SPEED = 6;
                GHOST_SPEED = 10;
                ORC_SPEED = 10;
                BAT_SPEED = 14;
                GOLEM_SPEED = 6;
                CANNON_SPEED = 3;
                BOSS_SPEED = 4;
                AVATAR_OFFSET = -6;
            } else if (MainCanvas.HEIGHT == 360) {
                ITEM_X = 155;
                ITEM2_X = 160;
                MENU_RADIUS = 13;
                STAFF_RADIUS = 50;
                STAFF_GEM_H = 7;
                SHOT_SPEED = 6;
                GHOST_SPEED = 10;
                ORC_SPEED = 10;
                BAT_SPEED = 14;
                GOLEM_SPEED = 6;
                CANNON_SPEED = 3;
                BOSS_SPEED = 8;
                AVATAR_OFFSET = -6;
            } else {
                ITEM_X = 70;
                ITEM2_X = 70;
                MENU_RADIUS = 26;
                STAFF_RADIUS = 80;
                STAFF_GEM_H = 15;
                SHOT_SPEED = 12;
                GHOST_SPEED = 20;
                ORC_SPEED = 20;
                BAT_SPEED = 28;
                GOLEM_SPEED = 12;
                CANNON_SPEED = 6;
                BOSS_SPEED = 16;
                AVATAR_OFFSET = -10;
            }
        } else if (MainCanvas.WIDTH == 360) {
            ITEM_X = 50;
            ITEM2_X = 50;
            MENU_RADIUS = 22;
            STAFF_RADIUS = 60;
            STAFF_GEM_H = 12;
            SHOT_SPEED = 12;
            GHOST_SPEED = 20;
            ORC_SPEED = 20;
            BAT_SPEED = 28;
            GOLEM_SPEED = 12;
            CANNON_SPEED = 6;
            BOSS_SPEED = 16;
            AVATAR_OFFSET = -10;
            STAT_ITEM_H = 45;
        } else if (MainCanvas.WIDTH == 320) {
            if (MainCanvas.HEIGHT != 480) {
                ITEM_X = 50;
                ITEM2_X = 50;
                MENU_RADIUS = 12;
                STAFF_RADIUS = 35;
                STAFF_GEM_H = 6;
                SHOT_SPEED = 4;
                GHOST_SPEED = 7;
                ORC_SPEED = 7;
                BAT_SPEED = 10;
                GOLEM_SPEED = 4;
                CANNON_SPEED = 2;
                BOSS_SPEED = 6;
                AVATAR_OFFSET = -10;
                STAT_ITEM_H = 30;
            } else {
                ITEM_X = 50;
                ITEM2_X = 50;
                MENU_RADIUS = 22;
                STAFF_RADIUS = 50;
                STAFF_GEM_H = 7;
                SHOT_SPEED = 12;
                GHOST_SPEED = 20;
                ORC_SPEED = 20;
                BAT_SPEED = 28;
                GOLEM_SPEED = 12;
                CANNON_SPEED = 6;
                BOSS_SPEED = 16;
                AVATAR_OFFSET = -10;
                STAT_ITEM_H = 45;
            }
        } else if (MainCanvas.WIDTH == 600) {
            ITEM_X = 80;
            ITEM2_X = 90;
            MENU_RADIUS = 30;
            STAFF_RADIUS = 60;
            STAFF_GEM_H = 12;
            SHOT_SPEED = 12;
            GHOST_SPEED = 20;
            ORC_SPEED = 20;
            BAT_SPEED = 28;
            GOLEM_SPEED = 12;
            CANNON_SPEED = 6;
            BOSS_SPEED = 16;
            AVATAR_OFFSET = -30;
            STAT_ITEM_H = 65;
            CLASSIC_ITEM_H = 70;
        }
    }

    static {
        STAT_ITEM_H = -9999;
        CLASSIC_ITEM_H = -9999;
    }
}

