/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Common;
import sk.inlogic.MainCanvas;
import sk.inlogic.Player;
import sk.inlogic.Resources;
import sk.inlogic.ShopItems;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.screen.IScreen;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenShop
implements IScreen {
    MainCanvas mainCanvas;
    int mode;
    long modeDelay = 10L;
    private int iTableAnimation = 0;
    private int TABLE_ANIMATION;
    public static boolean fromMenu;
    public static int SELECTED_CATEGORY;
    private int SELECTED_SHOP_ITEM = 0;
    private int SELECTED_SHOP_ITEM_ID;
    private int SELECTED_SHOP_BUTTON_DETAIL = 1;
    private int DETAIL_BUTTONS_CASE;
    private Rectangle[] menuItems = new Rectangle[6];
    public static int price;
    private int BUTTONS_CASE_UPGRADE = 0;
    private int BUTTONS_CASE_FULL_UPGRADE = 1;
    private int BUTTONS_CASE_FULL_UPGRADE_EQUIP = 2;
    private int BUTTONS_CASE_EQUIP = 3;
    private int BUTTONS_CASE_NONE = 4;
    private int BUTTON_FULL_UPGRADE = 0;
    private int BUTTON_UPGRADE = 1;
    private int BUTTON_EQUIP = 2;
    char[] strCategoryName;
    char[] strShopItemPrice;
    char[][] statsValues;
    static char[] chrCash;
    private int CONTROL_MODE = 0;
    private int instX;
    private int instW;
    private int scrollY;
    private int detailDescHSpace;
    private int backToItem = -9999;
    private int backToItemID = -9999;
    private int backToCat = -9999;
    private int shopIconSmallWandH;
    char[] chrCatNameStats;
    char[] chrCatNameInventory;
    char[] chrCatNameMagicTower;
    char[] chrCatNameConsumables;
    char[] chrCatNameCoins;
    String chrUpgrade;
    String chrFullUpgrade;
    String chrBuy;
    String chrEquip;
    private String loading = MainCanvas.texts.getString("LOADING");
    String nLevel = MainCanvas.texts.getString("UNLOCKS_ON");
    String nLevel2 = MainCanvas.texts.getString("STAGE");
    static long updateCounter;
    private boolean hiding = false;
    private int iHide = 0;
    private boolean hideScreen = false;
    public int nextMode;
    private final int MODE_MENU;
    private final int MODE_GAME;
    private final int MODE_SHOP;
    private final int MODE_SHOP_DETAIL;
    private final int MODE_SHOP_LOADING;
    private int[] iconAnimation = new int[]{0, 0, 0, 0, 0, 0};
    private int ICON_ANIMATION;
    private int selectorAnimation = 0;
    public static int buyItemEffect;
    private int[] buttonState = new int[]{0, 0, 0};
    private boolean textCheck = false;
    private int instOldY;

    public ScreenShop(MainCanvas mainCanvas) {
        this.MODE_MENU = 0;
        this.MODE_GAME = 1;
        this.MODE_SHOP = 4;
        this.MODE_SHOP_DETAIL = 5;
        this.MODE_SHOP_LOADING = 6;
        this.mainCanvas = mainCanvas;
        this.mode = 4;
    }

    public void beforeShow() {
        MainCanvas.loadGame();
        Resources.loadGFonts(new int[]{2, 3, 4});
        Resources.loadImages(new int[]{1, 3, 7, 31, 24, 25, 34});
        if (!MainCanvas.touchActivated) {
            Resources.loadSprites(new int[]{0, 73, 93, 89, 76, 78, 77, 79, 80, 81, 82, 91, 92, 99});
        } else {
            Resources.loadSprites(new int[]{0, 73, 93, 89, 76, 78, 77, 79, 80, 81, 82, 91, 92, 99});
        }
        this.iTableAnimation = this.TABLE_ANIMATION = Resources.resSprs[0].getWidth() >> 1;
        this.detailDescHSpace = 50;
        ShopItems.initData();
        chrCash = (Player.getCash() + " ").toCharArray();
        this.chrCatNameStats = MainCanvas.texts.getString("STATS").toCharArray();
        this.chrCatNameInventory = MainCanvas.texts.getString("INVENTORY").toCharArray();
        this.chrCatNameMagicTower = MainCanvas.texts.getString("MAGIC_TOWER").toCharArray();
        this.chrCatNameConsumables = MainCanvas.texts.getString("CONSUMABLES").toCharArray();
        this.chrCatNameCoins = MainCanvas.texts.getString("BUY_COINS").toCharArray();
        this.chrUpgrade = MainCanvas.texts.getString("UPGRADE");
        this.chrFullUpgrade = MainCanvas.texts.getString("FULL_UPGRADE");
        this.chrEquip = MainCanvas.texts.getString("EQUIP");
        this.chrBuy = MainCanvas.texts.getString("BUY");
        MainCanvas.limitedOffer = false;
        this.mode = 4;
    }

    public static void reloadShopItemsData() {
        ShopItems.refreshShopItemsPriceAndValues();
        chrCash = (Player.getCash() + " ").toCharArray();
        MainCanvas.saveGame();
        MainCanvas.loadGame();
    }

    public void afterHide() {
        Resources.freeGFonts(new int[]{3, 4});
        Resources.freeImages(new int[]{1, 3, 7, 25});
        Resources.freeSprites(new int[]{73, 76, 78, 77, 79, 80, 81, 82, 91, 92});
        this.trace("HAJDOL SOM");
        MainCanvas.saveGame();
    }

    public void trace(String str) {
        System.out.println(str);
    }

    public void resetShowAnimation() {
        this.iTableAnimation = this.TABLE_ANIMATION = Resources.resSprs[0].getWidth() >> 1;
        this.iHide = 0;
        this.hideScreen = false;
    }

    public void animateTable() {
        if (!this.hiding && this.iTableAnimation != 0) {
            if (this.iTableAnimation < 4) {
                --this.iTableAnimation;
            }
            this.iTableAnimation -= this.iTableAnimation >> 2;
        }
    }

    public void changeMode() {
        switch (this.nextMode) {
            case 4: {
                this.mode = 4;
                break;
            }
            case 5: {
                this.mode = 5;
                this.scrollY = 0;
                this.SELECTED_SHOP_BUTTON_DETAIL = 1;
                break;
            }
            case 0: {
                X.mainCanvas.setActiveScreen(1, null);
                MainCanvas.saveGame();
                break;
            }
            case 1: {
                if (Player.getStage() == 0 || Player.getStage() == 2 || Player.getStage() == 4) {
                    this.mainCanvas.tutorialGame = 8;
                }
                MainCanvas.gameMusic = true;
                MainCanvas.soundManager.Stop();
                MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                X.mainCanvas.setActiveScreen(3, null);
                MainCanvas.saveGame();
            }
        }
    }

    public void animateHide() {
        if (this.hiding && this.iconAnimation[0] == -(this.ICON_ANIMATION >> 1)) {
            if (this.iTableAnimation == 0) {
                this.iTableAnimation = 2;
            } else {
                this.iTableAnimation <<= 1;
                if (this.iTableAnimation >= this.TABLE_ANIMATION) {
                    this.changeMode();
                }
            }
        }
        if (this.hideScreen) {
            this.iHide <<= 1;
            if (Math.abs(this.iHide) > MainCanvas.WIDTH << 1) {
                this.resetShowAnimation();
                this.changeMode();
            }
        }
    }

    public void update(long lastRunLenght) {
        ++updateCounter;
        this.animateTable();
        this.animateHide();
        if (Resources.resGFonts[2] == null) {
            Resources.loadGFont(2);
        }
        int detailDescH = ShopItems.DESCRIPTION[this.SELECTED_SHOP_ITEM_ID].size() * Resources.resGFonts[2].getHeight();
        if (Keys.isActionPressed(2)) {
            if (this.scrollY < detailDescH - this.detailDescHSpace) {
                this.scrollY += 2;
            }
        } else if (Keys.isActionPressed(1) && this.scrollY > 0) {
            this.scrollY -= 2;
        }
        if (this.mode == 6) {
            if (this.modeDelay > 0L) {
                this.modeDelay -= 10L;
                return;
            }
            this.mainCanvas.repaint();
            if (Player.getStage() == 0 || Player.getStage() == 2 || Player.getStage() == 4) {
                this.mainCanvas.tutorialGame = 8;
            }
            MainCanvas.gameMusic = true;
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
            X.mainCanvas.setActiveScreen(3, null);
            MainCanvas.saveGame();
            this.mode = 4;
        }
        this.mainCanvas.repaint();
    }

    public void scrollText(int itemId) {
        if (ShopItems.TEXT_ANIMATION_DELAY[itemId] < 35 && ShopItems.TEXT_ANIMATION_DELAY[itemId] < 50) {
            int n = itemId;
            ShopItems.TEXT_ANIMATION_DELAY[n] = ShopItems.TEXT_ANIMATION_DELAY[n] + 5;
        } else if (ShopItems.TEXT_ANIMATION_DELAY[itemId] > 30 && ShopItems.TEXT_ANIMATION_DELAY[itemId] < 50) {
            int n = itemId;
            ShopItems.TEXT_ANIMATION[n] = ShopItems.TEXT_ANIMATION[n] + 5;
            if (ShopItems.TEXT_ANIMATION[itemId] > 50) {
                ShopItems.TEXT_ANIMATION[itemId] = 50;
                ShopItems.TEXT_ANIMATION_DELAY[itemId] = 50;
            }
        } else if (ShopItems.TEXT_ANIMATION_DELAY[itemId] == 50) {
            if (ShopItems.TEXT_ANIMATION[itemId] > 0) {
                int n = itemId;
                ShopItems.TEXT_ANIMATION[n] = ShopItems.TEXT_ANIMATION[n] - 5;
            } else {
                ShopItems.TEXT_ANIMATION_DELAY[itemId] = 0;
                ShopItems.TEXT_ANIMATION[itemId] = 0;
            }
        }
    }

    public void scrollTextReset() {
        for (int i = 0; i < ShopItems.TEXT_ANIMATION.length; ++i) {
            ShopItems.TEXT_ANIMATION[i] = 0;
        }
    }

    public void keyPressed(int keyCode) {
        if (Keys.isActionPressed(5) && this.mode == 5) {
            this.buttonState[this.SELECTED_SHOP_BUTTON_DETAIL] = 2;
        }
    }

    public void keyReleased(int keyCode) {
        if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55) {
            if (Keys.isActionPressed(3)) {
                switch (this.mode) {
                    case 4: {
                        if (this.CONTROL_MODE == 0) {
                            if (--SELECTED_CATEGORY >= 0) break;
                            SELECTED_CATEGORY = 3;
                            break;
                        }
                        if (this.SELECTED_SHOP_ITEM != 1 || SELECTED_CATEGORY == 3) {
                            // empty if block
                        }
                        if (this.SELECTED_SHOP_ITEM == 2 && SELECTED_CATEGORY == 3 || ShopItems.CAT_ITEMS_COUNT[SELECTED_CATEGORY] <= 3) break;
                        this.scrollTextReset();
                        if (this.SELECTED_SHOP_ITEM == 1 && SELECTED_CATEGORY == 3) {
                            System.out.println("C");
                            break;
                        }
                        if (this.SELECTED_SHOP_ITEM > 2) {
                            this.SELECTED_SHOP_ITEM -= 3;
                            break;
                        }
                        this.SELECTED_SHOP_ITEM += 3;
                        break;
                    }
                    case 5: {
                        if (this.DETAIL_BUTTONS_CASE == this.BUTTONS_CASE_FULL_UPGRADE_EQUIP) {
                            if (this.SELECTED_SHOP_BUTTON_DETAIL == 0) {
                                this.SELECTED_SHOP_BUTTON_DETAIL = 2;
                                break;
                            }
                            --this.SELECTED_SHOP_BUTTON_DETAIL;
                            break;
                        }
                        if (this.DETAIL_BUTTONS_CASE == this.BUTTONS_CASE_FULL_UPGRADE) {
                            if (this.SELECTED_SHOP_BUTTON_DETAIL == 0) {
                                this.SELECTED_SHOP_BUTTON_DETAIL = 1;
                                break;
                            }
                            --this.SELECTED_SHOP_BUTTON_DETAIL;
                            break;
                        }
                        if (this.DETAIL_BUTTONS_CASE == this.BUTTONS_CASE_UPGRADE) {
                            this.SELECTED_SHOP_BUTTON_DETAIL = 1;
                            break;
                        }
                        if (this.DETAIL_BUTTONS_CASE != this.BUTTONS_CASE_EQUIP) break;
                        this.SELECTED_SHOP_BUTTON_DETAIL = 2;
                    }
                }
            }
            if (Keys.isActionPressed(4)) {
                switch (this.mode) {
                    case 4: {
                        if (this.CONTROL_MODE == 0) {
                            if (++SELECTED_CATEGORY <= 3) break;
                            SELECTED_CATEGORY = 0;
                            break;
                        }
                        if (this.SELECTED_SHOP_ITEM != 1 || SELECTED_CATEGORY == 3) {
                            // empty if block
                        }
                        if (this.SELECTED_SHOP_ITEM == 2 && SELECTED_CATEGORY == 3 || ShopItems.CAT_ITEMS_COUNT[SELECTED_CATEGORY] <= 3) break;
                        this.scrollTextReset();
                        if (this.SELECTED_SHOP_ITEM == 1 && SELECTED_CATEGORY == 3) break;
                        if (this.SELECTED_SHOP_ITEM < 3) {
                            this.SELECTED_SHOP_ITEM += 3;
                            break;
                        }
                        this.SELECTED_SHOP_ITEM -= 3;
                        break;
                    }
                    case 5: {
                        if (this.DETAIL_BUTTONS_CASE == this.BUTTONS_CASE_FULL_UPGRADE_EQUIP) {
                            if (this.SELECTED_SHOP_BUTTON_DETAIL == 2) {
                                this.SELECTED_SHOP_BUTTON_DETAIL = 0;
                                break;
                            }
                            ++this.SELECTED_SHOP_BUTTON_DETAIL;
                            break;
                        }
                        if (this.DETAIL_BUTTONS_CASE == this.BUTTONS_CASE_FULL_UPGRADE) {
                            if (this.SELECTED_SHOP_BUTTON_DETAIL == 1) {
                                this.SELECTED_SHOP_BUTTON_DETAIL = 0;
                                break;
                            }
                            ++this.SELECTED_SHOP_BUTTON_DETAIL;
                            break;
                        }
                        if (this.DETAIL_BUTTONS_CASE == this.BUTTONS_CASE_UPGRADE) {
                            this.SELECTED_SHOP_BUTTON_DETAIL = 1;
                            break;
                        }
                        if (this.DETAIL_BUTTONS_CASE != this.BUTTONS_CASE_EQUIP) break;
                        this.SELECTED_SHOP_BUTTON_DETAIL = 2;
                    }
                }
            }
            if (Keys.isActionPressed(2)) {
                switch (this.mode) {
                    case 4: {
                        if (this.CONTROL_MODE == 0) {
                            this.CONTROL_MODE = 1;
                            this.SELECTED_SHOP_ITEM = 0;
                        } else if (this.SELECTED_SHOP_ITEM == 2 || this.SELECTED_SHOP_ITEM == 5) {
                            this.SELECTED_SHOP_ITEM -= 2;
                            System.out.println("-2");
                        } else if (SELECTED_CATEGORY == 3) {
                            System.out.println("0 : SELECTED_SHOP_ITEM: " + this.SELECTED_SHOP_ITEM);
                            if (this.SELECTED_SHOP_ITEM != 1 && this.SELECTED_SHOP_ITEM != 4) {
                                System.out.println("0000000000 : SELECTED_SHOP_ITEM: " + this.SELECTED_SHOP_ITEM);
                                if (this.SELECTED_SHOP_ITEM != 3 || SELECTED_CATEGORY != 3) {
                                    ++this.SELECTED_SHOP_ITEM;
                                }
                            } else if (this.SELECTED_SHOP_ITEM == 1 && SELECTED_CATEGORY == 3) {
                                ++this.SELECTED_SHOP_ITEM;
                            }
                        } else {
                            ++this.SELECTED_SHOP_ITEM;
                        }
                        this.scrollTextReset();
                    }
                }
            }
            if (Keys.isActionPressed(1)) {
                switch (this.mode) {
                    case 4: {
                        if (this.CONTROL_MODE == 1) {
                            if (this.SELECTED_SHOP_ITEM == 0 || this.SELECTED_SHOP_ITEM == 3) {
                                this.CONTROL_MODE = 0;
                            } else {
                                this.SELECTED_SHOP_ITEM = this.SELECTED_SHOP_ITEM == 0 || this.SELECTED_SHOP_ITEM == 3 ? (this.SELECTED_SHOP_ITEM += 2) : --this.SELECTED_SHOP_ITEM;
                            }
                        }
                        this.scrollTextReset();
                    }
                }
            }
            if (Keys.isActionGeneratedByKey(5, keyCode)) {
                if (this.mode == 4) {
                    if (this.CONTROL_MODE == 1) {
                        if (SELECTED_CATEGORY == 4) {
                            X.mainCanvas.buyingCoins = true;
                            X.mainCanvas.fullUpgrade = false;
                            X.mainCanvas.itemBuying = this.SELECTED_SHOP_ITEM_ID;
                        } else if (ShopItems.LOCKED[this.SELECTED_SHOP_ITEM_ID] <= Player.getStage()) {
                            this.mode = 5;
                        }
                    }
                } else if (this.mode == 5) {
                    this.buttonState[this.SELECTED_SHOP_BUTTON_DETAIL] = 0;
                    if (this.SELECTED_SHOP_BUTTON_DETAIL == 0) {
                        this.userClickedFullUpgradeButton();
                    } else if (this.SELECTED_SHOP_BUTTON_DETAIL == 1) {
                        this.userClickedBuyOrUpgradeButton();
                    } else if (this.SELECTED_SHOP_BUTTON_DETAIL == 2) {
                        this.userClickedEquipButton();
                    }
                }
            }
            if (Keys.isFKLeftCode(keyCode)) {
                switch (this.mode) {
                    case 4: {
                        this.mode = 6;
                        break;
                    }
                    case 5: {
                        if (this.SELECTED_SHOP_BUTTON_DETAIL == 0) {
                            this.userClickedFullUpgradeButton();
                            break;
                        }
                        if (this.SELECTED_SHOP_BUTTON_DETAIL == 1) {
                            this.userClickedBuyOrUpgradeButton();
                            break;
                        }
                        if (this.SELECTED_SHOP_BUTTON_DETAIL != 2) break;
                        this.userClickedEquipButton();
                    }
                }
            } else if (Keys.isFKRightCode(keyCode)) {
                switch (this.mode) {
                    case 4: {
                        if (this.backToItem != -9999) {
                            this.SELECTED_SHOP_ITEM = this.backToItem;
                            this.SELECTED_SHOP_ITEM_ID = this.backToItemID;
                            SELECTED_CATEGORY = this.backToCat;
                            this.backToItem = -9999;
                            this.backToItemID = -9999;
                            this.backToCat = -9999;
                            this.mode = 5;
                            break;
                        }
                        X.mainCanvas.setActiveScreen(1, null);
                        MainCanvas.saveGame();
                        break;
                    }
                    case 5: {
                        this.mode = 4;
                    }
                }
            }
        }
    }

    public void paint(Graphics g) {
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        switch (this.mode) {
            case 4: {
                this.paintShop(g);
                break;
            }
            case 5: {
                this.paintShopDetail(g);
                break;
            }
            case 6: {
                this.paintLoading(g);
            }
        }
    }

    public void paintLoading(Graphics g) {
        Common.paintMenuBackground(g);
        Common.drawCenteredText(g, 0, MainCanvas.HEIGHT >> 1, MainCanvas.WIDTH, Common.separateTextToLines(this.loading, MainCanvas.WIDTH, Resources.resGFonts[0]), Resources.resGFonts[0]);
    }

    public void paintShop(Graphics g) {
        Common.paintMenuBackground(g);
        Common.drawCenteredText(g, 0, MainCanvas.HEIGHT >> 1, MainCanvas.WIDTH, Common.separateTextToLines(this.loading, MainCanvas.WIDTH, Resources.resGFonts[0]), Resources.resGFonts[0]);
        Common.paintAnimatedMenuTable(MainCanvas.HEIGHT - Common.getInfoTableH(2) >> 1, 4, this.iTableAnimation, g);
        g.setClip(this.instX + this.iTableAnimation, 0, this.instW - (this.iTableAnimation << 1), MainCanvas.HEIGHT);
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        Sprite catIcons = Resources.resSprs[73];
        int catIconsW = catIcons.getWidth() + catIcons.getWidth() / 19;
        int catIconsH = catIcons.getHeight() + catIcons.getHeight() / 19;
        int firstCatIconStart = MainCanvas.WIDTH - catIconsW * 4 >> 1;
        int catIconsY = Common.animatedTableTopBorder(2) + catIconsH / 4 * 3;
        int catSelectorOffset = (Resources.resSprs[91].getWidth() - catIconsW >> 1) - 1;
        g.setColor(3153454);
        g.setColor(5717076);
        g.fillRect(firstCatIconStart + SELECTED_CATEGORY * catIconsW - catSelectorOffset, catIconsY - catSelectorOffset, Resources.resSprs[91].getWidth(), Resources.resSprs[91].getHeight());
        if (this.CONTROL_MODE == 0) {
            Resources.resSprs[91].setFrame(0);
            Resources.resSprs[91].setPosition(firstCatIconStart + SELECTED_CATEGORY * catIconsW - catSelectorOffset - 2, catIconsY - catSelectorOffset - 2);
            Resources.resSprs[91].paint(g);
            Resources.resSprs[91].setFrame(0);
            Resources.resSprs[91].setPosition(firstCatIconStart + SELECTED_CATEGORY * catIconsW - catSelectorOffset - 2, catIconsY - catSelectorOffset - 2);
            Resources.resSprs[91].paint(g);
        }
        for (int i = 0; i < 4; ++i) {
            int catIconX = firstCatIconStart + i * catIconsW;
            if (i < SELECTED_CATEGORY) {
                catIconX -= catSelectorOffset;
            }
            if (i > SELECTED_CATEGORY) {
                catIconX += catSelectorOffset;
            }
            catIcons.setFrame(i);
            catIcons.setPosition(catIconX, catIconsY);
            catIcons.paint(g);
            if (SELECTED_CATEGORY == i) continue;
            g.drawImage(Resources.resImgs[25], catIconX, catIconsY, 20);
        }
        switch (SELECTED_CATEGORY) {
            case 0: {
                this.strCategoryName = this.chrCatNameStats;
                break;
            }
            case 1: {
                this.strCategoryName = this.chrCatNameInventory;
                break;
            }
            case 2: {
                this.strCategoryName = this.chrCatNameMagicTower;
                break;
            }
            case 3: {
                this.strCategoryName = this.chrCatNameConsumables;
            }
        }
        Resources.resGFonts[0].drawString(g, this.strCategoryName, MainCanvas.WIDTH >> 1, catIconsY + catIcons.getHeight() + catIcons.getHeight() / 4, 3);
        Sprite shopItemsIcons = Resources.resSprs[ShopItems.CAT_ITEMS_ICON_RES[SELECTED_CATEGORY]];
        this.shopIconSmallWandH = shopItemsIcons.getHeight();
        int threePixels = this.shopIconSmallWandH / 10;
        int firstRowX = firstCatIconStart - Resources.resSprs[73].getHeight() / 2;
        int secondRowX = MainCanvas.WIDTH >> 1;
        int iconX = firstRowX;
        int iconY = 0;
        int firstIconY = catIconsY + catIconsH + catIconsH / 3 * 2 - 1;
        int itemIndex = 0;
        int verticalOffset = this.shopIconSmallWandH + (this.shopIconSmallWandH >> 1) + 1 + 3;
        for (int i = 0; i < ShopItems.CAT_ITEMS_COUNT[SELECTED_CATEGORY]; ++i) {
            itemIndex = ShopItems.SHOP_ITEMS_ORDER[SELECTED_CATEGORY * 6 + i];
            shopItemsIcons = Resources.resSprs[ShopItems.CAT_ITEMS_ICON_RES[ShopItems.CATEGORY[itemIndex]]];
            if (i < 3) {
                iconX = firstRowX;
                iconY = firstIconY + i * verticalOffset;
                g.drawImage(Resources.resImgs[24], MainCanvas.WIDTH >> 1, iconY - this.shopIconSmallWandH / 3 + 1, 17);
            } else {
                iconX = secondRowX;
                iconY = firstIconY + (i - 3) * verticalOffset;
            }
            if (i == this.SELECTED_SHOP_ITEM && this.CONTROL_MODE == 1) {
                int cursorOffset = Resources.resSprs[92].getWidth() - this.shopIconSmallWandH >> 1;
                Resources.resSprs[92].setFrame(1);
                Resources.resSprs[92].setPosition(iconX - cursorOffset, iconY - cursorOffset);
                Resources.resSprs[92].paint(g);
                this.SELECTED_SHOP_ITEM_ID = itemIndex;
                this.scrollText(itemIndex);
            }
            this.scrollText(itemIndex);
            this.menuItems[i] = new Rectangle(iconX, iconY, this.mainCanvas.getWidth() >> 1, shopItemsIcons.getHeight());
            shopItemsIcons.setFrame(ShopItems.SPR_FRAME[itemIndex]);
            shopItemsIcons.setPosition(iconX, iconY);
            if (SELECTED_CATEGORY != 3 || itemIndex <= 21) {
                shopItemsIcons.paint(g);
            }
            if (Player.getEquipedItemId(0) == itemIndex || Player.getEquipedItemId(1) == itemIndex || Player.getEquipedItemId(2) == itemIndex || Player.getEquipedStaff() == itemIndex || Player.getEquipedRobe() == itemIndex) {
                Resources.resSprs[82].setPosition(iconX + this.shopIconSmallWandH - Resources.resSprs[82].getWidth(), iconY + this.shopIconSmallWandH - Resources.resSprs[82].getHeight());
                Resources.resSprs[82].setFrame(0);
                if (SELECTED_CATEGORY == 3) {
                    // empty if block
                }
                Resources.resSprs[82].paint(g);
            }
            if (ShopItems.LOCKED[itemIndex] > Player.getStage()) {
                g.setClip(iconX, iconY, shopItemsIcons.getWidth(), shopItemsIcons.getHeight());
                g.drawImage(Resources.resImgs[25], iconX, iconY, 20);
                g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
                if (Resources.resImgs[7] != null) {
                    g.drawImage(Resources.resImgs[7], iconX + (this.shopIconSmallWandH >> 1), iconY + (this.shopIconSmallWandH >> 1), 3);
                }
            }
            threePixels = this.shopIconSmallWandH / 10;
            if (SELECTED_CATEGORY != 3 || itemIndex <= 21) {
                Common.drawScrollingText(g, ShopItems.TEXT_ANIMATION[itemIndex], iconX + this.shopIconSmallWandH + threePixels, iconY - 1, secondRowX - (firstRowX + this.shopIconSmallWandH + threePixels) - 1, ShopItems.NAME[itemIndex].toCharArray(), Resources.resGFonts[2]);
            }
            if (ShopItems.LOCKED[itemIndex] > Player.getStage()) {
                String neededLevel = this.nLevel;
                String neededLevel2 = this.nLevel2 + " " + String.valueOf(ShopItems.LOCKED[itemIndex]);
                if (SELECTED_CATEGORY == 3 && itemIndex > 21) continue;
                Resources.resGFonts[2].drawString(g, neededLevel.toCharArray(), iconX + (this.shopIconSmallWandH + threePixels), iconY + Resources.resSprs[73].getHeight() / 3 - threePixels, 20);
                Resources.resGFonts[2].drawString(g, neededLevel2.toCharArray(), iconX + (this.shopIconSmallWandH + threePixels), iconY + (Resources.resSprs[73].getHeight() / 3 << 1) - threePixels - threePixels, 20);
                continue;
            }
            if (itemIndex < 22 && (SELECTED_CATEGORY != 3 || itemIndex <= 21)) {
                Resources.resGFonts[3].drawString(g, ("@ " + ShopItems.VALUE[itemIndex]).toCharArray(), iconX + (this.shopIconSmallWandH + threePixels), iconY + Resources.resSprs[73].getHeight() / 3 - threePixels / 3 - 1, 20);
            }
            int currentItemLevelIndex = itemIndex - SELECTED_CATEGORY * 6;
            int currentItemLevel = 0;
            if (SELECTED_CATEGORY == 0) {
                currentItemLevel = Player.getStatValueExBonus(currentItemLevelIndex);
            } else if (SELECTED_CATEGORY == 1) {
                currentItemLevel = Player.getInventoryItemStatus(currentItemLevelIndex);
            } else if (SELECTED_CATEGORY == 2) {
                currentItemLevel = Player.getSpellStatus(currentItemLevelIndex);
            } else if (SELECTED_CATEGORY == 3) {
                currentItemLevel = Player.getConsumableCount(currentItemLevelIndex);
            } else if (SELECTED_CATEGORY == 4) {
                currentItemLevel = 0;
            }
            if (ShopItems.MAX_VALUE[itemIndex] <= currentItemLevel && ShopItems.MAX_VALUE[itemIndex] != 0) continue;
            if (ShopItems.REALCASH[itemIndex] == 0) {
                if (SELECTED_CATEGORY == 3 && itemIndex > 21) continue;
                Resources.resGFonts[4].drawString(g, ("@ " + String.valueOf(ShopItems.PRICE[itemIndex])).toCharArray(), iconX + (this.shopIconSmallWandH + threePixels), iconY + (Resources.resSprs[73].getHeight() / 3 << 1) - threePixels - 1, 20);
                continue;
            }
            if (SELECTED_CATEGORY == 3 && itemIndex > 21) continue;
            String realCashPrice = ShopItems.REAL_PRICE[itemIndex];
            Resources.resGFonts[4].drawString(g, ("@ " + String.valueOf(ShopItems.PRICE[itemIndex])).toCharArray(), iconX + (this.shopIconSmallWandH + threePixels), iconY + (Resources.resSprs[73].getHeight() / 3 << 1) - threePixels - 1, 20);
        }
        if (SELECTED_CATEGORY != 4 || ShopItems.CAT_ITEMS_COUNT[4] > 1) {
            // empty if block
        }
        int tableEnding = MainCanvas.HEIGHT - (MainCanvas.HEIGHT - Common.getTableH(4) >> 1);
        Resources.resGFonts[0].drawString(g, chrCash, MainCanvas.WIDTH >> 1, (tableEnding += threePixels) - Resources.resImgs[3].getHeight() - Resources.resImgs[3].getHeight(), 3);
        int stringW = Resources.resGFonts[0].stringWidth(chrCash);
        g.drawImage(Resources.resImgs[3], (MainCanvas.WIDTH >> 1) - (stringW >> 1) - (Resources.resImgs[3].getWidth() << 1), tableEnding - Resources.resImgs[3].getHeight() - Resources.resImgs[3].getHeight(), 6);
        Common.paintFNRight(2, g);
        Common.paintFNLeft(8, g);
        if (updateCounter % 2L == 0L) {
            ++this.selectorAnimation;
        }
        if (this.selectorAnimation > 3) {
            this.selectorAnimation = 0;
        }
    }

    public void paintShopDetail(Graphics g) {
        Common.paintMenuBackground(g);
        if (this.hideScreen) {
            g.translate(this.iHide, 0);
        }
        g.translate(this.iTableAnimation, 0);
        int leftBorder = Common.animatedTableLeftBorder();
        Common.paintAnimatedMenuTable(MainCanvas.HEIGHT - Common.getInfoTableH(2) >> 1, 4, this.iTableAnimation, g);
        g.setClip(this.instX + this.iTableAnimation, 0, this.instW - (this.iTableAnimation << 1), MainCanvas.HEIGHT);
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        Sprite shopItemsIcons = Resources.resSprs[ShopItems.CAT_ITEMS_ICON_RES[ShopItems.CATEGORY[this.SELECTED_SHOP_ITEM_ID]]];
        int tableTopY = MainCanvas.HEIGHT - Common.getInfoTableH(2) >> 1;
        int itemIconX = leftBorder + (this.shopIconSmallWandH >> 1);
        int itemIconX2 = leftBorder + this.shopIconSmallWandH;
        int itemIconY = this.shopIconSmallWandH + (this.shopIconSmallWandH >> 1);
        int threePixels = this.shopIconSmallWandH / 10;
        int fivePixels = this.shopIconSmallWandH / 6;
        Resources.resGFonts[2].drawString(g, ShopItems.NAME[this.SELECTED_SHOP_ITEM_ID].toCharArray(), itemIconX + this.shopIconSmallWandH + fivePixels, tableTopY + itemIconY, 20);
        if (buyItemEffect >= 0) {
            Resources.resSprs[92].setFrame(buyItemEffect);
            Resources.resSprs[92].setPosition(itemIconX - 2, tableTopY + itemIconY + (fivePixels - threePixels) - 3);
            Resources.resSprs[92].paint(g);
            if (++buyItemEffect == 4) {
                buyItemEffect = -9999;
            }
        }
        shopItemsIcons.setFrame(ShopItems.SPR_FRAME[this.SELECTED_SHOP_ITEM_ID]);
        shopItemsIcons.setPosition(itemIconX, tableTopY + itemIconY + (fivePixels - threePixels));
        shopItemsIcons.paint(g);
        if (this.SELECTED_SHOP_ITEM_ID < 22) {
            Resources.resGFonts[3].drawString(g, ("@ " + ShopItems.VALUE[this.SELECTED_SHOP_ITEM_ID]).toCharArray(), itemIconX + this.shopIconSmallWandH + fivePixels, tableTopY + itemIconY + 5 * threePixels, 20);
        }
        g.drawImage(Resources.resImgs[24], MainCanvas.WIDTH >> 1, tableTopY + this.shopIconSmallWandH * 3 + threePixels, 17);
        this.detailDescHSpace = Resources.resGFonts[2].getHeight() * 4;
        ++this.detailDescHSpace;
        int rowWidth = Common.getTableW() / 3;
        g.setClip(itemIconX, tableTopY + this.shopIconSmallWandH * 3 + threePixels * 6, MainCanvas.WIDTH / 4 * 3, this.detailDescHSpace);
        if (this.SELECTED_SHOP_ITEM_ID > 5 && this.SELECTED_SHOP_ITEM_ID < 12 && Player.getInventoryItemStatus(this.SELECTED_SHOP_ITEM_ID - 6) == 0 || this.SELECTED_SHOP_ITEM_ID > 11 && this.SELECTED_SHOP_ITEM_ID < 15 && Player.getSpellStatus(this.SELECTED_SHOP_ITEM_ID - 12) == 0) {
            rowWidth = 0;
            if (ShopItems.DESCRIPTION2ROW[this.SELECTED_SHOP_ITEM_ID] != null) {
                if (this.SELECTED_SHOP_ITEM_ID == 12) {
                    Common.drawSeparatedText(g, itemIconX + rowWidth, tableTopY + this.shopIconSmallWandH * 3 + threePixels * 6 - this.scrollY, Common.separateTextToLines(ShopItems.chrSpell1Desc, Common.getTableW() / 3 * 2 + 15, Resources.resGFonts[2]), Resources.resGFonts[2]);
                }
                if (this.SELECTED_SHOP_ITEM_ID == 13) {
                    Common.drawSeparatedText(g, itemIconX + rowWidth, tableTopY + this.shopIconSmallWandH * 3 + threePixels * 6 - this.scrollY, Common.separateTextToLines(ShopItems.chrSpell2Desc, Common.getTableW() / 3 * 2 + 15, Resources.resGFonts[2]), Resources.resGFonts[2]);
                }
                if (this.SELECTED_SHOP_ITEM_ID == 14) {
                    Common.drawSeparatedText(g, itemIconX + rowWidth, tableTopY + this.shopIconSmallWandH * 3 + threePixels * 6 - this.scrollY, Common.separateTextToLines(ShopItems.chrSpell3Desc, Common.getTableW() / 3 * 2 + 15, Resources.resGFonts[2]), Resources.resGFonts[2]);
                }
                Common.drawSeparatedText(g, itemIconX + rowWidth, tableTopY + this.shopIconSmallWandH * 3 + threePixels * 6 - this.scrollY, ShopItems.DESCRIPTION2ROW[this.SELECTED_SHOP_ITEM_ID], Resources.resGFonts[2]);
            }
        } else if (ShopItems.DESCRIPTION2ROW[this.SELECTED_SHOP_ITEM_ID] != null) {
            this.textCheck = true;
            Common.drawSeparatedText(g, itemIconX, tableTopY + this.shopIconSmallWandH * 3 + threePixels * 6 - this.scrollY, ShopItems.DESCRIPTION[this.SELECTED_SHOP_ITEM_ID], Resources.resGFonts[2]);
            Common.drawSeparatedText(g, itemIconX2 + rowWidth + 15, tableTopY + this.shopIconSmallWandH * 3 + threePixels * 6 - this.scrollY, ShopItems.DESCRIPTION2ROW[this.SELECTED_SHOP_ITEM_ID], Resources.resGFonts[2]);
        } else {
            this.textCheck = false;
            Common.drawSeparatedText(g, itemIconX, tableTopY + this.shopIconSmallWandH * 3 + threePixels * 6 - this.scrollY, ShopItems.DESCRIPTION[this.SELECTED_SHOP_ITEM_ID], Resources.resGFonts[2]);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        int detailDescH = ShopItems.DESCRIPTION[this.SELECTED_SHOP_ITEM_ID].size() * Resources.resGFonts[2].getHeight();
        int moveYPercentage = this.scrollY * 1000 / (detailDescH - this.detailDescHSpace) * 100 / 1000;
        g.drawImage(Resources.resImgs[24], MainCanvas.WIDTH >> 1, tableTopY + this.shopIconSmallWandH * 5 + fivePixels * 4, 17);
        int firstButtonPositionX = 0;
        int thisItemCount = 0;
        if (SELECTED_CATEGORY == 0) {
            thisItemCount = Player.getStatValueExBonus(ShopItems.INCAT_INDEX[this.SELECTED_SHOP_ITEM_ID]);
        }
        if (SELECTED_CATEGORY == 1) {
            thisItemCount = Player.getInventoryItemStatus(ShopItems.INCAT_INDEX[this.SELECTED_SHOP_ITEM_ID]);
        }
        if (SELECTED_CATEGORY == 2) {
            thisItemCount = Player.getSpellStatus(ShopItems.INCAT_INDEX[this.SELECTED_SHOP_ITEM_ID]);
        }
        if (SELECTED_CATEGORY == 3) {
            thisItemCount = Player.getConsumableCount(ShopItems.INCAT_INDEX[this.SELECTED_SHOP_ITEM_ID]);
        }
        if (ShopItems.MAX_VALUE[this.SELECTED_SHOP_ITEM_ID] > thisItemCount || ShopItems.MAX_VALUE[this.SELECTED_SHOP_ITEM_ID] == 0) {
            if (this.SELECTED_SHOP_ITEM_ID > 5 && this.SELECTED_SHOP_ITEM_ID < 12 || this.SELECTED_SHOP_ITEM_ID > 14 && this.SELECTED_SHOP_ITEM_ID < 18) {
                this.DETAIL_BUTTONS_CASE = this.BUTTONS_CASE_FULL_UPGRADE_EQUIP;
                if (ShopItems.EQUIPABLE[this.SELECTED_SHOP_ITEM_ID] == 0 || thisItemCount == 0 || Player.getEquipedItemId(0) == this.SELECTED_SHOP_ITEM_ID || Player.getEquipedItemId(1) == this.SELECTED_SHOP_ITEM_ID || Player.getEquipedItemId(2) == this.SELECTED_SHOP_ITEM_ID || Player.getEquipedStaff() == this.SELECTED_SHOP_ITEM_ID || Player.getEquipedRobe() == this.SELECTED_SHOP_ITEM_ID) {
                    this.DETAIL_BUTTONS_CASE = this.BUTTONS_CASE_FULL_UPGRADE;
                }
            } else {
                this.DETAIL_BUTTONS_CASE = this.BUTTONS_CASE_UPGRADE;
            }
        } else if (this.SELECTED_SHOP_ITEM_ID > 5 && this.SELECTED_SHOP_ITEM_ID < 12) {
            this.DETAIL_BUTTONS_CASE = this.BUTTONS_CASE_EQUIP;
            if (ShopItems.EQUIPABLE[this.SELECTED_SHOP_ITEM_ID] == 0 || thisItemCount == 0 || Player.getEquipedItemId(0) == this.SELECTED_SHOP_ITEM_ID || Player.getEquipedItemId(1) == this.SELECTED_SHOP_ITEM_ID || Player.getEquipedItemId(2) == this.SELECTED_SHOP_ITEM_ID || Player.getEquipedStaff() == this.SELECTED_SHOP_ITEM_ID || Player.getEquipedRobe() == this.SELECTED_SHOP_ITEM_ID) {
                this.DETAIL_BUTTONS_CASE = this.BUTTONS_CASE_NONE;
            }
        } else {
            this.DETAIL_BUTTONS_CASE = this.BUTTONS_CASE_NONE;
        }
        if (this.SELECTED_SHOP_ITEM_ID == 16 && thisItemCount > 0) {
            this.DETAIL_BUTTONS_CASE = this.BUTTONS_CASE_UPGRADE;
        }
        if (this.DETAIL_BUTTONS_CASE == this.BUTTONS_CASE_UPGRADE) {
            firstButtonPositionX = leftBorder + (Resources.resSprs[0].getWidth() - Resources.resSprs[89].getWidth() * 6 >> 1);
        }
        if (this.DETAIL_BUTTONS_CASE == this.BUTTONS_CASE_EQUIP) {
            firstButtonPositionX = leftBorder + (Resources.resSprs[0].getWidth() - Resources.resSprs[89].getWidth() * 6 >> 1);
            this.SELECTED_SHOP_BUTTON_DETAIL = this.BUTTON_EQUIP;
        }
        if (this.DETAIL_BUTTONS_CASE == this.BUTTONS_CASE_FULL_UPGRADE_EQUIP) {
            firstButtonPositionX = leftBorder + (Resources.resSprs[0].getWidth() - Resources.resSprs[89].getWidth() * 6 * 2 - Resources.resSprs[89].getWidth() * 3 >> 1);
        }
        int twoHtwelve = Common.animatedTableTopBorder(2) + this.shopIconSmallWandH * 6 + (fivePixels - threePixels);
        if (this.DETAIL_BUTTONS_CASE != this.BUTTONS_CASE_NONE) {
            String text = "";
            firstButtonPositionX += Resources.resSprs[89].getWidth() * 3;
            if (this.DETAIL_BUTTONS_CASE != this.BUTTONS_CASE_EQUIP) {
                if (SELECTED_CATEGORY == 3) {
                    text = this.chrBuy;
                }
                if (SELECTED_CATEGORY != 3) {
                    text = this.chrUpgrade;
                }
                if (ShopItems.REALCASH[this.SELECTED_SHOP_ITEM_ID] == 0) {
                    text = text + " ^ x " + ShopItems.PRICE[this.SELECTED_SHOP_ITEM_ID];
                    price = ShopItems.PRICE[this.SELECTED_SHOP_ITEM_ID];
                } else {
                    String realCashPrice = ShopItems.REAL_PRICE[this.SELECTED_SHOP_ITEM_ID];
                    text = text + " ^ " + realCashPrice;
                    price = ShopItems.PRICE[this.SELECTED_SHOP_ITEM_ID];
                }
                firstButtonPositionX = leftBorder + (Resources.resSprs[0].getWidth() - Resources.resSprs[89].getWidth() * 6 >> 1);
                Common.paintShopButton(g, text, firstButtonPositionX, twoHtwelve, 4, this.buttonState[this.BUTTON_EQUIP]);
                firstButtonPositionX += Resources.resSprs[89].getWidth() * 6;
            }
            if (this.DETAIL_BUTTONS_CASE == this.BUTTONS_CASE_FULL_UPGRADE_EQUIP || this.DETAIL_BUTTONS_CASE == this.BUTTONS_CASE_EQUIP) {
                text = this.chrEquip;
                if (this.DETAIL_BUTTONS_CASE == this.BUTTONS_CASE_EQUIP) {
                    Common.paintShopButton(g, text, firstButtonPositionX, twoHtwelve, 4, this.buttonState[this.BUTTON_EQUIP]);
                } else {
                    Common.paintShopButton(g, text, firstButtonPositionX, twoHtwelve, 1, this.buttonState[this.BUTTON_EQUIP]);
                }
            }
        }
        for (int i = 0; i < 3; ++i) {
            if (this.SELECTED_SHOP_BUTTON_DETAIL == i) {
                if (this.buttonState[i] != 2) {
                    this.buttonState[i] = 1;
                }
                if (this.buttonState[i] == 2) continue;
                this.buttonState[i] = 1;
                continue;
            }
            if (this.buttonState[i] == 2) continue;
            this.buttonState[i] = 0;
        }
        int tableEnding = MainCanvas.HEIGHT - (MainCanvas.HEIGHT - Common.getTableH(4) >> 1);
        Resources.resGFonts[0].drawString(g, chrCash, MainCanvas.WIDTH >> 1, (tableEnding += threePixels) - Resources.resImgs[3].getHeight() - Resources.resImgs[3].getHeight(), 3);
        int stringW = Resources.resGFonts[0].stringWidth(chrCash);
        g.drawImage(Resources.resImgs[3], (MainCanvas.WIDTH >> 1) - (stringW >> 1) - (Resources.resImgs[3].getWidth() << 1), tableEnding - Resources.resImgs[3].getHeight() - Resources.resImgs[3].getHeight(), 6);
        if (detailDescH > this.detailDescHSpace) {
            Common.paintScrollbar(g, 4, moveYPercentage);
        }
        Common.paintFNLeft(0, g);
        Common.paintFNRight(2, g);
    }

    public void pointerPressed(int x, int y) {
        switch (this.mode) {
            case 4: {
                Sprite catIcons = Resources.resSprs[73];
                int firstCatIconStart = MainCanvas.WIDTH - catIcons.getWidth() * 4 >> 1;
                int catIconsY = Common.animatedTableTopBorder(2) + catIcons.getHeight() / 4 * 3;
                int catSelectorOffset = Resources.resSprs[91].getWidth() - catIcons.getWidth() >> 1;
                if (y >= catIconsY && y <= catIconsY + catIcons.getHeight()) {
                    for (int i = 0; i < 4; ++i) {
                        int catIconX = firstCatIconStart + i * catIcons.getWidth();
                        if (i < SELECTED_CATEGORY) {
                            catIconX -= catSelectorOffset;
                        }
                        if (i > SELECTED_CATEGORY) {
                            catIconX += catSelectorOffset;
                        }
                        if (x < catIconX || x > catIconX + catIcons.getWidth()) continue;
                        SELECTED_CATEGORY = i;
                    }
                }
                for (int a = 0; a < this.menuItems.length; ++a) {
                    int itemIndex;
                    if (!this.menuItems[a].contains(x, y)) continue;
                    this.SELECTED_SHOP_ITEM_ID = itemIndex = ShopItems.SHOP_ITEMS_ORDER[SELECTED_CATEGORY * 6 + a];
                    this.SELECTED_SHOP_ITEM = a;
                    if (ShopItems.LOCKED[this.SELECTED_SHOP_ITEM_ID] > Player.getStage()) {
                        this.iHide = 0;
                        this.hideScreen = false;
                        for (int f = 0; f < this.menuItems.length; ++f) {
                        }
                        continue;
                    }
                    if (SELECTED_CATEGORY == 3 && a > 3) continue;
                    this.SELECTED_SHOP_ITEM_ID = itemIndex;
                    this.SELECTED_SHOP_ITEM = a;
                    this.mode = 5;
                }
                break;
            }
            case 5: {
                this.instOldY = y;
                int leftBorder = Common.animatedTableLeftBorder();
                int firstButtonPositionX = 0;
                int threePixels = this.shopIconSmallWandH / 10;
                int fivePixels = this.shopIconSmallWandH / 6;
                int twoHtwelve = Common.animatedTableTopBorder(2) + this.shopIconSmallWandH * 6 + (fivePixels - threePixels);
                if (this.DETAIL_BUTTONS_CASE == this.BUTTONS_CASE_UPGRADE) {
                    firstButtonPositionX = leftBorder + (Resources.resSprs[0].getWidth() - Resources.resSprs[89].getWidth() * 6 >> 1);
                }
                if (this.DETAIL_BUTTONS_CASE == this.BUTTONS_CASE_EQUIP) {
                    firstButtonPositionX = leftBorder + (Resources.resSprs[0].getWidth() - Resources.resSprs[89].getWidth() * 6 >> 1);
                    this.SELECTED_SHOP_BUTTON_DETAIL = this.BUTTON_EQUIP;
                }
                if (this.DETAIL_BUTTONS_CASE == this.BUTTONS_CASE_FULL_UPGRADE) {
                    firstButtonPositionX = leftBorder + (Resources.resSprs[0].getWidth() - Resources.resSprs[89].getWidth() * 6 * 2 >> 1);
                }
                if (this.DETAIL_BUTTONS_CASE == this.BUTTONS_CASE_FULL_UPGRADE_EQUIP) {
                    firstButtonPositionX = leftBorder + (Resources.resSprs[0].getWidth() - Resources.resSprs[89].getWidth() * 6 * 2 - Resources.resSprs[89].getWidth() * 3 >> 1);
                }
                if (y <= twoHtwelve || y >= twoHtwelve + Resources.resSprs[89].getHeight() || this.DETAIL_BUTTONS_CASE == this.BUTTONS_CASE_NONE) break;
                int butW = Resources.resSprs[89].getWidth() * 6;
                if (this.DETAIL_BUTTONS_CASE == this.BUTTONS_CASE_FULL_UPGRADE) {
                    if (x > firstButtonPositionX && x < firstButtonPositionX + butW) {
                        this.trace("klikol na full upgrade");
                        this.userClickedFullUpgradeButton();
                    }
                    if (x > firstButtonPositionX + butW && x < firstButtonPositionX + butW + butW) {
                        this.trace("klikol na buy/upgrade");
                        this.userClickedBuyOrUpgradeButton();
                    }
                }
                if (this.DETAIL_BUTTONS_CASE == this.BUTTONS_CASE_UPGRADE && x > firstButtonPositionX && x < firstButtonPositionX + butW) {
                    this.trace("klikol na buy/upgrade");
                    this.userClickedBuyOrUpgradeButton();
                }
                if (this.DETAIL_BUTTONS_CASE == this.BUTTONS_CASE_FULL_UPGRADE_EQUIP) {
                    if (x > firstButtonPositionX && x < firstButtonPositionX + butW) {
                        this.trace("klikol na full upgrade");
                        this.userClickedFullUpgradeButton();
                    }
                    if (x > firstButtonPositionX + butW && x < firstButtonPositionX + butW + butW) {
                        this.trace("klikol na buy/upgrade");
                        this.userClickedBuyOrUpgradeButton();
                    }
                    if (x > firstButtonPositionX + butW + butW && x < firstButtonPositionX + butW + butW + butW) {
                        this.trace("klikol na equip");
                        this.userClickedEquipButton();
                    }
                }
                if (this.DETAIL_BUTTONS_CASE != this.BUTTONS_CASE_EQUIP || x <= firstButtonPositionX || x >= firstButtonPositionX + butW) break;
                this.trace("klikol na equip");
                this.userClickedEquipButton();
            }
        }
        if (y > MainCanvas.HEIGHT - (Resources.resSprs[4].getHeight() << 1)) {
            if (x > MainCanvas.WIDTH - (Resources.resSprs[4].getWidth() << 1)) {
                switch (this.mode) {
                    case 4: {
                        X.mainCanvas.setActiveScreen(1, null);
                        MainCanvas.saveGame();
                        break;
                    }
                    case 5: {
                        this.mode = 4;
                    }
                }
            } else if (x < Resources.resSprs[4].getWidth() << 1) {
                switch (this.mode) {
                    case 4: {
                        this.mode = 6;
                        break;
                    }
                    case 5: {
                        if (this.SELECTED_SHOP_BUTTON_DETAIL == 0) {
                            this.userClickedFullUpgradeButton();
                            break;
                        }
                        if (this.SELECTED_SHOP_BUTTON_DETAIL == 1) {
                            this.userClickedBuyOrUpgradeButton();
                            break;
                        }
                        if (this.SELECTED_SHOP_BUTTON_DETAIL != 2) break;
                        this.userClickedEquipButton();
                    }
                }
            }
        }
    }

    private void userClickedBuyOrUpgradeButton() {
        if (Player.hasEnoughtGoldToBuyItem(this.SELECTED_SHOP_ITEM_ID) || ShopItems.REALCASH[this.SELECTED_SHOP_ITEM_ID] == 1) {
            int thisItemCount = 0;
            if (SELECTED_CATEGORY == 0) {
                thisItemCount = Player.getStatValueExBonus(ShopItems.INCAT_INDEX[this.SELECTED_SHOP_ITEM_ID]);
            }
            if (SELECTED_CATEGORY == 1) {
                thisItemCount = Player.getInventoryItemStatus(ShopItems.INCAT_INDEX[this.SELECTED_SHOP_ITEM_ID]);
            }
            if (SELECTED_CATEGORY == 2) {
                thisItemCount = Player.getSpellStatus(ShopItems.INCAT_INDEX[this.SELECTED_SHOP_ITEM_ID]);
            }
            if (SELECTED_CATEGORY == 3) {
                thisItemCount = Player.getConsumableCount(ShopItems.INCAT_INDEX[this.SELECTED_SHOP_ITEM_ID]);
            }
            if (ShopItems.MAX_VALUE[this.SELECTED_SHOP_ITEM_ID] > thisItemCount || ShopItems.MAX_VALUE[this.SELECTED_SHOP_ITEM_ID] == 0) {
                if (SELECTED_CATEGORY == 0) {
                    Player.upgradeStat(this.SELECTED_SHOP_ITEM_ID - 6 * SELECTED_CATEGORY, price);
                }
                if (SELECTED_CATEGORY == 1) {
                    Player.upgradeInventoryItem(this.SELECTED_SHOP_ITEM_ID - 6 * SELECTED_CATEGORY, price);
                }
                if (SELECTED_CATEGORY == 2 && ShopItems.MAX_VALUE[this.SELECTED_SHOP_ITEM_ID] >= Player.getSpellStatus(this.SELECTED_SHOP_ITEM_ID - 6 * SELECTED_CATEGORY) + 1) {
                    if (ShopItems.REALCASH[this.SELECTED_SHOP_ITEM_ID] == 1) {
                        X.mainCanvas.buyingCoins = false;
                        X.mainCanvas.fullUpgrade = false;
                        X.mainCanvas.itemBuying = this.SELECTED_SHOP_ITEM_ID;
                    } else {
                        Player.upgradeSpell(this.SELECTED_SHOP_ITEM_ID - 6 * SELECTED_CATEGORY, price);
                    }
                }
                if (SELECTED_CATEGORY == 3) {
                    boolean priceLevel = false;
                    if (ShopItems.REALCASH[this.SELECTED_SHOP_ITEM_ID] == 1) {
                        X.mainCanvas.buyingCoins = false;
                        X.mainCanvas.fullUpgrade = false;
                        X.mainCanvas.itemBuying = this.SELECTED_SHOP_ITEM_ID;
                    } else {
                        Player.buyConsumable(this.SELECTED_SHOP_ITEM_ID - 6 * SELECTED_CATEGORY, price);
                    }
                }
                if (SELECTED_CATEGORY == 4) {
                    X.mainCanvas.buyingCoins = true;
                    X.mainCanvas.fullUpgrade = false;
                    X.mainCanvas.itemBuying = this.SELECTED_SHOP_ITEM_ID;
                }
            }
        }
        ScreenShop.reloadShopItemsData();
    }

    private void userClickedEquipButton() {
        if (ShopItems.EQUIPABLE[this.SELECTED_SHOP_ITEM_ID] == 1) {
            Player.equipItem(this.SELECTED_SHOP_ITEM_ID);
            this.SELECTED_SHOP_BUTTON_DETAIL = 1;
        }
        ScreenShop.reloadShopItemsData();
    }

    private void userClickedFullUpgradeButton() {
        if (this.SELECTED_SHOP_ITEM_ID > 5 && this.SELECTED_SHOP_ITEM_ID < 12 || this.SELECTED_SHOP_ITEM_ID > 14 && this.SELECTED_SHOP_ITEM_ID < 18) {
            X.mainCanvas.buyingCoins = false;
            X.mainCanvas.itemBuying = this.SELECTED_SHOP_ITEM_ID;
            X.mainCanvas.fullUpgrade = true;
        }
    }

    public void pointerDragged(int x, int y) {
        switch (this.mode) {
            case 5: {
                int detailDescH = ShopItems.DESCRIPTION[this.SELECTED_SHOP_ITEM_ID].size() * Resources.resGFonts[2].getHeight();
                this.scrollY += this.instOldY - y;
                this.instOldY = y;
                if (this.scrollY > detailDescH - this.detailDescHSpace) {
                    this.scrollY = detailDescH - this.detailDescHSpace;
                }
                if (this.scrollY >= 0) break;
                this.scrollY = 0;
            }
        }
    }

    public void pointerReleased(int x, int y) {
    }

    static {
        SELECTED_CATEGORY = 0;
        price = 0;
        updateCounter = 0L;
        buyItemEffect = -9999;
    }
}

