/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import sk.inlogic.Player;

public class State {
    public static int INT_NULL = -9999;
    static final String RS_SETTINGS = "A";
    static final String RS_LOADSAVE = "B";
    static final String RS_TMPSAVE = "C";
    static RecordStore rsobj_settings = null;
    static RecordStore rsobj_loadsave = null;

    private void saveGame(DataOutputStream data) throws IOException {
        System.out.println("saveGame(data) - in");
        try {
            for (int i = 0; i < 1; ++i) {
                int j;
                data.writeInt(Player.getCash());
                data.writeInt(Player.getStage());
                data.writeInt(Player.getGeneratorSet());
                for (j = 0; j < 6; ++j) {
                    data.writeInt(Player.getStatValueExBonus(j));
                }
                for (j = 0; j < 6; ++j) {
                    data.writeInt(Player.getSpellStatus(j));
                }
                for (j = 0; j < 6; ++j) {
                    data.writeInt(Player.getInventoryItemStatus(j));
                }
                for (j = 0; j < 6; ++j) {
                    data.writeInt(Player.getConsumableCount(j));
                }
                data.writeInt(Player.getEquipedStaff());
                data.writeInt(Player.getEquipedRobe());
                data.writeInt(Player.streak);
                data.writeInt(Player.loseCountInRow);
                data.writeInt(Player.towerUpgradeLvl);
                data.writeBoolean(Player.towerWasUpgraded);
                data.writeInt(Player.dieHintStep);
                data.writeInt(Player.enemiesStronger);
                data.writeBoolean(Player.diedMoreThanOnce);
            }
        }
        catch (Exception e) {
            System.out.println("Error saveGame: " + e);
        }
        System.out.println("saveGame(data) - out");
    }

    private void saveSettings(DataOutputStream data) throws IOException {
        System.out.println("saveGame(data) - in");
        System.out.println("saveGame(data) - out");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGame(String rstoreName) {
        System.out.println("saveGame() - in");
        this.deleteSavedGame(rstoreName);
        try {
            rsobj_loadsave = RecordStore.openRecordStore((String)rstoreName, (boolean)true);
            ByteArrayOutputStream array = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(array);
            if (rstoreName == RS_LOADSAVE) {
                this.saveGame(data);
            } else if (rstoreName == RS_SETTINGS) {
                this.saveSettings(data);
            }
            rsobj_loadsave.addRecord(array.toByteArray(), 0, array.toByteArray().length);
            rsobj_loadsave.closeRecordStore();
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
            this.deleteSavedGame(rstoreName);
        }
        finally {
            if (rsobj_loadsave != null) {
                try {
                    rsobj_loadsave.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
        System.out.println("saveGame() - out");
    }

    public void deleteSavedGame(String rstoreName) {
        System.out.println("deleteSavedGame(boolean) - in");
        try {
            RecordStore.deleteRecordStore((String)rstoreName);
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
        System.out.println("deleteSavedGame(boolean) - out");
    }

    public void deleteSavedGame() {
        System.out.println("deleteSavedGame(boolean) - in");
        try {
            RecordStore.deleteRecordStore((String)RS_LOADSAVE);
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
        System.out.println("deleteSavedGame(boolean) - out");
    }

    private void loadGame(DataInputStream data) throws IOException {
        System.out.println("loadGame(data) - in");
        try {
            for (int i = 0; i < 1; ++i) {
                int j;
                System.out.println("LOAD PLAYER : " + i);
                Player.setCash(data.readInt());
                Player.setStage(data.readInt());
                Player.setGeneratorSet(data.readInt());
                System.out.println("LOAD 1");
                for (j = 0; j < 6; ++j) {
                    Player.setStatValue(j, data.readInt());
                }
                System.out.println("LOAD 2");
                for (j = 0; j < 6; ++j) {
                    Player.setSpellValue(j, data.readInt());
                }
                System.out.println("LOAD 3");
                for (j = 0; j < 6; ++j) {
                    Player.setInventoryItemValue(j, data.readInt());
                }
                System.out.println("LOAD 4");
                for (j = 0; j < 6; ++j) {
                    Player.setConsumableCount(j, data.readInt());
                }
                System.out.println("LOAD 5");
                Player.equipItem(data.readInt());
                System.out.println("LOAD 6");
                Player.equipItem(data.readInt());
                Player.streak = data.readInt();
                Player.loseCountInRow = data.readInt();
                Player.towerUpgradeLvl = data.readInt();
                Player.towerWasUpgraded = data.readBoolean();
                Player.dieHintStep = data.readInt();
                Player.enemiesStronger = data.readInt();
                Player.diedMoreThanOnce = data.readBoolean();
            }
        }
        catch (Exception e) {
            System.out.println("error loadGame: " + e);
        }
        System.out.println("loadGame(data) - out");
    }

    private void loadSettings(DataInputStream data) throws IOException {
        System.out.println("loadGame(data) - in");
        System.out.println("loadGame(data) - out");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadGame(String rstoreName) {
        System.out.println("loadGame() - in");
        try {
            rsobj_loadsave = RecordStore.openRecordStore((String)rstoreName, (boolean)false);
            RecordEnumeration renum = rsobj_loadsave.enumerateRecords(null, null, false);
            int i = renum.nextRecordId();
            byte[] record = rsobj_loadsave.getRecord(i);
            DataInputStream data = new DataInputStream(new ByteArrayInputStream(record));
            if (rstoreName == RS_LOADSAVE) {
                this.loadGame(data);
            } else if (rstoreName == RS_SETTINGS) {
                this.loadSettings(data);
            }
            rsobj_loadsave.closeRecordStore();
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
        finally {
            if (rsobj_loadsave != null) {
                try {
                    rsobj_loadsave.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
        System.out.println("loadGame() - out");
    }

    public static boolean canLoadGame(String rstoreName) {
        System.out.println("canLoadGame() - in");
        boolean RetVal = false;
        RecordEnumeration renum = null;
        try {
            rsobj_loadsave = RecordStore.openRecordStore((String)rstoreName, (boolean)false);
            renum = rsobj_loadsave.enumerateRecords(null, null, false);
            RetVal = renum.numRecords() > 0;
            rsobj_loadsave.closeRecordStore();
            rsobj_loadsave = null;
            renum = null;
            System.gc();
        }
        catch (Exception ex) {
            RetVal = false;
            System.out.println("Menu.canLoadGame() - exception : " + ex.toString());
        }
        if (rsobj_loadsave != null) {
            try {
                rsobj_loadsave.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        rsobj_loadsave = null;
        renum = null;
        System.gc();
        System.out.println("canLoadGame() - out");
        return RetVal;
    }
}

