/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import java.util.Vector;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import sk.inlogic.Common;
import sk.inlogic.Player;
import sk.inlogic.Resources;
import sk.inlogic.ScreenGame;
import sk.inlogic.ScreenIntro;
import sk.inlogic.ScreenLanguages;
import sk.inlogic.ScreenMenu;
import sk.inlogic.ScreenQuit;
import sk.inlogic.ScreenShop;
import sk.inlogic.ScreenSounds;
import sk.inlogic.ScreenSplash;
import sk.inlogic.Sounds;
import sk.inlogic.State;
import sk.inlogic.X;
import sk.inlogic.fx.SoundManager;
import sk.inlogic.screen.IScreen;
import sk.inlogic.text.ResourceBundle;
import sk.inlogic.util.Keys;

public class MainCanvas
extends GameCanvas
implements Runnable {
    public static final int FPS = 40;
    public static boolean ES = false;
    public static boolean EN = false;
    public static boolean FR = false;
    public static boolean PT = false;
    public static boolean DE = false;
    public static int soundVolume = 0;
    public static int WIDTH = 0;
    public static int HEIGHT = 0;
    public static int WIDTH_FROM_DC = 0;
    public static int HEIGHT_FROM_DC = 0;
    private static Thread mainThread;
    private static IScreen activeScreen;
    private static State state;
    public long lLastRun;
    public static final int SCREEN_LANGUAGES = 0;
    public static final int SCREEN_MENU = 1;
    public static final int SCREEN_GAME_TYPE = 2;
    public static final int SCREEN_GAME = 3;
    public static final int SCREEN_SHOP = 5;
    public static final int SCREEN_SOUNDS = 6;
    public static final int SCREEN_INTRO = 7;
    public static final int SCREEN_AVATAR = 8;
    public static final int SCREEN_QUIT = 9;
    public static final int SCREEN_SPLASH = 10;
    public static final int TOTAL_SCREENS = 11;
    private IScreen[] screens = new IScreen[11];
    private boolean interuptionIn;
    private boolean paintPaused;
    private boolean bScreenSizeAdjusted;
    public boolean inGameHourglassPurchase = false;
    public static boolean music;
    public static Player[] player;
    public static int activePlayer;
    public static ResourceBundle texts;
    public static SoundManager soundManager;
    public static int coinPackPurchuasing;
    public static String playerName;
    public static int[] coinPackagesQuantity;
    public static boolean limitedOffer;
    public static int limitedOfferItem;
    public static int specialOffer;
    public static final int DAMAGE_UPGRADE = 1;
    public static final int HEALTH_UPGRADE = 2;
    public static final int MANA_UPGRADE = 3;
    public static final int HEALTH_POTIONS = 4;
    public static final int MANA_POTIONS = 5;
    public static final int TOME_OF_POWER = 6;
    public static final int MYSTIC_HOURGLASS = 7;
    public static final int DOUBLE_COINS = 8;
    public static final int COINS = 9;
    public static int interuption_nokia;
    public static boolean touchActivated;
    int pauseGame = 0;
    int tutorialGame = 0;
    public static int a;
    public boolean resumeSounds = false;
    public static boolean gameMusic;
    public static int nokia;
    final int PAYM_SCORE;
    final int PAYM_GOODS;
    public static Vector vecLeaderboardTitle;
    public static Vector vecInsufficientCoins;
    public static Vector vecDailyReward;
    String[] strLeaderboardRanks = null;
    String[] strLeaderboardNickNames = null;
    String[] strLeaderboardScores = null;
    String strLeaderboardTitle;
    int iLanguageSelectedItem = 0;
    int iTopScoreOffset = 0;
    int iMaxTopScoreOffset = 0;
    boolean bShopFromMainMenu = false;
    boolean bQuitApp = false;
    String[] languages = new String[6];
    public int iDaysLastPlayed = 0;
    public int iDaysPlayed = 0;
    public boolean buyingCoins;
    public int itemBuying;
    public boolean fullUpgrade;
    public static Form form;
    public static boolean bScoreSent;
    public static boolean bSyncing;
    public static int coinsPriceLevelCount;

    public MainCanvas() {
        super(false);
        this.PAYM_SCORE = 1;
        this.PAYM_GOODS = 2;
        this.initCanvas();
        Keys.canvas = this;
        soundManager = new SoundManager(1);
        soundManager.LoadPlayList(Sounds.GAME_SOUND_FILES, Sounds.GAME_SOUND_TYPES, Sounds.GAME_SOUND_FLAGS);
        soundManager.SetSoundOn(false);
        this.initPlayers();
    }

    public static void loadGame() {
        if (State.canLoadGame("B")) {
            state.loadGame("B");
        }
    }

    public static void saveGame() {
        state.saveGame("B");
    }

    private void initCanvas() {
        super.setFullScreenMode(true);
        mainThread = new Thread(this);
        mainThread.start();
        this.interuptionIn = false;
        this.paintPaused = false;
        this.bScreenSizeAdjusted = false;
        this.lLastRun = 0L;
    }

    public void initPlayers() {
        player = new Player[3];
        MainCanvas.player[0] = new Player();
        MainCanvas.player[1] = new Player();
        MainCanvas.player[2] = new Player();
        this.setActivePlayer(0);
    }

    public void setActivePlayer(int playerID) {
        activePlayer = playerID;
    }

    public int getActivePlayer() {
        return activePlayer;
    }

    private IScreen createScreen(int screenType, Object params) {
        switch (screenType) {
            case 0: {
                return new ScreenLanguages(this);
            }
            case 3: {
                return new ScreenGame(this);
            }
            case 1: {
                return new ScreenMenu(this);
            }
            case 5: {
                return new ScreenShop(this);
            }
            case 6: {
                return new ScreenSounds(this);
            }
            case 7: {
                return new ScreenIntro(this);
            }
            case 9: {
                return new ScreenQuit(this);
            }
            case 10: {
                return new ScreenSplash(this);
            }
        }
        return null;
    }

    public void setActiveScreen(int screenType, Object params) {
        Keys.resetAllPressedKeysAndActions();
        this.screens[screenType] = this.createScreen(screenType, params);
        if (this.screens[screenType] == null) {
            return;
        }
        this.paintPaused = true;
        if (activeScreen != null) {
            activeScreen.afterHide();
            for (int i = 0; i < 11; ++i) {
                if (activeScreen != this.screens[i]) continue;
                this.screens[i] = null;
            }
            activeScreen = null;
            System.gc();
        }
        this.screens[screenType].beforeShow();
        activeScreen = this.screens[screenType];
        this.paintPaused = false;
    }

    public void hideNotify() {
        if (this.interuptionIn) {
            return;
        }
        if (this.tutorialGame != 8) {
            this.tutorialGame = Player.getStage() == 0 || Player.getStage() == 2 || Player.getStage() == 4 ? 8 : 1;
        }
        if (activeScreen == this.screens[3]) {
            ScreenGame.modeMenu(this.tutorialGame);
        } else if (activeScreen == this.screens[5]) {
            ScreenGame.modeMenu(this.tutorialGame);
        } else if (activeScreen == this.screens[1]) {
            ScreenGame.modeMenu(this.tutorialGame);
        }
        this.interuptionIn = true;
        soundManager.Stop();
        Keys.resetAllPressedKeysAndActions();
    }

    public void showNotify() {
        if (!this.interuptionIn) {
            return;
        }
        this.interuptionIn = false;
        if (this.tutorialGame != 8) {
            this.tutorialGame = Player.getStage() == 0 || Player.getStage() == 2 || Player.getStage() == 4 ? 8 : 1;
        }
        if (activeScreen == this.screens[3]) {
            ScreenGame.modeMenu(this.tutorialGame);
        } else if (activeScreen == this.screens[5]) {
            ScreenGame.modeMenu(this.tutorialGame);
        } else if (activeScreen == this.screens[1]) {
            ScreenGame.modeMenu(this.tutorialGame);
        }
        if (activeScreen == this.screens[3]) {
            soundManager.Play(Sounds.SOUND_GAME, -1);
            nokia = 1;
        } else {
            if (!gameMusic) {
                a = 1;
                soundManager.Play(Sounds.SOUND_MENU, -1);
                nokia = 1;
            } else {
                soundManager.Play(Sounds.SOUND_GAME, -1);
            }
            nokia = 1;
        }
        this.repaint();
    }

    public void run() {
        while (Thread.currentThread() == mainThread) {
            Thread.yield();
            if (System.currentTimeMillis() - this.lLastRun < 40L) continue;
            this.lLastRun = System.currentTimeMillis();
            if (activeScreen == null) continue;
            activeScreen.update(System.currentTimeMillis() - this.lLastRun);
        }
    }

    public void paint(Graphics g) {
        if (this.paintPaused) {
            return;
        }
        HEIGHT = g.getClipHeight();
        WIDTH = g.getClipWidth();
        if (WIDTH_FROM_DC < HEIGHT_FROM_DC && WIDTH > HEIGHT || WIDTH_FROM_DC > HEIGHT_FROM_DC && WIDTH < HEIGHT) {
            this.paintResRotation(g);
            ScreenGame.mode = 1;
            int h = HEIGHT;
            HEIGHT = WIDTH;
            WIDTH = h;
            return;
        }
        if (!this.bScreenSizeAdjusted) {
            this.bScreenSizeAdjusted = true;
            Common.setPort();
            this.setActiveScreen(7, null);
        }
        g.setClip(0, 0, WIDTH, HEIGHT);
        activeScreen.paint(g);
    }

    private void paintResRotation(Graphics g) {
        g.setClip(0, 0, WIDTH, HEIGHT);
        g.setColor(0);
        g.fillRect(0, 0, WIDTH, HEIGHT);
        if (Resources.resImgs[0] == null) {
            Resources.loadImage(0);
        } else {
            g.drawImage(Resources.resImgs[0], WIDTH / 2, HEIGHT / 2, 3);
        }
    }

    protected void keyPressed(int keyCode) {
        Keys.keyPressed(keyCode);
        if (this.resumeSounds) {
            if (activeScreen == this.screens[1] || activeScreen == this.screens[8] || activeScreen == this.screens[5]) {
                soundManager.Play(Sounds.SOUND_MENU, -1);
                this.resumeSounds = false;
            } else if (activeScreen == this.screens[3]) {
                soundManager.Play(Sounds.SOUND_GAME, -1);
                this.resumeSounds = false;
            }
        }
        if (activeScreen != null) {
            activeScreen.keyPressed(keyCode);
        }
    }

    private void onKeyReleased(int keyCode) {
        if (activeScreen != null) {
            activeScreen.keyReleased(keyCode);
            System.out.println("released");
        }
        Keys.keyReleased(keyCode);
    }

    protected void keyReleased(int keyCode) {
        this.onKeyReleased(keyCode);
    }

    protected void pointerPressed(int x, int y) {
        touchActivated = true;
        if (activeScreen != null) {
            activeScreen.pointerPressed(x, y);
        }
    }

    protected void pointerDragged(int x, int y) {
        if (activeScreen != null) {
            activeScreen.pointerDragged(x, y);
        }
    }

    protected void pointerReleased(int x, int y) {
        if (activeScreen != null) {
            activeScreen.pointerReleased(x, y);
        }
    }

    public void quit() {
        X.quitApp();
    }

    public void dailyReward(int arg0) {
    }

    public void gainFocus() {
        if (this.bQuitApp) {
            X.quitApp();
        }
    }

    public boolean isAcceptingDailyReward() {
        return false;
    }

    public boolean isAcceptingImages() {
        return false;
    }

    public void requestQuit() {
    }

    static {
        state = new State();
        music = false;
        activePlayer = 0;
        coinPackPurchuasing = -9999;
        playerName = "";
        coinPackagesQuantity = new int[]{0, 0, 0};
        limitedOffer = false;
        limitedOfferItem = 0;
        specialOffer = 0;
        interuption_nokia = 0;
        touchActivated = false;
        String fullCanvasSize = "240x432";
        try {
            WIDTH = WIDTH_FROM_DC = Integer.valueOf(fullCanvasSize.substring(0, fullCanvasSize.indexOf("x"))).intValue();
            HEIGHT = HEIGHT_FROM_DC = Integer.valueOf(fullCanvasSize.substring(fullCanvasSize.indexOf("x") + 1)).intValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        a = 0;
        gameMusic = false;
        nokia = 0;
        form = null;
        bScoreSent = false;
        bSyncing = false;
        coinsPriceLevelCount = 0;
    }
}

