/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Common;
import sk.inlogic.MainCanvas;
import sk.inlogic.Player;
import sk.inlogic.Resources;
import sk.inlogic.ScreenShop;
import sk.inlogic.ShopItems;
import sk.inlogic.Sounds;
import sk.inlogic.Varr;
import sk.inlogic.X;
import sk.inlogic.screen.IScreen;
import sk.inlogic.util.Keys;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class ScreenGame
implements IScreen {
    MainCanvas mainCanvas;
    public static int mode;
    long modeDelay;
    Rectangle[] rectItems = new Rectangle[7];
    Rectangle rectSelector;
    public int backgroundPositionX = MainCanvas.WIDTH >> 1;
    public int backgroundPositionY = 0;
    public int[] generateX;
    public int generateWaveCounter = 85;
    public int actualWave = 0;
    public boolean timerIsAlreadyExpired = false;
    public int aimingAngle = 270;
    public final int MAX_CRITS;
    public int[] critX = new int[50];
    public int[] critY = new int[50];
    public int[] critcounter = new int[50];
    public int playerHealth;
    public int[] playerHealthW;
    public int playerMana;
    public int[] playerManaW;
    public int playerBaseDMG;
    public int playerShield;
    public int currentlyShowingUnlockedItem = 0;
    public int thisStageCash = 0;
    private int itemsShowed = 0;
    public static boolean stopCountDown;
    private int shotCounter = 0;
    private int INT_NULL = -9999;
    private int MAX_SHOTS = 60;
    private int MAX_LAYERS = 7;
    private int MAX_ENEMIES = 20;
    private int MAX_CORPSES = 50;
    private int[] shotAngle;
    private int[] shotX;
    private int[] shotY;
    private int[] shotCrit;
    private int[] shotFromTower;
    private int actualShot = 0;
    private int[] shotRadius;
    private int activeStaff;
    public int[] towerOneShotAngle;
    public int[] towerOneShotX;
    public int[] towerOneShotY;
    public int[] towerOneShotRadius;
    public int towerOneActualShot = 0;
    public int[] towerTwoShotAngle;
    public int[] towerTwoShotX;
    public int[] towerTwoShotY;
    public int[] towerTwoShotRadius;
    public int towerTwoActualShot = 0;
    public int additionalTowerLvl = 0;
    public int enemiesKilled = 0;
    public int LEFT_OFFSET;
    public int COLLISION_LAYER_W;
    public int[][] corpseX;
    public int[][] corpseY;
    public int[][] corpseFrame;
    public int[][] corpseType;
    public int[][] corpseDirection;
    public int[] meteorX;
    public int[] meteorY;
    public int[] meteorTarget;
    public int MAX_METEORS = 100;
    public int[] poisonX;
    public int[] poisonY;
    public int[] poisonTarget;
    public int MAX_POISONS = 100;
    public int[] cloudX;
    public int[] cloudY;
    public int[] cloudFrame;
    public int[] frostCloudX;
    public int[] frostCloudY;
    public int[] frostCloudFrame;
    public int[] frostX;
    public int[] frostY;
    public int[] frostFrame;
    public int[] frostCounter;
    public int MAX_FROST = 100;
    public int[] explosionX;
    public int[] explosionY;
    public int[] explosionFrame;
    public int[] explosionParticlesFrame;
    public int[] enemyCannonShotExplosion;
    public int[] spellCounter;
    public int[] spellH;
    public int[][] enemyType;
    public int[][] enemyX;
    public int[][] enemyY;
    public int[][] enemyHealth;
    public int[][] enemyState;
    public int[][] enemyAtackCounter;
    public int[][] enemyFrostCounter;
    public int[][] enemyPoisonCounter;
    public int[][] enemyFireCounter;
    public int enemyW = 20;
    public int enemyH = 20;
    public int[][] healthW;
    public int enemyMaxHealth = 9999;
    public boolean[][] enemyAlreadyMoved;
    public int[][] cannonExplosionCounter;
    public int[] enemySpeed;
    public int[] enemySpeedBuffer;
    public int[] enemySpeedInc;
    public boolean clearField = false;
    public int[] frameSequence = new int[]{0, 1, 2, 3, 2, 1};
    public int level = 1;
    private boolean paintTutorial = false;
    public int menuSelected = 0;
    public int consumableSelected = 0;
    public int menuMode = 0;
    public int tomeOfPowerTimer;
    public int spellsPassiveAdditionFromConsumable = 0;
    public int startCounter = 0;
    public int[] waves;
    public static int iTableAnimation;
    public static int TABLE_ANIMATION;
    public static int iHide;
    public static boolean hideScreen;
    public final int MAX_ENEMY_SHOTS;
    public int[] enemyShotX;
    public int[] enemyShotY;
    public int[] enemyShotType;
    public boolean bossInThisStage = false;
    public boolean bossIsReadyToGo = false;
    public boolean bossLoaded = false;
    public boolean bossInited = false;
    public int bossJumpCounter = 0;
    public int bossPositionX;
    public int bossPositionY;
    public int bossWidth;
    public int bossHeight;
    public int bossState;
    public int bossAttackCounter = 0;
    public long bossMaxHealth;
    public long bossHealth;
    public int bossDroppedItem = this.INT_NULL;
    public boolean bossDead = false;
    public int bossAlertTimer = 0;
    public int bossCorpsePositionX = this.INT_NULL;
    public int bossCorpsePositionY = this.INT_NULL;
    public int bossCorpseFrame;
    public int bossSpeed;
    public int bossSpeedBuffer;
    public int bossShotPositionX;
    public int bossShotPositionY;
    public long bossLastHpBorder;
    public boolean playerUsedHP = false;
    public int lavaOffsetMin;
    public int lavaOffsetMax;
    public int lavaOffsetStep;
    public boolean shakeBackground = false;
    public int backgroundPosCounter;
    public int vectorX;
    public int vectorY;
    public int vectorW;
    public int vectorH;
    public Vector vecHint;
    public int WAVE_DELAY = 120;
    public int[] progressH;
    public boolean firstWave = true;
    public int gameOverTimer = 0;
    public int notEnoughTimer = 0;
    public int[] TowerUpgradeLvl = new int[8];
    public int[] FenceUpgradeLvl = new int[8];
    public int[] TowerAddUpgradeLvl = new int[8];
    public int towerResId;
    public int towerFenceResId;
    public int towerAddResId;
    public int towerResId1;
    public int towerFenceResId1;
    public int towerAddResId1;
    public int towerWallHeight;
    public int nextMode = 0;
    public int aimSelected = 0;
    public int staffBgTop;
    public int staffBgBottom;
    public int staffTop;
    public int bossWalkAnimationCounter = 0;
    public int lavaCounter = 0;
    public int bblX = -9999;
    public int bblY = -9999;
    char[] chrHealth;
    char[] chrMana;
    char[] chrCash;
    char[] chrStageComplete;
    char[] chrStageFailed;
    char[] chrStageStart;
    char[] chrStage;
    char[] chrHealthTxt;
    char[] chrTotal;
    char[] chrCoins;
    String chrHealthBonus;
    String chrStageBonus;
    char[] chrEnemiesKilled;
    char[] chrLostBonus;
    char[] chrBossComming;
    Sprite spr = null;
    Sprite sprCannon = null;
    private static boolean tomeOfPowerInUsage;
    private int pointerFirst = 0;
    private int pointerSecond = 0;
    public int enemyFrame = 0;
    public int flagFrame = 0;
    int cycle = 10;
    private boolean winLoseCounterUpdated = false;
    private int towerUpgradeTimeout = 0;
    private boolean allWavesGenerated = false;
    private int[] stageBonus = new int[]{0, 0, 0, 0};
    private boolean winStatUpdated = false;
    private boolean enemiesAreMoving = true;
    public int updateCounter = 0;
    public int updateGameCounter = 0;
    private int minionsCount;
    int bossMinionType = Varr.ENEMY_ORC;
    private int bossUpdateCounter = 0;
    private int enemiesTotalCount = 0;
    private boolean bossCashAlreadyAdded = false;
    public static int tutorialGame;
    private int lastMode = 0;
    private int selectorAnimation = 0;
    private int tutorialAnimation = 0;
    private String specialOfferQuantity = "10X";
    private String specialOfferOldPrice = "600";
    private String specialOfferNewPrice = "300";
    private String specialOfferDiscount = "20";
    private String specialOfferSaving = "200";
    private String save = MainCanvas.texts.getString("SAVE");
    private String free = Varr.freeTe;
    private String coins = MainCanvas.texts.getString("COINS");
    private String spec_offer = MainCanvas.texts.getString("SPECIAL_OFFER");
    private int yesAnimation = -10;
    Vector vecNotEnough;
    private boolean specialTomeOfPowerThing = false;
    private int countDownNumber = 10;
    private int towerAnimation = 0;
    private boolean showNewTower = false;
    private int plusHealthAnimationFrame = 0;
    private int plusManaAnimationFrame = 0;
    private int plusShieldAnimationFrame = 0;
    private int lastHealthStatus = 0;
    private int lastManaStatus = 0;
    private int lastShieldStatus = 0;
    private int cannonWalkFrame = 0;
    public int[] spellSelectorAnimation = new int[]{0, 0, 0};
    public boolean hintFrom3xDeath = false;
    private boolean stageBonusFail = false;
    private int showHintItemId = -9999;
    int touch = 0;
    static int[] SIN_TABLE;
    public static final int[] CosTable90;
    public static final int[] AtanTable;
    private int[][][] genEnemyType = new int[5][10][10];
    private int[][][] genEnemyForm = new int[5][10][10];

    private void calculatePositions() {
        this.LEFT_OFFSET = MainCanvas.WIDTH % 7 >> 1;
        this.COLLISION_LAYER_W = MainCanvas.WIDTH / 7;
        this.generateX = new int[this.MAX_LAYERS];
        for (int i = 0; i < this.MAX_LAYERS; ++i) {
            this.generateX[i] = this.LEFT_OFFSET + this.COLLISION_LAYER_W * i + (this.COLLISION_LAYER_W >> 1);
        }
    }

    private void prepareVector(String text) {
        this.vectorW = Resources.resSprs[0].getWidth() - Resources.resSprs[0].getWidth() / 4;
        this.vectorX = MainCanvas.WIDTH - this.vectorW >> 1;
        this.vecHint = Common.separateTextToLines(text, this.vectorW, Resources.resGFonts[0]);
        this.vectorH = this.vecHint.size() * Resources.resGFonts[0].getHeight();
        this.vectorY = MainCanvas.HEIGHT - this.vectorH >> 1;
    }

    private void prepareLimitedVector(String text) {
        this.vectorW = Resources.resSprs[0].getWidth() / 2 + 10;
        this.vectorX = MainCanvas.WIDTH - this.vectorW >> 1;
        this.vecHint = Common.separateTextToLines(text, this.vectorW, Resources.resGFonts[0]);
        this.vectorH = this.vecHint.size() * Resources.resGFonts[0].getHeight();
        this.vectorY = MainCanvas.HEIGHT - this.vectorH >> 1;
    }

    private void loadEnvironment() {
        this.TowerUpgradeLvl[0] = 51;
        this.TowerUpgradeLvl[1] = 52;
        this.TowerUpgradeLvl[2] = 53;
        this.TowerUpgradeLvl[3] = 54;
        this.TowerUpgradeLvl[4] = 55;
        this.TowerUpgradeLvl[5] = 56;
        this.TowerUpgradeLvl[6] = 57;
        this.TowerUpgradeLvl[7] = 58;
        this.FenceUpgradeLvl[0] = 61;
        this.FenceUpgradeLvl[1] = 62;
        this.FenceUpgradeLvl[2] = 63;
        this.FenceUpgradeLvl[3] = 64;
        this.FenceUpgradeLvl[4] = 65;
        this.FenceUpgradeLvl[5] = 66;
        this.FenceUpgradeLvl[6] = 67;
        this.FenceUpgradeLvl[7] = 68;
        this.TowerAddUpgradeLvl[0] = 102;
        this.TowerAddUpgradeLvl[1] = 103;
        this.TowerAddUpgradeLvl[2] = 104;
        this.TowerAddUpgradeLvl[3] = 105;
        this.TowerAddUpgradeLvl[4] = 106;
        this.TowerAddUpgradeLvl[5] = 107;
        this.TowerAddUpgradeLvl[6] = 108;
        this.TowerAddUpgradeLvl[7] = 109;
        int hpLvl = (Player.getStatValue(1) - 1000) / 100;
        int towerAndFenceId = 0;
        if (hpLvl == 1) {
            towerAndFenceId = 1;
        } else if (hpLvl >= 3 && hpLvl < 6) {
            towerAndFenceId = 2;
        } else if (hpLvl >= 6 && hpLvl < 10) {
            towerAndFenceId = 3;
        } else if (hpLvl >= 10 && hpLvl < 15) {
            towerAndFenceId = 4;
        } else if (hpLvl >= 15 && hpLvl < 21) {
            towerAndFenceId = 5;
        } else if (hpLvl >= 21 && hpLvl < 28) {
            towerAndFenceId = 6;
        } else if (hpLvl >= 28) {
            towerAndFenceId = 7;
        }
        int differenceBtwnUpgradeAndNewTower = towerAndFenceId - Player.towerUpgradeLvl;
        this.towerResId = this.TowerUpgradeLvl[Player.towerUpgradeLvl];
        this.towerFenceResId = this.FenceUpgradeLvl[Player.towerUpgradeLvl];
        this.towerAddResId = this.TowerAddUpgradeLvl[Player.towerUpgradeLvl];
        this.towerResId1 = this.TowerUpgradeLvl[Player.towerUpgradeLvl + differenceBtwnUpgradeAndNewTower];
        this.towerFenceResId1 = this.FenceUpgradeLvl[Player.towerUpgradeLvl + differenceBtwnUpgradeAndNewTower];
        this.towerAddResId1 = this.TowerAddUpgradeLvl[Player.towerUpgradeLvl + differenceBtwnUpgradeAndNewTower];
        Resources.loadImages(new int[]{2, 5, 6, 13, 17, 18, 19, 3, 20, 25, 29});
        Resources.loadSprites(new int[]{9, 14, 0, 42, 91, this.towerResId, this.towerFenceResId, this.towerAddResId, this.towerResId1, this.towerFenceResId1, this.towerAddResId1, 96, 71, 98, 87, 88, 72, 79, 77, 79, 76, 80, 90, 101, 112});
        this.lavaOffsetMin = Resources.resImgs[2].getHeight() / 10;
        this.lavaOffsetMax = MainCanvas.HEIGHT >> 1;
        this.lavaOffsetStep = (this.lavaOffsetMax - this.lavaOffsetMin) / ShopItems.MAX_VALUE[15];
        this.towerWallHeight = Resources.resSprs[this.towerResId].getHeight();
    }

    private void loadEnemies() {
        Resources.loadImages(new int[]{9, 10, 11, 12, 14});
        Resources.loadSprites(new int[]{7, 15, 23, 27, 46, 49, 47, 48, 50, 11, 22, 24, 28, 29, 30, 31, 32, 12, 37});
    }

    private void loadBoss() {
        if (!this.bossLoaded) {
            Resources.loadImages(new int[]{16, 35, 36, 37, 38, 39});
            Resources.loadSprites(new int[]{43, 44, 45, 100, 95, 12, 37});
            this.bossLoaded = true;
        }
    }

    private void loadSpells() {
        Resources.loadImages(new int[]{8, 32});
        Resources.loadSprites(new int[]{81, 33, 34, 35, 94, 36, 82, 83, 78, 92});
    }

    private void releaseSpells() {
        Resources.freeImages(new int[]{8, 32});
        Resources.freeSprites(new int[]{33, 34, 35, 94, 36, 82, 83, 78, 92});
    }

    private void releaseBoss() {
        Resources.freeImages(new int[]{16});
        Resources.freeSprites(new int[]{43, 44, 100, 45, 95});
        this.bossLoaded = false;
    }

    private void releaseEnemies() {
        Resources.freeImages(new int[]{9, 10, 11, 12, 14});
        Resources.freeSprites(new int[]{7, 15, 23, 27, 46, 49, 47, 48, 50, 11, 22, 24, 28, 29, 30, 31, 32, 12, 37});
    }

    private void releaseEnvironment() {
        Resources.freeImages(new int[]{2, 5, 6, 13, 17, 18, 19, 21, 20});
        Resources.freeSprites(new int[]{9, 14, 0, 42, 91, this.towerResId, this.towerFenceResId, 96, 71, 87, 88, 72, 79, 77, 79, 76, 90, 112});
    }

    public void afterHide() {
        tomeOfPowerInUsage = false;
        Resources.freeImage(24);
        this.releaseEnemies();
        this.releaseSpells();
        this.releaseBoss();
        this.releaseEnvironment();
        Resources.freeImage(24);
    }

    public void beforeShow() {
        int i;
        ShopItems.initData();
        MainCanvas.limitedOffer = false;
        this.preparePreGeneratedFormations();
        Resources.loadImage(24);
        stopCountDown = false;
        if (Player.getStage() == 0 || Player.getStage() == 2 || Player.getStage() == 4) {
            if (Player.getStage() == 0) {
                if (MainCanvas.touchActivated) {
                    this.prepareVector(MainCanvas.texts.getString("TUTORIAL_1_TOUCH"));
                } else {
                    this.prepareVector(MainCanvas.texts.getString("TUTORIAL_1_KEY"));
                }
            }
            if (Player.getStage() == 2 && !MainCanvas.touchActivated) {
                this.prepareVector(MainCanvas.texts.getString("TUTORIAL_3_KEY"));
            }
            if (Player.getStage() == 2 && MainCanvas.touchActivated) {
                this.prepareVector(MainCanvas.texts.getString("TUTORIAL_3_TOUCH"));
            }
            if (Player.getStage() == 4 && !MainCanvas.touchActivated) {
                this.prepareVector(MainCanvas.texts.getString("TUTORIAL_6_KEY"));
            }
            if (Player.getStage() == 4 && MainCanvas.touchActivated) {
                this.prepareVector(MainCanvas.texts.getString("TUTORIAL_6_TOUCH"));
            }
            mode = 8;
        } else {
            mode = 0;
        }
        this.level = Player.getStage();
        this.additionalTowerLvl = Player.getSpellStatus(4);
        this.loadEnemies();
        this.loadSpells();
        this.loadEnvironment();
        Resources.loadGFonts(new int[]{0, 2, 4, 3});
        Resources.resSprs[14].setFrame(0);
        this.calculatePositions();
        this.initShots();
        this.initEnemies();
        this.initSpeedValues();
        this.resetGame();
        this.activeStaff = Player.getEquipedStaff();
        this.setStaffColor(this.activeStaff);
        TABLE_ANIMATION = (Resources.resSprs[0].getWidth() >> 1) * 3;
        ScreenGame.resetShowAnimation();
        this.calculatePlayerHealth();
        this.playerShield = Player.getPlayerShield() * 50;
        this.playerBaseDMG = Player.getPlayerBaseDamage();
        if (Player.getEquipedStaff() == 11) {
            this.playerBaseDMG = this.playerBaseDMG * 1000 / 100 * 55 / 1000;
        }
        this.initWaves();
        this.progressH = new int[this.waves.length * this.WAVE_DELAY + this.WAVE_DELAY / 2];
        for (i = 0; i < this.progressH.length; ++i) {
            this.progressH[i] = RandomNum.barValue(i, this.progressH.length, Resources.resImgs[18].getWidth());
        }
        this.spellH = new int[this.WAVE_DELAY + Player.getSpellStatus(0) * 15 + 1];
        for (i = 0; i < this.spellH.length; ++i) {
            this.spellH[i] = RandomNum.barValue(i, this.spellH.length, Resources.resSprs[83].getHeight());
        }
        this.chrStageComplete = ScreenGame.replace(MainCanvas.texts.getString("STAGE_COMPLETE"), "[X]", "" + (this.level + 1)).toCharArray();
        this.chrStageFailed = ScreenGame.replace(MainCanvas.texts.getString("STAGE_FAILED"), "[X]", "" + (this.level + 1)).toCharArray();
        this.chrStageStart = (MainCanvas.texts.getString("STAGE") + " " + (this.level + 1)).toCharArray();
        this.chrStage = MainCanvas.texts.getString("STAGE").toCharArray();
        this.chrHealthTxt = MainCanvas.texts.getString("HEALTH").toCharArray();
        this.chrTotal = MainCanvas.texts.getString("TOTAL").toCharArray();
        this.chrCoins = MainCanvas.texts.getString("COINS").toCharArray();
        this.chrHealthBonus = MainCanvas.texts.getString("HEALTH_BONUS");
        this.chrStageBonus = MainCanvas.texts.getString("STAGE_BONUS");
        this.chrEnemiesKilled = MainCanvas.texts.getString("ENEMIES_KILLED").toCharArray();
        this.chrLostBonus = MainCanvas.texts.getString("LOST_BONUS").toCharArray();
        this.chrBossComming = MainCanvas.texts.getString("BOSS_ALERT").toCharArray();
        Varr.strUnlocked = MainCanvas.texts.getString("UNLOCKED");
        Varr.strNEHP = MainCanvas.texts.getString("NOT_E_HP");
        Varr.strNEMP = MainCanvas.texts.getString("NOT_E_MP");
        Varr.strNESR = MainCanvas.texts.getString("NOT_E_SR");
        Varr.strNEM = MainCanvas.texts.getString("NOT_E_MANA");
        Varr.strSIC = MainCanvas.texts.getString("Varr.SPELL_NREADY");
        Varr.chrFailH = Common.separateTextToLines(ScreenGame.replace(MainCanvas.texts.getString("FAIL_HOURGLASS"), "[X]", String.valueOf(Player.getStageBonus(Player.streak + 2, 0))), Common.getTableW() / 6 * 4, Resources.resGFonts[2]);
        Varr.chrFailNH = Common.separateTextToLines(ScreenGame.replace(MainCanvas.texts.getString("FAIL_NO_HOURGLASS"), "[X]", String.valueOf(Player.getStageBonus(Player.streak + 2, 0))), Common.getTableW() / 6 * 4, Resources.resGFonts[2]);
        Varr.chrBossDrop = Common.separateTextToLines(MainCanvas.texts.getString("BOSS_DROP"), Common.getTableW() / 6 * 4, Resources.resGFonts[2]);
        int itmsUnlckd = ShopItems.itemsUnlockedInThisStage(Player.getStage() + 1);
        int[] itemsUnlocked = new int[itmsUnlckd];
        int c = 0;
        for (int i2 = 0; i2 < ShopItems.LOCKED.length; ++i2) {
            if (ShopItems.LOCKED[i2] != Player.getStage() + 1) continue;
            itemsUnlocked[c] = i2;
            ++c;
        }
        if (itemsUnlocked.length > 0) {
            this.currentlyShowingUnlockedItem = itemsUnlocked[this.itemsShowed];
        }
        if (Player.getConsumableCount(3) > 0) {
            tomeOfPowerInUsage = true;
            this.useConsumable(3);
        }
        if (Player.getConsumableCount(4) > 0) {
            this.useConsumable(4);
        }
        Resources.loadImage(24);
        this.pointerFirst = Resources.resImgs[17].getHeight();
        this.pointerSecond = MainCanvas.HEIGHT - Resources.resSprs[83].getHeight();
    }

    public void initShots() {
        int i;
        this.shotCrit = new int[100];
        int critVal = Player.getStatValue(3);
        for (i = 0; i < 50; ++i) {
            this.critX[i] = this.INT_NULL;
            this.critY[i] = this.INT_NULL;
            this.critcounter[i] = this.INT_NULL;
        }
        for (i = 0; i < 100; ++i) {
            this.shotCrit[i] = i < critVal * 2 ? 1 : 0;
        }
        for (i = 0; i < 100; ++i) {
            int rand = RandomNum.getRandomUInt(100);
            int val = this.shotCrit[i];
            this.shotCrit[i] = this.shotCrit[rand];
            this.shotCrit[rand] = val;
        }
        this.shotAngle = new int[this.MAX_SHOTS];
        this.shotX = new int[this.MAX_SHOTS];
        this.shotY = new int[this.MAX_SHOTS];
        this.shotRadius = new int[this.MAX_SHOTS];
        this.shotFromTower = new int[this.MAX_SHOTS];
        this.explosionParticlesFrame = new int[this.MAX_SHOTS];
        this.enemyCannonShotExplosion = new int[this.MAX_SHOTS];
        this.towerOneShotAngle = new int[this.MAX_SHOTS];
        this.towerOneShotX = new int[this.MAX_SHOTS];
        this.towerOneShotY = new int[this.MAX_SHOTS];
        this.towerOneShotRadius = new int[this.MAX_SHOTS];
        this.towerTwoShotAngle = new int[this.MAX_SHOTS];
        this.towerTwoShotX = new int[this.MAX_SHOTS];
        this.towerTwoShotY = new int[this.MAX_SHOTS];
        this.towerTwoShotRadius = new int[this.MAX_SHOTS];
        for (i = 0; i < this.MAX_SHOTS; ++i) {
            this.shotAngle[i] = this.INT_NULL;
            this.shotX[i] = this.INT_NULL;
            this.shotY[i] = this.INT_NULL;
            this.shotRadius[i] = this.INT_NULL;
            this.shotFromTower[i] = this.INT_NULL;
            this.towerOneShotRadius[i] = this.INT_NULL;
            this.towerOneShotX[i] = this.INT_NULL;
            this.towerOneShotY[i] = this.INT_NULL;
            this.towerOneShotAngle[i] = this.INT_NULL;
            this.towerTwoShotRadius[i] = this.INT_NULL;
            this.towerTwoShotX[i] = this.INT_NULL;
            this.towerTwoShotY[i] = this.INT_NULL;
            this.towerTwoShotAngle[i] = this.INT_NULL;
            this.explosionParticlesFrame[i] = 0;
            this.enemyCannonShotExplosion[i] = 0;
        }
        this.spellCounter = new int[]{0, 0, 0};
        this.meteorX = new int[this.MAX_METEORS];
        this.meteorY = new int[this.MAX_METEORS];
        this.meteorTarget = new int[this.MAX_METEORS];
        this.explosionX = new int[this.MAX_METEORS];
        this.explosionY = new int[this.MAX_METEORS];
        this.explosionFrame = new int[this.MAX_METEORS];
        for (i = 0; i < this.MAX_METEORS; ++i) {
            this.meteorX[i] = this.INT_NULL;
            this.meteorY[i] = this.INT_NULL;
            this.meteorTarget[i] = this.INT_NULL;
            this.explosionX[i] = this.INT_NULL;
            this.explosionY[i] = this.INT_NULL;
            this.explosionFrame[i] = 0;
        }
        this.frostX = new int[this.MAX_FROST];
        this.frostY = new int[this.MAX_FROST];
        this.frostCounter = new int[this.MAX_FROST];
        this.frostFrame = new int[this.MAX_FROST];
        this.frostCloudX = new int[this.MAX_FROST];
        this.frostCloudY = new int[this.MAX_FROST];
        this.frostCloudFrame = new int[this.MAX_FROST];
        for (i = 0; i < this.MAX_FROST; ++i) {
            this.frostX[i] = this.INT_NULL;
            this.frostY[i] = this.INT_NULL;
            this.frostCounter[i] = this.INT_NULL;
            this.frostFrame[i] = 0;
            this.frostCloudX[i] = this.INT_NULL;
            this.frostCloudY[i] = this.INT_NULL;
            this.frostCloudFrame[i] = 0;
        }
        this.poisonX = new int[this.MAX_POISONS];
        this.poisonY = new int[this.MAX_POISONS];
        this.poisonTarget = new int[this.MAX_POISONS];
        this.cloudX = new int[this.MAX_POISONS];
        this.cloudY = new int[this.MAX_POISONS];
        this.cloudFrame = new int[this.MAX_POISONS];
        for (i = 0; i < this.MAX_POISONS; ++i) {
            this.poisonX[i] = this.INT_NULL;
            this.poisonY[i] = this.INT_NULL;
            this.poisonTarget[i] = this.INT_NULL;
            this.cloudX[i] = this.INT_NULL;
            this.cloudY[i] = this.INT_NULL;
            this.cloudFrame[i] = 0;
        }
        this.enemyShotX = new int[100];
        this.enemyShotY = new int[100];
        this.enemyShotType = new int[100];
        for (i = 0; i < 100; ++i) {
            this.enemyShotX[i] = this.INT_NULL;
            this.enemyShotY[i] = this.INT_NULL;
            this.enemyShotType[i] = this.INT_NULL;
        }
    }

    public void initSpeedValues() {
        this.enemySpeed = new int[5];
        this.enemySpeedBuffer = new int[5];
        this.enemySpeedInc = new int[5];
        this.enemySpeed[Varr.ENEMY_GHOST] = Common.GHOST_SPEED * 2;
        this.enemySpeed[Varr.ENEMY_ORC] = Common.ORC_SPEED * 2;
        this.enemySpeed[Varr.ENEMY_BAT] = Common.BAT_SPEED * 2;
        this.enemySpeed[Varr.ENEMY_GOLEM] = Common.GOLEM_SPEED * 2;
        this.enemySpeed[Varr.ENEMY_CANNON] = Common.CANNON_SPEED * 2;
        this.enemySpeedBuffer[Varr.ENEMY_GHOST] = 0;
        this.enemySpeedBuffer[Varr.ENEMY_ORC] = 0;
        this.enemySpeedBuffer[Varr.ENEMY_BAT] = 0;
        this.enemySpeedBuffer[Varr.ENEMY_GOLEM] = 0;
        this.enemySpeedBuffer[Varr.ENEMY_CANNON] = 0;
        this.enemySpeedInc[Varr.ENEMY_GHOST] = 0;
        this.enemySpeedInc[Varr.ENEMY_ORC] = 0;
        this.enemySpeedInc[Varr.ENEMY_BAT] = 0;
        this.enemySpeedInc[Varr.ENEMY_GOLEM] = 0;
        this.enemySpeedInc[Varr.ENEMY_CANNON] = 0;
    }

    public void initBoss() {
        if (!this.bossInited) {
            this.bossWidth = Resources.resSprs[43].getWidth();
            this.bossHeight = Resources.resSprs[43].getHeight();
            this.bossPositionX = (MainCanvas.WIDTH >> 1) - (this.bossWidth >> 1);
            this.bossPositionY = 0 - this.bossHeight;
            this.bossHealth = this.bossMaxHealth;
            this.bossLastHpBorder = this.bossMaxHealth;
            this.bossState = Varr.STATE_WALK;
            this.bossSpeed = Common.BOSS_SPEED * 3;
            this.bossSpeedBuffer = 0;
            this.bossShotPositionX = this.INT_NULL;
            this.bossShotPositionY = this.INT_NULL;
            this.bossInited = true;
        }
    }

    public void initEnemies() {
        int j;
        int i;
        this.corpseX = new int[this.MAX_LAYERS][this.MAX_CORPSES];
        this.corpseY = new int[this.MAX_LAYERS][this.MAX_CORPSES];
        this.corpseFrame = new int[this.MAX_LAYERS][this.MAX_CORPSES];
        this.corpseType = new int[this.MAX_LAYERS][this.MAX_CORPSES];
        this.corpseDirection = new int[this.MAX_LAYERS][this.MAX_CORPSES];
        this.enemyX = new int[this.MAX_LAYERS][this.MAX_ENEMIES];
        this.enemyType = new int[this.MAX_LAYERS][this.MAX_ENEMIES];
        this.enemyY = new int[this.MAX_LAYERS][this.MAX_ENEMIES];
        this.enemyHealth = new int[this.MAX_LAYERS][this.MAX_ENEMIES];
        this.enemyState = new int[this.MAX_LAYERS][this.MAX_ENEMIES];
        this.enemyAtackCounter = new int[this.MAX_LAYERS][this.MAX_ENEMIES];
        this.enemyFrostCounter = new int[this.MAX_LAYERS][this.MAX_ENEMIES];
        this.enemyFireCounter = new int[this.MAX_LAYERS][this.MAX_ENEMIES];
        this.enemyPoisonCounter = new int[this.MAX_LAYERS][this.MAX_ENEMIES];
        this.enemyAlreadyMoved = new boolean[this.MAX_LAYERS][this.MAX_ENEMIES];
        this.cannonExplosionCounter = new int[this.MAX_LAYERS][this.MAX_ENEMIES];
        for (i = 0; i < this.MAX_LAYERS; ++i) {
            for (j = 0; j < this.MAX_ENEMIES; ++j) {
                this.enemyType[i][j] = this.INT_NULL;
                this.enemyX[i][j] = this.INT_NULL;
                this.enemyY[i][j] = this.INT_NULL;
                this.enemyState[i][j] = this.INT_NULL;
                this.enemyFrostCounter[i][j] = 0;
                this.enemyFireCounter[i][j] = 0;
                this.enemyPoisonCounter[i][j] = 0;
                this.enemyAtackCounter[i][j] = 0;
                this.enemyAlreadyMoved[i][j] = false;
                this.cannonExplosionCounter[i][j] = 0;
            }
            for (j = 0; j < this.MAX_CORPSES; ++j) {
                this.corpseX[i][j] = this.INT_NULL;
                this.corpseY[i][j] = this.INT_NULL;
                this.corpseFrame[i][j] = 0;
            }
        }
        this.enemiesKilled = 0;
        this.healthW = new int[5][this.enemyMaxHealth];
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < this.enemyMaxHealth; ++j) {
                this.healthW[i][j] = j * 1000 / (this.getEnemyHealth(i) * 1000 / (Resources.resSprs[12].getWidth() - 2));
            }
        }
        this.enemyW = Resources.resSprs[7].getWidth();
        this.enemyH = Resources.resSprs[7].getHeight();
        this.bossMaxHealth = 9000 + 900 * (Player.getStage() - 9);
    }

    public int getEnemyHealth(int type) {
        int health = 9999;
        int lvl = Player.getStage();
        ++lvl;
        if (Player.getStage() > 29) {
            if (Player.getStage() % 10 == 0) {
                lvl -= 4;
            }
            if (Player.getStage() % 10 == 1) {
                lvl -= 3;
            }
            if (Player.getStage() % 10 == 2) {
                lvl -= 2;
            }
            if (Player.getStage() % 10 == 3) {
                --lvl;
            }
            lvl += 10;
        }
        if (Player.getStage() % 10 != 0 && Player.getStage() % 10 != 1 && Player.getStage() % 10 != 2) {
            lvl += Player.enemiesStronger;
        }
        if (type == Varr.ENEMY_BAT) {
            health = 100 + 10 * lvl;
        } else if (type == Varr.ENEMY_ORC) {
            health = 110 + 30 * lvl;
        } else if (type == Varr.ENEMY_GHOST) {
            health = 90 + 25 * lvl;
        } else if (type == Varr.ENEMY_GOLEM) {
            health = 170 + 50 * lvl;
        } else if (type == Varr.ENEMY_CANNON) {
            health = 300 + 80 * lvl;
        }
        return health;
    }

    public ScreenGame(MainCanvas mainCanvas) {
        this.MAX_CRITS = 50;
        this.MAX_ENEMY_SHOTS = 100;
        this.mainCanvas = mainCanvas;
        if (Player.getStage() == 0 || Player.getStage() == 2 || Player.getStage() == 4) {
            mainCanvas.tutorialGame = 8;
        } else {
            this.paintTutorial = true;
        }
    }

    public static String replace(String _text, String _searchStr, String _replacementStr) {
        StringBuffer sb = new StringBuffer();
        int searchStringPos = _text.indexOf(_searchStr);
        int startPos = 0;
        int searchStringLength = _searchStr.length();
        while (searchStringPos != -1) {
            sb.append(_text.substring(startPos, searchStringPos)).append(_replacementStr);
            startPos = searchStringPos + searchStringLength;
            searchStringPos = _text.indexOf(_searchStr, startPos);
        }
        sb.append(_text.substring(startPos, _text.length()));
        return sb.toString();
    }

    public void initWaves() {
        this.waves = new int[7];
        this.generateWaveCounter = this.WAVE_DELAY >> 1;
    }

    public void calculatePlayerHealth() {
        int i;
        this.playerHealth = Player.getStatValue(1);
        if (tomeOfPowerInUsage) {
            this.playerHealth += 500;
        }
        this.playerHealthW = new int[this.playerHealth + 1];
        for (i = 0; i <= this.playerHealth; ++i) {
            this.playerHealthW[i] = i * 1000 / (this.playerHealth * 1000 / Resources.resSprs[71].getWidth());
        }
        this.playerMana = Player.getStatValue(5);
        this.playerManaW = new int[this.playerMana + 1];
        for (i = 0; i <= this.playerMana; ++i) {
            this.playerManaW[i] = i * 1000 / (this.playerMana * 1000 / Resources.resSprs[71].getWidth());
        }
    }

    public static void resetShowAnimation() {
        iTableAnimation = TABLE_ANIMATION = (Resources.resSprs[0].getWidth() >> 1) * 3;
        iHide = 0;
        hideScreen = false;
    }

    public void generateWave(int type, int newWave) {
        int[] wave = this.getWave(newWave);
        if (type == Varr.ENEMY_CANNON) {
            wave = this.getCannonWave(newWave);
        }
        int g = 0;
        int waveDeformator = RandomNum.getRandomUInt(3);
        if (Player.getStage() < 30) {
            waveDeformator = 0;
        }
        g = waveDeformator == 2 ? this.MAX_LAYERS + 1 : 0;
        for (int i = this.MAX_LAYERS - 1; i >= 0; --i) {
            if (waveDeformator == 1) {
                if (++g == this.MAX_LAYERS + 1) {
                    g = 0;
                }
            } else if (waveDeformator == 2) {
                if (--g == 0) {
                    g = this.MAX_LAYERS + 1;
                }
            } else {
                g = 0;
            }
            for (int j = this.MAX_LAYERS - 1; j >= 0; --j) {
                int enemyID = this.INT_NULL;
                for (int y = this.MAX_ENEMIES - 1; y >= 0; --y) {
                    if (this.enemyX[i][y] != this.INT_NULL) continue;
                    enemyID = y;
                    y = 0;
                }
                if (enemyID == this.INT_NULL || wave[j * this.MAX_LAYERS + i] != 1) continue;
                this.addEnemyOnLayer(i, enemyID, j - g, type, Varr.STATE_WALK);
            }
        }
    }

    public int getEnemyHeight(int type) {
        if (type == Varr.ENEMY_GHOST && Resources.resSprs[7] != null) {
            return Resources.resSprs[7].getHeight();
        }
        if (type == Varr.ENEMY_ORC && Resources.resSprs[15] != null) {
            return Resources.resSprs[15].getHeight();
        }
        if (type == Varr.ENEMY_BAT && Resources.resSprs[23] != null) {
            return Resources.resSprs[23].getHeight();
        }
        if (type == Varr.ENEMY_GOLEM && Resources.resSprs[27] != null) {
            return Resources.resSprs[27].getHeight();
        }
        return Resources.resSprs[7].getHeight();
    }

    public void addEnemyShot(int x, int y, int enemyType) {
        for (int i = 0; i < 100; ++i) {
            if (this.enemyShotX[i] != this.INT_NULL) continue;
            this.enemyShotX[i] = x;
            this.enemyShotY[i] = y;
            this.enemyShotType[i] = enemyType;
            this.explosionParticlesFrame[i] = 0;
            i = 100;
        }
    }

    public void addBossShot() {
        this.bossShotPositionX = this.bossPositionX + this.bossWidth / 3 + 3;
        this.bossShotPositionY = this.bossPositionY + Resources.resSprs[44].getHeight() / 3 + 2;
    }

    public void addCloud(int x, int y) {
        for (int j = 0; j < this.MAX_POISONS; ++j) {
            if (this.cloudX[j] != this.INT_NULL) continue;
            this.cloudX[j] = x;
            this.cloudY[j] = y;
            this.cloudFrame[j] = 0;
            j = this.MAX_POISONS;
        }
    }

    public void addFrostCloud(int x, int y) {
        for (int j = 0; j < this.MAX_FROST; ++j) {
            if (this.frostCloudX[j] != this.INT_NULL) continue;
            this.frostCloudX[j] = x;
            this.frostCloudY[j] = y;
            this.frostCloudFrame[j] = 0;
            j = this.MAX_FROST;
        }
    }

    public void addCrit(int layer, int ID) {
        for (int i = 0; i < 50; ++i) {
            if (this.critX[i] != this.INT_NULL) continue;
            this.critX[i] = this.enemyX[layer][ID];
            this.critY[i] = this.enemyY[layer][ID];
            this.critcounter[i] = 7;
            i = 50;
        }
    }

    public void addBossCrit() {
        for (int i = 0; i < 50; ++i) {
            if (this.critX[i] != this.INT_NULL) continue;
            this.critX[i] = this.bossPositionX;
            this.critY[i] = this.bossPositionY;
            this.critcounter[i] = 7;
            i = 50;
        }
    }

    public void addEnemyOnLayer(int layer, int ID, int y, int type, int state) {
        this.enemyType[layer][ID] = type;
        this.enemyX[layer][ID] = this.generateX[layer];
        this.enemyY[layer][ID] = -(this.MAX_LAYERS * (this.enemyH >> 1) - (this.enemyH >> 1) * y);
        this.enemyHealth[layer][ID] = this.getEnemyHealth(this.enemyType[layer][ID]);
        this.enemyState[layer][ID] = state;
        this.enemyAtackCounter[layer][ID] = 0;
        this.enemyFrostCounter[layer][ID] = 0;
        this.enemyFireCounter[layer][ID] = 0;
        this.enemyPoisonCounter[layer][ID] = 0;
    }

    public void addExplosion(int x, int y) {
        for (int j = 0; j < this.MAX_METEORS; ++j) {
            if (this.explosionX[j] != this.INT_NULL) continue;
            this.explosionX[j] = x;
            this.explosionY[j] = y;
            this.explosionFrame[j] = 0;
            j = this.MAX_METEORS;
        }
    }

    public void addCorpse(int i, int j, int direction) {
        for (int y = 0; y < this.MAX_LAYERS; ++y) {
            for (int ii = 0; ii < this.MAX_CORPSES; ++ii) {
                if (this.corpseX[y][ii] != this.INT_NULL) continue;
                this.corpseX[i][ii] = this.enemyX[i][j];
                this.corpseY[i][ii] = this.enemyY[i][j];
                if (direction == 0) {
                    this.corpseFrame[i][ii] = 0;
                }
                if (direction == 1) {
                    this.corpseFrame[i][ii] = 11;
                }
                this.corpseDirection[i][ii] = direction;
                this.corpseType[i][ii] = this.enemyType[i][j];
                ii = this.MAX_CORPSES;
                y = this.MAX_LAYERS;
            }
        }
    }

    public void addBossCorpse() {
        if (this.bossPositionX != this.INT_NULL) {
            this.bossCorpsePositionX = this.bossPositionX + this.bossWidth;
            this.bossCorpsePositionY = this.bossPositionY + this.bossHeight;
            this.bossCorpseFrame = 35;
        }
    }

    public void removeShot(int shot) {
        this.shotRadius[shot] = this.INT_NULL;
        ++this.actualShot;
        if (this.actualShot >= 100) {
            this.actualShot = 0;
        }
    }

    public void removeTowerOneShot(int shot) {
        this.towerOneShotRadius[shot] = this.INT_NULL;
        ++this.towerOneActualShot;
        if (this.towerOneActualShot >= 100) {
            this.towerOneActualShot = 0;
        }
    }

    public void removeTowerTwoShot(int shot) {
        this.towerTwoShotRadius[shot] = this.INT_NULL;
        ++this.towerTwoActualShot;
        if (this.towerTwoActualShot >= 100) {
            this.towerTwoActualShot = 0;
        }
    }

    public void removeEnemy(int i, int j) {
        this.enemyX[i][j] = this.INT_NULL;
    }

    public void removeBoss() {
        this.bossPositionX = this.INT_NULL;
        this.bossPositionY = this.INT_NULL;
        this.bossState = Varr.STATE_DEAD;
    }

    public void trace(String str) {
        System.out.println(str);
    }

    public void update(long lastRunLenght) {
        if (MainCanvas.interuption_nokia == 0) {
            if (this.cycle > 0) {
                --this.cycle;
            } else if (MainCanvas.nokia == 1) {
                MainCanvas.nokia = 0;
                MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                this.cycle = 10;
                MainCanvas.a = 8888;
            }
        }
        ++this.updateCounter;
        if (this.updateCounter > 999999) {
            this.updateCounter = 0;
        }
        switch (mode) {
            case 0: {
                this.lastMode = 0;
                this.timerIsAlreadyExpired = false;
                ++this.startCounter;
                stopCountDown = false;
                this.countDownNumber = 10;
                this.updateBossSpeed();
                this.winLoseCounterUpdated = false;
                ++this.updateGameCounter;
                if (this.updateGameCounter > 9999) {
                    this.updateGameCounter = 0;
                }
                this.enemyFrame = this.updateCounter % 12 >> 1;
                this.updateAim();
                if (this.touch == 1) {
                    this.updateAim(true);
                } else if (this.touch == 2) {
                    this.updateAim(false);
                }
                this.autoShot();
                this.updateShots();
                this.updateEnemyShots();
                this.updateCrit();
                this.updateShieldRegen();
                this.clearField = true;
                if (this.bossState != Varr.STATE_DEAD) {
                    this.updateCorpses();
                    this.updateEnemies();
                    this.updateSpeed();
                } else {
                    this.updateBossCorpse();
                }
                if (this.bossIsReadyToGo) {
                    this.bossDead = false;
                    this.loadBoss();
                    this.initBoss();
                    this.updateBoss();
                    ++this.bossAlertTimer;
                    if (this.playerHealth <= 0) {
                        this.playerHealth = 0;
                        this.updateGameOver();
                        if (this.gameOverTimer > 10) {
                            mode = 7;
                            ScreenGame.resetShowAnimation();
                            MainCanvas.soundManager.Stop();
                            MainCanvas.soundManager.Play(Sounds.SOUND_LOST, 1);
                        }
                    }
                }
                if (!this.bossIsReadyToGo) {
                    this.updateWaves();
                }
                this.updateGameOverWin();
                this.updateSpells();
                this.regenerateMana();
                if (this.tomeOfPowerTimer == 2) {
                    if (this.activeStaff == this.INT_NULL) {
                        this.activeStaff = 9;
                    }
                    this.setStaffColor(this.activeStaff);
                    this.tomeOfPowerTimer = 1;
                }
                if (this.notEnoughTimer > 0) {
                    --this.notEnoughTimer;
                }
                if ((Player.getStage() + 1) % 10 == 0) {
                    this.bossInThisStage = true;
                }
                if (Player.towerWasUpgraded) {
                    ++this.towerUpgradeTimeout;
                    if (this.towerUpgradeTimeout > 20) {
                        this.updateTowerAnimation();
                    }
                }
                if (!this.showNewTower) break;
                this.updateNewTowerAnimation();
                break;
            }
            case 1: {
                this.animateTable();
                this.animateHide();
                break;
            }
            case 3: {
                if (!this.winLoseCounterUpdated) {
                    Player.loseCountInRow = 0;
                    this.winLoseCounterUpdated = true;
                    --Player.dieHintStep;
                    if (this.playerHealth > 900 && !this.playerUsedHP && Player.getStage() > 10) {
                        ++Player.enemiesStronger;
                    }
                }
                this.animateTable();
                this.animateHide();
                this.updateBossCorpse();
                this.lastMode = 3;
                break;
            }
            case 11: {
                this.animateTable();
                this.animateHide();
                this.updateBossCorpse();
                this.lastMode = 11;
                break;
            }
            case 4: {
                if (!this.winLoseCounterUpdated) {
                    ++Player.loseCountInRow;
                    this.winLoseCounterUpdated = true;
                    if (this.playerHealth < 600 && Player.getStage() > 10 && Player.enemiesStronger > 0) {
                        --Player.enemiesStronger;
                    }
                }
                this.animateTable();
                this.animateHide();
                this.releaseBoss();
                for (int i = 0; i < this.progressH.length; ++i) {
                    this.progressH[i] = MainCanvas.WIDTH;
                }
                Player.diedMoreThanOnce = true;
                this.lastMode = 4;
                break;
            }
            case 6: {
                this.animateTable();
                this.animateHide();
                break;
            }
            case 9: {
                this.animateTable();
                this.animateHide();
                break;
            }
            case 7: {
                this.animateTable();
                this.animateHide();
                if (!(this.timerIsAlreadyExpired || Player.getConsumableCount(5) != 0 && ShopItems.LOCKED[23] <= Player.getStage())) {
                    this.updateCountDown();
                }
                if (!this.timerIsAlreadyExpired) break;
                mode = 4;
                break;
            }
            case 8: {
                this.animateTable();
                this.animateHide();
            }
        }
        this.mainCanvas.repaint();
    }

    private void updateCountDown() {
        if (System.currentTimeMillis() - Varr.continueStartTime > 1000L && !stopCountDown) {
            --this.countDownNumber;
            Varr.continueStartTime = System.currentTimeMillis();
        }
        if (this.countDownNumber < 0) {
            mode = 4;
            this.timerIsAlreadyExpired = true;
        }
    }

    private void updateGameOver() {
        ++this.gameOverTimer;
    }

    private void updateShieldRegen() {
        if (this.updateCounter % 2 == 0 && this.playerShield < Player.getPlayerShield() * 50) {
            this.playerShield += 2;
        }
    }

    public void updateSpells() {
        for (int i = 0; i < 3; ++i) {
            if (this.spellCounter[i] == 1) {
                this.spellSelectorAnimation[i] = 3;
            }
            if (this.spellCounter[i] <= 0) continue;
            int n = i;
            this.spellCounter[n] = this.spellCounter[n] - 1;
        }
        this.updateMeteors();
        this.updateFrost();
        this.updatePoison();
    }

    public void updateMeteors() {
        int i;
        for (i = 0; i < this.MAX_METEORS; ++i) {
            if (this.explosionX[i] != this.INT_NULL && this.updateCounter % 2 == 0) {
                int n = i;
                this.explosionFrame[n] = this.explosionFrame[n] + 1;
                if (this.explosionFrame[i] == 7) {
                    this.explosionX[i] = this.INT_NULL;
                }
            }
            if (this.meteorX[i] == this.INT_NULL) continue;
            int n = i;
            this.meteorY[n] = this.meteorY[n] + 6;
            if (MainCanvas.HEIGHT > 700) {
                int n2 = i;
                this.meteorY[n2] = this.meteorY[n2] + 6;
            }
            if (this.meteorY[i] < this.meteorTarget[i]) continue;
            this.addExplosion(this.meteorX[i], this.meteorY[i]);
            this.collideExplosion(this.meteorX[i], this.meteorY[i]);
            this.meteorX[i] = this.INT_NULL;
        }
        for (i = 0; i < this.MAX_LAYERS; ++i) {
            for (int j = this.MAX_ENEMIES - 1; j >= 0; --j) {
                if (this.enemyFireCounter[i][j] <= 0) continue;
                int[] nArray = this.enemyFireCounter[i];
                int n = j;
                nArray[n] = nArray[n] - 1;
                if (this.updateCounter % 10 != 0) continue;
            }
        }
    }

    public void updatePoison() {
        int i;
        for (i = 0; i < this.MAX_POISONS; ++i) {
            if (this.cloudX[i] != this.INT_NULL && this.updateCounter % 2 == 0) {
                int n = i;
                this.cloudFrame[n] = this.cloudFrame[n] + 1;
                if (this.cloudFrame[i] == 5) {
                    this.cloudX[i] = this.INT_NULL;
                }
            }
            if (this.poisonX[i] == this.INT_NULL) continue;
            int n = i;
            this.poisonY[n] = this.poisonY[n] + 9;
            if (this.poisonY[i] < this.poisonTarget[i]) continue;
            this.addCloud(this.poisonX[i], this.poisonY[i]);
            this.collidePoison(this.poisonX[i], this.poisonY[i]);
            this.poisonX[i] = this.INT_NULL;
        }
        for (i = 0; i < this.MAX_LAYERS; ++i) {
            for (int j = this.MAX_ENEMIES - 1; j >= 0; --j) {
                if (this.enemyPoisonCounter[i][j] <= 0) continue;
                int[] nArray = this.enemyPoisonCounter[i];
                int n = j;
                nArray[n] = nArray[n] - 1;
                if (this.updateCounter % 2 != 0) continue;
                this.makeDmg(i, j, 4 + 10 * Player.getSpellStatus(2));
            }
        }
    }

    public void updateFrost() {
        for (int i = 0; i < this.MAX_FROST; ++i) {
            if (this.frostCloudX[i] != this.INT_NULL && this.updateCounter % 2 == 0) {
                int n = i;
                this.frostCloudFrame[n] = this.frostCloudFrame[n] + 1;
                if (this.frostCloudFrame[i] == 3) {
                    this.frostCloudX[i] = this.INT_NULL;
                }
            }
            if (this.frostX[i] == this.INT_NULL) continue;
            int n = i;
            this.frostY[n] = this.frostY[n] + 9;
            if (this.frostY[i] < this.meteorTarget[i]) continue;
            this.addFrostCloud(this.frostX[i], this.frostY[i]);
            this.collideFrost(this.frostX[i], this.frostY[i]);
            this.frostX[i] = this.INT_NULL;
        }
    }

    public void updateAim() {
        if (Keys.isActionPressed(3) && !Keys.isKeyPressed(49) && !Keys.isKeyPressed(55)) {
            if (this.aimingAngle > 205) {
                this.aimingAngle -= 5;
            }
        } else if (Keys.isActionPressed(4) && !Keys.isKeyPressed(51) && !Keys.isKeyPressed(57) && this.aimingAngle < 335) {
            this.aimingAngle += 5;
        }
        if (this.updateCounter % 2 == 0) {
            ++this.aimSelected;
            if (this.aimSelected > 11) {
                this.aimSelected = 0;
            }
        }
    }

    public void updateAim(boolean left) {
        if (left) {
            if (this.aimingAngle > 205) {
                this.aimingAngle -= 5;
            }
        } else if (!left && this.aimingAngle < 335) {
            this.aimingAngle += 5;
        }
        if (this.updateCounter % 2 == 0) {
            ++this.aimSelected;
            if (this.aimSelected > 11) {
                this.aimSelected = 0;
            }
        }
    }

    public void updateCrit() {
        for (int i = 0; i < 50; ++i) {
            if (this.critX[i] == this.INT_NULL) continue;
            int n = i;
            this.critcounter[n] = this.critcounter[n] - 1;
            if (this.critcounter[i] != 0) continue;
            this.critX[i] = this.INT_NULL;
        }
    }

    public void updateShots() {
        for (int i = 0; i < this.MAX_SHOTS; ++i) {
            if (this.shotRadius[i] == this.INT_NULL) continue;
            int n = i;
            this.shotRadius[n] = this.shotRadius[n] + Common.SHOT_SPEED * 2;
            if (this.shotFromTower[i] == 1) {
                this.shotX[i] = this.getAimArcXTowerOne(this.shotAngle[i], this.shotRadius[i]);
                this.shotY[i] = this.getAimArcYTowerOne(this.shotAngle[i], this.shotRadius[i]);
            } else if (this.shotFromTower[i] == 2) {
                this.shotX[i] = this.getAimArcXTowerTwo(this.shotAngle[i], this.shotRadius[i]);
                this.shotY[i] = this.getAimArcYTowerTwo(this.shotAngle[i], this.shotRadius[i]);
            } else {
                this.shotX[i] = this.getAimArcX(this.shotAngle[i], this.shotRadius[i]);
                this.shotY[i] = this.getAimArcY(this.shotAngle[i], this.shotRadius[i]);
            }
            if (!this.isShotActive(i)) {
                this.removeShot(i);
                continue;
            }
            this.collideShot(i);
            this.collideShotWithBoss(i);
            this.collideBossShot();
        }
    }

    public void updateTowerOneShots() {
        for (int i = 0; i < this.MAX_SHOTS; ++i) {
            if (this.towerOneShotRadius[i] == this.INT_NULL) continue;
            int n = i;
            this.towerOneShotRadius[n] = this.towerOneShotRadius[n] + Common.SHOT_SPEED * 2;
            this.towerOneShotX[i] = this.getAimArcXTowerOne(this.towerOneShotAngle[i], this.towerOneShotRadius[i]);
            this.towerOneShotY[i] = this.getAimArcYTowerOne(this.towerOneShotAngle[i], this.towerOneShotRadius[i]);
            if (!this.isTowerOneShotActive(i)) {
                this.removeTowerOneShot(i);
                continue;
            }
            this.collideShot(i);
            this.collideShotWithBoss(i);
            this.collideBossShot();
        }
    }

    public void updateTowerTwoShots() {
        for (int i = 0; i < this.MAX_SHOTS; ++i) {
            if (this.towerTwoShotRadius[i] == this.INT_NULL) continue;
            int n = i;
            this.towerTwoShotRadius[n] = this.towerTwoShotRadius[n] + Common.SHOT_SPEED * 2;
            this.towerTwoShotX[i] = this.getAimArcXTowerTwo(this.towerTwoShotAngle[i], this.towerTwoShotRadius[i]);
            this.towerTwoShotY[i] = this.getAimArcYTowerTwo(this.towerTwoShotAngle[i], this.towerTwoShotRadius[i]);
            if (!this.isTowerOneShotActive(i)) {
                this.removeTowerTwoShot(i);
                continue;
            }
            this.collideShot(i);
            this.collideShotWithBoss(i);
            this.collideBossShot();
        }
    }

    public void updateWaves() {
        if (this.actualWave <= this.waves.length && !this.allWavesGenerated) {
            ++this.generateWaveCounter;
            int stage = Player.getStage();
            if (this.generateWaveCounter >= this.WAVE_DELAY || this.firstWave) {
                if (stage <= 29) {
                    block0 : switch (stage) {
                        case 0: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_BAT, 0);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_BAT, 1);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_BAT, 2);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_BAT, 3);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_BAT, 2);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_BAT, 1);
                                }
                            }
                            break;
                        }
                        case 1: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_BAT, 1);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_BAT, 2);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_BAT, 2);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_ORC, 3);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_ORC, 1);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_ORC, 2);
                                }
                            }
                            break;
                        }
                        case 2: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_BAT, 2);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_ORC, 1);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_ORC, 3);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_BAT, 3);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_ORC, 5);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_ORC, 4);
                                }
                            }
                            break;
                        }
                        case 3: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_ORC, 0);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_BAT, 1);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_ORC, 4);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_ORC, 5);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_ORC, 6);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_BAT, 4);
                                }
                            }
                            break;
                        }
                        case 4: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_BAT, 4);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_ORC, 4);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_GHOST, 5);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_ORC, 7);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_GHOST, 3);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_ORC, 6);
                                }
                            }
                            break;
                        }
                        case 5: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_ORC, 0);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_BAT, 1);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_ORC, 6);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_ORC, 2);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_ORC, 6);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_BAT, 4);
                                }
                            }
                            break;
                        }
                        case 6: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_BAT, 4);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_ORC, 3);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_GHOST, 3);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_ORC, 4);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_GHOST, 4);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_ORC, 6);
                                }
                            }
                            break;
                        }
                        case 7: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_ORC, 0);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_BAT, 4);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_ORC, 7);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_BAT, 5);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_GHOST, 4);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_BAT, 6);
                                }
                            }
                            break;
                        }
                        case 8: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_ORC, 2);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_BAT, 1);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_ORC, 3);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_ORC, 5);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_ORC, 4);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_BAT, 4);
                                }
                            }
                            break;
                        }
                        case 9: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_ORC, 4);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_ORC, 1);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_GHOST, 4);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_ORC, 4);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 4);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_ORC, 5);
                                }
                            }
                            break;
                        }
                        case 10: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_ORC, 0);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_BAT, 1);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_ORC, 2);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 0);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_ORC, 3);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_BAT, 3);
                                }
                            }
                            break;
                        }
                        case 11: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 1);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_ORC, 3);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_GHOST, 1);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_ORC, 1);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_BAT, 3);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_ORC, 2);
                                }
                            }
                            break;
                        }
                        case 12: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 0);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_BAT, 2);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_ORC, 3);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 1);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_GHOST, 3);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_BAT, 4);
                                }
                            }
                            break;
                        }
                        case 13: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_GHOST, 2);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 1);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_BAT, 3);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_ORC, 5);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 3);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_BAT, 4);
                                }
                            }
                            break;
                        }
                        case 14: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_ORC, 4);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_GHOST, 2);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_BAT, 3);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_ORC, 4);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 4);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_CANNON, 1);
                                    break block0;
                                }
                                case 6: {
                                    this.generateWave(Varr.ENEMY_ORC, 2);
                                }
                            }
                            break;
                        }
                        case 15: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 0);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_BAT, 4);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_GHOST, 3);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_ORC, 4);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_GHOST, 2);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_CANNON, 1);
                                    break block0;
                                }
                                case 6: {
                                    this.generateWave(Varr.ENEMY_ORC, 5);
                                    break block0;
                                }
                                case 7: {
                                    this.generateWave(Varr.ENEMY_BAT, 2);
                                }
                            }
                            break;
                        }
                        case 16: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_BAT, 5);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_GHOST, 2);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_ORC, 5);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_CANNON, 0);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_GHOST, 3);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 4);
                                    break block0;
                                }
                                case 6: {
                                    this.generateWave(Varr.ENEMY_ORC, 1);
                                }
                            }
                            break;
                        }
                        case 17: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_ORC, 5);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_GHOST, 3);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_BAT, 6);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 4);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_GHOST, 2);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 4);
                                }
                            }
                            break;
                        }
                        case 18: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_BAT, 6);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 1);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_CANNON, 1);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_ORC, 5);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_GHOST, 3);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_BAT, 5);
                                }
                            }
                            break;
                        }
                        case 19: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_GHOST, 5);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_BAT, 5);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_ORC, 3);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 1);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_GHOST, 2);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_ORC, 4);
                                    break block0;
                                }
                                case 6: {
                                    this.generateWave(Varr.ENEMY_GHOST, 2);
                                    break block0;
                                }
                                case 7: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 1);
                                }
                            }
                            break;
                        }
                        case 20: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_BAT, 4);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_ORC, 4);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_GHOST, 2);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 4);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_GHOST, 1);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_ORC, 3);
                                }
                            }
                            break;
                        }
                        case 21: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_CANNON, 1);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_ORC, 3);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_GHOST, 3);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 1);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_BAT, 2);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_ORC, 4);
                                }
                            }
                            break;
                        }
                        case 22: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_BAT, 3);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 3);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_ORC, 1);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_GHOST, 5);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_BAT, 3);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_ORC, 5);
                                }
                            }
                            break;
                        }
                        case 23: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_CANNON, 1);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_BAT, 3);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_ORC, 2);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 5);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_GHOST, 3);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_ORC, 5);
                                }
                            }
                            break;
                        }
                        case 24: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 1);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_ORC, 3);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_GHOST, 3);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_CANNON, 0);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_BAT, 5);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_ORC, 5);
                                }
                            }
                            break;
                        }
                        case 25: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_ORC, 6);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 0);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_ORC, 6);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_BAT, 4);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 2);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_ORC, 7);
                                }
                            }
                            break;
                        }
                        case 26: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_BAT, 3);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 2);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_ORC, 5);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_BAT, 3);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_GHOST, 6);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_ORC, 5);
                                }
                            }
                            break;
                        }
                        case 27: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_ORC, 3);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_ORC, 3);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_ORC, 4);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 5);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_GHOST, 6);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_ORC, 5);
                                    break block0;
                                }
                                case 6: {
                                    this.generateWave(Varr.ENEMY_BAT, 7);
                                }
                            }
                            break;
                        }
                        case 28: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 5);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_ORC, 3);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_GHOST, 2);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 4);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_GHOST, 4);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_ORC, 5);
                                    break block0;
                                }
                                case 6: {
                                    this.generateWave(Varr.ENEMY_BAT, 3);
                                }
                            }
                            break;
                        }
                        case 29: {
                            switch (this.actualWave) {
                                case 0: {
                                    this.generateWave(Varr.ENEMY_CANNON, 1);
                                    this.firstWave = false;
                                    break block0;
                                }
                                case 1: {
                                    this.generateWave(Varr.ENEMY_BAT, 10);
                                    break block0;
                                }
                                case 2: {
                                    this.generateWave(Varr.ENEMY_GHOST, 6);
                                    break block0;
                                }
                                case 3: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 0);
                                    break block0;
                                }
                                case 4: {
                                    this.generateWave(Varr.ENEMY_ORC, 8);
                                    break block0;
                                }
                                case 5: {
                                    this.generateWave(Varr.ENEMY_GOLEM, 6);
                                    break block0;
                                }
                                case 6: {
                                    this.generateWave(Varr.ENEMY_BAT, 7);
                                }
                            }
                        }
                    }
                } else {
                    int paramGenSet = Player.getGeneratorSet();
                    int paramStage = stage - (stage - stage % 10);
                    int paramOrder = this.actualWave;
                    if (paramOrder == 0) {
                        this.firstWave = true;
                    }
                    this.generateWave(this.genEnemyType[paramGenSet][paramStage][paramOrder], this.genEnemyType[paramGenSet][paramStage][paramOrder]);
                    this.firstWave = false;
                }
                this.generateWaveCounter = 0;
                ++this.actualWave;
                if (this.actualWave == this.waves.length) {
                    this.allWavesGenerated = true;
                }
            }
        } else {
            this.allWavesGenerated = true;
        }
    }

    private void updateGameOverWin() {
        if (this.clearField && this.allWavesGenerated) {
            int i;
            for (i = 0; i < this.progressH.length; ++i) {
                this.progressH[i] = MainCanvas.WIDTH;
            }
            if (this.bossInThisStage && this.bossPositionX != this.INT_NULL) {
                this.bossIsReadyToGo = true;
            } else {
                this.updateGameOver();
                if (this.bossIsReadyToGo && this.gameOverTimer > 30 || !this.bossIsReadyToGo && this.gameOverTimer > 10) {
                    if (!this.winStatUpdated) {
                        mode = 3;
                        if (Player.getConsumableCount(4) > 0) {
                            this.thisStageCash *= 2;
                        }
                        if (Player.getStage() == 0) {
                            this.thisStageCash += 60;
                        }
                        if (++Player.streak > 1) {
                            for (i = 0; i < this.stageBonus.length; ++i) {
                                this.stageBonus[i] = Player.getStageBonus(Player.streak + i, i - 1);
                                if (Player.getConsumableCount(4) <= 0) continue;
                                this.stageBonus[i] = this.stageBonus[i] * 2;
                            }
                        }
                        Player.incStage();
                        ScreenGame.resetShowAnimation();
                        int percentage = (int)((double)(2 * Player.getStage()) * 1.99) * 2;
                        int plus4percent = (int)((double)(this.thisStageCash * 10000 / 100 * percentage / 10000) * 1.99) * 2 + 8;
                        MainCanvas.player[MainCanvas.activePlayer].addCash(this.thisStageCash + plus4percent + this.stageBonus[1]);
                        if (this.bossInThisStage) {
                            this.bossDead = true;
                            this.bossDroppedItem = Player.bossStageItemDrop(Player.getStage());
                        }
                        MainCanvas.soundManager.Stop();
                        MainCanvas.soundManager.Play(Sounds.SOUND_WIN, 1);
                        this.winStatUpdated = true;
                    } else if (Player.streak > 1) {
                        mode = 11;
                    }
                }
            }
        }
    }

    public void updateSpeed() {
        if (this.enemiesAreMoving) {
            for (int i = 0; i < this.enemySpeed.length; ++i) {
                int n = i;
                this.enemySpeedBuffer[n] = this.enemySpeedBuffer[n] + this.enemySpeed[i];
                this.enemySpeedInc[i] = this.enemySpeedBuffer[i] >> 3;
                this.enemySpeedBuffer[i] = this.enemySpeedBuffer[i] % 8;
            }
        }
    }

    public void updateBossSpeed() {
        this.bossSpeedBuffer += this.bossSpeed;
        this.bossSpeedBuffer %= 8;
    }

    public void updateCorpses() {
        for (int i = 0; i < this.MAX_LAYERS; ++i) {
            for (int j = 0; j < this.MAX_CORPSES; ++j) {
                if (this.corpseX[i][j] == this.INT_NULL) continue;
                this.clearField = false;
                if (this.corpseDirection[i][j] == 0) {
                    int[] nArray = this.corpseFrame[i];
                    int n = j;
                    nArray[n] = nArray[n] + 1;
                    if (this.corpseFrame[i][j] != 12) continue;
                    this.corpseX[i][j] = this.INT_NULL;
                    continue;
                }
                if (this.corpseDirection[i][j] != 1) continue;
                int[] nArray = this.corpseFrame[i];
                int n = j;
                nArray[n] = nArray[n] - 1;
                if (this.corpseFrame[i][j] != 0) continue;
                this.corpseX[i][j] = this.INT_NULL;
                this.bossState = Varr.STATE_HIDE;
            }
        }
    }

    public void setSummonedEnemiesToWalk() {
        for (int i = 0; i < this.MAX_LAYERS; ++i) {
            for (int j = 0; j < this.MAX_ENEMIES; ++j) {
                if (this.enemyX[i][j] == this.INT_NULL) continue;
                this.enemyState[i][j] = Varr.STATE_WALK;
            }
        }
    }

    public void updateBossCorpse() {
        if (this.bossCorpsePositionX != this.INT_NULL) {
            if (this.updateCounter % 4 == 0) {
                ++this.bossCorpseFrame;
            }
            if (this.bossCorpseFrame > 39) {
                this.bossCorpseFrame = 39;
            }
        }
    }

    private void summonBossMinions(int enemyCount, int enemyType) {
        this.bossJumpCounter = 0;
        this.enemiesAreMoving = false;
        this.minionsCount = enemyCount;
        int layer = 1;
        int y = 8;
        for (int m = 0; m < this.minionsCount; ++m) {
            this.addEnemyOnLayer(layer, m, y, enemyType, Varr.STATE_HIDE);
            this.addCorpse(layer, m, 1);
            if ((layer += 4) <= 5) continue;
            layer = 1;
            ++y;
        }
        this.bossLastHpBorder = this.bossHealth;
        ++this.bossMinionType;
    }

    public void updateBoss() {
        ++this.bossUpdateCounter;
        if (this.bossUpdateCounter > 999999) {
            this.bossUpdateCounter = 0;
        }
        if (this.shakeBackground) {
            ++this.backgroundPosCounter;
            if (this.backgroundPosCounter == 0) {
                this.backgroundPositionX = (MainCanvas.WIDTH >> 1) + 2;
            }
            if (this.backgroundPosCounter == 1) {
                this.backgroundPositionX = (MainCanvas.WIDTH >> 1) - 1;
            }
            if (this.backgroundPosCounter == 2) {
                this.backgroundPositionX = (MainCanvas.WIDTH >> 1) - 2;
            }
            if (this.backgroundPosCounter == 3) {
                this.backgroundPositionX = (MainCanvas.WIDTH >> 1) + 2;
            }
            if (this.backgroundPosCounter == 4) {
                this.backgroundPositionX = (MainCanvas.WIDTH >> 1) - 2;
            }
            if (this.backgroundPosCounter == 5) {
                this.backgroundPositionX = MainCanvas.WIDTH >> 1;
                this.shakeBackground = false;
            }
            if (this.backgroundPosCounter == 5) {
                this.backgroundPosCounter = 0;
            }
        }
        if (this.bossIsReadyToGo) {
            long bossQuaterLife = this.bossMaxHealth / 4L;
            if (this.bossState == Varr.STATE_HIDE && this.minionsCount == 0) {
                this.bossState = Varr.STATE_SHOW;
            } else if (this.bossHealth < this.bossLastHpBorder - bossQuaterLife && this.bossHealth > 0L && this.bossState != Varr.STATE_HIDE && this.bossState != Varr.STATE_SHOW && Player.getStage() > 10) {
                this.summonBossMinions(6, this.bossMinionType);
            } else {
                if (this.bossState == Varr.STATE_WALK) {
                    int towerHeight = this.towerWallHeight;
                    if (this.bossPositionY <= MainCanvas.HEIGHT - towerHeight - this.bossHeight / 4 - 50) {
                        this.bossPositionY += this.bossSpeed / 5;
                    } else {
                        this.bossState = this.bossUpdateCounter % 40 == 0 ? Varr.STATE_ATTACK : Varr.STATE_ATTACK;
                    }
                } else if (this.bossState == Varr.STATE_JUMP) {
                    ++this.bossJumpCounter;
                    int towerHeight = this.towerWallHeight;
                    if (this.bossJumpCounter == 8) {
                        int bossPosXRand = RandomNum.getRandomUInt(MainCanvas.WIDTH - this.bossWidth);
                        while (bossPosXRand - this.bossPositionX < MainCanvas.WIDTH / 4 && bossPosXRand - this.bossPositionX > 0 - MainCanvas.WIDTH / 4) {
                            bossPosXRand = RandomNum.getRandomUInt(MainCanvas.WIDTH - this.bossWidth);
                        }
                        this.bossPositionX = bossPosXRand;
                        int bosPosYRand = this.bossPositionY + (RandomNum.getRandomUInt(this.bossHeight) - this.bossHeight / 2);
                        this.bossPositionY = this.bossPositionY <= MainCanvas.HEIGHT - towerHeight - this.bossHeight / 4 - 50 ? bosPosYRand : MainCanvas.HEIGHT - towerHeight - this.bossHeight / 4 - 50;
                    }
                    if (this.bossJumpCounter > 16) {
                        this.bossJumpCounter = 0;
                        this.bossState = this.bossPositionY <= MainCanvas.HEIGHT - towerHeight - this.bossHeight / 4 - 50 ? Varr.STATE_WALK : Varr.STATE_ATTACK;
                    }
                } else if (this.bossState == Varr.STATE_HIDE) {
                    if (this.updateCounter % 2 == 0) {
                        ++this.bossJumpCounter;
                    }
                    if (this.bossJumpCounter == 8) {
                        this.bossPositionX = -1999;
                        this.bossPositionY = -1999;
                    }
                    if (this.bossJumpCounter > 7) {
                        this.bossJumpCounter = 8;
                    }
                } else if (this.bossState == Varr.STATE_SHOW) {
                    if (this.updateCounter % 2 == 0) {
                        --this.bossJumpCounter;
                    }
                    this.bossPositionX = (MainCanvas.WIDTH >> 1) - (this.bossWidth >> 1);
                    this.bossPositionY = (MainCanvas.HEIGHT >> 1) - (this.bossHeight >> 1);
                    if (this.bossJumpCounter == 0) {
                        this.bossState = Varr.STATE_ATTACK;
                    }
                } else if (this.bossState == Varr.STATE_WAIT) {
                    ++this.bossAttackCounter;
                    if (this.bossAttackCounter > 10) {
                        this.bossAttackCounter = 0;
                        this.bossState = Varr.STATE_JUMP;
                    }
                } else if (this.bossState == Varr.STATE_ATTACK) {
                    ++this.bossAttackCounter;
                    if (this.bossAttackCounter > 0 && this.bossAttackCounter <= 60) {
                        if (this.updateCounter % 30 == 0) {
                            this.addBossShot();
                        }
                    } else {
                        this.bossAttackCounter = 0;
                        this.bossState = Varr.STATE_WAIT;
                    }
                }
                if (this.bossShotPositionX != this.INT_NULL) {
                    this.bossShotPositionY += 10;
                }
            }
        }
    }

    public void updateEnemies() {
        this.enemiesTotalCount = 0;
        for (int i = 0; i < this.MAX_LAYERS; ++i) {
            int attackersCount = 0;
            for (int j = 0; j < this.MAX_ENEMIES; ++j) {
                if (this.enemyX[i][j] < 0 && this.enemyX[i][j] > MainCanvas.WIDTH && this.enemyY[i][j] > MainCanvas.HEIGHT) {
                    this.removeEnemy(i, j);
                }
                if (this.enemyX[i][j] == this.INT_NULL || this.enemyY[i][j] == this.INT_NULL) continue;
                ++this.enemiesTotalCount;
                this.collideLava(i, j);
                if (this.enemyFrostCounter[i][j] == 0) {
                    this.clearField = false;
                    if (this.enemyState[i][j] == Varr.STATE_WALK) {
                        int y2;
                        if (this.enemyPoisonCounter[i][j] == 0) {
                            int[] nArray = this.enemyY[i];
                            int n = j;
                            nArray[n] = nArray[n] + this.enemySpeedInc[this.enemyType[i][j]];
                        } else if (this.updateCounter % 2 == 0) {
                            int[] nArray = this.enemyY[i];
                            int n = j;
                            nArray[n] = nArray[n] + this.enemySpeedInc[this.enemyType[i][j]];
                        }
                        if (this.enemyType[i][j] == Varr.ENEMY_GHOST && this.enemyY[i][j] >= MainCanvas.HEIGHT >> 1 || this.enemyType[i][j] == Varr.ENEMY_CANNON && this.enemyY[i][j] >= MainCanvas.HEIGHT >> 1) {
                            this.enemyState[i][j] = Varr.STATE_WAIT;
                        } else if ((i == 2 || i == 4) && this.enemyY[i][j] >= MainCanvas.HEIGHT - (this.towerWallHeight >> 2) * 3) {
                            this.enemyState[i][j] = Varr.STATE_WAIT;
                        } else if (i == 3 && this.enemyY[i][j] >= MainCanvas.HEIGHT - this.towerWallHeight) {
                            this.enemyState[i][j] = Varr.STATE_WAIT;
                        } else if (this.enemyY[i][j] >= MainCanvas.HEIGHT - (this.towerWallHeight / 3 << 1) && i != 3) {
                            this.enemyState[i][j] = Varr.STATE_WAIT;
                        }
                        if (j >= this.MAX_ENEMIES - 1) continue;
                        if (this.enemyX[i][j + 1] == this.INT_NULL) {
                            this.swapEnemies(i, j, j + 1);
                            continue;
                        }
                        int y1 = this.enemyY[i][j] + (this.getEnemyHeight(this.enemyType[i][j]) >> 1);
                        if (y1 <= (y2 = this.enemyY[i][j + 1] + (this.getEnemyHeight(this.enemyType[i][j + 1]) >> 1))) continue;
                        this.swapEnemies(i, j, j + 1);
                        continue;
                    }
                    if (this.enemyState[i][j] == Varr.STATE_WAIT) {
                        int[] nArray = this.enemyAtackCounter[i];
                        int n = j;
                        nArray[n] = nArray[n] + 1;
                        if (this.enemyAtackCounter[i][j] <= 10) continue;
                        this.enemyAtackCounter[i][j] = 0;
                        this.enemyState[i][j] = Varr.STATE_ATTACK;
                        continue;
                    }
                    if (this.enemyState[i][j] == Varr.STATE_HIDE) {
                        int[] nArray = this.enemyAtackCounter[i];
                        int n = j;
                        nArray[n] = nArray[n] + 1;
                        if (this.enemyAtackCounter[i][j] <= 20) continue;
                        this.enemyAtackCounter[i][j] = 0;
                        this.enemyState[i][j] = Varr.STATE_WALK;
                        this.enemiesAreMoving = true;
                        continue;
                    }
                    if (this.enemyState[i][j] != Varr.STATE_ATTACK) continue;
                    ++attackersCount;
                    if (this.updateCounter % 3 == 0) {
                        int[] nArray = this.enemyAtackCounter[i];
                        int n = j;
                        nArray[n] = nArray[n] + 1;
                    }
                    if (this.enemyAtackCounter[i][j] <= 3) continue;
                    if (this.enemyType[i][j] == Varr.ENEMY_GHOST) {
                        this.addEnemyShot(this.enemyX[i][j], this.enemyY[i][j], this.enemyType[i][j]);
                        this.cannonExplosionCounter[i][j] = 0;
                    }
                    if (this.enemyType[i][j] == Varr.ENEMY_CANNON) {
                        if (this.updateCounter % 2 == 0) {
                            this.addEnemyShot(this.enemyX[i][j], this.enemyY[i][j], this.enemyType[i][j]);
                            this.cannonExplosionCounter[i][j] = 0;
                        }
                    } else {
                        int enemyDamage = 10;
                        int stage = Player.getStage();
                        int paramStage = stage - stage % 10;
                        if (paramStage > 29) {
                            enemyDamage = stage;
                            if (stage % 10 == 0) {
                                enemyDamage -= 4;
                            }
                            if (stage % 10 == 1) {
                                enemyDamage -= 3;
                            }
                            if (stage % 10 == 2) {
                                enemyDamage -= 2;
                            }
                            if (stage % 10 == 3) {
                                --enemyDamage;
                            }
                        }
                        if (this.enemyX[i][j] < 0 && this.enemyX[i][j] > MainCanvas.WIDTH) {
                            this.enemiesTotalCount = 100000000;
                        }
                        this.playerGetHit(enemyDamage);
                    }
                    this.enemyAtackCounter[i][j] = 0;
                    this.enemyState[i][j] = Varr.STATE_WAIT;
                    continue;
                }
                this.clearField = false;
                int[] nArray = this.enemyFrostCounter[i];
                int n = j;
                nArray[n] = nArray[n] - 1;
            }
            if (attackersCount > 1) {
                int internalMovingCounter = 0;
                int offset = MainCanvas.WIDTH / 100 + 1;
                for (int j = 0; j < this.MAX_ENEMIES; ++j) {
                    if (this.enemyState[i][j] == Varr.STATE_ATTACK && !this.enemyAlreadyMoved[i][j]) {
                        if (internalMovingCounter == 1) {
                            int[] nArray = this.enemyX[i];
                            int n = j;
                            nArray[n] = nArray[n] + offset;
                        } else if (internalMovingCounter == 2) {
                            int[] nArray = this.enemyX[i];
                            int n = j;
                            nArray[n] = nArray[n] - offset;
                        }
                        this.enemyAlreadyMoved[i][j] = true;
                    }
                    if (this.enemyState[i][j] != Varr.STATE_ATTACK) continue;
                    ++internalMovingCounter;
                }
            }
            boolean bl = false;
        }
        if (this.playerHealth <= 0) {
            this.playerHealth = 0;
            this.updateGameOver();
            if (this.gameOverTimer > 10) {
                mode = 7;
                ScreenGame.resetShowAnimation();
                MainCanvas.soundManager.Stop();
                MainCanvas.soundManager.Play(Sounds.SOUND_LOST, 1);
            }
        }
    }

    private void playerGetHit(int damage) {
        if (this.playerShield > 0) {
            this.playerShield -= damage;
        } else if (this.playerHealth > 0) {
            this.playerHealth -= damage;
        }
    }

    public void updateEnemyShots() {
        for (int i = 0; i < 100; ++i) {
            int paramStage;
            int stage;
            int enemyDamage;
            if (this.enemyShotX[i] == this.INT_NULL) continue;
            if (this.enemyShotType[i] == Varr.ENEMY_CANNON) {
                int n = i;
                this.enemyShotY[n] = this.enemyShotY[n] + Resources.resImgs[14].getHeight();
            } else {
                int n = i;
                this.enemyShotY[n] = this.enemyShotY[n] + (Resources.resImgs[14].getHeight() >> 1);
            }
            if (this.enemyShotY[i] <= MainCanvas.HEIGHT - (this.towerWallHeight >> 1)) continue;
            this.enemyShotX[i] = this.INT_NULL;
            if (this.playerHealth <= 0) continue;
            if (this.enemyShotType[i] == Varr.ENEMY_CANNON) {
                enemyDamage = 10;
                stage = Player.getStage();
                paramStage = stage - stage % 10;
                if (paramStage > 10) {
                    enemyDamage = stage;
                }
                if (paramStage > 29) {
                    enemyDamage = stage;
                    if (stage % 10 == 0) {
                        enemyDamage -= 4;
                    }
                    if (stage % 10 == 1) {
                        enemyDamage -= 3;
                    }
                    if (stage % 10 == 2) {
                        enemyDamage -= 2;
                    }
                    if (stage % 10 == 3) {
                        --enemyDamage;
                    }
                }
                this.playerGetHit(enemyDamage * 10);
            }
            if (this.enemyShotType[i] != Varr.ENEMY_GHOST) continue;
            enemyDamage = 10;
            stage = Player.getStage();
            paramStage = stage - stage % 10;
            if (paramStage > 10) {
                enemyDamage = stage;
            }
            if (paramStage > 29) {
                enemyDamage = stage;
                if (stage % 10 == 0) {
                    enemyDamage -= 4;
                }
                if (stage % 10 == 1) {
                    enemyDamage -= 3;
                }
                if (stage % 10 == 2) {
                    enemyDamage -= 2;
                }
                if (stage % 10 == 3) {
                    --enemyDamage;
                }
            }
            this.playerGetHit(enemyDamage);
        }
    }

    public void collideExplosion(int layer, int y) {
        for (int i = 0; i < this.MAX_ENEMIES; ++i) {
            int dy;
            if (this.enemyX[layer][i] == this.INT_NULL || (dy = Math.abs(this.enemyY[layer][i] - y)) >= this.getEnemyHeight(this.enemyType[layer][i]) + Resources.resSprs[33].getHeight() >> 1) continue;
            this.makeDmg(layer, i, 120 + 180 * Player.getSpellStatus(0));
            this.enemyFireCounter[layer][i] = 0;
        }
    }

    public void collidePoison(int layer, int y) {
        for (int i = 0; i < this.MAX_ENEMIES; ++i) {
            int dy;
            if (this.enemyX[layer][i] == this.INT_NULL || (dy = Math.abs(this.enemyY[layer][i] - y)) >= this.getEnemyHeight(this.enemyType[layer][i]) + Resources.resSprs[33].getHeight() >> 1) continue;
            this.enemyPoisonCounter[layer][i] = 60;
        }
    }

    public void collideLava(int layer, int y) {
        for (int i = 0; i < this.MAX_ENEMIES; ++i) {
            if (this.enemyX[layer][i] == this.INT_NULL || this.enemyY[layer][i] <= MainCanvas.HEIGHT - (this.lavaOffsetStep * Player.getSpellStatus(3) + this.lavaOffsetMin) || this.updateCounter % 10 != 0) continue;
            this.makeDmg(layer, i, 18 + 25 * Player.getSpellStatus(3));
        }
    }

    public void collideFrost(int layer, int y) {
        for (int i = 0; i < this.MAX_ENEMIES; ++i) {
            int dy;
            if (this.enemyX[layer][i] == this.INT_NULL || (dy = Math.abs(this.enemyY[layer][i] - y)) >= this.getEnemyHeight(this.enemyType[layer][i]) + Resources.resSprs[33].getHeight() >> 1) continue;
            this.enemyFrostCounter[layer][i] = 50 + 50 * Player.getSpellStatus(1);
            this.makeDmg(layer, i, 100 + 100 * Player.getSpellStatus(1));
        }
    }

    public void collideShotWithBoss(int ID) {
        int bossX1 = this.bossPositionX;
        int bossX2 = this.bossPositionX + this.bossWidth;
        int shotX1 = this.shotX[ID];
        int shotX2 = this.shotX[ID] + 5;
        int bossY1 = this.bossPositionY;
        int bossY2 = this.bossPositionY + this.bossHeight;
        int shotY1 = this.shotY[ID];
        int shotY2 = this.shotY[ID] + 5;
        if (shotX1 >= bossX1 && shotX1 <= bossX2 && shotY1 >= bossY1 && shotY1 <= bossY2) {
            this.removeShot(ID);
            if (this.shotCrit[this.actualShot] == 0) {
                this.makeBossDmg(this.playerBaseDMG);
            } else {
                this.addBossCrit();
                this.makeBossDmg(this.playerBaseDMG << 1);
            }
        }
        if (shotX2 >= bossX1 && shotX2 <= bossX2 && shotY2 >= bossY1 && shotY2 <= bossY2) {
            this.removeShot(ID);
            if (this.shotCrit[this.actualShot] == 0) {
                this.makeBossDmg(this.playerBaseDMG);
            } else {
                this.addBossCrit();
                this.makeBossDmg(this.playerBaseDMG << 1);
            }
        }
    }

    public void collideShot(int ID) {
        int dy;
        int dx;
        int i;
        int layer = this.getShotLayer(this.shotX[ID]);
        if (layer != this.INT_NULL) {
            for (i = 0; i < this.MAX_ENEMIES; ++i) {
                if (this.enemyX[layer][i] == this.INT_NULL) continue;
                dx = Math.abs(this.shotX[ID] - this.enemyX[layer][i]);
                dy = Math.abs(this.shotY[ID] - this.enemyY[layer][i]);
                if (dx > this.enemyW + 5 >> 1 || dy > this.enemyH + 5 >> 1) continue;
                int thisIsShotFromTower = this.shotFromTower[ID];
                this.removeShot(ID);
                if (this.shotCrit[this.actualShot] == 0) {
                    if (thisIsShotFromTower > 0) {
                        this.makeDmg(layer, i, this.playerBaseDMG / 10 * 2);
                    } else {
                        this.makeDmg(layer, i, this.playerBaseDMG);
                    }
                } else if (thisIsShotFromTower > 0) {
                    this.addCrit(layer, i);
                    this.makeDmg(layer, i, (this.playerBaseDMG << 1) / 10 * 2);
                } else {
                    this.addCrit(layer, i);
                    this.makeDmg(layer, i, this.playerBaseDMG << 1);
                }
                int knockback = Player.getStatValue(4);
                if (tomeOfPowerInUsage) {
                    knockback += 5;
                }
                if (++knockback > 0 && this.enemyFrostCounter[layer][i] == 0 && this.enemyType[layer][i] != Varr.ENEMY_CANNON) {
                    int[] nArray = this.enemyY[layer];
                    int n = i;
                    nArray[n] = nArray[n] - knockback * 2;
                    this.enemyState[layer][i] = Varr.STATE_WALK;
                    this.enemyAtackCounter[layer][i] = 0;
                }
                i = this.MAX_ENEMIES;
            }
        }
        if ((layer = this.getShotLayer(this.towerOneShotX[ID])) != this.INT_NULL) {
            for (i = 0; i < this.MAX_ENEMIES; ++i) {
                if (this.enemyX[layer][i] == this.INT_NULL) continue;
                dx = Math.abs(this.towerOneShotX[ID] - this.enemyX[layer][i]);
                dy = Math.abs(this.towerOneShotY[ID] - this.enemyY[layer][i]);
                if (dx > this.enemyW + 5 >> 1 || dy > this.enemyH + 5 >> 1) continue;
                this.removeShot(ID);
                if (this.shotCrit[this.actualShot] == 0) {
                    this.makeDmg(layer, i, this.playerBaseDMG);
                } else {
                    this.addCrit(layer, i);
                    this.makeDmg(layer, i, this.playerBaseDMG << 1);
                }
                if (Player.getStatValue(4) > 0) {
                    int[] nArray = this.enemyY[layer];
                    int n = i;
                    nArray[n] = nArray[n] - 4;
                    this.enemyState[layer][i] = Varr.STATE_WALK;
                    this.enemyAtackCounter[layer][i] = 0;
                }
                i = this.MAX_ENEMIES;
            }
        }
        if ((layer = this.getShotLayer(this.towerTwoShotX[ID])) != this.INT_NULL) {
            for (i = 0; i < this.MAX_ENEMIES; ++i) {
                if (this.enemyX[layer][i] == this.INT_NULL) continue;
                dx = Math.abs(this.towerTwoShotX[ID] - this.enemyX[layer][i]);
                dy = Math.abs(this.towerTwoShotY[ID] - this.enemyY[layer][i]);
                if (dx > this.enemyW + 5 >> 1 || dy > this.enemyH + 5 >> 1) continue;
                this.removeShot(ID);
                if (this.shotCrit[this.actualShot] == 0) {
                    this.makeDmg(layer, i, this.playerBaseDMG);
                } else {
                    this.addCrit(layer, i);
                    this.makeDmg(layer, i, this.playerBaseDMG << 1);
                }
                if (Player.getStatValue(4) > 0) {
                    int[] nArray = this.enemyY[layer];
                    int n = i;
                    nArray[n] = nArray[n] - 4;
                    this.enemyState[layer][i] = Varr.STATE_WALK;
                    this.enemyAtackCounter[layer][i] = 0;
                }
                i = this.MAX_ENEMIES;
            }
        }
    }

    public void collideBossShot() {
        int towerHeight = this.towerWallHeight;
        if (this.bossShotPositionY > MainCanvas.HEIGHT - towerHeight && this.playerHealth > 0) {
            this.playerGetHit(100);
            this.bossShotPositionY = this.INT_NULL;
            this.shakeBackground = true;
        }
    }

    public void makeDmg(int layer, int ID, int dmg) {
        if (this.enemyHealth[layer][ID] > 0) {
            if (tomeOfPowerInUsage) {
                dmg += dmg;
            }
            int[] nArray = this.enemyHealth[layer];
            int n = ID;
            nArray[n] = nArray[n] - dmg;
            if (this.enemyHealth[layer][ID] <= 0) {
                ++this.enemiesKilled;
                this.addCorpse(layer, ID, 0);
                this.removeEnemy(layer, ID);
                if (this.bossIsReadyToGo) {
                    --this.minionsCount;
                }
                if (this.enemyType[layer][ID] == Varr.ENEMY_BAT) {
                    ++this.thisStageCash;
                }
                if (this.enemyType[layer][ID] == Varr.ENEMY_ORC) {
                    this.thisStageCash += 2;
                }
                if (this.enemyType[layer][ID] == Varr.ENEMY_GHOST) {
                    this.thisStageCash += 2;
                }
                if (this.enemyType[layer][ID] == Varr.ENEMY_GOLEM) {
                    this.thisStageCash += 4;
                }
                if (this.enemyType[layer][ID] == Varr.ENEMY_CANNON) {
                    this.thisStageCash += 50;
                }
            }
        }
    }

    public void makeBossDmg(int dmg) {
        if (this.bossState != Varr.STATE_HIDE && this.bossState != Varr.STATE_SHOW) {
            this.bossHealth -= (long)dmg;
            if (this.bossHealth <= 0L) {
                ++this.enemiesKilled;
                this.addBossCorpse();
                this.removeBoss();
                if (!this.bossCashAlreadyAdded) {
                    this.thisStageCash += 500;
                    this.bossCashAlreadyAdded = true;
                }
            }
        }
    }

    public void animateTable() {
        if (iTableAnimation != 0) {
            if (iTableAnimation < 4) {
                --iTableAnimation;
            }
            iTableAnimation -= iTableAnimation >> 2;
        }
    }

    public void animateHide() {
        if (hideScreen && Math.abs(iHide <<= 1) > MainCanvas.WIDTH << 1) {
            if (this.nextMode == 0) {
                mode = 0;
            } else if (this.nextMode == 2) {
                X.mainCanvas.setActiveScreen(1, null);
                MainCanvas.gameMusic = false;
                MainCanvas.soundManager.Stop();
                MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
            } else if (this.nextMode == 5) {
                ScreenShop.fromMenu = false;
                MainCanvas.gameMusic = false;
                X.mainCanvas.setActiveScreen(5, null);
            }
        }
    }

    public void changeModeToShop() {
        ScreenShop.fromMenu = false;
        MainCanvas.gameMusic = false;
        X.mainCanvas.setActiveScreen(5, null);
    }

    public void autoShot() {
        ++this.shotCounter;
        int ag = Player.getStatValue(2);
        if (ag > 9) {
            ag = 9;
        }
        if (this.shotCounter == 10 - ag / 2) {
            if (this.additionalTowerLvl > 0) {
                boolean firstTowerShotWasMade = false;
                boolean secondTowerShotWasMade = false;
                for (int i = 0; i < this.MAX_LAYERS; ++i) {
                    for (int j = 0; j < this.enemyY[i].length; ++j) {
                        if (this.enemyY[i][j] == this.INT_NULL || this.enemyY[i][j] <= MainCanvas.HEIGHT / 3) continue;
                        int dx = Math.abs(10 - this.enemyX[i][j]);
                        int dy = Math.abs(MainCanvas.HEIGHT - 30 - this.enemyY[i][j]);
                        int addTowerAimingAngle = this.atan(dx, dy) - 90;
                        if (!firstTowerShotWasMade && this.enemyX[i][j] > 0 && this.enemyX[i][j] < MainCanvas.WIDTH) {
                            this.makeShot(addTowerAimingAngle, 1);
                            firstTowerShotWasMade = true;
                        }
                        if (this.additionalTowerLvl <= 1) continue;
                        dx = Math.abs(MainCanvas.WIDTH - 10 - this.enemyX[i][j]);
                        dy = Math.abs(MainCanvas.HEIGHT - 30 - this.enemyY[i][j]);
                        addTowerAimingAngle = Math.abs(this.atan(dx, dy) - 270);
                        if (secondTowerShotWasMade || this.enemyX[i][j] <= 0 || this.enemyX[i][j] >= MainCanvas.WIDTH) continue;
                        this.makeShot(addTowerAimingAngle, 2);
                        secondTowerShotWasMade = true;
                    }
                }
            }
            if (Player.getEquipedStaff() == 11) {
                if (Player.getInventoryItemStatus(5) > 0 && Player.getInventoryItemStatus(5) < 5) {
                    this.makeShot(this.aimingAngle - 3, 0);
                    this.makeShot(this.aimingAngle + 3, 0);
                } else {
                    this.makeShot(this.aimingAngle - 6, 0);
                    this.makeShot(this.aimingAngle, 0);
                    this.makeShot(this.aimingAngle + 6, 0);
                }
            } else {
                this.makeShot(this.aimingAngle, 0);
            }
            this.shotCounter = 0;
        }
    }

    public int getShotLayer(int x) {
        int layer = (x - this.LEFT_OFFSET) / this.COLLISION_LAYER_W;
        if (layer >= 0 && layer < 7) {
            return layer;
        }
        return this.INT_NULL;
    }

    public boolean isShotActive(int shot) {
        if (this.shotY[shot] < 0 || this.shotY[shot] > MainCanvas.HEIGHT) {
            return false;
        }
        return this.shotX[shot] >= 0 && this.shotX[shot] <= MainCanvas.WIDTH;
    }

    public boolean isTowerOneShotActive(int shot) {
        if (this.towerOneShotY[shot] < 0 || this.towerOneShotY[shot] > MainCanvas.HEIGHT) {
            return false;
        }
        return this.towerOneShotX[shot] >= 0 && this.towerOneShotX[shot] <= MainCanvas.WIDTH;
    }

    public boolean isTowerTwoShotActive(int shot) {
        if (this.towerTwoShotY[shot] < 0 || this.towerTwoShotY[shot] > MainCanvas.HEIGHT) {
            return false;
        }
        return this.towerTwoShotX[shot] >= 0 && this.towerTwoShotX[shot] <= MainCanvas.WIDTH;
    }

    public static void modeMenu(int pause) {
        ScreenGame.resetShowAnimation();
        tutorialGame = pause;
        mode = 1;
    }

    public void makeShot(int angle, int tower) {
        if (this.playerHealth > 0) {
            for (int i = 0; i < this.MAX_SHOTS; ++i) {
                if (this.shotRadius[i] != this.INT_NULL) continue;
                this.shotRadius[i] = Common.STAFF_RADIUS - 10;
                this.shotAngle[i] = angle;
                this.shotFromTower[i] = tower;
                i = this.MAX_SHOTS;
            }
        }
    }

    public void makeTowerOneShot(int angle) {
        for (int i = 0; i < this.MAX_SHOTS; ++i) {
            if (this.towerOneShotRadius[i] != this.INT_NULL) continue;
            this.towerOneShotRadius[i] = Common.STAFF_RADIUS - 10;
            this.towerOneShotAngle[i] = angle;
            i = this.MAX_SHOTS;
        }
    }

    public void makeTowerTwoShot(int angle) {
        for (int i = 0; i < this.MAX_SHOTS; ++i) {
            if (this.towerTwoShotRadius[i] != this.INT_NULL) continue;
            this.towerTwoShotRadius[i] = Common.STAFF_RADIUS - 10;
            this.towerTwoShotAngle[i] = angle;
            i = this.MAX_SHOTS;
        }
    }

    public void enterMenuItem(int selected) {
        switch (selected) {
            case 0: {
                if (this.mainCanvas.tutorialGame == 8 && !this.paintTutorial) {
                    mode = 8;
                    if (mode == 6) {
                        mode = 0;
                    }
                    this.mainCanvas.repaint();
                    break;
                }
                mode = 0;
                break;
            }
            case 1: {
                Common.changeMusic(Common.SND_GAME);
                break;
            }
            case 2: {
                hideScreen = true;
                iHide = -1;
                this.nextMode = 2;
            }
        }
    }

    public void regenerateMana() {
        if (this.updateCounter % 20 == 0 && this.playerMana < Player.getStatValue(5)) {
            ++this.playerMana;
        }
    }

    public void castSpell(int spell) {
        switch (spell) {
            case 0: {
                this.castFire(10 + 5 * Player.getSpellStatus(0) + this.spellsPassiveAdditionFromConsumable);
                break;
            }
            case 1: {
                this.castFrost(10 + 5 * Player.getSpellStatus(1) + this.spellsPassiveAdditionFromConsumable);
                break;
            }
            case 2: {
                this.castPoison(10 + 5 * Player.getSpellStatus(2) + this.spellsPassiveAdditionFromConsumable);
            }
        }
    }

    public void castFire(int cnt) {
        if (this.spellCounter[0] == 0 && Player.getSpellStatus(0) > 0 && ShopItems.LOCKED[12] <= Player.getStage() && this.playerMana >= Player.getManaCost(0)) {
            this.playerMana -= Player.getManaCost(0);
            this.spellCounter[0] = this.WAVE_DELAY + Player.getSpellStatus(0) * 15;
            for (int i = 0; i < cnt; ++i) {
                for (int j = 0; j < this.MAX_METEORS; ++j) {
                    if (this.meteorX[j] != this.INT_NULL) continue;
                    this.meteorY[j] = -(i + 1) * (Resources.resSprs[33].getHeight() >> 1);
                    this.meteorTarget[j] = MainCanvas.HEIGHT / 3 + RandomNum.getRandomUInt(MainCanvas.HEIGHT - Resources.resSprs[33].getHeight() - MainCanvas.HEIGHT / 3 - (this.towerWallHeight >> 1));
                    this.meteorX[j] = RandomNum.getRandomUInt(this.MAX_LAYERS);
                    j = this.MAX_METEORS;
                }
            }
        } else if (this.spellCounter[0] > 0) {
            this.vecNotEnough = Common.separateTextToLines(Varr.strSIC, MainCanvas.WIDTH, Resources.resGFonts[0]);
            this.notEnoughTimer = 40;
        } else if (this.playerMana < Player.getManaCost(0)) {
            this.vecNotEnough = Common.separateTextToLines(Varr.strNEM, MainCanvas.WIDTH, Resources.resGFonts[0]);
            this.notEnoughTimer = 40;
        }
    }

    public void castPoison(int cnt) {
        if (this.spellCounter[2] == 0 && Player.getSpellStatus(2) > 0 && ShopItems.LOCKED[14] <= Player.getStage() && this.playerMana >= Player.getManaCost(2)) {
            this.playerMana -= Player.getManaCost(2);
            this.spellCounter[2] = this.WAVE_DELAY + Player.getSpellStatus(2) * 15;
            for (int i = 0; i < cnt; ++i) {
                for (int j = 0; j < this.MAX_POISONS; ++j) {
                    if (this.poisonX[j] != this.INT_NULL) continue;
                    this.poisonY[j] = -(i + 1) * (Resources.resSprs[36].getHeight() >> 1);
                    this.poisonTarget[j] = MainCanvas.HEIGHT / 3 + RandomNum.getRandomUInt(MainCanvas.HEIGHT - Resources.resSprs[36].getHeight() - MainCanvas.HEIGHT / 3 - (this.towerWallHeight >> 1));
                    this.poisonX[j] = RandomNum.getRandomUInt(this.MAX_LAYERS);
                    j = this.MAX_POISONS;
                }
            }
        } else if (this.spellCounter[2] > 0) {
            this.vecNotEnough = Common.separateTextToLines(Varr.strSIC, MainCanvas.WIDTH, Resources.resGFonts[0]);
            this.notEnoughTimer = 40;
        } else if (this.playerMana < Player.getManaCost(2)) {
            this.vecNotEnough = Common.separateTextToLines(Varr.strNEM, MainCanvas.WIDTH, Resources.resGFonts[0]);
            this.notEnoughTimer = 40;
        }
    }

    public void castFrost(int cnt) {
        if (this.spellCounter[1] == 0 && Player.getSpellStatus(1) > 0 && ShopItems.LOCKED[13] <= Player.getStage() && this.playerMana >= Player.getManaCost(1)) {
            this.playerMana -= Player.getManaCost(1);
            this.spellCounter[1] = this.WAVE_DELAY + Player.getSpellStatus(1) * 15;
            for (int i = 0; i < cnt; ++i) {
                for (int j = 0; j < this.MAX_FROST; ++j) {
                    if (this.frostX[j] != this.INT_NULL) continue;
                    this.frostY[j] = -(i + 1) * (Resources.resSprs[35].getHeight() >> 1);
                    this.frostCounter[j] = i * 5;
                    this.meteorTarget[j] = MainCanvas.HEIGHT / 3 + RandomNum.getRandomUInt(MainCanvas.HEIGHT - Resources.resSprs[35].getHeight() - MainCanvas.HEIGHT / 3 - (this.towerWallHeight >> 1));
                    this.frostX[j] = RandomNum.getRandomUInt(this.MAX_LAYERS);
                    j = this.MAX_METEORS;
                }
            }
        } else if (this.spellCounter[1] > 0) {
            this.vecNotEnough = Common.separateTextToLines(Varr.strSIC, MainCanvas.WIDTH, Resources.resGFonts[0]);
            this.notEnoughTimer = 40;
        } else if (this.playerMana < Player.getManaCost(1)) {
            this.vecNotEnough = Common.separateTextToLines(Varr.strNEM, MainCanvas.WIDTH, Resources.resGFonts[0]);
            this.notEnoughTimer = 40;
        }
    }

    public void paint(Graphics g) {
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        switch (mode) {
            case 0: {
                this.paintGame(g);
                if (this.startCounter < 40) {
                    this.paintStartStage(g);
                }
                if (this.notEnoughTimer <= 0) break;
                this.paintNotEnought(g);
                break;
            }
            case 1: {
                this.paintGame(g);
                this.paintMenu(g);
                break;
            }
            case 3: {
                this.paintGame(g);
                this.paintWin(g);
                break;
            }
            case 11: {
                this.paintGame(g);
                if (this.stageBonusFail) {
                    this.paintStageBonusLost(g);
                    break;
                }
                this.paintStageBonus(g);
                break;
            }
            case 7: {
                mode = 4;
                break;
            }
            case 4: {
                this.paintGame(g);
                this.paintGameOver(g);
                this.lastMode = 4;
                break;
            }
            case 6: {
                this.paintGame(g);
                this.paintHint(g);
                this.paintTutorial = true;
                break;
            }
            case 9: {
                this.paintGame(g);
                this.paintBossDrop(g);
                break;
            }
            case 8: {
                this.paintTutorial = true;
                this.paintGame(g);
                this.paintHint(g);
                this.paintTutorial = true;
                break;
            }
            case 10: {
                this.paintGame(g);
                this.paintUnlock(g);
            }
        }
    }

    public void paintGame(Graphics g) {
        if (Player.getSpellStatus(3) > 0) {
            this.backgroundPositionY = -(this.lavaOffsetMin + this.lavaOffsetStep * Player.getSpellStatus(3));
        }
        if (Resources.resImgs[2] != null) {
            g.setColor(16270386);
            g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
            g.drawImage(Resources.resImgs[2], this.backgroundPositionX, this.backgroundPositionY, 17);
        } else {
            g.setColor(6382197);
            g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        }
        if (Resources.resSprs[72] != null && Player.getSpellStatus(3) > 0) {
            this.lavaCounter = this.lavaCounter == 4 ? 0 : ++this.lavaCounter;
            Sprite lavaAnimSprLarge = Resources.resSprs[72];
            if (this.lavaCounter < 4) {
                lavaAnimSprLarge.setPosition(this.bblX, this.bblY);
                lavaAnimSprLarge.setFrame(this.lavaCounter);
                lavaAnimSprLarge.paint(g);
            } else {
                this.bblX = RandomNum.getRandomUInt(MainCanvas.WIDTH);
                this.bblY = RandomNum.getRandomUInt(MainCanvas.HEIGHT - this.lavaOffsetMin);
                while (this.bblY <= MainCanvas.HEIGHT - this.lavaOffsetStep * (Player.getSpellStatus(3) + 1)) {
                    this.bblY = RandomNum.getRandomUInt(MainCanvas.HEIGHT - this.lavaOffsetMin);
                }
            }
        }
        if (this.bossIsReadyToGo) {
            this.paintBoss(g);
            this.paintBossCorpse(g);
        }
        this.paintEnemies(g);
        this.paintCorpses(g);
        this.paintEnemyShots(g);
        this.paintShot(g);
        this.paintCrit(g);
        this.paintAim(g);
        this.paintMeteors(g);
        this.paintFrost(g);
        this.paintPoison(g);
        this.paintWall(g);
        this.paintLevelProgress(g);
        this.paintStatusTable(g);
        if (this.bossIsReadyToGo && this.bossAlertTimer < 40) {
            this.paintBossAlert(g);
        }
        if (mode == 0) {
            this.paintSpells(g);
        }
    }

    public void paintAdditionalTowers(Graphics g) {
        if (this.additionalTowerLvl > 0) {
            g.drawImage(Resources.resImgs[29], Resources.resImgs[29].getWidth() >> 1, MainCanvas.HEIGHT - (Resources.resImgs[29].getHeight() + Resources.resImgs[29].getHeight() / 4), 20);
        }
        if (this.additionalTowerLvl > 1) {
            g.drawImage(Resources.resImgs[29], MainCanvas.WIDTH - (Resources.resImgs[29].getWidth() >> 1), MainCanvas.HEIGHT - (Resources.resImgs[29].getHeight() + Resources.resImgs[29].getHeight() / 4), 24);
        }
    }

    public void paintMenu(Graphics g) {
        int y = MainCanvas.HEIGHT - Common.getTableH(0) >> 1;
        this.paintGame(g);
        this.paintMenuBg(g);
        if (hideScreen) {
            g.translate(iHide, 0);
        }
        Common.paintAnimatedMenuTable(y, 1, iTableAnimation, g);
        if (iTableAnimation != 0) {
            g.setClip((MainCanvas.WIDTH >> 1) - (TABLE_ANIMATION - iTableAnimation), 0, TABLE_ANIMATION - iTableAnimation << 1, MainCanvas.HEIGHT);
        }
        this.paintMenuIcons(g);
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        if (hideScreen) {
            g.translate(0, 0);
        }
        Common.paintFNLeft(0, g);
        Common.paintFNRight(2, g);
    }

    public void paintMenuBg(Graphics g) {
        int tileW = Resources.resImgs[6].getWidth();
        for (int i = 0; i < MainCanvas.WIDTH / tileW + 1; ++i) {
            for (int j = 0; j < MainCanvas.HEIGHT / tileW + 1; ++j) {
                g.drawImage(Resources.resImgs[6], i * tileW, j * tileW, 0);
            }
        }
    }

    public void paintMenuIcons(Graphics g) {
        int startX;
        int y = (MainCanvas.HEIGHT >> 1) - (Resources.resSprs[79].getHeight() >> 1) - Resources.resSprs[79].getHeight() / 7;
        int x = startX = Common.animatedTableLeftBorder();
        int selectorOffset = Resources.resSprs[91].getWidth() - Resources.resSprs[42].getWidth() >> 1;
        for (int i = 0; i < 3; ++i) {
            x = startX + (i * Resources.resSprs[42].getWidth() + Resources.resSprs[42].getWidth());
            x += i * (Resources.resSprs[42].getWidth() >> 1);
            if (this.menuSelected == i && this.menuMode == 0) {
                Resources.resSprs[91].setFrame(this.selectorAnimation);
                Resources.resSprs[91].setPosition(x - selectorOffset + 1, y - selectorOffset + 1);
                Resources.resSprs[91].paint(g);
            }
            Resources.resSprs[42].setFrame(i);
            Resources.resSprs[42].setPosition(x, y);
            Resources.resSprs[42].paint(g);
            if (i != 1) continue;
            Resources.resSprs[82].setFrame(MainCanvas.music ? 0 : 1);
            Resources.resSprs[82].setPosition(x + Resources.resSprs[42].getWidth() - Resources.resSprs[82].getWidth(), y + Resources.resSprs[42].getHeight() - Resources.resSprs[82].getHeight());
            Resources.resSprs[82].paint(g);
        }
        if (this.updateCounter % 2 == 0) {
            ++this.selectorAnimation;
        }
        if (this.selectorAnimation > 3) {
            this.selectorAnimation = 0;
        }
    }

    public void paintHint(Graphics g) {
        if (Player.getStage() == 4) {
            Common.paintAnimatedMenuTableMentor(MainCanvas.HEIGHT - Common.getTableH(1) >> 1, 2, 0, g);
        } else {
            Common.paintAnimatedMenuTableMentor(MainCanvas.HEIGHT - Common.getTableH(1) >> 1, 3, 0, g);
        }
        int y = MainCanvas.HEIGHT - Common.getTableH(1) >> 1;
        if (this.showHintItemId != this.INT_NULL) {
            Sprite itemIcon = Resources.resSprs[76];
            if (this.showHintItemId > 5 && this.showHintItemId < 12) {
                itemIcon = Resources.resSprs[77];
            }
            if (this.showHintItemId > 11 && this.showHintItemId < 18) {
                itemIcon = Resources.resSprs[78];
            }
            if (this.showHintItemId > 17 && this.showHintItemId < 24) {
                itemIcon = Resources.resSprs[79];
            }
            if (this.showHintItemId > 23) {
                itemIcon = Resources.resSprs[80];
            }
            Resources.resGFonts[0].drawString(g, this.spec_offer.toCharArray(), MainCanvas.WIDTH >> 1, y, 17);
            y = y + Resources.resGFonts[0].getHeight() + (Resources.resGFonts[0].getHeight() >> 1);
            g.drawImage(Resources.resImgs[24], MainCanvas.WIDTH >> 1, y, 17);
            if (!MainCanvas.limitedOffer) {
                itemIcon.setFrame(ShopItems.SPR_FRAME[this.showHintItemId]);
                itemIcon.setPosition((MainCanvas.WIDTH >> 1) - itemIcon.getWidth(), y + itemIcon.getHeight());
                itemIcon.paint(g);
                Resources.resGFonts[0].drawString(g, (this.specialOfferQuantity + " ").toCharArray(), (MainCanvas.WIDTH >> 1) - itemIcon.getWidth(), y + itemIcon.getHeight() + (itemIcon.getHeight() >> 1), 10);
                Resources.resGFonts[0].drawString(g, ("   " + this.specialOfferOldPrice).toCharArray(), MainCanvas.WIDTH >> 1, y + itemIcon.getHeight() + (itemIcon.getHeight() >> 1), 36);
                g.drawImage(Resources.resImgs[3], (MainCanvas.WIDTH >> 1) + (Resources.resImgs[3].getWidth() >> 1), y + itemIcon.getHeight() + (itemIcon.getHeight() >> 1) - 3, 36);
                g.setColor(16770981);
                g.fillRect((MainCanvas.WIDTH >> 1) + (Resources.resImgs[3].getWidth() >> 1), y + itemIcon.getHeight() + (itemIcon.getHeight() >> 1) - (Resources.resGFonts[0].getHeight() >> 1), 50, 1);
                Resources.resGFonts[0].drawString(g, ("   " + this.specialOfferNewPrice).toCharArray(), MainCanvas.WIDTH >> 1, y + itemIcon.getHeight() + (itemIcon.getHeight() >> 1), 20);
                g.drawImage(Resources.resImgs[3], (MainCanvas.WIDTH >> 1) + (Resources.resImgs[3].getWidth() >> 1), y + itemIcon.getHeight() + (itemIcon.getHeight() >> 1) + 5, 20);
                y = y + Resources.resGFonts[0].getHeight() + (Resources.resGFonts[0].getHeight() >> 1);
                y = y + Resources.resGFonts[0].getHeight() + (Resources.resGFonts[0].getHeight() >> 1);
                if (MainCanvas.HEIGHT < 790) {
                    y = y + Resources.resGFonts[0].getHeight() + (Resources.resGFonts[0].getHeight() >> 1);
                }
                Resources.resGFonts[0].drawString(g, (this.save + " -" + this.specialOfferSaving + " " + this.coins).toCharArray(), MainCanvas.WIDTH >> 1, y, 17);
            } else if (MainCanvas.limitedOffer) {
                itemIcon.setFrame(ShopItems.SPR_FRAME[this.showHintItemId]);
                itemIcon.setPosition(Common.animatedTableLeftBorder() + itemIcon.getWidth(), y + itemIcon.getHeight());
                itemIcon.paint(g);
                Common.drawSeparatedText(g, Common.animatedTableLeftBorder() + itemIcon.getWidth() * 3, y + itemIcon.getHeight(), this.vecHint, Resources.resGFonts[0]);
                if (this.showHintItemId == 24) {
                    Resources.resGFonts[0].drawString(g, ("+ 1000 " + this.free).toCharArray(), Common.animatedTableLeftBorder() + itemIcon.getWidth() * 2, y + itemIcon.getHeight() * 3, 6);
                }
                if (this.showHintItemId == 23) {
                    Resources.resGFonts[0].drawString(g, ("+ 2X " + this.free).toCharArray(), Common.animatedTableLeftBorder() + itemIcon.getWidth() * 2, y + itemIcon.getHeight() * 3, 6);
                }
            }
            if (MainCanvas.specialOffer > 0) {
                int tableEnding = MainCanvas.HEIGHT - (MainCanvas.HEIGHT - Common.getTableH(3) >> 1);
                tableEnding += 3;
                this.chrCash = (Player.getCash() + " ").toCharArray();
                if (ShopItems.REALCASH[this.showHintItemId] == 0) {
                    Resources.resGFonts[0].drawString(g, this.chrCash, MainCanvas.WIDTH >> 1, tableEnding - Resources.resImgs[3].getHeight() - Resources.resImgs[3].getHeight(), 3);
                    int stringW = Resources.resGFonts[0].stringWidth(this.chrCash);
                    g.drawImage(Resources.resImgs[3], (MainCanvas.WIDTH >> 1) - (stringW >> 1) - (Resources.resImgs[3].getWidth() << 1), tableEnding - Resources.resImgs[3].getHeight() - Resources.resImgs[3].getHeight(), 6);
                }
            }
        } else {
            Common.drawCenteredText(g, this.vectorX, this.vectorY, this.vectorW, this.vecHint, Resources.resGFonts[0]);
        }
        Common.paintFNLeft(0, g);
        if (MainCanvas.limitedOffer || MainCanvas.specialOffer > 0) {
            Common.paintFNRight(1, g);
        }
        if (Player.getStage() == 4) {
            int animationOffset = this.tutorialAnimation;
            if (this.tutorialAnimation == 4) {
                animationOffset = 3;
            }
            if (this.tutorialAnimation == 5) {
                animationOffset = 2;
            }
            if (this.tutorialAnimation == 6) {
                animationOffset = 1;
            }
            if (this.tutorialAnimation == 7) {
                animationOffset = 0;
            }
            Resources.resSprs[90].setPosition((MainCanvas.WIDTH >> 1) - Resources.resSprs[90].getWidth() - Resources.resSprs[90].getWidth() / 4, (Resources.resSprs[90].getHeight() >> 1) + animationOffset);
            Resources.resSprs[90].setFrame(0);
            Resources.resSprs[90].paint(g);
            int oneBarWidth = Resources.resImgs[20].getWidth();
            int firstBarX = MainCanvas.WIDTH - oneBarWidth * 5 >> 1;
            Resources.resSprs[90].setPosition(firstBarX + Resources.resSprs[90].getHeight() / 3, (Resources.resSprs[90].getHeight() >> 1) + animationOffset);
            Resources.resSprs[90].setFrame(0);
            Resources.resSprs[90].paint(g);
            this.tutorialAnimation = this.tutorialAnimation < 7 ? ++this.tutorialAnimation : 0;
        }
    }

    public void paintWin(Graphics g) {
        int y = MainCanvas.HEIGHT - Common.getTableH(1) >> 1;
        int tab = Common.animatedTableLeftBorder() + Common.getTableW() / 8;
        int secondTab = Common.animatedTableLeftBorder() + Common.getTableW() / 3 * 2;
        this.paintGame(g);
        this.paintMenuBg(g);
        if (hideScreen) {
            g.translate(iHide, 0);
        }
        Common.paintAnimatedMenuTable(y, 2, iTableAnimation, g);
        Resources.resGFonts[0].drawString(g, this.chrStageComplete, MainCanvas.WIDTH >> 1, y += Resources.resGFonts[0].getHeight(), 17);
        y = y + Resources.resGFonts[0].getHeight() + (Resources.resGFonts[0].getHeight() >> 1);
        g.drawImage(Resources.resImgs[24], MainCanvas.WIDTH >> 1, y, 17);
        Resources.resGFonts[2].drawString(g, this.chrEnemiesKilled, tab, y += Resources.resGFonts[2].getHeight(), 6);
        Resources.resGFonts[2].drawString(g, String.valueOf(this.enemiesKilled).toCharArray(), secondTab, y, 6);
        g.drawImage(Resources.resImgs[24], MainCanvas.WIDTH >> 1, y += Resources.resGFonts[2].getHeight(), 17);
        g.drawImage(Resources.resImgs[24], MainCanvas.WIDTH >> 1, y += Resources.resGFonts[2].getHeight(), 17);
        int percentage = (int)((double)(2 * Player.getStage()) * 1.99) * 2;
        int plus4percent = (int)((double)(this.thisStageCash * 10000 / 100 * percentage / 10000) * 1.99) * 2 + 8;
        int thisStageCashIncFourPercent = this.thisStageCash + plus4percent;
        Resources.resGFonts[2].drawString(g, this.chrCoins, tab, y += Resources.resGFonts[2].getHeight(), 6);
        Resources.resGFonts[4].drawString(g, ("@ " + String.valueOf(thisStageCashIncFourPercent)).toCharArray(), secondTab, y, 6);
        g.drawImage(Resources.resImgs[24], MainCanvas.WIDTH >> 1, y += Resources.resGFonts[2].getHeight(), 17);
        if (hideScreen) {
            g.translate(0, 0);
        }
        Common.paintFNLeft(0, g);
    }

    public void paintStageBonus(Graphics g) {
        int y = MainCanvas.HEIGHT - Common.getTableH(2) >> 1;
        int tab = Common.animatedTableLeftBorder() + Common.getTableW() / 8;
        int secondTab = Common.animatedTableLeftBorder() + Common.getTableW() / 3 * 2 - 10;
        Sprite yesNoAnim = Resources.resSprs[112];
        this.paintGame(g);
        this.paintMenuBg(g);
        if (hideScreen) {
            g.translate(iHide, 0);
        }
        Common.paintAnimatedMenuTable(y, 3, iTableAnimation, g);
        if (this.updateCounter % 2 == 0) {
            this.yesAnimation = this.yesAnimation < 3 ? ++this.yesAnimation : 3;
        }
        Resources.resGFonts[0].drawString(g, this.chrStageBonus.toCharArray(), MainCanvas.WIDTH >> 1, y += Resources.resGFonts[0].getHeight(), 17);
        y = y + Resources.resGFonts[0].getHeight() + (Resources.resGFonts[0].getHeight() >> 1);
        g.drawImage(Resources.resImgs[24], MainCanvas.WIDTH >> 1, y, 17);
        if (this.stageBonus[0] == 0) {
            Resources.resGFonts[2].drawString(g, "".toCharArray(), tab, y += Resources.resGFonts[2].getHeight(), 6);
            Resources.resGFonts[4].drawString(g, "".toCharArray(), secondTab, y, 6);
            g.drawImage(Resources.resImgs[24], MainCanvas.WIDTH >> 1, y += Resources.resGFonts[2].getHeight(), 17);
        } else {
            Resources.resGFonts[2].drawString(g, (Player.streak + " " + this.chrHealthBonus).toCharArray(), tab, y += Resources.resGFonts[2].getHeight(), 6);
            Resources.resGFonts[4].drawString(g, ("+ @ " + String.valueOf(this.stageBonus[0])).toCharArray(), secondTab, y, 6);
            if (Player.streak > 1) {
                if (this.mainCanvas.getWidth() == 320) {
                    yesNoAnim.setPosition(secondTab + yesNoAnim.getHeight() + (yesNoAnim.getHeight() << 1), y - (yesNoAnim.getHeight() >> 1));
                    yesNoAnim.setFrame(3);
                    yesNoAnim.paint(g);
                } else {
                    yesNoAnim.setPosition(secondTab + yesNoAnim.getHeight() + (yesNoAnim.getHeight() >> 1), y - (yesNoAnim.getHeight() >> 1));
                    yesNoAnim.setFrame(3);
                    yesNoAnim.paint(g);
                }
            }
            g.drawImage(Resources.resImgs[24], MainCanvas.WIDTH >> 1, y += Resources.resGFonts[2].getHeight(), 17);
        }
        Resources.resGFonts[2].drawString(g, (Player.streak + 1 + " " + this.chrHealthBonus).toCharArray(), tab, y += Resources.resGFonts[2].getHeight(), 6);
        Resources.resGFonts[4].drawString(g, ("+ @ " + String.valueOf(this.stageBonus[1])).toCharArray(), secondTab, y, 6);
        g.drawImage(Resources.resImgs[24], MainCanvas.WIDTH >> 1, y += Resources.resGFonts[2].getHeight(), 17);
        Resources.resGFonts[2].drawString(g, (Player.streak + 2 + " " + this.chrHealthBonus).toCharArray(), tab, y += Resources.resGFonts[2].getHeight(), 6);
        Resources.resGFonts[4].drawString(g, ("+ @ " + String.valueOf(this.stageBonus[2])).toCharArray(), secondTab, y, 6);
        g.drawImage(Resources.resImgs[24], MainCanvas.WIDTH >> 1, y += Resources.resGFonts[2].getHeight(), 17);
        Resources.resGFonts[2].drawString(g, (Player.streak + 3 + " " + this.chrHealthBonus).toCharArray(), tab, y += Resources.resGFonts[2].getHeight(), 6);
        Resources.resGFonts[4].drawString(g, ("+ @ " + String.valueOf(this.stageBonus[3])).toCharArray(), secondTab, y, 6);
        g.drawImage(Resources.resImgs[24], MainCanvas.WIDTH >> 1, y += Resources.resGFonts[2].getHeight(), 17);
        if (hideScreen) {
            g.translate(0, 0);
        }
        Common.paintFNLeft(0, g);
    }

    public void paintStageBonusLost(Graphics g) {
        int y = MainCanvas.HEIGHT - Common.getTableH(2) >> 1;
        int tab = Common.animatedTableLeftBorder() + Common.getTableW() / 8;
        int secondTab = Common.animatedTableLeftBorder() + Common.getTableW() / 3 * 2 - 10;
        Sprite yesNoAnim = Resources.resSprs[112];
        this.paintGame(g);
        this.paintMenuBg(g);
        if (hideScreen) {
            g.translate(iHide, 0);
        }
        Common.paintAnimatedMenuTable(y, 3, iTableAnimation, g);
        if (this.updateCounter % 2 == 0) {
            this.yesAnimation = this.yesAnimation < 3 ? ++this.yesAnimation : 3;
        }
        Resources.resGFonts[0].drawString(g, this.chrStageBonus.toCharArray(), MainCanvas.WIDTH >> 1, y += Resources.resGFonts[0].getHeight(), 17);
        y = y + Resources.resGFonts[0].getHeight() + (Resources.resGFonts[0].getHeight() >> 1);
        g.drawImage(Resources.resImgs[24], MainCanvas.WIDTH >> 1, y, 17);
        Resources.resGFonts[2].drawString(g, (Player.streak + " " + this.chrHealthBonus).toCharArray(), tab, y += Resources.resGFonts[2].getHeight(), 6);
        Resources.resGFonts[4].drawString(g, ("+ @ " + String.valueOf(this.stageBonus[0])).toCharArray(), secondTab, y, 6);
        yesNoAnim.setPosition(secondTab + yesNoAnim.getHeight() + (yesNoAnim.getHeight() >> 1), y - (yesNoAnim.getHeight() >> 1));
        yesNoAnim.setFrame(4);
        yesNoAnim.paint(g);
        g.drawImage(Resources.resImgs[24], MainCanvas.WIDTH >> 1, y += Resources.resGFonts[2].getHeight(), 17);
        Resources.resGFonts[2].drawString(g, (Player.streak + 1 + " " + this.chrHealthBonus).toCharArray(), tab, y += Resources.resGFonts[2].getHeight(), 6);
        Resources.resGFonts[4].drawString(g, ("+ @ " + String.valueOf(this.stageBonus[1])).toCharArray(), secondTab, y, 6);
        yesNoAnim.setPosition(secondTab + yesNoAnim.getHeight() + (yesNoAnim.getHeight() >> 1), y - (yesNoAnim.getHeight() >> 1));
        yesNoAnim.setFrame(4);
        yesNoAnim.paint(g);
        g.drawImage(Resources.resImgs[24], MainCanvas.WIDTH >> 1, y += Resources.resGFonts[2].getHeight(), 17);
        Resources.resGFonts[2].drawString(g, (Player.streak + 2 + " " + this.chrHealthBonus).toCharArray(), tab, y += Resources.resGFonts[2].getHeight(), 6);
        Resources.resGFonts[4].drawString(g, ("+ @ " + String.valueOf(this.stageBonus[2])).toCharArray(), secondTab, y, 6);
        yesNoAnim.setPosition(secondTab + yesNoAnim.getHeight() + (yesNoAnim.getHeight() >> 1), y - (yesNoAnim.getHeight() >> 1));
        yesNoAnim.setFrame(4);
        yesNoAnim.paint(g);
        g.drawImage(Resources.resImgs[24], MainCanvas.WIDTH >> 1, y += Resources.resGFonts[2].getHeight(), 17);
        Resources.resGFonts[2].drawString(g, (Player.streak + 3 + " " + this.chrHealthBonus).toCharArray(), tab, y += Resources.resGFonts[2].getHeight(), 6);
        Resources.resGFonts[4].drawString(g, ("+ @ " + String.valueOf(this.stageBonus[3])).toCharArray(), secondTab, y, 6);
        yesNoAnim.setPosition(secondTab + yesNoAnim.getHeight() + (yesNoAnim.getHeight() >> 1), y - (yesNoAnim.getHeight() >> 1));
        yesNoAnim.setFrame(4);
        yesNoAnim.paint(g);
        g.drawImage(Resources.resImgs[24], MainCanvas.WIDTH >> 1, y += Resources.resGFonts[2].getHeight(), 17);
        if (hideScreen) {
            g.translate(0, 0);
        }
        Common.paintFNLeft(0, g);
    }

    public void paintNotEnought(Graphics g) {
        Common.drawCenteredText(g, 0, (MainCanvas.HEIGHT >> 1) - MainCanvas.HEIGHT / 6, MainCanvas.WIDTH, this.vecNotEnough, Resources.resGFonts[0]);
    }

    public void paintBossDrop(Graphics g) {
        int y = MainCanvas.HEIGHT - Common.getTableH(1) >> 1;
        int tab = Common.animatedTableLeftBorder() + Common.getTableW() / 8;
        int secondTab = Common.animatedTableLeftBorder() + Common.getTableW() / 3 * 2;
        this.paintMenuBg(g);
        g.setClip(Common.animatedTableLeftBorder(), y, Common.getTableW(), Common.getTableH(1));
        if (hideScreen) {
            g.translate(iHide, 0);
        }
        Common.paintAnimatedMenuTable(y, 2, iTableAnimation, g);
        Common.drawCenteredText(g, 0, (y += Resources.resGFonts[2].getHeight()) - (Resources.resGFonts[2].getHeight() >> 1), MainCanvas.WIDTH, Varr.chrBossDrop, Resources.resGFonts[2]);
        y = y + Resources.resGFonts[2].getHeight() + (Resources.resGFonts[0].getHeight() >> 1);
        g.drawImage(Resources.resImgs[24], MainCanvas.WIDTH >> 1, y, 17);
        y += Resources.resGFonts[2].getHeight();
        int droppedItemIndex = -9999;
        if (this.bossDroppedItem == 0) {
            droppedItemIndex = 9;
            Player.equipItem(droppedItemIndex);
        }
        if (this.bossDroppedItem == 1) {
            droppedItemIndex = 10;
            Player.equipItem(droppedItemIndex);
        }
        if (this.bossDroppedItem == 2) {
            droppedItemIndex = 11;
            Player.equipItem(droppedItemIndex);
        }
        if (this.bossDroppedItem == 3) {
            droppedItemIndex = 6;
            Player.equipItem(droppedItemIndex);
        }
        if (this.bossDroppedItem == 4) {
            droppedItemIndex = 7;
            Player.equipItem(droppedItemIndex);
        }
        if (this.bossDroppedItem == 5) {
            droppedItemIndex = 8;
            Player.equipItem(droppedItemIndex);
        }
        if (this.bossDroppedItem == 6) {
            droppedItemIndex = 19;
        }
        if (this.bossDroppedItem == 7) {
            droppedItemIndex = 18;
        }
        if (this.bossDroppedItem == 8) {
            droppedItemIndex = 20;
        }
        if (this.bossDroppedItem == 9) {
            droppedItemIndex = 21;
        }
        if (this.bossDroppedItem == 10) {
            droppedItemIndex = 22;
        }
        String dropCount = "";
        dropCount = this.bossDroppedItem > 5 ? String.valueOf(Player.lastDropCountGenerated) + "X " : "";
        Sprite itemIcon = Resources.resSprs[77];
        if (this.bossDroppedItem > 5) {
            itemIcon = Resources.resSprs[79];
        }
        Resources.resGFonts[2].drawString(g, (dropCount + ShopItems.NAME[droppedItemIndex]).toCharArray(), secondTab - itemIcon.getWidth() - itemIcon.getWidth() - (itemIcon.getWidth() >> 1), y + itemIcon.getHeight() - (Resources.resGFonts[2].getHeight() >> 1), 6);
        itemIcon.setFrame(ShopItems.SPR_FRAME[droppedItemIndex]);
        itemIcon.setPosition(tab, y += Resources.resGFonts[2].getHeight());
        itemIcon.paint(g);
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        if (hideScreen) {
            g.translate(0, 0);
        }
        Common.paintFNLeft(0, g);
    }

    public void paintUnlock(Graphics g) {
        Sprite itemIcon = Resources.resSprs[76];
        int y = MainCanvas.HEIGHT - Common.getTableH(1) >> 1;
        int tab = Common.animatedTableLeftBorder() + Common.getTableW() / 8;
        int secondTab = Common.animatedTableLeftBorder() + Common.getTableW() / 3 * 2 - itemIcon.getWidth();
        g.setClip(Common.animatedTableLeftBorder(), y, Common.getTableW(), Common.getTableH(1));
        this.paintMenuBg(g);
        Common.paintAnimatedMenuTable(y, 2, iTableAnimation, g);
        if (this.specialTomeOfPowerThing) {
            Common.drawCenteredText(g, 0, y += Resources.resGFonts[0].getHeight(), MainCanvas.WIDTH, Common.separateTextToLines(Varr.stageRew, MainCanvas.WIDTH, Resources.resGFonts[0]), Resources.resGFonts[0]);
            y = y + Resources.resGFonts[2].getHeight() + (Resources.resGFonts[0].getHeight() >> 1);
            g.drawImage(Resources.resImgs[24], MainCanvas.WIDTH >> 1, y, 17);
            itemIcon = Resources.resSprs[79];
            g.setClip(Common.animatedTableLeftBorder(), 0, Common.getTableW(), MainCanvas.HEIGHT);
            Resources.resGFonts[2].drawString(g, ShopItems.NAME[21].toCharArray(), secondTab - itemIcon.getWidth() - (itemIcon.getWidth() >> 1), (y += Resources.resGFonts[2].getHeight()) + itemIcon.getHeight() - Resources.resGFonts[2].getHeight(), 6);
            int descTextWidth = Common.getTableW() / 3 * 2;
            Common.drawSeparatedText(g, secondTab - itemIcon.getWidth() - (itemIcon.getWidth() >> 1), y + Resources.resGFonts[0].getHeight() + (Resources.resGFonts[0].getHeight() >> 1), Common.separateTextToLines(MainCanvas.texts.getString("TOP_FREE"), descTextWidth, Resources.resGFonts[2]), Resources.resGFonts[2]);
            itemIcon.setFrame(ShopItems.SPR_FRAME[21]);
            itemIcon.setPosition(tab, y += Resources.resGFonts[2].getHeight());
            itemIcon.paint(g);
        } else {
            Common.drawCenteredText(g, 0, y += Resources.resGFonts[0].getHeight(), MainCanvas.WIDTH, Common.separateTextToLines(Varr.strUnlocked, MainCanvas.WIDTH, Resources.resGFonts[0]), Resources.resGFonts[0]);
            y = y + Resources.resGFonts[2].getHeight() + (Resources.resGFonts[0].getHeight() >> 1);
            g.drawImage(Resources.resImgs[24], MainCanvas.WIDTH >> 1, y, 17);
            y += Resources.resGFonts[2].getHeight();
            if (this.currentlyShowingUnlockedItem > 5 && this.currentlyShowingUnlockedItem < 12) {
                itemIcon = Resources.resSprs[77];
            }
            if (this.currentlyShowingUnlockedItem > 11 && this.currentlyShowingUnlockedItem < 18) {
                itemIcon = Resources.resSprs[78];
            }
            if (this.currentlyShowingUnlockedItem > 17) {
                itemIcon = Resources.resSprs[79];
            }
            g.setClip(Common.animatedTableLeftBorder(), 0, Common.getTableW(), MainCanvas.HEIGHT);
            Resources.resGFonts[2].drawString(g, ShopItems.NAME[this.currentlyShowingUnlockedItem].toCharArray(), secondTab - itemIcon.getWidth() - (itemIcon.getWidth() >> 1), y + itemIcon.getHeight() - Resources.resGFonts[2].getHeight(), 6);
            String strFree = "";
            if (Player.getStage() == 1 && this.currentlyShowingUnlockedItem != 0) {
                strFree = "c 2X " + Varr.freeTe;
                Varr.strUnlocked = Varr.stageRew;
                Resources.resGFonts[2].drawString(g, strFree.toCharArray(), secondTab - itemIcon.getWidth() - (itemIcon.getWidth() >> 1), y + Resources.resGFonts[0].getHeight() + (Resources.resGFonts[0].getHeight() >> 1), 20);
            } else if (Player.getStage() == 2 && this.currentlyShowingUnlockedItem != 5) {
                strFree = "c " + Varr.fLf;
                Varr.strUnlocked = Varr.stageRew;
                Resources.resGFonts[2].drawString(g, strFree.toCharArray(), secondTab - itemIcon.getWidth() - (itemIcon.getWidth() >> 1), y + Resources.resGFonts[0].getHeight() + (Resources.resGFonts[0].getHeight() >> 1), 20);
            } else if (Player.getStage() == 4) {
                strFree = "c " + Varr.fFree;
                Varr.strUnlocked = Varr.stageRew;
                Resources.resGFonts[2].drawString(g, strFree.toCharArray(), secondTab - itemIcon.getWidth() - (itemIcon.getWidth() >> 1), y + Resources.resGFonts[0].getHeight() + (Resources.resGFonts[0].getHeight() >> 1), 20);
            } else {
                Common.drawSeparatedText(g, secondTab - itemIcon.getWidth() - (itemIcon.getWidth() >> 1), y + Resources.resGFonts[0].getHeight() + (Resources.resGFonts[0].getHeight() >> 1), ShopItems.DESC_UNLOCK[this.currentlyShowingUnlockedItem], Resources.resGFonts[2]);
            }
            itemIcon.setFrame(ShopItems.SPR_FRAME[this.currentlyShowingUnlockedItem]);
            itemIcon.setPosition(tab, y += Resources.resGFonts[2].getHeight());
            itemIcon.paint(g);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        Common.paintFNLeft(0, g);
    }

    public void paintHourglass(Graphics g) {
        this.paintMenuBg(g);
        int y = MainCanvas.HEIGHT - Common.getTableH(2) >> 1;
        if (hideScreen) {
            g.translate(iHide, 0);
        }
        Common.paintAnimatedMenuTable(y, 3, iTableAnimation, g);
        Resources.resGFonts[0].drawString(g, MainCanvas.texts.getString("CONT").toCharArray(), MainCanvas.WIDTH >> 1, y += Resources.resGFonts[0].getHeight(), 17);
        y = y + Resources.resGFonts[0].getHeight() + (Resources.resGFonts[0].getHeight() >> 1);
        g.drawImage(Resources.resImgs[24], MainCanvas.WIDTH >> 1, y, 17);
        Common.drawCenteredText(g, Common.animatedTableLeftBorder(), y += Resources.resGFonts[2].getHeight(), Common.getTableW(), Varr.chrFailNH, Resources.resGFonts[2]);
        y = y + Resources.resGFonts[0].getHeight() + (Resources.resGFonts[0].getHeight() >> 1);
        y = y + Resources.resGFonts[0].getHeight() + (Resources.resGFonts[0].getHeight() >> 1);
        Vector continueCountDown = Common.separateTextToLines(String.valueOf(this.countDownNumber), MainCanvas.WIDTH / 3 * 2, Resources.resGFonts[0]);
        Common.drawCenteredText(g, Common.animatedTableLeftBorder(), y + 15, Common.getTableW(), continueCountDown, Resources.resGFonts[0]);
        if (hideScreen) {
            g.translate(0, 0);
        }
        Common.paintFNLeft(0, g);
        Common.paintFNRight(1, g);
    }

    public void paintGameOver(Graphics g) {
        int y = MainCanvas.HEIGHT - Common.getTableH(1) >> 1;
        int tab = Common.animatedTableLeftBorder() + Common.getTableW() / 8;
        int secondTab = Common.animatedTableLeftBorder() + Common.getTableW() / 3 * 2;
        this.paintGame(g);
        this.paintMenuBg(g);
        if (hideScreen) {
            g.translate(iHide, 0);
        }
        Common.paintAnimatedMenuTable(y, 2, iTableAnimation, g);
        Resources.resGFonts[0].drawString(g, this.chrStageFailed, MainCanvas.WIDTH >> 1, y += Resources.resGFonts[0].getHeight(), 17);
        y = y + Resources.resGFonts[0].getHeight() + (Resources.resGFonts[0].getHeight() >> 1);
        g.drawImage(Resources.resImgs[24], MainCanvas.WIDTH >> 1, y, 17);
        int percentage = 2 * Player.getStage();
        int plus4percent = this.thisStageCash * 10000 / 100 * percentage / 10000;
        int thisStageCashIncFourPercent = (int)((double)(this.thisStageCash + plus4percent) * 0.8) * 2 + (this.thisStageCash + plus4percent) / 2;
        Resources.resGFonts[2].drawString(g, this.chrCoins, tab, y += Resources.resGFonts[2].getHeight(), 6);
        Resources.resGFonts[4].drawString(g, ("@ " + String.valueOf(thisStageCashIncFourPercent)).toCharArray(), secondTab, y, 6);
        g.drawImage(Resources.resImgs[24], MainCanvas.WIDTH >> 1, y += Resources.resGFonts[2].getHeight(), 17);
        Resources.resGFonts[2].drawString(g, this.chrLostBonus, tab, y += Resources.resGFonts[2].getHeight(), 6);
        g.drawImage(Resources.resImgs[24], MainCanvas.WIDTH >> 1, y += Resources.resGFonts[2].getHeight(), 17);
        if (hideScreen) {
            g.translate(0, 0);
        }
        Common.paintFNLeft(0, g);
    }

    public void paintStartStage(Graphics g) {
        int y = MainCanvas.HEIGHT - Common.getTableH(0) >> 1;
        Common.paintAnimatedMenuTable(y, 0, iTableAnimation, g);
        Resources.resGFonts[0].drawString(g, this.chrStageStart, MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT >> 1, 3);
    }

    public void paintBossAlert(Graphics g) {
        int y = MainCanvas.HEIGHT - Common.getTableH(0) >> 1;
        Common.paintAnimatedMenuTable(y, 0, iTableAnimation, g);
        Resources.resGFonts[0].drawString(g, this.chrBossComming, MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT >> 1, 3);
    }

    public void paintLevelProgress(Graphics g) {
        int progressBarBgHeight = Resources.resImgs[17].getHeight();
        int progressBarMaxWidth = Resources.resImgs[18].getWidth();
        g.drawImage(Resources.resImgs[17], MainCanvas.WIDTH >> 1, 0, 17);
        if (this.updateGameCounter < this.progressH.length) {
            g.setClip(0, progressBarBgHeight - Resources.resImgs[18].getHeight(), MainCanvas.WIDTH - (MainCanvas.WIDTH - progressBarMaxWidth >> 1) - this.progressH[this.updateGameCounter], progressBarBgHeight);
            g.drawImage(Resources.resImgs[18], MainCanvas.WIDTH >> 1, progressBarBgHeight - Resources.resImgs[18].getHeight(), 17);
            g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        }
    }

    private void updateTowerAnimation() {
        int towerH = Resources.resSprs[this.towerResId].getHeight();
        if (this.towerAnimation < towerH) {
            this.towerAnimation += 4;
        } else {
            int hpLvl = (Player.getStatValue(1) - 1000) / 100;
            int towerAndFenceId = 0;
            if (hpLvl == 1) {
                towerAndFenceId = 1;
            } else if (hpLvl >= 3 && hpLvl < 6) {
                towerAndFenceId = 2;
            } else if (hpLvl >= 6 && hpLvl < 10) {
                towerAndFenceId = 3;
            } else if (hpLvl >= 10 && hpLvl < 15) {
                towerAndFenceId = 4;
            } else if (hpLvl >= 15 && hpLvl < 21) {
                towerAndFenceId = 5;
            } else if (hpLvl >= 21 && hpLvl < 28) {
                towerAndFenceId = 6;
            } else if (hpLvl >= 28) {
                towerAndFenceId = 7;
            }
            int differenceBtwnUpgradeAndNewTower = towerAndFenceId - Player.towerUpgradeLvl;
            if (differenceBtwnUpgradeAndNewTower > 0) {
                Player.towerUpgradeLvl += differenceBtwnUpgradeAndNewTower;
            }
            Player.towerWasUpgraded = false;
            MainCanvas.saveGame();
            this.towerResId = this.towerResId1;
            this.towerFenceResId = this.towerFenceResId1;
            this.towerAddResId = this.towerAddResId1;
            this.showNewTower = true;
        }
    }

    private void updateNewTowerAnimation() {
        if (this.towerAnimation > 0) {
            this.towerAnimation -= 4;
        } else {
            this.showNewTower = false;
            this.towerUpgradeTimeout = 0;
        }
    }

    public void paintWall(Graphics g) {
        int leftFenceStart;
        int rightFenceStart;
        int towerW = Resources.resSprs[this.towerResId].getWidth();
        int towerH = Resources.resSprs[this.towerResId].getHeight();
        int towerFenceW = Resources.resSprs[this.towerFenceResId].getWidth();
        int towerFenceH = Resources.resSprs[this.towerFenceResId].getHeight();
        int towerVerticalOffset = towerH / 6;
        if (this.shakeBackground) {
            ++this.backgroundPosCounter;
            if (this.backgroundPosCounter == 0) {
                towerVerticalOffset -= 3;
            }
            if (this.backgroundPosCounter == 1) {
                --towerVerticalOffset;
            }
            if (this.backgroundPosCounter == 2) {
                towerVerticalOffset -= 2;
            }
            if (this.backgroundPosCounter == 3) {
                towerVerticalOffset += 2;
            }
            if (this.backgroundPosCounter == 4) {
                towerVerticalOffset += 4;
            }
            if (this.backgroundPosCounter == 5) {
                towerVerticalOffset = towerH / 6;
                this.shakeBackground = false;
            }
            if (this.backgroundPosCounter == 5) {
                towerVerticalOffset = towerH / 6;
            }
        }
        for (int i = rightFenceStart = (MainCanvas.WIDTH >> 1) + towerW; i <= MainCanvas.WIDTH; i += towerFenceW) {
            if (i == rightFenceStart + towerFenceW * 2 && this.additionalTowerLvl > 1) {
                Resources.resSprs[this.towerAddResId].setFrame(0);
                Resources.resSprs[this.towerAddResId].setTransform(2);
                Resources.resSprs[this.towerAddResId].setPosition(i, MainCanvas.HEIGHT - towerFenceH + towerVerticalOffset + this.towerAnimation - (Resources.resSprs[this.towerAddResId].getHeight() - Resources.resSprs[this.towerFenceResId].getHeight()));
                Resources.resSprs[this.towerAddResId].paint(g);
                continue;
            }
            Resources.resSprs[this.towerFenceResId].setFrame(0);
            Resources.resSprs[this.towerFenceResId].setTransform(2);
            Resources.resSprs[this.towerFenceResId].setPosition(i, MainCanvas.HEIGHT - towerFenceH + towerVerticalOffset + this.towerAnimation);
            Resources.resSprs[this.towerFenceResId].paint(g);
        }
        for (int i = leftFenceStart = (MainCanvas.WIDTH >> 1) - towerW; i >= 0 - towerW; i -= towerFenceW) {
            if (i == leftFenceStart - towerFenceW * 2 && this.additionalTowerLvl > 0) {
                Resources.resSprs[this.towerAddResId].setFrame(0);
                Resources.resSprs[this.towerAddResId].setTransform(0);
                Resources.resSprs[this.towerAddResId].setPosition(i, MainCanvas.HEIGHT - towerFenceH + towerVerticalOffset + this.towerAnimation - (Resources.resSprs[this.towerAddResId].getHeight() - Resources.resSprs[this.towerFenceResId].getHeight()));
                Resources.resSprs[this.towerAddResId].paint(g);
            }
            Resources.resSprs[this.towerFenceResId].setFrame(0);
            Resources.resSprs[this.towerFenceResId].setTransform(0);
            Resources.resSprs[this.towerFenceResId].setPosition(i, MainCanvas.HEIGHT - towerFenceH + towerVerticalOffset + this.towerAnimation);
            Resources.resSprs[this.towerFenceResId].paint(g);
        }
        Resources.resSprs[this.towerResId].setFrame(0);
        Resources.resSprs[this.towerResId].setTransform(0);
        Resources.resSprs[this.towerResId].setPosition((MainCanvas.WIDTH >> 1) - towerW, MainCanvas.HEIGHT - towerH + towerVerticalOffset + this.towerAnimation);
        Resources.resSprs[this.towerResId].paint(g);
        Resources.resSprs[this.towerResId].setFrame(0);
        Resources.resSprs[this.towerResId].setTransform(2);
        Resources.resSprs[this.towerResId].setPosition(MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT - towerH + towerVerticalOffset + this.towerAnimation);
        Resources.resSprs[this.towerResId].paint(g);
        if (mode == 0) {
            Resources.resSprs[14].setPosition(MainCanvas.WIDTH - Resources.resSprs[14].getWidth() - 2, MainCanvas.HEIGHT - Resources.resSprs[14].getHeight() - 2);
            Resources.resSprs[14].paint(g);
        }
        if (Player.towerWasUpgraded && this.towerUpgradeTimeout > 20 || this.showNewTower) {
            Common.paintTowerUpgradeTable(MainCanvas.HEIGHT, 0, 0, g);
        }
    }

    public void paintBoss(Graphics g) {
        if (this.bossInited && this.bossLoaded) {
            int frame = 0;
            if (this.bossState == Varr.STATE_WALK) {
                this.spr = Resources.resSprs[43];
                frame = this.bossWalkAnimationCounter % 16 >> 2;
            } else if (this.bossState == Varr.STATE_WAIT) {
                this.spr = Resources.resSprs[44];
                frame = 0;
                g.drawImage(Resources.resImgs[16], this.bossPositionX, this.bossPositionY, 0);
            } else if (this.bossState == Varr.STATE_ATTACK) {
                this.spr = Resources.resSprs[44];
                frame = 0;
            } else if (this.bossState == Varr.STATE_JUMP) {
                this.spr = Resources.resSprs[45];
                if (this.bossJumpCounter == 0 || this.bossJumpCounter == 1) {
                    frame = 0;
                }
                if (this.bossJumpCounter == 2 || this.bossJumpCounter == 3) {
                    frame = 1;
                }
                if (this.bossJumpCounter == 4 || this.bossJumpCounter == 5) {
                    frame = 2;
                }
                if (this.bossJumpCounter == 6 || this.bossJumpCounter == 7) {
                    frame = 3;
                }
                if (this.bossJumpCounter == 9 || this.bossJumpCounter == 10) {
                    frame = 3;
                }
                if (this.bossJumpCounter == 11 || this.bossJumpCounter == 12) {
                    frame = 2;
                }
                if (this.bossJumpCounter == 13 || this.bossJumpCounter == 14) {
                    frame = 1;
                }
                if (this.bossJumpCounter == 15 || this.bossJumpCounter == 16) {
                    frame = 0;
                }
            } else if (this.bossState == Varr.STATE_HIDE || this.bossState == Varr.STATE_SHOW) {
                this.spr = Resources.resSprs[45];
                if (this.bossJumpCounter == 0 || this.bossJumpCounter == 1) {
                    frame = 0;
                }
                if (this.bossJumpCounter == 2 || this.bossJumpCounter == 3) {
                    frame = 1;
                }
                if (this.bossJumpCounter == 4 || this.bossJumpCounter == 5) {
                    frame = 2;
                }
                if (this.bossJumpCounter == 6 || this.bossJumpCounter == 7) {
                    frame = 3;
                }
            }
            if (this.bossJumpCounter != 8) {
                this.spr.setFrame(frame);
                this.spr.setPosition(this.bossPositionX, this.bossPositionY);
                this.spr.paint(g);
            }
            ++this.bossWalkAnimationCounter;
            if (this.bossState != Varr.STATE_HIDE && this.bossHealth < this.bossMaxHealth && this.bossState != Varr.STATE_HIDE) {
                int maxHealthWidth = Resources.resSprs[12].getWidth();
                long bossHealthWidth = (long)(maxHealthWidth * 100000) / this.bossMaxHealth * this.bossHealth / 100000L;
                int remainingSpaceBetweenBossAndHealthBar = this.bossWidth - maxHealthWidth >> 1;
                Resources.resSprs[12].setFrame(0);
                Resources.resSprs[12].setPosition(this.bossPositionX + remainingSpaceBetweenBossAndHealthBar, this.bossPositionY - this.bossHeight / 8);
                Resources.resSprs[12].paint(g);
                g.setClip(this.bossPositionX + remainingSpaceBetweenBossAndHealthBar + 2, this.bossPositionY - this.bossHeight / 8, (int)bossHealthWidth, MainCanvas.HEIGHT);
                Resources.resSprs[12].setFrame(1);
                Resources.resSprs[12].setPosition(this.bossPositionX + remainingSpaceBetweenBossAndHealthBar, this.bossPositionY - this.bossHeight / 8);
                Resources.resSprs[12].paint(g);
                g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
            }
            Resources.resSprs[12].setFrame(0);
            Resources.resSprs[100].setPosition(this.bossShotPositionX, this.bossShotPositionY);
            Resources.resSprs[100].paint(g);
        }
    }

    public void paintBossCorpse(Graphics g) {
        if (this.bossInited && this.bossLoaded && this.bossCorpsePositionX != this.INT_NULL) {
            this.spr = Resources.resSprs[95];
            g.drawImage(Resources.resImgs[this.bossCorpseFrame], this.bossCorpsePositionX, this.bossCorpsePositionY, 40);
        }
    }

    public void paintShot(Graphics g) {
        int shotW = Resources.resSprs[9].getWidth();
        int shotH = Resources.resSprs[9].getHeight();
        for (int i = 0; i < this.MAX_SHOTS; ++i) {
            if (this.shotRadius[i] == this.INT_NULL) continue;
            int frame = 4;
            if (this.shotFromTower[i] < 1 && this.activeStaff != this.INT_NULL) {
                if (this.activeStaff == 9) {
                    frame = 2;
                }
                if (this.activeStaff == 10) {
                    frame = 0;
                }
                if (this.activeStaff == 11) {
                    frame = 3;
                }
            }
            Resources.resSprs[9].setFrame(frame);
            Resources.resSprs[9].setPosition(this.shotX[i] - (shotW >> 1), this.shotY[i] - (shotH >> 1));
            Resources.resSprs[9].paint(g);
            Resources.resSprs[9].setFrame(frame);
            Resources.resSprs[9].setPosition(this.towerOneShotX[i] - (shotW >> 1), this.towerOneShotY[i] - (shotH >> 1));
            Resources.resSprs[9].paint(g);
            Resources.resSprs[9].setFrame(frame);
            Resources.resSprs[9].setPosition(this.towerTwoShotX[i] - (shotW >> 1), this.towerTwoShotY[i] - (shotH >> 1));
            Resources.resSprs[9].paint(g);
        }
    }

    public void paintCrit(Graphics g) {
        for (int i = 0; i < 50; ++i) {
            if (this.critX[i] == this.INT_NULL) continue;
            g.drawImage(Resources.resImgs[13], this.critX[i], this.critY[i], 3);
        }
    }

    public void paintStatusTable(Graphics g) {
        Sprite sprBars = Resources.resSprs[71];
        Sprite sprIcons = Resources.resSprs[96];
        Sprite sprPlus = Resources.resSprs[87];
        Sprite sprPlusEff = Resources.resSprs[88];
        Sprite sprNum = Resources.resSprs[81];
        int tableY = Resources.resImgs[20].getHeight() / 10;
        int oneBarWidth = Resources.resImgs[20].getWidth() + sprIcons.getWidth();
        int firstBarX = MainCanvas.WIDTH - oneBarWidth * 3 >> 1;
        int colorBarY = Resources.resImgs[20].getHeight() / 3 + Resources.resImgs[20].getHeight() / 20;
        g.drawImage(Resources.resImgs[20], firstBarX + sprIcons.getWidth(), tableY, 20);
        sprIcons.setFrame(0);
        sprIcons.setPosition(firstBarX, tableY);
        sprIcons.paint(g);
        sprBars.setFrame(3);
        sprBars.setPosition(firstBarX + sprIcons.getWidth(), colorBarY);
        sprBars.paint(g);
        int playerHealthPercentage = this.playerHealth * 1000 / Player.getStatValue(1);
        playerHealthPercentage = playerHealthPercentage * 100 / 1000;
        int playerHealthMaxWidth = sprBars.getWidth();
        int playerActualHealthInPixels = playerHealthMaxWidth * 1000 / 100;
        playerActualHealthInPixels = playerActualHealthInPixels * playerHealthPercentage / 1000;
        g.setClip(firstBarX + sprIcons.getWidth(), 0, playerActualHealthInPixels, MainCanvas.HEIGHT);
        sprBars.setFrame(0);
        sprBars.setPosition(firstBarX + sprIcons.getWidth(), colorBarY);
        sprBars.paint(g);
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        if (this.playerHealth <= Player.getStatValue(1) * 10 / 16 && Player.getConsumableCount(0) > 0 && ShopItems.LOCKED[18] <= Player.getStage() && mode != 3 && mode != 4) {
            sprNum.setFrame(0);
            sprNum.setPosition(firstBarX - (sprNum.getWidth() >> 1), tableY);
            if (!MainCanvas.touchActivated) {
                sprNum.paint(g);
            }
            if (this.lastHealthStatus >= Player.getStatValue(1) * 10 / 16) {
                this.plusHealthAnimationFrame = 0;
            }
            if (this.plusHealthAnimationFrame < 3) {
                sprPlusEff.setFrame(this.plusHealthAnimationFrame);
                sprPlusEff.setPosition(firstBarX + sprIcons.getWidth() + Resources.resImgs[20].getWidth() - sprPlus.getWidth() - sprPlusEff.getWidth() / 6, sprPlusEff.getWidth() / 6);
                sprPlusEff.paint(g);
                if (this.updateCounter % 4 == 0) {
                    ++this.plusHealthAnimationFrame;
                }
            }
            sprPlus.setFrame(0);
            sprPlus.setPosition(firstBarX + sprIcons.getWidth() + Resources.resImgs[20].getWidth() - sprPlus.getWidth() - 1, Resources.resImgs[20].getHeight() / 4);
            sprPlus.paint(g);
        }
        if (this.playerHealth <= Player.getStatValue(1) * 10 / 50 && Player.getConsumableCount(0) > 0 && ShopItems.LOCKED[18] <= Player.getStage() && this.playerHealth > 0 && mode != 3 && mode != 4) {
            sprPlusEff.setFrame(this.plusHealthAnimationFrame);
            sprPlusEff.setPosition(firstBarX + sprIcons.getWidth() + Resources.resImgs[20].getWidth() - sprPlus.getWidth() - sprPlusEff.getWidth() / 6, sprPlusEff.getWidth() / 6);
            sprPlusEff.paint(g);
            if (this.updateCounter % 4 == 0) {
                ++this.plusHealthAnimationFrame;
            }
            if (this.plusHealthAnimationFrame > 3) {
                this.plusHealthAnimationFrame = 0;
            }
        }
        this.lastHealthStatus = this.playerHealth;
        int manaBarActualWidth = 0;
        manaBarActualWidth = this.playerManaW[this.playerMana];
        g.drawImage(Resources.resImgs[20], (firstBarX += Resources.resImgs[20].getWidth() + sprIcons.getWidth()) + sprIcons.getWidth(), tableY, 20);
        sprIcons.setFrame(1);
        sprIcons.setPosition(firstBarX, tableY);
        sprIcons.paint(g);
        sprBars.setFrame(4);
        sprBars.setPosition(firstBarX + sprIcons.getWidth(), colorBarY);
        sprBars.paint(g);
        g.setClip(firstBarX + sprIcons.getWidth(), 0, manaBarActualWidth, MainCanvas.HEIGHT);
        sprBars.setFrame(1);
        sprBars.setPosition(firstBarX + sprIcons.getWidth(), colorBarY);
        sprBars.paint(g);
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        if (this.playerMana <= Player.getStatValue(5) * 10 / 16 && Player.getConsumableCount(1) > 0 && ShopItems.LOCKED[19] <= Player.getStage() && mode != 3 && mode != 4) {
            sprNum.setFrame(1);
            sprNum.setPosition(firstBarX - (sprNum.getWidth() >> 1), tableY);
            if (!MainCanvas.touchActivated) {
                sprNum.paint(g);
            }
            if (this.lastManaStatus >= Player.getStatValue(5) * 10 / 16) {
                this.plusManaAnimationFrame = 0;
            }
            if (this.plusManaAnimationFrame < 3) {
                sprPlusEff.setFrame(this.plusManaAnimationFrame);
                sprPlusEff.setPosition(firstBarX + sprIcons.getWidth() + Resources.resImgs[20].getWidth() - sprPlus.getWidth() - sprPlusEff.getWidth() / 6, sprPlusEff.getWidth() / 6);
                sprPlusEff.paint(g);
                if (this.updateCounter % 4 == 0) {
                    ++this.plusManaAnimationFrame;
                }
            }
            sprPlus.setFrame(1);
            sprPlus.setPosition(firstBarX + sprIcons.getWidth() + Resources.resImgs[20].getWidth() - sprPlus.getWidth() - 1, Resources.resImgs[20].getHeight() / 4);
            sprPlus.paint(g);
        }
        if (this.playerMana <= Player.getStatValue(5) * 10 / 50 && Player.getConsumableCount(1) > 0 && ShopItems.LOCKED[19] <= Player.getStage() && this.playerMana > 0 && mode != 3 && mode != 4) {
            sprPlusEff.setFrame(this.plusManaAnimationFrame);
            sprPlusEff.setPosition(firstBarX + sprIcons.getWidth() + Resources.resImgs[20].getWidth() - sprPlus.getWidth() - sprPlusEff.getWidth() / 6, sprPlusEff.getWidth() / 6);
            sprPlusEff.paint(g);
            if (this.updateCounter % 4 == 0) {
                ++this.plusManaAnimationFrame;
            }
            if (this.plusManaAnimationFrame > 3) {
                this.plusManaAnimationFrame = 0;
            }
        }
        this.lastManaStatus = this.playerMana;
        firstBarX += Resources.resImgs[20].getWidth() + sprIcons.getWidth();
        if (Player.getPlayerShield() > 0) {
            int shieldBarActualStatusPercentage = this.playerShield * 1000 / (Player.getPlayerShield() * 50);
            shieldBarActualStatusPercentage = shieldBarActualStatusPercentage * 100 / 1000;
            int shieldBarMaxWidth = sprBars.getWidth();
            int shieldActualStatusInPixels = shieldBarMaxWidth * 1000 / 100;
            shieldActualStatusInPixels = shieldActualStatusInPixels * shieldBarActualStatusPercentage / 1000;
            g.drawImage(Resources.resImgs[20], firstBarX + sprIcons.getWidth(), tableY, 20);
            sprIcons.setFrame(2);
            sprIcons.setPosition(firstBarX, tableY);
            sprIcons.paint(g);
            sprBars.setFrame(5);
            sprBars.setPosition(firstBarX + sprIcons.getWidth(), colorBarY);
            sprBars.paint(g);
            g.setClip(firstBarX + sprIcons.getWidth(), 0, shieldActualStatusInPixels, MainCanvas.HEIGHT);
            sprBars.setFrame(2);
            sprBars.setPosition(firstBarX + sprIcons.getWidth(), colorBarY);
            sprBars.paint(g);
            g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
            if (this.playerShield <= Player.getPlayerShield() * 50 * 10 / 16 && Player.getConsumableCount(2) > 0 && ShopItems.LOCKED[20] <= Player.getStage() && mode != 3 && mode != 4) {
                sprNum.setFrame(2);
                sprNum.setPosition(firstBarX - (sprNum.getWidth() >> 1), tableY);
                if (!MainCanvas.touchActivated) {
                    sprNum.paint(g);
                }
                if (this.lastShieldStatus >= Player.getPlayerShield() * 50 * 10 / 16) {
                    this.plusShieldAnimationFrame = 0;
                }
                if (this.plusShieldAnimationFrame < 3) {
                    sprPlusEff.setFrame(this.plusShieldAnimationFrame);
                    sprPlusEff.setPosition(firstBarX + sprIcons.getWidth() + Resources.resImgs[20].getWidth() - sprPlus.getWidth() - sprPlusEff.getWidth() / 6, sprPlusEff.getWidth() / 6);
                    sprPlusEff.paint(g);
                    if (this.updateCounter % 4 == 0) {
                        ++this.plusShieldAnimationFrame;
                    }
                }
                sprPlus.setFrame(2);
                sprPlus.setPosition(firstBarX + sprIcons.getWidth() + Resources.resImgs[20].getWidth() - sprPlus.getWidth() - 1, Resources.resImgs[20].getHeight() / 4);
                sprPlus.paint(g);
            }
            if (this.playerShield <= Player.getPlayerShield() * 50 * 10 / 16 && Player.getConsumableCount(2) > 0 && ShopItems.LOCKED[20] <= Player.getStage() && mode != 3 && mode != 4) {
                sprPlusEff.setFrame(this.plusShieldAnimationFrame);
                sprPlusEff.setPosition(firstBarX + sprIcons.getWidth() + Resources.resImgs[20].getWidth() - sprPlus.getWidth() - sprPlusEff.getWidth() / 6, sprPlusEff.getWidth() / 6);
                sprPlusEff.paint(g);
                if (this.updateCounter % 4 == 0) {
                    ++this.plusShieldAnimationFrame;
                }
                if (this.plusShieldAnimationFrame > 3) {
                    this.plusShieldAnimationFrame = 0;
                }
            }
            this.lastShieldStatus = this.playerShield;
        }
        int thisBarPos = (MainCanvas.WIDTH >> 1) - (Resources.resImgs[19].getWidth() >> 1);
        if (Player.getStage() >= ShopItems.LOCKED[18]) {
            g.drawImage(Resources.resImgs[19], MainCanvas.WIDTH >> 1, Resources.resImgs[17].getHeight() - Resources.resImgs[17].getHeight() / 10 + 1, 17);
            Resources.resSprs[98].setPosition(thisBarPos + (Resources.resSprs[98].getWidth() << 1), Resources.resImgs[17].getHeight() - Resources.resImgs[17].getHeight() / 8);
            Resources.resSprs[98].setFrame(1);
            Resources.resSprs[98].paint(g);
            Resources.resGFonts[2].drawString(g, String.valueOf(Player.getConsumableCount(0) + "X").toCharArray(), thisBarPos + Resources.resSprs[98].getWidth() * 3, Resources.resImgs[17].getHeight() - Resources.resImgs[17].getHeight() / 8, 20);
        }
        if (Player.getStage() >= ShopItems.LOCKED[19]) {
            Resources.resSprs[98].setPosition(thisBarPos + Resources.resSprs[98].getWidth() * 4 + (Resources.resSprs[98].getWidth() >> 1), Resources.resImgs[17].getHeight() - Resources.resImgs[17].getHeight() / 8);
            Resources.resSprs[98].setFrame(0);
            Resources.resSprs[98].paint(g);
            Resources.resGFonts[2].drawString(g, String.valueOf(Player.getConsumableCount(1) + "X").toCharArray(), thisBarPos + Resources.resSprs[98].getWidth() * 5 + (Resources.resSprs[98].getWidth() >> 1), Resources.resImgs[17].getHeight() - Resources.resImgs[17].getHeight() / 8, 20);
        }
        if (Player.getStage() >= ShopItems.LOCKED[20] && Player.getSpellStatus(5) > 0) {
            Resources.resSprs[98].setPosition(thisBarPos + Resources.resSprs[98].getWidth() * 7, Resources.resImgs[17].getHeight() - Resources.resImgs[17].getHeight() / 8);
            Resources.resSprs[98].setFrame(2);
            Resources.resSprs[98].paint(g);
            Resources.resGFonts[2].drawString(g, String.valueOf(Player.getConsumableCount(2) + "X").toCharArray(), thisBarPos + Resources.resSprs[98].getWidth() * 8, Resources.resImgs[17].getHeight() - Resources.resImgs[17].getHeight() / 8, 20);
        }
    }

    public void paintEnemies(Graphics g) {
        for (int i = 0; i < this.MAX_LAYERS; ++i) {
            for (int j = 0; j < this.MAX_ENEMIES; ++j) {
                int cannonBodyW;
                if (this.enemyX[i][j] == this.INT_NULL) continue;
                this.spr = null;
                this.sprCannon = null;
                int frame = 0;
                if (this.enemyFrostCounter[i][j] == 0) {
                    this.enemyW = this.enemyType[i][j] == Varr.ENEMY_CANNON ? Resources.resSprs[46].getWidth() << 1 : Resources.resSprs[7].getWidth();
                    if (this.enemyState[i][j] == Varr.STATE_WALK) {
                        if (this.enemyType[i][j] == Varr.ENEMY_GHOST) {
                            this.spr = Resources.resSprs[7];
                            frame = (this.updateCounter + j + i) % 16 >> 2;
                        } else if (this.enemyType[i][j] == Varr.ENEMY_ORC) {
                            this.spr = Resources.resSprs[15];
                            frame = this.frameSequence[(this.enemyFrame + j + i) % 6];
                        } else if (this.enemyType[i][j] == Varr.ENEMY_BAT) {
                            this.spr = Resources.resSprs[23] != null ? Resources.resSprs[23] : Resources.resSprs[15];
                            frame = (this.updateCounter + j + i) % 8 >> 1;
                        } else if (this.enemyType[i][j] == Varr.ENEMY_GOLEM) {
                            this.spr = Resources.resSprs[27] != null ? Resources.resSprs[27] : Resources.resSprs[15];
                            frame = this.frameSequence[(this.enemyFrame + j + i) % 6];
                        }
                        if (this.enemyType[i][j] == Varr.ENEMY_CANNON) {
                            this.spr = Resources.resSprs[46];
                            frame = 0;
                            cannonBodyW = this.spr.getWidth();
                            this.sprCannon = Resources.resSprs[47];
                            this.sprCannon.setFrame(this.cannonWalkFrame);
                            this.sprCannon.setPosition(this.enemyX[i][j] - (cannonBodyW >> 1) - this.sprCannon.getWidth(), this.enemyY[i][j] - (this.enemyH >> 1));
                            this.sprCannon.paint(g);
                            this.sprCannon = Resources.resSprs[48];
                            this.sprCannon.setFrame(this.cannonWalkFrame);
                            this.sprCannon.setPosition(this.enemyX[i][j] + (cannonBodyW >> 1), this.enemyY[i][j] - (this.enemyH >> 1));
                            this.sprCannon.paint(g);
                            this.spr.setFrame(frame);
                            this.spr.setPosition(this.enemyX[i][j] - (cannonBodyW >> 1), this.enemyY[i][j] - (this.enemyH >> 1));
                            this.spr.paint(g);
                            if (this.updateCounter % 4 == 0) {
                                this.cannonWalkFrame = this.cannonWalkFrame < 2 ? ++this.cannonWalkFrame : 0;
                            }
                        }
                    } else if (this.enemyState[i][j] == Varr.STATE_WAIT) {
                        if (this.enemyType[i][j] == Varr.ENEMY_GHOST) {
                            this.spr = Resources.resSprs[7];
                            frame = (this.updateCounter + j + i) % 16 >> 2;
                        } else if (this.enemyType[i][j] == Varr.ENEMY_ORC) {
                            this.spr = Resources.resSprs[15];
                            frame = 0;
                        } else if (this.enemyType[i][j] == Varr.ENEMY_BAT) {
                            this.spr = Resources.resSprs[23] != null ? Resources.resSprs[23] : Resources.resSprs[15];
                            frame = (this.updateCounter + j + i) % 8 >> 1;
                        } else if (this.enemyType[i][j] == Varr.ENEMY_GOLEM) {
                            this.spr = Resources.resSprs[27] != null ? Resources.resSprs[27] : Resources.resSprs[15];
                            frame = 0;
                        } else if (this.enemyType[i][j] == Varr.ENEMY_CANNON) {
                            this.spr = Resources.resSprs[46];
                            frame = 0;
                            cannonBodyW = this.spr.getWidth();
                            this.sprCannon = Resources.resSprs[47];
                            this.sprCannon.setFrame(0);
                            this.sprCannon.setPosition(this.enemyX[i][j] - (cannonBodyW >> 1) - this.sprCannon.getWidth(), this.enemyY[i][j] - (this.enemyH >> 1));
                            this.sprCannon.paint(g);
                            this.sprCannon = Resources.resSprs[48];
                            this.sprCannon.setFrame(0);
                            this.sprCannon.setPosition(this.enemyX[i][j] + (cannonBodyW >> 1), this.enemyY[i][j] - (this.enemyH >> 1));
                            this.sprCannon.paint(g);
                            this.spr.setFrame(frame);
                            this.spr.setPosition(this.enemyX[i][j] - (cannonBodyW >> 1), this.enemyY[i][j] - (this.enemyH >> 1));
                            this.spr.paint(g);
                        }
                    } else if (this.enemyState[i][j] == Varr.STATE_HIDE) {
                        if (this.enemyType[i][j] == Varr.ENEMY_GHOST) {
                            this.spr = Resources.resSprs[7];
                            frame = (this.updateCounter + j + i) % 16 >> 2;
                        } else if (this.enemyType[i][j] == Varr.ENEMY_ORC) {
                            this.spr = Resources.resSprs[15];
                            frame = 0;
                        } else if (this.enemyType[i][j] == Varr.ENEMY_BAT) {
                            this.spr = Resources.resSprs[23] != null ? Resources.resSprs[23] : Resources.resSprs[15];
                            frame = (this.updateCounter + j + i) % 8 >> 1;
                        } else if (this.enemyType[i][j] == Varr.ENEMY_GOLEM) {
                            this.spr = Resources.resSprs[27] != null ? Resources.resSprs[27] : Resources.resSprs[15];
                            frame = 0;
                        } else if (this.enemyType[i][j] == Varr.ENEMY_CANNON) {
                            this.spr = Resources.resSprs[46];
                            frame = 0;
                            cannonBodyW = this.spr.getWidth();
                            this.sprCannon = Resources.resSprs[47];
                            this.sprCannon.setFrame(0);
                            this.sprCannon.setPosition(this.enemyX[i][j] - (cannonBodyW >> 1) - this.sprCannon.getWidth(), this.enemyY[i][j] - (this.enemyH >> 1));
                            this.sprCannon.paint(g);
                            this.sprCannon = Resources.resSprs[48];
                            this.sprCannon.setFrame(0);
                            this.sprCannon.setPosition(this.enemyX[i][j] + (cannonBodyW >> 1), this.enemyY[i][j] - (this.enemyH >> 1));
                            this.sprCannon.paint(g);
                            this.spr.setFrame(frame);
                            this.spr.setPosition(this.enemyX[i][j] - (cannonBodyW >> 1), this.enemyY[i][j] - (this.enemyH >> 1));
                            this.spr.paint(g);
                        }
                    } else if (this.enemyType[i][j] == Varr.ENEMY_GHOST) {
                        this.spr = Resources.resSprs[29];
                        frame = this.enemyAtackCounter[i][j];
                    } else if (this.enemyType[i][j] == Varr.ENEMY_ORC) {
                        this.spr = Resources.resSprs[30];
                        frame = this.enemyAtackCounter[i][j];
                    } else if (this.enemyType[i][j] == Varr.ENEMY_BAT) {
                        this.spr = Resources.resSprs[31] != null ? Resources.resSprs[31] : Resources.resSprs[30];
                        frame = this.enemyAtackCounter[i][j];
                    } else if (this.enemyType[i][j] == Varr.ENEMY_GOLEM) {
                        this.spr = Resources.resSprs[32] != null ? Resources.resSprs[32] : Resources.resSprs[30];
                        frame = this.enemyAtackCounter[i][j];
                    } else if (this.enemyType[i][j] == Varr.ENEMY_CANNON) {
                        this.spr = Resources.resSprs[46];
                        frame = 0;
                        cannonBodyW = this.spr.getWidth();
                        this.sprCannon = Resources.resSprs[47];
                        this.sprCannon.setFrame(0);
                        this.sprCannon.setPosition(this.enemyX[i][j] - (cannonBodyW >> 1) - this.sprCannon.getWidth(), this.enemyY[i][j] - (this.enemyH >> 1));
                        this.sprCannon.paint(g);
                        this.sprCannon = Resources.resSprs[48];
                        this.sprCannon.setFrame(0);
                        this.sprCannon.setPosition(this.enemyX[i][j] + (cannonBodyW >> 1), this.enemyY[i][j] - (this.enemyH >> 1));
                        this.sprCannon.paint(g);
                        this.spr.setFrame(frame);
                        this.spr.setPosition(this.enemyX[i][j] - (cannonBodyW >> 1), this.enemyY[i][j] - (this.enemyH >> 1));
                        this.spr.paint(g);
                    }
                    if (this.enemyType[i][j] != Varr.ENEMY_CANNON) {
                        this.spr.setFrame(frame);
                        if (this.enemyType[i][j] == Varr.ENEMY_ORC) {
                            this.spr.setPosition(this.enemyX[i][j] - (this.enemyW >> 1) - this.enemyW / 5, this.enemyY[i][j] - (this.enemyH >> 1));
                        } else {
                            this.spr.setPosition(this.enemyX[i][j] - (this.enemyW >> 1), this.enemyY[i][j] - (this.enemyH >> 1));
                        }
                        this.spr.paint(g);
                    }
                } else if (this.enemyType[i][j] == Varr.ENEMY_ORC) {
                    g.drawImage(Resources.resImgs[9], this.enemyX[i][j], this.enemyY[i][j], 3);
                } else if (this.enemyType[i][j] == Varr.ENEMY_GHOST) {
                    g.drawImage(Resources.resImgs[10], this.enemyX[i][j], this.enemyY[i][j], 3);
                } else if (this.enemyType[i][j] == Varr.ENEMY_BAT) {
                    if (Resources.resImgs[11] != null) {
                        g.drawImage(Resources.resImgs[11], this.enemyX[i][j], this.enemyY[i][j], 3);
                    } else {
                        g.drawImage(Resources.resImgs[9], this.enemyX[i][j], this.enemyY[i][j], 3);
                    }
                } else if (this.enemyType[i][j] == Varr.ENEMY_GOLEM) {
                    if (Resources.resImgs[12] != null) {
                        g.drawImage(Resources.resImgs[12], this.enemyX[i][j], this.enemyY[i][j], 3);
                    } else {
                        g.drawImage(Resources.resImgs[9], this.enemyX[i][j], this.enemyY[i][j], 3);
                    }
                } else if (this.enemyType[i][j] == Varr.ENEMY_CANNON) {
                    this.spr = Resources.resSprs[46];
                    frame = 0;
                    cannonBodyW = this.spr.getWidth();
                    this.sprCannon = Resources.resSprs[47];
                    this.sprCannon.setFrame(0);
                    this.sprCannon.setPosition(this.enemyX[i][j] - (cannonBodyW >> 1) - this.sprCannon.getWidth(), this.enemyY[i][j] - (this.enemyH >> 1));
                    this.sprCannon.paint(g);
                    this.sprCannon = Resources.resSprs[48];
                    this.sprCannon.setFrame(0);
                    this.sprCannon.setPosition(this.enemyX[i][j] + (cannonBodyW >> 1), this.enemyY[i][j] - (this.enemyH >> 1));
                    this.sprCannon.paint(g);
                    this.spr.setFrame(frame);
                    this.spr.setPosition(this.enemyX[i][j] - (cannonBodyW >> 1), this.enemyY[i][j] - (this.enemyH >> 1));
                    this.spr.paint(g);
                }
                int thisEnemyActualHealth = this.enemyHealth[i][j];
                int thisEnemyMaxHealth = this.getEnemyHealth(this.enemyType[i][j]);
                int thisEnemyHealthPercentage = thisEnemyActualHealth * 1000 / thisEnemyMaxHealth;
                thisEnemyHealthPercentage = thisEnemyHealthPercentage * 100 / 1000;
                int thisEnemyHealthMaxWidth = 1;
                if (Resources.resSprs[12] != null) {
                    thisEnemyHealthMaxWidth = Resources.resSprs[12].getWidth();
                }
                int thisEnemyActualHealthInPixels = thisEnemyHealthMaxWidth * 1000 / 100;
                thisEnemyActualHealthInPixels = thisEnemyActualHealthInPixels * thisEnemyHealthPercentage / 1000;
                if (this.enemyHealth[i][j] < this.getEnemyHealth(this.enemyType[i][j]) && this.enemyPoisonCounter[i][j] == 0) {
                    Resources.resSprs[12].setFrame(0);
                    Resources.resSprs[12].setPosition(this.enemyX[i][j] - (Resources.resSprs[12].getWidth() >> 1), this.enemyY[i][j] - (this.enemyH >> 1));
                    Resources.resSprs[12].paint(g);
                    g.setClip(this.enemyX[i][j] - (Resources.resSprs[12].getWidth() >> 1) + 2, this.enemyY[i][j] - (this.enemyH >> 1), thisEnemyActualHealthInPixels, MainCanvas.HEIGHT);
                    Resources.resSprs[12].setFrame(1);
                    Resources.resSprs[12].setPosition(this.enemyX[i][j] - (Resources.resSprs[12].getWidth() >> 1), this.enemyY[i][j] - (this.enemyH >> 1));
                    Resources.resSprs[12].paint(g);
                    g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
                    continue;
                }
                if (this.enemyPoisonCounter[i][j] <= 0) continue;
                Resources.resSprs[37].setFrame(0);
                Resources.resSprs[37].setPosition(this.enemyX[i][j] - (Resources.resSprs[12].getWidth() >> 1), this.enemyY[i][j] - (this.enemyH >> 1));
                Resources.resSprs[37].paint(g);
                g.setClip(this.enemyX[i][j] - (Resources.resSprs[12].getWidth() >> 1) + 2, this.enemyY[i][j] - (this.enemyH >> 1), thisEnemyActualHealthInPixels, MainCanvas.HEIGHT);
                Resources.resSprs[37].setFrame(1);
                Resources.resSprs[37].setPosition(this.enemyX[i][j] - (Resources.resSprs[12].getWidth() >> 1), this.enemyY[i][j] - (this.enemyH >> 1));
                Resources.resSprs[37].paint(g);
                g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
            }
        }
    }

    public void paintEnemyShots(Graphics g) {
        for (int i = 0; i < 100; ++i) {
            if (this.enemyShotX[i] == this.INT_NULL) continue;
            if (this.enemyShotType[i] == Varr.ENEMY_GHOST) {
                g.drawImage(Resources.resImgs[14], this.enemyShotX[i], this.enemyShotY[i], 3);
            } else if (this.enemyShotType[i] == Varr.ENEMY_CANNON) {
                Resources.resSprs[49].setFrame(0);
                Resources.resSprs[49].setPosition(this.enemyShotX[i] - (Resources.resSprs[49].getWidth() >> 1), this.enemyShotY[i]);
                Resources.resSprs[49].paint(g);
                if (this.explosionParticlesFrame[i] < 1) {
                    Resources.resSprs[50].setFrame(this.explosionParticlesFrame[i]);
                    Resources.resSprs[50].setPosition(this.enemyShotX[i] - (Resources.resSprs[50].getWidth() >> 1), this.enemyShotY[i] - (Resources.resSprs[49].getHeight() >> 1) * (this.explosionParticlesFrame[i] + 1));
                    Resources.resSprs[50].paint(g);
                }
            }
            if (this.explosionParticlesFrame[i] > 3) {
                this.explosionParticlesFrame[i] = 2;
                continue;
            }
            if (this.updateCounter % 2 != 0) continue;
            int n = i;
            this.explosionParticlesFrame[n] = this.explosionParticlesFrame[n] + 1;
        }
    }

    public void paintCorpses(Graphics g) {
        for (int i = 0; i < this.MAX_LAYERS; ++i) {
            for (int j = this.MAX_CORPSES - 1; j >= 0; --j) {
                if (this.corpseX[i][j] == this.INT_NULL) continue;
                this.enemyW = this.corpseType[i][j] == Varr.ENEMY_CANNON ? Resources.resSprs[46].getWidth() << 1 : Resources.resSprs[7].getWidth();
                this.spr = null;
                this.spr = this.corpseType[i][j] == Varr.ENEMY_GHOST ? Resources.resSprs[11] : (this.corpseType[i][j] == Varr.ENEMY_ORC ? Resources.resSprs[22] : (this.corpseType[i][j] == Varr.ENEMY_BAT && Resources.resSprs[24] != null ? Resources.resSprs[24] : (this.corpseType[i][j] == Varr.ENEMY_GOLEM && Resources.resSprs[28] != null ? Resources.resSprs[28] : (this.corpseType[i][j] == Varr.ENEMY_CANNON ? Resources.resSprs[34] : Resources.resSprs[22]))));
                this.spr.setFrame(this.corpseFrame[i][j] / 3);
                if (this.corpseType[i][j] == Varr.ENEMY_ORC) {
                    this.spr.setPosition(this.corpseX[i][j] - (this.enemyW >> 1) - this.enemyW / 5, this.corpseY[i][j] - (this.enemyH >> 1));
                } else {
                    this.spr.setPosition(this.corpseX[i][j] - (this.enemyW >> 1), this.corpseY[i][j] - (this.enemyH >> 1));
                }
                this.spr.paint(g);
            }
        }
    }

    public void paintSpells(Graphics g) {
        this.spr = Resources.resSprs[78];
        Sprite sprD = Resources.resSprs[83];
        Sprite sprNum = Resources.resSprs[81];
        Sprite sprSel = Resources.resSprs[92];
        for (int i = 0; i < 3; ++i) {
            if (Player.getSpellStatus(i) <= 0 || ShopItems.LOCKED[i + 12] > Player.getStage()) continue;
            if (this.spellCounter[i] == 0 && Player.getSpellStatus(i) > 0 && this.playerMana >= Player.getManaCost(i)) {
                int selectorOffset = sprSel.getWidth() - this.spr.getWidth();
                if (this.spellSelectorAnimation[i] > 0) {
                    sprSel.setFrame(this.spellSelectorAnimation[i]);
                    sprSel.setPosition(2 + i * (this.spr.getWidth() + 2) - (selectorOffset >> 1), MainCanvas.HEIGHT - this.spr.getHeight() - 5);
                    sprSel.paint(g);
                    if (this.updateCounter % 2 == 0) {
                        int n = i;
                        this.spellSelectorAnimation[n] = this.spellSelectorAnimation[n] - 1;
                    }
                }
            }
            sprD.setFrame(i);
            sprD.setPosition(2 + i * (this.spr.getWidth() + 2), MainCanvas.HEIGHT - this.spr.getHeight() - 2);
            sprD.paint(g);
            if (this.spellCounter[i] > 0) {
                g.setClip(0, MainCanvas.HEIGHT - 2 - (this.spr.getHeight() - this.spellH[this.spellCounter[i]]), MainCanvas.WIDTH, this.spr.getHeight());
            }
            if (Player.getSpellStatus(i) > 0 && ShopItems.LOCKED[i + 12] <= Player.getStage() && this.playerMana >= Player.getManaCost(i)) {
                this.spr.setFrame(i);
                this.spr.setPosition(2 + i * (this.spr.getWidth() + 2), MainCanvas.HEIGHT - this.spr.getHeight() - 2);
                this.spr.paint(g);
            }
            g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
            sprNum.setFrame(i + 3);
            sprNum.setPosition(1 + (i + 1) * this.spr.getWidth() - sprNum.getWidth(), MainCanvas.HEIGHT - 3 - sprNum.getHeight());
            if (MainCanvas.touchActivated) continue;
            sprNum.paint(g);
        }
    }

    public void paintFrost(Graphics g) {
        for (int i = 0; i < this.MAX_FROST; ++i) {
            if (this.frostX[i] != this.INT_NULL) {
                g.drawImage(Resources.resImgs[32], this.generateX[this.frostX[i]], this.frostY[i], 3);
                int y = this.frostY[i] - (Resources.resSprs[35].getHeight() >> 1);
                for (int f = 0; f < 4; ++f) {
                    Resources.resSprs[94].setFrame(f);
                    Resources.resSprs[94].setPosition(this.generateX[this.frostX[i]], y -= Resources.resSprs[94].getHeight());
                    Resources.resSprs[94].paint(g);
                }
            }
            if (this.frostCloudX[i] == this.INT_NULL) continue;
            Resources.resSprs[35].setFrame(this.frostCloudFrame[i]);
            Resources.resSprs[35].setPosition(this.generateX[this.frostCloudX[i]] - (Resources.resSprs[35].getWidth() >> 1), this.frostCloudY[i] - (Resources.resSprs[35].getHeight() >> 1));
            Resources.resSprs[35].paint(g);
        }
    }

    public void paintPoison(Graphics g) {
        for (int i = 0; i < this.MAX_POISONS; ++i) {
            if (this.poisonX[i] != this.INT_NULL) {
                g.drawImage(Resources.resImgs[8], this.generateX[this.poisonX[i]], this.poisonY[i], 3);
            }
            if (this.cloudX[i] == this.INT_NULL) continue;
            Resources.resSprs[36].setFrame(this.cloudFrame[i]);
            Resources.resSprs[36].setPosition(this.generateX[this.cloudX[i]] - (Resources.resSprs[36].getWidth() >> 1), this.cloudY[i] - (Resources.resSprs[36].getHeight() >> 1));
            Resources.resSprs[36].paint(g);
        }
    }

    public void paintMeteors(Graphics g) {
        for (int i = 0; i < this.MAX_METEORS; ++i) {
            if (this.meteorX[i] != this.INT_NULL) {
                Resources.resSprs[33].setFrame(mode == 0 ? this.updateCounter % 4 : 0);
                Resources.resSprs[33].setPosition(this.generateX[this.meteorX[i]] - (Resources.resSprs[33].getWidth() >> 1), this.meteorY[i] - (Resources.resSprs[33].getHeight() >> 1));
                Resources.resSprs[33].paint(g);
            }
            if (this.explosionX[i] == this.INT_NULL || Resources.resSprs[34] == null) continue;
            Resources.resSprs[34].setFrame(this.explosionFrame[i]);
            Resources.resSprs[34].setPosition(this.generateX[this.explosionX[i]] - (Resources.resSprs[34].getWidth() >> 1), this.explosionY[i] - (Resources.resSprs[34].getHeight() >> 1));
            Resources.resSprs[34].paint(g);
        }
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        this.keyReleased_mainMenu(keyCode);
    }

    public void keyReleased_mainMenu(int keyCode) {
        if (keyCode == 114) {
            this.castSpell(0);
        } else if (keyCode == 116) {
            this.castSpell(1);
        } else if (keyCode == 122) {
            this.castSpell(2);
        }
        if (Keys.isKeyPressed(49)) {
            switch (mode) {
                case 0: {
                    this.useConsumable(0);
                }
            }
        }
        if (Keys.isKeyPressed(50)) {
            switch (mode) {
                case 0: {
                    this.useConsumable(1);
                }
            }
        }
        if (Keys.isKeyPressed(51)) {
            switch (mode) {
                case 0: {
                    this.useConsumable(2);
                }
            }
        }
        if (Keys.isKeyPressed(55)) {
            switch (mode) {
                case 0: {
                    this.castSpell(0);
                }
            }
        }
        if (Keys.isKeyPressed(56)) {
            switch (mode) {
                case 0: {
                    this.castSpell(1);
                }
            }
        }
        if (Keys.isKeyPressed(57)) {
            switch (mode) {
                case 0: {
                    this.castSpell(2);
                }
            }
        }
        if (Keys.isFKLeftCode(keyCode)) {
            switch (mode) {
                case 7: {
                    if (this.mainCanvas.tutorialGame == 8 && !this.paintTutorial) {
                        mode = 8;
                        this.mainCanvas.repaint();
                        break;
                    }
                    stopCountDown = true;
                    if (Player.getConsumableCount(5) > 0 && ShopItems.LOCKED[23] <= Player.getStage()) {
                        this.playerShield = Player.getStatValue(Player.getPlayerShield() * 50);
                        this.playerMana = Player.getStatValue(5);
                        this.playerHealth = Player.getStatValue(1);
                        Player.setConsumableCount(5, Player.getConsumableCount(5) - 1);
                        mode = 0;
                        iHide = -1;
                        hideScreen = true;
                    }
                    this.timerIsAlreadyExpired = false;
                    MainCanvas.soundManager.Stop();
                    MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                    break;
                }
                case 1: {
                    if (this.menuMode == 0) {
                        this.enterMenuItem(this.menuSelected);
                        break;
                    }
                    this.useConsumable(this.consumableSelected);
                    break;
                }
                case 4: {
                    if (Player.getConsumableCount(4) > 0) {
                        this.thisStageCash *= 2;
                    }
                    int percentage = 2 * Player.getStage();
                    if (Player.getStage() > 29) {
                        percentage = 3 * Player.getStage();
                    }
                    int plus4percent = this.thisStageCash * 10000 / 100 * percentage / 10000;
                    MainCanvas.player[MainCanvas.activePlayer].addCash((int)((double)(this.thisStageCash + plus4percent) * 1.99) * 2 + 8);
                    if (Player.streak >= 1) {
                        this.stageBonusFail = true;
                        for (int i = 0; i < this.stageBonus.length; ++i) {
                            this.stageBonus[i] = Player.getStageBonus(Player.streak + i + 1, i - 1);
                            if (Player.getConsumableCount(4) <= 0) continue;
                            this.stageBonus[i] = this.stageBonus[i] * 2;
                        }
                        mode = 11;
                        break;
                    }
                    if (Player.getStage() > 4) {
                        if (Player.getStage() == 14 && Player.diedInLvlFifteen == 2) {
                            this.specialTomeOfPowerThing = true;
                            mode = 10;
                            ++Player.diedInLvlFifteen;
                            break;
                        }
                        if (Player.getStage() == 14 && Player.diedInLvlFifteen < 2) {
                            ++Player.diedInLvlFifteen;
                        }
                        this.nextMode = 5;
                        iHide = -1;
                        hideScreen = true;
                        MainCanvas.saveGame();
                        MainCanvas.soundManager.Stop();
                        MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                        break;
                    }
                    this.nextMode = 5;
                    iHide = -1;
                    hideScreen = true;
                    MainCanvas.saveGame();
                    MainCanvas.soundManager.Stop();
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                    break;
                }
                case 3: {
                    if (Player.streak > 1) {
                        mode = 11;
                        break;
                    }
                    if (this.bossDead) {
                        mode = 9;
                        break;
                    }
                    if (Player.getStage() == 1) {
                        this.prepareVector(Varr.hint1);
                        mode = 6;
                        this.hintFrom3xDeath = false;
                        break;
                    }
                    if (this.itemsUnlockedInThisStage() > 0) {
                        MainCanvas.soundManager.Stop();
                        MainCanvas.soundManager.Play(Sounds.SOUND_UNLOCK, 1);
                        mode = 10;
                        break;
                    }
                    MainCanvas.saveGame();
                    MainCanvas.soundManager.Stop();
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                    this.changeModeToShop();
                    break;
                }
                case 11: {
                    if (this.stageBonusFail) {
                        Player.streak = 0;
                        if (Player.loseCountInRow == 3) {
                            ++Player.hintCounter;
                            ScreenShop.SELECTED_CATEGORY = 3;
                            if (Player.getStage() < 30) {
                                if (Player.getStage() == 9 || Player.getStage() == 19 || Player.getStage() == 29) {
                                    this.prepareVector(Varr.lO);
                                    MainCanvas.limitedOffer = true;
                                    ScreenShop.SELECTED_CATEGORY = 4;
                                } else if (Player.hintCounter % 2 == 0) {
                                    if (Player.getStage() < 11) {
                                        switch (RandomNum.getRandomUInt(4)) {
                                            case 0: {
                                                this.prepareVector(Varr.rec1);
                                                ScreenShop.SELECTED_CATEGORY = 3;
                                                this.showHintItemId = 18;
                                                break;
                                            }
                                            case 1: {
                                                this.prepareVector(Varr.rec2);
                                                ScreenShop.SELECTED_CATEGORY = 0;
                                                this.showHintItemId = 0;
                                                break;
                                            }
                                            case 2: {
                                                this.prepareVector(Varr.rec4);
                                                ScreenShop.SELECTED_CATEGORY = 2;
                                                this.showHintItemId = 12;
                                                break;
                                            }
                                            case 3: {
                                                this.prepareVector(Varr.rec5);
                                                ScreenShop.SELECTED_CATEGORY = 3;
                                                this.showHintItemId = 22;
                                            }
                                        }
                                    } else {
                                        switch (RandomNum.getRandomUInt(5)) {
                                            case 0: {
                                                this.prepareVector(Varr.rec1);
                                                ScreenShop.SELECTED_CATEGORY = 3;
                                                this.showHintItemId = 18;
                                                break;
                                            }
                                            case 1: {
                                                this.prepareVector(Varr.rec2);
                                                ScreenShop.SELECTED_CATEGORY = 0;
                                                this.showHintItemId = 0;
                                                break;
                                            }
                                            case 2: {
                                                this.prepareVector(Varr.rec3);
                                                ScreenShop.SELECTED_CATEGORY = 1;
                                                this.showHintItemId = 9;
                                                break;
                                            }
                                            case 3: {
                                                this.prepareVector(Varr.rec4);
                                                ScreenShop.SELECTED_CATEGORY = 2;
                                                this.showHintItemId = 12;
                                                break;
                                            }
                                            case 4: {
                                                this.prepareVector(Varr.rec5);
                                                ScreenShop.SELECTED_CATEGORY = 3;
                                                this.showHintItemId = 22;
                                            }
                                        }
                                    }
                                } else {
                                    this.prepareVector(Varr.lO);
                                    MainCanvas.limitedOffer = true;
                                    ScreenShop.SELECTED_CATEGORY = 4;
                                }
                                this.hintFrom3xDeath = true;
                                mode = 6;
                                Player.loseCountInRow = 0;
                                break;
                            }
                            if (Player.hintCounter % 2 == 0) {
                                switch (RandomNum.getRandomUInt(6)) {
                                    case 0: {
                                        this.prepareVector(Varr.lO);
                                        MainCanvas.limitedOffer = true;
                                        ScreenShop.SELECTED_CATEGORY = 4;
                                        break;
                                    }
                                    case 1: {
                                        this.prepareVector("BUY 3X DAMAGE NOW FOR " + String.valueOf(Player.getSpecialOfferItemPrice(1)) + " COINS, YOU'LL SAVE -" + String.valueOf(Player.getSpecialOfferItemSaving(1)) + " COINS!");
                                        MainCanvas.limitedOffer = false;
                                        MainCanvas.specialOffer = 1;
                                        ScreenShop.SELECTED_CATEGORY = 0;
                                        this.showHintItemId = 0;
                                        break;
                                    }
                                    case 2: {
                                        this.prepareVector("BUY 3X HEALTH NOW FOR " + String.valueOf(Player.getSpecialOfferItemPrice(2)) + " COINS, YOU'LL SAVE -" + String.valueOf(Player.getSpecialOfferItemSaving(2)) + " COINS!");
                                        MainCanvas.limitedOffer = false;
                                        MainCanvas.specialOffer = 2;
                                        ScreenShop.SELECTED_CATEGORY = 0;
                                        this.showHintItemId = 1;
                                        break;
                                    }
                                    case 3: {
                                        this.prepareVector("BUY 3X MANA NOW FOR " + String.valueOf(Player.getSpecialOfferItemPrice(3)) + " COINS, YOU'LL SAVE -" + String.valueOf(Player.getSpecialOfferItemSaving(3)) + " COINS!");
                                        MainCanvas.limitedOffer = false;
                                        MainCanvas.specialOffer = 3;
                                        ScreenShop.SELECTED_CATEGORY = 0;
                                        this.showHintItemId = 5;
                                        break;
                                    }
                                    case 4: {
                                        this.prepareVector("BUY 10X HEALTH POTION NOW FOR " + String.valueOf(Player.getSpecialOfferItemPrice(4)) + " COINS, YOU'LL SAVE -" + String.valueOf(Player.getSpecialOfferItemSaving(4)) + " COINS!");
                                        MainCanvas.limitedOffer = false;
                                        MainCanvas.specialOffer = 4;
                                        ScreenShop.SELECTED_CATEGORY = 3;
                                        this.showHintItemId = 18;
                                        break;
                                    }
                                    case 5: {
                                        this.prepareVector("BUY 5X MANA POTION NOW FOR " + String.valueOf(Player.getSpecialOfferItemPrice(5)) + " COINS, YOU'LL SAVE -" + String.valueOf(Player.getSpecialOfferItemSaving(5)) + " COINS!");
                                        MainCanvas.limitedOffer = false;
                                        MainCanvas.specialOffer = 5;
                                        ScreenShop.SELECTED_CATEGORY = 3;
                                        this.showHintItemId = 19;
                                    }
                                }
                            } else {
                                this.prepareVector(Varr.lO);
                                MainCanvas.limitedOffer = true;
                                ScreenShop.SELECTED_CATEGORY = 4;
                            }
                            this.hintFrom3xDeath = true;
                            mode = 6;
                            Player.loseCountInRow = 0;
                            break;
                        }
                        this.nextMode = 5;
                        iHide = -1;
                        hideScreen = true;
                        MainCanvas.saveGame();
                        MainCanvas.soundManager.Stop();
                        MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                        break;
                    }
                    if (this.bossDead) {
                        mode = 9;
                        break;
                    }
                    if (Player.getStage() == 1) {
                        this.prepareVector(Varr.hint1);
                        mode = 6;
                        this.hintFrom3xDeath = false;
                        break;
                    }
                    if (this.itemsUnlockedInThisStage() > 0) {
                        MainCanvas.soundManager.Stop();
                        MainCanvas.soundManager.Play(Sounds.SOUND_UNLOCK, 1);
                        mode = 10;
                        break;
                    }
                    MainCanvas.saveGame();
                    MainCanvas.soundManager.Stop();
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                    this.changeModeToShop();
                    break;
                }
                case 10: {
                    int catToShow;
                    if (this.itemsUnlockedInThisStage() > 0) {
                        int[] itemsUnlocked = new int[this.itemsUnlockedInThisStage()];
                        int c = 0;
                        for (int i = 0; i < ShopItems.LOCKED.length; ++i) {
                            if (ShopItems.LOCKED[i] != Player.getStage()) continue;
                            itemsUnlocked[c] = i;
                            ++c;
                        }
                        if (this.itemsShowed < this.itemsUnlockedInThisStage() - 1) {
                            mode = 10;
                            ++this.itemsShowed;
                            this.currentlyShowingUnlockedItem = itemsUnlocked[this.itemsShowed];
                            break;
                        }
                        MainCanvas.saveGame();
                        MainCanvas.soundManager.Stop();
                        MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                        int catToShow2 = 0;
                        if (itemsUnlocked[this.itemsShowed] < 6) {
                            catToShow2 = 0;
                        }
                        if (itemsUnlocked[this.itemsShowed] > 5 && itemsUnlocked[this.itemsShowed] < 12) {
                            catToShow2 = 1;
                        }
                        if (itemsUnlocked[this.itemsShowed] > 11 && itemsUnlocked[this.itemsShowed] < 18) {
                            catToShow2 = 2;
                        }
                        if (itemsUnlocked[this.itemsShowed] > 17) {
                            catToShow2 = 3;
                        }
                        ScreenShop.SELECTED_CATEGORY = catToShow2;
                        this.changeModeToShop();
                        break;
                    }
                    if (!this.specialTomeOfPowerThing) break;
                    ScreenShop.SELECTED_CATEGORY = catToShow = 3;
                    Player.buyConsumableForCash(21);
                    this.specialTomeOfPowerThing = false;
                    MainCanvas.saveGame();
                    MainCanvas.soundManager.Stop();
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                    this.changeModeToShop();
                    break;
                }
                case 6: {
                    if (MainCanvas.limitedOffer) {
                        this.nextMode = 5;
                        iHide = -1;
                        hideScreen = true;
                        MainCanvas.saveGame();
                        MainCanvas.soundManager.Stop();
                        MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                        if (MainCanvas.limitedOfferItem != 9) break;
                        X.mainCanvas.buyingCoins = true;
                        X.mainCanvas.fullUpgrade = false;
                        X.mainCanvas.itemBuying = 22;
                        break;
                    }
                    if (MainCanvas.specialOffer > 0) {
                        if (Player.getCash() < Player.getSpecialOfferItemPrice(MainCanvas.specialOffer)) {
                            X.mainCanvas.buyingCoins = true;
                            X.mainCanvas.fullUpgrade = false;
                            MainCanvas.limitedOffer = false;
                            X.mainCanvas.itemBuying = 22;
                            break;
                        }
                        Player.userHasUsedSpecialOffer(MainCanvas.specialOffer);
                        this.nextMode = 5;
                        iHide = -1;
                        hideScreen = true;
                        MainCanvas.saveGame();
                        MainCanvas.soundManager.Stop();
                        MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                        break;
                    }
                    if (this.itemsUnlockedInThisStage() > 0 && !this.hintFrom3xDeath) {
                        mode = 10;
                        break;
                    }
                    this.nextMode = 5;
                    iHide = -1;
                    hideScreen = true;
                    MainCanvas.saveGame();
                    MainCanvas.soundManager.Stop();
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                    break;
                }
                case 9: {
                    this.nextMode = 5;
                    iHide = -1;
                    hideScreen = true;
                    MainCanvas.saveGame();
                    MainCanvas.soundManager.Stop();
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                    break;
                }
                case 8: {
                    this.nextMode = 0;
                    iHide = -1;
                    hideScreen = true;
                }
            }
        }
        if (Keys.isFKRightCode(keyCode)) {
            switch (mode) {
                case 0: {
                    ScreenGame.resetShowAnimation();
                    mode = 1;
                    break;
                }
                case 1: {
                    hideScreen = true;
                    iHide = -1;
                    this.nextMode = 0;
                    break;
                }
                case 7: {
                    mode = 4;
                    break;
                }
                case 6: {
                    if (MainCanvas.limitedOffer) {
                        Player.playerRefusedLimitedOffer = true;
                        this.nextMode = 5;
                        iHide = -1;
                        hideScreen = true;
                        MainCanvas.saveGame();
                        MainCanvas.soundManager.Stop();
                        MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                    }
                    if (MainCanvas.specialOffer <= 0) break;
                    this.nextMode = 5;
                    iHide = -1;
                    hideScreen = true;
                    MainCanvas.saveGame();
                    MainCanvas.soundManager.Stop();
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                }
            }
        }
        if (Keys.isActionGeneratedByKey(3, keyCode)) {
            switch (mode) {
                case 1: {
                    if (this.menuSelected > 0) {
                        --this.menuSelected;
                        break;
                    }
                    this.menuSelected = 2;
                }
            }
        }
        if (Keys.isActionGeneratedByKey(4, keyCode)) {
            switch (mode) {
                case 1: {
                    if (this.menuSelected < 2) {
                        ++this.menuSelected;
                        break;
                    }
                    this.menuSelected = 0;
                }
            }
        }
        if (Keys.isActionGeneratedByKey(2, keyCode)) {
            switch (mode) {
                default: 
            }
        }
        if (Keys.isActionGeneratedByKey(1, keyCode)) {
            switch (mode) {
                default: 
            }
        }
        if (Keys.isActionGeneratedByKey(5, keyCode)) {
            switch (mode) {
                case 1: {
                    if (this.menuMode == 0) {
                        this.enterMenuItem(this.menuSelected);
                        break;
                    }
                    this.useConsumable(this.consumableSelected);
                }
            }
        }
    }

    private int itemsUnlockedInThisStage() {
        int itemsUnlockedInThisStage = 0;
        int stg = Player.getStage();
        for (int i = 0; i < 24; ++i) {
            if (ShopItems.LOCKED[i] != stg) continue;
            ++itemsUnlockedInThisStage;
        }
        return itemsUnlockedInThisStage;
    }

    private void useConsumable(int item) {
        if (ShopItems.LOCKED[18 + item] <= Player.getStage()) {
            switch (item) {
                case 0: {
                    if (Player.getConsumableCount(0) > 0) {
                        this.playerHealth += Player.getStatValue(1) / 10 * 4;
                        if (this.playerHealth > Player.getStatValue(1)) {
                            this.playerHealth = Player.getStatValue(1);
                        }
                        Player.setConsumableCount(0, Player.getConsumableCount(0) - 1);
                        this.playerUsedHP = true;
                        break;
                    }
                    this.vecNotEnough = Common.separateTextToLines(Varr.strNEHP, MainCanvas.WIDTH, Resources.resGFonts[0]);
                    this.notEnoughTimer = 40;
                    break;
                }
                case 1: {
                    if (Player.getConsumableCount(1) > 0) {
                        this.playerMana += Player.getStatValue(5) / 10 * 8;
                        if (this.playerMana > Player.getStatValue(5)) {
                            this.playerMana = Player.getStatValue(5);
                        }
                        Player.setConsumableCount(1, Player.getConsumableCount(1) - 1);
                        break;
                    }
                    this.vecNotEnough = Common.separateTextToLines(Varr.strNEMP, MainCanvas.WIDTH, Resources.resGFonts[0]);
                    this.notEnoughTimer = 40;
                    break;
                }
                case 2: {
                    if (Player.getConsumableCount(2) > 0) {
                        this.playerShield = Player.getPlayerShield() * 50;
                        Player.setConsumableCount(2, Player.getConsumableCount(2) - 1);
                        break;
                    }
                    this.vecNotEnough = Common.separateTextToLines(Varr.strNESR, MainCanvas.WIDTH, Resources.resGFonts[0]);
                    this.notEnoughTimer = 40;
                    break;
                }
                case 3: {
                    if (Player.getConsumableCount(3) <= 0) break;
                    Player.setConsumableCount(3, Player.getConsumableCount(3) - 1);
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    if (Player.getConsumableCount(5) <= 0) break;
                    this.playerShield = Player.getStatValue(Player.getPlayerShield() * 50);
                    this.playerMana = Player.getStatValue(5);
                    this.playerHealth = Player.getStatValue(1);
                    Player.setConsumableCount(5, Player.getConsumableCount(5) - 1);
                }
            }
            hideScreen = true;
            iHide = -1;
            this.nextMode = 0;
        }
    }

    public void paintAim(Graphics g) {
        int aimW = 5;
        int aimH = 5;
        int radius = Common.STAFF_RADIUS;
        radius = this.shotCounter < 5 ? Common.STAFF_RADIUS - this.shotCounter : Common.STAFF_RADIUS - 5;
        int aimX = this.getAimArcX(this.aimingAngle, radius);
        int aimY = this.getAimArcY(this.aimingAngle, radius);
        g.setColor(5388548);
        g.fillArc(aimX - (aimW >> 1), aimY - (aimH >> 1), aimW, aimH, 0, 360);
        g.fillTriangle(this.getAimArcX(this.aimingAngle - 3, radius + Common.STAFF_GEM_H), this.getAimArcY(this.aimingAngle - 3, radius + Common.STAFF_GEM_H), this.getAimArcX(this.aimingAngle + 3, radius + Common.STAFF_GEM_H), this.getAimArcY(this.aimingAngle + 3, radius + Common.STAFF_GEM_H), this.getAimArcX(this.aimingAngle, 0), this.getAimArcY(this.aimingAngle, 0));
        g.setColor(this.staffBgTop);
        g.fillTriangle(this.getAimArcX(this.aimingAngle - 5, radius + Common.STAFF_GEM_H), this.getAimArcY(this.aimingAngle - 5, radius + Common.STAFF_GEM_H), this.getAimArcX(this.aimingAngle + 5, radius + Common.STAFF_GEM_H), this.getAimArcY(this.aimingAngle + 5, radius + Common.STAFF_GEM_H), this.getAimArcX(this.aimingAngle, radius + (Common.STAFF_GEM_H << 1)), this.getAimArcY(this.aimingAngle, radius + (Common.STAFF_GEM_H << 1)));
        g.setColor(this.staffTop);
        g.fillTriangle(this.getAimArcX(this.aimingAngle - 2, radius + Common.STAFF_GEM_H), this.getAimArcY(this.aimingAngle - 2, radius + Common.STAFF_GEM_H), this.getAimArcX(this.aimingAngle + 2, radius + Common.STAFF_GEM_H), this.getAimArcY(this.aimingAngle + 2, radius + Common.STAFF_GEM_H), this.getAimArcX(this.aimingAngle, radius + (Common.STAFF_GEM_H << 1)), this.getAimArcY(this.aimingAngle, radius + (Common.STAFF_GEM_H << 1)));
        g.setColor(5388548);
        g.fillTriangle(this.getAimArcX(this.aimingAngle - 6, radius + Common.STAFF_GEM_H), this.getAimArcY(this.aimingAngle - 6, radius + Common.STAFF_GEM_H), this.getAimArcX(this.aimingAngle + 6, radius + Common.STAFF_GEM_H), this.getAimArcY(this.aimingAngle + 6, radius + Common.STAFF_GEM_H), this.getAimArcX(this.aimingAngle, radius - (Common.STAFF_GEM_H >> 1)), this.getAimArcY(this.aimingAngle, radius - (Common.STAFF_GEM_H >> 1)));
        g.setColor(this.staffBgBottom);
        g.fillTriangle(this.getAimArcX(this.aimingAngle - 5, radius + Common.STAFF_GEM_H), this.getAimArcY(this.aimingAngle - 5, radius + Common.STAFF_GEM_H), this.getAimArcX(this.aimingAngle + 5, radius + Common.STAFF_GEM_H), this.getAimArcY(this.aimingAngle + 5, radius + Common.STAFF_GEM_H), this.getAimArcX(this.aimingAngle, radius), this.getAimArcY(this.aimingAngle, radius));
        g.setColor(this.staffBgBottom);
        g.fillTriangle(this.getAimArcX(this.aimingAngle - 2, radius + Common.STAFF_GEM_H), this.getAimArcY(this.aimingAngle - 2, radius + Common.STAFF_GEM_H), this.getAimArcX(this.aimingAngle + 2, radius + Common.STAFF_GEM_H), this.getAimArcY(this.aimingAngle + 2, radius + Common.STAFF_GEM_H), this.getAimArcX(this.aimingAngle, radius), this.getAimArcY(this.aimingAngle, radius));
        g.setColor(5388548);
        g.fillTriangle(this.getAimArcX(this.aimingAngle - 2, radius), this.getAimArcY(this.aimingAngle - 2, radius), this.getAimArcX(this.aimingAngle + 2, radius), this.getAimArcY(this.aimingAngle + 2, radius), this.getAimArcX(this.aimingAngle, radius + Common.STAFF_GEM_H), this.getAimArcY(this.aimingAngle, radius + Common.STAFF_GEM_H));
    }

    public void setStaffColor(int staff) {
        switch (staff) {
            case 9: {
                this.staffTop = 16741190;
                this.staffBgTop = 16596481;
                this.staffBgBottom = 11413248;
                break;
            }
            case 10: {
                this.staffTop = 0xFFFA7F;
                this.staffBgTop = 16769281;
                this.staffBgBottom = 13545986;
                break;
            }
            case 11: {
                this.staffTop = 0x7EFF7E;
                this.staffBgTop = 65280;
                this.staffBgBottom = 44032;
                break;
            }
            default: {
                this.staffTop = 0x80F8FF;
                this.staffBgTop = 61951;
                this.staffBgBottom = 301988;
            }
        }
    }

    public void swapEnemies(int layer, int ID1, int ID2) {
        int x = this.enemyX[layer][ID1];
        int y = this.enemyY[layer][ID1];
        int type = this.enemyType[layer][ID1];
        int state = this.enemyState[layer][ID1];
        int health = this.enemyHealth[layer][ID1];
        int frost = this.enemyFrostCounter[layer][ID1];
        int fire = this.enemyFireCounter[layer][ID1];
        int poison = this.enemyPoisonCounter[layer][ID1];
        int attack = this.enemyAtackCounter[layer][ID1];
        boolean moved = this.enemyAlreadyMoved[layer][ID1];
        int explode = this.cannonExplosionCounter[layer][ID1];
        this.enemyX[layer][ID1] = this.enemyX[layer][ID2];
        this.enemyY[layer][ID1] = this.enemyY[layer][ID2];
        this.enemyType[layer][ID1] = this.enemyType[layer][ID2];
        this.enemyState[layer][ID1] = this.enemyState[layer][ID2];
        this.enemyHealth[layer][ID1] = this.enemyHealth[layer][ID2];
        this.enemyFrostCounter[layer][ID1] = this.enemyFrostCounter[layer][ID2];
        this.enemyFireCounter[layer][ID1] = this.enemyFireCounter[layer][ID2];
        this.enemyPoisonCounter[layer][ID1] = this.enemyPoisonCounter[layer][ID2];
        this.enemyAtackCounter[layer][ID1] = this.enemyAtackCounter[layer][ID2];
        this.enemyAlreadyMoved[layer][ID1] = this.enemyAlreadyMoved[layer][ID2];
        this.cannonExplosionCounter[layer][ID1] = this.cannonExplosionCounter[layer][ID2];
        this.enemyX[layer][ID2] = x;
        this.enemyY[layer][ID2] = y;
        this.enemyType[layer][ID2] = type;
        this.enemyState[layer][ID2] = state;
        this.enemyHealth[layer][ID2] = health;
        this.enemyFrostCounter[layer][ID2] = frost;
        this.enemyFireCounter[layer][ID2] = fire;
        this.enemyPoisonCounter[layer][ID2] = poison;
        this.enemyAtackCounter[layer][ID2] = attack;
        this.enemyAlreadyMoved[layer][ID2] = moved;
        this.cannonExplosionCounter[layer][ID2] = explode;
    }

    public void pointerPressed(int x, int y) {
        switch (mode) {
            case 0: {
                if (y <= Resources.resImgs[17].getHeight()) {
                    if (x < MainCanvas.WIDTH / 3 + Resources.resSprs[87].getWidth()) {
                        this.useConsumable(0);
                        break;
                    }
                    if (x >= MainCanvas.WIDTH / 3 + Resources.resSprs[87].getWidth() && x < MainCanvas.WIDTH / 3 * 2) {
                        this.useConsumable(1);
                        break;
                    }
                    if (x < MainCanvas.WIDTH / 3 * 2) break;
                    this.useConsumable(2);
                    break;
                }
                if (y > MainCanvas.HEIGHT - Resources.resSprs[83].getHeight() - 2 && y > Resources.resImgs[17].getHeight()) {
                    for (int i = 0; i < 3; ++i) {
                        if (x <= 2 + i * Resources.resSprs[83].getWidth() || x >= 2 + (i + 1) * Resources.resSprs[83].getWidth()) continue;
                        if (i == 0) {
                            this.castSpell(0);
                            continue;
                        }
                        if (i == 1) {
                            this.castSpell(1);
                            continue;
                        }
                        if (i != 2) continue;
                        this.castSpell(2);
                    }
                    break;
                }
                if (x < MainCanvas.WIDTH >> 1) {
                    this.touch = 1;
                    break;
                }
                this.touch = 2;
                break;
            }
            case 1: {
                int startX;
                int iconY = (MainCanvas.HEIGHT >> 1) - (Resources.resSprs[79].getHeight() >> 1) - Resources.resSprs[79].getHeight() / 7;
                int iconX = startX = Common.animatedTableLeftBorder();
                if (y <= iconY || y >= iconY + Resources.resSprs[42].getHeight()) break;
                for (int i = 0; i < 3; ++i) {
                    iconX = startX + (i * Resources.resSprs[42].getWidth() + Resources.resSprs[42].getWidth());
                    if (x <= (iconX += i * (Resources.resSprs[42].getWidth() >> 1)) || x >= iconX + Resources.resSprs[42].getWidth()) continue;
                    this.menuSelected = i;
                    this.enterMenuItem(this.menuSelected);
                }
                break;
            }
        }
        Common.fnTouch(x, y);
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        switch (mode) {
            case 0: {
                this.touch = 0;
            }
        }
    }

    public int getArcX(int angle, int r) {
        return (MainCanvas.WIDTH >> 1) + (ScreenGame.COS(angle) * r >> 6);
    }

    public int getArcY(int angle, int r) {
        return MainCanvas.HEIGHT + (ScreenGame.SIN(angle) * r >> 6);
    }

    public int getAimArcX(int angle, int r) {
        return (MainCanvas.WIDTH >> 1) + (ScreenGame.COS(angle) * r >> 7);
    }

    public int getAimArcY(int angle, int r) {
        return MainCanvas.HEIGHT + (ScreenGame.SIN(angle) * r >> 7);
    }

    public int getAimArcXTowerOne(int angle, int r) {
        return Resources.resSprs[this.towerAddResId].getWidth() + (ScreenGame.COS(angle) * (r - Resources.resSprs[this.towerAddResId].getWidth()) >> 7);
    }

    public int getAimArcYTowerOne(int angle, int r) {
        return MainCanvas.HEIGHT - 0 + (ScreenGame.SIN(angle) * (r - (Resources.resSprs[this.towerAddResId].getWidth() >> 1)) >> 7);
    }

    public int getAimArcXTowerTwo(int angle, int r) {
        return MainCanvas.WIDTH - (Resources.resSprs[this.towerAddResId].getWidth() >> 1) + (ScreenGame.COS(angle) * (r - (Resources.resSprs[this.towerAddResId].getWidth() >> 1)) >> 7);
    }

    public int getAimArcYTowerTwo(int angle, int r) {
        return MainCanvas.HEIGHT - (Resources.resSprs[this.towerAddResId].getHeight() >> 1) + (ScreenGame.SIN(angle) * (r - (Resources.resSprs[this.towerAddResId].getWidth() >> 1)) >> 7);
    }

    public void resetGame() {
        int i;
        for (i = 0; i < this.MAX_LAYERS; ++i) {
            for (int j = 0; j < this.MAX_ENEMIES; ++j) {
                this.removeEnemy(i, j);
            }
        }
        for (i = 0; i < this.MAX_SHOTS; ++i) {
            this.removeShot(i);
        }
        this.generateWaveCounter = 80;
        this.aimingAngle = 270;
        this.shotCounter = 0;
    }

    public int[] getWave(int wave) {
        if (wave == 0) {
            return new int[]{0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }
        if (wave == 1) {
            return new int[]{0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0};
        }
        if (wave == 2) {
            return new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0};
        }
        if (wave == 3) {
            return new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0};
        }
        if (wave == 4) {
            return new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0};
        }
        if (wave == 5) {
            return new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0};
        }
        if (wave == 6) {
            return new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1};
        }
        if (wave == 7) {
            return new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0};
        }
        if (wave == 8) {
            return new int[]{1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0};
        }
        if (wave == 9) {
            return new int[]{1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1};
        }
        if (wave == 10) {
            return new int[]{1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1};
        }
        if (wave == 11) {
            return new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1};
        }
        if (wave == 12) {
            return new int[]{1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1};
        }
        if (wave == 13) {
            return new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        }
        if (wave == 14) {
            return new int[]{1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0};
        }
        if (wave == 15) {
            return new int[]{1, 1, 0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1};
        }
        if (wave == 16) {
            return new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0};
        }
        if (wave == 17) {
            return new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        }
        return new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public int[] getCannonWave(int wave) {
        if (wave == 0) {
            return new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0};
        }
        if (wave == 1) {
            return new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0};
        }
        if (wave == 2) {
            return new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0};
        }
        return new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    int getStageCash(int iTier, int BASE_VALUE, int iStep) {
        int base = iTier == 0 ? BASE_VALUE : this.getStageCash(iTier - 1, BASE_VALUE, iStep);
        return base + iStep;
    }

    int getEnemyMaxHealth(int iTier, int BASE_VALUE, int iStep) {
        int base = iTier == 0 ? BASE_VALUE : this.getStageCash(iTier - 1, BASE_VALUE, iStep);
        return base + iStep;
    }

    static int SIN(long angle) {
        if ((angle %= 360L) < 0L) {
            angle = 360L + angle;
        }
        return SIN_TABLE[(int)angle];
    }

    static int COS(long angle) {
        return ScreenGame.SIN(angle += 90L);
    }

    public int atan(int Y, int X2) {
        int bottom;
        boolean swap = false;
        int top = Math.abs(Y);
        if (top > (bottom = Math.abs(X2))) {
            int btemp = bottom;
            bottom = top;
            top = btemp;
            swap = true;
        } else if (bottom == 0) {
            return -300;
        }
        int index = top * 45 / bottom;
        int angle = AtanTable[index];
        if (swap) {
            angle = 90 - angle;
        }
        if (X2 < 0 && Y < 0) {
            angle += 180;
        } else if (Y < 0) {
            angle = 90 - angle;
            angle += 270;
        } else if (X2 < 0) {
            angle = 90 - angle;
            angle += 90;
        }
        if (angle == 360) {
            angle = 0;
        }
        return angle;
    }

    private void preparePreGeneratedFormations() {
        this.genEnemyType[0][0][0] = Varr.ENEMY_GHOST;
        this.genEnemyForm[0][0][0] = 5;
        this.genEnemyType[0][0][1] = Varr.ENEMY_BAT;
        this.genEnemyForm[0][0][1] = 5;
        this.genEnemyType[0][0][2] = Varr.ENEMY_ORC;
        this.genEnemyForm[0][0][2] = 3;
        this.genEnemyType[0][0][3] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[0][0][3] = 1;
        this.genEnemyType[0][0][4] = Varr.ENEMY_GHOST;
        this.genEnemyForm[0][0][4] = 5;
        this.genEnemyType[0][0][5] = Varr.ENEMY_ORC;
        this.genEnemyForm[0][0][5] = 4;
        this.genEnemyType[0][1][0] = Varr.ENEMY_BAT;
        this.genEnemyForm[0][1][0] = 4;
        this.genEnemyType[0][1][1] = Varr.ENEMY_ORC;
        this.genEnemyForm[0][1][1] = 4;
        this.genEnemyType[0][1][2] = Varr.ENEMY_GHOST;
        this.genEnemyForm[0][1][2] = 6;
        this.genEnemyType[0][1][3] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[0][1][3] = 2;
        this.genEnemyType[0][1][4] = Varr.ENEMY_GHOST;
        this.genEnemyForm[0][1][4] = 3;
        this.genEnemyType[0][1][5] = Varr.ENEMY_ORC;
        this.genEnemyForm[0][1][5] = 8;
        this.genEnemyType[0][2][0] = Varr.ENEMY_CANNON;
        this.genEnemyForm[0][2][0] = 1;
        this.genEnemyType[0][2][1] = Varr.ENEMY_ORC;
        this.genEnemyForm[0][2][1] = 3;
        this.genEnemyType[0][2][2] = Varr.ENEMY_GHOST;
        this.genEnemyForm[0][2][2] = 3;
        this.genEnemyType[0][2][3] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[0][2][3] = 1;
        this.genEnemyType[0][2][4] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[0][2][4] = 2;
        this.genEnemyType[0][2][5] = Varr.ENEMY_ORC;
        this.genEnemyForm[0][2][5] = 4;
        this.genEnemyType[0][3][0] = Varr.ENEMY_BAT;
        this.genEnemyForm[0][3][0] = 3;
        this.genEnemyType[0][3][1] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[0][3][1] = 3;
        this.genEnemyType[0][3][2] = Varr.ENEMY_ORC;
        this.genEnemyForm[0][3][2] = 1;
        this.genEnemyType[0][3][3] = Varr.ENEMY_GHOST;
        this.genEnemyForm[0][3][3] = 5;
        this.genEnemyType[0][3][4] = Varr.ENEMY_BAT;
        this.genEnemyForm[0][3][4] = 3;
        this.genEnemyType[0][3][5] = Varr.ENEMY_ORC;
        this.genEnemyForm[0][3][5] = 5;
        this.genEnemyType[0][4][0] = Varr.ENEMY_ORC;
        this.genEnemyForm[0][4][0] = 8;
        this.genEnemyType[0][4][1] = Varr.ENEMY_GHOST;
        this.genEnemyForm[0][4][1] = 4;
        this.genEnemyType[0][4][2] = Varr.ENEMY_BAT;
        this.genEnemyForm[0][4][2] = 5;
        this.genEnemyType[0][4][3] = Varr.ENEMY_ORC;
        this.genEnemyForm[0][4][3] = 6;
        this.genEnemyType[0][4][4] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[0][4][4] = 8;
        this.genEnemyType[0][4][5] = Varr.ENEMY_CANNON;
        this.genEnemyForm[0][4][5] = 3;
        this.genEnemyType[0][5][0] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[0][5][0] = 8;
        this.genEnemyType[0][5][1] = Varr.ENEMY_BAT;
        this.genEnemyForm[0][5][1] = 6;
        this.genEnemyType[0][5][2] = Varr.ENEMY_GHOST;
        this.genEnemyForm[0][5][2] = 5;
        this.genEnemyType[0][5][3] = Varr.ENEMY_ORC;
        this.genEnemyForm[0][5][3] = 8;
        this.genEnemyType[0][5][4] = Varr.ENEMY_GHOST;
        this.genEnemyForm[0][5][4] = 8;
        this.genEnemyType[0][5][5] = Varr.ENEMY_CANNON;
        this.genEnemyForm[0][5][5] = 2;
        this.genEnemyType[0][6][0] = Varr.ENEMY_BAT;
        this.genEnemyForm[0][6][0] = 8;
        this.genEnemyType[0][6][1] = Varr.ENEMY_GHOST;
        this.genEnemyForm[0][6][1] = 10;
        this.genEnemyType[0][6][2] = Varr.ENEMY_ORC;
        this.genEnemyForm[0][6][2] = 9;
        this.genEnemyType[0][6][3] = Varr.ENEMY_CANNON;
        this.genEnemyForm[0][6][3] = 0;
        this.genEnemyType[0][6][4] = Varr.ENEMY_GHOST;
        this.genEnemyForm[0][6][4] = 8;
        this.genEnemyType[0][6][5] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[0][6][5] = 7;
        this.genEnemyType[0][7][0] = Varr.ENEMY_ORC;
        this.genEnemyForm[0][7][0] = 10;
        this.genEnemyType[0][7][1] = Varr.ENEMY_GHOST;
        this.genEnemyForm[0][7][1] = 8;
        this.genEnemyType[0][7][2] = Varr.ENEMY_CANNON;
        this.genEnemyForm[0][7][2] = 3;
        this.genEnemyType[0][7][3] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[0][7][3] = 8;
        this.genEnemyType[0][7][4] = Varr.ENEMY_GHOST;
        this.genEnemyForm[0][7][4] = 7;
        this.genEnemyType[0][7][5] = Varr.ENEMY_BAT;
        this.genEnemyForm[0][7][5] = 10;
        this.genEnemyType[0][8][0] = Varr.ENEMY_GHOST;
        this.genEnemyForm[0][8][0] = 7;
        this.genEnemyType[0][8][1] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[0][8][1] = 10;
        this.genEnemyType[0][8][2] = Varr.ENEMY_BAT;
        this.genEnemyForm[0][8][2] = 7;
        this.genEnemyType[0][8][3] = Varr.ENEMY_CANNON;
        this.genEnemyForm[0][8][3] = 3;
        this.genEnemyType[0][8][4] = Varr.ENEMY_ORC;
        this.genEnemyForm[0][8][4] = 9;
        this.genEnemyType[0][8][5] = Varr.ENEMY_GHOST;
        this.genEnemyForm[0][8][5] = 10;
        this.genEnemyType[0][9][0] = Varr.ENEMY_GHOST;
        this.genEnemyForm[0][9][0] = 7;
        this.genEnemyType[0][9][1] = Varr.ENEMY_BAT;
        this.genEnemyForm[0][9][1] = 15;
        this.genEnemyType[0][9][2] = Varr.ENEMY_ORC;
        this.genEnemyForm[0][9][2] = 10;
        this.genEnemyType[0][9][3] = Varr.ENEMY_CANNON;
        this.genEnemyForm[0][9][3] = 2;
        this.genEnemyType[0][9][4] = Varr.ENEMY_GHOST;
        this.genEnemyForm[0][9][4] = 10;
        this.genEnemyType[0][9][5] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[0][9][5] = 4;
        this.genEnemyType[1][0][0] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[1][0][0] = 0;
        this.genEnemyType[1][0][1] = Varr.ENEMY_BAT;
        this.genEnemyForm[1][0][1] = 1;
        this.genEnemyType[1][0][2] = Varr.ENEMY_ORC;
        this.genEnemyForm[1][0][2] = 3;
        this.genEnemyType[1][0][3] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[1][0][3] = 0;
        this.genEnemyType[1][0][4] = Varr.ENEMY_ORC;
        this.genEnemyForm[1][0][4] = 3;
        this.genEnemyType[1][0][5] = Varr.ENEMY_BAT;
        this.genEnemyForm[1][0][5] = 3;
        this.genEnemyType[1][1][0] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[1][1][0] = 1;
        this.genEnemyType[1][1][1] = Varr.ENEMY_ORC;
        this.genEnemyForm[1][1][1] = 3;
        this.genEnemyType[1][1][2] = Varr.ENEMY_GHOST;
        this.genEnemyForm[1][1][2] = 2;
        this.genEnemyType[1][1][3] = Varr.ENEMY_ORC;
        this.genEnemyForm[1][1][3] = 1;
        this.genEnemyType[1][1][4] = Varr.ENEMY_ORC;
        this.genEnemyForm[1][1][4] = 2;
        this.genEnemyType[1][1][5] = Varr.ENEMY_ORC;
        this.genEnemyForm[1][1][5] = 2;
        this.genEnemyType[1][2][0] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[1][2][0] = 0;
        this.genEnemyType[1][2][1] = Varr.ENEMY_BAT;
        this.genEnemyForm[1][2][1] = 2;
        this.genEnemyType[1][2][2] = Varr.ENEMY_ORC;
        this.genEnemyForm[1][2][2] = 3;
        this.genEnemyType[1][2][3] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[1][2][3] = 1;
        this.genEnemyType[1][2][4] = Varr.ENEMY_GHOST;
        this.genEnemyForm[1][2][4] = 3;
        this.genEnemyType[1][2][5] = Varr.ENEMY_BAT;
        this.genEnemyForm[1][2][5] = 4;
        this.genEnemyType[1][3][0] = Varr.ENEMY_GHOST;
        this.genEnemyForm[1][3][0] = 2;
        this.genEnemyType[1][3][1] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[1][3][1] = 1;
        this.genEnemyType[1][3][2] = Varr.ENEMY_BAT;
        this.genEnemyForm[1][3][2] = 3;
        this.genEnemyType[1][3][3] = Varr.ENEMY_ORC;
        this.genEnemyForm[1][3][3] = 5;
        this.genEnemyType[1][3][4] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[1][3][4] = 3;
        this.genEnemyType[1][3][5] = Varr.ENEMY_BAT;
        this.genEnemyForm[1][3][5] = 4;
        this.genEnemyType[1][4][0] = Varr.ENEMY_ORC;
        this.genEnemyForm[1][4][0] = 4;
        this.genEnemyType[1][4][1] = Varr.ENEMY_GHOST;
        this.genEnemyForm[1][4][1] = 2;
        this.genEnemyType[1][4][2] = Varr.ENEMY_BAT;
        this.genEnemyForm[1][4][2] = 3;
        this.genEnemyType[1][4][3] = Varr.ENEMY_ORC;
        this.genEnemyForm[1][4][3] = 4;
        this.genEnemyType[1][4][4] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[1][4][4] = 6;
        this.genEnemyType[1][4][5] = Varr.ENEMY_CANNON;
        this.genEnemyForm[1][4][5] = 1;
        this.genEnemyType[1][5][0] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[1][5][0] = 0;
        this.genEnemyType[1][5][1] = Varr.ENEMY_BAT;
        this.genEnemyForm[1][5][1] = 1;
        this.genEnemyType[1][5][2] = Varr.ENEMY_GHOST;
        this.genEnemyForm[1][5][2] = 3;
        this.genEnemyType[1][5][3] = Varr.ENEMY_ORC;
        this.genEnemyForm[1][5][3] = 4;
        this.genEnemyType[1][5][4] = Varr.ENEMY_GHOST;
        this.genEnemyForm[1][5][4] = 2;
        this.genEnemyType[1][5][5] = Varr.ENEMY_CANNON;
        this.genEnemyForm[1][5][5] = 0;
        this.genEnemyType[1][6][0] = Varr.ENEMY_BAT;
        this.genEnemyForm[1][6][0] = 2;
        this.genEnemyType[1][6][1] = Varr.ENEMY_GHOST;
        this.genEnemyForm[1][6][1] = 1;
        this.genEnemyType[1][6][2] = Varr.ENEMY_ORC;
        this.genEnemyForm[1][6][2] = 3;
        this.genEnemyType[1][6][3] = Varr.ENEMY_CANNON;
        this.genEnemyForm[1][6][3] = 0;
        this.genEnemyType[1][6][4] = Varr.ENEMY_GHOST;
        this.genEnemyForm[1][6][4] = 2;
        this.genEnemyType[1][6][5] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[1][6][5] = 5;
        this.genEnemyType[1][7][0] = Varr.ENEMY_ORC;
        this.genEnemyForm[1][7][0] = 5;
        this.genEnemyType[1][7][1] = Varr.ENEMY_GHOST;
        this.genEnemyForm[1][7][1] = 0;
        this.genEnemyType[1][7][2] = Varr.ENEMY_BAT;
        this.genEnemyForm[1][7][2] = 2;
        this.genEnemyType[1][7][3] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[1][7][3] = 5;
        this.genEnemyType[1][7][4] = Varr.ENEMY_GHOST;
        this.genEnemyForm[1][7][4] = 2;
        this.genEnemyType[1][7][5] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[1][7][5] = 5;
        this.genEnemyType[1][8][0] = Varr.ENEMY_BAT;
        this.genEnemyForm[1][8][0] = 4;
        this.genEnemyType[1][8][1] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[1][8][1] = 0;
        this.genEnemyType[1][8][2] = Varr.ENEMY_BAT;
        this.genEnemyForm[1][8][2] = 1;
        this.genEnemyType[1][8][3] = Varr.ENEMY_CANNON;
        this.genEnemyForm[1][8][3] = 3;
        this.genEnemyType[1][8][4] = Varr.ENEMY_ORC;
        this.genEnemyForm[1][8][4] = 2;
        this.genEnemyType[1][8][5] = Varr.ENEMY_GHOST;
        this.genEnemyForm[1][8][5] = 1;
        this.genEnemyType[1][9][0] = Varr.ENEMY_GHOST;
        this.genEnemyForm[1][9][0] = 5;
        this.genEnemyType[1][9][1] = Varr.ENEMY_BAT;
        this.genEnemyForm[1][9][1] = 2;
        this.genEnemyType[1][9][2] = Varr.ENEMY_ORC;
        this.genEnemyForm[1][9][2] = 2;
        this.genEnemyType[1][9][3] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[1][9][3] = 0;
        this.genEnemyType[1][9][4] = Varr.ENEMY_GHOST;
        this.genEnemyForm[1][9][4] = 1;
        this.genEnemyType[1][9][5] = Varr.ENEMY_ORC;
        this.genEnemyForm[1][9][5] = 4;
        this.genEnemyType[2][0][0] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[2][0][0] = 0;
        this.genEnemyType[2][0][1] = Varr.ENEMY_BAT;
        this.genEnemyForm[2][0][1] = 1;
        this.genEnemyType[2][0][2] = Varr.ENEMY_ORC;
        this.genEnemyForm[2][0][2] = 3;
        this.genEnemyType[2][0][3] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[2][0][3] = 0;
        this.genEnemyType[2][0][4] = Varr.ENEMY_ORC;
        this.genEnemyForm[2][0][4] = 3;
        this.genEnemyType[2][0][5] = Varr.ENEMY_BAT;
        this.genEnemyForm[2][0][5] = 3;
        this.genEnemyType[2][1][0] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[2][1][0] = 1;
        this.genEnemyType[2][1][1] = Varr.ENEMY_ORC;
        this.genEnemyForm[2][1][1] = 3;
        this.genEnemyType[2][1][2] = Varr.ENEMY_GHOST;
        this.genEnemyForm[2][1][2] = 2;
        this.genEnemyType[2][1][3] = Varr.ENEMY_ORC;
        this.genEnemyForm[2][1][3] = 1;
        this.genEnemyType[2][1][4] = Varr.ENEMY_ORC;
        this.genEnemyForm[2][1][4] = 2;
        this.genEnemyType[2][1][5] = Varr.ENEMY_ORC;
        this.genEnemyForm[2][1][5] = 2;
        this.genEnemyType[2][2][0] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[2][2][0] = 0;
        this.genEnemyType[2][2][1] = Varr.ENEMY_BAT;
        this.genEnemyForm[2][2][1] = 2;
        this.genEnemyType[2][2][2] = Varr.ENEMY_ORC;
        this.genEnemyForm[2][2][2] = 3;
        this.genEnemyType[2][2][3] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[2][2][3] = 1;
        this.genEnemyType[2][2][4] = Varr.ENEMY_GHOST;
        this.genEnemyForm[2][2][4] = 3;
        this.genEnemyType[2][2][5] = Varr.ENEMY_BAT;
        this.genEnemyForm[2][2][5] = 4;
        this.genEnemyType[2][3][0] = Varr.ENEMY_GHOST;
        this.genEnemyForm[2][3][0] = 2;
        this.genEnemyType[2][3][1] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[2][3][1] = 1;
        this.genEnemyType[2][3][2] = Varr.ENEMY_BAT;
        this.genEnemyForm[2][3][2] = 3;
        this.genEnemyType[2][3][3] = Varr.ENEMY_ORC;
        this.genEnemyForm[2][3][3] = 5;
        this.genEnemyType[2][3][4] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[2][3][4] = 3;
        this.genEnemyType[2][3][5] = Varr.ENEMY_BAT;
        this.genEnemyForm[2][3][5] = 4;
        this.genEnemyType[2][4][0] = Varr.ENEMY_ORC;
        this.genEnemyForm[2][4][0] = 4;
        this.genEnemyType[2][4][1] = Varr.ENEMY_GHOST;
        this.genEnemyForm[2][4][1] = 2;
        this.genEnemyType[2][4][2] = Varr.ENEMY_BAT;
        this.genEnemyForm[2][4][2] = 3;
        this.genEnemyType[2][4][3] = Varr.ENEMY_ORC;
        this.genEnemyForm[2][4][3] = 4;
        this.genEnemyType[2][4][4] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[2][4][4] = 6;
        this.genEnemyType[2][4][5] = Varr.ENEMY_CANNON;
        this.genEnemyForm[2][4][5] = 1;
        this.genEnemyType[2][5][0] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[2][5][0] = 0;
        this.genEnemyType[2][5][1] = Varr.ENEMY_BAT;
        this.genEnemyForm[2][5][1] = 1;
        this.genEnemyType[2][5][2] = Varr.ENEMY_GHOST;
        this.genEnemyForm[2][5][2] = 3;
        this.genEnemyType[2][5][3] = Varr.ENEMY_ORC;
        this.genEnemyForm[2][5][3] = 4;
        this.genEnemyType[2][5][4] = Varr.ENEMY_GHOST;
        this.genEnemyForm[2][5][4] = 2;
        this.genEnemyType[2][5][5] = Varr.ENEMY_CANNON;
        this.genEnemyForm[2][5][5] = 0;
        this.genEnemyType[2][6][0] = Varr.ENEMY_BAT;
        this.genEnemyForm[2][6][0] = 2;
        this.genEnemyType[2][6][1] = Varr.ENEMY_GHOST;
        this.genEnemyForm[2][6][1] = 1;
        this.genEnemyType[2][6][2] = Varr.ENEMY_ORC;
        this.genEnemyForm[2][6][2] = 3;
        this.genEnemyType[2][6][3] = Varr.ENEMY_CANNON;
        this.genEnemyForm[2][6][3] = 0;
        this.genEnemyType[2][6][4] = Varr.ENEMY_GHOST;
        this.genEnemyForm[2][6][4] = 2;
        this.genEnemyType[2][6][5] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[2][6][5] = 5;
        this.genEnemyType[2][7][0] = Varr.ENEMY_ORC;
        this.genEnemyForm[2][7][0] = 5;
        this.genEnemyType[2][7][1] = Varr.ENEMY_GHOST;
        this.genEnemyForm[2][7][1] = 0;
        this.genEnemyType[2][7][2] = Varr.ENEMY_BAT;
        this.genEnemyForm[2][7][2] = 2;
        this.genEnemyType[2][7][3] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[2][7][3] = 5;
        this.genEnemyType[2][7][4] = Varr.ENEMY_GHOST;
        this.genEnemyForm[2][7][4] = 2;
        this.genEnemyType[2][7][5] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[2][7][5] = 5;
        this.genEnemyType[2][8][0] = Varr.ENEMY_BAT;
        this.genEnemyForm[2][8][0] = 4;
        this.genEnemyType[2][8][1] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[2][8][1] = 0;
        this.genEnemyType[2][8][2] = Varr.ENEMY_BAT;
        this.genEnemyForm[2][8][2] = 1;
        this.genEnemyType[2][8][3] = Varr.ENEMY_CANNON;
        this.genEnemyForm[2][8][3] = 3;
        this.genEnemyType[2][8][4] = Varr.ENEMY_ORC;
        this.genEnemyForm[2][8][4] = 2;
        this.genEnemyType[2][8][5] = Varr.ENEMY_GHOST;
        this.genEnemyForm[2][8][5] = 1;
        this.genEnemyType[2][9][0] = Varr.ENEMY_GHOST;
        this.genEnemyForm[2][9][0] = 5;
        this.genEnemyType[2][9][1] = Varr.ENEMY_BAT;
        this.genEnemyForm[2][9][1] = 2;
        this.genEnemyType[2][9][2] = Varr.ENEMY_ORC;
        this.genEnemyForm[2][9][2] = 2;
        this.genEnemyType[2][9][3] = Varr.ENEMY_GOLEM;
        this.genEnemyForm[2][9][3] = 0;
        this.genEnemyType[2][9][4] = Varr.ENEMY_GHOST;
        this.genEnemyForm[2][9][4] = 1;
        this.genEnemyType[2][9][5] = Varr.ENEMY_ORC;
        this.genEnemyForm[2][9][5] = 4;
    }

    static {
        stopCountDown = false;
        iTableAnimation = 0;
        hideScreen = false;
        tomeOfPowerInUsage = false;
        tutorialGame = 0;
        SIN_TABLE = new int[]{0, 4, 8, 13, 17, 22, 26, 31, 35, 40, 44, 48, 53, 57, 61, 66, 70, 74, 79, 83, 87, 91, 95, 100, 104, 108, 112, 116, 120, 124, 127, 131, 135, 139, 143, 146, 150, 154, 157, 161, 164, 167, 171, 174, 177, 181, 184, 187, 190, 193, 196, 198, 201, 204, 207, 209, 212, 214, 217, 219, 221, 223, 226, 228, 230, 232, 233, 235, 237, 238, 240, 242, 243, 244, 246, 247, 248, 249, 250, 251, 252, 252, 253, 254, 254, 255, 255, 255, 255, 255, 256, 255, 255, 255, 255, 255, 254, 254, 253, 252, 252, 251, 250, 249, 248, 247, 246, 244, 243, 242, 240, 238, 237, 235, 233, 232, 230, 228, 226, 223, 221, 219, 217, 214, 212, 209, 207, 204, 201, 198, 196, 193, 190, 187, 184, 181, 177, 174, 171, 167, 164, 161, 157, 154, 150, 146, 143, 139, 135, 131, 127, 124, 120, 116, 112, 108, 104, 100, 95, 91, 87, 83, 79, 74, 70, 66, 61, 57, 53, 48, 44, 40, 35, 31, 26, 22, 17, 13, 8, 4, 0, -4, -8, -13, -17, -22, -26, -31, -35, -40, -44, -48, -53, -57, -61, -66, -70, -74, -79, -83, -87, -91, -95, -100, -104, -108, -112, -116, -120, -124, -127, -131, -135, -139, -143, -146, -150, -154, -157, -161, -164, -167, -171, -174, -177, -181, -184, -187, -190, -193, -196, -198, -201, -204, -207, -209, -212, -214, -217, -219, -221, -223, -226, -228, -230, -232, -233, -235, -237, -238, -240, -242, -243, -244, -246, -247, -248, -249, -250, -251, -252, -252, -253, -254, -254, -255, -255, -255, -255, -255, -256, -255, -255, -255, -255, -255, -254, -254, -253, -252, -252, -251, -250, -249, -248, -247, -246, -244, -243, -242, -240, -238, -237, -235, -233, -232, -230, -228, -226, -223, -221, -219, -217, -214, -212, -209, -207, -204, -201, -198, -196, -193, -190, -187, -184, -181, -177, -174, -171, -167, -164, -161, -157, -154, -150, -146, -143, -139, -135, -131, -128, -124, -120, -116, -112, -108, -104, -100, -95, -91, -87, -83, -79, -74, -70, -66, -61, -57, -53, -48, -44, -40, -35, -31, -26, -22, -17, -13, -8, -4};
        CosTable90 = new int[]{1024, 1023, 1023, 1022, 1021, 1020, 1018, 1016, 1014, 1011, 1008, 1005, 1001, 997, 993, 989, 984, 979, 973, 968, 962, 955, 949, 942, 935, 928, 920, 912, 904, 895, 886, 877, 868, 858, 848, 838, 828, 817, 806, 795, 784, 772, 760, 748, 736, 724, 711, 698, 685, 671, 658, 644, 630, 616, 601, 587, 572, 557, 542, 527, 512, 496, 480, 464, 448, 432, 416, 400, 383, 366, 350, 333, 316, 299, 282, 265, 247, 230, 212, 195, 177, 160, 142, 124, 107, 89, 71, 53, 35, 17, 0};
        AtanTable = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 10, 11, 12, 13, 14, 16, 17, 18, 19, 20, 21, 22, 23, 25, 26, 27, 28, 29, 30, 30, 31, 32, 33, 34, 35, 36, 37, 37, 38, 39, 40, 40, 41, 42, 43, 43, 44, 45};
    }
}

