/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import sk.inlogic.MainCanvas;
import sk.inlogic.ScreenShop;
import sk.inlogic.ShopItems;
import sk.inlogic.util.RandomNum;

public class Player {
    private static int cash;
    private static int stage;
    private static int generatorSet;
    public static final int STAT_STRENGTH = 0;
    public static final int STAT_HEALTH = 1;
    public static final int STAT_AGILITY = 2;
    public static final int STAT_CRITICAL = 3;
    public static final int STAT_KNOCKBACK = 4;
    public static final int STAT_MANA = 5;
    public static final int MAX_STATS = 6;
    public static int[] STAT_MAX;
    public static int lastOfferId;
    public static boolean towerWasUpgraded;
    public static int towerUpgradeLvl;
    private static int[] stat;
    private static int[] statBonusStaff;
    public static int[] statBonusRobe;
    private static int[] SLOT_ITEM;
    private static int ACTIVE_STAFF;
    private static int ACTIVE_ROBE;
    public static boolean playerRefusedLimitedOffer;
    private static int[] InventoryItemStatus;
    private static int[] SpellStatus;
    private static int[] ConsumableCounts;
    private static int score;
    public static int streak;
    public static int loseCountInRow;
    public static int dieHintStep;
    private static String strStrName;
    private static String strDexName;
    private static String strCritName;
    private static String strHealthName;
    private static String strKnockName;
    private static String strManaName;
    private static String strAllEquipText;
    private static String strNextLevelText;
    public static int enemiesStronger;
    public static boolean diedMoreThanOnce;
    public static int diedInLvlFifteen;
    public static int lastDropCountGenerated;
    public static int hintCounter;

    public Player() {
        this.setDefault();
    }

    public void setDefault() {
        Player.stat[0] = 0;
        Player.stat[2] = 0;
        Player.stat[3] = 0;
        Player.stat[1] = 1000;
        Player.stat[4] = 0;
        Player.stat[5] = 50;
        Player.ConsumableCounts[0] = 1;
        Player.ConsumableCounts[1] = 1;
        Player.ConsumableCounts[2] = 1;
        Player.ConsumableCounts[3] = 0;
        Player.ConsumableCounts[4] = 0;
        Player.ConsumableCounts[5] = 2;
        Player.SpellStatus[0] = 1;
        Player.SLOT_ITEM[0] = -9999;
        Player.SLOT_ITEM[1] = -9999;
        Player.SLOT_ITEM[2] = -9999;
    }

    public static String getStatNameById(int id) {
        String statName = "";
        if (id == 0) {
            statName = strStrName;
        }
        if (id == 2) {
            statName = strDexName;
        }
        if (id == 3) {
            statName = strCritName;
        }
        if (id == 1) {
            statName = strHealthName;
        }
        if (id == 4) {
            statName = strKnockName;
        }
        if (id == 5) {
            statName = strManaName;
        }
        return statName;
    }

    public static String getInventoryItemBonusesStringed(int id) {
        int oldId;
        boolean isThereAnyBonus;
        String result;
        String bonusDesc;
        block8: {
            block6: {
                block7: {
                    if (strStrName == "") {
                        strStrName = MainCanvas.texts.getString("STRENGTH");
                        strDexName = MainCanvas.texts.getString("AGILITY");
                        strCritName = MainCanvas.texts.getString("CRITICAL");
                        strHealthName = MainCanvas.texts.getString("HEALTH");
                        strKnockName = MainCanvas.texts.getString("KNOCKBACK");
                        strManaName = MainCanvas.texts.getString("MANA");
                        strAllEquipText = MainCanvas.texts.getString("ALL_EQUIP_TEXT");
                        strNextLevelText = MainCanvas.texts.getString("STAT_TEXT_ADD2WB");
                    }
                    bonusDesc = strAllEquipText + " ";
                    result = "";
                    isThereAnyBonus = false;
                    if (id <= 8) break block6;
                    oldId = ACTIVE_STAFF;
                    ACTIVE_STAFF = id;
                    Player.setStatBonuses();
                    for (int i = 0; i < 6; ++i) {
                        if (statBonusStaff[i] <= 0) continue;
                        isThereAnyBonus = true;
                        result = i == 0 ? result + " ^ +" + statBonusStaff[i] * 20 + " " + Player.getStatNameById(i) : (i == 2 ? result + " ^ +" + statBonusStaff[i] * 10 + "% " + Player.getStatNameById(i) : (i == 3 ? result + " ^ +" + statBonusStaff[i] * 2 + "% " + Player.getStatNameById(i) : result + " ^ +" + statBonusStaff[i] + " " + Player.getStatNameById(i)));
                    }
                    if (id != 11 || Player.getInventoryItemStatus(id - 6) > 5) break block7;
                    result = result + " ^ DOUBLE SHOT";
                    break block8;
                }
                if (id != 11 || Player.getInventoryItemStatus(id - 6) <= 5) break block8;
                result = result + " ^ TRIPPLE SHOT";
                break block8;
            }
            oldId = ACTIVE_ROBE;
            ACTIVE_ROBE = id;
            Player.setStatBonuses();
            for (int i = 0; i < 6; ++i) {
                if (statBonusRobe[i] <= 0) continue;
                isThereAnyBonus = true;
                result = i == 0 ? result + " ^ +" + statBonusRobe[i] * 20 + " " + Player.getStatNameById(i) : (i == 2 ? result + " ^ +" + statBonusRobe[i] * 10 + "% " + Player.getStatNameById(i) : (i == 3 ? result + " ^ +" + statBonusRobe[i] * 2 + "% " + Player.getStatNameById(i) : result + " ^ +" + statBonusRobe[i] + " " + Player.getStatNameById(i)));
            }
        }
        Player.resetBonuses();
        if (id > 8) {
            ACTIVE_STAFF = oldId;
        } else {
            ACTIVE_ROBE = oldId;
        }
        Player.setStatBonuses();
        if (!isThereAnyBonus) {
            bonusDesc = "";
        }
        return bonusDesc + result;
    }

    public static String getInventoryItemBonusesStringedForNextLevel(int id) {
        String res;
        block6: {
            int oldId;
            boolean isThereAnyBonus;
            String result;
            String bonusDesc;
            block9: {
                block7: {
                    block8: {
                        res = "";
                        if (ShopItems.MAX_VALUE[id] <= Player.getInventoryItemStatus(id - 6) && Player.getInventoryItemStatus(id - 6) != 0) break block6;
                        if (strStrName == "") {
                            strStrName = MainCanvas.texts.getString("STRENGTH");
                            strDexName = MainCanvas.texts.getString("AGILITY");
                            strCritName = MainCanvas.texts.getString("CRITICAL");
                            strHealthName = MainCanvas.texts.getString("HEALTH");
                            strKnockName = MainCanvas.texts.getString("KNOCKBACK");
                            strManaName = MainCanvas.texts.getString("MANA");
                            strAllEquipText = MainCanvas.texts.getString("ALL_EQUIP_TEXT");
                            strNextLevelText = MainCanvas.texts.getString("STAT_TEXT_ADD2WB");
                        }
                        bonusDesc = strNextLevelText + " ";
                        result = "";
                        isThereAnyBonus = false;
                        if (id <= 8) break block7;
                        oldId = ACTIVE_STAFF;
                        ACTIVE_STAFF = id;
                        Player.setInventoryItemValue(ACTIVE_STAFF - 6, Player.getInventoryItemStatus(ACTIVE_STAFF - 6) + 1);
                        Player.setStatBonuses();
                        for (int i = 0; i < 6; ++i) {
                            if (statBonusStaff[i] <= 0) continue;
                            isThereAnyBonus = true;
                            result = i == 0 ? result + " ^ +" + statBonusStaff[i] * 20 + " " + Player.getStatNameById(i) : (i == 2 ? result + " ^ +" + statBonusStaff[i] * 10 + "% " + Player.getStatNameById(i) : (i == 3 ? result + " ^ +" + statBonusStaff[i] * 2 + "% " + Player.getStatNameById(i) : result + " ^ +" + statBonusStaff[i] + " " + Player.getStatNameById(i)));
                        }
                        if (id != 11 || Player.getInventoryItemStatus(id - 6) > 5) break block8;
                        result = result + " ^ DOUBLE SHOT";
                        break block9;
                    }
                    if (id != 11 || Player.getInventoryItemStatus(id - 6) <= 5) break block9;
                    result = result + " ^ TRIPPLE SHOT";
                    break block9;
                }
                oldId = ACTIVE_ROBE;
                ACTIVE_ROBE = id;
                Player.setInventoryItemValue(ACTIVE_ROBE - 6, Player.getInventoryItemStatus(ACTIVE_ROBE - 6) + 1);
                Player.setStatBonuses();
                for (int i = 0; i < 6; ++i) {
                    if (statBonusRobe[i] <= 0) continue;
                    isThereAnyBonus = true;
                    result = i == 0 ? result + " ^ +" + statBonusRobe[i] * 20 + " " + Player.getStatNameById(i) : (i == 2 ? result + " ^ +" + statBonusRobe[i] * 10 + "% " + Player.getStatNameById(i) : (i == 3 ? result + " ^ +" + statBonusRobe[i] * 2 + "% " + Player.getStatNameById(i) : result + " ^ +" + statBonusRobe[i] + " " + Player.getStatNameById(i)));
                }
            }
            Player.resetBonuses();
            if (id > 8) {
                Player.setInventoryItemValue(ACTIVE_STAFF - 6, Player.getInventoryItemStatus(ACTIVE_STAFF - 6) - 1);
                ACTIVE_STAFF = oldId;
            } else {
                Player.setInventoryItemValue(ACTIVE_ROBE - 6, Player.getInventoryItemStatus(ACTIVE_ROBE - 6) - 1);
                ACTIVE_ROBE = oldId;
            }
            Player.setStatBonuses();
            if (!isThereAnyBonus) {
                bonusDesc = "";
            }
            res = bonusDesc + result;
        }
        return res;
    }

    public static void incStage() {
        ++stage;
    }

    public static void resetBonuses() {
        for (int i = 0; i < 6; ++i) {
            Player.statBonusStaff[i] = 0;
            Player.statBonusRobe[i] = 0;
        }
    }

    public static int getPlayerBaseDamage() {
        int baseDmgCalculated = Player.getCalculatedDamage(Player.getStatValueExBonus(0));
        int bonusDmgCalculated = Player.getStatBonus(0) * 20;
        return baseDmgCalculated + bonusDmgCalculated;
    }

    public static int getPlayerBaseDamageForNextLevel() {
        int baseDmgCalculated = Player.getCalculatedDamage(Player.getStatValueExBonus(0) + 1);
        int bonusDmgCalculated = Player.getStatBonus(0) * 20;
        return baseDmgCalculated + bonusDmgCalculated;
    }

    public static int getCalculatedDamage(int lvl) {
        return 110 + 20 * lvl;
    }

    public static void setStatBonuses() {
        if (Player.getEquipedStaff() == 9) {
            if (Player.getInventoryItemStatus(3) == 1) {
                Player.statBonusStaff[2] = 1;
            }
            if (Player.getInventoryItemStatus(3) == 2) {
                Player.statBonusStaff[2] = 2;
                Player.statBonusStaff[0] = 1;
            }
            if (Player.getInventoryItemStatus(3) == 3) {
                Player.statBonusStaff[2] = 2;
                Player.statBonusStaff[0] = 2;
            }
            if (Player.getInventoryItemStatus(3) == 4) {
                Player.statBonusStaff[2] = 3;
                Player.statBonusStaff[0] = 2;
            }
            if (Player.getInventoryItemStatus(3) == 5) {
                Player.statBonusStaff[2] = 3;
                Player.statBonusStaff[0] = 3;
            }
            if (Player.getInventoryItemStatus(3) == 6) {
                Player.statBonusStaff[2] = 4;
                Player.statBonusStaff[0] = 3;
            }
            if (Player.getInventoryItemStatus(3) == 7) {
                Player.statBonusStaff[2] = 4;
                Player.statBonusStaff[0] = 3;
            }
        }
        if (Player.getEquipedStaff() == 10) {
            if (Player.getInventoryItemStatus(4) == 1) {
                Player.statBonusStaff[0] = 3;
                Player.statBonusStaff[2] = 2;
                Player.statBonusStaff[4] = 2;
            }
            if (Player.getInventoryItemStatus(4) == 2) {
                Player.statBonusStaff[0] = 4;
                Player.statBonusStaff[2] = 2;
                Player.statBonusStaff[4] = 3;
            }
            if (Player.getInventoryItemStatus(4) == 3) {
                Player.statBonusStaff[0] = 6;
                Player.statBonusStaff[2] = 2;
                Player.statBonusStaff[4] = 3;
            }
            if (Player.getInventoryItemStatus(4) == 4) {
                Player.statBonusStaff[0] = 6;
                Player.statBonusStaff[2] = 3;
                Player.statBonusStaff[4] = 4;
            }
            if (Player.getInventoryItemStatus(4) == 5) {
                Player.statBonusStaff[0] = 8;
                Player.statBonusStaff[2] = 3;
                Player.statBonusStaff[4] = 4;
            }
            if (Player.getInventoryItemStatus(4) == 6) {
                Player.statBonusStaff[0] = 9;
                Player.statBonusStaff[2] = 3;
                Player.statBonusStaff[4] = 5;
            }
            if (Player.getInventoryItemStatus(4) == 7) {
                Player.statBonusStaff[0] = 11;
                Player.statBonusStaff[2] = 3;
                Player.statBonusStaff[4] = 5;
            }
            if (Player.getInventoryItemStatus(4) == 8) {
                Player.statBonusStaff[0] = 13;
                Player.statBonusStaff[2] = 4;
                Player.statBonusStaff[4] = 6;
            }
            if (Player.getInventoryItemStatus(4) == 9) {
                Player.statBonusStaff[0] = 13;
                Player.statBonusStaff[2] = 4;
                Player.statBonusStaff[4] = 6;
            }
        }
        if (Player.getEquipedStaff() == 11) {
            if (Player.getInventoryItemStatus(5) == 1) {
                Player.statBonusStaff[0] = 10;
                Player.statBonusStaff[2] = 3;
                Player.statBonusStaff[4] = 4;
                Player.statBonusStaff[3] = 1;
            }
            if (Player.getInventoryItemStatus(5) == 2) {
                Player.statBonusStaff[0] = 12;
                Player.statBonusStaff[2] = 3;
                Player.statBonusStaff[4] = 4;
                Player.statBonusStaff[3] = 1;
            }
            if (Player.getInventoryItemStatus(5) == 3) {
                Player.statBonusStaff[0] = 13;
                Player.statBonusStaff[2] = 3;
                Player.statBonusStaff[4] = 4;
                Player.statBonusStaff[3] = 1;
            }
            if (Player.getInventoryItemStatus(5) == 4) {
                Player.statBonusStaff[0] = 13;
                Player.statBonusStaff[2] = 3;
                Player.statBonusStaff[4] = 4;
                Player.statBonusStaff[3] = 2;
            }
            if (Player.getInventoryItemStatus(5) == 5) {
                Player.statBonusStaff[0] = 13;
                Player.statBonusStaff[2] = 3;
                Player.statBonusStaff[4] = 5;
                Player.statBonusStaff[3] = 2;
            }
            if (Player.getInventoryItemStatus(5) == 6) {
                Player.statBonusStaff[0] = 14;
                Player.statBonusStaff[2] = 3;
                Player.statBonusStaff[4] = 5;
                Player.statBonusStaff[3] = 3;
            }
            if (Player.getInventoryItemStatus(5) == 7) {
                Player.statBonusStaff[0] = 16;
                Player.statBonusStaff[2] = 3;
                Player.statBonusStaff[4] = 5;
                Player.statBonusStaff[3] = 3;
            }
            if (Player.getInventoryItemStatus(5) == 8) {
                Player.statBonusStaff[0] = 16;
                Player.statBonusStaff[2] = 3;
                Player.statBonusStaff[4] = 6;
                Player.statBonusStaff[3] = 4;
            }
            if (Player.getInventoryItemStatus(5) == 9) {
                Player.statBonusStaff[0] = 18;
                Player.statBonusStaff[2] = 3;
                Player.statBonusStaff[4] = 6;
                Player.statBonusStaff[3] = 4;
            }
            if (Player.getInventoryItemStatus(5) == 10) {
                Player.statBonusStaff[0] = 18;
                Player.statBonusStaff[2] = 3;
                Player.statBonusStaff[4] = 6;
                Player.statBonusStaff[3] = 5;
            }
            if (Player.getInventoryItemStatus(5) == 11) {
                Player.statBonusStaff[0] = 20;
                Player.statBonusStaff[2] = 3;
                Player.statBonusStaff[4] = 5;
                Player.statBonusStaff[3] = 6;
            }
            if (Player.getInventoryItemStatus(5) == 12) {
                Player.statBonusStaff[0] = 20;
                Player.statBonusStaff[2] = 3;
                Player.statBonusStaff[4] = 5;
                Player.statBonusStaff[3] = 6;
            }
        }
        if (Player.getEquipedRobe() == 6) {
            if (Player.getInventoryItemStatus(0) == 1) {
                Player.statBonusRobe[1] = 300;
            }
            if (Player.getInventoryItemStatus(0) == 2) {
                Player.statBonusRobe[1] = 450;
                Player.statBonusRobe[3] = 2;
            }
            if (Player.getInventoryItemStatus(0) == 3) {
                Player.statBonusRobe[1] = 600;
                Player.statBonusRobe[3] = 2;
            }
            if (Player.getInventoryItemStatus(0) == 4) {
                Player.statBonusRobe[1] = 750;
                Player.statBonusRobe[3] = 4;
            }
            if (Player.getInventoryItemStatus(0) == 5) {
                Player.statBonusRobe[1] = 900;
                Player.statBonusRobe[3] = 4;
            }
            if (Player.getInventoryItemStatus(0) == 6) {
                Player.statBonusRobe[1] = 300;
                Player.statBonusRobe[3] = 3;
            }
            if (Player.getInventoryItemStatus(0) == 7) {
                Player.statBonusRobe[1] = 400;
                Player.statBonusRobe[3] = 3;
            }
            if (Player.getInventoryItemStatus(0) == 8) {
                Player.statBonusRobe[1] = 400;
                Player.statBonusRobe[3] = 4;
            }
            if (Player.getInventoryItemStatus(0) == 9) {
                Player.statBonusRobe[1] = 500;
                Player.statBonusRobe[3] = 4;
            }
            if (Player.getInventoryItemStatus(0) == 10) {
                Player.statBonusRobe[1] = 500;
                Player.statBonusRobe[3] = 5;
            }
        }
        if (Player.getEquipedRobe() == 7) {
            if (Player.getInventoryItemStatus(1) == 1) {
                Player.statBonusRobe[1] = 700;
                Player.statBonusRobe[3] = 6;
                Player.statBonusRobe[0] = 2;
            }
            if (Player.getInventoryItemStatus(1) == 2) {
                Player.statBonusRobe[1] = 850;
                Player.statBonusRobe[3] = 6;
                Player.statBonusRobe[0] = 3;
            }
            if (Player.getInventoryItemStatus(1) == 3) {
                Player.statBonusRobe[1] = 1000;
                Player.statBonusRobe[3] = 6;
                Player.statBonusRobe[0] = 4;
            }
            if (Player.getInventoryItemStatus(1) == 4) {
                Player.statBonusRobe[1] = 1150;
                Player.statBonusRobe[3] = 6;
                Player.statBonusRobe[0] = 5;
            }
            if (Player.getInventoryItemStatus(1) == 5) {
                Player.statBonusRobe[1] = 1300;
                Player.statBonusRobe[3] = 6;
                Player.statBonusRobe[0] = 6;
            }
            if (Player.getInventoryItemStatus(1) == 6) {
                Player.statBonusRobe[1] = 600;
                Player.statBonusRobe[5] = 10;
                Player.statBonusRobe[4] = 6;
                Player.statBonusRobe[3] = 3;
            }
            if (Player.getInventoryItemStatus(1) == 7) {
                Player.statBonusRobe[1] = 700;
                Player.statBonusRobe[5] = 15;
                Player.statBonusRobe[4] = 7;
                Player.statBonusRobe[3] = 3;
            }
            if (Player.getInventoryItemStatus(1) == 8) {
                Player.statBonusRobe[1] = 800;
                Player.statBonusRobe[5] = 15;
                Player.statBonusRobe[4] = 8;
                Player.statBonusRobe[3] = 4;
            }
            if (Player.getInventoryItemStatus(1) == 9) {
                Player.statBonusRobe[1] = 900;
                Player.statBonusRobe[5] = 20;
                Player.statBonusRobe[4] = 9;
                Player.statBonusRobe[3] = 4;
            }
            if (Player.getInventoryItemStatus(1) == 10) {
                Player.statBonusRobe[1] = 1000;
                Player.statBonusRobe[5] = 20;
                Player.statBonusRobe[4] = 10;
                Player.statBonusRobe[3] = 5;
            }
        }
        if (Player.getEquipedRobe() == 8) {
            if (Player.getInventoryItemStatus(2) == 1) {
                Player.statBonusRobe[0] = 6;
                Player.statBonusRobe[3] = 6;
                Player.statBonusRobe[5] = 5;
                Player.statBonusRobe[1] = 1300;
            }
            if (Player.getInventoryItemStatus(2) == 2) {
                Player.statBonusRobe[0] = 6;
                Player.statBonusRobe[3] = 8;
                Player.statBonusRobe[5] = 10;
                Player.statBonusRobe[1] = 1350;
            }
            if (Player.getInventoryItemStatus(2) == 3) {
                Player.statBonusRobe[0] = 6;
                Player.statBonusRobe[3] = 10;
                Player.statBonusRobe[5] = 15;
                Player.statBonusRobe[1] = 1400;
            }
            if (Player.getInventoryItemStatus(2) == 4) {
                Player.statBonusRobe[0] = 6;
                Player.statBonusRobe[3] = 12;
                Player.statBonusRobe[5] = 20;
                Player.statBonusRobe[1] = 1450;
            }
            if (Player.getInventoryItemStatus(2) == 5) {
                Player.statBonusRobe[0] = 6;
                Player.statBonusRobe[3] = 14;
                Player.statBonusRobe[5] = 25;
                Player.statBonusRobe[1] = 1500;
            }
            if (Player.getInventoryItemStatus(2) == 6) {
                Player.statBonusRobe[0] = 6;
                Player.statBonusRobe[2] = 6;
                Player.statBonusRobe[3] = 3;
                Player.statBonusRobe[5] = 30;
            }
            if (Player.getInventoryItemStatus(2) == 7) {
                Player.statBonusRobe[0] = 7;
                Player.statBonusRobe[2] = 7;
                Player.statBonusRobe[3] = 4;
                Player.statBonusRobe[5] = 35;
            }
            if (Player.getInventoryItemStatus(2) == 8) {
                Player.statBonusRobe[0] = 8;
                Player.statBonusRobe[2] = 8;
                Player.statBonusRobe[3] = 4;
                Player.statBonusRobe[5] = 40;
            }
            if (Player.getInventoryItemStatus(2) == 9) {
                Player.statBonusRobe[0] = 9;
                Player.statBonusRobe[2] = 9;
                Player.statBonusRobe[3] = 5;
                Player.statBonusRobe[5] = 45;
            }
            if (Player.getInventoryItemStatus(2) == 10) {
                Player.statBonusRobe[0] = 10;
                Player.statBonusRobe[2] = 10;
                Player.statBonusRobe[3] = 5;
                Player.statBonusRobe[5] = 50;
            }
        }
    }

    public static int getSpellDamage(int spellId, int spellLvl) {
        int dmg = 0;
        int count = 10 + 5 * spellLvl;
        if (spellId == 0 && spellLvl > 0) {
            dmg = 100 + 50 * spellLvl;
        }
        if (spellId == 1 && spellLvl > 0) {
            dmg = 35 * spellLvl;
        }
        if (spellId == 2 && spellLvl > 0) {
            dmg = 20 + 20 * spellLvl;
        }
        return dmg *= count;
    }

    public static int getManaCost(int ID) {
        return 25 + 5 * Player.getSpellStatus(ID);
    }

    public static int getManaCostForNextLevel(int ID) {
        return 25 + 5 * (Player.getSpellStatus(ID) + 1);
    }

    public static int getStatPrice(int statId, int lvl) {
        int price = 0;
        lvl += 2;
        if (statId == 0) {
            price = 120 + 25 * lvl * (lvl - 2);
        } else if (statId == 1) {
            lvl = (lvl - 1000) / 100;
            price = 150 + 10 * ++lvl * (lvl - 2);
        } else if (statId == 2) {
            price = 800 + (lvl -= 2) * 1600;
        } else if (statId == 3) {
            price = 600 + (lvl -= 2) * 180;
        } else if (statId == 4) {
            price = (lvl -= 2) < 3 ? 300 + lvl * 300 : (lvl - 1) * 900;
        } else if (statId == 5) {
            lvl = (lvl - 50) / 5;
            price = 200 + lvl * 150;
        }
        return price;
    }

    public static int getStatValue(int statID) {
        int statValue = stat[statID];
        int bonusValue = statBonusRobe[statID] + statBonusStaff[statID];
        return statValue + bonusValue;
    }

    public static int getStatValueExBonus(int statID) {
        int statValue = stat[statID];
        return statValue;
    }

    public static void setStatValue(int statID, int value) {
        Player.stat[statID] = value;
    }

    public static int getStatBonus(int statID) {
        return statBonusRobe[statID] + statBonusStaff[statID];
    }

    public static String getStatBonusString(int statID) {
        String result = "";
        if (statID == 2) {
            if (statBonusRobe[statID] + statBonusStaff[statID] > 0) {
                result = " + " + String.valueOf((statBonusRobe[statID] + statBonusStaff[statID]) * 10) + "%";
            }
        } else if (statID == 0) {
            if (statBonusRobe[statID] + statBonusStaff[statID] > 0) {
                result = " + " + String.valueOf((statBonusRobe[statID] + statBonusStaff[statID]) * 20);
            }
        } else if (statID == 3) {
            if (statBonusRobe[statID] + statBonusStaff[statID] > 0) {
                result = " + " + String.valueOf((statBonusRobe[statID] + statBonusStaff[statID]) * 2) + "%";
            }
        } else if (statBonusRobe[statID] + statBonusStaff[statID] > 0) {
            result = " + " + String.valueOf(statBonusRobe[statID] + statBonusStaff[statID]);
        }
        return result;
    }

    public static void upgradeStat(int statID, int price) {
        if (cash >= Player.getStatPrice(statID, Player.getStatValueExBonus(statID))) {
            cash -= price;
            ScreenShop.buyItemEffect = 0;
            switch (statID) {
                case 0: {
                    stat[0] = stat[0] + 1;
                    break;
                }
                case 2: {
                    stat[2] = stat[2] + 1;
                    break;
                }
                case 3: {
                    stat[3] = stat[3] + 1;
                    break;
                }
                case 1: {
                    stat[1] = stat[1] + 100;
                    int hpLvl = (stat[1] - 1000) / 100;
                    int towerAndFenceId = 0;
                    if (hpLvl == 1) {
                        towerAndFenceId = 1;
                    } else if (hpLvl >= 3 && hpLvl < 6) {
                        towerAndFenceId = 2;
                    } else if (hpLvl >= 6 && hpLvl < 10) {
                        towerAndFenceId = 3;
                    } else if (hpLvl >= 10 && hpLvl < 15) {
                        towerAndFenceId = 4;
                    } else if (hpLvl >= 15 && hpLvl < 21) {
                        towerAndFenceId = 5;
                    } else if (hpLvl >= 21 && hpLvl < 28) {
                        towerAndFenceId = 6;
                    } else if (hpLvl >= 28) {
                        towerAndFenceId = 7;
                    }
                    if (towerAndFenceId <= towerUpgradeLvl) break;
                    towerWasUpgraded = true;
                    break;
                }
                case 4: {
                    stat[4] = stat[4] + 1;
                    break;
                }
                case 5: {
                    stat[5] = stat[5] + 5;
                }
            }
        }
    }

    public static void upgradeInventoryItem(int itemId, int price) {
        if (cash >= Player.getInventoryItemPrice(itemId, Player.getInventoryItemStatus(itemId)) && ShopItems.MAX_VALUE[itemId + 6] >= Player.getInventoryItemStatus(itemId) + 1) {
            cash -= price;
            ScreenShop.buyItemEffect = 0;
            int n = itemId;
            InventoryItemStatus[n] = InventoryItemStatus[n] + 1;
            Player.equipItem(itemId + 6);
        }
    }

    public static void setFullUpgrade(int itemId) {
        if (itemId > 14) {
            if (itemId == 15) {
                Player.setSpellValue(3, ShopItems.MAX_VALUE[itemId]);
            }
            if (itemId == 16) {
                Player.setSpellValue(4, ShopItems.MAX_VALUE[itemId]);
            }
            if (itemId == 17) {
                Player.setSpellValue(5, ShopItems.MAX_VALUE[itemId]);
            }
        } else {
            Player.InventoryItemStatus[itemId - 6] = ShopItems.MAX_VALUE[itemId];
        }
    }

    public static int getInventoryItemStatus(int itemId) {
        return InventoryItemStatus[itemId];
    }

    public static void setInventoryItemValue(int itemId, int value) {
        Player.InventoryItemStatus[itemId] = value;
    }

    public static int getInventoryItemPrice(int itemId, int lvl) {
        int price = 0;
        ++lvl;
        if (itemId == 0 | itemId == 3) {
            price = 500 + 150 * (lvl * lvl - 2);
        }
        if (itemId == 1 | itemId == 4) {
            price = 3000 + 1000 * lvl;
        }
        if (itemId == 2 | itemId == 5) {
            price = 8500 + 1500 * lvl;
        }
        return price;
    }

    public static void upgradeSpell(int spellId, int price) {
        if (cash >= Player.getSpellPrice(spellId, Player.getSpellStatus(spellId)) && ShopItems.MAX_VALUE[spellId + 12] >= Player.getSpellStatus(spellId) + 1) {
            cash -= price;
            int n = spellId;
            SpellStatus[n] = SpellStatus[n] + 1;
            ScreenShop.buyItemEffect = 0;
        }
    }

    public static int getSpellStatus(int spellId) {
        return SpellStatus[spellId];
    }

    public static int getSpellPrice(int spellId, int lvl) {
        int price = 400 + (++lvl - 1) * 400;
        if (spellId == 3) {
            price = 3000 + 500 * lvl * lvl;
        }
        if (spellId == 4) {
            price = 15000;
        }
        if (spellId == 5) {
            price = 3000 + 1500 * (lvl - 1);
        }
        return price;
    }

    public static void setSpellValue(int statID, int value) {
        Player.SpellStatus[statID] = value;
    }

    public static void buyConsumable(int consumableId, int price) {
        if (cash >= Player.getConsumablePrice(consumableId)) {
            cash -= price;
            int n = consumableId;
            ConsumableCounts[n] = ConsumableCounts[n] + 1;
            ScreenShop.buyItemEffect = 0;
        }
    }

    public static void buyConsumableForCash(int consumableId) {
        if (consumableId == 21) {
            consumableId = 3;
        }
        if (consumableId == 22) {
            consumableId = 4;
        }
        if (consumableId == 23) {
            consumableId = 5;
        }
        int n = consumableId;
        ConsumableCounts[n] = ConsumableCounts[n] + 1;
    }

    public static void buyAdditionalTowerForCash() {
        SpellStatus[4] = SpellStatus[4] + 1;
    }

    public static void buyShieldsForCash() {
        SpellStatus[5] = SpellStatus[5] + 1;
    }

    public static int getConsumableCount(int consumableId) {
        return ConsumableCounts[consumableId];
    }

    public static void setConsumableCount(int itemId, int value) {
        Player.ConsumableCounts[itemId] = value;
    }

    public static int getConsumablePrice(int consumableId) {
        int price = 0;
        if (consumableId == 0) {
            int hpLvl = (stat[1] - 1000) / 100;
            price = 200 + hpLvl * 10;
        }
        if (consumableId == 1) {
            int manaLvl = (stat[5] - 50) / 5;
            price = 200 + manaLvl * 10;
        }
        if (consumableId == 2) {
            price = 700;
        }
        if (consumableId == 3) {
            int damageLvl = stat[0];
            price = 400 + damageLvl * 10;
        }
        if (consumableId == 4) {
            price = 750;
        }
        if (consumableId == 5) {
            price = 1250;
        }
        return price;
    }

    public static void buyCoins(int coinsPackId) {
        if (coinsPackId == 22) {
            cash += MainCanvas.coinPackagesQuantity[0];
        }
        if (coinsPackId == 23) {
            cash += MainCanvas.coinPackagesQuantity[1];
        }
        if (coinsPackId == 24) {
            cash += MainCanvas.coinPackagesQuantity[2];
        }
        if (MainCanvas.limitedOffer) {
            cash += MainCanvas.coinPackagesQuantity[0] / 5;
            MainCanvas.limitedOffer = false;
        }
    }

    public static void equipItem(int itemId) {
        if (itemId == 6 || itemId == 7 || itemId == 8) {
            ACTIVE_ROBE = itemId;
        }
        if (itemId == 9 || itemId == 10 || itemId == 11) {
            ACTIVE_STAFF = itemId;
        }
    }

    public static int getEquipedItemId(int slotId) {
        return SLOT_ITEM[slotId];
    }

    public static int getEquipedStaff() {
        return ACTIVE_STAFF;
    }

    public static int getEquipedRobe() {
        return ACTIVE_ROBE;
    }

    public static int getStage() {
        return stage;
    }

    public static void setStage(int val) {
        stage = val;
    }

    public static int getGeneratorSet() {
        return generatorSet;
    }

    public static void setGeneratorSet(int val) {
        generatorSet = val;
    }

    public static int getCash() {
        return cash;
    }

    public static void setCash(int val) {
        cash = val;
    }

    public void addCash(int inc) {
        cash += inc;
    }

    public static void addScore(int value) {
        score += value;
    }

    public static int getScore() {
        return score;
    }

    public static void setScore(int value) {
        score = value;
    }

    public int getMaxMana() {
        return (stat[5] + 1) * 5;
    }

    public static int getPlayerShield() {
        return SpellStatus[5] * 5;
    }

    public static void setPlayerShield(int value) {
        Player.SpellStatus[5] = value;
    }

    public static int getSpecialOfferItemPrice(int specialOfferId) {
        int price = 0;
        if (specialOfferId == 1) {
            price = Player.getStatPrice(0, Player.getStatValueExBonus(0)) * 3;
        }
        if (specialOfferId == 2) {
            price = Player.getStatPrice(1, Player.getStatValueExBonus(1)) * 3;
        }
        if (specialOfferId == 3) {
            price = Player.getStatPrice(5, Player.getStatValueExBonus(5)) * 3;
        }
        if (specialOfferId == 4) {
            price = Player.getConsumablePrice(0) * 7;
        }
        if (specialOfferId == 5) {
            price = Player.getConsumablePrice(1) * 3;
        }
        if (specialOfferId == 6) {
            price = Player.getConsumablePrice(3) * 3;
        }
        return price;
    }

    public static int getStandardItemPrice(int specialOfferId) {
        int cl;
        int save = 0;
        if (specialOfferId == 1) {
            cl = Player.getStatValueExBonus(0);
            save = Player.getStatPrice(0, cl) + Player.getStatPrice(0, cl + 1) + Player.getStatPrice(0, cl + 2);
        }
        if (specialOfferId == 2) {
            cl = (Player.getStatValueExBonus(1) - 1000) / 100;
            save = Player.getStatPrice(1, cl) + Player.getStatPrice(1, cl + 1) + Player.getStatPrice(1, cl + 2);
        }
        if (specialOfferId == 3) {
            cl = Player.getStatValueExBonus(5);
            save = Player.getStatPrice(5, cl) + Player.getStatPrice(5, cl + 5) + Player.getStatPrice(5, cl + 10);
        }
        if (specialOfferId == 4) {
            save = Player.getConsumablePrice(0) * 10;
        }
        if (specialOfferId == 5) {
            save = Player.getConsumablePrice(1) * 5;
        }
        if (specialOfferId == 6) {
            save = Player.getConsumablePrice(3) * 5;
        }
        return save;
    }

    public static int getSpecialOfferItemSaving(int specialOfferId) {
        int cl;
        int save = 0;
        if (specialOfferId == 1) {
            cl = Player.getStatValueExBonus(0);
            save = Player.getStatPrice(0, cl) + Player.getStatPrice(0, cl + 1) + Player.getStatPrice(0, cl + 2);
            save -= Player.getSpecialOfferItemPrice(specialOfferId);
        }
        if (specialOfferId == 2) {
            cl = (Player.getStatValueExBonus(1) - 1000) / 100;
            save = Player.getStatPrice(1, cl) + Player.getStatPrice(1, cl + 1) + Player.getStatPrice(1, cl + 2);
            save -= Player.getSpecialOfferItemPrice(specialOfferId);
        }
        if (specialOfferId == 3) {
            cl = Player.getStatValueExBonus(5);
            save = Player.getStatPrice(5, cl) + Player.getStatPrice(5, cl + 5) + Player.getStatPrice(5, cl + 10);
            save -= Player.getSpecialOfferItemPrice(specialOfferId);
        }
        if (specialOfferId == 4) {
            save = Player.getConsumablePrice(0) * 10;
            save -= Player.getSpecialOfferItemPrice(specialOfferId);
        }
        if (specialOfferId == 5) {
            save = Player.getConsumablePrice(1) * 5;
            save -= Player.getSpecialOfferItemPrice(specialOfferId);
        }
        if (specialOfferId == 6) {
            save = Player.getConsumablePrice(3) * 5;
            save -= Player.getSpecialOfferItemPrice(specialOfferId);
        }
        return save;
    }

    public static int getSpecialOfferItemSavingPercentage(int specialOfferId) {
        int cl;
        int old = 0;
        int save = 0;
        int percentage = 0;
        if (specialOfferId == 1) {
            cl = Player.getStatValueExBonus(0);
            old = Player.getStatPrice(0, cl) + Player.getStatPrice(0, cl + 1) + Player.getStatPrice(0, cl + 2);
            save = old - Player.getSpecialOfferItemPrice(specialOfferId);
            percentage = save * 1000 / old * 100 / 1000;
        }
        if (specialOfferId == 2) {
            cl = (Player.getStatValueExBonus(1) - 1000) / 100;
            old = Player.getStatPrice(1, cl) + Player.getStatPrice(1, cl + 1) + Player.getStatPrice(1, cl + 2);
            save = old - Player.getSpecialOfferItemPrice(specialOfferId);
            percentage = save * 1000 / old * 100 / 1000;
        }
        if (specialOfferId == 3) {
            cl = Player.getStatValueExBonus(5);
            old = Player.getStatPrice(5, cl) + Player.getStatPrice(5, cl + 5) + Player.getStatPrice(5, cl + 10);
            save = old - Player.getSpecialOfferItemPrice(specialOfferId);
            percentage = save * 1000 / old * 100 / 1000;
        }
        if (specialOfferId == 4) {
            old = Player.getConsumablePrice(0) * 10;
            save = old - Player.getSpecialOfferItemPrice(specialOfferId);
            percentage = save * 1000 / old * 100 / 1000;
        }
        if (specialOfferId == 5) {
            old = Player.getConsumablePrice(1) * 5;
            save = old - Player.getSpecialOfferItemPrice(specialOfferId);
            percentage = save * 1000 / old * 100 / 1000;
        }
        if (specialOfferId == 6) {
            old = Player.getConsumablePrice(3) * 5;
            save = old - Player.getSpecialOfferItemPrice(specialOfferId);
            percentage = save * 1000 / old * 100 / 1000;
        }
        return percentage;
    }

    public static void userHasUsedSpecialOffer(int specialOfferId) {
        if (specialOfferId == 1) {
            cash -= Player.getSpecialOfferItemPrice(specialOfferId);
            stat[0] = stat[0] + 3;
        }
        if (specialOfferId == 2) {
            cash -= Player.getSpecialOfferItemPrice(specialOfferId);
            stat[1] = stat[1] + 300;
            int hpLvl = (stat[1] - 1000) / 100;
            int towerAndFenceId = 0;
            if (hpLvl == 1) {
                towerAndFenceId = 1;
            } else if (hpLvl >= 3 && hpLvl < 6) {
                towerAndFenceId = 2;
            } else if (hpLvl >= 6 && hpLvl < 10) {
                towerAndFenceId = 3;
            } else if (hpLvl >= 10 && hpLvl < 15) {
                towerAndFenceId = 4;
            } else if (hpLvl >= 15 && hpLvl < 21) {
                towerAndFenceId = 5;
            } else if (hpLvl >= 21 && hpLvl < 28) {
                towerAndFenceId = 6;
            } else if (hpLvl >= 28) {
                towerAndFenceId = 7;
            }
            if (towerAndFenceId > towerUpgradeLvl) {
                towerWasUpgraded = true;
            }
        }
        if (specialOfferId == 3) {
            cash -= Player.getSpecialOfferItemPrice(specialOfferId);
            stat[5] = stat[5] + 3;
        }
        if (specialOfferId == 4) {
            cash -= Player.getSpecialOfferItemPrice(specialOfferId);
            ConsumableCounts[0] = ConsumableCounts[0] + 10;
        }
        if (specialOfferId == 5) {
            cash -= Player.getSpecialOfferItemPrice(specialOfferId);
            ConsumableCounts[1] = ConsumableCounts[1] + 5;
        }
    }

    public static int bossStageItemDrop(int stage) {
        int count;
        int dropedItem = -9999;
        dropedItem = stage == 10 ? 0 : (stage == 20 ? 3 : (stage == 30 ? 1 : RandomNum.getRandomUInt(3) + 6));
        lastDropCountGenerated = count = RandomNum.getRandomUInt(3) + 3;
        Player.addToPlayerDroppedItem(dropedItem, count);
        return dropedItem;
    }

    private static void addToPlayerDroppedItem(int itemId, int count) {
        if (itemId == 0) {
            InventoryItemStatus[3] = InventoryItemStatus[3] + 1;
            ScreenShop.SELECTED_CATEGORY = 1;
        }
        if (itemId == 1) {
            InventoryItemStatus[4] = InventoryItemStatus[4] + 1;
            ScreenShop.SELECTED_CATEGORY = 1;
        }
        if (itemId == 2) {
            InventoryItemStatus[5] = InventoryItemStatus[5] + 1;
            ScreenShop.SELECTED_CATEGORY = 1;
        }
        if (itemId == 3) {
            InventoryItemStatus[0] = InventoryItemStatus[0] + 1;
            ScreenShop.SELECTED_CATEGORY = 1;
        }
        if (itemId == 4) {
            InventoryItemStatus[1] = InventoryItemStatus[1] + 1;
            ScreenShop.SELECTED_CATEGORY = 1;
        }
        if (itemId == 5) {
            InventoryItemStatus[2] = InventoryItemStatus[2] + 1;
            ScreenShop.SELECTED_CATEGORY = 1;
        }
        if (itemId == 6) {
            ConsumableCounts[1] = ConsumableCounts[1] + count;
            ScreenShop.SELECTED_CATEGORY = 3;
        }
        if (itemId == 7) {
            ConsumableCounts[0] = ConsumableCounts[0] + count;
            ScreenShop.SELECTED_CATEGORY = 3;
        }
        if (itemId == 8) {
            ConsumableCounts[4] = ConsumableCounts[4] + count;
            ScreenShop.SELECTED_CATEGORY = 3;
        }
    }

    public static boolean hasEnoughtGoldToBuyItem(int itemId) {
        boolean result = false;
        if (itemId < 6 && cash >= Player.getStatPrice(itemId, Player.getStatValueExBonus(itemId))) {
            result = true;
        }
        if (itemId > 5 && itemId < 12 && cash >= Player.getInventoryItemPrice(itemId - 6, Player.getInventoryItemStatus(itemId - 6)) && ShopItems.MAX_VALUE[itemId] >= Player.getInventoryItemStatus(itemId - 6) + 1) {
            result = true;
        }
        if (itemId > 11 && itemId < 18 && cash >= Player.getSpellPrice(itemId - 12, Player.getSpellStatus(itemId - 12)) && ShopItems.MAX_VALUE[itemId] >= Player.getSpellStatus(itemId - 12) + 1) {
            result = true;
        }
        if (itemId > 17 && cash >= Player.getConsumablePrice(itemId - 18)) {
            result = true;
        }
        return result;
    }

    public static int getStageBonus(int stages, int offset) {
        int bonus = 0;
        if (stages > 5) {
            stages = 5;
        }
        int decade = (Player.getStage() + 1 + offset - (Player.getStage() + 1 + offset) % 10) / 10;
        int baseTax = 40 + 100 * decade;
        bonus = baseTax * (stages - 1);
        return bonus;
    }

    static {
        stage = 0;
        generatorSet = 0;
        lastOfferId = -1;
        towerWasUpgraded = false;
        towerUpgradeLvl = 0;
        stat = new int[6];
        statBonusStaff = new int[6];
        statBonusRobe = new int[6];
        SLOT_ITEM = new int[3];
        ACTIVE_STAFF = -9999;
        ACTIVE_ROBE = -9999;
        playerRefusedLimitedOffer = false;
        InventoryItemStatus = new int[]{0, 0, 0, 0, 0, 0, 0};
        SpellStatus = new int[]{0, 0, 0, 0, 0, 0, 0};
        ConsumableCounts = new int[]{0, 0, 0, 0, 0, 0, 0};
        streak = 0;
        loseCountInRow = 0;
        dieHintStep = 3;
        strStrName = "";
        enemiesStronger = 0;
        diedMoreThanOnce = false;
        diedInLvlFifteen = 0;
        lastDropCountGenerated = 3;
        hintCounter = 0;
    }
}

