/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.bubble_birds_2.game;

import com.ximad.bubble_birds_2.game.DataManager;
import com.ximad.bubble_birds_2.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLLevel {
    public int[] mixArray = new int[]{0, 0, 0, 0, 0, 0};
    private int bg_type;
    private int init_y;
    private int birdsNumber;
    private Vector birdsVector;
    private static XMLLevel parser;

    private XMLLevel() {
    }

    public static void loadLevel(int lvl_nmb, Vector birdsVector) {
        if (parser == null) {
            parser = new XMLLevel();
        }
        XMLLevel.parser.birdsVector = birdsVector;
        parser.parseLevel(lvl_nmb);
    }

    public static int getBgType() {
        if (parser != null) {
            return XMLLevel.parser.bg_type;
        }
        return -1;
    }

    public static int getInitY() {
        if (parser != null) {
            return XMLLevel.parser.init_y;
        }
        return -1;
    }

    public static int getBirdsNumber() {
        if (parser != null) {
            return XMLLevel.parser.birdsNumber;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseLevel(int lvl_nmb) {
        this.initMixing(this.mixArray);
        InputStream is = this.getClass().getResourceAsStream("/levels/" + lvl_nmb + ".xml");
        if (is == null) {
            return;
        }
        LevelHandler lh = new LevelHandler();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(is, (DefaultHandler)lh);
        }
        catch (ParserConfigurationException e) {
            Utils.log("!!! parse error1");
        }
        catch (SAXException e) {
            Utils.log("!!! parse error2");
        }
        catch (IOException e) {
            Utils.log("!!! parse error3");
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    Utils.log("!!! parse error4");
                }
            }
        }
    }

    public void initMixing(int[] array) {
        int i;
        int l = array.length;
        for (i = 0; i < l; ++i) {
            array[i] = i;
        }
        for (i = 0; i < l; ++i) {
            int j = Math.abs(Utils.random() % l);
            int tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
    }

    public int mixBubbles(int[] array, int val) {
        return val < array.length ? this.mixArray[val] : val;
    }

    class LevelHandler
    extends DefaultHandler {
        private String tmpAttr;
        private boolean startDocument = false;
        private boolean endDocument = false;

        LevelHandler() {
        }

        public void startDocument() {
            this.startDocument = true;
        }

        public void endDocument() {
            this.endDocument = true;
        }

        public void startElement(String uri, String name, String qName, Attributes atts) {
            block11: {
                if (!this.startDocument) {
                    return;
                }
                name = qName;
                try {
                    if (name.equals("Level")) {
                        this.tmpAttr = atts.getValue("backgroundImage");
                        if (this.tmpAttr != null) {
                            XMLLevel.this.bg_type = Integer.parseInt("" + atts.getValue("backgroundImage"));
                            DataManager.bgIndex = XMLLevel.this.bg_type;
                        }
                        if (atts.getValue("screensCount") != null) {
                            int tmp_scr = Integer.parseInt(atts.getValue("screensCount").toString());
                            XMLLevel.this.init_y = 480 - tmp_scr * 480;
                        }
                        if (atts.getValue("rowsCount") != null) {
                            XMLLevel.this.birdsNumber = Integer.parseInt("" + atts.getValue("rowsCount")) * 12;
                        }
                        break block11;
                    }
                    if (!name.equals("BlocksList")) break block11;
                    for (int i = 1; i <= XMLLevel.this.birdsNumber; ++i) {
                        String tmp_bird = "";
                        int bird_type = 0;
                        try {
                            tmp_bird = atts.getValue("b" + i).toString();
                            bird_type = Integer.parseInt(tmp_bird);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (tmp_bird == null || tmp_bird.equals("")) {
                            XMLLevel.this.birdsVector.addElement("-1");
                            continue;
                        }
                        XMLLevel.this.birdsVector.addElement("" + XMLLevel.this.mixBubbles(XMLLevel.this.mixArray, bird_type));
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }
}

