/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.bubble_birds_2.component;

import com.ximad.bubble_birds_2.component.XYRect;
import com.ximad.bubble_birds_2.engine.Bitmap;

public class MyAnim {
    private int startX;
    private int endX;
    private int startY;
    private int endY;
    private long creatingTime;
    private int totalTime;
    private Bitmap[] frames;
    private XYRect myRect = new XYRect();

    public MyAnim(Bitmap[] frames, int x0, int y0, int x1, int y1, int timeMS) {
        this.frames = frames;
        this.startX = x0;
        this.endX = x1;
        this.startY = y0;
        this.endY = y1;
        this.totalTime = timeMS;
        this.myRect.width = frames[0].getWidth();
        this.myRect.height = frames[0].getHeight();
        this.creatingTime = System.currentTimeMillis();
    }

    public int getX() {
        return (int)((double)this.startX + 1.0 * (double)(this.endX - this.startX) * (double)(System.currentTimeMillis() - this.creatingTime) / (double)this.totalTime);
    }

    public int getY() {
        return (int)((double)this.startY + 1.0 * (double)(this.endY - this.startY) * (double)(System.currentTimeMillis() - this.creatingTime) / (double)this.totalTime);
    }

    public XYRect getRect() {
        this.myRect.x = this.getX();
        this.myRect.y = this.getY();
        return this.myRect;
    }

    public Bitmap getBitmap() {
        int ind = (int)((long)(this.frames.length - 1) * (System.currentTimeMillis() - this.creatingTime) / (long)this.totalTime);
        if (ind < this.frames.length) {
            return this.frames[ind];
        }
        this.onAnimationEnd();
        return null;
    }

    public void onAnimationEnd() {
    }
}

