/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.bubble_birds_2.screen;

import com.ximad.bubble_birds_2.Flurry;
import com.ximad.bubble_birds_2.component.Animatable;
import com.ximad.bubble_birds_2.component.MyIntField;
import com.ximad.bubble_birds_2.engine.Application;
import com.ximad.bubble_birds_2.engine.Bitmap;
import com.ximad.bubble_birds_2.engine.CustomButton;
import com.ximad.bubble_birds_2.engine.Screen;
import com.ximad.bubble_birds_2.engine.UiScreen;
import com.ximad.bubble_birds_2.game.DataManager;
import com.ximad.bubble_birds_2.res.Res;
import com.ximad.bubble_birds_2.screen.GameScreen;
import com.ximad.bubble_birds_2.screen.HomeScreen;
import com.ximad.bubble_birds_2.screen.SelectLevelScreen;
import javax.microedition.lcdui.Graphics;

public class ShopScreen
extends UiScreen {
    static int callFrom;
    public static final int CALL_FROM_MENU = 0;
    public static final int CALL_FROM_SELECT_LEVEL = 1;
    public static final int CALL_FROM_WIN_LEVEL = 2;
    public static final int CALL_FROM_PAUSE = 3;
    private static ShopScreen instance;
    static GameScreen gs;
    static Bitmap bg;
    CustomButton buyBombButton;
    CustomButton buyAnyButton;
    CustomButton exitButton;
    MyIntField balanceInt;
    MyIntField bombCountInt;
    MyIntField anyCountInt;
    MyIntField bombCostInt;
    MyIntField anyCostField;
    public static Animatable bird_1;
    public static Animatable bird_2;
    public static final AnimationThread animationThread;

    public static ShopScreen getInstance(Bitmap bg, GameScreen gs) {
        ShopScreen.bg = bg;
        ShopScreen.gs = gs;
        callFrom = 3;
        if (instance == null) {
            instance = new ShopScreen();
        }
        return instance;
    }

    private ShopScreen() {
        this.makeUi();
    }

    public static ShopScreen getInstance(Bitmap bg, int callFrom) {
        ShopScreen.bg = bg;
        ShopScreen.callFrom = callFrom;
        if (instance == null) {
            instance = new ShopScreen();
        }
        return instance;
    }

    private void makeUi() {
        this.buyBombButton = new CustomButton(Res.shopBuyOff, Res.shopBuyOn, null, null){

            protected void touchAction() {
                ShopScreen.this.buyBombClick();
            }
        };
        this.buyAnyButton = new CustomButton(Res.shopBuyOff, Res.shopBuyOn, null, null){

            protected void touchAction() {
                ShopScreen.this.buyAnyClick();
            }
        };
        this.exitButton = new CustomButton(Res.shopExitOff, Res.shopExitOn, null, null){

            protected void touchAction() {
                ShopScreen.this.exitClick();
            }
        };
        this.balanceInt = new MyIntField(DataManager.getCoinsCount(), Res.font_default);
        this.bombCostInt = new MyIntField(10, Res.font_default);
        this.bombCountInt = new MyIntField(DataManager.getBombCount(), Res.font_ebr);
        this.anyCostField = new MyIntField(10, Res.font_default);
        this.anyCountInt = new MyIntField(DataManager.getAnyCount(), Res.font_ebr);
        this.add(bird_1, 0, 0);
        this.add(bird_2, 0, 0);
        this.add(this.buyBombButton, 193, 310);
        this.add(this.buyAnyButton, 193, 445);
        this.add(this.exitButton, 150, 546);
        this.add(this.balanceInt, 210, 173);
        this.add(this.bombCostInt, 162, 318);
        this.add(this.bombCountInt, 216, 255);
        this.add(this.anyCostField, 162, 451);
        this.add(this.anyCountInt, 216, 382);
    }

    private void exitClick() {
        this.playButtonSound();
        switch (callFrom) {
            case 0: {
                Application.setScreen(HomeScreen.getInstance());
                break;
            }
            case 1: {
                Application.setScreen(SelectLevelScreen.getInstance());
                break;
            }
            case 2: {
                Application.setScreen(GameScreen.getInstance(DataManager.currLevel));
                break;
            }
            case 3: {
                gs.continueGame();
                Application.setScreen(GameScreen.getInstance());
                break;
            }
        }
    }

    public void onPaint(Graphics g) {
        bg.draw(g, 0, 0);
        Res.rgbShadow.draw(g, 0, 0);
        Res.shopBg.draw(g, 49, 113);
        Res.shopBombBird.draw(g, 135, 222);
        Res.shopAnyBird.draw(g, 135, 355);
        Res.shopPlank.draw(g, 123, 307);
        Res.shopPlank.draw(g, 123, 441);
        this.balanceInt.setInt(DataManager.getCoinsCount());
        super.onPaint(g);
    }

    private void buyBombClick() {
        this.playButtonSound();
        if (DataManager.getCoinsCount() >= 10) {
            Flurry.onBirdBuy(1);
            DataManager.setBombCount(DataManager.getBombCount() + 1);
            DataManager.setCoinsCount(DataManager.getCoinsCount() - 10);
            this.bombCountInt.setInt(DataManager.getBombCount());
            this.balanceInt.setInt(DataManager.getCoinsCount());
            ShopScreen.repaint();
        }
    }

    private void buyAnyClick() {
        this.playButtonSound();
        if (DataManager.getCoinsCount() >= 10) {
            Flurry.onBirdBuy(0);
            DataManager.setAnyCount(DataManager.getAnyCount() + 1);
            DataManager.setCoinsCount(DataManager.getCoinsCount() - 10);
            this.anyCountInt.setInt(DataManager.getAnyCount());
            this.balanceInt.setInt(DataManager.getCoinsCount());
            ShopScreen.repaint();
        }
    }

    public void onShow() {
        this.balanceInt.setInt(DataManager.getCoinsCount());
        animationThread.resumeAnimation();
    }

    public void onHide() {
        animationThread.pauseAnimation();
    }

    static {
        animationThread = new AnimationThread();
        animationThread.pauseAnimation();
        animationThread.start();
    }

    public static class AnimationThread
    extends Thread {
        private boolean paused = false;

        public AnimationThread() {
            if (bird_1 == null) {
                bird_1 = new Animatable(Res.popupBird_1[0], 43, 40);
                bird_1.animate(Res.popupBird_1, 140, Animatable.TYPE_LINEAR, true);
                bird_1.startAnimation(Animatable.TYPE_FRAME);
            }
            if (bird_2 == null) {
                bird_2 = new Animatable(Res.popupBird_2[0], 190, 40);
                bird_2.animate(Res.popupBird_2, 140, Animatable.TYPE_LINEAR, true);
                bird_2.startAnimation(Animatable.TYPE_FRAME);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int sleepTime = 50;
                while (true) {
                    if (this.paused) {
                        AnimationThread animationThread = this;
                        synchronized (animationThread) {
                            this.wait();
                        }
                    }
                    sleepTime = bird_1.frameAnimationStep();
                    bird_2.frameAnimationStep();
                    Screen.repaint();
                    AnimationThread.sleep(sleepTime);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public void pauseAnimation() {
            this.paused = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resumeAnimation() {
            this.paused = false;
            AnimationThread animationThread = this;
            synchronized (animationThread) {
                this.notifyAll();
            }
        }
    }
}

