/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.bubble_birds_2.screen;

import com.ximad.bubble_birds_2.component.Animatable;
import com.ximad.bubble_birds_2.engine.Application;
import com.ximad.bubble_birds_2.engine.CustomButton;
import com.ximad.bubble_birds_2.engine.Screen;
import com.ximad.bubble_birds_2.engine.UiScreen;
import com.ximad.bubble_birds_2.res.Res;
import com.ximad.bubble_birds_2.screen.GameScreen;
import com.ximad.bubble_birds_2.screen.SelectLevelScreen;
import com.ximad.bubble_birds_2.screen.ShopScreen;
import javax.microedition.lcdui.Graphics;

public class PauseScreen
extends UiScreen {
    CustomButton continueButton = new CustomButton(Res.pauseContinueOff, Res.pauseContinueOn, null, null){

        protected void touchAction() {
            PauseScreen.this.continueClick();
        }
    };
    CustomButton levelButton;
    CustomButton shopButton = new CustomButton(Res.pauseShopOff, Res.pauseShopOn, null, null){

        protected void touchAction() {
            PauseScreen.this.shopClick();
        }
    };
    public static Animatable bird_1;
    public static Animatable bird_2;
    public static final AnimationThread animationThread;
    private static PauseScreen instance;
    static GameScreen gs;

    public void onShow() {
        animationThread.resumeAnimation();
    }

    public void onHide() {
        animationThread.pauseAnimation();
    }

    private PauseScreen() {
        this.levelButton = new CustomButton(Res.pauseLevelsOff, Res.pauseLevelsOn, null, null){

            protected void touchAction() {
                PauseScreen.this.levelClick();
            }
        };
        this.add(bird_1, 0, 0);
        this.add(bird_2, 0, 0);
        this.add(this.continueButton, 102, 208);
        this.add(this.levelButton, 106, 307);
        this.add(this.shopButton, 109, 429);
    }

    public static PauseScreen getInstance(GameScreen g) {
        gs = g;
        if (instance == null) {
            instance = new PauseScreen();
        }
        return instance;
    }

    public void onPaint(Graphics g) {
        Res.popupBg.draw(g, 0, 0);
        super.onPaint(g);
    }

    private void shopClick() {
        this.playButtonSound();
        Application.setScreen(ShopScreen.getInstance(this.takeScreenshot(), gs));
    }

    private void levelClick() {
        gs.quit();
        this.playButtonSound();
        Application.setScreen(SelectLevelScreen.getInstance());
    }

    private void continueClick() {
        this.playButtonSound();
        gs.continueGame();
        Application.setScreen(gs);
    }

    static {
        animationThread = new AnimationThread();
        animationThread.pauseAnimation();
        animationThread.start();
    }

    public static class AnimationThread
    extends Thread {
        private boolean paused = false;

        public AnimationThread() {
            if (bird_1 == null) {
                bird_1 = new Animatable(Res.popupBird_1[0], 43, 40);
                bird_1.animate(Res.popupBird_1, 140, Animatable.TYPE_LINEAR, true);
                bird_1.startAnimation(Animatable.TYPE_FRAME);
            }
            if (bird_2 == null) {
                bird_2 = new Animatable(Res.popupBird_2[0], 190, 40);
                bird_2.animate(Res.popupBird_2, 140, Animatable.TYPE_LINEAR, true);
                bird_2.startAnimation(Animatable.TYPE_FRAME);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int sleepTime = 50;
                while (true) {
                    if (this.paused) {
                        AnimationThread animationThread = this;
                        synchronized (animationThread) {
                            this.wait();
                        }
                    }
                    sleepTime = bird_1.frameAnimationStep();
                    bird_2.frameAnimationStep();
                    Screen.repaint();
                    AnimationThread.sleep(sleepTime);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public void pauseAnimation() {
            this.paused = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resumeAnimation() {
            this.paused = false;
            AnimationThread animationThread = this;
            synchronized (animationThread) {
                this.notifyAll();
            }
        }
    }
}

