/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.bubble_birds_2.screen;

import com.ximad.bubble_birds_2.Consts;
import com.ximad.bubble_birds_2.Flurry;
import com.ximad.bubble_birds_2.component.MyAnim;
import com.ximad.bubble_birds_2.component.MyIntField;
import com.ximad.bubble_birds_2.component.imAgination;
import com.ximad.bubble_birds_2.component.imgAnimated;
import com.ximad.bubble_birds_2.component.imgConst;
import com.ximad.bubble_birds_2.component.imgSimple;
import com.ximad.bubble_birds_2.engine.Application;
import com.ximad.bubble_birds_2.engine.Bitmap;
import com.ximad.bubble_birds_2.engine.CustomButton;
import com.ximad.bubble_birds_2.engine.Screen;
import com.ximad.bubble_birds_2.engine.UiScreen;
import com.ximad.bubble_birds_2.game.DataManager;
import com.ximad.bubble_birds_2.game.XMLLevel;
import com.ximad.bubble_birds_2.res.Res;
import com.ximad.bubble_birds_2.screen.GamePopupScreen;
import com.ximad.bubble_birds_2.screen.PauseScreen;
import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class GameScreen
extends UiScreen {
    public static GameScreen instance;
    private int bg_type;
    private int[] currLevel;
    private int init_y;
    private imAgination imageManip = new imAgination(Res.background[DataManager.bgIndex]);
    private Vector birdsVector;
    private float birdSpeed;
    private int curr_lvl;
    private TimerTask animTask;
    private Timer animRunner;
    CustomButton anyBirdButton;
    CustomButton bombBirdButton;
    CustomButton pauseButton = new CustomButton(Res.gamePauseOff, Res.gamePauseOn, null, null){

        protected void touchAction() {
            GameScreen.this.pauseClick();
        }
    };
    MyIntField bombCountInt;
    MyIntField anyCountInt;
    MyIntField coinsInt;
    MyIntField pointsInt;
    private imgConst tmpConst;
    private Bitmap[] tmp_bmps;
    private int x0;
    private int y0;
    private int w;
    private int h;
    private int lng;
    private int x_modifier;
    int rows;
    int nmb;
    int x;
    int y;

    public GameScreen() {
        this.anyBirdButton = new CustomButton(Res.gameAnyButton, Res.gameAnyButton, null, null){

            protected void touchAction() {
                GameScreen.this.anyClick();
            }
        };
        this.bombBirdButton = new CustomButton(Res.gameBombButton, Res.gameBombButton, null, null){

            protected void touchAction() {
                GameScreen.this.bombClick();
            }
        };
        this.bombCountInt = new MyIntField(DataManager.getBombCount(), Res.font_ebr);
        this.anyCountInt = new MyIntField(DataManager.getAnyCount(), Res.font_ebr);
        this.coinsInt = new MyIntField(DataManager.getCoinsCount(), Res.font_default);
        this.pointsInt = new MyIntField(DataManager.getScore(), Res.font_default);
        this.add(this.pauseButton, 20, 0);
        this.add(this.anyBirdButton, 28, 553);
        this.add(this.bombBirdButton, 284, 553);
        this.add(this.anyCountInt, 23, 526);
        this.add(this.bombCountInt, 320, 526);
        this.add(this.coinsInt, 180, 16);
        this.add(this.pointsInt, 282, 15);
    }

    public void init() {
        this.birdsVector = new Vector();
        this.birdsVector.removeAllElements();
        DataManager.currLevel = this.curr_lvl;
        DataManager.currCoins = 0;
        DataManager.currScore = 0;
        this.start_game(this.curr_lvl);
    }

    public void onHide() {
        this.animRunner.cancel();
        this.imageManip.setGameState(imAgination.STATE_ABORT);
        DataManager.game_flag = true;
        DataManager.shop_flag = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touchEvent(int touchEventType, int eventX, int eventY) {
        if (this.pauseButton.touchEvent(touchEventType, eventX, eventY) || this.anyBirdButton.touchEvent(touchEventType, eventX, eventY) || this.bombBirdButton.touchEvent(touchEventType, eventX, eventY)) {
            return;
        }
        if (touchEventType == 1) {
            if (eventY >= 566) {
                return;
            }
            imAgination imAgination2 = this.imageManip;
            synchronized (imAgination2) {
                this.imageManip.launchBird(eventX, eventY);
            }
        }
    }

    private void start_game(int lvl) {
        this.birdSpeed = (float)(DataManager.getGameSpeed() + 2) / 10.0f;
        this.init_level(lvl);
        DataManager.setCurrStars(0);
        this.imageManip = new imAgination(Res.background[this.bg_type]);
        int lng = this.currLevel.length;
        int rows_nmb = lng / 9;
        this.init_y = -1 * (rows_nmb - 1) * 38;
        this.imageManip.addElement(0, Res.game_seiling, 0, this.init_y - Res.game_seiling.getHeight());
        int count = 0;
        int full_row = this.init_y;
        this.imageManip.setForce(count, this.birdSpeed, 1.5707964f);
        for (int i = 0; i < rows_nmb; ++i) {
            int[] row = new int[11];
            int padding = 0;
            if (i % 2 != 0) {
                padding = 19;
            }
            int elt_count = 0;
            for (int j = 0; j < 12; ++j) {
                if (j == 0 || j > 9 || i * 12 + j >= this.currLevel.length) continue;
                int type = this.currLevel[i * 12 + j] + 1;
                if (type != 0) {
                    ++elt_count;
                    if (type == 12) {
                        type = 7;
                    } else if (type == 11) {
                        type = 11;
                    } else if (type == 10) {
                        type = 12;
                    } else if (type > 6) {
                        ++type;
                    }
                    this.imageManip.addBird(type, padding + (j - 1) * 38, this.init_y + i * 38);
                    row[j - 1] = ++count;
                    this.imageManip.setForce(count, this.birdSpeed, 1.5707964f);
                    continue;
                }
                row[j - 1] = -1;
            }
            if (elt_count > 0) {
                row[9] = this.init_y + i * 38;
                row[10] = elt_count;
                this.imageManip.addRow(row);
            }
            if (elt_count < 8) continue;
            full_row = this.init_y + i * 38;
        }
        this.imageManip.initMinMaxY(this.init_y, full_row);
        this.imageManip.help_on_dy[0] = -1 * this.init_y;
        this.imageManip.help_on_dy[1] = -1 * (this.init_y * 3 / 4 + 1);
        this.imageManip.help_on_dy[2] = -1 * (this.init_y / 3 + 1);
        this.imageManip.was_help[2] = false;
        this.imageManip.was_help[1] = false;
        this.imageManip.was_help[0] = false;
        this.imageManip.addConstElement(Res.eggs[0], 149, 525, false);
        this.imageManip.addBullet();
        this.startSteps();
    }

    private void startSteps() {
        if (this.animRunner != null) {
            this.animRunner.cancel();
        }
        this.animRunner = new Timer();
        this.animTask = new TimerTask(){

            public void run() {
                if (((GameScreen)GameScreen.this).imageManip.gameState != imAgination.STATE_PLAY) {
                    if (((GameScreen)GameScreen.this).imageManip.gameState == imAgination.STATE_WIN) {
                        GameScreen.this.processWin();
                    } else if (((GameScreen)GameScreen.this).imageManip.gameState == imAgination.STATE_LOSE) {
                        GameScreen.this.processLose();
                    }
                    GameScreen.this.animRunner.cancel();
                    return;
                }
                GameScreen.this.imageManip.Step();
                Screen.repaint();
            }
        };
        this.animRunner.schedule(this.animTask, 40L, 40L);
    }

    private void processWin() {
        this.imageManip.Step();
        Res.popupBg = GameScreen.makePopupBg(this.takeScreenshot());
        DataManager.setCoinsCount(DataManager.getCoinsCount() + DataManager.currCoins);
        DataManager.setScore(DataManager.getScore() + DataManager.currScore);
        DataManager.setStarsCount(this.curr_lvl - 1, DataManager.getCurrStars());
        if (DataManager.getMaxLevel() < this.curr_lvl + 1) {
            DataManager.setMaxLevel(this.curr_lvl + 1);
        }
        if (this.curr_lvl + 1 <= 100) {
            Application.setScreen(GamePopupScreen.getInstance(0));
        } else {
            DataManager.setMaxLevel(100);
            Application.setScreen(GamePopupScreen.getInstance(3));
        }
    }

    private void processLose() {
        this.imageManip.Step();
        Res.popupBg = GameScreen.makePopupBg(this.takeScreenshot());
        DataManager.setCoinsCount(DataManager.getCoinsCount() + DataManager.currCoins);
        DataManager.setScore(DataManager.getScore() + DataManager.currScore);
        if (DataManager.getPlayerPosition(DataManager.getScore()) != -1 && DataManager.getScore() > 0) {
            Application.setScreen(GamePopupScreen.getInstance(1));
        } else {
            Application.setScreen(GamePopupScreen.getInstance(4));
        }
    }

    public void init_level(int lvl_nmb) {
        XMLLevel.loadLevel(lvl_nmb, this.birdsVector);
        this.bg_type = XMLLevel.getBgType();
        this.init_y = XMLLevel.getInitY();
        this.currLevel = new int[this.birdsVector.size()];
        this.copyVectorToIntArr(this.birdsVector, this.currLevel);
    }

    private void copyVectorToIntArr(Vector src, int[] target) {
        Enumeration enumeration = src.elements();
        int count = 0;
        while (enumeration.hasMoreElements()) {
            Object element = enumeration.nextElement();
            target[count++] = Integer.parseInt("" + element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPaint(Graphics g) {
        this.imageManip.pure_background.draw(g, 0, 0);
        imAgination imAgination2 = this.imageManip;
        synchronized (imAgination2) {
            if (this.imageManip.constBackElementCount != 0) {
                for (int i = 0; i < this.imageManip.constBackElementCount; ++i) {
                    this.tmpConst = this.imageManip.constBackElement[i];
                    this.tmp_bmps = this.tmpConst.get_bitmap();
                    this.lng = this.tmp_bmps.length;
                    this.x_modifier = 0;
                    for (int j = 0; j < this.lng; ++j) {
                        this.x0 = this.tmpConst.getImgPoint().x + this.x_modifier;
                        this.y0 = this.tmpConst.getImgPoint().y;
                        this.w = this.tmp_bmps[j].getWidth();
                        this.h = this.tmp_bmps[j].getHeight();
                        this.x_modifier += this.w;
                        if (this.lng != 1) {
                            this.y0 = this.y0 + this.tmp_bmps[0].getHeight() / 2 - this.h / 2;
                        }
                        if (this.x0 <= -1 * this.w || this.x0 >= 360 || this.y0 < -1 * this.h || this.y0 >= 640) continue;
                        this.tmp_bmps[j].draw(g, this.x0, this.y0);
                    }
                }
            }
            imgSimple img = this.imageManip.imgElements[0];
            img.get_bitmap().draw(g, img.getImgPoint().x, img.getImgPoint().y + this.imageManip.dy);
            this.rows = this.imageManip.allRowsCount;
            if (this.rows > 0) {
                for (int i = 0; i < this.rows; ++i) {
                    for (int j = 0; j < 9; ++j) {
                        this.nmb = this.imageManip.allRows[i][j];
                        if (this.nmb == -1 || this.nmb >= this.imageManip.imgElementsCount) continue;
                        img = this.imageManip.imgElements[this.nmb];
                        this.x = img.getImgPoint().x;
                        this.y = img.getImgPoint().y + this.imageManip.dy;
                        img.get_bitmap().draw(g, this.x, this.y);
                    }
                }
            }
            this.nmb = this.imageManip.imgElementsCount - 1;
            img = this.imageManip.imgElements[this.nmb];
            this.x = img.getImgPoint().x + this.imageManip.bullet_dx;
            this.y = img.getImgPoint().y + this.imageManip.bullet_dy;
            img.get_bitmap().draw(g, this.x, this.y);
            if (this.imageManip.animationCount != 0) {
                for (int i = 0; i < this.imageManip.animationCount; ++i) {
                    imgAnimated tmpAnimation = this.imageManip.animation[i];
                    Bitmap tmp_bmp = tmpAnimation.get_frame(System.currentTimeMillis());
                    if (tmp_bmp != null) {
                        this.x0 = tmpAnimation.get_x();
                        this.y0 = tmpAnimation.get_y();
                        this.w = tmp_bmp.getWidth();
                        this.h = tmp_bmp.getHeight();
                        if (this.x0 <= -1 * this.w || this.x0 >= 360 || this.y0 < -1 * this.h || this.y0 >= 640) continue;
                        tmp_bmp.draw(g, this.x0, this.y0);
                        continue;
                    }
                    System.arraycopy(this.imageManip.animation, i + 1, this.imageManip.animation, i, this.imageManip.animationCount - (i - 1));
                    this.imageManip.animation[--this.imageManip.animationCount] = null;
                    --i;
                }
            }
        }
        if (!this.imageManip.myAnimation.isEmpty()) {
            for (int i = 0; i < this.imageManip.myAnimation.size(); ++i) {
                MyAnim m = (MyAnim)this.imageManip.myAnimation.elementAt(i);
                Bitmap b = m.getBitmap();
                if (b != null) {
                    b.draw(g, m.getX(), m.getY());
                    continue;
                }
                this.imageManip.myAnimation.removeElementAt(i);
                --i;
            }
        }
        if (this.imageManip.helper_on_screen) {
            Bitmap b = this.imageManip.helper.getBitmap();
            if (b == null) {
                this.imageManip.removeHelper();
            } else {
                b.draw(g, this.imageManip.helper.x, this.imageManip.helper.y);
                if (this.imageManip.getBulletRect().intersects(this.imageManip.helper.getRect()) && this.imageManip.bullet_real_dy != 0.0f) {
                    this.imageManip.activateHelper();
                }
            }
        }
        Res.gamePlank.draw(g, 0, 0);
        for (int i = 0; i < DataManager.getCurrStars(); ++i) {
            Res.gameStar.draw(g, Consts.GAME_STAR_X[i], Consts.GAME_STAR_Y[i]);
        }
        Res.deadline[this.bg_type].draw(g, 0, 447);
        this.bombBirdButton.onPaint(g);
        this.anyBirdButton.onPaint(g);
        this.anyCountInt.setInt(DataManager.getAnyCount());
        this.anyCountInt.onPaint(g);
        this.bombCountInt.setInt(DataManager.getBombCount());
        this.bombCountInt.onPaint(g);
        this.pointsInt.setInt(DataManager.currScore + DataManager.getScore());
        this.pointsInt.onPaint(g);
        this.coinsInt.setInt(DataManager.currCoins + DataManager.getCoinsCount());
        this.coinsInt.onPaint(g);
    }

    public void onShow() {
        GameScreen.instance.imageManip.setGameState(imAgination.STATE_PLAY);
        this.startSteps();
    }

    public static GameScreen getInstance(int lvl) {
        DataManager.stopSound();
        if (lvl % 5 == 0) {
            Flurry.onLevelStarted(lvl);
        }
        if (instance == null) {
            instance = new GameScreen();
        }
        GameScreen.instance.curr_lvl = lvl;
        instance.init();
        return instance;
    }

    public static GameScreen getInstance() {
        block0: {
            if (instance != null) break block0;
            instance = new GameScreen();
        }
        return instance;
    }

    public void continueGame() {
        this.imageManip.gameState = imAgination.STATE_PLAY;
    }

    private void pauseClick() {
        Res.popupBg = GameScreen.makePopupBg(this.takeScreenshot());
        this.imageManip.gameState = imAgination.STATE_PAUSE;
        Application.setScreen(PauseScreen.getInstance(this));
    }

    private void anyClick() {
        if (DataManager.getAnyCount() > 0) {
            DataManager.setAnyCount(DataManager.getAnyCount() - 1);
            this.imageManip.addAnyBullet();
        }
    }

    private void bombClick() {
        if (DataManager.getBombCount() > 0) {
            DataManager.setBombCount(DataManager.getBombCount() - 1);
            this.imageManip.addBombBullet();
        }
    }

    public void quit() {
        if (this.animRunner != null) {
            this.animRunner.cancel();
            this.animRunner = null;
        }
    }
}

