/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.bubble_birds_2.component;

import com.ximad.bubble_birds_2.component.XYPoint;
import com.ximad.bubble_birds_2.engine.Bitmap;

public class imgSimple {
    private XYPoint img_point;
    private int img_width;
    private int img_height;
    private float force = 0.0f;
    private float angle;
    private float step_x = 0.0f;
    private float step_y = 0.0f;
    private float real_x = 0.0f;
    private float real_y = 0.0f;
    private Bitmap img_bmp;
    private int elt_type;
    private boolean elt_state;
    private Bitmap[] anim_frames;
    private int curr_frame;
    private boolean animated = false;
    int animationInterval;
    long lastTimeFrameGet;

    public imgSimple(int type, Bitmap bmp, int x, int y, float angle) {
        this.img_bmp = bmp;
        this.elt_type = type;
        this.img_point = new XYPoint(x, y);
        this.img_width = this.img_bmp.getWidth();
        this.img_height = this.img_bmp.getHeight();
        this.real_x = x;
        this.real_y = y;
        this.elt_state = true;
    }

    public boolean getEltState() {
        return this.elt_state;
    }

    public void setEltState(boolean new_state) {
        this.elt_state = new_state;
    }

    public void set_bitmap(Bitmap new_img) {
        this.img_bmp = new_img;
    }

    public Bitmap get_bitmap() {
        Bitmap curr_img;
        if (!this.animated) {
            curr_img = this.img_bmp;
        } else {
            curr_img = this.anim_frames[this.curr_frame];
            if (System.currentTimeMillis() - this.lastTimeFrameGet > (long)this.animationInterval) {
                ++this.curr_frame;
                this.lastTimeFrameGet = System.currentTimeMillis();
            }
            if (this.curr_frame >= this.anim_frames.length) {
                this.animated = false;
            }
        }
        return curr_img;
    }

    public int get_real_width() {
        return this.img_width;
    }

    public int get_real_height() {
        return this.img_height;
    }

    public float getAngle() {
        return this.angle;
    }

    public float getForce() {
        return this.force;
    }

    public void setForce(float f, float a) {
        this.force = f;
        this.angle = a;
        this.step_x = this.force * (float)Math.cos(this.angle);
        this.step_y = this.force * (float)Math.sin(this.angle);
    }

    public int get_type() {
        return this.elt_type;
    }

    public void set_type(int new_type) {
        this.elt_type = new_type;
    }

    public XYPoint getImgPoint() {
        return this.img_point;
    }

    public void setImgPoint(int x, int y) {
        this.img_point.set(x, y);
    }

    public void setRealX(float x) {
        this.real_x = x;
    }

    public void setRealY(float y) {
        this.real_y = y;
    }

    public float getStepX() {
        return this.step_x;
    }

    public float getStepY() {
        return this.step_y;
    }

    public float getRealX() {
        return this.real_x;
    }

    public float getRealY() {
        return this.real_y;
    }

    public void setAnimation(Bitmap[] frames, int time) {
        this.lastTimeFrameGet = System.currentTimeMillis();
        this.animationInterval = time;
        this.anim_frames = frames;
        this.curr_frame = 0;
        this.animated = true;
    }

    public boolean getAnimationState() {
        return this.animated;
    }
}

