/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.bubble_birds_2.screen;

import com.ximad.bubble_birds_2.component.Field;
import com.ximad.bubble_birds_2.component.LevelButtonsBox;
import com.ximad.bubble_birds_2.component.MyIntField;
import com.ximad.bubble_birds_2.engine.Application;
import com.ximad.bubble_birds_2.engine.Bitmap;
import com.ximad.bubble_birds_2.engine.CustomButton;
import com.ximad.bubble_birds_2.engine.UiScreen;
import com.ximad.bubble_birds_2.game.DataManager;
import com.ximad.bubble_birds_2.res.Res;
import com.ximad.bubble_birds_2.screen.GameScreen;
import com.ximad.bubble_birds_2.screen.HomeScreen;
import com.ximad.bubble_birds_2.screen.ShopScreen;
import javax.microedition.lcdui.Graphics;

public class SelectLevelScreen
extends UiScreen {
    private static SelectLevelScreen instance;
    private LevelEggField[] eggs;
    private LevelButtonsBox itemsList = new LevelButtonsBox(248, 312, 4);
    private CustomButton backButton;
    private CustomButton shopButton;
    private MyIntField coinsField;

    public static SelectLevelScreen getInstance() {
        if (instance == null) {
            instance = new SelectLevelScreen();
        }
        return instance;
    }

    private SelectLevelScreen() {
        int i;
        this.eggs = new LevelEggField[100];
        for (i = 0; i < DataManager.getMaxLevel(); ++i) {
            this.eggs[i] = new LevelEggField(Res.levelOpenOff, Res.levelOpenOn, Res.font_green, DataManager.getStarsCount(i), i + 1){

                public void touchAction() {
                    SelectLevelScreen.this.levelClick(this.index);
                }
            };
            this.eggs[i].index = i + 1;
        }
        for (i = DataManager.getMaxLevel(); i < 100; ++i) {
            this.eggs[i] = new LevelEggField(Res.levelCloseOff, Res.levelCloseOn, Res.font_yellow, 0, i + 1){

                public void touchAction() {
                    SelectLevelScreen.this.levelClick(this.index);
                }
            };
            this.eggs[i].index = i + 1;
        }
        for (i = 0; i < this.eggs.length; ++i) {
            this.itemsList.add(this.eggs[i]);
        }
        this.shopButton = new CustomButton(Res.homeShopOff, Res.homeShopOn, null){

            protected void touchAction() {
                SelectLevelScreen.this.shopClick();
            }
        };
        this.backButton = new CustomButton(Res.backOff, Res.backOn, null, null){

            protected void touchAction() {
                SelectLevelScreen.this.playButtonSound();
                SelectLevelScreen.this.backClick();
            }
        };
        this.coinsField = new MyIntField(DataManager.getCoinsCount(), Res.font_default);
        this.add(this.shopButton, 114, 478);
        this.add(this.coinsField, 168, 590);
        this.add(this.backButton, 11, 553);
        this.add(this.itemsList, 60, 140);
    }

    public void backClick() {
        this.playButtonSound();
        Application.setScreen(HomeScreen.getInstance());
    }

    public void shopClick() {
        this.playButtonSound();
        Application.setScreen(ShopScreen.getInstance(this.takeScreenshot(), 1));
    }

    public void onShow() {
        for (int i = 0; i < DataManager.getMaxLevel(); ++i) {
            this.eggs[i].setOffImage(Res.levelOpenOff);
            this.eggs[i].setOnImage(Res.levelOpenOn);
            this.eggs[i].setStarCount(DataManager.getStarsCount(i));
            this.eggs[i].setFont(Res.font_green);
        }
        this.coinsField.setInt(DataManager.getCoinsCount());
        SelectLevelScreen.repaint();
        super.onShow();
    }

    public void onPaint(Graphics g) {
        Res.customBg.draw(g, 0, 0);
        super.onPaint(g);
    }

    public void levelClick(int index) {
        if (index <= DataManager.getMaxLevel()) {
            Application.setScreen(GameScreen.getInstance(index));
        }
    }

    public class LevelEggField
    extends Field {
        MyIntField numberBitmap;
        Bitmap stars;
        Bitmap offImage;
        Bitmap onImage;
        Bitmap currentImage;
        public int index;

        public LevelEggField(Bitmap offImage, Bitmap onImage, Bitmap[] font, int starCount, int number) {
            this.numberBitmap = new MyIntField(number, font);
            this.stars = Res.stars[starCount];
            this.offImage = offImage;
            this.onImage = onImage;
            this.currentImage = offImage;
            this.width = offImage.getWidth();
            this.height = offImage.getHeight();
        }

        public void setFont(Bitmap[] newFont) {
            this.numberBitmap.setFont(newFont);
        }

        public void setStarCount(int starCount) {
            this.stars = Res.stars[starCount];
        }

        public void setOffImage(Bitmap offImage) {
            this.offImage = offImage;
            this.currentImage = offImage;
        }

        public void setOnImage(Bitmap onImage) {
            this.onImage = onImage;
        }

        public void onPaint(Graphics g) {
            this.currentImage.draw(g, this.left, this.top);
            this.numberBitmap.draw(g, this.left + (this.width - this.numberBitmap.getWidth()) / 2, this.top + 30);
            this.stars.draw(g, this.left + (this.width - this.stars.getWidth()) / 2, this.top + 75);
        }

        public void touchAction() {
        }

        public boolean touchEvent(int touchEventType, int eventX, int eventY) {
            boolean out = false;
            if (eventX < this.left || eventX > this.left + this.width || eventY < this.top || eventY > this.top + this.height) {
                out = true;
            }
            switch (touchEventType) {
                case 3: {
                    return false;
                }
                case 2: {
                    if (out) {
                        return false;
                    }
                    this.currentImage = this.onImage;
                    return super.touchEvent(touchEventType, eventX, eventY);
                }
                case 1: {
                    if (out) break;
                    this.currentImage = this.offImage;
                    this.touchAction();
                }
            }
            return !out;
        }
    }
}

