/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.bubble_birds_2.screen;

import com.ximad.bubble_birds_2.Flurry;
import com.ximad.bubble_birds_2.component.Animatable;
import com.ximad.bubble_birds_2.engine.Application;
import com.ximad.bubble_birds_2.engine.CustomButton;
import com.ximad.bubble_birds_2.engine.Screen;
import com.ximad.bubble_birds_2.engine.UiScreen;
import com.ximad.bubble_birds_2.game.DataManager;
import com.ximad.bubble_birds_2.res.Res;
import com.ximad.bubble_birds_2.screen.HomeScreen;
import com.ximad.bubble_birds_2.screen.SelectLevelScreen;
import javax.microedition.lcdui.Graphics;

public class ChooseHardnessScreen
extends UiScreen {
    private CustomButton easyButton = new CustomButton(Res.easyOff, Res.easyOn, null, null){

        protected void touchAction() {
            ChooseHardnessScreen.this.easyClick();
        }
    };
    private CustomButton normalButton = new CustomButton(Res.normalOff, Res.normalOn, null, null){

        protected void touchAction() {
            ChooseHardnessScreen.this.normalClick();
        }
    };
    private CustomButton hardButton = new CustomButton(Res.hardOff, Res.hardOn, null, null){

        protected void touchAction() {
            ChooseHardnessScreen.this.hardClick();
        }
    };
    private CustomButton backButton = new CustomButton(Res.backOff, Res.backOn, null, null){

        protected void touchAction() {
            ChooseHardnessScreen.this.backClick();
        }
    };
    public static Animatable bird_1;
    public static Animatable bird_2;
    public static final AnimationThread animationThread;
    private static ChooseHardnessScreen instance;

    private ChooseHardnessScreen() {
        this.add(this.backButton, 134, 556);
        this.add(this.easyButton, 123, 207);
        this.add(this.normalButton, 109, 313);
        this.add(this.hardButton, 118, 428);
        this.add(bird_1, 0, 0);
        this.add(bird_2, 0, 0);
    }

    public static ChooseHardnessScreen getInstance() {
        if (instance == null) {
            instance = new ChooseHardnessScreen();
        }
        return instance;
    }

    public void onShow() {
        animationThread.resumeAnimation();
    }

    public void onHide() {
        animationThread.pauseAnimation();
    }

    public void onPaint(Graphics g) {
        Res.popupBg.draw(g, 0, 0);
        super.onPaint(g);
    }

    private void easyClick() {
        this.playButtonSound();
        Flurry.onChooseHardness(0);
        DataManager.setGameSpeed(0);
        Application.setScreen(SelectLevelScreen.getInstance());
    }

    private void normalClick() {
        this.playButtonSound();
        Flurry.onChooseHardness(1);
        DataManager.setGameSpeed(1);
        Application.setScreen(SelectLevelScreen.getInstance());
    }

    private void hardClick() {
        Flurry.onChooseHardness(2);
        DataManager.setGameSpeed(2);
        this.playButtonSound();
        Application.setScreen(SelectLevelScreen.getInstance());
    }

    private void backClick() {
        this.playButtonSound();
        Application.setScreen(HomeScreen.getInstance());
    }

    static {
        animationThread = new AnimationThread();
        animationThread.pauseAnimation();
        animationThread.start();
    }

    public static class AnimationThread
    extends Thread {
        private boolean paused = false;

        public AnimationThread() {
            if (bird_1 == null) {
                bird_1 = new Animatable(Res.popupBird_1[0], 43, 40);
                bird_1.animate(Res.popupBird_1, 140, Animatable.TYPE_LINEAR, true);
                bird_1.startAnimation(Animatable.TYPE_FRAME);
            }
            if (bird_2 == null) {
                bird_2 = new Animatable(Res.popupBird_2[0], 190, 40);
                bird_2.animate(Res.popupBird_2, 140, Animatable.TYPE_LINEAR, true);
                bird_2.startAnimation(Animatable.TYPE_FRAME);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int sleepTime = 50;
                while (true) {
                    if (this.paused) {
                        AnimationThread animationThread = this;
                        synchronized (animationThread) {
                            this.wait();
                        }
                    }
                    sleepTime = bird_1.frameAnimationStep();
                    bird_2.frameAnimationStep();
                    Screen.repaint();
                    AnimationThread.sleep(sleepTime);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public void pauseAnimation() {
            this.paused = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resumeAnimation() {
            this.paused = false;
            AnimationThread animationThread = this;
            synchronized (animationThread) {
                this.notifyAll();
            }
        }
    }
}

