/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.bubble_birds_2.component;

import com.ximad.bubble_birds_2.component.Field;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class CustomItemBox
extends Field {
    private Vector items;
    private Vector tops;
    private boolean SCROLL;
    private int lastEventY;
    private int scrollPosition;
    private int maxPosition;
    private int delta;
    private int speed;
    private int begin;
    boolean inertion = false;

    public CustomItemBox(int w, int h) {
        this.width = w;
        this.height = h;
        this.items = new Vector();
        this.tops = new Vector();
    }

    public void onPaint(Graphics g) {
        g.clipRect(this.left, this.top, this.width, this.height);
        for (int i = 0; i < this.items.size(); ++i) {
            ((Field)this.items.elementAt((int)i)).left = this.left;
            ((Field)this.items.elementAt((int)i)).top = (Integer)this.tops.elementAt(i) - this.scrollPosition + this.top;
            ((Field)this.items.elementAt(i)).onPaint(g);
        }
    }

    public void add(Field f) {
        f.top = this.maxPosition;
        this.items.addElement(f);
        this.maxPosition += f.getHeight() + 10;
        this.tops.addElement(new Integer(f.top));
    }

    public void add(Field[] f) {
        for (int i = 0; i < f.length; ++i) {
            this.add(f[i]);
        }
    }

    public void onIdle() {
        if (this.inertion && this.begin > 10) {
            if (this.delta > 0) {
                this.scrollPosition -= this.speed * 2;
            } else if (this.delta < 0) {
                this.scrollPosition += this.speed * 2;
            }
            if (this.scrollPosition < 0) {
                this.scrollPosition = 0;
            } else if (this.scrollPosition > this.getMaxScrollPosition()) {
                this.scrollPosition = this.getMaxScrollPosition();
            }
            --this.speed;
            if (this.speed == 0) {
                this.inertion = false;
            }
            this.repaint(this.left, this.top, this.width, this.height);
        }
    }

    public int getMaxPosition() {
        return this.maxPosition;
    }

    public int getMaxScrollPosition() {
        return this.maxPosition - this.height;
    }

    public boolean touchEvent(int touchEventType, int eventX, int eventY) {
        boolean out = false;
        if (eventX < this.left || eventX > this.left + this.width || eventY < this.top || eventY > this.top + this.height) {
            out = true;
        }
        switch (touchEventType) {
            case 2: {
                if (out) {
                    return false;
                }
                this.SCROLL = true;
                this.lastEventY = eventY;
                this.begin = eventY;
                this.inertion = false;
                break;
            }
            case 1: {
                this.SCROLL = false;
                if (this.delta > 1 || this.delta < -1) {
                    this.inertion = true;
                    this.speed = 10;
                }
                this.begin = eventY - this.begin;
                if (this.begin >= 0) break;
                this.begin *= -1;
                break;
            }
            case 3: {
                if (!this.SCROLL) {
                    return false;
                }
                this.delta = eventY - this.lastEventY;
                this.scrollPosition -= this.delta;
                this.lastEventY = eventY;
                if (this.scrollPosition < 0) {
                    this.scrollPosition = 0;
                } else if (this.scrollPosition > this.getMaxScrollPosition()) {
                    this.scrollPosition = this.getMaxScrollPosition();
                }
                this.repaint(this.left, this.top, this.width, this.height);
            }
        }
        return !out;
    }

    public void setLeft(int l) {
        this.left = l;
    }

    public void setTop(int t) {
        this.top = t;
    }
}

