/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.bubble_birds_2.screen;

import com.ximad.bubble_birds_2.Consts;
import com.ximad.bubble_birds_2.Flurry;
import com.ximad.bubble_birds_2.audio.SoundSystem;
import com.ximad.bubble_birds_2.component.MyAnim;
import com.ximad.bubble_birds_2.component.MyIntField;
import com.ximad.bubble_birds_2.engine.Application;
import com.ximad.bubble_birds_2.engine.Bitmap;
import com.ximad.bubble_birds_2.engine.CustomButton;
import com.ximad.bubble_birds_2.engine.UiScreen;
import com.ximad.bubble_birds_2.game.DataManager;
import com.ximad.bubble_birds_2.res.Res;
import com.ximad.bubble_birds_2.screen.AboutScreen;
import com.ximad.bubble_birds_2.screen.ChooseHardnessScreen;
import com.ximad.bubble_birds_2.screen.InstructionsScreen;
import com.ximad.bubble_birds_2.screen.ScoresScreen;
import com.ximad.bubble_birds_2.screen.ShopScreen;
import com.ximad.bubble_birds_2.utils.Utils;
import javax.microedition.lcdui.Graphics;

public class HomeScreen
extends UiScreen {
    private static HomeScreen instance;
    private CustomButton playButton;
    private CustomButton scoreboardButton;
    private CustomButton aboutButton;
    private CustomButton instructButton;
    private CustomButton exitButton;
    private CustomButton shopButton;
    private CustomButton soundButton;
    private MyIntField coinsField;
    private Bitmap[] birds;
    private int[] birdTypes;
    private boolean birdAreFalling = false;
    private MyAnim[] fallingBirds;
    AnimThread thread;

    public void init() {
        int i;
        this.birds = new Bitmap[Consts.HOME_BIRDS_X.length];
        this.birdTypes = new int[this.birds.length];
        for (i = 0; i < this.birds.length; ++i) {
            this.birdTypes[i] = Utils.random(0, 6);
            this.birds[i] = Res.birds[this.birdTypes[i]];
        }
        this.coinsField = new MyIntField(DataManager.getCoinsCount(), Res.font_default);
        this.soundButton = !DataManager.getSoundState() ? new CustomButton(Res.homeSoundOff, Res.homeSoundOff, null){

            protected void touchAction() {
                HomeScreen.this.soundClick();
            }
        } : new CustomButton(Res.homeSoundOn, Res.homeSoundOn, null){

            protected void touchAction() {
                HomeScreen.this.soundClick();
            }
        };
        this.shopButton = new CustomButton(Res.homeShopOff, Res.homeShopOn, null){

            protected void touchAction() {
                HomeScreen.this.shopClick();
            }
        };
        this.playButton = new CustomButton(Res.homePlayOff, Res.homePlayOn, null){

            protected void touchAction() {
                HomeScreen.this.playClick();
            }
        };
        this.scoreboardButton = new CustomButton(Res.homeScoreboardOff, Res.homeScoreboardOn, null){

            protected void touchAction() {
                HomeScreen.this.openScores();
            }
        };
        this.aboutButton = new CustomButton(Res.homeAboutOff, Res.homeAboutOn, null){

            protected void touchAction() {
                HomeScreen.this.openAbout();
            }
        };
        this.instructButton = new CustomButton(Res.homeInstructionsOff, Res.homeInstructionsOn, null){

            protected void touchAction() {
                HomeScreen.this.openInstructions();
            }
        };
        this.exitButton = new CustomButton(Res.homeExitOff, Res.homeExitOn, null){

            protected void touchAction() {
                HomeScreen.this.quitGame();
            }
        };
        this.add(this.playButton, 82, 34);
        this.add(this.scoreboardButton, 27, 164);
        this.add(this.aboutButton, 82, 278);
        this.add(this.instructButton, 243, 497);
        this.add(this.exitButton, 92, 368);
        this.add(this.shopButton, 112, 457);
        this.add(this.coinsField, 168, 568);
        this.add(this.soundButton, 0, 487);
        Res.popupBg = HomeScreen.makePopupBg(Res.homeBg);
        if (Res.background[0] == null) {
            for (i = 0; i < 5; ++i) {
                Res.background[i] = Bitmap.getBitmapResource("/img/360x640cut/screens/gamescreen/backgrounds/" + (i + 1) + "/bg.jpg");
                Res.deadline[i] = Bitmap.getBitmapResource("/img/360x640cut/screens/gamescreen/backgrounds/" + (i + 1) + "/line.png");
            }
        }
    }

    public void shopClick() {
        Application.setScreen(ShopScreen.getInstance(this.takeScreenshot(), 0));
    }

    public HomeScreen() {
        this.init();
    }

    public void onPaint(Graphics g) {
        Res.homeBg.draw(g, 0, 0);
        super.onPaint(g);
        if (!this.birdAreFalling) {
            for (int i = 0; i < this.birds.length; ++i) {
                this.birds[i].draw(g, Consts.HOME_BIRDS_X[i], Consts.HOME_BIRDS_Y[i]);
            }
        } else if (!this.thread.stopped) {
            boolean cont = false;
            for (int i = 0; i < this.fallingBirds.length; ++i) {
                Bitmap b = this.fallingBirds[i].getBitmap();
                cont |= b != null;
                if (b == null) continue;
                b.draw(g, this.fallingBirds[i].getX(), this.fallingBirds[i].getY());
            }
            this.thread.stopped = !cont;
        }
    }

    public void playClick() {
        this.thread = null;
        this.thread = new AnimThread(){

            public void onFinish() {
                Application.setScreen(ChooseHardnessScreen.getInstance());
            }
        };
        this.fall();
    }

    private void openScores() {
        Flurry.onScoresClick();
        this.thread = null;
        this.thread = new AnimThread(){

            public void onFinish() {
                Application.setScreen(ScoresScreen.getInstance());
            }
        };
        this.fall();
    }

    private void openAbout() {
        Application.setScreen(AboutScreen.getInstance());
    }

    private void openInstructions() {
        this.playButtonSound();
        Application.setScreen(InstructionsScreen.getInstance());
    }

    private void openQuit() {
        this.quitGame();
    }

    public static HomeScreen getInstance() {
        Res.popupBg = HomeScreen.makePopupBg(Res.homeBg);
        if (instance == null) {
            instance = new HomeScreen();
        }
        return instance;
    }

    public void onShow() {
        this.coinsField.setInt(DataManager.getCoinsCount());
        this.birdAreFalling = false;
        this.fallingBirds = null;
        for (int i = 0; i < this.birds.length; ++i) {
            this.birdTypes[i] = Utils.random(0, 6);
            this.birds[i] = Res.birds[this.birdTypes[i]];
        }
        super.onShow();
    }

    private void soundClick() {
        DataManager.changeSoundState();
        if (DataManager.getSoundState()) {
            this.playButtonSound();
            DataManager.setSoundState(false);
            SoundSystem.SOUND_MAIN_THEME.stop();
            this.soundButton.setOffImage(Res.homeSoundOff);
            this.soundButton.setOnImage(Res.homeSoundOff);
        } else {
            DataManager.setSoundState(true);
            SoundSystem.SOUND_MAIN_THEME.play();
            this.soundButton.setOffImage(Res.homeSoundOn);
            this.soundButton.setOnImage(Res.homeSoundOn);
        }
    }

    private void fall() {
        SoundSystem.SOUND_FALL_5.play();
        this.birdAreFalling = true;
        this.fallingBirds = new MyAnim[this.birdTypes.length];
        for (int i = 0; i < this.fallingBirds.length; ++i) {
            this.fallingBirds[i] = new MyAnim(Res.birdsFalling[this.birdTypes[i]], Consts.HOME_BIRDS_X[i], Consts.HOME_BIRDS_Y[i], Consts.HOME_BIRDS_X[i], 640, 1250 + Utils.random(0, 500));
        }
        this.thread.start();
    }

    private void quitGame() {
        Application.quit();
    }

    private class AnimThread
    extends Thread {
        boolean stopped = false;

        private AnimThread() {
        }

        public void run() {
            while (!this.stopped) {
                Application.canvas.repaint(107, 15, 185, 625);
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.onFinish();
        }

        public void onFinish() {
        }
    }
}

