/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.bubble_birds_2.screen;

import com.ximad.bubble_birds_2.audio.SoundSystem;
import com.ximad.bubble_birds_2.component.Animatable;
import com.ximad.bubble_birds_2.component.BitmapField;
import com.ximad.bubble_birds_2.component.CustomIntField;
import com.ximad.bubble_birds_2.engine.Application;
import com.ximad.bubble_birds_2.engine.Bitmap;
import com.ximad.bubble_birds_2.engine.CustomButton;
import com.ximad.bubble_birds_2.engine.CustomLabelField;
import com.ximad.bubble_birds_2.engine.Screen;
import com.ximad.bubble_birds_2.engine.UiScreen;
import com.ximad.bubble_birds_2.game.DataManager;
import com.ximad.bubble_birds_2.res.Res;
import com.ximad.bubble_birds_2.screen.EnterNameScreen;
import com.ximad.bubble_birds_2.screen.GameScreen;
import com.ximad.bubble_birds_2.screen.HomeScreen;
import com.ximad.bubble_birds_2.screen.ScoresScreen;
import com.ximad.bubble_birds_2.screen.ShopScreen;
import javax.microedition.lcdui.Graphics;

public class GamePopupScreen
extends UiScreen {
    public static final int WIN_LVL = 0;
    public static final int ENTER = 1;
    public static final int WIN_ALL = 3;
    public static final int LOSE_ALL = 4;
    public static final int CLEAR = 6;
    public static final int RATE = 9;
    public static final int POPUPS_COUNT = 10;
    private static GamePopupScreen[] instances = new GamePopupScreen[10];
    public static String playerName;
    public static CustomButton name_button;
    public static CustomLabelField name_text;
    private Bitmap background;
    private BitmapField popup_body;
    CustomButton popup_no_btn;
    CustomButton popup_yes_btn;
    public static Animatable bird_1;
    public static Animatable bird_2;
    public static final AnimationThread animationThread;
    private CustomIntField level_field;
    private CustomIntField score_field;
    private CustomIntField coins_field;
    private CustomIntField total_field;
    private int pop_type;
    static int t_w;

    public GamePopupScreen(int type) {
        this.pop_type = type;
        this.init();
    }

    private void init() {
        this.background = Res.popupBg;
        if (this.pop_type == 0) {
            this.level_field = new CustomIntField(DataManager.currLevel, 213, 240, Res.font_popup);
            this.score_field = new CustomIntField(DataManager.currScore, 236, 322, Res.font_popup);
            this.coins_field = new CustomIntField(DataManager.currCoins, 193, 355, Res.font_popup);
            this.total_field = new CustomIntField(DataManager.getScore(), 183, 436, Res.font_popup);
            this.popup_body = new BitmapField(Res.popupWinLvl);
            this.popup_yes_btn = new CustomButton(Res.popupOkOff, Res.popupOkOn, null, null){

                protected void touchAction() {
                    GamePopupScreen.this.removeAdsFromScreen();
                    GamePopupScreen.this.playButtonSound();
                    if (DataManager.getCoinsCount() >= 10) {
                        Application.setScreen(ShopScreen.getInstance(GamePopupScreen.this.takeScreenshot(), 2));
                    } else {
                        Application.setScreen(GameScreen.getInstance(DataManager.currLevel));
                    }
                }
            };
            this.add(this.popup_body, 77, 195);
            this.add(bird_1, 0, 0);
            this.add(bird_2, 0, 0);
            this.add(this.level_field, 0, 0);
            this.add(this.score_field, 0, 0);
            this.add(this.coins_field, 0, 0);
            this.add(this.total_field, 0, 0);
            this.add(this.popup_yes_btn, 162, 478);
            ++DataManager.currLevel;
        } else if (this.pop_type == 3) {
            this.total_field = new CustomIntField(DataManager.getScore(), 183, 429, Res.font_popup);
            this.popup_body = new BitmapField(Res.popupWinGame);
            this.popup_yes_btn = new CustomButton(Res.popupOkOff, Res.popupOkOn, null, null){

                protected void touchAction() {
                    GamePopupScreen.this.removeAdsFromScreen();
                    GamePopupScreen.this.playButtonSound();
                    if (DataManager.getScore() == 0 || DataManager.getPlayerPosition(DataManager.getScore()) == -1) {
                        Application.setScreen(HomeScreen.getInstance());
                    } else {
                        Application.setScreen(GamePopupScreen.getInstance(1));
                    }
                }
            };
            this.add(this.popup_body, 77, 195);
            this.add(bird_1, 0, 0);
            this.add(bird_2, 0, 0);
            this.add(this.total_field, 0, 0);
            this.add(this.popup_yes_btn, 162, 478);
        } else if (this.pop_type == 4) {
            this.total_field = new CustomIntField(DataManager.getScore(), 181, 367, Res.font_popup);
            DataManager.setScore(0);
            DataManager.currScore = 0;
            this.popup_body = new BitmapField(Res.popupLoseAll);
            this.popup_yes_btn = new CustomButton(Res.popupYesOff, Res.popupYesOn, null, null){

                protected void touchAction() {
                    GamePopupScreen.this.playButtonSound();
                    Application.setScreen(GameScreen.getInstance(1));
                }
            };
            this.popup_no_btn = new CustomButton(Res.popupNoOff, Res.popupNoOn, null, null){

                protected void touchAction() {
                    GamePopupScreen.this.removeAdsFromScreen();
                    GamePopupScreen.this.playButtonSound();
                    Application.setScreen(HomeScreen.getInstance());
                }
            };
            this.add(this.popup_body, 77, 195);
            this.add(bird_1, 0, 0);
            this.add(bird_2, 0, 0);
            this.add(this.total_field, 0, 0);
            this.add(this.popup_yes_btn, 103, 475);
            this.add(this.popup_no_btn, 216, 475);
        } else if (this.pop_type == 6) {
            this.popup_body = new BitmapField(Res.popupClear);
            this.popup_yes_btn = new CustomButton(Res.popupYesOff, Res.popupYesOn, null, null){

                protected void touchAction() {
                    GamePopupScreen.this.playButtonSound();
                    DataManager.clearScores();
                    GamePopupScreen.this.returnToMenu();
                }
            };
            this.popup_no_btn = new CustomButton(Res.popupNoOff, Res.popupNoOn, null, null){

                protected void touchAction() {
                    GamePopupScreen.this.playButtonSound();
                    GamePopupScreen.this.returnToMenu();
                }
            };
            this.add(this.popup_body, 77, 195);
            this.add(bird_1, 0, 0);
            this.add(bird_2, 0, 0);
            this.add(this.popup_yes_btn, 103, 475);
            this.add(this.popup_no_btn, 216, 475);
        } else if (this.pop_type == 1) {
            this.popup_body = new BitmapField(Res.popupEnter);
            this.popup_yes_btn = new CustomButton(Res.popupOkOff, Res.popupOkOn, null, null){

                protected void touchAction() {
                    GamePopupScreen.this.set_name();
                }
            };
            name_button = new CustomButton(147, 26){

                protected void touchAction() {
                    Application.setScreen(EnterNameScreen.getInstance());
                }
            };
            name_text = new CustomLabelField("Champion", 19, 0);
            t_w = name_text.getWidth();
            this.add(this.popup_body, 77, 195);
            this.add(name_text, (360 - t_w) / 2, 412);
            this.add(bird_1, 0, 0);
            this.add(bird_2, 0, 0);
            this.add(name_button, 132, 412);
            this.add(this.popup_yes_btn, 162, 453);
        } else if (this.pop_type == 9) {
            this.popup_body = new BitmapField(Res.popupRate);
            this.popup_yes_btn = new CustomButton(Res.popupBtnRate, Res.popupBtnRatePress, null, null){

                protected void touchAction() {
                    GamePopupScreen.this.removeAdsFromScreen();
                    GamePopupScreen.this.playButtonSound();
                    Application.isRating = true;
                    try {
                        Application.getInstance().platformRequest("http://store.ovi.com/content/262559");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Application.setScreen(HomeScreen.getInstance());
                }
            };
            this.popup_no_btn = new CustomButton(Res.popupBtnCancel, Res.popupBtnCancelPress, null, null){

                protected void touchAction() {
                    GamePopupScreen.this.removeAdsFromScreen();
                    GamePopupScreen.this.playButtonSound();
                    Application.setScreen(HomeScreen.getInstance());
                }
            };
            this.add(bird_1, 0, 0);
            this.add(bird_2, 0, 0);
            this.add(this.popup_body, 77, 195);
            this.add(this.popup_yes_btn, 91, 459);
            this.add(this.popup_no_btn, 202, 459);
        }
        if (this.pop_type == 0 || this.pop_type == 3) {
            SoundSystem.SOUND_LEVEL_END.play();
        } else if (this.pop_type == 4) {
            SoundSystem.SOUND_GAME_LOSE.play();
        }
    }

    public void onShow() {
        animationThread.resumeAnimation();
    }

    public void onHide() {
        animationThread.pauseAnimation();
    }

    private void initExisting() {
        this.background = Res.popupBg;
        if (this.pop_type == 0) {
            this.level_field.set_int(DataManager.currLevel);
            this.score_field.set_int(DataManager.currScore);
            this.coins_field.set_int(DataManager.currCoins);
            this.total_field.set_int(DataManager.getScore());
            this.popup_body.setBitmap(Res.popupWinLvl);
            ++DataManager.currLevel;
        } else if (this.pop_type == 3) {
            this.total_field.set_int(DataManager.getScore());
            this.popup_body.setBitmap(Res.popupWinGame);
        } else if (this.pop_type == 4) {
            this.total_field.set_int(DataManager.getScore());
            this.popup_body.setBitmap(Res.popupLoseAll);
        } else if (this.pop_type == 6) {
            this.popup_body.setBitmap(Res.popupClear);
        } else if (this.pop_type == 1) {
            this.popup_body.setBitmap(Res.popupEnter);
        }
        if (this.pop_type == 0 || this.pop_type == 3) {
            SoundSystem.SOUND_LEVEL_END.play();
        }
    }

    public void onPaint(Graphics g) {
        this.background.draw(g, 0, 0);
        super.onPaint(g);
    }

    private void returnToMenu() {
        this.processClose();
    }

    public void set_name() {
        this.removeAdsFromScreen();
        this.playButtonSound();
        DataManager.addResultToScoreboard(name_text.getText(), DataManager.getScore());
        DataManager.setScore(0);
        DataManager.currScore = 0;
        Application.setScreen(ScoresScreen.getInstance());
    }

    public void close() {
        this.processClose();
    }

    private void processClose() {
        this.removeAdsFromScreen();
        if (this.pop_type == 1) {
            this.playButtonSound();
            this.set_name();
        } else if (this.pop_type == 0) {
            this.playButtonSound();
            Application.setScreen(ShopScreen.getInstance(this.takeScreenshot(), 2));
        } else if (this.pop_type == 3 || this.pop_type == 4) {
            this.playButtonSound();
            if (DataManager.getScore() == 0 || DataManager.getPlayerPosition(DataManager.getScore()) == -1) {
                Application.setScreen(HomeScreen.getInstance());
            } else {
                Application.setScreen(GamePopupScreen.getInstance(1));
            }
        } else {
            this.playButtonSound();
            Application.setScreen(HomeScreen.getInstance());
        }
    }

    public void removeAdsFromScreen() {
    }

    public static GamePopupScreen getInstance(int popupType) {
        if (name_text != null) {
            t_w = name_text.getWidth();
            name_text.setPosition((360 - t_w) / 2, 412);
        }
        try {
            if (instances[popupType] == null) {
                GamePopupScreen.instances[popupType] = new GamePopupScreen(popupType);
            } else {
                instances[popupType].initExisting();
            }
            return instances[popupType];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
    }

    public static void setPlayerName(String name) {
        playerName = name;
        name_text.setText(name);
    }

    static {
        animationThread = new AnimationThread();
        animationThread.pauseAnimation();
        animationThread.start();
    }

    public static class AnimationThread
    extends Thread {
        private boolean paused = false;

        public AnimationThread() {
            if (bird_1 == null) {
                bird_1 = new Animatable(Res.popupBird_1[0], 43, 40);
                bird_1.animate(Res.popupBird_1, 140, Animatable.TYPE_LINEAR, true);
                bird_1.startAnimation(Animatable.TYPE_FRAME);
            }
            if (bird_2 == null) {
                bird_2 = new Animatable(Res.popupBird_2[0], 190, 40);
                bird_2.animate(Res.popupBird_2, 140, Animatable.TYPE_LINEAR, true);
                bird_2.startAnimation(Animatable.TYPE_FRAME);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int sleepTime = 50;
                while (true) {
                    if (this.paused) {
                        AnimationThread animationThread = this;
                        synchronized (animationThread) {
                            this.wait();
                        }
                    }
                    sleepTime = bird_1.frameAnimationStep();
                    bird_2.frameAnimationStep();
                    Screen.repaint();
                    AnimationThread.sleep(sleepTime);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public void pauseAnimation() {
            this.paused = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resumeAnimation() {
            this.paused = false;
            AnimationThread animationThread = this;
            synchronized (animationThread) {
                this.notifyAll();
            }
        }
    }
}

