/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.bubble_birds_2.game;

import com.ximad.bubble_birds_2.audio.SoundManager;
import com.ximad.bubble_birds_2.component.Scoreboard;
import com.ximad.bubble_birds_2.game.AppSettings;

public class DataManager {
    private static AppSettings appSettings;
    private static int gameSpeed;
    private static boolean isSoundEnabled;
    private static Scoreboard[] scoreboard;
    private static int currentSoundLevel;
    private static int prevSoundLevel;
    public static boolean isRated;
    public static int launchNumber;
    public static boolean isAdPopupNeeded;
    public static boolean isVideoAdReady;
    public static int playedGamesNumber;
    public static boolean shop_flag;
    public static boolean game_flag;
    public static int currCoins;
    public static int currLevel;
    public static int bgIndex;
    private static int score;
    private static int coinsCount;
    private static int maxLevel;
    private static int[] starsForLevel;
    private static int bombCount;
    private static int anyCount;
    public static int currScore;
    private static int currStars;

    public DataManager() {
        appSettings = new AppSettings();
        appSettings.init("bubble_birds_2.0.0_360x640");
        DataManager.setDefaultSettings();
        DataManager.loadSettings();
    }

    public static void setDefaultSettings() {
        scoreboard = new Scoreboard[10];
        starsForLevel = new int[100];
        for (int i = 0; i < scoreboard.length; ++i) {
            DataManager.scoreboard[i] = new Scoreboard();
        }
        isSoundEnabled = true;
        isRated = false;
        launchNumber = 1;
        gameSpeed = 1;
        isAdPopupNeeded = true;
        isVideoAdReady = false;
        playedGamesNumber = 0;
        shop_flag = false;
        game_flag = false;
        currentSoundLevel = 50;
        DataManager.setCurrentSoundLvl(currentSoundLevel);
    }

    public static boolean loadSettings() {
        try {
            int i;
            if (appSettings.containsItem("GameSpeed")) {
                gameSpeed = (Integer)appSettings.getItem("GameSpeed");
            }
            if (appSettings.containsItem("TotalScore")) {
                score = (Integer)appSettings.getItem("TotalScore");
            }
            coinsCount = appSettings.containsItem("CoinsCount") ? (Integer)appSettings.getItem("CoinsCount") : 0;
            maxLevel = appSettings.containsItem("MaxLevel") ? (Integer)appSettings.getItem("MaxLevel") : 1;
            for (i = 0; i < starsForLevel.length && appSettings.containsItem("StarsForLevel_" + i); ++i) {
                DataManager.starsForLevel[i] = (Integer)appSettings.getItem("StarsForLevel_" + i);
            }
            if (appSettings.containsItem("AnyCount")) {
                anyCount = (Integer)appSettings.getItem("AnyCount");
            }
            if (appSettings.containsItem("BombCount")) {
                bombCount = (Integer)appSettings.getItem("BombCount");
            }
            if (appSettings.containsItem("SoundState")) {
                isSoundEnabled = (Boolean)appSettings.getItem("SoundState");
            }
            for (i = 0; i < scoreboard.length && appSettings.containsItem("Score_name_" + i); ++i) {
                scoreboard[i].setName("" + appSettings.getItem("Score_name_" + i));
                scoreboard[i].setScore(Integer.parseInt("" + appSettings.getItem("Score_value_" + i)));
            }
            if (appSettings.containsItem("IsRated")) {
                isRated = (Boolean)appSettings.getItem("IsRated");
            }
            if (appSettings.containsItem("LnchNmb")) {
                launchNumber = (Integer)appSettings.getItem("LnchNmb") + 1;
            }
            if (appSettings.containsItem("shpFlag")) {
                shop_flag = (Boolean)appSettings.getItem("shpFlag");
            }
            if (appSettings.containsItem("gameFlag")) {
                game_flag = (Boolean)appSettings.getItem("gameFlag");
            }
            if (appSettings.containsItem("sndLvl")) {
                currentSoundLevel = (Integer)appSettings.getItem("sndLvl");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static void saveSettings() {
        try {
            int i;
            appSettings.setItem("GameSpeed", new Integer(gameSpeed));
            appSettings.setItem("TotalScore", new Integer(score));
            appSettings.setItem("CoinsCount", new Integer(coinsCount));
            appSettings.setItem("MaxLevel", new Integer(maxLevel));
            for (i = 0; i < starsForLevel.length && starsForLevel[i] > 0; ++i) {
                appSettings.setItem("StarsForLevel_" + i, new Integer(starsForLevel[i]));
            }
            appSettings.setItem("BombCount", new Integer(bombCount));
            appSettings.setItem("AnyCount", new Integer(anyCount));
            appSettings.setItem("SoundState", isSoundEnabled ? Boolean.TRUE : Boolean.FALSE);
            appSettings.setItem("IsRated", isRated ? Boolean.TRUE : Boolean.FALSE);
            appSettings.setItem("shpFlag", shop_flag ? Boolean.TRUE : Boolean.FALSE);
            appSettings.setItem("gameFlag", game_flag ? Boolean.TRUE : Boolean.FALSE);
            appSettings.setItem("sndLvl", new Integer(currentSoundLevel));
            appSettings.setItem("LnchNmb", new Integer(launchNumber));
            for (i = 0; i < 10 && scoreboard[i].getScore() > 0; ++i) {
                appSettings.setItem("Score_name_" + i, scoreboard[i].getName());
                appSettings.setItem("Score_value_" + i, new Integer(scoreboard[i].getScore()));
            }
            appSettings.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isSavedGameEnabled() {
        return appSettings.containsItem("LevelData");
    }

    public static int getGameSpeed() {
        return gameSpeed;
    }

    public static void setGameSpeed(int value) {
        gameSpeed = value;
    }

    public static void changeSoundState() {
        if (isSoundEnabled) {
            prevSoundLevel = currentSoundLevel;
            DataManager.setCurrentSoundLvl(0);
        } else {
            DataManager.setCurrentSoundLvl(prevSoundLevel);
        }
        DataManager.onChangeVolume();
    }

    private static void onChangeVolume() {
    }

    public static boolean getSoundState() {
        return isSoundEnabled;
    }

    public static void setSoundState(boolean state) {
        isSoundEnabled = state;
    }

    public static int getCurrentSoundLvl() {
        return currentSoundLevel;
    }

    public static void setCurrentSoundLvl(int lvl) {
        currentSoundLevel = lvl;
    }

    public static Scoreboard getScoreboardRow(int i) {
        return scoreboard[i];
    }

    public static void setScoreboardRow(int rowIndex, String name, int score) {
        scoreboard[rowIndex].setName(name);
        scoreboard[rowIndex].setScore(score);
    }

    public static int getPlayerPosition(int score) {
        for (int i = 0; i < scoreboard.length; ++i) {
            if (score < scoreboard[i].getScore()) continue;
            return i;
        }
        return -1;
    }

    public static void addResultToScoreboard(String name, int score) {
        int playerPos = DataManager.getPlayerPosition(score);
        for (int i = scoreboard.length - 1; i > playerPos; --i) {
            scoreboard[i].setName(scoreboard[i - 1].getName());
            scoreboard[i].setScore(scoreboard[i - 1].getScore());
        }
        scoreboard[playerPos].setName(name);
        scoreboard[playerPos].setScore(score);
    }

    public static void clearScores() {
        for (int i = 0; i < scoreboard.length; ++i) {
            scoreboard[i].setName("");
            scoreboard[i].setScore(0);
        }
        DataManager.saveSettings();
    }

    public static void stopSound() {
        SoundManager.stop();
    }

    public static void setScore(int score) {
        DataManager.score = score;
    }

    public static int getScore() {
        return score;
    }

    public static void setCoinsCount(int coinsCount) {
        DataManager.coinsCount = coinsCount;
    }

    public static int getCoinsCount() {
        return coinsCount;
    }

    public static void setMaxLevel(int maxLevel) {
        DataManager.maxLevel = maxLevel;
    }

    public static int getMaxLevel() {
        return maxLevel;
    }

    public static int getStarsCount(int forLevel) {
        return starsForLevel[forLevel];
    }

    public static void setStarsCount(int forLevel, int withValue) {
        DataManager.starsForLevel[forLevel] = withValue;
    }

    public static void setBombCount(int bombCount) {
        DataManager.bombCount = bombCount;
    }

    public static int getBombCount() {
        return bombCount;
    }

    public static void setAnyCount(int anyCount) {
        DataManager.anyCount = anyCount;
    }

    public static int getAnyCount() {
        return anyCount;
    }

    public static void setCurrStars(int currStars) {
        DataManager.currStars = currStars;
    }

    public static int getCurrStars() {
        return currStars;
    }

    static {
        prevSoundLevel = 10;
    }
}

