/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.bubble_birds_2.component;

import com.ximad.bubble_birds_2.component.Field;
import com.ximad.bubble_birds_2.engine.Bitmap;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MyIntField
extends Field {
    public int number = 0;
    Bitmap[] arr;

    public void setInt(int n) {
        if (n == this.number) {
            return;
        }
        this.number = n;
        this.repaint();
    }

    public MyIntField() {
    }

    public void setFont(Bitmap[] f) {
        this.arr = f;
    }

    public MyIntField(int n, Bitmap[] b) {
        this.arr = b;
        this.number = n;
        if (n == 0) {
            this.width = this.arr[0].getWidth();
            this.height = this.arr[0].getHeight();
        } else {
            for (int k = n; k > 0; k /= 10) {
                this.height = Math.max(this.arr[k % 10].getHeight(), this.height);
                this.width += this.arr[k % 10].getWidth();
            }
        }
        this.repaint();
    }

    public void onPaint(Graphics g) {
        this.height = 0;
        this.width = 0;
        int k = this.number;
        if (k < 10) {
            this.drawDigit(k, g);
        } else {
            int div = 1;
            while (k > 0) {
                k /= 10;
                div *= 10;
            }
            div /= 10;
            while (div > 0) {
                this.drawDigit(this.number / div % 10, g);
                div /= 10;
            }
        }
    }

    private void drawDigit(int thisDigit, Graphics usingGraphics) {
        this.height = Math.max(this.arr[thisDigit].getHeight(), this.height);
        this.arr[thisDigit].draw(usingGraphics, this.left + this.width, this.top);
        this.width += this.arr[thisDigit].getWidth();
    }

    public void draw(Graphics g, int x, int y) {
        this.left = x;
        this.top = y;
        this.onPaint(g);
    }

    public void setLeft(int l) {
        this.left = l;
        this.repaint();
    }

    public void setTop(int t) {
        this.top = t;
        this.repaint();
    }

    public static Bitmap toBitmap(int number, Bitmap[] src) {
        String text = String.valueOf(number);
        int wh = src[0].getWidth();
        int ht = src[0].getHeight();
        int l = text.length();
        Image fon = Image.createImage((int)(wh * l), (int)ht);
        Graphics g = fon.getGraphics();
        for (int i = 0; i < l; ++i) {
            src[Integer.parseInt(text.substring(i, i + 1))].draw(g, i * wh, 0);
        }
        return new Bitmap(fon);
    }
}

