/*
 * Decompiled with CFR 0.152.
 */
package com.ea.sdk;

public class SDKHashtable {
    private static int[] prime_list = new int[]{11, 31, 61, 101, 211, 499, 1543};
    private int SIZE;
    private Object[] T;
    private int[] keys;
    private int DELETED = -1;

    public SDKHashtable(int n) {
        n += n >> 2;
        for (int i = 0; i < prime_list.length; ++i) {
            if (n >= prime_list[i]) continue;
            this.SIZE = prime_list[i];
            this.T = new Object[this.SIZE];
            this.keys = new int[this.SIZE];
            return;
        }
        this.SIZE = prime_list[prime_list.length - 1];
        this.T = new Object[this.SIZE];
        this.keys = new int[this.SIZE];
    }

    public Object get(int n) {
        int n2 = 0;
        int n3 = this.hash(n, n2);
        while ((this.T[n3] != null || this.keys[n3] == this.DELETED) && n2 < this.SIZE) {
            if (this.keys[n3] == n) {
                return this.T[n3];
            }
            n3 = this.hash(n, ++n2);
        }
        return null;
    }

    public void put(int n, Object object) {
        for (int i = 0; i < this.SIZE; ++i) {
            int n2 = this.hash(n, i);
            if (this.T[n2] != null && this.keys[n2] != this.DELETED) continue;
            this.T[n2] = object;
            this.keys[n2] = n;
            return;
        }
    }

    public void remove(int n) {
        for (int i = 0; i < this.SIZE; ++i) {
            int n2 = this.hash(n, i);
            if (this.T[n2] == null) {
                return;
            }
            if (this.keys[n2] != n) continue;
            this.keys[n2] = this.DELETED;
            this.T[n2] = null;
            return;
        }
    }

    private int hash(int n, int n2) {
        return (n % this.SIZE + n2 * (1 + n % (this.SIZE - 1))) % this.SIZE;
    }

    public void reset() {
        this.T = null;
        this.keys = null;
        System.gc();
        this.T = new Object[this.SIZE];
        this.keys = new int[this.SIZE];
    }
}

