/*
 * Decompiled with CFR 0.152.
 */
package com.ea.sdk;

import java.io.UnsupportedEncodingException;

public class SDKString {
    public static final int CHAR_ENCODING_UTF16BE = 0;
    public static final int CHAR_ENCODING_ASCII = 1;
    static final int CHAR_ENCODING_ISO8859_1 = 2;
    static final int CHAR_ENCODING_ISO8859_2 = 3;
    static final int CHAR_ENCODING_ISO8859_3 = 4;
    static final int CHAR_ENCODING_ISO8859_4 = 5;
    static final int CHAR_ENCODING_ISO8859_5 = 6;
    static final int CHAR_ENCODING_ISO8859_6 = 7;
    static final int CHAR_ENCODING_ISO8859_7 = 8;
    static final int CHAR_ENCODING_ISO8859_8 = 9;
    static final int CHAR_ENCODING_ISO8859_9 = 10;
    static final int CHAR_ENCODING_ISO8859_10 = 11;
    static final int CHAR_ENCODING_ISO8859_11 = 12;
    static final int CHAR_ENCODING_ISO8859_12 = 13;
    static final int CHAR_ENCODING_ISO8859_13 = 14;
    static final int CHAR_ENCODING_ISO8859_14 = 15;
    static final int CHAR_ENCODING_ISO8859_15 = 16;
    static final int CHAR_ENCODING_ISO8859_16 = 17;
    static final int CHAR_ENCODING_KOI8R = 18;
    private static final int IN_ESCAPE = 1;
    private static final int IN_STRING = 2;
    private static final byte BUFFER_FLAG = -128;
    private static final byte ENCODING_MASK = 127;
    private static String[] encodings = null;
    byte[] ptr;
    int off;
    short len;
    byte encoding;

    public static SDKString createSDKStringBuffer(int n, int n2) {
        SDKString sDKString = new SDKString();
        sDKString.encoding = (byte)(n2 | 0xFFFFFF80);
        sDKString.ptr = new byte[n2 == 0 ? n << 1 : n];
        sDKString.off = 0;
        sDKString.len = 0;
        return sDKString;
    }

    public SDKString(String string, int n) {
        this.encoding = (byte)n;
        this.off = 0;
        this.len = (short)string.length();
        this.ptr = new byte[this.len];
        for (int i = 0; i < this.len; ++i) {
            this.ptr[i] = (byte)string.charAt(i);
        }
    }

    public static SDKString createSDKString(String string, int n) {
        if (encodings == null) {
            encodings = new String[]{"UTF-16BE", "US-ASCII", "ISO-8859-1", "ISO-8859-2", "ISO-8859-3", "ISO-8859-4", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8", "ISO-8859-9", "ISO-8859-10", "ISO-8859-11", "ISO-8859-12", "ISO-8859-13", "ISO-8859-14", "ISO-8859-15", "ISO-8859-16", "KOI8-R"};
        }
        SDKString sDKString = new SDKString();
        sDKString.off = 0;
        sDKString.encoding = (byte)n;
        try {
            byte[] byArray = string.getBytes(encodings[n]);
            sDKString.ptr = byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byte[] byArray = string.getBytes();
            if (byArray.length == string.length()) {
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] <= 127) continue;
                    sDKString.len = 0;
                    return sDKString;
                }
                if (n == 0) {
                    byte[] byArray2 = new byte[byArray.length << 1];
                    for (int i = 0; i < byArray.length; ++i) {
                        int n2 = i << 1;
                        byArray2[n2] = 0;
                        byArray2[n2 + 1] = byArray[i];
                    }
                    sDKString.ptr = byArray2;
                } else {
                    sDKString.ptr = byArray;
                }
            }
            sDKString.len = 0;
            return sDKString;
        }
        sDKString.len = (short)string.length();
        return sDKString;
    }

    SDKString() {
    }

    public SDKString append(SDKString sDKString) {
        byte by = (byte)(this.encoding & 0x7F);
        if (sDKString.encoding == 0 && by != 0 || (this.encoding & 0xFFFFFF80) == 0) {
            return this;
        }
        for (int i = 0; i < sDKString.len; ++i) {
            int n = this.off + (by == 0 ? this.len << 1 : this.len);
            if (by == 0) {
                if (sDKString.encoding == 0) {
                    int n2 = sDKString.off + (i << 1);
                    this.ptr[n] = sDKString.ptr[n2];
                    this.ptr[n + 1] = sDKString.ptr[n2 + 1];
                } else {
                    this.ptr[n] = 0;
                    this.ptr[n + 1] = sDKString.ptr[sDKString.off + i];
                }
            } else {
                this.ptr[n] = sDKString.ptr[sDKString.off + i];
            }
            this.len = (short)(this.len + 1);
        }
        return this;
    }

    public short charCodeAt(int n) {
        short s = 0;
        byte by = (byte)(this.encoding & 0x7F);
        int n2 = by == 0 ? 2 : 1;
        int n3 = this.off + n * n2;
        s = by == 0 ? (short)((this.ptr[n3] & 0xFF) << 8 | this.ptr[n3 + 1] & 0xFF) : (short)(this.ptr[n3] & 0xFF);
        return s;
    }

    public int indexOfCode(short s, int n) {
        for (int i = n; i < this.len; ++i) {
            if (this.charCodeAt(i) != s) continue;
            return i;
        }
        return -1;
    }

    public SDKString replace(SDKString[] sDKStringArray) {
        int n;
        short s;
        boolean bl = false;
        int n2 = 2;
        int n3 = 0;
        block8: for (int i = 0; i < this.len; ++i) {
            s = this.charCodeAt(i);
            switch (n2) {
                case 2: {
                    if (s == 92) {
                        n2 = 1;
                        continue block8;
                    }
                    n3 = (short)(n3 + 1);
                    continue block8;
                }
                case 1: {
                    n2 = 2;
                    if (s == 92) {
                        n3 = (short)(n3 + 1);
                        bl = true;
                        continue block8;
                    }
                    if (s >= 48 && s <= 57) {
                        n3 = (short)(n3 + sDKStringArray[s - 48].len);
                        bl = true;
                        continue block8;
                    }
                    n3 = (short)(n3 + 2);
                }
            }
        }
        if (!bl) {
            return this;
        }
        SDKString sDKString = new SDKString();
        sDKString.off = 0;
        sDKString.encoding = this.encoding;
        s = 0;
        for (n = 0; n < sDKStringArray.length; ++n) {
            if (sDKStringArray[n].encoding == this.encoding) continue;
            s = 1;
            break;
        }
        if (s != 0) {
            sDKString.ptr = this.ptr;
            return sDKString;
        }
        n = sDKString.encoding == 0 ? 2 : 1;
        sDKString.len = (short)n3;
        sDKString.ptr = new byte[n3 * n];
        int n4 = 0;
        block10: for (int i = 0; i < this.len; ++i) {
            short s2 = this.charCodeAt(i);
            switch (n2) {
                case 2: {
                    if (s2 == 92) {
                        n2 = 1;
                        continue block10;
                    }
                    sDKString.ptr[n4 * n] = (byte)(s2 & 0xFF);
                    if (n == 2) {
                        sDKString.ptr[n4 * n + 1] = (byte)((s2 & 0xFF00) >> 8);
                    }
                    ++n4;
                    continue block10;
                }
                case 1: {
                    n2 = 2;
                    if (s2 == 92) {
                        sDKString.ptr[n4 * n] = (byte)(s2 & 0xFF);
                        ++n4;
                        continue block10;
                    }
                    if (s2 >= 48 && s2 <= 57) {
                        for (int j = 0; j < sDKStringArray[s2 - 48].len; ++j) {
                            short s3 = sDKStringArray[s2 - 48].charCodeAt(j);
                            sDKString.ptr[n4 * n] = (byte)(s3 & 0xFF);
                            if (n == 2) {
                                sDKString.ptr[n4 * n + 1] = (byte)((s3 & 0xFF00) >> 8);
                            }
                            ++n4;
                        }
                        continue block10;
                    }
                    sDKString.ptr[n4 * n] = 92;
                    sDKString.ptr[++n4 * n] = (byte)(s2 & 0xFF);
                    if (n == 2) {
                        sDKString.ptr[n4 * n + 1] = (byte)((s2 & 0xFF00) >> 8);
                    }
                    ++n4;
                }
            }
        }
        return sDKString;
    }

    public SDKString concat(SDKString sDKString) {
        byte by = (byte)(this.encoding & 0x7F);
        if (sDKString.encoding == 0 && by != 0) {
            return this;
        }
        int n = by == 0 ? 2 : 1;
        SDKString sDKString2 = new SDKString();
        sDKString2.len = (short)(this.len + sDKString.len);
        sDKString2.ptr = new byte[sDKString2.len * n];
        sDKString2.off = 0;
        sDKString2.encoding = by;
        System.arraycopy(this.ptr, this.off, sDKString2.ptr, 0, this.len * n);
        if (by != sDKString.encoding && n == 2) {
            int n2 = this.len << 1;
            for (int i = sDKString.off; i < sDKString.off + sDKString.len; ++i) {
                sDKString2.ptr[n2] = 0;
                sDKString2.ptr[n2 + 1] = sDKString.ptr[i];
                n2 += 2;
            }
        } else {
            System.arraycopy(sDKString.ptr, sDKString.off, sDKString2.ptr, this.len * n, sDKString.len * n);
        }
        return sDKString2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.len; ++i) {
            stringBuffer.append((char)this.charCodeAt(i));
        }
        return stringBuffer.toString();
    }

    public SDKString toSDKString() {
        return this.concat(SDKString.createSDKString("", this.getEncoding()));
    }

    public int length() {
        return this.len;
    }

    public int getEncoding() {
        return this.encoding & 0x7F;
    }

    public SDKString substring(int n, int n2) throws IndexOutOfBoundsException {
        if (n < 0 || n2 < n || n2 > this.len) {
            throw new IndexOutOfBoundsException();
        }
        SDKString sDKString = new SDKString();
        sDKString.encoding = (byte)this.getEncoding();
        int n3 = sDKString.encoding == 0 ? 2 : 1;
        sDKString.len = (short)(n2 - n);
        sDKString.off = this.off + n * n3;
        sDKString.ptr = this.ptr;
        return sDKString;
    }

    public SDKString concat(int n) {
        return this.concat(SDKString.createSDKString("" + n, this.getEncoding()));
    }

    public SDKString concat(String string) {
        return this.concat(new SDKString(string, this.getEncoding()));
    }

    public SDKString replaceFirst(int n) {
        return this.replace(new SDKString[]{SDKString.createSDKString("" + n, this.getEncoding())});
    }

    public SDKString replaceFirst(String string) {
        return this.replace(new SDKString[]{new SDKString(string, this.getEncoding())});
    }

    public SDKString replaceFirst(SDKString sDKString) {
        return this.replace(new SDKString[]{sDKString});
    }

    public void setLength(int n) {
        if ((this.encoding & 0xFFFFFF80) == 0) {
            return;
        }
        this.len = (short)n;
    }

    public SDKString trim() {
        short s;
        int n;
        int n2;
        int n3 = this.off;
        int n4 = this.len;
        for (n2 = 0; n2 < n4; ++n2) {
            if (this.getEncoding() == 0) {
                n = n3 + (n2 << 1);
                s = (short)((this.ptr[n] & 0xFF) << 8 | this.ptr[n + 1] & 0xFF);
                if (s != 32) break;
                this.off += 2;
                this.len = (short)(this.len - 1);
                continue;
            }
            n = this.ptr[n3 + n2];
            if (n != 32) break;
            ++this.off;
            this.len = (short)(this.len - 1);
        }
        n4 = this.len;
        for (n2 = this.len - 1; n2 >= 0; --n2) {
            if (this.getEncoding() == 0) {
                n = this.off + (n2 << 1);
                s = (short)((this.ptr[n] & 0xFF) << 8 | this.ptr[n + 1] & 0xFF);
                if (s != 32) break;
                this.len = (short)(this.len - 1);
                continue;
            }
            n = this.ptr[this.off + n2];
            if (n != 32) break;
            this.len = (short)(this.len - 1);
        }
        return this;
    }
}

