/*
 * Decompiled with CFR 0.152.
 */
package com.ea.cnc;

import com.ea.cnc.GameImpl;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKTextUtils;
import javax.microedition.lcdui.Graphics;

public class Page {
    int title_id;
    SDKString textString;
    short[] wrapOffsets;
    int first_line;
    int visible_lines;
    int width;
    int height;
    Object font_txt;
    Object font_tit;
    private int fontSize = 10;
    private int offsetY = 0;
    private int time = 0;
    private int waitTime = 0;
    private static final int TIME_PER_LINE = 1000;
    private static final int WAIT_TIME = 2000;
    public static final int ARROW_HEIGHT = 4;
    public static final int ARROW_COLOR1 = 12032;
    public static final int ARROW_COLOR2 = 65280;

    public Page(SDKString sDKString, Object object, int n, int n2) {
        this.width = n;
        this.height = n2;
        this.font_txt = object;
        this.createPage(sDKString, true);
    }

    public Page(int n, Object object, SDKString sDKString, Object object2, int n2, int n3) {
        this.title_id = n;
        this.font_tit = object;
        this.width = n2;
        this.height = n3;
        this.font_txt = object2;
        this.createPage(sDKString, false);
        this.time = 0;
        this.waitTime = 2000;
    }

    public void createPage(SDKString sDKString, boolean bl) {
        this.wrapOffsets = null;
        if (bl) {
            this.wrapOffsets = new short[50];
        }
        this.wrapOffsets = new short[500];
        SDKTextUtils.setFont(this.font_txt);
        this.fontSize = SDKTextUtils.getLineSize();
        this.wrapOffsets = SDKTextUtils.wrapString(sDKString, this.wrapOffsets, this.width, (short)124);
        this.textString = sDKString;
        short s = this.wrapOffsets[0];
        this.visible_lines = s > 0 ? this.height / this.fontSize : 0;
        this.first_line = 0;
    }

    public void reset() {
        this.first_line = 0;
    }

    public void moveUp() {
        if (this.first_line > 0) {
            --this.first_line;
        }
        this.waitTime = 2000;
    }

    public void moveDown() {
        int n = this.wrapOffsets[0] - this.visible_lines;
        if (this.first_line < n) {
            ++this.first_line;
        }
        this.waitTime = 2000;
    }

    public void pageDown(int n) {
        if (!this.canScrollDown()) {
            return;
        }
        this.first_line += this.visible_lines - n;
        this.waitTime = 2000;
    }

    public void pageUp(int n) {
        if (!this.canScrollUp()) {
            return;
        }
        this.first_line -= this.visible_lines - n;
        if (this.first_line < 0) {
            this.first_line = 0;
        }
        this.waitTime = 2000;
    }

    public void pageDown() {
        if (!this.canScrollDown()) {
            return;
        }
        this.first_line += this.visible_lines;
        this.waitTime = 2000;
    }

    public void pageUp() {
        if (!this.canScrollUp()) {
            return;
        }
        this.first_line -= this.visible_lines;
        if (this.first_line < 0) {
            this.first_line = 0;
        }
        this.waitTime = 2000;
    }

    public void drawTitle(Graphics graphics, int n, int n2, int n3) {
        if (this.title_id >= 0 && this.font_tit != null) {
            SDKString sDKString = SDKTextUtils.getString(this.title_id, GameImpl.tempString);
            SDKTextUtils.setFont(this.font_tit);
            SDKTextUtils.drawString(sDKString, n, n2, n3);
        }
    }

    public int drawContent(int n, int n2, int n3, boolean bl) {
        SDKTextUtils.setFont(this.font_txt);
        int n4 = this.first_line + 1;
        int n5 = Math.min(this.visible_lines, this.wrapOffsets[0] - this.first_line);
        SDKTextUtils.drawWrappedString(this.textString, this.wrapOffsets, n4, n5, n, n2 - this.offsetY, n3);
        return n5 * SDKTextUtils.getLineSize();
    }

    public int drawScrollableContent(Graphics graphics, int n, int n2, int n3) {
        SDKTextUtils.setFont(this.font_txt);
        int n4 = this.first_line + 1;
        int n5 = Math.min(this.visible_lines, this.wrapOffsets[0] - this.first_line);
        SDKTextUtils.setClip(graphics, 0, n2 + this.fontSize, 480, this.height - this.fontSize);
        SDKTextUtils.drawWrappedString(this.textString, this.wrapOffsets, n4, n5, n, n2 - this.offsetY + this.fontSize, n3);
        SDKTextUtils.setClip(graphics, 0, 0, 480, 360);
        return this.height;
    }

    public void updateScrollableContent(int n) {
        if (this.waitTime > 0) {
            this.waitTime -= n;
            this.offsetY = 0;
            this.time = 0;
            return;
        }
        this.time += n;
        if (this.time >= 1000) {
            ++this.first_line;
        }
        if (this.first_line == this.wrapOffsets[0]) {
            this.first_line = 0;
            this.offsetY = 0;
            this.time = 0;
            this.waitTime = 2000;
        }
        this.time %= 1000;
        this.offsetY = this.time * this.fontSize / 1000;
    }

    public boolean canScrollDown() {
        return this.first_line < this.wrapOffsets[0] - this.visible_lines;
    }

    public boolean canScrollUp() {
        return this.first_line > 0;
    }
}

