/*
 * Decompiled with CFR 0.152.
 */
package com.ea.sdk;

import com.ea.cnc.GameImpl;
import com.ea.sdk.SDKGame;
import com.ea.sdk.SDKKeys;
import com.ea.sdk.SDKMIDlet;
import com.ea.sdk.SDKSound;
import com.ea.sdk.SDKString;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import net.rim.device.api.system.Application;
import net.rim.device.api.system.GlobalEventListener;
import net.rim.device.api.system.KeyListener;
import net.rim.device.api.system.SensorListener;
import net.rim.device.api.system.SystemListener;
import net.rim.device.api.system.SystemListener2;
import net.rim.device.api.ui.Keypad;
import net.rim.device.api.ui.UiApplication;

public class SDKCanvas
extends GameCanvas
implements SDKKeys,
KeyListener,
GlobalEventListener,
SensorListener,
SystemListener2 {
    private static SDKCanvas singleton = null;
    boolean paintFinished = false;
    private long appInstantTime = System.currentTimeMillis();
    private long updateTime = 0L;
    private long paintTime = 0L;
    String updateException;
    String paintException;
    private Graphics g;
    SDKGame game;
    UiApplication app;
    private boolean initDone = false;
    private boolean paused = false;
    private boolean soundPaused = false;
    private static final int EVENT_NOT_AVAILABLE = 0;
    private static final int EVENT_PRESS = 1;
    private static final int EVENT_RELEASE = 2;
    private static final int EVENT_PRESS_LETTER = 3;
    private static final int EVENT_RELEASE_LETTER = 4;
    private static final int EVENT_POINTER_PRESSED = 5;
    private static final int EVENT_POINTER_RELEASED = 6;
    private static final int EVENT_POINTER_DRAGGED = 7;
    private static final int KEY_BUFFER_SIZE = 16;
    private static final int K_NONE = 0;
    int keysPressed = 0;
    long lastKeyPressedTime = 0L;
    int keysReleased = 0;
    long lastKeyReleaseTime = 0L;
    int[] events = new int[16];
    int[] nativeCodes = new int[16];
    long[] times = new long[16];
    int pos = 0;
    int oldestpos = 0;

    public static SDKCanvas getInstance() {
        return singleton;
    }

    public long getAppTime() {
        return System.currentTimeMillis() - SDKMIDlet.me.lostTime;
    }

    public SDKCanvas() {
        super(false);
        this.app = UiApplication.getUiApplication();
        this.app.addKeyListener((KeyListener)this);
        Application.getApplication().addSystemListener((SystemListener)this);
        Application.getApplication().addGlobalEventListener((GlobalEventListener)this);
        this.setFullScreenMode(true);
        this.g = this.getGraphics();
        singleton = this;
    }

    void updateKeys() {
        while (this.isAnyKeyEventWaiting()) {
            int n = this.getCurrentKeyEventType();
            if (n == 1) {
                this.game.appKeyPressed(this.getCurrentKeyEventCode(), this.getCurrentKeyEventTime());
            }
            if (n == 2) {
                this.game.appKeyReleased(this.getCurrentKeyEventCode(), this.getCurrentKeyEventTime());
            }
            this.goToNextKeyEvent();
        }
    }

    void flushKeys() {
        while (this.isAnyKeyEventWaiting()) {
            this.goToNextKeyEvent();
        }
    }

    void myPaint() {
        if (this.game == null) {
            return;
        }
        if (SDKMIDlet.me.paused) {
            return;
        }
        try {
            this.game.draw(this.g);
        }
        catch (Exception exception) {
            this.paintException = exception.getClass().toString();
        }
        this.paintFinished = true;
    }

    void initRun() {
        if (this.initDone) {
            return;
        }
        this.initDone = true;
        this.game = new GameImpl(this);
        this.game.init();
    }

    protected void hideNotify() {
        try {
            System.out.println("hide notify");
            this.paused = true;
            if (SDKSound.soundOn) {
                this.soundPaused = true;
                SDKSound.saveCurrentPlaying();
                SDKSound.stopSounds();
            }
            SDKMIDlet.me._pauseApp();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void showNotify() {
        try {
            SDKMIDlet.me._resumeApp();
            if (SDKSound.soundOn) {
                SDKSound.setCurrentLoop(-1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getWidth() {
        return 480;
    }

    public int getHeight() {
        return 360;
    }

    public void eventOccurred(long l, int n, int n2, Object object, Object object2) {
        if (l == 5961289116197897667L) {
            if (n == 1) {
                this.hideNotify();
            } else if (n == 2) {
                this.showNotify();
            }
        }
    }

    public void onSensorUpdate(int n, int n2) {
        if ((n & 1) != 0) {
            if ((n2 & 0) != 0) {
                this.showNotify();
            } else if ((n2 & 1) != 0) {
                this.hideNotify();
            }
        }
    }

    public void backlightStateChange(boolean bl) {
        if (bl) {
            this.showNotify();
            this.repaint();
        } else {
            this.hideNotify();
        }
    }

    public void cradleMismatch(boolean bl) {
    }

    public void fastReset() {
    }

    public void powerOffRequested(int n) {
    }

    public void usbConnectionStateChange(int n) {
    }

    public void batteryGood() {
    }

    public void batteryLow() {
    }

    public void batteryStatusChange(int n) {
    }

    public void powerOff() {
    }

    public void powerUp() {
    }

    public boolean keyDown(int n, int n2) {
        if (this.soundPaused && this.isShown()) {
            SDKSound.resumeSound();
            this.soundPaused = false;
        }
        switch (Keypad.key((int)n)) {
            case 17: 
            case 18: {
                this.hideNotify();
                this.showNotify();
                return false;
            }
            case 4096: {
                SDKSound.setSoundVolume(SDKSound.getSoundVolume() + 20, 100);
                return true;
            }
            case 4097: {
                SDKSound.setSoundVolume(SDKSound.getSoundVolume() - 20, 100);
                return true;
            }
            case 81: {
                n = 32;
                break;
            }
            case 80: {
                n = 64;
            }
        }
        this.keyPressed(n);
        return true;
    }

    public boolean keyUp(int n, int n2) {
        switch (Keypad.key((int)n)) {
            case 17: 
            case 18: {
                return false;
            }
            case 4096: 
            case 4097: {
                return true;
            }
            case 81: {
                n = 32;
                break;
            }
            case 80: {
                n = 64;
            }
        }
        this.keyReleased(n);
        return true;
    }

    public boolean keyChar(char c, int n, int n2) {
        return true;
    }

    public boolean keyRepeat(int n, int n2) {
        return true;
    }

    public boolean keyStatus(int n, int n2) {
        return true;
    }

    private int convertToKey(int n) {
        return n;
    }

    private int translateCode(int n) {
        if (n == -1 || n == 1) {
            return 1;
        }
        if (n == -2 || n == 2) {
            return 2;
        }
        if (n == -3 || n == 3) {
            return 4;
        }
        if (n == -4 || n == 4) {
            return 8;
        }
        if (n == -5 || n == 5) {
            return 16;
        }
        if (n == -6 || n == 6) {
            return 32;
        }
        if (n == -7 || n == 7) {
            return 64;
        }
        if (n >= 48 && n <= 57) {
            return 128 << n - 48;
        }
        if (n == 42) {
            return 131072;
        }
        if (n == 35) {
            return 262144;
        }
        switch (n) {
            case 119: {
                return 256;
            }
            case 101: {
                return 512;
            }
            case 114: {
                return 1024;
            }
            case 115: {
                return 2048;
            }
            case 100: {
                return 4096;
            }
            case 102: {
                return 8192;
            }
            case 122: {
                return 16384;
            }
            case 120: {
                return 32768;
            }
            case 99: {
                return 65536;
            }
            case 43: {
                return 128;
            }
        }
        return 0;
    }

    protected void keyPressed(int n) {
        if (this.soundPaused && this.isShown()) {
            SDKSound.resumeSound();
            this.soundPaused = false;
        }
        block0 : switch (n) {
            case 1: {
                n = 1;
                break;
            }
            case 6: {
                n = 2;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
            case 5: {
                n = 8;
                break;
            }
            case -8: {
                n = 16;
                break;
            }
            default: {
                switch (Keypad.key((int)n)) {
                    case 10: {
                        n = 16;
                        break block0;
                    }
                    case 27: {
                        n = 64;
                        break block0;
                    }
                    case 69: {
                        n = 512;
                        break block0;
                    }
                    case 83: {
                        n = 2048;
                        break block0;
                    }
                    case 68: {
                        n = 4096;
                        break block0;
                    }
                    case 70: {
                        n = 8192;
                        break block0;
                    }
                    case 88: {
                        n = 32768;
                        break block0;
                    }
                    case 48: {
                        n = 128;
                    }
                }
            }
        }
        this.push(1, n, System.currentTimeMillis() - SDKMIDlet.me.lostTime);
    }

    protected void keyReleased(int n) {
        block0 : switch (n) {
            case 1: {
                n = 1;
                break;
            }
            case 6: {
                n = 2;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
            case 5: {
                n = 8;
                break;
            }
            case -8: {
                n = 16;
                break;
            }
            default: {
                switch (Keypad.key((int)n)) {
                    case 10: {
                        n = 16;
                        break block0;
                    }
                    case 27: {
                        n = 64;
                        break block0;
                    }
                    case 69: {
                        n = 512;
                        break block0;
                    }
                    case 83: {
                        n = 2048;
                        break block0;
                    }
                    case 68: {
                        n = 4096;
                        break block0;
                    }
                    case 70: {
                        n = 8192;
                        break block0;
                    }
                    case 88: {
                        n = 32768;
                        break block0;
                    }
                    case 48: {
                        n = 128;
                    }
                }
            }
        }
        this.push(2, n, System.currentTimeMillis() - SDKMIDlet.me.lostTime);
    }

    private void push(int n, int n2, long l) {
        int n3 = this.pos++;
        if (this.pos == 16) {
            this.pos = 0;
        }
        if (this.pos == this.oldestpos) {
            ++this.oldestpos;
            if (this.oldestpos == 16) {
                this.oldestpos = 0;
            }
        }
        this.events[n3] = n;
        this.nativeCodes[n3] = n2;
        this.times[n3] = l;
    }

    int getCurrentKeyEventType() {
        if (this.oldestpos == this.pos) {
            return 0;
        }
        return this.events[this.oldestpos];
    }

    int getCurrentKeyEventCode() {
        if (this.oldestpos == this.pos) {
            return 0;
        }
        if (this.events[this.oldestpos] == 3 || this.events[this.oldestpos] == 4) {
            return this.nativeCodes[this.oldestpos];
        }
        return this.convertToKey(this.nativeCodes[this.oldestpos]);
    }

    long getCurrentKeyEventTime() {
        if (this.oldestpos == this.pos) {
            return 0L;
        }
        return this.times[this.oldestpos];
    }

    void goToNextKeyEvent() {
        ++this.oldestpos;
        if (this.oldestpos == 16) {
            this.oldestpos = 0;
        }
    }

    boolean isAnyKeyEventWaiting() {
        return this.pos != this.oldestpos;
    }

    public static void setCommands(SDKString sDKString, SDKString sDKString2) {
    }
}

