/*
 * Decompiled with CFR 0.152.
 */
package com.ea.sdk;

import com.ea.sdk.SDKString;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class SDKTextUtils {
    private static final int MAX_WRAPPED_LINES = 100;
    private static final byte FONT_ORIENTATION_LEFT_TO_RIGHT = 0;
    private static final byte FONT_ORIENTATION_RIGHT_TO_LEFT = 1;
    private static final byte FONT_ORIENTATION_TOP_TO_BOTTOM = 2;
    private static final byte FONT_ORIENTATION_BOTTOM_TO_TOP = 3;
    private static final int FONT_OBJECT_IMAGE = 0;
    private static final int FONT_OBJECT_FONT_PROPS = 1;
    private static final int FONT_OBJECT_CHAR_CODES_OR_MAP = 2;
    private static final int FONT_OBJECT_CHAR_OFFSETS = 3;
    private static final int FONT_OBJECT_CHAR_GLYPH_DATA = 4;
    private static final byte FONT_ENCODING_INDEX = 0;
    private static final byte FONT_TEXT_DIRECTION_INDEX = 1;
    private static final byte FONT_LEADING_INDEX = 2;
    private static final byte FONT_ASCENT_INDEX = 3;
    private static final byte FONT_DESCENT_INDEX = 4;
    private static final byte FONT_SPACE_SPACING_INDEX = 5;
    private static final byte FONT_CHAR_SPACING_INDEX = 6;
    private static final int CHAR_NUM_GLYPHS_INDEX = 0;
    private static final int CHAR_ADVANCE_INDEX = 1;
    private static final int CHAR_START_GLYPH_DATA_INDEX = 2;
    private static final int GLYPH_X_INDEX = 0;
    private static final int GLYPH_Y_INDEX = 1;
    private static final int GLYPH_RX_INDEX = 2;
    private static final int GLYPH_RY_INDEX = 3;
    private static final int GLYPH_WIDTH_INDEX = 4;
    private static final int GLYPH_HEIGHT_INDEX = 5;
    private static final int SIZE_OF_GLYPH_DATA = 6;
    private static final String TEXT_RESOURCE_FILE_PREFIX = "t_";
    private static final int HEADER_CHUNKANDGROUP_INDEX = 0;
    private static final byte CHUNK_CONFIG_CONCAT = 0;
    private static final byte CHUNK_CONFIG_SEPARATE = 1;
    private static final byte CHUNK_FLAG_UTF16BE = -128;
    private static final byte CHUNK_FLAG_MULTILANGUAGE = 64;
    private static final int MENU = 1;
    private static final int DETECT_MENU = 2;
    private static final int DETECT_FORCE_MENU = 3;
    private static final int FORCE_DETECT_MENU = 4;
    private static Object _font;
    private static Object _fontImage;
    private static byte[] _fontProps;
    private static short[] _fontCharCodes2Byte;
    private static short[] _fontCharOffsets;
    private static byte[] _fontCharAndGlyphData;
    private static byte[] _fontCharMap;
    private static int _fontNumChars;
    private static int _fontScanLength;
    private static int _stringOffset;
    private static int _stringLen;
    private static boolean _display;
    private static int _stringWidth;
    private static short[] _wrapOffsets;
    private static byte[][] _chunkStringData;
    private static short[][] _chunkStringOffsets;
    private static byte[] _chunkGroup;
    private static byte[] _chunkFlags;
    private static byte _chunkConfig;
    private static short[][] _chunkSize;
    private static short[] _numStringsPerChunk;
    private static short[] _groupMaxSize;
    private static short[] _groupMaxNumOffsets;
    private static byte[] _groupMap;
    private static byte[] _languageEncodings;
    private static String[] _languageISOCodes;
    private static byte[] _languageFontDifferentiator;
    private static byte _langIndex;
    private static Graphics _graphics;
    static MIDlet midlet;

    public static void setMidlet(MIDlet mIDlet) {
        midlet = mIDlet;
    }

    private static Object loadFontInternal(Object object, byte[] byArray) {
        Object[] objectArray = SDKTextUtils.loadFontChunk(byArray);
        if (objectArray == null) {
            return null;
        }
        Object[] objectArray2 = new Object[]{object, objectArray[0], objectArray[1], objectArray[2], objectArray[3]};
        return objectArray2;
    }

    public static Object loadFont(short[] sArray, byte[] byArray, int n) {
        _fontScanLength = n;
        return SDKTextUtils.loadFontInternal(sArray, byArray);
    }

    public static Object loadFont(Image image, byte[] byArray) {
        return SDKTextUtils.loadFontInternal(image, byArray);
    }

    public static void setFontChunk(byte[] byArray) {
        _font = null;
        _fontProps = null;
        _fontCharCodes2Byte = null;
        _fontCharMap = null;
        _fontCharOffsets = null;
        _fontCharAndGlyphData = null;
        Object[] objectArray = SDKTextUtils.loadFontChunk(byArray);
        Object[] objectArray2 = new Object[]{_fontImage, objectArray[0], objectArray[1], objectArray[2], objectArray[3]};
        SDKTextUtils.setFont(objectArray2);
    }

    private static void setFontImageInternal(Object object) {
        _font = null;
        _fontImage = null;
        _fontImage = object;
        byte by = _fontProps[0];
        _font = by == 0 ? new Object[]{_fontImage, _fontProps, _fontCharCodes2Byte, _fontCharOffsets, _fontCharAndGlyphData} : new Object[]{_fontImage, _fontProps, _fontCharMap, _fontCharOffsets, _fontCharAndGlyphData};
    }

    public static void setFontImage(short[] sArray, int n) {
        SDKTextUtils.setFontImageInternal(sArray);
        _fontScanLength = n;
    }

    private static void setFontImage(Image image) {
        SDKTextUtils.setFontImageInternal(image);
    }

    public static void setFont(Object object) {
        _font = null;
        _fontProps = null;
        _fontImage = null;
        _fontCharCodes2Byte = null;
        _fontCharMap = null;
        _fontCharOffsets = null;
        _fontCharAndGlyphData = null;
        _fontNumChars = 0;
        if (object != null) {
            _fontProps = (byte[])((Object[])object)[1];
            _fontImage = ((Object[])object)[0];
            byte by = _fontProps[0];
            if (by == 0) {
                _fontCharCodes2Byte = (short[])((Object[])object)[2];
            } else {
                _fontCharMap = (byte[])((Object[])object)[2];
            }
            _fontCharOffsets = (short[])((Object[])object)[3];
            _fontCharAndGlyphData = (byte[])((Object[])object)[4];
            _fontNumChars = _fontCharOffsets.length;
        }
        _font = object;
    }

    public static Object getFont() {
        return _font;
    }

    public static void setCharSpacing(int n) {
        SDKTextUtils._fontProps[6] = (byte)n;
    }

    public static int getCharSpacing() {
        return _fontProps[6] & 0xFF;
    }

    public static void setSpaceSpacing(int n) {
        SDKTextUtils._fontProps[5] = (byte)n;
        short s = _fontCharOffsets[_fontNumChars - 1];
        SDKTextUtils._fontCharAndGlyphData[s] = (byte)n;
    }

    public static int getSpaceSpacing() {
        return _fontProps[5] & 0xFF;
    }

    public static void setLeadingSpacing(int n) {
        if ((_fontProps[3] & 0xFF) + (_fontProps[4] & 0xFF) + n < 0) {
            n = -(_fontProps[3] & 255 + _fontProps[4] & 0xFF);
        }
        SDKTextUtils._fontProps[2] = (byte)n;
    }

    public static int getLeadingSpacing() {
        return _fontProps[2];
    }

    public static int getBaselinePosition() {
        return _fontProps[3] & 0xFF;
    }

    public static int getLineSize() {
        return (_fontProps[3] & 0xFF) + (_fontProps[4] & 0xFF) + _fontProps[2];
    }

    public static void drawString(SDKString sDKString, int n, int n2, int n3) {
        int n4;
        byte by = _fontProps[0];
        int n5 = _fontProps[3] & 0xFF;
        int n6 = SDKTextUtils.getLineSize();
        boolean bl = _fontImage instanceof short[];
        if (_display) {
            if ((n3 & 8) != 0) {
                n4 = SDKTextUtils.getStringSize(sDKString);
                n -= n4;
            } else if ((n3 & 1) != 0) {
                n4 = SDKTextUtils.getStringSize(sDKString);
                n -= n4 >> 1;
            }
            if ((n3 & 0x40) != 0) {
                n2 -= n5;
            } else if ((n3 & 0x20) != 0) {
                n2 -= n6;
            }
        }
        n4 = n;
        if (by != sDKString.getEncoding() && sDKString.getEncoding() != 1) {
            return;
        }
        int n7 = _stringOffset;
        int n8 = n7 + _stringLen;
        if (n8 < 0) {
            n8 = sDKString.len;
        }
        for (int i = n7; i < n8; ++i) {
            short s = sDKString.charCodeAt(i);
            if (s == 173 && i != n8 - 1) continue;
            short s2 = SDKTextUtils.getCharOffset(s, by);
            int n9 = SDKTextUtils.getCharAdvance(s2);
            if (_display) {
                int n10;
                if (s2 == _fontNumChars - 1) {
                    if (s != 32) {
                        n10 = _graphics.getColor();
                        _graphics.setColor(0, 255, 0);
                        _graphics.fillRect(n4, n2, n9, n6);
                        _graphics.setColor(255, 0, 0);
                        _graphics.drawLine(n4, n2, n4 + n9, n2 + n6);
                        _graphics.drawLine(n4, n2 + n6, n4 + n9, n2);
                        _graphics.setColor(n10);
                    }
                    n4 += n9;
                    continue;
                }
                short s3 = s2 = (short)(s2 + 1);
                s2 = (short)(s2 + 1);
                n10 = _fontCharAndGlyphData[s3] & 0xFF;
                for (int j = 0; j < n10; ++j) {
                    short s4 = s2;
                    s2 = (short)(s2 + 1);
                    int n11 = _fontCharAndGlyphData[s4] & 0xFF;
                    short s5 = s2;
                    s2 = (short)(s2 + 1);
                    int n12 = _fontCharAndGlyphData[s5] & 0xFF;
                    short s6 = s2;
                    s2 = (short)(s2 + 1);
                    byte by2 = _fontCharAndGlyphData[s6];
                    short s7 = s2;
                    s2 = (short)(s2 + 1);
                    byte by3 = _fontCharAndGlyphData[s7];
                    short s8 = s2;
                    s2 = (short)(s2 + 1);
                    int n13 = _fontCharAndGlyphData[s8] & 0xFF;
                    short s9 = s2;
                    s2 = (short)(s2 + 1);
                    int n14 = _fontCharAndGlyphData[s9] & 0xFF;
                    if (bl) {
                        SDKTextUtils.drawRegion((short[])_fontImage, _fontScanLength, n11, n12, n13, n14, 0, n4 + by2, n2 - by3 + n5 - n14, 0);
                        continue;
                    }
                    SDKTextUtils.drawRegion((Image)_fontImage, n11, n12, n13, n14, 0, n4 + by2, n2 - by3 + n5 - n14, 0);
                }
            }
            n4 += n9;
        }
        _stringWidth = n4 - n;
    }

    public static void drawSubString(SDKString sDKString, int n, int n2, int n3, int n4, int n5) {
        SDKTextUtils.setStringOffsetLen(n, n2);
        SDKTextUtils.drawString(sDKString, n3, n4, n5);
        SDKTextUtils.setStringOffsetLen(0, -1);
    }

    public static void drawWrappedString(SDKString sDKString, short[] sArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = n + n2;
        int n7 = SDKTextUtils.getLineSize();
        if ((n5 & 2) != 0) {
            n4 -= sArray[0] * n7 - _fontProps[2] >> 1;
        }
        for (int i = n; i < n6; ++i) {
            int n8 = sArray[i] & 0xFFFF;
            int n9 = (sArray[i + 1] & 0xFFFF) - n8;
            if (sDKString.charCodeAt((sArray[i + 1] & 0xFFFF) - 1) == sArray[(sArray[0] & 0xFFFF) + 2]) {
                --n9;
            }
            SDKTextUtils.setStringOffsetLen(n8, n9);
            SDKTextUtils.drawString(sDKString, n3, n4, n5);
            n4 += n7;
        }
        SDKTextUtils.setStringOffsetLen(0, -1);
    }

    private static int getCharAdvance(short s) {
        int n = _fontProps[6] & 0xFF;
        if (s == _fontNumChars - 1) {
            return (_fontProps[5] & 0xFF) + n;
        }
        return (_fontCharAndGlyphData[s & 0xFFFF] & 0xFF) + n;
    }

    private static short getCharOffset(short s, int n) {
        int n2 = n == 0 ? SDKTextUtils.getCharPosUTF16(s, 0, _fontNumChars - 2) : _fontCharMap[s] & 0xFF;
        return _fontCharOffsets[n2];
    }

    public static short[] wrapString(SDKString sDKString, short[] sArray, int n, short s) {
        boolean bl = false;
        if (sArray == null) {
            if (_wrapOffsets == null) {
                _wrapOffsets = new short[100];
            }
            sArray = _wrapOffsets;
            bl = true;
        }
        int n2 = sDKString.getEncoding();
        int n3 = _stringLen < 0 ? (int)sDKString.len : _stringLen;
        int n4 = _stringOffset;
        int n5 = 0;
        int n6 = 0;
        int n7 = -1;
        int n8 = 1;
        for (int i = _stringOffset; i < n3 + _stringOffset; ++i) {
            short s2 = sDKString.charCodeAt(i);
            if (s2 == s) {
                sArray[n8++] = (short)n4;
                n4 = i + 1;
                n5 = 0;
                n6 = 0;
                n7 = -1;
                continue;
            }
            if (s2 == 32 || s2 == 173) {
                n7 = i;
                n6 = 0;
            }
            int n9 = SDKTextUtils.getCharAdvance(SDKTextUtils.getCharOffset(s2, n2));
            n6 += n9;
            if ((n5 += n9) <= n) continue;
            sArray[n8++] = (short)n4;
            if (n7 == -1) {
                n4 = i - 1;
                n5 = n9;
                n6 = 0;
                continue;
            }
            n4 = n7 + 1;
            n7 = -1;
            n5 = n6;
            n6 = 0;
        }
        if (n4 <= n3 + _stringOffset - 1) {
            sArray[n8++] = (short)n4;
        }
        sArray[n8] = (short)(n3 + _stringOffset);
        sArray[0] = (short)(n8 - 1);
        sArray[(sArray[0] & 0xFFFF) + 2] = s;
        if (bl) {
            short[] sArray2 = new short[(sArray[0] & 0xFFFF) + 3];
            System.arraycopy(sArray, 0, sArray2, 0, sArray2.length);
            sArray = sArray2;
        }
        return sArray;
    }

    public static short[] wrapSubString(SDKString sDKString, int n, int n2, short[] sArray, int n3, short s) {
        SDKTextUtils.setStringOffsetLen(n, n2);
        sArray = SDKTextUtils.wrapString(sDKString, sArray, n3, s);
        SDKTextUtils.setStringOffsetLen(0, -1);
        return sArray;
    }

    public static int getStringSize(SDKString sDKString) {
        _display = false;
        SDKTextUtils.drawString(sDKString, 0, 0, 0);
        _display = true;
        return _stringWidth;
    }

    public static int getSubStringSize(SDKString sDKString, int n, int n2) {
        SDKTextUtils.setStringOffsetLen(n, n2);
        _display = false;
        SDKTextUtils.drawString(sDKString, 0, 0, 0);
        _display = true;
        SDKTextUtils.setStringOffsetLen(0, -1);
        return _stringWidth;
    }

    public static void loadStringsChunk(int n) {
        InputStream inputStream = null;
        try {
            int n2;
            int n3;
            if (_chunkConfig == 0) {
                inputStream = midlet.getClass().getResourceAsStream("/t_" + _languageISOCodes[_langIndex]);
                for (n3 = 1; n3 < n; ++n3) {
                    inputStream.skip(_numStringsPerChunk[n3] + 1 << 1);
                    inputStream.skip(_chunkSize[_langIndex][n3] & 0xFFFF);
                }
            } else if (_chunkConfig == 1) {
                inputStream = midlet.getClass().getResourceAsStream("/t_" + _languageISOCodes[_langIndex] + n);
            }
            n3 = _numStringsPerChunk[n] + 1;
            byte by = _chunkGroup[n];
            if (_chunkStringOffsets[by] == null) {
                SDKTextUtils._chunkStringOffsets[by] = new short[_groupMaxNumOffsets[by]];
            }
            for (n2 = 0; n2 < n3; ++n2) {
                byte[] byArray = new byte[]{(byte)inputStream.read(), (byte)inputStream.read()};
                SDKTextUtils._chunkStringOffsets[by][n2] = SDKTextUtils.bytesToShort(byArray, 0);
            }
            if (_chunkStringData[by] == null) {
                SDKTextUtils._chunkStringData[by] = new byte[_groupMaxSize[by] & 0xFFFF];
            }
            for (n2 = 0; n2 < (_chunkSize[_langIndex][n] & 0xFFFF); ++n2) {
                SDKTextUtils._chunkStringData[by][n2] = (byte)inputStream.read();
            }
            SDKTextUtils._groupMap[by] = (byte)n;
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void freeStringsChunk(int n) {
        if (n > 0) {
            SDKTextUtils._chunkStringData[SDKTextUtils._chunkGroup[n]] = null;
            SDKTextUtils._chunkStringOffsets[SDKTextUtils._chunkGroup[n]] = null;
        }
    }

    public static int loadTextHeader(byte[] byArray) {
        int n;
        int n2;
        byte by;
        int n3 = 0;
        if ((by = byArray[n3++]) != 0) {
            return 0;
        }
        _chunkConfig = byArray[n3++];
        short s = SDKTextUtils.bytesToShort(byArray, n3);
        n3 += 2;
        int n4 = byArray[n3++];
        byte by2 = byArray[n3++];
        byte by3 = byArray[n3++];
        int n5 = by2 + 1;
        int n6 = by3 + 1;
        _languageEncodings = new byte[n4];
        _languageISOCodes = new String[n4];
        _languageFontDifferentiator = new byte[n4];
        _numStringsPerChunk = new short[n6];
        _chunkFlags = new byte[n6];
        _chunkGroup = new byte[n6];
        _chunkSize = new short[n4][n6];
        _groupMaxSize = new short[n6];
        _groupMaxNumOffsets = new short[n6];
        _groupMap = new byte[n6];
        _chunkStringData = new byte[n5][];
        _chunkStringOffsets = new short[n5][];
        SDKTextUtils._numStringsPerChunk[0] = s;
        int n7 = s + 1;
        for (n2 = 0; n2 < n4; ++n2) {
            SDKTextUtils._languageISOCodes[n2] = new String(byArray, n3, 5).trim();
            n3 += 5;
            SDKTextUtils._languageEncodings[n2] = byArray[n3++];
            SDKTextUtils._languageFontDifferentiator[n2] = byArray[n3++];
            if (s <= 0) continue;
            if (_chunkStringOffsets[0] == null) {
                SDKTextUtils._chunkStringOffsets[0] = new short[n4 * n7];
            }
            for (n = 0; n < n7; ++n) {
                SDKTextUtils._chunkStringOffsets[0][n2 * n7 + n] = SDKTextUtils.bytesToShort(byArray, n3);
                n3 += 2;
            }
        }
        if (s > 0) {
            n2 = _chunkStringOffsets[0][n4 * n7 - 1];
            SDKTextUtils._chunkStringData[0] = new byte[n2];
            System.arraycopy(byArray, n3, _chunkStringData[0], 0, n2);
            n3 += n2;
        }
        for (n2 = 1; n2 < n6; ++n2) {
            SDKTextUtils._chunkFlags[n2] = (byte)(byArray[n3] & 0xC0);
            SDKTextUtils._chunkGroup[n2] = (byte)(byArray[n3] & 0x3F);
            SDKTextUtils._numStringsPerChunk[n2] = SDKTextUtils.bytesToShort(byArray, ++n3);
            n3 += 2;
            if (_numStringsPerChunk[n2] + 1 > _groupMaxNumOffsets[_chunkGroup[n2]]) {
                SDKTextUtils._groupMaxNumOffsets[SDKTextUtils._chunkGroup[n2]] = (short)(_numStringsPerChunk[n2] + 1);
            }
            for (n = 0; n < n4; ++n) {
                SDKTextUtils._chunkSize[n][n2] = SDKTextUtils.bytesToShort(byArray, n3);
                if ((_chunkSize[n][n2] & 0xFFFF) > (_groupMaxSize[_chunkGroup[n2]] & 0xFFFF)) {
                    SDKTextUtils._groupMaxSize[SDKTextUtils._chunkGroup[n2]] = _chunkSize[n][n2];
                }
                n3 += 2;
            }
        }
        return n4;
    }

    public static SDKString getHeaderString(int n, int n2, SDKString sDKString) {
        int n3 = n2 + (_numStringsPerChunk[0] + 1) * n;
        if (sDKString == null) {
            sDKString = new SDKString();
        }
        sDKString.ptr = _chunkStringData[0];
        sDKString.off = _chunkStringOffsets[0][n3];
        sDKString.len = (short)(_chunkStringOffsets[0][n3 + 1] - _chunkStringOffsets[0][n3] >> 1);
        sDKString.encoding = 0;
        return sDKString;
    }

    public static SDKString getString(int n, SDKString sDKString) {
        int n2;
        int n3 = -1;
        int n4 = 0;
        for (n2 = 0; n2 < _numStringsPerChunk.length; ++n2) {
            if (n >= (n4 += _numStringsPerChunk[n2])) continue;
            n3 = n2;
            break;
        }
        n2 = n - (n4 - _numStringsPerChunk[n3]);
        byte by = _chunkGroup[n3];
        if (sDKString == null) {
            sDKString = new SDKString();
        }
        sDKString.ptr = _chunkStringData[by];
        sDKString.off = _chunkStringOffsets[by][n2] & 0xFFFF;
        sDKString.len = (short)((_chunkStringOffsets[by][n2 + 1] & 0xFFFF) - (_chunkStringOffsets[by][n2] & 0xFFFF));
        byte by2 = _languageEncodings[_langIndex];
        if ((_chunkFlags[n3] & 0xFFFFFF80) != 0) {
            by2 = 0;
        }
        if (by2 == 0) {
            sDKString.len = (short)(sDKString.len >> 1);
        }
        sDKString.encoding = by2;
        return sDKString;
    }

    public static int getCurrentLanguage() {
        return _langIndex;
    }

    public static boolean setCurrentLanguage(int n) {
        byte by = _langIndex;
        if (_languageISOCodes != null && n >= 0 && n < _languageISOCodes.length) {
            _langIndex = (byte)n;
        }
        if (_langIndex != by) {
            for (int i = 1; i < _chunkGroup.length; ++i) {
                byte by2 = _chunkGroup[i];
                if (_chunkStringData[by2] == null || _groupMap[by2] != i || (_chunkFlags[i] & 0x40) != 0) continue;
                SDKTextUtils.loadStringsChunk(i);
            }
        }
        return _langIndex == n;
    }

    public static int chooseLanguage(int n) {
        if (_languageISOCodes.length == 1) {
            return 0;
        }
        String string = midlet.getAppProperty("Force-Locale");
        String[] stringArray = new String[_languageISOCodes.length];
        System.arraycopy(_languageISOCodes, 0, stringArray, 0, stringArray.length);
        if (n == -1) {
            int n2;
            int n3 = 1;
            if (string == null) {
                n3 = 2;
            } else if ((string = string.toLowerCase().trim()).length() < 2) {
                n3 = 2;
            } else if (string.equals("menu")) {
                n3 = 1;
            } else if (string.startsWith("auto-")) {
                n3 = 3;
                string = string.substring(5);
            } else {
                n3 = 4;
            }
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (stringArray[n2].length() <= 2) continue;
                String string2 = stringArray[n2].substring(0, 2);
                boolean bl = true;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (n2 == i || !stringArray[i].startsWith(string2)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                stringArray[n2] = string2;
            }
            if (n3 == 2 || n3 == 3 || n3 == 1) {
                n = SDKTextUtils.detectLanguage(stringArray);
                if (n3 == 1 && n > -1) {
                    n = -1 - n;
                }
            }
            if (n3 == 4 || n3 == 3 && n == -1) {
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    if (!string.startsWith(stringArray[n2])) continue;
                    n = n2;
                    break;
                }
            }
            if (n3 == 4 && n == -1) {
                n = SDKTextUtils.detectLanguage(stringArray);
            }
        }
        return n;
    }

    public static int getFontDifferentiator(int n) {
        return _languageFontDifferentiator[n];
    }

    public static void setGraphics(Graphics graphics) {
        _graphics = null;
        _graphics = graphics;
    }

    static short bytesToShort(byte[] byArray, int n) {
        return (short)((byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF);
    }

    private static byte detectLanguage(String[] stringArray) {
        int n = -1;
        String string = System.getProperty("microedition.locale");
        if (string != null) {
            int n2 = (string = string.toLowerCase().trim()).length();
            if (n2 < 2) {
                return -1;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].length() > n2 && stringArray[i].startsWith(string)) {
                    n = -1;
                    break;
                }
                if (!string.startsWith(stringArray[i])) continue;
                n = (byte)i;
                break;
            }
        }
        return (byte)n;
    }

    public static void drawRegion(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
    }

    public static void drawRegion(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        _graphics.drawRegion(image, n, n2, n3, n4, n5, n6, n7, n8);
    }

    private static int getCharPosUTF16(int n, int n2, int n3) {
        if (n2 > n3) {
            return _fontNumChars - 1;
        }
        int n4 = n2 + n3 >> 1;
        int n5 = _fontCharCodes2Byte[n4] & 0xFFFF;
        if (n == n5) {
            return n4;
        }
        return n < n5 ? SDKTextUtils.getCharPosUTF16(n, n2, n4 - 1) : SDKTextUtils.getCharPosUTF16(n, n4 + 1, n3);
    }

    private static Object[] loadFontChunk(byte[] byArray) {
        int n;
        int n2;
        byte by;
        Object[] objectArray = null;
        int n3 = 0;
        if ((by = byArray[n3++]) != 17) {
            return null;
        }
        byte by2 = byArray[n3++];
        byte by3 = byArray[n3++];
        byte by4 = byArray[n3++];
        byte by5 = byArray[n3++];
        byte by6 = byArray[n3++];
        byte by7 = byArray[n3++];
        int n4 = SDKTextUtils.bytesToShort(byArray, n3);
        short s = SDKTextUtils.bytesToShort(byArray, n3 += 2);
        short s2 = SDKTextUtils.bytesToShort(byArray, n3 += 2);
        n3 += 2;
        byte[] byArray2 = new byte[]{by2, by3, by4, by5, by6, by7, 0};
        byte[] byArray3 = null;
        short[] sArray = null;
        int n5 = n4 + 1;
        if (by2 == 0) {
            sArray = new short[n5];
            for (n2 = 0; n2 < n5; ++n2) {
                sArray[n2] = SDKTextUtils.bytesToShort(byArray, n3);
                n3 += 2;
            }
        } else {
            byArray3 = new byte[n5];
            System.arraycopy(byArray, n3, byArray3, 0, n5);
            n3 += n5;
        }
        n2 = n4 + 1;
        short[] sArray2 = new short[n2];
        for (n = 0; n < n2; ++n) {
            sArray2[n] = SDKTextUtils.bytesToShort(byArray, n3);
            n3 += 2;
        }
        n = (n4 - s) * 2 + s2 * 6 + 8;
        byte[] byArray4 = new byte[n];
        System.arraycopy(byArray, n3, byArray4, 0, n);
        n3 += n;
        if (by2 == 0) {
            objectArray = new Object[]{byArray2, sArray, sArray2, byArray4};
        } else {
            int n6;
            byte[] byArray5 = new byte[256];
            for (n6 = 0; n6 < 256; ++n6) {
                byArray5[n6] = (byte)n4;
            }
            for (n6 = 0; n6 < n4; ++n6) {
                byte by8 = byArray3[n6];
                byArray5[by8 & 0xFF] = (byte)n6;
            }
            objectArray = new Object[]{byArray2, byArray5, sArray2, byArray4};
        }
        return objectArray;
    }

    private static void setStringOffsetLen(int n, int n2) {
        _stringOffset = n;
        _stringLen = n2;
    }

    public static void fillTriangle(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        _graphics.setColor(n7);
        _graphics.fillTriangle(n, n2, n3, n4, n5, n6);
    }

    public static void getRGB(Image image, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        image.getRGB(nArray, n, n2, n3, n4, n5, n6);
    }

    public static void drawRGB(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        _graphics.drawRGB(nArray, n, n2, n3, n4, n5, n6, bl);
    }

    public static void setClip(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setClip(n, n2, n3, n4);
    }

    public static void gc() {
        System.gc();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    static {
        _stringOffset = 0;
        _stringLen = -1;
        _display = true;
        _langIndex = (byte)-1;
    }
}

