/*
 * Decompiled with CFR 0.152.
 */
package com.ea.cnc;

import com.ea.cnc.Building;
import com.ea.cnc.CLevel;
import com.ea.cnc.Constants;
import com.ea.cnc.GameImpl;
import com.ea.cnc.PathFinderFast;
import com.ea.cnc.Scroller;
import com.ea.cnc.Targetable;
import javax.microedition.lcdui.Graphics;

public class View
implements Constants {
    static byte MAP_WIDTH;
    static byte MAP_HEIGHT;
    int view_width;
    int view_height;
    int level_width;
    int level_height;
    public int viewPort_x = 0;
    public int viewPort_y;
    public int viewPort_width;
    public int viewPort_height;
    public CLevel level;
    public int viewPortMapX;
    public int viewPortMapY;
    int scrollTimeX;
    int scrollTimeY;
    int levelFrame;
    Scroller scroller;
    static final boolean BUGGED_NOKIA = true;
    int cursorType;
    Targetable underCursor;
    public static final int CURSOR_ACCELERATION = 128;
    static final int CURSOR_WIDTH = 12;
    static final int CURSOR_HEIGHT = 12;
    static int _nCursorSpdX;
    static int _nCursorSpdY;
    static final int CURSOR_ACC = 2;
    static final int CURSOR_MAX_SPEED = 20;
    static final int CURSOR_SIZE = 12;
    public int cursorX = 0;
    public int cursorY = 0;
    public int cursorAccX = 0;
    public int cursorAccY = 0;
    public int translate_x = 0;
    public int translate_y = 0;

    View() {
        GameImpl.writeDebugOutput("View Object Created");
    }

    void setViewPortSize(int n, int n2, int n3, int n4, int n5, int n6) {
        this.viewPort_x = n;
        this.viewPort_y = n2;
        this.viewPort_width = n3;
        this.viewPort_height = n4;
        this.view_width = n5 - this.viewPort_width - 1;
        this.view_height = n6 - this.viewPort_height - 1;
        this.level_width = n5;
        this.level_height = n6;
    }

    public void initView(int n, int n2, int n3, int n4) {
        this.viewPortMapX = 0;
        this.viewPortMapY = 0;
        this.viewPort_x = n;
        this.viewPort_y = n2;
        this.viewPort_width = n3;
        this.viewPort_height = n4;
        if (this.scroller == null) {
            this.scroller = new Scroller(this.viewPort_width, this.viewPort_height, this.level);
        } else {
            this.scroller.level = this.level;
        }
        this.scrollTimeX = 0;
        this.scrollTimeY = 0;
    }

    void UpdateCursor(int n) {
        if ((n & 0x804) != 0) {
            if (_nCursorSpdX > 0) {
                _nCursorSpdX /= 2;
            }
            if ((_nCursorSpdX -= 2) < -20) {
                _nCursorSpdX = -20;
            }
        } else if ((n & 0x2008) != 0) {
            if (_nCursorSpdX < 0) {
                _nCursorSpdX /= 2;
            }
            if ((_nCursorSpdX += 2) > 20) {
                _nCursorSpdX = 20;
            }
        } else {
            _nCursorSpdX /= 2;
        }
        if ((n & 0x201) != 0) {
            if (_nCursorSpdY > 0) {
                _nCursorSpdY /= 2;
            }
            if ((_nCursorSpdY -= 2) < -20) {
                _nCursorSpdY = -20;
            }
        } else if ((n & 0x8002) != 0) {
            if (_nCursorSpdY < 0) {
                _nCursorSpdY /= 2;
            }
            if ((_nCursorSpdY += 2) > 20) {
                _nCursorSpdY = 20;
            }
        } else {
            _nCursorSpdY /= 2;
        }
        if (_nCursorSpdX > 0) {
            this.cursorX += _nCursorSpdX;
            if (this.cursorX > this.level_width - 12) {
                this.cursorX = this.level_width - 12;
            }
        } else if (_nCursorSpdX < 0) {
            this.cursorX += _nCursorSpdX;
            if (this.cursorX < 12) {
                this.cursorX = 12;
            }
        }
        if (_nCursorSpdY > 0) {
            this.cursorY += _nCursorSpdY;
            if (this.cursorY > this.level_height - 12) {
                this.cursorY = this.level_height - 12;
            }
        } else if (_nCursorSpdY < 0) {
            this.cursorY += _nCursorSpdY;
            if (this.cursorY < 12) {
                this.cursorY = 12;
            }
        }
        if (this.translate_x == 0 && this.translate_y == 0) {
            if (this.viewPortMapX > this.cursorX - 12) {
                this.viewPortMapX = this.cursorX - 12;
            }
            if (this.viewPortMapX < this.cursorX + 12 - this.viewPort_width) {
                this.viewPortMapX = this.cursorX + 12 - this.viewPort_width;
            }
            if (this.viewPortMapY > this.cursorY - 12) {
                this.viewPortMapY = this.cursorY - 12;
            }
            if (this.viewPortMapY < this.cursorY + 12 - this.viewPort_height) {
                this.viewPortMapY = this.cursorY + 12 - this.viewPort_height;
            }
        }
    }

    public static int getCellValue(int n, int n2) {
        if ((n /= 16) < 0 || (n2 /= 16) < 0 || n >= MAP_WIDTH || n2 >= MAP_HEIGHT) {
            return -1;
        }
        return PathFinderFast.mGrid[n2][n];
    }

    public static boolean isInBlockedCell(int n, int n2) {
        if ((n /= 16) < 0 || (n2 /= 16) < 0 || n >= MAP_WIDTH || n2 >= MAP_HEIGHT) {
            return true;
        }
        boolean bl = PathFinderFast.mGrid[n2][n] > 10;
        return bl;
    }

    public void updateViewPort(int n) {
        if (this.translate_x == 0 && this.translate_y == 0) {
            return;
        }
        if (this.translate_x > n) {
            this.viewPortMapX += n;
            this.translate_x -= n;
        } else if (this.translate_x > 0) {
            this.viewPortMapX += this.translate_x;
            this.translate_x -= this.translate_x;
        }
        if (this.translate_x < -n) {
            this.viewPortMapX -= n;
            this.translate_x += n;
        } else if (this.translate_x < 0) {
            this.viewPortMapX += this.translate_x;
            this.translate_x -= this.translate_x;
        }
        if (this.translate_y > n) {
            this.viewPortMapY += n;
            this.translate_y -= n;
        } else if (this.translate_y > 0) {
            this.viewPortMapY += this.translate_y;
            this.translate_y -= this.translate_y;
        }
        if (this.translate_y < -n) {
            this.viewPortMapY -= n;
            this.translate_y += n;
        } else if (this.translate_y < 0) {
            this.viewPortMapY += this.translate_y;
            this.translate_y -= this.translate_y;
        }
    }

    public void normalize() {
        if (this.viewPortMapX == 0 && this.translate_x < 0) {
            this.translate_x = 0;
        }
        if (this.translate_x < 0 && this.translate_x < -this.viewPortMapX) {
            this.translate_x = -this.viewPortMapX;
        }
        if (this.viewPortMapY == 0 && this.translate_y < 0) {
            this.translate_y = 0;
        }
        if (this.translate_y < 0 && this.translate_y < -this.viewPortMapY) {
            this.translate_y = -this.viewPortMapY;
        }
        if (this.viewPortMapX == this.view_width && this.translate_x > 0) {
            this.translate_x = 0;
        }
        if (this.translate_x > 0 && this.translate_x > this.view_width - this.viewPortMapX) {
            this.translate_x = this.view_width - this.viewPortMapX;
        }
        if (this.viewPortMapY == this.view_height && this.translate_y > 0) {
            this.translate_y = 0;
        }
        if (this.translate_y > 0 && this.translate_y > this.view_height - this.viewPortMapY) {
            this.translate_y = this.view_height - this.viewPortMapY;
        }
    }

    public void setViewPortPosition(Building building, int n, int n2) {
        this.cursorX = GameImpl.buildings_map_posX + 22 + n * 14 + n2 * 45;
        this.cursorY = GameImpl.buildings_map_posY + 22 + n * 45 - n2 * 14;
        this.translate_x = this.cursorX - (this.viewPortMapX + this.viewPort_width / 2);
        this.translate_y = this.cursorY - (this.viewPortMapY + this.viewPort_height / 2);
        this.normalize();
        this.scroller.bReinit = true;
    }

    public void updateTerain() {
        this.scroller.update(this.viewPortMapX, this.viewPortMapY);
        if (this.scroller.nrRegions > 0) {
            int n;
            this.scroller.getInvalidArea();
            this.scroller.findVisibleTiles();
            this.scroller.findVisibleObject();
            for (n = 0; n < this.scroller.nrRegions; ++n) {
                this.scroller.drawScrollerModules(this.scroller.regions[n]);
                this.scroller.drawScrollerObjects(this.scroller.regions[n], 1);
                this.scroller.drawScrollerObjects(this.scroller.regions[n], 2);
            }
            for (n = 0; n < this.level.noObjects + this.level.noExtraObjects; ++n) {
                this.level.objects[n].invalidated = false;
            }
        }
        this.scroller.nrRegions = 0;
    }

    public void drawTerrain(Graphics graphics) {
        graphics.setClip(this.viewPort_x, this.viewPort_y, this.viewPort_width, this.viewPort_height);
        this.scroller.blitToScreen(graphics, this);
    }

    static {
        _nCursorSpdX = 0;
        _nCursorSpdY = 0;
    }
}

