/*
 * Decompiled with CFR 0.152.
 */
package com.ea.sdk;

import com.ea.sdk.SDKInputStream;
import com.ea.sdk.SDKMIDlet;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.midlet.MIDlet;

public class SDKSound {
    public static final int IMEDIATE_PLAYBACK = 0;
    public static final int QUEUE_PLAYBACK = 1;
    public static final int IGNORE_PLAYBACK = 2;
    private static int playBackType = 0;
    public static int m_iVolume = 100;
    public static final int NB_SOUNDS = 3;
    private static Player _player;
    static byte[][] cacheSounds;
    static int[] indexSounds;
    static int indexCount;
    static Vector soundQueue;
    static int nb_queueSounds;
    private static final int MID = 77;
    private static final int WAV = 82;
    private static final int AMR = 35;
    private static final int TONE = 2;
    private static int MAX_SOUNDVOLUME;
    public static int soundVolume;
    static boolean mime_x_waw_available;
    private static final int NO_SOUND = -1;
    static int nb_sounds;
    static int currentPlaying;
    static int current_loop;
    public static final int INFINITE_LOOP = -1;
    static byte[] resourcesArray;
    public static SDKSound _soundManager;
    static String[] _supportedType;
    public static int lastPlaying;
    private static boolean soundOn;

    public static void changeVolume(int n) {
    }

    public static void setPlayBackType(int n) {
        playBackType = n;
    }

    public static void checkSymbolConsistency() {
    }

    private SDKSound() {
        int n;
        _soundManager = this;
        for (n = 0; n < 3; ++n) {
            SDKSound.indexSounds[n] = -1;
        }
        _supportedType = Manager.getSupportedContentTypes(null);
        for (n = 0; n < _supportedType.length; ++n) {
            if (_supportedType[n].compareTo("audio/x-wav") != 0) continue;
            mime_x_waw_available = true;
            break;
        }
    }

    public static void setCurrentLoop(int n) {
        current_loop = n;
    }

    static void addPriority(int n, byte by) {
    }

    static void getResource(int n) {
        resourcesArray = SDKInputStream.loadResourceAsByteArray(n);
    }

    static String getSoundType(byte by) {
        String string = null;
        switch (by) {
            case 77: {
                string = "audio/midi";
                break;
            }
            case 82: {
                if (mime_x_waw_available) {
                    string = "audio/x-wav";
                    break;
                }
                string = "audio/wav";
                break;
            }
            case 35: {
                string = "audio/amr";
                break;
            }
        }
        return string;
    }

    public static void setSoundVolume(int n, int n2) {
        soundVolume = m_iVolume;
        Player player = null;
        if (currentPlaying == -1) {
            return;
        }
        player = SDKSound.getPlayer(currentPlaying);
        if (player == null) {
            return;
        }
        ((VolumeControl)player.getControl("VolumeControl")).setLevel(soundVolume);
    }

    public static int getSoundVolume() {
        return soundVolume;
    }

    public static void loadSound(int n) {
        int n2;
        String string = "";
        for (n2 = 0; n2 < 3; ++n2) {
            if (indexSounds[n2] != n) continue;
            return;
        }
        for (n2 = 0; n2 < 3; ++n2) {
            if (indexSounds[n2] != -1) continue;
            SDKSound.getResource(n);
            SDKSound.indexSounds[n2] = n;
            if (cacheSounds[n2] != null) break;
            SDKSound.cacheSounds[n2] = new byte[resourcesArray.length];
            System.arraycopy(resourcesArray, 0, cacheSounds[n2], 0, resourcesArray.length);
            break;
        }
        resourcesArray = null;
        System.gc();
    }

    public static void unloadSound(int n) {
        SDKSound.stopSound(n);
    }

    public static void soundEngineUpdate() {
        if (playBackType == 1) {
            if (nb_queueSounds == 0) {
                return;
            }
            SDKSound.playSound((Integer)soundQueue.elementAt(0));
            soundQueue.removeElementAt(0);
            --nb_queueSounds;
        }
    }

    public static int getCurrentplaying() {
        return currentPlaying;
    }

    public static void startSound(int n) {
        int n2 = -1;
        for (int i = 0; i < 3; ++i) {
            if (n != indexSounds[i]) continue;
            n2 = i;
        }
        if (n2 == -1) {
            return;
        }
        String string = SDKSound.getSoundType(cacheSounds[n2][0]);
        try {
            _player = Manager.createPlayer((InputStream)new ByteArrayInputStream(cacheSounds[n2]), (String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            _player.realize();
            _player.prefetch();
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            _player.setLoopCount(current_loop);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            _player.start();
            ((VolumeControl)_player.getControl("VolumeControl")).setLevel(SDKSound.getSoundVolume());
            currentPlaying = n;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void playSound(int n) {
        lastPlaying = n;
        if (!soundOn) {
            return;
        }
        int n2 = SDKSound.getCurrentplaying();
        if (n2 != -1) {
            if (playBackType == 1) {
                ++nb_queueSounds;
                soundQueue.addElement(new Integer(n));
            }
            if (playBackType != 0) {
                return;
            }
        }
        SDKSound.stopSound(n2);
        SDKSound.startSound(n);
        SDKSound.setSoundVolume(0, 0);
    }

    private static Player getPlayer(int n) {
        return _player;
    }

    public static void stopSound(int n) {
        if (currentPlaying == -1) {
            return;
        }
        try {
            if (_player == null) {
                return;
            }
            if (_player.getState() == 400) {
                _player.stop();
            }
            if (_player.getState() == 300) {
                _player.deallocate();
            }
            _player.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        _player = null;
        currentPlaying = -1;
    }

    public static void stopSounds() {
        int n = SDKSound.getCurrentplaying();
        if (n == -1) {
            return;
        }
        SDKSound.stopSound(n);
    }

    public static void vibrate(int n) {
        Display display = Display.getDisplay((MIDlet)SDKMIDlet.me);
        display.vibrate(n);
    }

    public static void setSoundOnOff(boolean bl) {
        soundOn = bl;
        if (!bl) {
            SDKSound.stopSounds();
        }
    }

    static {
        cacheSounds = new byte[3][];
        indexSounds = new int[3];
        indexCount = 0;
        soundQueue = new Vector();
        nb_queueSounds = 0;
        soundVolume = MAX_SOUNDVOLUME = 100;
        mime_x_waw_available = false;
        nb_sounds = -1;
        currentPlaying = -1;
        current_loop = 1;
        resourcesArray = null;
        _soundManager = new SDKSound();
        _supportedType = null;
        lastPlaying = -1;
        soundOn = true;
    }
}

