/*
 * Decompiled with CFR 0.152.
 */
package com.ea.cnc;

import com.ea.cnc.CLevel;
import com.ea.cnc.GameImpl;
import com.ea.cnc.Region;
import com.ea.cnc.View;
import com.ea.sdk.SDKTextUtils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Scroller {
    public boolean bReinit = true;
    public int xo;
    public int yo;
    public int oldX;
    public int oldY;
    public int scrollerX;
    public int scrollerY;
    public int scrollerWidth;
    public int scrollerHeight;
    public int nrRegions;
    public static final int NUMBER_OF_REFION = 32;
    public Region[] regions = new Region[32];
    public Image scrollerImage;
    public Region activeRegion = new Region();
    public int nrVisibleTiles = 0;
    public short[] visibleTiles;
    public Graphics bg;
    CLevel level;
    private int overlayColor = 0;

    public Scroller(int n, int n2, CLevel cLevel) {
        this.level = cLevel;
        this.scrollerWidth = n;
        this.scrollerHeight = n2;
        this.scrollerX = 0;
        this.scrollerY = 0;
        this.xo = 0;
        this.yo = 0;
        this.oldX = this.scrollerX;
        this.oldY = this.scrollerY;
        this.nrRegions = 0;
        this.addRegion(this.scrollerX, this.scrollerY, this.xo, this.yo, this.scrollerWidth, this.scrollerHeight);
        this.scrollerImage = Image.createImage((int)this.scrollerWidth, (int)this.scrollerHeight);
        this.bg = this.scrollerImage.getGraphics();
        this.bg.setColor(0);
        this.bg.fillRect(0, 0, this.scrollerWidth, this.scrollerHeight);
        GameImpl.writeDebugOutput("NoOfLevelModules" + cLevel.NoOfLevelModules);
        this.visibleTiles = new short[cLevel.NoOfLevelModules * 4];
    }

    public void reInit(int n, int n2) {
        this.scrollerX = n;
        this.scrollerY = n2;
        this.xo = 0;
        this.yo = 0;
        this.oldX = n;
        this.oldY = n2;
        this.nrRegions = 0;
        this.addRegion(n, n2, this.xo, this.yo, this.scrollerWidth, this.scrollerHeight);
    }

    public void moveX(int n) {
        int n2 = this.xo;
        this.xo += n;
        if (this.xo >= this.scrollerWidth) {
            this.xo -= this.scrollerWidth;
            this.findXRegion(this.scrollerX + this.scrollerWidth, n2, this.scrollerWidth - n2);
            this.findXRegion(this.scrollerX + this.scrollerWidth + (this.scrollerWidth - n2), 0, this.xo);
            return;
        }
        if (this.xo < 0) {
            this.xo += this.scrollerWidth;
            this.findXRegion(this.scrollerX + n, this.xo, this.scrollerWidth - this.xo);
            this.findXRegion(this.scrollerX + n + this.scrollerWidth - this.xo, 0, n2);
            return;
        }
        if (n > 0) {
            this.findXRegion(this.scrollerX + this.scrollerWidth, n2, n);
        } else {
            this.findXRegion(this.scrollerX + n, n2 + n, -n);
        }
    }

    public void findXRegion(int n, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        this.addRegion(n, this.scrollerY, n2, this.yo, n3, this.scrollerHeight - this.yo);
        if (this.yo != 0) {
            this.addRegion(n, this.scrollerY + (this.scrollerHeight - this.yo), n2, 0, n3, this.yo);
        }
    }

    public void moveY(int n) {
        int n2 = this.yo;
        this.yo += n;
        if (this.yo >= this.scrollerHeight) {
            this.yo -= this.scrollerHeight;
            this.findYRegion(this.scrollerY + this.scrollerHeight, n2, this.scrollerHeight - n2);
            this.findYRegion(this.scrollerY + this.scrollerHeight + (this.scrollerHeight - n2), 0, this.yo);
            return;
        }
        if (this.yo < 0) {
            this.yo += this.scrollerHeight;
            this.findYRegion(this.scrollerY + n, this.yo, this.scrollerHeight - this.yo);
            this.findYRegion(this.scrollerY + n + this.scrollerHeight - this.yo, 0, n2);
            return;
        }
        if (n > 0) {
            this.findYRegion(this.scrollerY + this.scrollerHeight, n2, n);
        } else {
            this.findYRegion(this.scrollerY + n, n2 + n, -n);
        }
    }

    public void findYRegion(int n, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        this.addRegion(this.scrollerX, n, this.xo, n2, this.scrollerWidth - this.xo, n3);
        if (this.xo != 0) {
            this.addRegion(this.scrollerX + (this.scrollerWidth - this.xo), n, 0, n2, this.xo, n3);
        }
    }

    public void addRegion(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.nrRegions == 31) {
            this.bReinit = true;
            return;
        }
        Region region = new Region();
        region.x = (short)n;
        region.y = (short)n2;
        region.xo = (short)n3;
        region.yo = (short)n4;
        region.w = (short)n5;
        region.h = (short)n6;
        this.regions[this.nrRegions++] = region;
    }

    public void addRegion(int n, int n2, int n3, int n4) {
        if (this.bReinit) {
            return;
        }
        if (this.scrollerX > n) {
            n3 -= this.scrollerX - n;
            n = this.scrollerX;
        }
        if (this.scrollerY > n2) {
            n4 -= this.scrollerY - n2;
            n2 = this.scrollerY;
        }
        if (n + n3 > this.scrollerX + this.scrollerWidth) {
            n3 -= n + n3 - (this.scrollerX + this.scrollerWidth);
        }
        if (n2 + n4 > this.scrollerY + this.scrollerHeight) {
            n4 -= n2 + n4 - (this.scrollerY + this.scrollerHeight);
        }
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        if (n3 <= this.scrollerWidth - this.xo - (n - this.scrollerX)) {
            if (n4 <= this.scrollerHeight - this.yo - (n2 - this.scrollerY)) {
                this.addRegion(n, n2, this.xo + n - this.scrollerX, this.yo + n2 - this.scrollerY, n3, n4);
            } else {
                int n5 = this.scrollerHeight - this.yo + (this.scrollerY - n2);
                this.addRegion(n, n2, this.xo + n - this.scrollerX, this.yo + n2 - this.scrollerY, n3, n5);
                this.addRegion(n, n2 + n5, this.xo + n - this.scrollerX, 0, n3, n4 - n5);
            }
        } else {
            int n6 = this.scrollerWidth - this.xo + (this.scrollerX - n);
            if (n4 <= this.scrollerHeight - this.yo - (n2 - this.scrollerY)) {
                this.addRegion(n, n2, this.xo + n - this.scrollerX, this.yo + n2 - this.scrollerY, n6, n4);
                this.addRegion(n + n6, n2, 0, this.yo + n2 - this.scrollerY, n3 - n6, n4);
            } else {
                int n7 = this.scrollerHeight - this.yo + (this.scrollerY - n2);
                this.addRegion(n, n2, this.xo + n - this.scrollerX, this.yo + n2 - this.scrollerY, n6, n7);
                this.addRegion(n, n2 + n7, this.xo + n - this.scrollerX, 0, n6, n4 - n7);
                this.addRegion(n + n6, n2, 0, this.yo + n2 - this.scrollerY, n3 - n6, n7);
                this.addRegion(n + n6, n2 + n7, 0, 0, n3 - n6, n4 - n7);
            }
        }
    }

    public void update(int n, int n2) {
        if (this.bReinit) {
            this.reInit(n, n2);
            this.bReinit = false;
            return;
        }
        int n3 = n - this.oldX;
        if (n3 <= -this.scrollerWidth || n3 >= this.scrollerWidth) {
            this.reInit(n, n2);
            return;
        }
        if (n3 != 0) {
            this.moveX(n3);
        }
        this.scrollerX = n;
        this.oldX = n;
        int n4 = n2 - this.oldY;
        if (n4 <= -this.scrollerHeight || n4 >= this.scrollerHeight) {
            this.reInit(n, n2);
            return;
        }
        if (n4 != 0) {
            this.moveY(n4);
        }
        this.scrollerY = n2;
        this.oldY = n2;
    }

    public void blitToScreen(Graphics graphics, View view) {
        if (this.scrollerWidth - this.xo != 0) {
            if (this.scrollerHeight - this.yo != 0) {
                SDKTextUtils.drawRegion(this.scrollerImage, this.xo, this.yo, this.scrollerWidth - this.xo, this.scrollerHeight - this.yo, 0, view.viewPort_x, view.viewPort_y, 20);
            }
            if (this.yo != 0) {
                SDKTextUtils.drawRegion(this.scrollerImage, this.xo, 0, this.scrollerWidth - this.xo, this.yo, 0, view.viewPort_x, this.scrollerHeight - this.yo + view.viewPort_y, 20);
            }
        }
        if (this.xo != 0) {
            if (this.scrollerHeight - this.yo != 0) {
                SDKTextUtils.drawRegion(this.scrollerImage, 0, this.yo, this.xo, this.scrollerHeight - this.yo, 0, this.scrollerWidth - this.xo + view.viewPort_x, view.viewPort_y, 20);
            }
            if (this.yo != 0) {
                SDKTextUtils.drawRegion(this.scrollerImage, 0, 0, this.xo, this.yo, 0, this.scrollerWidth - this.xo + view.viewPort_x, this.scrollerHeight - this.yo + view.viewPort_y, 20);
            }
        }
    }

    public void getInvalidArea() {
        short s = 29999;
        short s2 = 29999;
        int n = -29999;
        int n2 = -29999;
        int n3 = 0;
        for (n3 = 0; n3 < this.nrRegions; ++n3) {
            Region region = this.regions[n3];
            if (region.x < s) {
                s = region.x;
            }
            if (region.y < s2) {
                s2 = region.y;
            }
            if (region.x + region.w > n) {
                n = (short)(region.x + region.w);
            }
            if (region.y + region.h <= n2) continue;
            n2 = (short)(region.y + region.h);
        }
        if (n3 == 0) {
            this.activeRegion.xo = (short)-1;
            this.activeRegion.yo = (short)-1;
        } else {
            this.activeRegion.xo = 0;
            this.activeRegion.yo = 0;
            this.activeRegion.x = s;
            this.activeRegion.y = s2;
            this.activeRegion.w = (short)(n - s);
            this.activeRegion.h = (short)(n2 - s2);
        }
    }

    public void findVisibleObject() {
        int n = this.level.noObjects + this.level.noExtraObjects;
        for (int i = 0; i < n; ++i) {
            short s = this.level.objects[i].boundingBoxX;
            short s2 = this.level.objects[i].boundingBoxY;
            short s3 = this.level.objects[i].boundingBoxW;
            short s4 = this.level.objects[i].boundingBoxH;
            this.level.objects[i].invalidated = false;
            if (this.activeRegion.x > s + s3 || this.activeRegion.y > s2 + s4 || this.activeRegion.x + this.activeRegion.w < s || this.activeRegion.y + this.activeRegion.h < s2) continue;
            this.level.objects[i].invalidated = true;
        }
    }

    public void drawScrollerObjects(Region region, int n) {
        SDKTextUtils.setClip(this.bg, region.xo, region.yo, region.w, region.h);
        for (int i = 0; i < this.level.noObjects + this.level.noExtraObjects; ++i) {
            if (!this.level.objects[i].invalidated || this.level.objects[i].layer != n) continue;
            int n2 = this.level.objects[i].boundingBoxX;
            int n3 = this.level.objects[i].boundingBoxY;
            int n4 = this.level.objects[i].boundingBoxW;
            int n5 = this.level.objects[i].boundingBoxH;
            n3 -= region.y;
            if ((n2 -= region.x) < 0) {
                n4 += n2;
                n2 = 0;
            }
            if (n2 + n4 > region.w) {
                n4 = region.w - n2;
            }
            if (n4 < 0) continue;
            if (n3 < 0) {
                n5 += n3;
                n3 = 0;
            }
            if (n3 + n5 > region.h) {
                n5 = region.h - n3;
            }
            if (n5 < 0) continue;
            this.level.objects[i].draw(this.bg, region.xo + (this.level.objects[i].posX - region.x), region.yo + (this.level.objects[i].posY - region.y));
        }
    }

    public void findVisibleTiles() {
        int n = 0;
        this.nrVisibleTiles = 0;
        int n2 = this.level.NoOfLevelModules;
        for (int i = n2 - 1; i >= 0; --i) {
            short s;
            short s2;
            short s3 = this.level.levelModuleId[i];
            short s4 = this.level.levelModuleOffsetX[i];
            short s5 = this.level.levelModuleOffsetY[i];
            byte by = this.level.levelModulesFlag[i];
            switch (by) {
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    s2 = CLevel.modulesW[s3];
                    s = CLevel.modulesH[s3];
                    break;
                }
                default: {
                    s = CLevel.modulesW[s3];
                    s2 = CLevel.modulesH[s3];
                }
            }
            if (this.activeRegion.x > s4 + s || this.activeRegion.y > s5 + s2 || this.activeRegion.x + this.activeRegion.w < s4 || this.activeRegion.y + this.activeRegion.h < s5) continue;
            ++this.nrVisibleTiles;
            if (this.nrVisibleTiles > this.visibleTiles.length) break;
            this.visibleTiles[n] = (short)(s3 << 8 | by & 0xFF);
            this.visibleTiles[n + 1] = s4;
            this.visibleTiles[n + 2] = s5;
            this.visibleTiles[n + 3] = (short)(s << 8 | s2 & 0xFF);
            n += 4;
        }
    }

    public void drawScrollerModules(Region region) {
        SDKTextUtils.setClip(this.bg, region.xo, region.yo, region.w, region.h);
        int n = 0;
        block6: for (int i = 0; i < this.nrVisibleTiles; ++i) {
            int n2 = this.visibleTiles[n] >> 8 & 0xFF;
            int n3 = this.visibleTiles[n + 1];
            int n4 = this.visibleTiles[n + 2];
            int n5 = this.visibleTiles[n] & 0xFF;
            int n6 = this.visibleTiles[n + 3] >> 8 & 0xFF;
            int n7 = this.visibleTiles[n + 3] & 0xFF;
            n += 4;
            int n8 = 0;
            int n9 = 0;
            switch (n5) {
                case 0: {
                    n4 -= region.y;
                    if ((n3 -= region.x) < 0) {
                        n8 = -n3;
                        n6 += n3;
                        n3 = 0;
                    }
                    if (n3 + n6 > region.w) {
                        n6 = region.w - n3;
                    }
                    if (n6 < 0) continue block6;
                    if (n4 < 0) {
                        n9 = -n4;
                        n7 += n4;
                        n4 = 0;
                    }
                    if (n4 + n7 > region.h) {
                        n7 = region.h - n4;
                    }
                    if (n7 >= 0) break;
                    continue block6;
                }
                case 2: {
                    int n10 = n6;
                    n4 -= region.y;
                    if ((n3 -= region.x) < 0) {
                        n8 = -n3;
                        n6 += n3;
                        n3 = 0;
                    }
                    if (n3 + n6 > region.w) {
                        n6 = region.w - n3;
                    }
                    if (n6 < 0) continue block6;
                    if (n4 < 0) {
                        n9 = -n4;
                        n7 += n4;
                        n4 = 0;
                    }
                    if (n4 + n7 > region.h) {
                        n7 = region.h - n4;
                    }
                    if (n7 < 0) continue block6;
                    n8 = n10 - n6 - n8;
                    break;
                }
                case 3: {
                    int n10 = n6;
                    int n11 = n7;
                    n4 -= region.y;
                    if ((n3 -= region.x) < 0) {
                        n8 = -n3;
                        n6 += n3;
                        n3 = 0;
                    }
                    if (n3 + n6 > region.w) {
                        n6 = region.w - n3;
                    }
                    if (n6 < 0) continue block6;
                    if (n4 < 0) {
                        n9 = -n4;
                        n7 += n4;
                        n4 = 0;
                    }
                    if (n4 + n7 > region.h) {
                        n7 = region.h - n4;
                    }
                    if (n7 < 0) continue block6;
                    n8 = n10 - n6 - n8;
                    n9 = n11 - n7 - n9;
                    break;
                }
                case 1: {
                    int n11 = n7;
                    n4 -= region.y;
                    if ((n3 -= region.x) < 0) {
                        n8 = -n3;
                        n6 += n3;
                        n3 = 0;
                    }
                    if (n3 + n6 > region.w) {
                        n6 = region.w - n3;
                    }
                    if (n6 < 0) continue block6;
                    if (n4 < 0) {
                        n9 = -n4;
                        n7 += n4;
                        n4 = 0;
                    }
                    if (n4 + n7 > region.h) {
                        n7 = region.h - n4;
                    }
                    if (n7 < 0) continue block6;
                    n9 = n11 - n7 - n9;
                    break;
                }
                default: {
                    if (region.x > n3 + n6 || region.y > n4 + n7 || region.x + region.w < n3 || region.y + region.h < n4) continue block6;
                    n3 -= region.x;
                    n4 -= region.y;
                    n6 = CLevel.modulesW[n2];
                    n7 = CLevel.modulesH[n2];
                    SDKTextUtils.setClip(this.bg, region.xo, region.yo, region.w, region.h);
                }
            }
            SDKTextUtils.setGraphics(this.bg);
            SDKTextUtils.drawRegion(CLevel.image[this.level.currentPallete], CLevel.modulesX[n2] + n8, CLevel.modulesY[n2] + n9, n6, n7, n5, region.xo + n3, region.yo + n4, 20);
        }
    }
}

