/*
 * Decompiled with CFR 0.152.
 */
package com.ea.cnc;

import com.ea.cnc.GameConfig;
import com.ea.cnc.GameImpl;
import com.ea.cnc.LevelObject;
import com.ea.cnc.Unit;
import com.ea.sdk.SDKScript;
import com.ea.sdk.SDKSound;
import com.ea.sdk.SDKTextUtils;
import javax.microedition.lcdui.Graphics;

public class Team
implements GameConfig {
    public static final byte[][] teamUnitOffsets = new byte[][]{{5, -3}, {-17, 17}, {-17, -17}, {17, -17}, {17, 17}, {17, 2}};
    public boolean[] teamUnitOffsetsOcupied = new boolean[]{false, false, false, false, false, false};
    int noOfUnits;
    short alliance;
    static int[] unitsPerAlliance = new int[]{0, 0, 0};
    static int[] tanksPerAlliance = new int[]{0, 0, 0};
    Unit[] troops;
    int posX;
    int posY;
    int spawnX;
    int spawnY;
    int nextPosX;
    int nextPosY;
    short ID;
    short reg;
    boolean isWave;
    boolean active;

    Team(short s, short s2, short s3, short s4) {
        this.posX = GameImpl.currentView.level.directionalHotspots[s4][0];
        this.posY = GameImpl.currentView.level.directionalHotspots[s4][1];
        this.spawnX = this.posX;
        this.spawnY = this.posY;
        this.nextPosX = this.posX;
        this.nextPosY = this.posY;
        this.alliance = s;
        this.troops = new Unit[5];
        this.noOfUnits = 0;
        this.ID = s2;
        this.reg = s3;
        this.isWave = false;
        this.active = false;
    }

    public int addUnit(Unit unit) {
        GameImpl.writeDebugOutput("add unit");
        if (this.noOfUnits == 5) {
            return -1;
        }
        short s = this.alliance;
        unitsPerAlliance[s] = unitsPerAlliance[s] + 1;
        this.troops[this.noOfUnits] = unit;
        Team.updateUnitReg(unit.type, this.alliance, 1);
        short s2 = this.reg;
        SDKScript.regCX[s2] = (byte)(SDKScript.regCX[s2] + 1);
        int n = 0;
        for (int n2 = 0; n2 < 5; n2 = (int)((byte)(n2 + 1))) {
            if (this.teamUnitOffsetsOcupied[n2]) continue;
            n = n2;
            this.teamUnitOffsetsOcupied[n2] = true;
            break;
        }
        switch (unit.type) {
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                short s3 = this.alliance;
                tanksPerAlliance[s3] = tanksPerAlliance[s3] + 1;
            }
        }
        unit.setPositionTargetOfsset(n);
        ++this.noOfUnits;
        this.active = true;
        if (this.alliance == 0) {
            ++GameImpl.unitsProduced;
            this.getCenter();
        }
        Unit.checkAllForMorale = true;
        GameImpl.addForegroundObject(unit);
        return this.noOfUnits;
    }

    public int replaceUnit(Unit unit, int n) {
        n = 5 - n - 1;
        Team.updateUnitReg(this.troops[n].type, this.alliance, -1);
        Team.updateUnitReg(unit.type, this.alliance, 1);
        GameImpl.removeForegroundObject(this.troops[n]);
        this.troops[n].dispose();
        this.troops[n] = unit;
        GameImpl.addForegroundObject(this.troops[n]);
        unit.setPositionTargetOfsset((byte)n);
        if (this.alliance == 0) {
            this.getCenter();
            ++GameImpl.unitsProduced;
        }
        return this.noOfUnits;
    }

    void drawUnitTriangles(Graphics graphics) {
        for (int i = 0; i < this.noOfUnits; ++i) {
            Unit unit = this.troops[i];
            int n = unit.posX - 6 + 3 + GameImpl.currentView.viewPort_x - GameImpl.currentView.viewPortMapX;
            int n2 = unit.posY - 16 + GameImpl.currentView.viewPort_y - GameImpl.currentView.viewPortMapY;
            SDKTextUtils.fillTriangle(n, n2, n + 3, n2 + 4, n + 6, n2, GameImpl.currentGdiTeam == 0 ? 13565745 : 1684718);
        }
    }

    void Update(long l, int n, boolean bl) {
        for (int i = 0; i < this.noOfUnits; ++i) {
            this.troops[i].upDate(l, n, bl);
        }
        if (this.alliance == 0) {
            this.getCenter();
        }
    }

    void draw(Graphics graphics) {
        for (int i = 0; i < this.noOfUnits; ++i) {
            this.troops[i].draw(graphics);
        }
    }

    public void killUnit(int n) {
        this.killUnit(this.troops[n]);
    }

    void killUnit(Unit unit) {
        int n;
        int n2;
        for (n2 = 0; this.troops[n2] != unit && n2 < this.noOfUnits; ++n2) {
        }
        if (n2 == this.noOfUnits || this.troops[n2] == null) {
            return;
        }
        Team.updateUnitReg(unit.type, this.alliance, -1);
        if (this.alliance == 1) {
            ++GameImpl.unitsKilled;
            if (GameImpl.skirmishMode) {
                GameImpl.current_money += GameImpl.unitsBonus[unit.type - 20] * 10;
                GameImpl.moneyGenerated += GameImpl.unitsBonus[unit.type - 20] * 10;
            }
        } else {
            ++GameImpl.unitsLost;
        }
        short s = this.alliance;
        unitsPerAlliance[s] = unitsPerAlliance[s] - 1;
        switch (unit.type) {
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                short s2 = this.alliance;
                tanksPerAlliance[s2] = tanksPerAlliance[s2] - 1;
            }
        }
        this.teamUnitOffsetsOcupied[this.troops[n2].offsetTarget] = false;
        switch (unit.type) {
            case 13: 
            case 15: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                GameImpl.addOverlayAnimation(0, unit.posX, unit.posY, GameImpl.miscSprite, 2);
                LevelObject levelObject = new LevelObject(19, (short)unit.posX, (short)unit.posY, 4, 10000, 1);
                GameImpl.currentView.level.addExtraObject(levelObject);
                if (!GameImpl.vibraStatus) break;
                SDKSound.vibrate(100);
                break;
            }
            default: {
                GameImpl.addOverlayAnimation(0, unit.posX, unit.posY, GameImpl.miscSprite, 3);
                GameImpl.addOverlayAnimation(-200, unit.posX, unit.posY, GameImpl.miscSprite, 4);
            }
        }
        for (n = n2; n < this.noOfUnits - 1; ++n) {
            this.troops[n] = this.troops[n + 1];
        }
        --this.noOfUnits;
        this.troops[this.noOfUnits].dispose();
        this.troops[this.noOfUnits] = null;
        short s3 = this.reg;
        SDKScript.regCX[s3] = (byte)(SDKScript.regCX[s3] - 1);
        if (SDKScript.regCX[this.reg] < 0) {
            SDKScript.regCX[this.reg] = 0;
        }
        if (this.noOfUnits <= 0) {
            if (this.alliance != 0) {
                GameImpl.removeTeam(this);
            } else {
                this.active = false;
                for (n = 0; n < GameImpl.noOfTeams[0]; ++n) {
                    if (n == GameImpl.currentGdiTeam || !GameImpl.factions[0][n].active) continue;
                    GameImpl.currentGdiTeam = n;
                    GameImpl.moveCamera(GameImpl.factions[0][GameImpl.currentGdiTeam].posX, GameImpl.factions[0][GameImpl.currentGdiTeam].posY, true);
                    break;
                }
                --GameImpl.noOfActiveGdiTeams;
                GameImpl.setSoftKeys();
            }
        }
        Unit.checkAllForMorale = true;
        GameImpl.removeForegroundObject(unit);
        GameImpl.writeDebugOutput("!! !! SDKScript.regCX[" + this.reg + "]: " + SDKScript.regCX[this.reg]);
    }

    public int[] getList(int n) {
        int[] nArray = null;
        switch (n) {
            case 0: {
                int n2;
                nArray = new int[6];
                for (n2 = 0; n2 < 5; ++n2) {
                    nArray[n2] = 28;
                }
                for (n2 = 0; n2 < this.noOfUnits; ++n2) {
                    nArray[nArray.length - 1 - n2 - 1] = this.troops[n2].type;
                }
                nArray[5] = 26;
                break;
            }
            case 1: {
                nArray = new int[this.noOfUnits + 1];
                for (int i = 0; i < this.noOfUnits; ++i) {
                    nArray[i] = this.troops[i].type;
                }
                nArray[this.noOfUnits] = 26;
            }
        }
        return nArray;
    }

    public void getCenter() {
        if (this.noOfUnits == 0) {
            return;
        }
        int n = -10000;
        int n2 = -10000;
        int n3 = 1000;
        int n4 = 10000;
        for (int i = 0; i < this.noOfUnits; ++i) {
            if (this.troops[i].posX > n) {
                n = this.troops[i].posX;
            }
            if (this.troops[i].posY > n2) {
                n2 = this.troops[i].posY;
            }
            if (this.troops[i].posX < n3) {
                n3 = this.troops[i].posX;
            }
            if (this.troops[i].posY >= n4) continue;
            n4 = this.troops[i].posY;
        }
        this.posX = (n - n3) / 2 + n3;
        this.posY = (n2 - n4) / 2 + n4;
    }

    public static void updateUnitReg(int n, int n2, int n3) {
        if (n2 == 0) {
            switch (n) {
                case 10: {
                    SDKScript.regCX[25] = (byte)(SDKScript.regCX[25] + n3);
                    break;
                }
                case 13: {
                    SDKScript.regCX[28] = (byte)(SDKScript.regCX[28] + n3);
                    break;
                }
                case 15: {
                    SDKScript.regCX[30] = (byte)(SDKScript.regCX[30] + n3);
                }
            }
            return;
        }
    }

    public static void resetTanksCounter() {
        unitsPerAlliance = new int[]{0, 0, 0};
        tanksPerAlliance = new int[]{0, 0, 0};
    }

    public void dispose() {
    }
}

