/*
 * Decompiled with CFR 0.152.
 */
package com.ea.cnc;

import com.ea.cnc.AniSprite;
import com.ea.cnc.CActor;
import com.ea.cnc.CGlobals;
import com.ea.cnc.CLevel;
import com.ea.cnc.GameConfig;
import com.ea.cnc.GameImpl;
import com.ea.cnc.PathFinderFast;
import com.ea.cnc.Projectile;
import com.ea.cnc.Targetable;
import com.ea.cnc.Unit;
import com.ea.sdk.SDKScript;
import javax.microedition.lcdui.Graphics;

public class Building
extends Targetable
implements GameConfig {
    public int range = 100;
    private int sqr_range = 10000;
    public int buildTime;
    static final int STATUS_OK = 1;
    static final int STATUS_UNPOWERED = 2;
    static final int STATUS_UNERECTED = 3;
    public byte type = (byte)-1;
    public int[] option_list;
    public int upgrade_level = 0;
    public int health = 1500;
    public int health_max = 1500;
    public int status = 0;
    private int attackCoolDown;
    public int turretOrientation;
    static int maximPower;
    static int powerUsed;
    public static final int POWER_COST_HQ = 0;
    public static final int POWER_COST_POWER_PLANT = 0;
    public static final int POWER_COST_BARACKS = 8;
    public static final int POWER_COST_WATCHTOWER = 5;
    public static final int POWER_COST_REFINERY = 8;
    public static final int POWER_COST_WARFACTORY = 10;
    public static final int POWER_COST_COMMAND_POST = 8;
    public static final int POWER_COST_AIRFIELD = 10;
    public static final int POWER_COST_TECH_CENTER = 5;
    public static final int POWER_COST_ION_CANNON = 20;
    static final int[] powerCost;
    public static final int HITPOINTS_HQ = 1500;
    public static final int HITPOINTS_POWER_PLANT = 900;
    public static final int HITPOINTS_BARACKS = 950;
    public static final int HITPOINTS_WATCHTOWER = 1000;
    public static final int HITPOINTS_REFINERY = 1200;
    public static final int HITPOINTS_WARFACTORY = 1200;
    public static final int HITPOINTS_COMMAND_POST = 1000;
    public static final int HITPOINTS_AIRFIELD = 1100;
    public static final int HITPOINTS_TECH_CENTER = 900;
    public static final int HITPOINTS_ION_CANON = 1300;
    public static final int HITPOINTS_UNBUILDABLE = 0;
    static final int[] buildingsHealth;
    public static AniSprite turret;
    static AniSprite anime;
    static int orcaNo;
    static int firehawkNo;
    public CActor actor;
    static final Building building_unbuildable;
    static final Building building_extensible;
    static final Building building_free;
    static final int UPGRADE_LEVEL0 = 1;
    static final int UPGRADE_LEVEL1 = 0;
    public static int upgradeRailGun;
    public static int upgradeArmour;
    public static int upgradeEnergyPack;
    public static int hqPosX;
    public static int hqPosY;

    void setCollision(int n, int n2, byte by) {
        int n3 = GameImpl.buildings_map_posX;
        int n4 = GameImpl.buildings_map_posY;
        this.posX = n3 + n2 * 14 + n * 45 + 22;
        this.posY = n4 + n2 * 45 - n * 14 + 22;
        int n5 = n3 + n2 * 14 + n * 45 - 5;
        int n6 = n4 + n2 * 45 - n * 14 - 5;
        int n7 = n3 + (n2 + 1) * 14 + (n + 1) * 45;
        int n8 = n4 + (n2 + 1) * 45 - (n + 1) * 14 + 10;
        int n9 = n5 + 45;
        int n10 = n6;
        int n11 = n3 + (n2 + 1) * 14 + n * 45 + 5;
        int n12 = n4 + (n2 + 1) * 45 - n * 14 + 5;
        CLevel.intersect(n5, n6, n9, n10, by, PathFinderFast.mGrid, true);
        CLevel.intersect(n5, n6, n11, n12, by, PathFinderFast.mGrid, true);
        CLevel.intersect(n7, n8, n9, n10, by, PathFinderFast.mGrid, true);
        CLevel.intersect(n7, n8, n11, n12, by, PathFinderFast.mGrid, true);
    }

    public Building(byte by, int n, byte by2, byte by3, boolean bl) {
        this.alliance = n;
        this.type = by;
        if (this.type >= 0) {
            this.actor = new CActor(anime);
            this.actor.initActor(10, 0, 1);
            this.status = 1;
            if (this.alliance == 0 && GameImpl.state_game != 6) {
                GameImpl.unlocked_buildings |= 1 << this.type;
                GameImpl.confirmed_buildings |= 1 << this.type;
            }
            this.health_max = this.health = buildingsHealth[this.type];
            this.setCollision(by2, by3, (byte)80);
            if (bl) {
                this.status = 3;
                this.buildTime = 2000;
            } else {
                this.completeBuilding();
            }
            GameImpl.extendGrid(by2, by3, building_free);
        }
        if (by == 0) {
            hqPosX = this.posX;
            hqPosY = this.posY;
            GameImpl.building_map_currentX = by2;
            GameImpl.building_map_currentY = by3;
        }
        GameImpl.updateBuildingReg(this, 1);
    }

    public void completeBuilding() {
        if (this.type == 1) {
            this.status = 1;
            maximPower += 15;
        } else if (this.type == 0) {
            this.status = 1;
        }
        powerUsed += powerCost[this.type];
        GameImpl.setList(this);
        if (this.status == 2) {
            this.actor.initActor(this.type + 11, 0, 1);
        } else {
            this.actor.initActor(this.type, 0, 1);
        }
    }

    public static void computePower() {
        powerUsed = 0;
        maximPower = 0;
        for (int i = 0; i < GameImpl.buildings.length; ++i) {
            if (GameImpl.buildings[i].type < 0 || GameImpl.buildings[i].status == 3) continue;
            if (GameImpl.buildings[i].type == 1) {
                maximPower += 15;
            }
            powerUsed += powerCost[GameImpl.buildings[i].type];
        }
    }

    public static void updatePower() {
        int n = 0;
        if (powerUsed <= maximPower - GameImpl._nIonCannonPowerUsed) {
            if (SDKScript.regCX[77] != 0) {
                GameImpl.actorInterface.initActor(0, -1, -1);
            }
            n = 1;
            SDKScript.regCX[77] = 0;
        } else {
            if (SDKScript.regCX[77] != 1) {
                GameImpl.actorInterface.initActor(0, 0, 1);
            }
            n = 2;
            SDKScript.regCX[77] = 1;
        }
        for (int i = 0; i < GameImpl.buildings.length; ++i) {
            if (GameImpl.buildings[i].type < 0 || GameImpl.buildings[i].status == 3) continue;
            if (n == 1 && GameImpl.buildings[i].status != n) {
                GameImpl.buildings[i].actor.initActor(GameImpl.buildings[i].type, 0, 1);
            } else if (n == 2 && GameImpl.buildings[i].status != n) {
                GameImpl.buildings[i].actor.initActor(GameImpl.buildings[i].type + 11, 0, 1);
            }
            GameImpl.buildings[i].status = n;
        }
    }

    public void destroyBuilding(int n, int n2, int n3) {
        int n4 = n3 / 5;
        int n5 = n3 % 5;
        this.setCollision(n5, n4, (byte)1);
        powerUsed -= powerCost[this.type];
        if (this.type == 1) {
            maximPower -= 15;
        }
        GameImpl.updateBuildingReg(this, -1);
        if (GameImpl.state_game == 2 || GameImpl.state_game == 6 || GameImpl.state_game == 7) {
            GameImpl.addOverlayAnimation(0, this.posX, this.posY, GameImpl.miscSprite, 2);
        }
        for (int i = 0; i < PathFinderFast.mDirection.length; ++i) {
            int n6 = n4 + PathFinderFast.mDirection[i][1];
            int n7 = n5 + PathFinderFast.mDirection[i][0];
            int n8 = n7 + n6 * 5;
            if (n7 < 0 || n7 >= 5 || n6 < 0 || n6 >= 5 || GameImpl.buildings[n8].type < 0) continue;
            GameImpl.buildings[n8].setCollision(n7, n6, (byte)80);
        }
        this.dispose();
    }

    public void update(long l, int n) {
        if (this.type < 0) {
            return;
        }
        if (this.status == 3) {
            this.buildTime -= n;
            if (this.buildTime <= 0) {
                this.status = 2;
                this.completeBuilding();
                Building.updatePower();
            }
        }
        boolean bl = false;
        if (this.type == 3 && this.status == 1) {
            for (int i = 0; i < GameImpl.noOfTeams[1]; ++i) {
                Unit[] unitArray = GameImpl.factions[1][i].troops;
                int n2 = GameImpl.factions[1][i].noOfUnits;
                for (int j = 0; j < n2; ++j) {
                    int n3 = unitArray[j].posX - this.posX;
                    int n4 = unitArray[j].posY - this.posY;
                    int n5 = n3 * n3 + n4 * n4;
                    if (n5 > this.sqr_range) continue;
                    unitArray[j].isCloaked = false;
                    if (bl || this.attackCoolDown > 0) continue;
                    bl = true;
                    this.turretOrientation = CGlobals.getOrientation(n3, n4, this.turretOrientation);
                    Projectile.attemptToCreateProjectile(1, 12 - unitArray[j].armour, l, this, unitArray[j]);
                    this.attackCoolDown = 500;
                }
            }
        }
        this.attackCoolDown -= n;
        this.actor.update(n);
    }

    public void draw(Graphics graphics) {
        if (this.type < 0) {
            return;
        }
        int n = this.posX - GameImpl.currentView.viewPortMapX + GameImpl.currentView.viewPort_x;
        int n2 = this.posY - GameImpl.currentView.viewPortMapY + GameImpl.currentView.viewPort_y;
        if (n + 22 < GameImpl.currentView.viewPort_x || n - 22 > 240 || n2 + 22 < GameImpl.currentView.viewPort_y || n2 - 22 > 320) {
            return;
        }
        this.actor.draw(graphics, n, n2);
        if (this.type == 3 && this.actor._nAnimationId != 10) {
            turret.drawFrame(this.turretOrientation, graphics, n += anime.getHotSpot(this.actor._nAnimationId, 0, 1, 0), n2 += anime.getHotSpot(this.actor._nAnimationId, 0, 1, 1));
            n2 -= 5;
        }
        if (this.health != this.health_max && this.health != 10000) {
            int n3 = 20;
            graphics.setColor(255);
            graphics.fillRect(n - n3 / 2, n2 - 11, n3, 4);
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(n - n3 / 2 - 1, n2 - 11 + 1, (n3 - 2) * this.health / this.health_max, 2);
        }
    }

    public void takeDamage(int n) {
        if (this.health == 10000) {
            return;
        }
        this.health -= n;
        SDKScript.regCX[73] = 1;
        if (this.type == 0 && this.alliance == 0) {
            SDKScript.regCX[72] = 0;
        }
    }

    public void repair() {
        this.health = this.health_max;
        if (this.type == 0) {
            SDKScript.regCX[72] = 1;
        }
    }

    public void upGrade() {
        ++this.upgrade_level;
    }

    public int getCursorType() {
        return 0;
    }

    public int getTargetPointX() {
        return this.posX + anime.getHotSpot(-1, this.type, 0, 0);
    }

    public int getTargetPointY() {
        return this.posY + anime.getHotSpot(-1, this.type, 0, 1);
    }

    public int getBulletPositionX() {
        return this.posX + anime.getHotSpot(this.actor._nAnimationId, 0, 1, 0) + turret.getHotSpot(this.turretOrientation, 0, 0, 0);
    }

    public int getBulletPositionY() {
        return this.posY + anime.getHotSpot(this.actor._nAnimationId, 0, 1, 1) + turret.getHotSpot(this.turretOrientation, 0, 0, 1);
    }

    void dispose() {
        this.option_list = null;
    }

    static {
        powerCost = new int[]{0, 0, 8, 5, 8, 10, 8, 10, 5, 20};
        buildingsHealth = new int[]{1500, 900, 950, 1000, 1200, 1200, 1000, 1100, 900, 1300, 0};
        orcaNo = 0;
        firehawkNo = 0;
        building_unbuildable = new Building(-3, 1, 1, 1, false);
        building_extensible = new Building(-2, 1, 1, 1, false);
        building_free = new Building(-1, 1, 1, 1, false);
        upgradeRailGun = 1;
        upgradeArmour = 1;
        upgradeEnergyPack = 1;
    }
}

