/*
 * Decompiled with CFR 0.152.
 */
package com.ea.cnc;

import com.ea.cnc.AniSprite;
import com.ea.cnc.Building;
import com.ea.cnc.CActor;
import com.ea.cnc.CGlobals;
import com.ea.cnc.GameConfig;
import com.ea.cnc.GameImpl;
import com.ea.cnc.PathFinderFast;
import com.ea.cnc.Projectile;
import com.ea.cnc.Targetable;
import com.ea.cnc.Team;
import com.ea.cnc.View;
import com.ea.sdk.SDKScript;
import javax.microedition.lcdui.Graphics;

public class Unit
extends Targetable
implements GameConfig {
    static final int UNIT_STATE_WAIT = 0;
    static final int UNIT_STATE_WALK = 1;
    static final int UNIT_STATE_WALK_TOTHE_SAFEPOINT = 2;
    static final int UNIT_STATE_WAIT_FEW_SECONDS = 3;
    static final int TIME_WAIT_AT_SAFEPOINT = 3000;
    int waitTime = 0;
    int shotsFired;
    boolean isCloaked = false;
    boolean isCloakedOld = false;
    int unitExperienceLevel = 0;
    int firedShots = 0;
    public int maxim_morale = 100;
    public boolean checkForMorale = false;
    public static boolean checkAllForMorale = false;
    public int morale = 0;
    public boolean safePointVisited = false;
    public int safePointVisitNO = 0;
    public int range = 65;
    public int sqr_range = 4225;
    Team pTeam;
    public int health;
    public int maxHealth;
    private int cellOffsetX;
    private int cellOffsetY;
    public int offsetTarget;
    byte[] currentPathX = new byte[126];
    byte[] currentPathY = new byte[126];
    int pathSize;
    int pathStep;
    int speed;
    int speedTime;
    public static final int NO_FRAME_SPEED_UP = 20;
    private int framePassed = -1;
    boolean attacking;
    private int attackCoolDown;
    private int state;
    public int type;
    AniSprite anime;
    AniSprite turretAnime;
    CActor actor;
    int currentOrientation;
    int orientation;
    int palette;
    CActor turretActor;
    int turretPalette;
    int turretOrientation;
    int lastPosX;
    int lastPosY;
    Building fanaticBuildingTarget = null;
    boolean fanaticMode;
    short damage;
    short armour;
    int waypointsPathId;
    int currentWaypoint;
    boolean loopPath;
    public static int nextId = 0;
    public int unitId = nextId++;
    static final int HEALTH_BAR_HEIGHT = 2;
    static final int HEALTH_BAR_WIDTH = 15;
    static final int HEALTH_BAR_POSITION = 10;
    static final int RANK_SIZE = 3;
    static final int RANK_POSITION = 10;

    Unit(Team team, int n) {
        GameImpl.writeDebugOutput("type: " + n);
        this.type = n;
        this.isCloaked = false;
        this.isCloakedOld = false;
        this.waypointsPathId = -1;
        this.currentWaypoint = -1;
        this.loopPath = false;
        this.palette = 0;
        this.turretPalette = 0;
        GameImpl.setUnitStates(this);
        this.actor = new CActor(this.anime);
        this.currentOrientation = 4;
        this.orientation = 4;
        this.actor.initActor(4, 0, 1);
        if (this.turretAnime != null) {
            this.turretActor = new CActor(this.turretAnime);
            this.turretOrientation = 4;
            this.turretActor.initActor(4, 0, 1);
        }
        this.pTeam = team;
        this.alliance = team.alliance;
        this.state = 0;
        this.attacking = false;
        this.safePointVisited = false;
        this.unitExperienceLevel = 0;
        this.firedShots = 0;
        this.sqr_range = this.range * this.range;
        this.hasPositionChanged = true;
        this.safePointVisitNO = 0;
    }

    void setPositionTargetOfsset(int n) {
        this.offsetTarget = n;
        this.lastPosX = this.posX = this.pTeam.posX + Team.teamUnitOffsets[n][0];
        this.lastPosY = this.posY = this.pTeam.posY + Team.teamUnitOffsets[n][1];
        this.cellOffsetX = ((Team.teamUnitOffsets[n][0] + 8) % 16 + 16) % 16;
        this.cellOffsetY = ((Team.teamUnitOffsets[n][1] + 8) % 16 + 16) % 16;
        this.pathSize = 0;
        this.state = 0;
        this.hasPositionChanged = true;
    }

    void setOrientation(int n, int n2) {
        this.orientation = CGlobals.getOrientation(n, n2, this.currentOrientation);
        if (this.currentOrientation != this.orientation && this.actor._nAnimationId != 16) {
            int n3 = this.currentOrientation - this.orientation;
            int n4 = n3 < 0 ? -1 : 1;
            int n5 = 1;
            if (n3 > -4 && n4 == -1) {
                n5 = 1;
            }
            if (n3 < -4 && n4 == -1) {
                n5 = -1;
            }
            if (n3 < 4 && n4 == 1) {
                n5 = -1;
            }
            if (n3 > 4 && n4 == 1) {
                n5 = 1;
            }
            this.actor.initActor(16, this.currentOrientation << 1, n5);
        }
    }

    public boolean isInScreen() {
        return GameImpl.currentView.viewPortMapX <= this.posX + 10 && GameImpl.currentView.viewPortMapY <= this.posY + 10 && GameImpl.currentView.viewPortMapX + GameImpl.currentView.viewPort_width >= this.posX && GameImpl.currentView.viewPortMapY + GameImpl.currentView.viewPort_height >= this.posY;
    }

    void draw(Graphics graphics) {
        int n = this.posX + GameImpl.currentView.viewPort_x - GameImpl.currentView.viewPortMapX;
        int n2 = this.posY + GameImpl.currentView.viewPort_y - GameImpl.currentView.viewPortMapY;
        if (!this.isInScreen()) {
            return;
        }
        this.anime.setCurrentPalette(this.palette);
        if (this.isCloakedOld && this.isCloaked == this.isCloakedOld) {
            return;
        }
        this.actor.draw(graphics, n, n2);
        if (this.turretActor != null) {
            this.turretActor._oSprite.setCurrentPalette(this.turretPalette);
            this.turretActor.draw(graphics, n, n2);
        }
        if (this.health < this.maxHealth) {
            graphics.setColor(65280);
            graphics.fillRect(n - 7, n2 - 10, 15 * this.health / this.maxHealth, 2);
            if (this.pTeam.alliance == 0) {
                graphics.setColor(255);
            } else {
                graphics.setColor(0xFF0000);
            }
            graphics.drawRect(n - 7, n2 - 10, 15, 2);
        }
        switch (this.unitExperienceLevel) {
            case 2: {
                graphics.setColor(0xFF7733);
                graphics.drawLine(n + 10, n2 - 10 + 2, n + 10 + 3, n2 - 10 + 2 + 3);
                graphics.drawLine(n + 10 + 3, n2 - 10 + 2 + 3, n + 10 + 6, n2 - 10 + 2);
                graphics.setColor(0xFFFF00);
                graphics.drawLine(n + 10, n2 - 10 + 3, n + 10 + 3, n2 - 10 + 3 + 3);
                graphics.drawLine(n + 10 + 3, n2 - 10 + 3 + 3, n + 10 + 6, n2 - 10 + 3);
            }
            case 1: {
                graphics.setColor(0xFFFF00);
                graphics.drawLine(n + 10, n2 - 10, n + 10 + 3, n2 - 10 + 3);
                graphics.drawLine(n + 10 + 3, n2 - 10 + 3, n + 10 + 6, n2 - 10);
            }
        }
    }

    void aquireTarget() {
        int n = -1;
        switch (this.type) {
            case 21: {
                n = GameImpl.getClosestBuilding(this.posX, this.posY, 1, true, this);
                break;
            }
            case 24: {
                n = GameImpl.getClosestBuilding(this.posX, this.posY, 2, false, this);
                if (n != -1) break;
                n = GameImpl.getClosestBuilding(this.posX, this.posY, 5, true, this);
                break;
            }
            case 23: {
                n = GameImpl.getClosestBuilding(this.posX, this.posY, 0, true, this);
                break;
            }
            case 22: {
                n = GameImpl.getClosestBuilding(this.posX, this.posY, 7, false, this);
                if (n == -1) {
                    n = GameImpl.getClosestBuilding(this.posX, this.posY, 9, false, this);
                }
                if (n != -1) break;
                n = GameImpl.getClosestBuilding(this.posX, this.posY, 0, true, this);
                break;
            }
            default: {
                n = GameImpl.getClosestBuilding(this.posX, this.posY, -1, true, this);
            }
        }
        if (n != -1) {
            short s = (short)(n & 0xFFFF);
            short s2 = (short)(n >> 16 & 0xFFFF);
            this.setDestination(s2, s);
        } else {
            GameImpl.writeDebugOutput("NO BUILDING FOUND");
        }
    }

    public void updateNod(int n) {
        if (this.loopPath && (SDKScript.regCX[9] < 5 || SDKScript.regCX[0] == 0)) {
            this.loopPath = false;
        }
        if (this.framePassed == 0) {
            this.speed *= 3;
        }
        if (this.type == 23) {
            if (this.isCloaked != this.isCloakedOld) {
                if (this.actor._nAnimationId != 8 + this.currentOrientation) {
                    if (!this.isCloakedOld) {
                        this.actor.initActor(8 + this.currentOrientation, 0, 1);
                    } else {
                        this.actor.initActor(8 + this.currentOrientation, -1, -1);
                    }
                } else if (this.actor.frameLock) {
                    this.isCloakedOld = this.isCloaked;
                }
            } else if (this.actor._nAnimationId >= 8 && this.actor._nAnimationId != 16) {
                if (this.actor._nAnimationId != 8 + this.currentOrientation) {
                    if (this.isCloakedOld) {
                        this.actor.initActor(8 + this.currentOrientation, 0, 1);
                    } else {
                        this.actor.initActor(8 + this.currentOrientation, -1, -1);
                    }
                    this.isCloakedOld = !this.isCloaked;
                } else if (this.actor.frameLock) {
                    this.isCloakedOld = this.isCloaked;
                }
            }
            this.isCloaked = true;
        }
        if (this.state == 3) {
            this.waitTime -= n;
            if (this.waitTime < 0) {
                this.state = 0;
                this.attacking = false;
                this.pathSize = 0;
                this.pathStep = 0;
                this.morale = 100;
                if (this.framePassed > 0) {
                    this.speed *= 3;
                }
                if (this.safePointVisitNO == 0) {
                    this.health += this.maxHealth * 20 / 100;
                    if (this.health > this.maxHealth) {
                        this.health = this.maxHealth;
                    }
                }
                if (!this.pTeam.isWave) {
                    this.setDestination((short)this.pTeam.spawnX, (short)this.pTeam.spawnY);
                }
            } else {
                return;
            }
        }
        if (this.safePointVisitNO == 0 && !this.safePointVisited && (this.checkForMorale || checkAllForMorale) && this.type != 22) {
            this.morale = this.maxim_morale;
            int n2 = 100 - 100 * this.health / this.maxHealth;
            this.morale -= n2;
            this.morale -= Team.tanksPerAlliance[0] * 10;
            if (this.morale <= 25) {
                ++this.safePointVisitNO;
                this.moveToSafePoint();
                this.safePointVisited = true;
                GameImpl.writeDebugOutput("UNIT_STATE_WALK_TOTHE_SAFEPOINT 2");
                this.speed /= 3;
                this.framePassed = 20;
            }
            this.checkForMorale = false;
        }
        if (this.pathSize == 0) {
            if (this.waypointsPathId != -1) {
                this.walkPreloadedPath();
            } else if (this.pTeam.isWave && !this.attacking) {
                this.aquireTarget();
            }
        }
    }

    void upDate(long l, int n, boolean bl) {
        if (this.health <= 0) {
            this.pTeam.killUnit(this);
            return;
        }
        --this.framePassed;
        if (bl) {
            this.actor.update(n);
            if (this.turretActor != null) {
                this.turretActor.update(n);
            }
            if (this.alliance == 1) {
                this.updateNod(n);
            }
            if (this.pathSize != 0 || this.fanaticMode) {
                this.speedTime += n;
            }
            int n2 = 0;
            int n3 = 0;
            this.lastPosX = this.posX;
            this.lastPosY = this.posY;
            if (this.fanaticMode) {
                boolean bl2 = false;
                if (this.fanaticBuildingTarget == null) {
                    bl2 = true;
                } else if (this.fanaticBuildingTarget.health <= 0) {
                    this.fanaticMode = false;
                    this.attacking = false;
                    this.fanaticBuildingTarget = null;
                } else if (this.speedTime > this.speed) {
                    if (this.fanaticBuildingTarget.posX > this.posX) {
                        n2 = 1;
                    } else if (this.fanaticBuildingTarget.posX < this.posX) {
                        n2 = -1;
                    }
                    if (this.fanaticBuildingTarget.posY > this.posY) {
                        n3 = 1;
                    } else if (this.fanaticBuildingTarget.posY < this.posY) {
                        n3 = -1;
                    }
                    this.posX += n2;
                    this.posY += n3;
                    this.speedTime -= this.speed;
                    if (CGlobals.distance(this.fanaticBuildingTarget.posX - this.posX, this.fanaticBuildingTarget.posY - this.posY) < 22) {
                        bl2 = true;
                    }
                }
                if (bl2) {
                    GameConfig gameConfig;
                    int n4;
                    for (n4 = 0; n4 < GameImpl.noOfTeams[0]; ++n4) {
                        gameConfig = GameImpl.factions[0][n4];
                        for (int i = 0; i < ((Team)gameConfig).noOfUnits; ++i) {
                            Unit unit = ((Team)gameConfig).troops[i];
                            if (CGlobals.distance(unit.posX - this.posX, unit.posY - this.posY) > 32) continue;
                            unit.takeDamage(this.health);
                        }
                    }
                    for (n4 = 0; n4 < GameImpl.buildings.length; ++n4) {
                        gameConfig = GameImpl.buildings[n4];
                        if (gameConfig == null || CGlobals.distance(((Targetable)((Object)gameConfig)).posX - this.posX, ((Targetable)((Object)gameConfig)).posY - this.posY) > 32) continue;
                        ((Building)gameConfig).takeDamage(this.health);
                    }
                    this.takeDamage(this.health);
                }
            } else if (this.pathStep < this.pathSize - 1) {
                n2 = this.currentPathX[this.pathStep + 1] - this.currentPathX[this.pathStep];
                n3 = this.currentPathY[this.pathStep + 1] - this.currentPathY[this.pathStep];
                if (this.speedTime > this.speed) {
                    this.posX += n2;
                    this.posY += n3;
                    this.speedTime -= this.speed;
                }
                int n5 = this.currentPathX[this.pathStep + 1] * 16 + this.cellOffsetX;
                int n6 = this.currentPathY[this.pathStep + 1] * 16 + this.cellOffsetY;
                if (n2 > 0 && this.posX > n5) {
                    this.posX = n5;
                    ++this.pathStep;
                } else if (n2 < 0 && this.posX < n5) {
                    this.posX = n5;
                    ++this.pathStep;
                } else if (n3 < 0 && this.posY < n6) {
                    this.posY = n6;
                    ++this.pathStep;
                } else if (n3 > 0 && this.posY > n6) {
                    this.posY = n6;
                    ++this.pathStep;
                }
            } else if (this.pathSize != 0) {
                this.pathSize = 0;
                if (this.type == 22 && this.fanaticBuildingTarget != null) {
                    this.fanaticMode = true;
                    this.attacking = true;
                    this.state = 1;
                } else {
                    if (this.state == 2) {
                        this.waitTime = 3000;
                        this.state = 3;
                        this.currentOrientation = this.orientation;
                        if (this.actor._nAnimationId != this.currentOrientation) {
                            this.actor.initActor(this.currentOrientation, 0, 1);
                        }
                        return;
                    }
                    this.state = 0;
                }
            }
            this.attackClosestUnit(l);
            this.attackBuilding(l);
            block0 : switch (this.state) {
                case 1: 
                case 2: {
                    switch (this.type) {
                        case 13: 
                        case 15: 
                        case 16: 
                        case 23: 
                        case 24: 
                        case 25: {
                            if (this.type == 23 && this.actor._nAnimationId == 8 + this.currentOrientation && !this.actor.frameLock) break block0;
                            this.setOrientation(n2, n3);
                            if (this.actor._nAnimationId != 16) break block0;
                            this.currentOrientation = this.actor._nAnimationFrame >> 1;
                            if (this.currentOrientation != this.orientation) break block0;
                            this.actor.initActor(this.currentOrientation, 0, 1);
                            break block0;
                        }
                    }
                    if (!this.attacking) {
                        this.currentOrientation = this.orientation = CGlobals.getOrientation(n2, n3, this.orientation);
                    }
                    if (this.actor._nAnimationId == this.currentOrientation + 8) break;
                    this.actor.initActor(this.currentOrientation + 8, 0, 1);
                    break;
                }
                case 0: {
                    if (this.type == 23 && this.actor._nAnimationId == 8 + this.currentOrientation && !this.actor.frameLock) break;
                    if (this.actor._nAnimationId != 16) {
                        if (this.actor._nAnimationId == this.currentOrientation) break;
                        this.actor.initActor(this.currentOrientation, 0, 1);
                        break;
                    }
                    if (this.actor._nAnimationFrame >> 1 != this.currentOrientation) break;
                    this.actor.initActor(this.currentOrientation, 0, 1);
                }
            }
            if (this.pTeam.alliance == 0 && this.type == 12) {
                GameImpl.findInvisible(this.posX, this.posY, 6400);
            }
            this.attackCoolDown -= n;
            if (this.lastPosX != this.posX || this.lastPosY != this.posY) {
                this.hasPositionChanged = true;
            }
        }
    }

    void promoteUnit() {
        if (this.unitExperienceLevel < 2) {
            ++this.unitExperienceLevel;
            this.maxHealth += this.maxHealth * GameConfig.UNIT_EXPERIENCE_MODIFIERS[this.unitExperienceLevel][2] / 100;
            this.speed += this.speed * GameConfig.UNIT_EXPERIENCE_MODIFIERS[this.unitExperienceLevel][3] / 100;
            this.health = this.maxHealth;
        }
    }

    void setDestination(short s, short s2) {
        int n;
        int n2;
        int n3 = s + Team.teamUnitOffsets[this.offsetTarget][0];
        int n4 = s2 + Team.teamUnitOffsets[this.offsetTarget][1];
        if (View.isInBlockedCell(n3, n4)) {
            n3 = s + this.cellOffsetX;
            n4 = s2 + this.cellOffsetY;
            s = (short)n3;
            s2 = (short)n4;
            while (PathFinderFast.mGrid[s2 / 16][s / 16] > 1) {
                n2 = (this.posX - s) / 2;
                n = (this.posY - s2) / 2;
                if (n2 == 0 && n == 0) break;
                s = (short)(s + n2);
                s2 = (short)(s2 + n);
            }
            n3 = s;
            n4 = s2;
        }
        n2 = this.posX / 16;
        n = this.posY / 16;
        if (n3 / 16 == n2 && n4 / 16 == n) {
            s = (short)(s / 16);
            s2 = (short)(s2 / 16);
        } else {
            s = (short)(n3 / 16);
            s2 = (short)(n4 / 16);
        }
        if (PathFinderFast.mGrid[s2][s] > 1) {
            return;
        }
        int n5 = PathFinderFast.FindPath(n2, n, s, s2);
        if (n5 > 1) {
            if (this.currentPathX == null) {
                this.currentPathX = new byte[126];
            }
            if (this.currentPathY == null) {
                this.currentPathY = new byte[126];
            }
            this.pathSize = n5 - 1;
            this.pathStep = 0;
            for (int i = this.pathSize; i > 0; --i) {
                this.currentPathX[this.pathSize - i] = PathFinderFast.resultPathX[i];
                this.currentPathY[this.pathSize - i] = PathFinderFast.resultPathY[i];
            }
            this.state = 1;
        } else {
            if (this.pTeam.alliance == 1) {
                this.moveToSafePoint();
            }
            GameImpl.writeDebugOutput("Path is null! Why?");
        }
    }

    void attackClosestUnit(long l) {
        int n;
        Team[] teamArray;
        if (this.attackCoolDown > 0) {
            return;
        }
        if (this.type == 22) {
            return;
        }
        if (this.pTeam.alliance == 0) {
            teamArray = GameImpl.factions[1];
            n = GameImpl.noOfTeams[1];
        } else if (this.pTeam.alliance == 1) {
            teamArray = GameImpl.factions[0];
            n = GameImpl.noOfTeams[0];
        } else {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Unit[] unitArray = teamArray[i].troops;
            int n2 = teamArray[i].noOfUnits;
            for (int j = 0; j < n2; ++j) {
                int n3;
                int n4;
                int n5;
                if (unitArray[j].isCloakedOld || (n5 = (n4 = unitArray[j].posX - this.posX) * n4 + (n3 = unitArray[j].posY - this.posY) * n3) > this.sqr_range) continue;
                switch (this.type) {
                    case 15: 
                    case 16: 
                    case 24: {
                        this.turretOrientation = CGlobals.getOrientation(n4, n3, this.turretOrientation);
                        if (this.turretActor._nAnimationId == this.turretOrientation) break;
                        this.turretActor.initActor(this.turretOrientation, 0, 1);
                        break;
                    }
                    case 13: 
                    case 23: 
                    case 25: {
                        break;
                    }
                    default: {
                        this.currentOrientation = this.orientation = CGlobals.getOrientation(n4, n3, this.orientation);
                    }
                }
                int n6 = 0;
                if (this.type == 11) {
                    this.attackCoolDown = 1500;
                    n6 = 2;
                } else if (this.type == 21) {
                    this.attackCoolDown = 2000;
                    n6 = 3;
                } else {
                    this.attackCoolDown = 500;
                    n6 = 1;
                }
                this.attackCoolDown -= this.attackCoolDown * GameConfig.UNIT_EXPERIENCE_MODIFIERS[this.unitExperienceLevel][0] / 100;
                int n7 = GameConfig.UNIT_EXPERIENCE_MODIFIERS[this.unitExperienceLevel][1];
                Projectile.attemptToCreateProjectile(n6, this.damage - unitArray[j].armour, l, this, unitArray[j], n7);
                if (this.pTeam.alliance == 0 && this.unitExperienceLevel < 2) {
                    ++this.firedShots;
                    if (this.firedShots > GameConfig.UNIT_EXPERIENCE_THRESHOLD[this.unitExperienceLevel + 1]) {
                        this.promoteUnit();
                    }
                } else if (this.pTeam.alliance == 1) {
                    ++this.shotsFired;
                    if ((this.type == 25 || this.type == 23) && this.shotsFired > 5) {
                        this.safePointVisited = false;
                        this.moveToSafePoint();
                        this.shotsFired = 0;
                    }
                }
                this.attacking = true;
                return;
            }
        }
        this.attacking = false;
    }

    private boolean goodTarget(Building building, long l) {
        int n = building.posX - this.posX;
        int n2 = building.posY - this.posY;
        int n3 = n * n + n2 * n2;
        if (n3 <= this.sqr_range) {
            switch (this.type) {
                case 15: 
                case 16: 
                case 24: {
                    this.turretOrientation = CGlobals.getOrientation(n, n2, this.turretOrientation);
                    if (this.turretActor._nAnimationId == this.turretOrientation) break;
                    this.turretActor.initActor(this.turretOrientation, 0, 1);
                    break;
                }
                case 13: 
                case 23: 
                case 25: {
                    break;
                }
                default: {
                    this.currentOrientation = this.orientation = CGlobals.getOrientation(n, n2, this.orientation);
                }
            }
            int n4 = 0;
            switch (this.type) {
                case 11: 
                case 25: {
                    this.attackCoolDown = 1500;
                    n4 = 2;
                    break;
                }
                case 15: 
                case 16: 
                case 21: 
                case 23: {
                    this.attackCoolDown = 2000;
                    n4 = 3;
                    break;
                }
                default: {
                    this.attackCoolDown = 500;
                    n4 = 1;
                }
            }
            this.attackCoolDown -= this.attackCoolDown * GameConfig.UNIT_EXPERIENCE_MODIFIERS[this.unitExperienceLevel][0] / 100;
            int n5 = GameConfig.UNIT_EXPERIENCE_MODIFIERS[this.unitExperienceLevel][1];
            Projectile.attemptToCreateProjectile(n4, this.damage, l, this, building, n5);
            if (this.pTeam.alliance == 0 && this.unitExperienceLevel < 2) {
                ++this.firedShots;
                if (this.firedShots > GameConfig.UNIT_EXPERIENCE_THRESHOLD[this.unitExperienceLevel + 1]) {
                    this.promoteUnit();
                }
            } else if (this.pTeam.alliance == 1) {
                ++this.shotsFired;
                if ((this.type == 25 || this.type == 23) && this.shotsFired > 5) {
                    this.safePointVisited = false;
                    this.moveToSafePoint();
                    this.shotsFired = 0;
                }
            }
            this.attacking = true;
            return true;
        }
        return false;
    }

    void attackBuilding(long l) {
        if (this.attackCoolDown > 0 || this.pTeam.alliance == 0 || this.type == 22) {
            return;
        }
        Building[] buildingArray = GameImpl.buildings;
        for (int i = 0; i < buildingArray.length; ++i) {
            if (buildingArray[i].type < 0 || !this.goodTarget(buildingArray[i], l)) continue;
            return;
        }
        this.attacking = false;
    }

    public void takeDamage(int n) {
        if (this.pTeam == null) {
            return;
        }
        if (n <= 0) {
            n = 1;
        }
        this.health -= n;
        if (this.health < 0) {
            this.health = 0;
        }
        this.checkForMorale = true;
    }

    public int getCursorType() {
        if (this.alliance == 0) {
            return 0;
        }
        return 1;
    }

    public void moveToSafePoint() {
        int n = GameImpl.currentView.level.getRandomSafePoint();
        if (n == -1) {
            return;
        }
        this.setDestination(GameImpl.currentView.level.directionalHotspots[n][0], GameImpl.currentView.level.directionalHotspots[n][1]);
        GameImpl.writeDebugOutput("id " + n);
        this.state = 2;
        GameImpl.writeDebugOutput("UNIT_STATE_WALK_TOTHE_SAFEPOINT 2");
    }

    public int getTargetPointX() {
        return this.posX + this.anime.getHotSpot(this.actor._nAnimationId, this.actor._nAnimationFrame, 0, 0);
    }

    public int getTargetPointY() {
        return this.posY + this.anime.getHotSpot(this.actor._nAnimationId, this.actor._nAnimationFrame, 0, 1);
    }

    public int getBulletPositionX() {
        if (this.turretAnime != null) {
            return this.posX + this.turretAnime.getHotSpot(this.turretActor._nAnimationId, this.turretActor._nAnimationFrame, 0, 0);
        }
        return this.posX + this.anime.getHotSpot(this.actor._nAnimationId, this.actor._nAnimationFrame, 1, 0);
    }

    public int getBulletPositionY() {
        if (this.turretAnime != null) {
            return this.posY + this.turretAnime.getHotSpot(this.turretActor._nAnimationId, this.turretActor._nAnimationFrame, 0, 1);
        }
        return this.posY + this.anime.getHotSpot(this.actor._nAnimationId, this.actor._nAnimationFrame, 1, 1);
    }

    public void walkPreloadedPath() {
        ++this.currentWaypoint;
        if (this.currentWaypoint > GameImpl.currentView.level.pathsNoOfWayPoints[this.waypointsPathId]) {
            this.pTeam.isWave = true;
            this.waypointsPathId = -1;
            this.currentWaypoint = -1;
            return;
        }
        if (this.currentWaypoint == GameImpl.currentView.level.pathsNoOfWayPoints[this.waypointsPathId]) {
            if (this.loopPath) {
                this.currentWaypoint = 0;
            } else {
                this.pTeam.isWave = true;
                this.waypointsPathId = -1;
                this.currentWaypoint = -1;
                return;
            }
        }
        this.setDestination(GameImpl.currentView.level.pathsXCoord[this.waypointsPathId][this.currentWaypoint], GameImpl.currentView.level.pathsYCoord[this.waypointsPathId][this.currentWaypoint]);
    }

    public void initWalkPresetPath(int n, boolean bl) {
        this.waypointsPathId = n;
        this.currentWaypoint = -1;
        this.loopPath = bl;
        this.pTeam.isWave = false;
        this.pathSize = 0;
    }

    void dispose() {
    }
}

