/*
 * Decompiled with CFR 0.152.
 */
package com.ea.cnc;

public class Menu {
    int title_id;
    int[] option_id;
    int menuLayOut = 0;
    public static final int MAX_MENU_ITEMS = 9;
    static final int NO_TITLE = -100;
    static final byte OPTION_TYPE_SELECT = 1;
    static final byte OPTION_TYPE_LEFT_RIGHT = 2;
    static final byte OPTION_DISABLED = 8;
    public static final byte LAYOUT_CENTERED = 0;
    public static final byte LAYOUT_LEFT_RIGHT = 1;
    byte[] option_type;
    byte[] layout_value;
    int[] option_value;
    int index = 0;
    int selected_item;

    public Menu(int n) {
        this.title_id = n;
        this.selected_item = 0;
        this.option_id = new int[9];
        this.option_type = new byte[9];
        this.option_value = new int[9];
        this.layout_value = new byte[9];
        this.index = 0;
    }

    public void setlayout(byte by) {
        this.layout_value[this.index - 1] = by;
    }

    public void addOption(int n) {
        this.option_id[this.index] = n;
        this.option_type[this.index] = 1;
        ++this.index;
    }

    public int getOption(int n) {
        return this.option_id[n];
    }

    public void setOptionWithValue(int n, byte by, byte by2, byte by3) {
        this.option_id[this.index] = n;
        this.option_type[this.index] = 2;
        this.option_value[this.index] = (by & 0xFF) << 16 | (by2 & 0xFF) << 8 | by3 & 0xFF;
        ++this.index;
    }

    public void setValue(int n, int n2) {
        for (int i = 0; i < this.index; ++i) {
            if (this.option_id[i] != n) continue;
            this.option_value[i] = this.option_value[i] & 0xFFFFFF00 | n2 & 0xFF;
        }
    }

    public void enableOption(int n) {
        int n2 = n;
        this.option_type[n2] = (byte)(this.option_type[n2] & 0xFFFFFFF7);
    }

    public void disableOption(int n) {
        int n2 = n;
        this.option_type[n2] = (byte)(this.option_type[n2] | 8);
    }

    public void moveLeft() {
        if ((this.option_type[this.selected_item] & 2) != 0) {
            int n = this.option_value[this.selected_item] & 0xFF;
            int n2 = (this.option_value[this.selected_item] & 0xFF0000) >> 16;
            int n3 = (this.option_value[this.selected_item] & 0xFF00) >> 8;
            n = n > n2 ? --n : n3;
            this.option_value[this.selected_item] = (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | n & 0xFF;
        }
    }

    public void moveRight() {
        if ((this.option_type[this.selected_item] & 2) != 0) {
            int n = this.option_value[this.selected_item] & 0xFF;
            int n2 = (this.option_value[this.selected_item] & 0xFF0000) >> 16;
            int n3 = (this.option_value[this.selected_item] & 0xFF00) >> 8;
            n = n < n3 ? ++n : n2;
            this.option_value[this.selected_item] = (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | n & 0xFF;
        }
    }

    public void moveUp() {
        --this.selected_item;
        if (this.selected_item < 0) {
            this.selected_item = this.index - 1;
        }
        while ((this.option_type[this.selected_item] & 8) != 0) {
            --this.selected_item;
            if (this.selected_item >= 0) continue;
            this.selected_item = this.index - 1;
        }
    }

    public void moveDown() {
        ++this.selected_item;
        if (this.selected_item > this.index - 1) {
            this.selected_item = 0;
        }
        while ((this.option_type[this.selected_item] & 8) != 0) {
            ++this.selected_item;
            if (this.selected_item <= this.index - 1) continue;
            this.selected_item = 0;
        }
    }

    public boolean canScrollUp(int n, int n2) {
        for (int i = n - 1; i >= 0; --i) {
            if ((this.option_type[i] & 8) != 0) continue;
            return true;
        }
        return false;
    }

    public boolean canScrollDown(int n, int n2) {
        int n3 = 0;
        for (int i = n; i < this.index; ++i) {
            if ((this.option_type[i] & 8) != 0) continue;
            ++n3;
        }
        return n3 > n2;
    }
}

