/*
 * Decompiled with CFR 0.152.
 */
package com.ea.cnc;

import com.ea.cnc.GameConfig;
import com.ea.cnc.GameImpl;
import com.ea.cnc.LevelObject;
import com.ea.cnc.PathFinderFast;
import com.ea.cnc.View;
import com.ea.sdk.SDKInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Image;

public class CLevel
implements GameConfig {
    public static int NoOfModules = 0;
    public static short[] modulesX;
    public static short[] modulesY;
    public static short[] modulesW;
    public static short[] modulesH;
    public int NoOfLevelModules = 0;
    public short[] levelModuleId;
    public short[] levelModuleOffsetX;
    public short[] levelModuleOffsetY;
    public byte[] levelModulesFlag;
    public short LEVEL_WIDTH;
    public short LEVEL_HEIGHT;
    public byte[][] levelModuleIdGrid;
    public byte[][] levelModuleFlagGrid;
    public static final byte TILE_SIZE = 24;
    public int noOfHotspots;
    public short[][] directionalHotspots;
    public static final int MAX_SAFE_POINT = 7;
    public byte[] safePointsId;
    public int noSafePoints = 0;
    public int noOfPaths;
    public byte[] pathsNoOfWayPoints;
    public short[][] pathsXCoord;
    public short[][] pathsYCoord;
    public LevelObject[] objects;
    public short noObjects;
    public short noExtraObjects;
    public static Image[] image;
    public int currentPallete = 0;
    public static boolean modulesLoaded;
    int id_col;

    public static void loadModules(int n) {
        try {
            int n2;
            SDKInputStream sDKInputStream = new SDKInputStream(n);
            NoOfModules = sDKInputStream.readUnsignedByte();
            GameImpl.writeDebugOutput("number of modules :" + NoOfModules);
            modulesX = new short[NoOfModules];
            modulesY = new short[NoOfModules];
            for (n2 = 0; n2 < NoOfModules; ++n2) {
                CLevel.modulesX[n2] = sDKInputStream.readShort();
                CLevel.modulesY[n2] = sDKInputStream.readShort();
            }
            modulesW = new short[NoOfModules];
            modulesH = new short[NoOfModules];
            for (n2 = 0; n2 < NoOfModules; ++n2) {
                CLevel.modulesW[n2] = sDKInputStream.readUnsignedByte();
            }
            for (n2 = 0; n2 < NoOfModules; ++n2) {
                CLevel.modulesH[n2] = sDKInputStream.readUnsignedByte();
            }
            sDKInputStream.close();
            modulesLoaded = true;
        }
        catch (Exception exception) {
            GameImpl.writeDebugOutput("!!! ERROR LOADING MODULES");
        }
    }

    void setColisions() {
        try {
            int n;
            int n2;
            int n3;
            byte[][] byArray = PathFinderFast.mGrid;
            for (n3 = 0; n3 < View.MAP_HEIGHT; ++n3) {
                for (n2 = 0; n2 < View.MAP_WIDTH; ++n2) {
                    byArray[n3][n2] = 1;
                }
            }
            SDKInputStream sDKInputStream = new SDKInputStream(this.id_col);
            int n4 = sDKInputStream.readShort();
            for (n = 0; n < n4; ++n) {
                n3 = sDKInputStream.readShort();
                n2 = sDKInputStream.readShort();
                short s = sDKInputStream.readShort();
                short s2 = sDKInputStream.readShort();
                byte by = sDKInputStream.readByte();
                if (by != 110 && by != 2) {
                    by = 100;
                }
                CLevel.intersect(n3, n2, s, s2, by, byArray, true);
            }
            sDKInputStream.close();
            for (n = 0; n < this.noObjects + this.noExtraObjects; ++n) {
                this.objects[n].setCollision((byte)90);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CLevel(int n, int n2, int n3) {
        GameImpl.confirmed_buildings = 1;
        GameImpl.blocked_buildings = 0;
        GameImpl.available_buildings = 0;
        try {
            int n4;
            int n5;
            int n6;
            SDKInputStream sDKInputStream = new SDKInputStream(n);
            this.LEVEL_WIDTH = sDKInputStream.readShort();
            this.LEVEL_HEIGHT = sDKInputStream.readShort();
            this.NoOfLevelModules = sDKInputStream.readShort();
            this.levelModuleId = new short[this.NoOfLevelModules];
            this.levelModuleOffsetX = new short[this.NoOfLevelModules];
            this.levelModuleOffsetY = new short[this.NoOfLevelModules];
            this.levelModulesFlag = new byte[this.NoOfLevelModules];
            for (n6 = 0; n6 < this.NoOfLevelModules; ++n6) {
                this.levelModuleId[n6] = sDKInputStream.readUnsignedByte();
                this.levelModuleOffsetX[n6] = sDKInputStream.readShort();
                this.levelModuleOffsetY[n6] = sDKInputStream.readShort();
                this.levelModulesFlag[n6] = sDKInputStream.readByte();
            }
            sDKInputStream.close();
            View.MAP_WIDTH = (byte)CLevel.GetPowerOf2Ceiling(this.LEVEL_WIDTH / 16);
            View.MAP_HEIGHT = (byte)CLevel.GetPowerOf2Ceiling(this.LEVEL_HEIGHT / 16);
            GameImpl.writeDebugOutput("matrixWidth: " + View.MAP_WIDTH);
            GameImpl.writeDebugOutput("matrixHeight: " + View.MAP_HEIGHT);
            this.id_col = n2;
            sDKInputStream = new SDKInputStream(n3);
            this.noOfHotspots = sDKInputStream.readShort();
            this.directionalHotspots = new short[this.noOfHotspots][2];
            GameImpl.writeDebugOutput("noOfHotspots " + this.noOfHotspots);
            for (n6 = 0; n6 < this.noOfHotspots; ++n6) {
                this.directionalHotspots[n6][0] = sDKInputStream.readShort();
                this.directionalHotspots[n6][1] = sDKInputStream.readShort();
                GameImpl.writeDebugOutput("x  " + this.directionalHotspots[n6][0] + " y: " + this.directionalHotspots[n6][1]);
            }
            n6 = sDKInputStream.readShort();
            sDKInputStream.skip(n6 * 13);
            this.noObjects = sDKInputStream.readShort();
            sDKInputStream.readShort();
            this.noExtraObjects = 0;
            GameImpl.writeDebugOutput("NoOfObjects: " + this.noObjects);
            this.objects = new LevelObject[this.noObjects + 25];
            for (int i = 0; i < this.noObjects; ++i) {
                n5 = sDKInputStream.readByte();
                n4 = sDKInputStream.readShort();
                short s = sDKInputStream.readShort();
                byte by = sDKInputStream.readByte();
                GameImpl.writeDebugOutput("ObjectAnimId: " + n5 + "\n" + "ObjectPosX: " + n4 + "\n" + "ObjectPosY: " + s + "\n" + "ObjectFlags: " + by + "\n");
                this.objects[i] = new LevelObject((byte)n5, (short)n4, s, by, -1, 2);
            }
            this.noOfPaths = sDKInputStream.read();
            this.pathsNoOfWayPoints = new byte[this.noOfPaths];
            this.pathsXCoord = new short[this.noOfPaths][];
            this.pathsYCoord = new short[this.noOfPaths][];
            for (n5 = 0; n5 < this.noOfPaths; ++n5) {
                this.pathsNoOfWayPoints[n5] = sDKInputStream.readByte();
                this.pathsXCoord[n5] = new short[this.pathsNoOfWayPoints[n5]];
                for (n4 = 0; n4 < this.pathsNoOfWayPoints[n5]; ++n4) {
                    this.pathsXCoord[n5][n4] = sDKInputStream.readShort();
                }
                this.pathsYCoord[n5] = new short[this.pathsNoOfWayPoints[n5]];
                for (n4 = 0; n4 < this.pathsNoOfWayPoints[n5]; ++n4) {
                    this.pathsYCoord[n5][n4] = sDKInputStream.readShort();
                }
            }
            sDKInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.noSafePoints = 0;
        this.safePointsId = new byte[7];
    }

    public void addSafePoint(int n) {
        if (this.noSafePoints == 7) {
            return;
        }
        this.safePointsId[this.noSafePoints] = (byte)n;
        ++this.noSafePoints;
    }

    public int getNearestSafePoint(int n, int n2) {
        int n3 = 0xFFFFFFF;
        int n4 = -1;
        if (this.noSafePoints == 1) {
            return this.safePointsId[0];
        }
        GameImpl.writeDebugOutput("noSafePoints " + this.noSafePoints);
        for (int i = 0; i < this.noSafePoints; ++i) {
            GameImpl.writeDebugOutput("safePointsId[i] " + this.safePointsId[i]);
            int n5 = (n - this.directionalHotspots[this.safePointsId[i]][0]) * (n - this.directionalHotspots[this.safePointsId[i]][0]) + (n2 - this.directionalHotspots[this.safePointsId[i]][1]) * (n2 - this.directionalHotspots[this.safePointsId[i]][1]);
            if (n5 >= n3) continue;
            n3 = n5;
            n4 = this.safePointsId[i];
        }
        return n4;
    }

    public int getRandomSafePoint() {
        if (this.noSafePoints == 0) {
            return -1;
        }
        int n = Math.abs(GameImpl.randGenerator.nextInt());
        GameImpl.writeDebugOutput("id " + (n %= this.noSafePoints));
        GameImpl.writeDebugOutput("safePointsId[tmp] " + this.safePointsId[n]);
        GameImpl.writeDebugOutput("no " + this.noSafePoints);
        return this.safePointsId[n];
    }

    public static final int GetPowerOf2Ceiling(int n) {
        int n2;
        for (n2 = 1; n > n2; n2 <<= 1) {
        }
        return n2;
    }

    public static boolean intersect(int n, int n2, int n3, int n4, byte by, byte[][] byArray, boolean bl) {
        int n5;
        int n6;
        if (n == n3 && n > 0 && n < View.MAP_WIDTH * 16) {
            int n7;
            if (n2 > n4) {
                n7 = n2;
                n2 = n4;
                n4 = n7;
            }
            for (n7 = n2; n7 <= n4; ++n7) {
                if (n7 < 0 || n7 >= View.MAP_HEIGHT * 16) continue;
                if (bl) {
                    byArray[n7 / 16][n / 16] = by;
                    continue;
                }
                if (byArray[n7 / 16][n / 16] <= 80) continue;
                return true;
            }
            return false;
        }
        if (n2 == n4 && n2 > 0 && n2 < View.MAP_HEIGHT * 16) {
            int n8;
            if (n > n3) {
                n8 = n;
                n = n3;
                n3 = n8;
            }
            for (n8 = n; n8 <= n3; ++n8) {
                if (n8 < 0 || n8 >= View.MAP_WIDTH * 16) continue;
                if (bl) {
                    byArray[n2 / 16][n8 / 16] = by;
                    continue;
                }
                if (byArray[n2 / 16][n8 / 16] <= 80) continue;
                return true;
            }
            return false;
        }
        int n9 = 0;
        if (n > n3) {
            n9 |= 1;
        }
        if (n2 > n4) {
            n9 |= 2;
        }
        int n10 = n > n3 ? n - n3 : n3 - n;
        int n11 = n6 = n2 > n4 ? n2 - n4 : n4 - n2;
        if (n6 > n10) {
            n9 |= 4;
        }
        switch (n9) {
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                n5 = n;
                n = n3;
                n3 = n5;
                n5 = n2;
                n2 = n4;
                n4 = n5;
            }
        }
        switch (n9) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                n5 = -1;
                break;
            }
            default: {
                n5 = 1;
            }
        }
        int n12 = n10 << 1;
        int n13 = n6 << 1;
        if (n9 < 4) {
            int n14 = n - n3;
            int n15 = n2;
            for (int i = n; i <= n3; ++i) {
                if (i >= 0 && i < View.MAP_WIDTH * 16 && n15 >= 0 && n15 < View.MAP_HEIGHT * 16) {
                    if (bl) {
                        byArray[n15 / 16][i / 16] = by;
                    } else if (byArray[n15 / 16][i / 16] > 80) {
                        return true;
                    }
                }
                if ((n14 += n13) <= 0) continue;
                if (i >= 0 && i < View.MAP_WIDTH * 16 && (n15 += n5) >= 0 && n15 < View.MAP_HEIGHT * 16) {
                    if (bl) {
                        byArray[n15 / 16][i / 16] = by;
                    } else if (byArray[n15 / 16][i / 16] > 80) {
                        return true;
                    }
                }
                n14 -= n12;
            }
        } else {
            int n16 = n2 - n4;
            int n17 = n;
            for (int i = n2; i <= n4; ++i) {
                if (n17 >= 0 && n17 < View.MAP_WIDTH * 16 && i >= 0 && i < View.MAP_HEIGHT * 16) {
                    if (bl) {
                        byArray[i / 16][n17 / 16] = by;
                    } else if (byArray[i / 16][n17 / 16] > 80) {
                        return true;
                    }
                }
                if ((n16 += n12) <= 0) continue;
                if ((n17 += n5) >= 0 && n17 < View.MAP_WIDTH * 16 && i >= 0 && i < View.MAP_HEIGHT * 16) {
                    if (bl) {
                        byArray[i / 16][n17 / 16] = by;
                    } else if (byArray[i / 16][n17 / 16] > 80) {
                        return true;
                    }
                }
                n16 -= n13;
            }
        }
        return false;
    }

    public void updateObjects(int n) {
        for (int i = 0; i < this.noObjects + this.noExtraObjects; ++i) {
            this.objects[i].update(n);
            if (this.objects[i] == null || !this.objects[i].isForeground || !this.objects[i].isInScreen()) continue;
            short s = this.objects[i].boundingBoxX;
            short s2 = this.objects[i].boundingBoxY;
            short s3 = this.objects[i].boundingBoxW;
            short s4 = this.objects[i].boundingBoxH;
            for (int j = 0; j < 3 && !this.objects[i].invalidated; ++j) {
                block2: for (int k = 0; k < GameImpl.noOfTeams[j] && !this.objects[i].invalidated; ++k) {
                    for (int i2 = 0; i2 < GameImpl.factions[j][k].noOfUnits; ++i2) {
                        if (!GameImpl.factions[j][k].troops[i2].isInScreen()) continue;
                        int n2 = GameImpl.factions[j][k].troops[i2].posX;
                        int n3 = GameImpl.factions[j][k].troops[i2].posY;
                        if (n2 < s - 20 || n2 >= s + s3 + 20 || n3 < s2 - 20 || n3 >= s2 + s4 + 20) continue;
                        this.objects[i].invalidated = true;
                        continue block2;
                    }
                }
            }
        }
    }

    public void addExtraObject(LevelObject levelObject) {
        if (this.noExtraObjects >= 25) {
            return;
        }
        this.objects[this.noObjects + this.noExtraObjects] = levelObject;
        this.noExtraObjects = (short)(this.noExtraObjects + 1);
        GameImpl.currentView.scroller.addRegion(levelObject.boundingBoxX, levelObject.boundingBoxY, levelObject.boundingBoxW, levelObject.boundingBoxH);
    }

    public void addAllForegroundObjects() {
        for (int i = 0; i < this.noObjects; ++i) {
            if (!this.objects[i].isForeground) continue;
            GameImpl.addForegroundObject(this.objects[i]);
        }
    }

    public void removeObject(LevelObject levelObject) {
        int n;
        if (this.noExtraObjects <= 0) {
            return;
        }
        for (n = this.noObjects; n < this.noObjects + this.noExtraObjects && this.objects[n] != levelObject; ++n) {
        }
        while (n < this.noObjects + this.noExtraObjects - 1) {
            this.objects[n] = this.objects[n + 1];
            ++n;
        }
        this.objects[n] = null;
        this.noExtraObjects = (short)(this.noExtraObjects - 1);
        if (levelObject.isForeground) {
            GameImpl.removeForegroundObject(levelObject);
        }
        GameImpl.currentView.scroller.addRegion(levelObject.boundingBoxX, levelObject.boundingBoxY, levelObject.boundingBoxW, levelObject.boundingBoxH);
    }

    static {
        image = new Image[3];
        modulesLoaded = false;
    }
}

