/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game;

import com.ximad.pvn.engine.Application;
import com.ximad.pvn.game.Camera;
import com.ximad.pvn.game.GameParameters;
import com.ximad.pvn.game.Launcher;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.game.Textures;
import com.ximad.pvn.game.WaitingPanda;
import com.ximad.pvn.game.ninjas.Ninja;
import com.ximad.pvn.game.obstacles.GameLandscape;
import com.ximad.pvn.game.obstacles.Obstacle;
import com.ximad.pvn.game.obstacles.ObstacleTypes;
import com.ximad.pvn.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLLevel {
    private static int OFFSET_Y;
    private static XMLLevel parser;
    private int currentScenario = 0;
    private int currentLevel = 0;

    private XMLLevel() {
        OFFSET_Y = 20;
    }

    public static void loadLevel(int scenario, int level) {
        if (parser == null) {
            parser = new XMLLevel();
        }
        XMLLevel.parser.currentScenario = scenario;
        XMLLevel.parser.currentLevel = level;
        parser.parseLevel(scenario, level);
        GameParameters.indexCurrentScenario = scenario - 1;
        GameParameters.currentLevelInt = level - 1;
        GameParameters.currentLevelStr = "" + level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseLevel(int scenario, int level) {
        InputStream is = this.getClass().getResourceAsStream("/xml/scenario" + scenario + "_level" + level + ".xml");
        if (is == null) {
            Utils.print("/xml/scenario" + scenario + "_level" + level + ".xml ----  not found!!");
            return;
        }
        LevelHandler lh = new LevelHandler();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(is, (DefaultHandler)lh);
        }
        catch (ParserConfigurationException e) {
            Utils.log("!!! parse error1");
        }
        catch (SAXException e) {
            Utils.log("!!! parse error2");
        }
        catch (IOException e) {
            Utils.log("!!! parse error3");
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    Utils.log("!!! parse error4");
                }
            }
        }
    }

    class LevelHandler
    extends DefaultHandler {
        private boolean startDocument = false;
        private boolean endDocument = false;
        private final int PANDA;
        private final int NINJA;
        private final int LANDSCAPE;
        private final int OBSTACLE;
        private String sFar;
        private String sMiddle;
        private String sFront;
        private String sGold;
        private String sSilver;
        private String sBronze;
        private String sWind;
        private String sTypeObject;
        private String sImageName;
        private String sTypeMaterial;
        private String sRadius;
        private String sAngle;
        private String sIsStatic;
        private String sWidth;
        private String sHeight;
        private int angle;
        private int radius;
        private int ninja;
        private int obstacle;
        private int width;
        private int height;
        boolean isStatic;
        private String[] shape;
        private String points;
        private String sCenter;

        LevelHandler() {
            this.PANDA = 0;
            this.NINJA = 1;
            this.LANDSCAPE = 2;
            this.OBSTACLE = 3;
        }

        public void startDocument() {
            this.startDocument = true;
            Utils.print("-< start parse >- scenario = " + XMLLevel.this.currentScenario + " / level = " + XMLLevel.this.currentLevel);
        }

        public void endDocument() {
            this.endDocument = true;
            Utils.print("-< end parse >- scenario = " + XMLLevel.this.currentScenario + " / level = " + XMLLevel.this.currentLevel);
        }

        public void startElement(String uri, String name, String qName, Attributes atts) {
            if (!this.startDocument) {
                return;
            }
            name = qName;
            try {
                if (name.equals("Level")) {
                    this.sWidth = atts.getValue("width");
                    this.width = this.sWidth == null ? Application.screenWidth : Integer.parseInt(this.sWidth);
                    this.sHeight = atts.getValue("height");
                    this.height = this.sHeight == null ? Application.screenHeight : Integer.parseInt(this.sHeight);
                    this.sGold = atts.getValue("gold");
                    if (this.sGold == null) {
                        this.sGold = "0";
                    }
                    MyWorld.gold = Integer.parseInt(this.sGold);
                    this.sSilver = atts.getValue("silver");
                    if (this.sSilver == null) {
                        this.sSilver = "0";
                    }
                    MyWorld.silver = Integer.parseInt(this.sSilver);
                    this.sBronze = atts.getValue("bronze");
                    if (this.sBronze == null) {
                        this.sBronze = "0";
                    }
                    MyWorld.bronze = Integer.parseInt(this.sBronze);
                    this.sWind = atts.getValue("wind");
                    MyWorld.wind = this.sWind.equals("true");
                    this.sCenter = atts.getValue("center");
                    if (this.sCenter == null) {
                        this.sCenter = "700";
                    }
                    MyWorld.center = Integer.parseInt(this.sCenter);
                    Camera.level_size = MyWorld.center + Application.screenWidth / 2;
                    if (XMLLevel.this.currentScenario == 6) {
                        OFFSET_Y = Application.screenHeight - this.height - 20;
                    } else {
                        OFFSET_Y = 20;
                    }
                    this.sFar = atts.getValue("layerfar");
                    if (this.sFar != null) {
                        if (this.sFar.equals("layerfar1")) {
                            MyWorld.background.setBackBackground(Textures.layerfar1);
                        } else if (this.sFar.equals("layerfar2")) {
                            MyWorld.background.setBackBackground(Textures.layerfar2);
                        } else if (this.sFar.equals("layerfar3")) {
                            MyWorld.background.setBackBackground(Textures.layerfar3);
                        } else if (this.sFar.equals("layerfar4")) {
                            MyWorld.background.setBackBackground(Textures.layerfar4);
                        } else if (this.sFar.equals("layerfar5")) {
                            MyWorld.background.setBackBackground(Textures.layerfar5);
                        } else if (this.sFar.equals("layerfar6")) {
                            MyWorld.background.setBackBackground(Textures.layerfar6);
                        }
                    }
                    this.sFront = atts.getValue("layerfront");
                    if (this.sFront != null) {
                        if (this.sFront.equals("layerfront1")) {
                            MyWorld.background.setFrontBackground(1);
                        } else if (this.sFront.equals("layerfront2")) {
                            MyWorld.background.setFrontBackground(2);
                        } else if (this.sFront.equals("layerfront3")) {
                            MyWorld.background.setFrontBackground(3);
                        } else if (this.sFront.equals("layerfront4")) {
                            MyWorld.background.setFrontBackground(4);
                        } else if (this.sFront.equals("layerfront5")) {
                            MyWorld.background.setFrontBackground(5);
                        } else if (this.sFront.equals("layerfront6")) {
                            MyWorld.background.setFrontBackground(6);
                        }
                    }
                    Utils.print("-< parse >- parse background and scores");
                }
                if (name.equals("Object")) {
                    this.sTypeObject = atts.getValue("TypeDinamicalObjects");
                    this.sTypeMaterial = atts.getValue("Typematerial");
                    if (this.sTypeMaterial == null) {
                        this.sTypeMaterial = "";
                    }
                    this.sImageName = atts.getValue("Image");
                    if (this.sImageName == null) {
                        this.sImageName = this.sTypeMaterial;
                    }
                    this.sRadius = atts.getValue("Radius");
                    if (this.sRadius == null) {
                        this.sRadius = "";
                    }
                    this.sAngle = atts.getValue("Angle");
                    if (this.sAngle == null) {
                        this.sAngle = "0";
                    }
                    this.angle = Utils.round(Float.parseFloat(this.sAngle) * 180.0f / 3.1415925f);
                    this.sIsStatic = atts.getValue("IsStatic");
                    if (this.sIsStatic == null) {
                        this.sIsStatic = "false";
                    }
                    this.isStatic = this.sIsStatic.equalsIgnoreCase("true");
                    Utils.print("-< object parse >- type = " + this.sTypeObject);
                }
                if (name.equals("Shape")) {
                    this.shape = null;
                    this.points = atts.getValue("points");
                    this.shape = Utils.split(this.points, ',');
                    if (this.sTypeObject.equals("LAUNCHER")) {
                        Launcher.createNewLauncher(this.sImageName, (int)Float.parseFloat(this.shape[0]), (int)(Float.parseFloat(this.shape[1]) + (float)OFFSET_Y));
                        Utils.print("-< parse >- create main panda");
                    }
                    if (this.sTypeObject.equals("LANDSCAPE")) {
                        GameLandscape.createLandscape((int)Float.parseFloat(this.shape[0]), (int)(Float.parseFloat(this.shape[1]) + (float)OFFSET_Y), (int)Float.parseFloat(this.shape[2]), (int)(Float.parseFloat(this.shape[3]) + (float)OFFSET_Y), (int)Float.parseFloat(this.shape[4]), (int)(Float.parseFloat(this.shape[5]) + (float)OFFSET_Y), (int)Float.parseFloat(this.shape[6]), (int)(Float.parseFloat(this.shape[7]) + (float)OFFSET_Y), this.angle);
                        Utils.print("-< parse >- create landscape");
                    }
                    if (this.sTypeObject.equals("PANDA")) {
                        if (this.sTypeMaterial.toUpperCase().equals("PANDANORMAL")) {
                            WaitingPanda.createWaitingPanda(3141);
                        } else if (this.sTypeMaterial.toUpperCase().equals("PANDAACCELERATE")) {
                            WaitingPanda.createWaitingPanda(3142);
                        } else if (this.sTypeMaterial.toUpperCase().equals("PANDAEXPLODE")) {
                            WaitingPanda.createWaitingPanda(3144);
                        } else if (this.sTypeMaterial.toUpperCase().equals("PANDATRIPLE")) {
                            WaitingPanda.createWaitingPanda(3143);
                        }
                        Utils.print("-< parse >- create panda");
                    }
                    if (this.sTypeObject.equals("OBSTACLE")) {
                        Obstacle.sstatic = this.isStatic;
                        if (this.sRadius.equals("")) {
                            if (this.shape.length == 6) {
                                Obstacle.createObstacle(ObstacleTypes.getType(this.sTypeMaterial), (int)Float.parseFloat(this.shape[0]), (int)(Float.parseFloat(this.shape[1]) + (float)OFFSET_Y), (int)Float.parseFloat(this.shape[2]), (int)(Float.parseFloat(this.shape[3]) + (float)OFFSET_Y), (int)Float.parseFloat(this.shape[4]), (int)(Float.parseFloat(this.shape[5]) + (float)OFFSET_Y), this.sImageName, this.angle);
                                Utils.print("-< parse >- create triangle");
                            } else if (this.shape.length == 8) {
                                if (this.sImageName.length() != 0) {
                                    Obstacle.createObstacle(ObstacleTypes.getType(this.sTypeMaterial), (int)Float.parseFloat(this.shape[0]), (int)(Float.parseFloat(this.shape[1]) + (float)OFFSET_Y), (int)Float.parseFloat(this.shape[2]), (int)(Float.parseFloat(this.shape[3]) + (float)OFFSET_Y), (int)Float.parseFloat(this.shape[4]), (int)(Float.parseFloat(this.shape[5]) + (float)OFFSET_Y), (int)Float.parseFloat(this.shape[6]), (int)(Float.parseFloat(this.shape[7]) + (float)OFFSET_Y), this.sImageName, this.angle);
                                    Utils.print("-< parse >- create obstacle 8 with image");
                                } else {
                                    Obstacle.createObstacle(ObstacleTypes.getType(this.sTypeMaterial), (int)Float.parseFloat(this.shape[0]), (int)(Float.parseFloat(this.shape[1]) + (float)OFFSET_Y), (int)Float.parseFloat(this.shape[2]), (int)(Float.parseFloat(this.shape[3]) + (float)OFFSET_Y), (int)Float.parseFloat(this.shape[4]), (int)(Float.parseFloat(this.shape[5]) + (float)OFFSET_Y), (int)Float.parseFloat(this.shape[6]), (int)(Float.parseFloat(this.shape[7]) + (float)OFFSET_Y));
                                    Utils.print("-< parse >- create obstacle 8 without image");
                                }
                            }
                        } else {
                            Obstacle.createObstacle(ObstacleTypes.getType(this.sTypeMaterial), (int)Float.parseFloat(this.shape[0]), (int)(Float.parseFloat(this.shape[1]) + (float)OFFSET_Y), (int)Float.parseFloat(this.sRadius), this.sImageName);
                            this.sRadius = "";
                            Utils.print("-< parse >- create circle");
                        }
                        this.isStatic = false;
                    }
                    if (this.sTypeObject.equals("NINJAS")) {
                        if (this.sTypeMaterial.toUpperCase().equals("NINJANORMAL")) {
                            this.ninja = 4401;
                        } else if (this.sTypeMaterial.toUpperCase().equals("NINJASTRONG")) {
                            this.ninja = 4402;
                        } else if (this.sTypeMaterial.toUpperCase().equals("NINJAREINFORCED")) {
                            this.ninja = 4403;
                        }
                        Ninja.createNinja(this.ninja, (int)Float.parseFloat(this.shape[0]), (int)(Float.parseFloat(this.shape[1]) + (float)OFFSET_Y));
                        Utils.print("-< parse >- create ninja");
                    }
                }
            }
            catch (Exception e) {
                Utils.log("!!! level parser error: scenario = " + XMLLevel.this.currentScenario + " / level = " + XMLLevel.this.currentLevel + " / message = " + e.getMessage());
            }
        }
    }
}

