/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game;

import com.ximad.pvn.engine.Application;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.game.Textures;
import com.ximad.pvn.utils.Utils;
import javax.microedition.lcdui.Graphics;

public class Score {
    private static long oldScore;
    public static int[] mHiscore;
    public static int[] mScore;
    public static int hiscoreWidth;
    public static int scoreWidth;
    public static int digitWidth;

    public static void init() {
        oldScore = 0L;
        mHiscore = new int[6];
        mScore = new int[6];
        hiscoreWidth = Textures.score[0].getWidth();
        scoreWidth = Textures.score[1].getWidth();
        digitWidth = Textures.digits[0].getWidth();
        Score.setHighscoreArray();
        Score.setScoreArray();
    }

    public static void setHighscoreArray() {
        long sc = MyWorld.highscore;
        for (int i = 6; i > 0; --i) {
            long p = Utils.pow(10, i - 1);
            Score.mHiscore[6 - i] = (int)(sc / p);
            sc -= (long)mHiscore[6 - i] * p;
        }
    }

    public static void setScoreArray() {
        long sc = MyWorld.score;
        for (int i = 6; i > 0; --i) {
            long p = Utils.pow(10, i - 1);
            Score.mScore[6 - i] = (int)(sc / p);
            sc -= (long)mScore[6 - i] * p;
        }
    }

    public static void update() {
        if (oldScore != (long)MyWorld.score) {
            Score.setScoreArray();
            oldScore = MyWorld.score;
        }
    }

    public static void draw(Graphics g) {
        int i;
        Textures.score[0].draw(g, Application.screenWidth - 220, 5);
        for (i = 0; i < 6; ++i) {
            Textures.digits[mHiscore[i]].draw(g, Application.screenWidth + hiscoreWidth + digitWidth * i - 220, 5);
        }
        Textures.score[1].draw(g, Application.screenWidth - 160, 30);
        for (i = 0; i < 6; ++i) {
            Textures.digits[mScore[i]].draw(g, Application.screenWidth + scoreWidth + digitWidth * i - 159, 30);
        }
    }
}

