/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game;

import com.ximad.pvn.game.AppSettings;
import com.ximad.pvn.game.GameParameters;
import com.ximad.pvn.game.LevelCompleteStat;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.utils.ArrayList;
import com.ximad.pvn.utils.Utils;

public class Scenario {
    public int id;
    public String name;
    public boolean isOpen;
    public int totalScore;
    public int countLevels;
    public int levelsComplete;
    public boolean locked;
    public ArrayList level;
    public int medals;
    public int needMedals;

    public Scenario(int id, String name, boolean isOpen, int countLevels, int totalScore, int levelsComplete, int medals, boolean locked) {
        this.id = id;
        this.name = name;
        this.isOpen = isOpen;
        this.countLevels = countLevels;
        this.totalScore = totalScore;
        this.levelsComplete = levelsComplete;
        this.locked = locked;
        this.level = new ArrayList();
        this.medals = medals;
    }

    public Scenario(String name, int countLevel, String scoreScenario) {
        this.name = name;
        this.countLevels = countLevel;
    }

    public void saveResult() {
        int currLevel = MyWorld.currentLevelInt;
        if (MyWorld.highscore < MyWorld.score) {
            ((LevelCompleteStat)this.level.get((int)currLevel)).hightscore = MyWorld.score;
            MyWorld.highscore = MyWorld.score;
        }
        int tekMedal = ((LevelCompleteStat)this.level.get((int)currLevel)).medal;
        if (MyWorld.score >= MyWorld.gold) {
            ((LevelCompleteStat)this.level.get((int)currLevel)).medal = 3;
        } else if (MyWorld.score >= MyWorld.silver) {
            if (((LevelCompleteStat)this.level.get((int)currLevel)).medal < 2) {
                ((LevelCompleteStat)this.level.get((int)currLevel)).medal = 2;
            }
        } else if (MyWorld.score >= MyWorld.bronze && ((LevelCompleteStat)this.level.get((int)currLevel)).medal < 1) {
            ((LevelCompleteStat)this.level.get((int)currLevel)).medal = 1;
        }
        tekMedal = ((LevelCompleteStat)this.level.get((int)currLevel)).medal - tekMedal;
        GameParameters.countGoldMedals += tekMedal;
        if (currLevel < this.level.size()) {
            if (MyWorld.onWin) {
                if (!((LevelCompleteStat)this.level.get((int)currLevel)).isComplete) {
                    ++this.levelsComplete;
                }
                ((LevelCompleteStat)this.level.get((int)currLevel)).isComplete = true;
            }
            if (currLevel < this.level.size() - 1) {
                ((LevelCompleteStat)this.level.get((int)(currLevel + 1))).isOpen = true;
            }
        }
        Scenario.refreshScenarios();
    }

    public static void recalculateMedals() {
        int med = 0;
        for (int i = 1; i < GameParameters.scenarios.size(); ++i) {
            ((Scenario)GameParameters.scenarios.get((int)i)).needMedals = med += ((Scenario)GameParameters.scenarios.get((int)(i - 1))).medals;
        }
    }

    public static void refreshScenarios() {
        for (int i = 1; i < GameParameters.scenarios.size(); ++i) {
            Scenario scenario = (Scenario)GameParameters.scenarios.get(i);
            Scenario prevScenario = (Scenario)GameParameters.scenarios.get(i - 1);
            if (prevScenario.levelsComplete < 25) {
                scenario.isOpen = false;
                ((LevelCompleteStat)scenario.level.get((int)0)).isOpen = false;
            } else {
                scenario.isOpen = true;
                ((LevelCompleteStat)scenario.level.get((int)0)).isOpen = true;
            }
            if (GameParameters.countGoldMedals < scenario.needMedals) continue;
            scenario.locked = false;
        }
    }

    public static void addMedals(int medals) {
        GameParameters.countGoldMedals += medals;
        Scenario.refreshScenarios();
    }

    public static void unlockAllScenarios() {
        int max = ((Scenario)GameParameters.scenarios.get((int)(GameParameters.scenarios.size() - 1))).needMedals;
        if (GameParameters.countGoldMedals < max) {
            GameParameters.countGoldMedals = max;
            Scenario.refreshScenarios();
        }
    }

    public static int getIdFromName(String name) {
        int id = 0;
        if (name.equals("scenario1")) {
            return 0;
        }
        if (name.equals("scenario2")) {
            return 1;
        }
        if (name.equals("scenario3")) {
            return 2;
        }
        if (name.equals("scenario4")) {
            return 3;
        }
        if (name.equals("scenario5")) {
            return 4;
        }
        return id;
    }

    public void save(AppSettings os) {
        try {
            os.writeInt(this.id);
            os.writeBoolean(this.isOpen);
            os.writeInt(this.totalScore);
            os.writeInt(this.countLevels);
            os.writeInt(this.levelsComplete);
            os.writeBoolean(this.locked);
            this.name = "";
        }
        catch (Exception e) {
            Utils.log("!! error in LevelCompleteStat.getData: " + e.getMessage());
        }
    }

    public void load(AppSettings is) {
        try {
            this.id = is.readInt(this.id);
            this.isOpen = is.readBoolean(this.isOpen);
            this.totalScore = is.readInt(this.totalScore);
            is.readInt(0);
            this.levelsComplete = is.readInt(this.levelsComplete);
            is.readBoolean(false);
        }
        catch (Exception e) {
            Utils.log("!! error in LevelCompleteStat.setData: " + e.getMessage());
        }
    }
}

