/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.engine;

import com.ximad.pvn.engine.Bitmap;
import com.ximad.pvn.engine.Field;
import com.ximad.pvn.game.GameParameters;
import com.ximad.pvn.game.Scenario;
import com.ximad.pvn.game.Textures;
import javax.microedition.lcdui.Graphics;

public class ScenarioButton
extends Field {
    private int index;
    private Bitmap image;
    private int indexOff;
    private int indexOn;
    private int lockLeftOffset;
    private int lockTopOffset;
    private int textTopOffset;
    private int textLeftOffset;
    private String medals;
    private boolean isOpen;
    private boolean isLock;
    private Bitmap lockImage;
    private boolean isPressed;

    public ScenarioButton(Bitmap texture, int index) {
        this.index = index;
        this.image = texture;
        this.width = this.image.getTileWidth();
        this.height = this.image.getTileHeight();
        this.indexOff = index + 6;
        this.indexOn = index;
        if (Textures.selectScenarioLock != null) {
            this.lockImage = Textures.selectScenarioLock;
            this.lockLeftOffset = this.width / 2;
            this.lockTopOffset = this.height - Textures.selectScenarioLock.getHeight();
            this.textTopOffset = this.lockTopOffset + this.height / 3;
            this.textLeftOffset = this.width / 2;
        }
        this.isPressed = false;
    }

    public void onPaint(Graphics g) {
        if (this.isOpen) {
            this.image.drawSprite(g, this.left, this.top, this.indexOn);
        } else {
            this.image.drawSprite(g, this.left, this.top, this.indexOff);
        }
        if (this.isLock) {
            this.lockImage.drawFlag(g, this.left + this.lockLeftOffset, this.top + this.lockTopOffset, 17);
            g.setColor(0xFFFFFF);
            g.drawString(this.medals, this.left + this.textLeftOffset, this.top + this.textTopOffset, 17);
        }
    }

    public void refresh() {
        Scenario scenario = (Scenario)GameParameters.scenarios.get(this.index);
        this.isOpen = scenario.isOpen;
        this.isLock = scenario.locked;
        this.medals = "" + scenario.needMedals;
    }

    public boolean touchEvent(int touchEventType, int eventX, int eventY) {
        boolean out = false;
        if (eventX < this.left || eventX > this.left + this.width || eventY < this.top || eventY > this.top + this.height) {
            out = true;
        }
        switch (touchEventType) {
            case 2: {
                if (out) {
                    return false;
                }
                this.isPressed = true;
                break;
            }
            case 1: {
                if (!this.isPressed) {
                    out = true;
                }
                if (!out) {
                    this.touchAction();
                    break;
                }
                this.repaint();
            }
        }
        return !out;
    }

    protected void touchAction() {
    }
}

