/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.screens;

import com.ximad.pvn.engine.Application;
import com.ximad.pvn.engine.Bitmap;
import com.ximad.pvn.engine.CustomButton;
import com.ximad.pvn.engine.CustomLabelField;
import com.ximad.pvn.engine.ScenarioButton;
import com.ximad.pvn.engine.UiScreen;
import com.ximad.pvn.game.GameParameters;
import com.ximad.pvn.game.Scenario;
import com.ximad.pvn.game.Textures;
import com.ximad.pvn.screens.HomeScreen;
import com.ximad.pvn.screens.SelectLevelScreen;
import javax.microedition.lcdui.Graphics;

public class SelectScenarioScreen
extends UiScreen {
    private static SelectScenarioScreen instance;
    private Bitmap farBackground;
    private Bitmap mainBackground;
    private Bitmap caption;
    private ScenarioButton[] btLevel = new ScenarioButton[6];
    private CustomButton btChristmas;
    private CustomButton btBack;
    private CustomLabelField lbScore;

    public SelectScenarioScreen() {
        this.farBackground = Textures.mainMenuBackground;
        this.mainBackground = Textures.selectScenarioMainBackground;
        this.caption = Textures.selectScenarioCaption;
        for (int lvl = 0; lvl < 6; ++lvl) {
            final int k = lvl;
            this.btLevel[lvl] = new ScenarioButton(Textures.selectScenarioLevels, lvl){

                protected void touchAction() {
                    SelectScenarioScreen.this.openScenario(k);
                }
            };
        }
        this.btBack = new CustomButton(Textures.back, 0, 1){

            protected void touchAction() {
                Application.setScreen(HomeScreen.getInstance());
            }
        };
        this.btChristmas = new CustomButton(Textures.selectScenarioChristmas, Textures.selectScenarioChristmas, null){

            protected void touchAction() {
                try {
                    Application.getInstance().platformRequest("http://store.ovi.com/content/227024");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.lbScore = new CustomLabelField("0", 22, 5646607);
        this.add(this.btBack, 257, 310);
        this.add(this.btLevel[0], 94, 125);
        this.add(this.btLevel[1], 210, 125);
        this.add(this.btLevel[2], 325, 124);
        this.add(this.btLevel[3], 440, 124);
        this.add(this.btLevel[4], 152, 205);
        this.add(this.btLevel[5], 270, 205);
        this.add(this.btChristmas, 384, 210);
        this.add(this.lbScore, 295, 100);
    }

    public void onPaint(Graphics g) {
        this.farBackground.draw(g, 0, 0);
        this.mainBackground.draw(g, 33, -10);
        this.caption.drawFlag(g, 321, 62, 3);
        Textures.selectScenarioMedal.draw(g, 240, 88);
        super.onPaint(g);
    }

    private void openScenario(int number) {
        if (number >= 0 && number < GameParameters.scenarios.size() && ((Scenario)GameParameters.scenarios.get((int)number)).isOpen && !((Scenario)GameParameters.scenarios.get((int)number)).locked) {
            SelectLevelScreen.getInstance().scenarioNumber = number;
            GameParameters.indexCurrentScenario = number;
            GameParameters.currentScenario = (Scenario)GameParameters.scenarios.get(number);
            Application.setScreen(SelectLevelScreen.getInstance());
        }
    }

    public void onShow() {
        for (int lvl = 0; lvl < GameParameters.scenarios.size(); ++lvl) {
            this.btLevel[lvl].refresh();
        }
        this.lbScore.setText("x " + GameParameters.countGoldMedals);
        SelectScenarioScreen.repaint();
    }

    public static SelectScenarioScreen getInstance() {
        if (instance == null) {
            instance = new SelectScenarioScreen();
        }
        return instance;
    }
}

