/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.screens;

import at.emini.physics2D.World;
import at.emini.physics2D.util.FXUtil;
import at.emini.physics2D.util.FXVector;
import com.ximad.pvn.audio.SoundSystem;
import com.ximad.pvn.debug.Monitor;
import com.ximad.pvn.engine.Application;
import com.ximad.pvn.engine.UiScreen;
import com.ximad.pvn.game.Background;
import com.ximad.pvn.game.Camera;
import com.ximad.pvn.game.CollisionSystem;
import com.ximad.pvn.game.GameControl;
import com.ximad.pvn.game.GameObject;
import com.ximad.pvn.game.GameParameters;
import com.ximad.pvn.game.LevelCompleteStat;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.game.PandaSeeker;
import com.ximad.pvn.game.PandaSetup;
import com.ximad.pvn.game.ParticleSystem;
import com.ximad.pvn.game.Scenario;
import com.ximad.pvn.game.Score;
import com.ximad.pvn.game.Textures;
import com.ximad.pvn.game.WaitingPanda;
import com.ximad.pvn.game.XMLLevel;
import com.ximad.pvn.game.ninjas.Ninja;
import com.ximad.pvn.game.obstacles.GameLandscape;
import com.ximad.pvn.market.MarketScreen;
import com.ximad.pvn.screens.EndLevelScreen;
import com.ximad.pvn.screens.PauseScreen;
import javax.microedition.lcdui.Graphics;

public class GameScreen
extends UiScreen {
    private static final int MILLIS = 30;
    private static GameScreen instance;
    public static MyWorld world;
    private GameControl gameControl;
    long lastUpdate = System.currentTimeMillis();
    public static boolean pause;
    public static boolean market;
    public static boolean end;
    public static boolean win;

    public void onIdle() {
        if (market) {
            this.market();
            return;
        }
        if (pause) {
            this.pause();
            return;
        }
        if (end) {
            this.end();
            return;
        }
        Monitor.begin("update.all");
        long start = System.currentTimeMillis();
        long dt = start - this.lastUpdate;
        this.lastUpdate = start;
        world.update(dt);
        Monitor.end("update.all");
        GameScreen.repaint();
        long sleepTm = 30L - (System.currentTimeMillis() - start);
        if (sleepTm > 0L && sleepTm > 0L) {
            GameScreen.sleep(sleepTm);
        }
    }

    public void onPaint(Graphics g) {
        Monitor.onStartPaint();
        Monitor.begin("draw.all");
        world.draw(g);
        Monitor.end("draw.all");
    }

    protected void onPointerPressed(int x, int y) {
        this.gameControl.processInput(2, x, y, world);
    }

    protected void onPointerReleased(int x, int y) {
        this.gameControl.processInput(1, x, y, world);
    }

    protected void onPointerDragged(int x, int y) {
        this.gameControl.processInput(3, x, y, world);
    }

    public void loadLevel(int scenario, int level) {
        System.gc();
        if (world == null) {
            world = new MyWorld();
        } else {
            world.restart();
        }
        if (scenario == 1 && level == 1 && GameParameters.tutorials[0] == 1) {
            Textures.tutorial = Textures.loadBitmap("scenario1_1");
            MyWorld.onTutorial = true;
            GameParameters.tutorials[0] = 0;
        }
        if (scenario == 1 && level == 10 && GameParameters.tutorials[1] == 1) {
            Textures.tutorial = Textures.loadBitmap("scenario1_10");
            MyWorld.onTutorial = true;
            GameParameters.tutorials[1] = 0;
        }
        if (scenario == 2 && level == 13 && GameParameters.tutorials[2] == 1) {
            Textures.tutorial = Textures.loadBitmap("scenario2_13");
            MyWorld.onTutorial = true;
            GameParameters.tutorials[2] = 0;
        }
        if (scenario == 4 && level == 2 && GameParameters.tutorials[3] == 1) {
            Textures.tutorial = Textures.loadBitmap("scenario4_2");
            MyWorld.onTutorial = true;
            GameParameters.tutorials[3] = 0;
        }
        this.gameControl = new GameControl();
        GameScreen.world.collisionSystem = new CollisionSystem();
        GameScreen.world.collisionSystem.init();
        ParticleSystem.init();
        GameLandscape.createGroundBox();
        world.setGravity(new FXVector(0, 163840));
        MyWorld.camera = new Camera();
        MyWorld.camera.init();
        MyWorld.background = new Background();
        Ninja.ninjas.removeAllElements();
        MyWorld.currentLevelInt = level - 1;
        MyWorld.currentLevelStr = "" + level;
        GameParameters.currentLevelInt = level - 1;
        GameParameters.indexCurrentScenario = scenario - 1;
        GameParameters.currentScenario = (Scenario)GameParameters.scenarios.get(scenario - 1);
        XMLLevel.loadLevel(scenario, level);
        MyWorld.highscore = ((LevelCompleteStat)GameParameters.currentScenario.level.get((int)(level - 1))).hightscore;
        Score.init();
        PandaSeeker.init();
        Camera.setPosition(Camera.level_size - Application.screenWidth);
        GameScreen.loadAllPandas();
        World.setTimestepFX(FXUtil.divideFX(1, 14));
        world.setDampingRotationalFX(5000);
        System.gc();
    }

    public static void loadAllPandas() {
        int i;
        for (i = 0; i < MyWorld.wPandas.size(); ++i) {
            MyWorld.gameObjects.add(MyWorld.wPandas.get(i));
        }
        MyWorld.currentPanda = MyWorld.wPandas.size() != 0 ? ((WaitingPanda)MyWorld.wPandas.get((int)0)).type : -1;
        for (i = MyWorld.gameObjects.size() - 1; i >= 0; --i) {
            GameObject go = (GameObject)MyWorld.gameObjects.get(i);
            if (go == null || !go.panda) continue;
            PandaSetup.createPandaSetup((GameObject)MyWorld.gameObjects.get(i), MyWorld.playerCoord.x, MyWorld.playerCoord.y);
            MyWorld.gameObjects.remove(i);
            MyWorld.gameObjects.clearDeleted();
            MyWorld.currentPanda = -1;
            break;
        }
    }

    public void restart() {
        this.loadLevel(GameParameters.indexCurrentScenario + 1, GameParameters.currentLevelInt + 1);
    }

    public void pause() {
        Application.setScreen(null);
        GameScreen.sleep(25L);
        MyWorld.SHOW_SCORE_AND_PAUSE = false;
        PauseScreen.getInstance().setFon(this.takeScreenshot());
        MyWorld.SHOW_SCORE_AND_PAUSE = true;
        PauseScreen.getInstance().setText("" + (GameParameters.indexCurrentScenario + 1) + "-" + GameParameters.currentLevelStr);
        Application.setScreen(PauseScreen.getInstance());
        pause = false;
    }

    public void market() {
        Application.setScreen(null);
        GameScreen.sleep(25L);
        MyWorld.SHOW_SCORE_AND_PAUSE = false;
        MarketScreen.getInstance().setFon(this.takeScreenshot());
        MyWorld.SHOW_SCORE_AND_PAUSE = true;
        Application.setScreen(MarketScreen.getInstance());
        market = false;
    }

    public void resume() {
    }

    public void end() {
        MyWorld.SHOW_SCORE_AND_PAUSE = false;
        EndLevelScreen.getInstance().setFon(this.takeScreenshot());
        MyWorld.SHOW_SCORE_AND_PAUSE = true;
        EndLevelScreen.getInstance().setWin(win);
        Application.setScreen(EndLevelScreen.getInstance());
        end = false;
    }

    public void onShow() {
        SoundSystem.SOUND_MAIN_THEME.stop();
    }

    public static GameScreen getInstance() {
        if (instance == null) {
            instance = new GameScreen();
        }
        return instance;
    }
}

