/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.screens;

import com.ximad.pvn.audio.SoundSystem;
import com.ximad.pvn.engine.Application;
import com.ximad.pvn.engine.Bitmap;
import com.ximad.pvn.engine.CustomButton;
import com.ximad.pvn.engine.CustomLabelField;
import com.ximad.pvn.engine.UiScreen;
import com.ximad.pvn.game.GameParameters;
import com.ximad.pvn.game.LevelCompleteStat;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.game.Scenario;
import com.ximad.pvn.game.Textures;
import com.ximad.pvn.screens.GameScreen;
import com.ximad.pvn.screens.SelectLevelScreen;
import com.ximad.pvn.screens.StatisticScreen;
import javax.microedition.lcdui.Graphics;

public class EndLevelScreen
extends UiScreen {
    private static EndLevelScreen instance;
    private CustomButton btSecond;
    private Bitmap farBackground;
    private CustomLabelField level;
    private CustomLabelField score;
    private CustomLabelField high_score;
    private CustomLabelField game_score;
    public int medal = 0;
    private boolean final_level = false;
    private boolean next = false;
    private boolean win = false;

    public EndLevelScreen() {
        CustomButton btRestart = new CustomButton(Textures.endlevelRestart, Textures.endlevelRestart, null){

            protected void touchAction() {
                GameScreen.getInstance().restart();
                Application.setScreen(GameScreen.getInstance());
            }
        };
        this.btSecond = new CustomButton(Textures.endlevelNextOff, Textures.endlevelNext, null){

            protected void touchAction() {
                if (EndLevelScreen.this.final_level) {
                    EndLevelScreen.this.showStatistic();
                } else if (EndLevelScreen.this.next) {
                    EndLevelScreen.this.nextLevel();
                }
            }
        };
        CustomButton btExit = new CustomButton(Textures.endlevelExit, Textures.endlevelExit, null){

            protected void touchAction() {
                EndLevelScreen.this.quit();
            }
        };
        this.level = new CustomLabelField("2", 14, 0);
        this.score = new CustomLabelField("score: ", 14, 0);
        this.high_score = new CustomLabelField("high score: ", 14, 0);
        this.game_score = new CustomLabelField("game score: ", 14, 0);
        this.add(btRestart, 375, 0);
        this.add(this.btSecond, 375, 123);
        this.add(btExit, 375, 211);
        this.add(this.level, 150, 124);
        this.add(this.score, 150, 147);
        this.add(this.high_score, 205, 172);
        this.add(this.game_score, 220, 200);
    }

    public void onPaint(Graphics g) {
        if (this.farBackground != null) {
            this.farBackground.draw(g, 0, 0);
        }
        Textures.endlevelPapirus.draw(g, 30, 0);
        Textures.medalOff.draw(g, 150, 232);
        switch (this.medal) {
            case 1: {
                Textures.medalBronze.draw(g, 150, 232);
                break;
            }
            case 2: {
                Textures.medalSilver.draw(g, 150, 232);
                break;
            }
            case 3: {
                Textures.medalGold.draw(g, 150, 232);
            }
        }
        if (this.win) {
            Textures.endLevelCompleted.drawFlag(g, 192, 90, 3);
        } else {
            Textures.endLevelFailed.drawFlag(g, 192, 90, 3);
        }
        super.onPaint(g);
    }

    public void onShow() {
        this.level.setText("" + (MyWorld.currentLevelInt + 1));
        this.score.setText("" + MyWorld.score);
        this.high_score.setText("" + MyWorld.highscore);
        int scor = 0;
        for (int i = 0; i < GameParameters.scenarios.size(); ++i) {
            Scenario scenario = (Scenario)GameParameters.scenarios.get(i);
            for (int j = 0; j < scenario.level.size(); ++j) {
                LevelCompleteStat lvl = (LevelCompleteStat)scenario.level.get(j);
                scor += lvl.hightscore;
            }
        }
        this.game_score.setText("" + scor);
        this.medal = this.win ? (MyWorld.score < MyWorld.bronze ? 0 : (MyWorld.score < MyWorld.silver ? 1 : (MyWorld.score < MyWorld.gold ? 2 : 3))) : 0;
        if (MyWorld.currentLevelInt == GameParameters.currentScenario.level.size() - 1 && GameParameters.indexCurrentScenario == GameParameters.scenarios.size() - 1) {
            this.final_level = true;
            this.btSecond.setOffImage(Textures.endlevelStatistics);
            this.btSecond.setOnImage(Textures.endlevelStatistics);
        } else {
            this.final_level = false;
            this.next = MyWorld.currentLevelInt < GameParameters.currentScenario.level.size() - 1 ? ((LevelCompleteStat)GameParameters.currentScenario.level.get((int)(MyWorld.currentLevelInt + 1))).isOpen : (GameParameters.scenarios.get(GameParameters.indexCurrentScenario + 1) != null ? ((LevelCompleteStat)((Scenario)GameParameters.scenarios.get((int)(GameParameters.indexCurrentScenario + 1))).level.get((int)0)).isOpen : false);
            if (this.next) {
                this.btSecond.setOffImage(Textures.endlevelNext);
                this.btSecond.setOnImage(Textures.endlevelNext);
            } else {
                this.btSecond.setOffImage(Textures.endlevelNextOff);
                this.btSecond.setOnImage(Textures.endlevelNextOff);
            }
        }
        EndLevelScreen.repaint();
    }

    public void setFon(Bitmap image) {
        this.farBackground = image;
        this.farBackground.setDark(150);
    }

    public void setWin(boolean win) {
        this.win = win;
    }

    public void setText(String text) {
        this.level.setText(text);
    }

    private void quit() {
        Application.setScreen(SelectLevelScreen.getInstance());
        SoundSystem.SOUND_MAIN_THEME.playInLoop();
    }

    private void showStatistic() {
        Application.setScreen(StatisticScreen.getInstance());
        SoundSystem.SOUND_MAIN_THEME.playInLoop();
    }

    private void nextLevel() {
        if (GameParameters.currentLevelInt == GameParameters.currentScenario.level.size() - 1) {
            GameScreen.getInstance().loadLevel(GameParameters.indexCurrentScenario + 2, 1);
        } else {
            GameScreen.getInstance().loadLevel(GameParameters.indexCurrentScenario + 1, GameParameters.currentLevelInt + 2);
        }
        Application.setScreen(GameScreen.getInstance());
    }

    public static EndLevelScreen getInstance() {
        if (instance == null) {
            instance = new EndLevelScreen();
        }
        return instance;
    }
}

