/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game.ninjas;

import com.ximad.pvn.audio.SoundSystem;
import com.ximad.pvn.engine.Application;
import com.ximad.pvn.game.Box2d;
import com.ximad.pvn.game.Camera;
import com.ximad.pvn.game.EffectStars;
import com.ximad.pvn.game.GameParameters;
import com.ximad.pvn.game.Launcher;
import com.ximad.pvn.game.LevelCompleteStat;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.game.PhysicalGameObject;
import com.ximad.pvn.game.Point;
import com.ximad.pvn.game.Point_system;
import com.ximad.pvn.game.SpecialEffect;
import com.ximad.pvn.game.Textures;
import com.ximad.pvn.game.ninjas.Ninja;
import com.ximad.pvn.utils.ArrayList;
import com.ximad.pvn.utils.Utils;
import javax.microedition.lcdui.Graphics;

public class NinjaNormal
extends Ninja {
    private static final int DENSITY = 15;
    public float collisionForce = 0.0f;
    int timeToDie = 0;
    private boolean effect;
    int time;
    int timetowait;
    int mSound;

    public NinjaNormal() {
        this.isPlayerPenetratable = true;
        this.effect = false;
        this.score = 1000;
    }

    public void OnCollision(PhysicalGameObject obj, float force) {
        force = (float)((double)force * 1.15);
        if (obj.typeDinamicalObjects == 103) {
            this.collisionForce = force;
            if (this.collisionForce > 15.0f) {
                if (this.health > 0) {
                    this.health -= 3;
                    this.setStunnedAnimationSequence();
                }
            } else if (this.collisionForce > 12.0f) {
                if (this.health > 0) {
                    this.health -= 2;
                    this.setStunnedAnimationSequence();
                }
            } else if (this.collisionForce > 10.0f && this.health > 0) {
                --this.health;
                this.setStunnedAnimationSequence();
            }
        }
        if (obj.typeDinamicalObjects == 104) {
            Box2d.stopAngularVelocity(this.box2dId);
            this.collisionForce = force;
            if (this.collisionForce > 20.0f) {
                if (this.health > 0) {
                    this.health -= 3;
                    this.setStunnedAnimationSequence();
                }
            } else if (this.collisionForce > 18.0f) {
                if (this.health > 0) {
                    this.health -= 2;
                    this.setStunnedAnimationSequence();
                }
            } else if (this.collisionForce > 14.0f && this.health > 0) {
                --this.health;
                this.setStunnedAnimationSequence();
            }
        }
        if (obj.typeDinamicalObjects == 102) {
            this.collisionForce = force;
            if (this.collisionForce > 15.0f) {
                if (this.health > 0) {
                    this.health -= 3;
                    this.setStunnedAnimationSequence();
                }
            } else if (this.collisionForce > 12.0f) {
                if (this.health > 0) {
                    this.health -= 2;
                    this.setStunnedAnimationSequence();
                }
            } else if (this.collisionForce > 8.0f && this.health > 0) {
                --this.health;
                this.setStunnedAnimationSequence();
            }
        }
        if (obj.typeDinamicalObjects == 101) {
            Box2d.stopAngularVelocity(this.box2dId);
            this.collisionForce = force;
            if (this.collisionForce > 16.0f) {
                if (this.health > 0) {
                    this.health -= 3;
                    this.setStunnedAnimationSequence();
                }
            } else if (this.collisionForce > 13.0f) {
                if (this.health > 0) {
                    this.health -= 2;
                    this.setStunnedAnimationSequence();
                }
            } else if (this.collisionForce > 10.0f && this.health > 0) {
                --this.health;
                this.setStunnedAnimationSequence();
            }
        }
    }

    public void checkDeadPanda(float dt) {
        if (this.onDestroy) {
            this.timeToDie = (int)((float)this.timeToDie + dt);
            if (this.timeToDie > 2000) {
                int point = (this.damage - this.health) * this.score;
                MyWorld.score += point;
                LevelCompleteStat levelCompleteStat = (LevelCompleteStat)GameParameters.currentScenario.level.get(MyWorld.currentLevelInt);
                levelCompleteStat.score += (long)point;
                SoundSystem.SOUND_ON_NINJA_DESTROY[Utils.random.nextInt(4)].play();
                Point_system.createPoints(this, point);
                SpecialEffect.createSmoke2(this);
                Box2d.destroyGameObject(this.box2dId);
                ninjas.removeElement(this);
                ++levelCompleteStat.ninjas;
                --MyWorld.livesDisapearedNinja;
                MyWorld.physicalGameObjects.remove(this);
                MyWorld.checkEndLevel();
            }
        }
    }

    public void update(long dt) {
        this.checkDeadPanda(dt);
        int centerX = Box2d.getCenterX(this.box2dId);
        if (centerX + 20 > MyWorld.center + Application.screenWidth / 2 || centerX < Launcher.launcher.position.x) {
            this.health = 0;
        }
        this.time = (int)((long)this.time + dt);
        if (this.health <= 0) {
            this.onDestroy = true;
        }
        if (this.onDestroy && !this.effect) {
            if (this.frames != Textures.ninjanormal) {
                this.frames = Textures.ninjanormal;
            }
            this.health = 0;
            this.setStunnedAnimationSequence();
            EffectStars.createStars(this);
            this.effect = true;
        } else if (MyWorld.onPlay) {
            if (this.health == 2 && this.damage == 3 && !this.isAnimationPlaying) {
                this.frames = Textures.ninjareinforced;
                this.setWaitingAnimationSequence();
                Point_system.createPoints(this, (this.damage - this.health) * 1000);
                this.damage = 2;
            }
            if (this.health == 1 && this.damage >= 2 && !this.isAnimationPlaying) {
                this.frames = Textures.ninjanormal;
                this.setWaitingAnimationSequence();
                Point_system.createPoints(this, (this.damage - this.health) * 1000);
                this.damage = 1;
            }
        }
        this.cFrame = this.getCurrentFrame();
        this.angle = Box2d.getAngle(this.box2dId);
    }

    public void draw(Graphics g) {
        if (this.isInvisible()) {
            return;
        }
        this.frames[this.cFrame].drawRotatedCenterSquareImage(Box2d.getCenterX(this.box2dId) - Camera.position, Box2d.getCenterY(this.box2dId), this.angle, g);
    }

    public static void createNinja(int x, int y, int hp) {
        NinjaNormal ninja = new NinjaNormal();
        ninjas.addElement(ninja);
        ninja.typeDinamicalObjects = 103;
        ninja.isCircle = true;
        ninja.restitution = 1;
        ninja.friction = 99;
        ninja.radius = 18;
        ninja.density = 15;
        ArrayList shape = new ArrayList();
        shape.add(new Point(x, y));
        ninja.nFrames = 8;
        if (hp == 3) {
            ninja.frames = Textures.ninjastrong;
            ninja.health = ninja.damage = hp;
        }
        if (hp == 2) {
            ninja.frames = Textures.ninjareinforced;
            ninja.health = ninja.damage = hp;
        }
        if (hp == 1) {
            ninja.frames = Textures.ninjanormal;
            ninja.health = ninja.damage = hp;
        }
        ninja.setWaitingAnimationSequence();
        ++MyWorld.livesDisapearedNinja;
        ninja.fixedRotation = false;
        ninja.setShape(shape, false, false);
        MyWorld.physicalGameObjects.add(ninja);
        ninja.mass = Box2d.getMass(ninja.box2dId);
        ninja.mSound = Utils.random.nextInt(6) + 1;
        ninja.box2dId.setParent(ninja);
    }
}

