/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game;

import com.ximad.pvn.game.Camera;
import com.ximad.pvn.game.GameObject;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.game.PandaSetup;
import com.ximad.pvn.game.Score;
import com.ximad.pvn.game.Textures;
import com.ximad.pvn.game.WaitingPanda;
import com.ximad.pvn.screens.GameScreen;
import javax.microedition.lcdui.Graphics;

public class Hud {
    public static final int SLOT_WIDTH = 53;
    public static final int SLOT_HEIGHT = 52;
    public static final int SLOT_LEFT_OFFSET = 8;
    public static final int SLOT_PADDING_OFFSET = 0;
    public static final int SLOT_TOP = 127;
    public static final int RADIUS = 15;
    public static final int HOUSE_LEFT = 4;
    public static final int HOUSE_TOP = 115;
    public static final int SLOT_ROWS = 3;
    public static final int SLOT_COLUMNS = 3;
    public static final int SLOT_COUNT = 9;
    public static Slot[] pandas = new Slot[9];
    public static final int FRAME_DELAY = 100;
    public static boolean isAnim = false;
    private static long lastTime;
    private static int downX;
    private static int downY;

    public static void init() {
        int k = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                Hud.pandas[k] = new Slot(j, i + 2, 8 + j * 53, 127 + i * 52, 53, 52);
                ++k;
            }
        }
    }

    public static void drawHouse(Graphics g) {
    }

    public static void drawHud(Graphics g) {
        Score.draw(g);
        Textures.pauseButton.draw(g, 0, 0);
    }

    public static void draw(Graphics g) {
    }

    public static boolean touchEvent(int touchEvent, int x, int y) {
        if (x > 0 && x < Textures.pauseButton.getWidth() && y > 0 && y < Textures.pauseButton.getHeight()) {
            GameScreen.pause = true;
            return false;
        }
        return true;
    }

    public static int getFreeSlots() {
        int freeSlots = 0;
        for (int i = 0; i < 9; ++i) {
            if (pandas[i].getPandaType() != 0) continue;
            ++freeSlots;
        }
        return freeSlots;
    }

    public static boolean addPandas(int type, int count) {
        int i;
        int freeSlots = 0;
        for (i = 0; i < 9; ++i) {
            if (pandas[i].getPandaType() != 0) continue;
            ++freeSlots;
        }
        if (count > freeSlots) {
            return false;
        }
        for (i = 0; i < 9; ++i) {
            if (pandas[i].getPandaType() != 0 || count <= 0) continue;
            pandas[i].setPandaType(type);
            --count;
        }
        return true;
    }

    public static int swapTopPanda(int panda_type) {
        int i;
        for (i = MyWorld.gameObjects.size() - 1; i >= 0; --i) {
            if (MyWorld.gameObjects.get(i) == null || !((GameObject)MyWorld.gameObjects.get((int)i)).panda) continue;
            if (!((WaitingPanda)MyWorld.gameObjects.get((int)i)).isBuy) break;
            if (panda_type == 0) {
                MyWorld.wPandas.remove(MyWorld.wPandas.size() - 1);
                MyWorld.wPandas.clearDeleted();
                int type = ((WaitingPanda)MyWorld.gameObjects.get((int)i)).type;
                MyWorld.gameObjects.remove(i);
                MyWorld.gameObjects.clearDeleted();
                --MyWorld.lives;
                --MyWorld.livesDisapearedPanda;
                return type;
            }
            return WaitingPanda.changeTypePanda((WaitingPanda)MyWorld.gameObjects.get(i), panda_type);
        }
        if (panda_type != 0) {
            WaitingPanda.createWaitingPanda(panda_type, true);
            MyWorld.gameObjects.add(MyWorld.wPandas.get(MyWorld.wPandas.size() - 1));
            if (MyWorld.currentPanda == -1 && !PandaSetup.settingUp) {
                for (i = MyWorld.gameObjects.size() - 1; i >= 0; --i) {
                    if (MyWorld.gameObjects.get(i) == null || !((GameObject)MyWorld.gameObjects.get((int)i)).panda) continue;
                    PandaSetup.createPandaSetup((GameObject)MyWorld.gameObjects.get(i), MyWorld.playerCoord.x, MyWorld.playerCoord.y);
                    MyWorld.gameObjects.remove(i);
                    MyWorld.gameObjects.clearDeleted();
                    MyWorld.onLost = false;
                    MyWorld.onCompleteLost = false;
                    Camera.canScrollStart = true;
                    break;
                }
            }
        }
        return 0;
    }

    static class Slot {
        private int pandaType;
        private int indexX;
        private int indexY;
        private int left;
        private int top;
        private int width;
        private int height;
        private int indexFrame;
        private int animTypeUp;
        private int animTypeDown;
        private int indexFrameDown;
        private int pandaTypeDown;
        private int pandaTypeUp;
        private long time;

        public Slot(int indexX, int indexY, int left, int top, int width, int height) {
            this.indexX = indexX;
            this.indexY = indexY;
            this.left = left;
            this.top = top;
            this.width = width;
            this.height = height;
            this.pandaType = 0;
            this.indexFrame = 0;
            this.time = 0L;
            this.pandaTypeUp = 0;
        }

        public int getPandaType() {
            return this.pandaType;
        }

        public void setPandaType(int type) {
            this.pandaType = type;
            this.pandaTypeUp = type;
        }

        public void click() {
            if (!isAnim) {
                this.startSwap();
            }
        }

        public void startSwap() {
            isAnim = true;
            this.pandaTypeUp = this.pandaType;
            this.pandaType = this.pandaTypeDown = Hud.swapTopPanda(this.pandaType);
            int offset = 2;
            if (this.pandaTypeUp == 0 && this.pandaTypeDown == 0) {
                this.animTypeUp = 0;
                isAnim = false;
                return;
            }
            if (this.pandaTypeUp == 0 && this.pandaTypeDown != 0) {
                this.animTypeUp = -1;
                this.animTypeDown = 1;
                this.indexFrame = 10;
                this.indexFrameDown = 0;
                this.pandaTypeUp = this.pandaTypeDown;
                offset = 1;
            }
            if (this.pandaTypeUp != 0 && this.pandaTypeDown == 0) {
                this.animTypeUp = 1;
                this.animTypeDown = -1;
                this.indexFrame = 0;
                this.indexFrameDown = 10;
                this.pandaTypeDown = this.pandaTypeUp;
            }
            if (this.pandaTypeUp != 0 && this.pandaTypeDown != 0) {
                this.animTypeUp = 1;
                this.animTypeDown = 1;
                this.indexFrame = 0;
                this.indexFrameDown = 0;
            }
            downX = 30 + (int)((double)((MyWorld.lives - offset) * 15) * 2.5 + (double)(5 * (MyWorld.lives - offset))) + 15 - this.width / 2 + 4;
            downY = MyWorld.floor - 15 - this.height / 2 + 2;
            this.time = System.currentTimeMillis();
        }

        public void update(long dt) {
            this.time += dt;
            if (this.time > 100L && this.animTypeUp != 0) {
                this.time = 0L;
                this.indexFrame += this.animTypeUp;
                this.indexFrameDown += this.animTypeDown;
                if (this.animTypeUp == 1 && this.animTypeDown == 1 && this.indexFrame == 5) {
                    this.animTypeUp = -1;
                    this.animTypeDown = -1;
                    int tempType = this.pandaTypeUp;
                    this.pandaTypeUp = this.pandaTypeDown;
                    this.pandaTypeDown = tempType;
                }
                if (this.indexFrame == 0 || this.indexFrame == 10 || this.indexFrameDown == 0 || this.indexFrameDown == 10) {
                    isAnim = false;
                    this.animTypeUp = 0;
                    this.animTypeDown = 0;
                    this.indexFrame = 0;
                    this.pandaTypeUp = this.pandaType;
                }
            }
        }

        public void draw(Graphics g) {
            if (this.pandaTypeUp == 0) {
                Textures.marketCell.draw(g, this.left - Camera.position, this.top + 8);
            } else {
                Textures.marketPaid.draw(g, this.left + 20 - Camera.position, this.top - 5);
                switch (this.pandaTypeUp) {
                    case 3141: {
                        Textures.pandaNormalAnim.drawSprite(g, this.left - Camera.position, this.top, this.indexFrame);
                        break;
                    }
                    case 3142: {
                        Textures.pandaAccelerateAnim.drawSprite(g, this.left - Camera.position, this.top, this.indexFrame);
                        break;
                    }
                    case 3144: {
                        Textures.pandaExplodeAnim.drawSprite(g, this.left - Camera.position, this.top, this.indexFrame);
                        break;
                    }
                    case 3143: {
                        Textures.pandaGhostAnim.drawSprite(g, this.left - Camera.position, this.top, this.indexFrame);
                    }
                }
            }
            if (this.animTypeUp != 0) {
                switch (this.pandaTypeDown) {
                    case 3141: {
                        Textures.pandaNormalAnim.drawSprite(g, downX - Camera.position, downY, this.indexFrameDown);
                        break;
                    }
                    case 3142: {
                        Textures.pandaAccelerateAnim.drawSprite(g, downX - Camera.position, downY, this.indexFrameDown);
                        break;
                    }
                    case 3144: {
                        Textures.pandaExplodeAnim.drawSprite(g, downX - Camera.position, downY, this.indexFrameDown);
                        break;
                    }
                    case 3143: {
                        Textures.pandaGhostAnim.drawSprite(g, downX - Camera.position, downY, this.indexFrameDown);
                    }
                }
            }
        }
    }
}

