/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game.pandas;

import com.ximad.pvn.audio.SoundSystem;
import com.ximad.pvn.game.Box2d;
import com.ximad.pvn.game.Camera;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.game.PhysicalGameObject;
import com.ximad.pvn.game.Point;
import com.ximad.pvn.game.Textures;
import com.ximad.pvn.game.TraceEffect;
import com.ximad.pvn.game.pandas.Panda;
import com.ximad.pvn.utils.ArrayList;

public class PandaAccelerate
extends Panda {
    public void OnCollision(PhysicalGameObject obj, float force) {
        if (MyWorld.playerPanda != null && !this.isDying && this == MyWorld.playerPanda) {
            MyWorld.onFly = false;
            this.isDying = true;
            MyWorld.playerPanda = null;
        }
        if (obj.typeDinamicalObjects == 101) {
            Box2d.stopAngularVelocity(this.box2dId);
        }
        if (obj.typeDinamicalObjects == 103) {
            // empty if block
        }
        if (obj.typeDinamicalObjects == 104) {
            // empty if block
        }
        if (obj.typeDinamicalObjects == 102) {
            // empty if block
        }
    }

    public void ability() {
        if (this.trick) {
            SoundSystem.SOUND_ON_ABILITY.play();
            int k1 = Box2d.getLinearVelocityX(this.box2dId);
            int k2 = Box2d.getLinearVelocityY(this.box2dId);
            Box2d.applyForceToCenter(this.box2dId, k1 * 62, k2 * 62);
            this.trick = false;
            Camera.canScrollStart = true;
        }
    }

    public static void createPanda(int x, int y) {
        PandaAccelerate panda = new PandaAccelerate();
        panda.typeDinamicalObjects = 102;
        panda.isCircle = true;
        panda.isBullet = true;
        panda.restitution = 43;
        panda.friction = 3;
        panda.radius = 15;
        panda.density = 40;
        ArrayList shape = new ArrayList();
        shape.add(new Point(x, y));
        panda.setShape(shape, false, false);
        panda.frames = Textures.pandaSuper;
        panda.nFrames = 8;
        MyWorld.physicalGameObjects.add(panda);
        panda.mass = Box2d.getMass(panda.box2dId);
        MyWorld.playerPanda = panda;
        Camera.setTarget(panda);
        panda.box2dId.setParent(panda);
        TraceEffect.createSpecialTrace(panda);
    }

    public static void launchPanda(int RawX, int RawY) {
        PandaAccelerate.createPanda(RawX, RawY);
        Box2d.applyForceToCenter(MyWorld.playerPanda.box2dId, Box2d.getMass(MyWorld.playerPanda.box2dId) * forceX, Box2d.getMass(MyWorld.playerPanda.box2dId) * forceY);
    }

    public void update(long dt) {
        this.checkDeadPanda(dt);
        this.checkDistance();
        super.update(dt);
    }
}

