/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game.obstacles;

import at.emini.physics2D.util.FXUtil;
import com.ximad.pvn.audio.SoundSystem;
import com.ximad.pvn.game.Box2d;
import com.ximad.pvn.game.CollisionSystem;
import com.ximad.pvn.game.GameParameters;
import com.ximad.pvn.game.LevelCompleteStat;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.game.PhysicalGameObject;
import com.ximad.pvn.game.Point;
import com.ximad.pvn.game.SpecialEffect;
import com.ximad.pvn.game.XBody;
import com.ximad.pvn.game.obstacles.Obstacle;
import com.ximad.pvn.game.pandas.PandaMini;
import com.ximad.pvn.utils.ArrayList;
import com.ximad.pvn.utils.Utils;
import javax.microedition.lcdui.Graphics;

public class ObstacleDynamite
extends Obstacle {
    static final float kExploid = 0.3f;
    public float collisionForce = 0.0f;
    private float radiusExplode = 0.0f;

    public ObstacleDynamite() {
        this.isPlayerPenetratable = true;
        this.score = 5000;
        this.durability = 1;
        this.type = 5009;
    }

    public void OnCollision(PhysicalGameObject obj, float force) {
        super.OnCollision(obj, force);
        if (obj.typeDinamicalObjects == 101) {
            this.collisionForce = force;
            if (this.collisionForce > 8.0f) {
                --this.durability;
                SoundSystem.SOUND_ON_PANDA_EXPLOSION.play();
            }
        }
        if (obj.typeDinamicalObjects == 103) {
            this.collisionForce = force;
            if (this.collisionForce > 7.0f) {
                --this.durability;
                SoundSystem.SOUND_ON_PANDA_EXPLOSION.play();
            }
        }
        if (obj.typeDinamicalObjects == 104) {
            this.collisionForce = force;
            if (this.collisionForce > 7.0f) {
                --this.durability;
                SoundSystem.SOUND_ON_PANDA_EXPLOSION.play();
            }
        }
        if (obj.typeDinamicalObjects == 102 && !(obj instanceof PandaMini)) {
            this.collisionForce = force;
            if (this.collisionForce > 21.0f) {
                this.durability = this.durability == 2 ? 0 : --this.durability;
                SoundSystem.SOUND_ON_PANDA_EXPLOSION.play();
            } else if (this.collisionForce > 8.0f) {
                --this.durability;
                SoundSystem.SOUND_ON_PANDA_EXPLOSION.play();
            }
        }
    }

    public void draw(Graphics g) {
        super.draw(g);
    }

    public void update(long dt) {
        super.update(dt);
        if (this.durability <= 0) {
            this.onDestroy = true;
        }
        if (this.onDestroy) {
            int centerX = Box2d.getCenterX(this.box2dId) * 100;
            SoundSystem.SOUND_ON_PANDA_EXPLOSION.play();
            this.explosionAbility();
            this.destroyObstacle();
            ++((LevelCompleteStat)GameParameters.currentScenario.level.get((int)GameParameters.currentLevelInt)).obstacles;
        } else {
            if (MyWorld.onPlay) {
                this.defaultFrame = this.nFrames - this.durability;
            }
            if (MyWorld.onLost) {
                // empty if block
            }
        }
    }

    public void explosionAbility() {
        float max = 0.0f;
        float x = Box2d.getCenterX(this.box2dId);
        float y = Box2d.getCenterY(this.box2dId);
        float imp = 30000.0f;
        for (int j = 0; j < MyWorld.physicalGameObjects.size(); ++j) {
            PhysicalGameObject body;
            if (MyWorld.physicalGameObjects.get(j) == this || (body = (PhysicalGameObject)MyWorld.physicalGameObjects.get(j)) == null || body.isStatic) continue;
            XBody body_box2dId = body.box2dId;
            float bx = Box2d.getCenterX(body_box2dId);
            float by = Box2d.getCenterY(body_box2dId);
            float dx = x - bx;
            float dy = y - by;
            float d = (float)Math.sqrt(dx * dx + dy * dy);
            if ((double)Math.abs(bx - x) < 1.0E-4) {
                bx += 1.0E-4f;
            }
            float k = (by - y) / (bx - x);
            float sinA = (float)Utils.atan(k);
            if (d < 1.0f) {
                d = 1.0f;
            }
            float bodyImp = 2.0f * imp;
            int force = 0;
            if (d > this.radiusExplode * 2.0f) {
                bodyImp = 0.9f * bodyImp;
                force = 31;
            }
            if (d > this.radiusExplode * 3.0f) {
                bodyImp = 0.8f * bodyImp;
                force = 31;
            }
            if (d > this.radiusExplode * 4.0f) {
                bodyImp = 0.6f * bodyImp;
                force = 21;
            }
            if (d > this.radiusExplode * 5.0f) {
                bodyImp = 0.4f * bodyImp;
                force = 12;
            }
            if (d > this.radiusExplode * 6.0f) {
                bodyImp = 0.2f * bodyImp;
                force = 7;
            }
            if (d > this.radiusExplode * 7.0f) {
                bodyImp = 0.1f * bodyImp;
                force = 3;
            }
            if (d > this.radiusExplode * 8.0f) {
                bodyImp = 0.0f;
                force = 0;
            }
            CollisionSystem.OnCollision(body_box2dId, body_box2dId, FXUtil.toFX(force * 100));
            int py = (int)(bodyImp * sinA);
            int px = (int)(bodyImp * (1.0f - sinA * sinA));
            if (x > bx) {
                px = -px;
            }
            if (y < by) {
                py = -py;
            }
            Box2d.applyImpulseToCenter(body_box2dId, px, py);
            if (!(bodyImp > max)) continue;
            max = bodyImp;
        }
        SpecialEffect.createPandaExplosion(this);
        SoundSystem.SOUND_ON_PANDA_EXPLOSION.play();
        Box2d.moveBodyOutside(this.box2dId);
        Box2d.setMass(this.box2dId, 0);
        Box2d.setVelocity(this.box2dId, 0, 0);
    }

    public static void createObstacle(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, String imageName, int angle) {
        ObstacleDynamite obj = new ObstacleDynamite();
        ArrayList shape = new ArrayList();
        obj.restitution = 1;
        obj.friction = 90;
        obj.isCrushable = true;
        obj.density = 15;
        obj.angle = angle;
        obj.imageName = imageName;
        obj.radiusExplode = ObstacleDynamite.radiusExplode(x1, y1, x3, y3);
        obj.isStatic = sstatic;
        shape.add(new Point(x1, y1));
        shape.add(new Point(x2, y2));
        shape.add(new Point(x3, y3));
        shape.add(new Point(x4, y4));
        obj.loadImage(imageName, shape);
        obj.setShape(shape, false, false);
        MyWorld.physicalGameObjects.add(obj);
        obj.mass = Box2d.getMass(obj.box2dId);
        obj.damage = obj.durability = obj.nFrames;
        obj.box2dId.setParent(obj);
    }

    public static float radiusExplode(int x1, int y1, int x2, int y2) {
        float dx = Math.abs(x1 - x2);
        float dy = Math.abs(x1 - x2);
        return (float)((double)0.3f * (0.5 * Math.sqrt(dx * dx + dy * dy) + (double)(dx * dy / (dx + dy))));
    }
}

