/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game;

import com.ximad.pvn.audio.SoundSystem;
import com.ximad.pvn.game.AppSettings;
import com.ximad.pvn.game.GameParameters;
import com.ximad.pvn.game.Hud;
import com.ximad.pvn.game.LevelCompleteStat;
import com.ximad.pvn.game.Scenario;
import com.ximad.pvn.game.XMLScenario;
import com.ximad.pvn.screens.HomeScreen;
import com.ximad.pvn.screens.OptionsScreen;
import com.ximad.pvn.screens.PauseScreen;
import com.ximad.pvn.screens.RateItDialog;

public class DataManager {
    private static AppSettings as;
    private static int currentMusicLevel;
    private static int prevMusicLevel;
    private static int currentEffectsLevel;
    private static int prevEffectsLevel;
    private static boolean isSoundEnabled;
    private XMLScenario xmlScenario;
    public static boolean isRated;

    public DataManager() {
        as = new AppSettings();
        as.init("PandasVsNinjas_112358132134");
        as.readInt(0);
        this.xmlScenario = new XMLScenario();
        DataManager.setCurrentMusicLvl(as.readInt(50));
        DataManager.setCurrentEffectsLvl(as.readInt(50));
        this.xmlScenario.loadFromXML();
        this.loadScenarios();
    }

    public void saveSettings() {
        as.writeInt(5);
        as.writeInt(currentMusicLevel);
        as.writeInt(currentEffectsLevel);
        this.saveScenarios();
        as.commit();
    }

    public void clearAllLevels() {
        this.xmlScenario.loadFromXML();
        GameParameters.countGoldMedals = 0;
        Scenario.recalculateMedals();
        Scenario.refreshScenarios();
    }

    private void loadScenarios() {
        LevelCompleteStat level;
        int j;
        Scenario scenario;
        int i;
        GameParameters.countGoldMedals = 0;
        for (i = 0; i < 6; ++i) {
            scenario = (Scenario)GameParameters.scenarios.get(i);
            scenario.load(as);
            for (j = 0; j < 25; ++j) {
                level = (LevelCompleteStat)scenario.level.get(j);
                level.load(as);
                GameParameters.countGoldMedals += level.medal;
            }
        }
        isRated = as.readBoolean(false);
        RateItDialog.show = !isRated;
        for (i = 0; i < 6; ++i) {
            scenario = (Scenario)GameParameters.scenarios.get(i);
            for (j = 25; j < 30; ++j) {
                level = (LevelCompleteStat)scenario.level.get(j);
                level.load(as);
                GameParameters.countGoldMedals += level.medal;
            }
        }
        if (((LevelCompleteStat)((Scenario)GameParameters.scenarios.get((int)4)).level.get((int)24)).isComplete) {
            ((Scenario)GameParameters.scenarios.get((int)5)).isOpen = true;
            ((LevelCompleteStat)((Scenario)GameParameters.scenarios.get((int)5)).level.get((int)0)).isOpen = true;
        }
        for (i = 0; i < GameParameters.scenarios.size(); ++i) {
            if (!((LevelCompleteStat)((Scenario)GameParameters.scenarios.get((int)i)).level.get((int)24)).isComplete) continue;
            ((LevelCompleteStat)((Scenario)GameParameters.scenarios.get((int)i)).level.get((int)25)).isOpen = true;
        }
        int m = as.readInt(GameParameters.countGoldMedals);
        if (m > GameParameters.countGoldMedals) {
            GameParameters.countGoldMedals = m;
        }
        Hud.init();
        for (int i2 = 0; i2 < 9; ++i2) {
            Hud.pandas[i2].setPandaType(as.readInt(0));
        }
        Scenario.recalculateMedals();
        Scenario.refreshScenarios();
    }

    public void saveScenarios() {
        int j;
        Scenario scenario;
        int i;
        for (i = 0; i < GameParameters.scenarios.size(); ++i) {
            scenario = (Scenario)GameParameters.scenarios.get(i);
            scenario.save(as);
            for (j = 0; j < 25; ++j) {
                ((LevelCompleteStat)scenario.level.get(j)).save(as);
            }
        }
        as.writeBoolean(isRated);
        for (i = 0; i < GameParameters.scenarios.size(); ++i) {
            scenario = (Scenario)GameParameters.scenarios.get(i);
            for (j = 25; j < scenario.level.size(); ++j) {
                ((LevelCompleteStat)scenario.level.get(j)).save(as);
            }
        }
        as.writeInt(GameParameters.countGoldMedals);
        for (i = 0; i < 9; ++i) {
            as.writeInt(Hud.pandas[i].getPandaType());
        }
    }

    public static boolean getSoundState() {
        return isSoundEnabled;
    }

    public static void changeSoundState() {
        if (isSoundEnabled) {
            prevMusicLevel = currentMusicLevel;
            prevEffectsLevel = currentEffectsLevel;
            DataManager.setCurrentMusicLvl(0);
            DataManager.setCurrentEffectsLvl(0);
        } else {
            DataManager.setCurrentMusicLvl(prevMusicLevel);
            DataManager.setCurrentEffectsLvl(prevEffectsLevel);
        }
        DataManager.onChangeVolume();
    }

    public static int getCurrentMusicLvl() {
        return currentMusicLevel;
    }

    public static void setCurrentMusicLvl(int lvl) {
        currentMusicLevel = lvl;
        if (lvl > 100) {
            currentMusicLevel = 100;
        }
        if (lvl < 0) {
            currentMusicLevel = 0;
        }
        isSoundEnabled = currentMusicLevel != 0 || currentEffectsLevel != 0;
        SoundSystem.mm.setVolume(currentMusicLevel);
        DataManager.onChangeVolume();
    }

    public static int getCurrentEffectsLvl() {
        return currentEffectsLevel;
    }

    public static void setCurrentEffectsLvl(int lvl) {
        currentEffectsLevel = lvl;
        if (lvl > 100) {
            currentEffectsLevel = 100;
        }
        if (lvl < 0) {
            currentEffectsLevel = 0;
        }
        isSoundEnabled = currentMusicLevel != 0 || currentEffectsLevel != 0;
        SoundSystem.sm.setVolume(currentEffectsLevel);
        DataManager.onChangeVolume();
    }

    private static void onChangeVolume() {
        HomeScreen.getInstance().onVolumeChange();
        OptionsScreen.getInstance().onVolumeChange();
        PauseScreen.getInstance().onVolumeChange();
    }

    static {
        currentMusicLevel = 0;
        prevMusicLevel = 10;
        currentEffectsLevel = 0;
        prevEffectsLevel = 10;
        isSoundEnabled = true;
    }
}

