/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXMatrix;
import at.emini.physics2D.util.FXVector;
import java.util.Vector;

public class Shape {
    protected FXVector[] corners;
    int[] a;
    int b = 0;
    private int k;
    int c;
    private int l;
    int d;
    long e = 0L;
    protected int elasticityFX = 0;
    protected int frictionFX = 1024;
    int f = 4096;
    long g = 0x1000000L;
    long h = 4096L;
    long i = 0x1000000L;
    int j = -1;
    protected UserData userData = null;
    protected FXVector centroid = new FXVector();
    public static final int MAX_MASS_FX = 0x1000001;

    public static Shape createRectangle(int n, int n2) {
        FXVector[] fXVectorArray = new FXVector[4];
        FXVector[] fXVectorArray2 = fXVectorArray;
        fXVectorArray[0] = new FXVector(-(n <<= 12) / 2, -(n2 <<= 12) / 2);
        fXVectorArray2[1] = new FXVector(-n / 2, n2 / 2);
        fXVectorArray2[2] = new FXVector(n / 2, n2 / 2);
        fXVectorArray2[3] = new FXVector(n / 2, -n2 / 2);
        Shape shape = new Shape(fXVectorArray2);
        return shape;
    }

    public static Shape createCircle(int n) {
        FXVector[] fXVectorArray = new FXVector[1];
        FXVector[] fXVectorArray2 = fXVectorArray;
        fXVectorArray[0] = new FXVector(0, n << 12);
        return new Shape(fXVectorArray2);
    }

    public static Shape createRegularPolygon(int n, int n2) {
        FXVector[] fXVectorArray = new FXVector[n2];
        FXVector fXVector = new FXVector(0, n << 12);
        for (int i = 0; i < n2; ++i) {
            long l = 105414356L * (long)((i << 1) + 1) / (long)(n2 << 1);
            FXMatrix fXMatrix = FXMatrix.createRotationMatrix((int)l);
            fXVectorArray[n2 - 1 - i] = fXMatrix.mult(fXVector);
        }
        Shape shape = new Shape(fXVectorArray);
        return shape;
    }

    public Shape(FXVector[] fXVectorArray) {
        if (fXVectorArray.length > 12) {
            return;
        }
        this.corners = fXVectorArray;
        this.updateInternals();
        this.setMass(1);
    }

    public Shape(Shape shape) {
        this.corners = new FXVector[shape.corners.length];
        System.arraycopy(shape.corners, 0, this.corners, 0, this.corners.length);
        this.setElasticityFX(shape.elasticityFX);
        this.setFrictionFX(shape.frictionFX);
        this.updateInternals();
        this.setMassFX(shape.f);
        if (shape.userData != null) {
            this.userData = shape.userData.copy();
        }
    }

    protected Shape() {
    }

    protected void updateInternals() {
        this.a();
        this.k = 0;
        for (int i = 0; i < this.corners.length; ++i) {
            FXVector fXVector = this.corners[i];
            int n = fXVector.lengthSquare();
            if (n <= this.k * this.k) continue;
            this.k = fXVector.lengthFX() >> 12;
        }
        this.c = this.k << 12;
        this.b();
        Shape shape = this;
        this.l = shape.d = shape.c << 1;
        for (int i = 0; i < shape.a.length && shape.a[i] >= 0; i += 2) {
            long l;
            FXVector fXVector = new FXVector(shape.corners[shape.a[i]]);
            fXVector.subtract(shape.corners[shape.a[i + 1]]);
            fXVector.normalize();
            long l2 = 0L;
            long l3 = l = (long)shape.corners[0].xFX * (long)fXVector.yFX - (long)shape.corners[0].yFX * (long)fXVector.xFX >> 12;
            for (int j = 1; j < shape.corners.length; ++j) {
                l2 = (long)shape.corners[j].xFX * (long)fXVector.yFX - (long)shape.corners[j].yFX * (long)fXVector.xFX >> 12;
                if (l2 < l3) {
                    l3 = l2;
                    continue;
                }
                if (l2 <= l) continue;
                l = l2;
            }
            if ((long)shape.d < l - l3) {
                shape.d = (int)(l - l3);
            }
            if ((long)shape.l <= l - l3) continue;
            shape.l = (int)(l - l3);
        }
    }

    public void correctCentroid() {
        if (this.corners.length < 3) {
            return;
        }
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        int n2 = this.corners.length - 1;
        while (n < this.corners.length) {
            long l3 = (long)this.corners[n].xFX * (long)this.corners[n2].yFX - (long)this.corners[n].yFX * (long)this.corners[n2].xFX >> 12;
            l += l3 * (long)(this.corners[n].xFX + this.corners[n2].xFX) >> 12;
            l2 += l3 * (long)(this.corners[n].yFX + this.corners[n2].yFX) >> 12;
            n2 = n++;
        }
        l = (l << 12) / (this.e * 6L);
        l2 = (l2 << 12) / (this.e * 6L);
        for (n = 0; n < this.corners.length; ++n) {
            this.corners[n].subtract(new FXVector((int)l, (int)l2));
        }
        this.updateInternals();
    }

    public FXVector[] getCorners() {
        return this.corners;
    }

    public int getBoundingRadiusSquare() {
        return this.k * this.k;
    }

    protected int getBoundingRadius() {
        return this.k;
    }

    public int getBoundingRadiusFX() {
        return this.c;
    }

    void a() {
        if (this.corners.length == 1) {
            this.a = new int[0];
            this.b = 0;
            return;
        }
        this.a = new int[this.corners.length << 1];
        Vector<FXVector> vector = new Vector<FXVector>();
        int n = 0;
        int n2 = this.corners.length - 1;
        while (n < this.corners.length) {
            FXVector fXVector = new FXVector(this.corners[n]);
            fXVector.subtract(this.corners[n2]);
            fXVector.normalize();
            boolean bl = true;
            for (int i = 0; i < vector.size(); ++i) {
                FXVector fXVector2 = (FXVector)vector.elementAt(i);
                if (Math.abs((long)fXVector.xFX * (long)fXVector2.xFX + (long)fXVector.yFX * (long)fXVector2.yFX >> 12) <= 4088L) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.a[vector.size() << 1] = n;
                this.a[(vector.size() << 1) + 1] = n2;
                vector.addElement(fXVector);
            }
            n2 = n++;
        }
        this.b = vector.size() << 1;
        for (n = vector.size() << 1; n < this.a.length; ++n) {
            this.a[n] = -1;
        }
    }

    public void setFriction(int n) {
        this.frictionFX = (n << 12) / 100;
    }

    public void setFrictionFX(int n) {
        this.frictionFX = n;
    }

    public int getFrictionFX() {
        return this.frictionFX;
    }

    public void setElasticity(int n) {
        this.elasticityFX = (n << 12) / 100;
    }

    public void setElasticityFX(int n) {
        this.elasticityFX = n;
    }

    public int getElasticityFX() {
        return this.elasticityFX;
    }

    public final void setMass(int n) {
        this.setMassFX(n << 12);
    }

    public final void setMassFX(int n) {
        if (this.e == 0L) {
            this.h = 0x1000001L;
            this.g = 0L;
            this.i = 0L;
            return;
        }
        this.f = n;
        this.g = 0x1000000000L / (long)n;
        this.b();
    }

    public int getMass() {
        return this.f >> 12;
    }

    public int getMassFX() {
        return this.f;
    }

    public int getId() {
        return this.j;
    }

    public long getAreaFX() {
        return this.e;
    }

    void b() {
        this.e = 0L;
        this.h = 0L;
        if (this.corners.length == 1) {
            this.e = 52707178L * (long)((int)((long)this.c * (long)this.c) >> 24) >> 12;
            this.h = (int)((long)(this.f / 2) * (long)this.c * (long)this.c >> 24);
        } else if (this.corners.length > 2) {
            for (int i = 0; i < this.corners.length; ++i) {
                FXVector fXVector = this.corners[i];
                FXVector fXVector2 = this.corners[i + 1 >= this.corners.length ? 0 : i + 1];
                long l = (long)fXVector2.xFX * (long)fXVector.yFX - (long)fXVector2.yFX * (long)fXVector.xFX >> 12;
                this.e += l / 2L;
                long l2 = fXVector.xFX;
                long l3 = fXVector.yFX;
                long l4 = fXVector2.xFX;
                long l5 = fXVector2.yFX;
                long l6 = (int)((l2 * l2 + l4 * l2 + l4 * l4) / 12L >> 12);
                long l7 = (int)((l3 * l3 + l5 * l3 + l5 * l5) / 12L >> 12);
                this.h += l * (l6 + l7) >> 12;
            }
            this.h = (this.h << 12) / this.e * (long)this.f >> 12;
        }
        if (this.e > 0L) {
            long l = 0L;
            long l8 = 0L;
            int n = 0;
            int n2 = this.corners.length - 1;
            while (n < this.corners.length) {
                long l9 = (long)this.corners[n].xFX * (long)this.corners[n2].yFX - (long)this.corners[n].yFX * (long)this.corners[n2].xFX >> 12;
                l += l9 * (long)(this.corners[n].xFX + this.corners[n2].xFX) >> 12;
                l8 += l9 * (long)(this.corners[n].yFX + this.corners[n2].yFX) >> 12;
                n2 = n++;
            }
            l = (l << 12) / (this.e * 6L);
            l8 = (l8 << 12) / (this.e * 6L);
            this.centroid.assignFX((int)l, (int)l8);
        } else {
            this.centroid.assignFX(0, 0);
        }
        this.h += (long)this.f * (long)this.centroid.lengthSquareFX() >> 12;
        if (this.h == 0L) {
            this.i = Integer.MAX_VALUE;
            return;
        }
        this.i = 0x1000000000L / this.h;
    }

    protected final void getVerticesFX(FXVector fXVector, FXMatrix fXMatrix, FXVector[] fXVectorArray) {
        if (fXVectorArray.length < this.corners.length) {
            return;
        }
        for (int i = 0; i < this.corners.length; ++i) {
            fXMatrix.mult(this.corners[i], fXVectorArray[i]);
            fXVectorArray[i].xFX += fXVector.xFX;
            fXVectorArray[i].yFX += fXVector.yFX;
        }
    }

    public UserData getUserData() {
        return this.userData;
    }

    public void setUserData(UserData userData) {
        this.userData = userData;
    }
}

