/*
 * Decompiled with CFR 0.152.
 */
package Jim.Engine;

import Jim.Engine.JCore;
import Jim.Engine.JTool;
import javax.microedition.lcdui.Graphics;

public class JWord2 {
    public int BKColor;
    public int CountTime;
    public int FontColor;
    public int FontSize;
    public int PosX;
    public int PosY;
    public static final byte SCROLL_ANM = 0;
    public static final byte SCROLL_LEFT = 2;
    public static final byte SCROLL_NULL = -1;
    public static final byte SCROLL_RIGHT = 3;
    public static final byte SCROLL_SAY = 1;
    public int ScrollBarColor;
    public int ScrollBoxColor;
    public int column;
    public boolean delFirstChar;
    public int delayTime = 100;
    public boolean end;
    public int height;
    public int index;
    public boolean loop;
    public boolean mask;
    public int maxWordIndex;
    public int maxWordLength;
    public int pageIndex;
    public boolean playOk;
    public int row;
    public int scrollBoxHeight = 5;
    public int scrollBoxWidth = 5;
    public int scrollHeight;
    public int scrollPosX;
    public int scrollPosY;
    public int scrollStep;
    public int scrollType;
    public int scrollWidth;
    public int space;
    public int totalWordLength;
    public boolean update;
    public int width;
    public String word;
    public int wordIndex;

    public void Init(String str, int x, int y, int width, int height, int FontSize, boolean mask, int scroll, boolean del) {
        if (x == -1000) {
            x = (JCore.GameScreenWidth - width) / 2;
        }
        if (y == -1000) {
            y = (JCore.GameScreenHeight - height) / 2;
        }
        this.setPos(x, y);
        this.CountTime = 0;
        this.delFirstChar = del;
        this.update = true;
        this.index = 0;
        this.column = -1;
        this.row = -1;
        this.word = str;
        this.delayTime = 0;
        this.wordIndex = 0;
        this.playOk = false;
        this.loop = false;
        this.totalWordLength = this.word.length();
        this.mask = mask;
        this.scrollType = scroll;
        FontSize = mask ? (FontSize += 3) : ++FontSize;
        this.set(width, height, FontSize);
        this.pageIndex = 0;
        this.BKColor = 16734720;
        this.FontColor = 0xFFFFFF;
        this.ScrollBarColor = 0x525050;
        this.ScrollBoxColor = 0xFFFF00;
    }

    public void brew() {
        this.update = true;
        if (--this.index < 0) {
            this.index = 0;
        }
    }

    public void checkTotalWordLength() {
        int count = 0;
        String temp = "";
        boolean start = true;
        int i = 0;
        while (i < this.totalWordLength) {
            char string = this.word.charAt(i);
            if (!this.delFirstChar || i != 0) {
                if (string != '\n') {
                    temp = temp + string;
                    ++count;
                } else {
                    int space = this.row - count % this.row;
                    int j = 0;
                    while (j < space) {
                        temp = temp + '\u3000';
                        ++j;
                    }
                    count += space;
                }
            }
            ++i;
        }
        this.word = temp;
        this.totalWordLength = this.word.length();
    }

    public boolean delayCount(long time) {
        if ((long)(this.CountTime += JCore.FpsTime) >= time) {
            this.CountTime = 0;
            return true;
        }
        return false;
    }

    public boolean draw(Graphics g, boolean back, boolean always_update) {
        int tempScrollPosY = 0;
        if (!always_update && !this.update) {
            return false;
        }
        if (back) {
            g.setColor(this.BKColor);
            JTool.fillRect(g, this.PosX, this.PosY, this.width, this.height);
            JTool.drawRect(g, this.PosX, this.PosY, this.width - 1, this.height - 1);
        }
        if (this.scrollType >= 2) {
            if (this.maxWordIndex > 1) {
                tempScrollPosY = this.index == this.maxWordIndex - 1 ? this.PosY + this.scrollHeight - this.scrollBoxHeight : (this.index >= 1 ? this.scrollPosY + this.index * this.scrollStep - this.scrollBoxHeight : this.scrollPosY);
                g.setColor(this.ScrollBarColor);
                JTool.fillRect(g, this.scrollPosX, this.scrollPosY, this.scrollBoxWidth, this.scrollHeight);
                g.setColor(this.ScrollBoxColor);
                JTool.fillRect(g, this.scrollPosX, tempScrollPosY, this.scrollBoxWidth, this.scrollBoxHeight);
            }
        } else if (this.scrollType == 0) {
            if (this.maxWordIndex <= 1) {
                if (this.delayCount(1000L)) {
                    this.playOk = true;
                }
            } else if (this.delayCount(500L) && ++this.index >= this.maxWordIndex) {
                if (this.loop) {
                    this.index = 0;
                } else {
                    this.index = this.maxWordIndex - 1;
                    this.playOk = true;
                }
            }
        } else if (this.scrollType == 1) {
            if (this.playOk) {
                if (this.loop && this.delayCount(2000L)) {
                    this.playOk = false;
                    this.wordIndex = 0;
                }
            } else if (this.delayCount(100L) && this.wordIndex++ >= this.totalWordLength) {
                this.playOk = true;
                this.wordIndex = this.totalWordLength - 1;
            }
        }
        this.drawPage(g, this.index, this.mask);
        this.update = false;
        return this.playOk;
    }

    public void drawPage(Graphics g, int page, boolean outline) {
        char string = '0';
        if (this.scrollType == 1) {
            int searchIndex = this.wordIndex / this.maxWordLength;
            int nowIndex = this.wordIndex % this.maxWordLength + 1;
            int nexpage = searchIndex * this.maxWordLength;
            int i = 0;
            while (i < nowIndex) {
                if (i + nexpage >= this.totalWordLength) break;
                string = this.word.charAt(i + nexpage);
                JTool.drawString(g, String.valueOf(string), this.PosX + this.space + i % this.row * this.FontSize, this.PosY + i / this.row * this.FontSize);
                ++i;
            }
            return;
        }
        int i = 0;
        while (i < this.maxWordLength) {
            if (page * this.maxWordLength + i >= this.word.length()) {
                return;
            }
            string = this.word.charAt(this.index * this.maxWordLength + i);
            if (outline) {
                JTool.drawString(g, String.valueOf(string), this.PosX + this.space + i % this.row * this.FontSize, this.PosY + i / this.row * this.FontSize, 0, 0xFFFFFF, (byte)0);
            } else {
                JTool.drawString(g, String.valueOf(string), this.PosX + this.space + i % this.row * this.FontSize, this.PosY + i / this.row * this.FontSize, this.FontColor, this.FontColor, (byte)-1);
            }
            ++i;
        }
    }

    public void next() {
        this.end = false;
        this.update = true;
        if (++this.index >= this.maxWordIndex) {
            this.end = true;
            this.index = 0;
        }
    }

    public void reset() {
        this.update = true;
        this.wordIndex = 0;
        this.playOk = false;
    }

    public void set(int width, int height, int FontSize) {
        this.width = width;
        this.column = height / FontSize;
        if (this.column == 0) {
            this.column = 1;
        }
        if ((this.row = this.width / FontSize) == 0) {
            this.row = 1;
        }
        this.maxWordLength = this.column * this.row;
        this.space = (width - this.row * FontSize) / 2;
        this.FontSize = FontSize;
        this.checkTotalWordLength();
        this.maxWordIndex = this.totalWordLength / this.maxWordLength;
        if (this.totalWordLength % this.maxWordLength > 0) {
            ++this.maxWordIndex;
        }
        if (this.maxWordIndex > 1) {
            this.maxWordIndex = 0;
            this.width -= this.scrollBoxWidth;
            this.column = height / FontSize;
            if (this.column == 0) {
                this.column = 1;
            }
            if ((this.row = this.width / FontSize) == 0) {
                this.row = 1;
            }
            this.maxWordLength = this.column * this.row;
            this.space = (width - this.row * FontSize) / 2;
            this.FontSize = FontSize;
            this.checkTotalWordLength();
            this.maxWordIndex = this.totalWordLength / this.maxWordLength;
            if (this.totalWordLength % this.maxWordLength > 0) {
                ++this.maxWordIndex;
            }
        }
        this.height = height;
        if (this.scrollType == 2) {
            this.scrollPosX = this.PosX;
            this.PosX += this.scrollBoxWidth;
        } else {
            this.scrollPosX = this.PosX + this.width;
        }
        this.scrollPosY = this.PosY;
        this.scrollHeight = height;
        this.scrollStep = this.maxWordIndex >= 2 ? this.scrollHeight / (this.maxWordIndex - 1) : this.scrollHeight / this.maxWordIndex;
    }

    public void setColor(int bkColor, int fontColor, int scrollBarColor, int scrollBoxColor) {
        this.BKColor = bkColor;
        this.FontColor = fontColor;
        this.ScrollBarColor = scrollBarColor;
        this.ScrollBoxColor = scrollBoxColor;
    }

    public void setFrameDelay(int time) {
        this.CountTime = 0;
        this.delayTime = time;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public void setPos(int x, int y) {
        this.PosX = x;
        this.PosY = y;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }
}

